SET session wait_timeout=28800;

DROP TABLE IF EXISTS #__akeeba_common;
CREATE TABLE `#__akeeba_common` (
  `key` varchar(255) NOT NULL,
  `value` longtext NOT NULL,
  PRIMARY KEY (`key`)
) DEFAULT CHARSET=utf8;

INSERT INTO `#__akeeba_common` VALUES 
('stats_lastrun','1430993333'),
('stats_siteid','5c717c8aeae0b127daafa458213a5386e4feee5e'),
('stats_siteurl','cfdc35254f4cdc52b8e4e5ee219c59ab');

DROP TABLE IF EXISTS #__assets;
CREATE TABLE `#__assets` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `parent_id` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set parent.',
  `lft` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set lft.',
  `rgt` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set rgt.',
  `level` int(10) unsigned NOT NULL COMMENT 'The cached level in the nested tree.',
  `name` varchar(50) NOT NULL COMMENT 'The unique name for the asset.\n',
  `title` varchar(100) NOT NULL COMMENT 'The descriptive title for the asset.',
  `rules` varchar(5120) NOT NULL COMMENT 'JSON encoded access control.',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_asset_name` (`name`),
  KEY `idx_lft_rgt` (`lft`,`rgt`),
  KEY `idx_parent_id` (`parent_id`)
) AUTO_INCREMENT=421 DEFAULT CHARSET=utf8;

INSERT INTO `#__assets` VALUES 
('1','0','1','450','0','root.1','Root Asset','{"core.login.site":{"6":1,"2":1},"core.login.admin":{"6":1},"core.login.offline":[],"core.admin":{"8":1},"core.manage":{"7":1},"core.create":{"6":1,"3":1},"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
('2','1','2','3','1','com_admin','com_admin','{}'),
('3','1','4','7','1','com_banners','com_banners','{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
('4','1','8','9','1','com_cache','com_cache','{"core.admin":{"7":1},"core.manage":{"7":1}}'),
('5','1','10','11','1','com_checkin','com_checkin','{"core.admin":{"7":1},"core.manage":{"7":1}}'),
('6','1','12','13','1','com_config','com_config','{}'),
('7','1','14','21','1','com_contact','com_contact','{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[],"core.edit.own":[]}'),
('8','1','22','119','1','com_content','com_content','{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
('9','1','120','121','1','com_cpanel','com_cpanel','{}'),
('10','1','122','123','1','com_installer','com_installer','{"core.admin":[],"core.manage":{"7":0},"core.delete":{"7":0},"core.edit.state":{"7":0}}'),
('11','1','124','125','1','com_languages','com_languages','{"core.admin":{"7":1},"core.manage":[],"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
('12','1','126','127','1','com_login','com_login','{}'),
('13','1','128','129','1','com_mailto','com_mailto','{}'),
('14','1','130','131','1','com_massmail','com_massmail','{}'),
('15','1','132','133','1','com_media','com_media','{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":{"3":1},"core.delete":{"5":1},"core.edit":[],"core.edit.state":[]}'),
('16','1','134','135','1','com_menus','com_menus','{"core.admin":{"7":1},"core.manage":[],"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
('18','1','138','327','1','com_modules','com_modules','{"core.admin":{"7":1},"core.manage":[],"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
('19','1','328','331','1','com_newsfeeds','com_newsfeeds','{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
('20','1','332','333','1','com_plugins','com_plugins','{"core.admin":{"7":1},"core.manage":[],"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
('21','1','334','335','1','com_redirect','com_redirect','{"core.admin":{"7":1},"core.manage":[]}'),
('22','1','336','337','1','com_search','com_search','{"core.admin":{"7":1},"core.manage":{"6":1}}'),
('23','1','338','339','1','com_templates','com_templates','{"core.admin":{"7":1},"core.manage":[],"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
('24','1','340','343','1','com_users','com_users','{"core.admin":{"7":1},"core.manage":[],"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
('25','1','344','351','1','com_weblinks','com_weblinks','{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":{"3":1,"10":0,"12":0},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1}}'),
('26','1','352','353','1','com_wrapper','com_wrapper','{}'),
('33','1','414','415','1','com_finder','com_finder','{"core.admin":{"7":1},"core.manage":{"6":1}}'),
('41','7','19','20','2','com_contact.category.16','Sample Data-Contact','{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
('100','8','41','42','2','com_content.category.71','Milky Way','{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
('169','24','341','342','2','com_users.category.77','Uncategorised',''),
('173','1','416','417','1','com_joomlaupdate','com_joomlaupdate','{"core.admin":[],"core.manage":[],"core.delete":[],"core.edit.state":[]}'),
('174','205','50','51','3','com_content.article.71','Typography','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('178','1','418','419','1','com_djmediatools','com_djmediatools','{"core.admin":[],"core.manage":[],"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
('197','1','420','421','1','com_tags','com_tags','{}'),
('198','1','422','423','1','com_contenthistory','com_contenthistory','{}'),
('199','1','424','425','1','com_ajax','com_ajax','{}'),
('200','1','426','427','1','com_postinstall','com_postinstall','{}'),
('202','18','139','140','2','com_modules.module.141','DJ-MegaMenu','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
('203','18','141','142','2','com_modules.module.103','Content-top','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('204','18','143','144','2','com_modules.module.104','Content-Bottom','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('205','8','45','66','2','com_content.category.82','JM-Sample-Data','{"core.create":{"6":1,"3":1},"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
('206','205','48','49','3','com_content.article.84','All Template\'s Positions','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('207','205','46','47','3','com_content.article.85','Module Suffixes','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('208','18','145','146','2','com_modules.module.91','Top','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('209','18','147','148','2','com_modules.module.92','Top','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('210','18','149','150','2','com_modules.module.93','Top','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('211','18','151','152','2','com_modules.module.94','Top','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('226','18','153','154','2','com_modules.module.167','Bottom','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('227','18','155','156','2','com_modules.module.168','Bottom','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('228','18','157','158','2','com_modules.module.169','Bottom','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('229','18','159','160','2','com_modules.module.170','Bottom','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}');
INSERT INTO `#__assets` VALUES 
('230','18','161','162','2','com_modules.module.109','Footer','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('231','18','163','164','2','com_modules.module.110','Footer','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('232','18','165','166','2','com_modules.module.111','Footer','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('233','18','167','168','2','com_modules.module.112','Header','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('235','18','169','170','2','com_modules.module.194','Offer','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('236','18','171','172','2','com_modules.module.195','Information','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('237','18','173','174','2','com_modules.module.95','Left-column','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('238','18','175','176','2','com_modules.module.96','Left-column','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('239','18','177','178','2','com_modules.module.152','Left-column','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('240','18','179','180','2','com_modules.module.97','Left-column','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('241','18','181','182','2','com_modules.module.98','Right-column','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('242','18','183','184','2','com_modules.module.99','Right-column','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('243','18','185','186','2','com_modules.module.100','Right-column','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('244','18','187','188','2','com_modules.module.153','Right-column','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('246','18','189','190','2','com_modules.module.207','Most Popular','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('247','18','191','192','2','com_modules.module.206','Search','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('248','18','193','194','2','com_modules.module.211',' Search Front inputbox ','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('251','8','67','84','2','com_content.category.83','JM-Sample-Blog','{"core.create":{"6":1,"3":1},"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
('252','205','52','53','3','com_content.article.86','Content Area','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('253','205','54','55','3','com_content.article.87','Single Article','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('254','205','56','57','3','com_content.article.88','Tabs / Accordion in article','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('255','251','68','69','3','com_content.article.89','Blog Article 1','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('256','251','70','71','3','com_content.article.90','Blog Article 2','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('257','251','72','73','3','com_content.article.91','Blog Article 3','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('258','251','74','75','3','com_content.article.92','Blog Article 4','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('259','251','76','77','3','com_content.article.93','Blog Article 5','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('260','251','78','79','3','com_content.article.94','Blog Article 6','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('261','251','80','81','3','com_content.article.95','Blog Article 7','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('262','251','82','83','3','com_content.article.96','Leading Article','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('263','18','195','196','2','com_modules.module.202','Categories','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('265','18','197','198','2','com_modules.module.148','Promotion','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
('267','18','199','200','2','com_modules.module.212','Layouts','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('269','18','201','202','2','com_modules.module.214','J! Content','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('270','18','203','204','2','com_modules.module.215','J! Content','{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
('271','18','205','206','2','com_modules.module.216','J! Other pages','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('272','18','207','208','2','com_modules.module.217','J! Other pages','{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
('273','18','209','210','2','com_modules.module.218','Search Component','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('274','18','211','212','2','com_modules.module.219','Search Component','{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
('275','18','213','214','2','com_modules.module.220','Contact Component','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('276','18','215','216','2','com_modules.module.221','Contact Component','{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
('277','18','217','218','2','com_modules.module.222','DJ-MediaTools','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('278','18','219','220','2','com_modules.module.223','DJ-MediaTools','{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
('282','18','221','222','2','com_modules.module.227','User Menu','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('287','18','223','224','2','com_modules.module.192','Social','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('289','18','225','226','2','com_modules.module.231','Footer','{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
('291','18','227','228','2','com_modules.module.233','Header 4','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
('292','18','229','230','2','com_modules.module.114','Copyrights','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('294','1','428','429','1','com_djtabs','com_djtabs','{"core.admin":[],"core.manage":[],"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
('295','8','85','94','2','com_content.category.84','Tab articles','{"core.create":{"6":1,"3":1},"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
('296','295','86','87','3','com_content.article.97','Steam cleaning','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}');
INSERT INTO `#__assets` VALUES 
('297','295','88','89','3','com_content.article.98','Carpet cleanin','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('298','295','90','91','3','com_content.article.99','Window cleaning','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('300','8','95','96','2','com_content.category.85','Opening Hours','{"core.create":{"6":1,"3":1},"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
('306','18','231','232','2','com_modules.module.238','Contact Details','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
('309','8','97','108','2','com_content.category.86','Header articles','{"core.create":{"6":1,"3":1},"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
('310','309','98','99','3','com_content.article.103','You work enough already!','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('311','18','233','234','2','com_modules.module.241','Other articles','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('312','309','100','101','3','com_content.article.104','Treat yourself to a clean healthy home','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('313','18','235','236','2','com_modules.module.242','Trust & Security','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
('317','18','237','238','2','com_modules.module.244','Articles Tabs','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
('321','18','239','240','2','com_modules.module.245','Our Videos','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('322','309','102','103','3','com_content.article.109','Enjoy your time off','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('323','18','241','242','2','com_modules.module.181','Logout','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
('324','18','243','244','2','com_modules.module.176','Top-bar Guest','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('325','18','245','246','2','com_modules.module.246','Search','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
('326','18','247','248','2','com_modules.module.247','Our services','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('327','18','249','250','2','com_modules.module.248','DJ-Tabs','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('328','18','251','252','2','com_modules.module.249','DJ-Tabs','{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
('332','18','253','254','2','com_modules.module.253','Contact Map','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('333','18','255','256','2','com_modules.module.254','Contact Info','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('334','205','58','59','3','com_content.article.110','Pricing Table','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('342','18','257','258','2','com_modules.module.260','Latest News','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('343','309','104','105','3','com_content.article.113','You deserve a break!','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('345','18','259','260','2','com_modules.module.261','RSFirewall! Control Panel Module',''),
('347','18','261','262','2','com_modules.module.263','Offcanvas Button','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
('348','18','263','264','2','com_modules.module.264','Offcanvas Info','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('349','18','265','266','2','com_modules.module.265','Main Menu','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('350','18','267','268','2','com_modules.module.266','Our site is coming soon','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('353','18','269','270','2','com_modules.module.268','Domestic Cleaning','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
('359','18','271','272','2','com_modules.module.274','Articles Accordion Front','{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
('360','8','109','118','2','com_content.category.88','Articles','{"core.create":{"6":1,"3":1},"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
('361','295','92','93','3','com_content.article.114','Spring cleaning','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('362','360','110','111','3','com_content.article.115','Support at every stage of homeownership','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('363','360','112','113','3','com_content.article.116','Guard against fraud','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('364','360','114','115','3','com_content.article.117','Make saving money simpler','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('365','360','116','117','3','com_content.article.118','Make no payments while you\'re in school','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('366','18','273','274','2','com_modules.module.275','Custom pages','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('367','205','60','61','3','com_content.article.119','Coming Soon','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('368','205','62','63','3','com_content.article.120','Frequently Asked Questions','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('370','205','64','65','3','com_content.article.121','Error 404','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('379','18','275','276','2','com_modules.module.279','Home views','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('380','18','277','278','2','com_modules.module.52','Breadcrumbs','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('381','18','279','280','2','com_modules.module.280','Header 1','{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
('382','18','281','282','2','com_modules.module.281','Header 3','{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
('383','18','283','284','2','com_modules.module.282','Header 2','{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
('384','18','285','286','2','com_modules.module.283','Example module','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('385','18','287','288','2','com_modules.module.284','Custom boxes - Front','{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
('386','18','289','290','2','com_modules.module.285','Promo Offcanvas','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
('387','18','291','292','2','com_modules.module.286','Tags','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('388','1','430','431','1','#__ucm_content.3','#__ucm_content.3','[]');
INSERT INTO `#__assets` VALUES 
('389','1','432','433','1','#__ucm_content.4','#__ucm_content.4','[]'),
('390','1','434','435','1','#__ucm_content.5','#__ucm_content.5','[]'),
('391','1','436','437','1','#__ucm_content.6','#__ucm_content.6','[]'),
('396','1','438','439','1','#__ucm_content.11','#__ucm_content.11','[]'),
('397','1','440','441','1','#__ucm_content.12','#__ucm_content.12','[]'),
('398','1','442','443','1','#__ucm_content.13','#__ucm_content.13','[]'),
('399','18','293','294','2','com_modules.module.287','Banner','{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
('400','18','295','296','2','com_modules.module.288','Office Cleaning','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
('401','18','297','298','2','com_modules.module.289','Ironing Services','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
('402','18','299','300','2','com_modules.module.290','End of tenancy cleaning','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
('403','18','301','302','2','com_modules.module.291','Spring cleaning','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
('404','18','303','304','2','com_modules.module.292','Window cleaning','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
('405','18','305','306','2','com_modules.module.293','Carpet cleaning','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
('406','18','307','308','2','com_modules.module.294','Steam cleaning','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
('407','18','309','310','2','com_modules.module.295','Guarantee','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
('408','18','311','312','2','com_modules.module.296','WE WORK FOR','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
('410','309','106','107','3','com_content.article.122','Dream to live clean?','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
('411','1','444','445','1','#__ucm_content.14','#__ucm_content.14','[]'),
('412','18','313','314','2','com_modules.module.297','Make an appointment','{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
('413','18','315','316','2','com_modules.module.298','Send us a message','{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
('414','18','317','318','2','com_modules.module.299','Visit us','{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
('415','18','319','320','2','com_modules.module.300','Template styles','{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
('416','18','321','322','2','com_modules.module.301','DJ-MegaMenu - Mobile Menu Button',''),
('417','18','323','324','2','com_modules.module.302','Search (2)','{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
('418','18','325','326','2','com_modules.module.303','Topbar Logout','{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
('419','1','446','447','1','com_fields','com_fields','{}'),
('420','1','448','449','1','com_associations','com_associations','{}');

DROP TABLE IF EXISTS #__associations;
CREATE TABLE `#__associations` (
  `id` int(11) NOT NULL COMMENT 'A reference to the associated item.',
  `context` varchar(50) NOT NULL COMMENT 'The context of the associated item.',
  `key` char(32) NOT NULL COMMENT 'The key for the association computed from an md5 on associated ids.',
  PRIMARY KEY (`context`,`id`),
  KEY `idx_key` (`key`)
) DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS #__banner_clients;
CREATE TABLE `#__banner_clients` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `contact` varchar(255) NOT NULL DEFAULT '',
  `email` varchar(255) NOT NULL DEFAULT '',
  `extrainfo` mediumtext NOT NULL,
  `state` tinyint(3) NOT NULL DEFAULT '0',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `metakey` mediumtext NOT NULL,
  `own_prefix` tinyint(4) NOT NULL DEFAULT '0',
  `metakey_prefix` varchar(255) NOT NULL DEFAULT '',
  `purchase_type` tinyint(4) NOT NULL DEFAULT '-1',
  `track_clicks` tinyint(4) NOT NULL DEFAULT '-1',
  `track_impressions` tinyint(4) NOT NULL DEFAULT '-1',
  PRIMARY KEY (`id`),
  KEY `idx_own_prefix` (`own_prefix`),
  KEY `idx_metakey_prefix` (`metakey_prefix`(100))
) DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS #__banner_tracks;
CREATE TABLE `#__banner_tracks` (
  `track_date` datetime NOT NULL,
  `track_type` int(10) unsigned NOT NULL,
  `banner_id` int(10) unsigned NOT NULL,
  `count` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`track_date`,`track_type`,`banner_id`),
  KEY `idx_track_date` (`track_date`),
  KEY `idx_track_type` (`track_type`),
  KEY `idx_banner_id` (`banner_id`)
) DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS #__banners;
CREATE TABLE `#__banners` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cid` int(11) NOT NULL DEFAULT '0',
  `type` int(11) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `alias` varchar(400) NOT NULL DEFAULT '',
  `imptotal` int(11) NOT NULL DEFAULT '0',
  `impmade` int(11) NOT NULL DEFAULT '0',
  `clicks` int(11) NOT NULL DEFAULT '0',
  `clickurl` varchar(200) NOT NULL DEFAULT '',
  `state` tinyint(3) NOT NULL DEFAULT '0',
  `catid` int(10) unsigned NOT NULL DEFAULT '0',
  `description` mediumtext NOT NULL,
  `custombannercode` varchar(2048) NOT NULL,
  `sticky` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `metakey` mediumtext NOT NULL,
  `params` mediumtext NOT NULL,
  `own_prefix` tinyint(1) NOT NULL DEFAULT '0',
  `metakey_prefix` varchar(400) NOT NULL DEFAULT '',
  `purchase_type` tinyint(4) NOT NULL DEFAULT '-1',
  `track_clicks` tinyint(4) NOT NULL DEFAULT '-1',
  `track_impressions` tinyint(4) NOT NULL DEFAULT '-1',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `reset` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `language` char(7) NOT NULL DEFAULT '',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT '0',
  `version` int(10) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `idx_state` (`state`),
  KEY `idx_own_prefix` (`own_prefix`),
  KEY `idx_banner_catid` (`catid`),
  KEY `idx_language` (`language`),
  KEY `idx_metakey_prefix` (`metakey_prefix`(100))
) DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS #__categories;
CREATE TABLE `#__categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0',
  `lft` int(11) NOT NULL DEFAULT '0',
  `rgt` int(11) NOT NULL DEFAULT '0',
  `level` int(10) unsigned NOT NULL DEFAULT '0',
  `path` varchar(400) NOT NULL DEFAULT '',
  `extension` varchar(50) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `alias` varchar(400) NOT NULL DEFAULT '',
  `note` varchar(255) NOT NULL DEFAULT '',
  `description` mediumtext NOT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(11) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access` int(10) unsigned NOT NULL DEFAULT '0',
  `params` text NOT NULL,
  `metadesc` varchar(1024) NOT NULL DEFAULT '' COMMENT 'The meta description for the page.',
  `metakey` varchar(1024) NOT NULL DEFAULT '' COMMENT 'The meta keywords for the page.',
  `metadata` varchar(2048) NOT NULL DEFAULT '' COMMENT 'JSON encoded metadata properties.',
  `created_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `created_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `modified_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `hits` int(10) unsigned NOT NULL DEFAULT '0',
  `language` char(7) NOT NULL DEFAULT '',
  `version` int(10) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `cat_idx` (`extension`,`published`,`access`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_left_right` (`lft`,`rgt`),
  KEY `idx_language` (`language`),
  KEY `idx_path` (`path`(100)),
  KEY `idx_alias` (`alias`(100))
) AUTO_INCREMENT=89 DEFAULT CHARSET=utf8;

INSERT INTO `#__categories` VALUES 
('1','0','0','0','17','0','','system','ROOT','root','','','1','0','0000-00-00 00:00:00','1','{}','','','','499','2011-01-01 00:00:01','0','0000-00-00 00:00:00','0','*','1'),
('16','41','1','1','2','1','sample-data-contact','com_contact','Sample Data-Contact','sample-data-contact','','','1','0','0000-00-00 00:00:00','1','{"target":"","image":""}','','','{"page_title":"","author":"","robots":""}','499','2011-01-01 00:00:01','0','0000-00-00 00:00:00','0','*','1'),
('77','169','1','7','8','1','uncategorised','com_users','Uncategorised','uncategorised','','','1','0','0000-00-00 00:00:00','1','{"target":"","image":""}','','','{"page_title":"","author":"","robots":""}','499','2011-01-01 00:00:01','0','0000-00-00 00:00:00','0','*','1'),
('82','205','1','3','4','1','jm-sample-data','com_content','JM-Sample-Data','jm-sample-data','','','1','0','0000-00-00 00:00:00','1','{"category_layout":"","image":""}','','','{"author":"","robots":""}','499','2013-11-19 09:36:51','152','2014-02-12 12:56:17','0','*','1'),
('83','251','1','5','6','1','jm-sample-blog','com_content','JM-Sample-Blog','jm-sample-blog','','','1','0','0000-00-00 00:00:00','1','{"category_layout":"","image":""}','','','{"author":"","robots":""}','499','2014-02-12 13:02:22','0','0000-00-00 00:00:00','0','*','1'),
('84','295','1','11','12','1','tab-articles','com_content','Tab articles','tab-articles','','','1','0','0000-00-00 00:00:00','1','{"category_layout":"","image":"","image_alt":""}','','','{"author":"","robots":""}','499','2014-05-22 13:24:24','545','2015-05-06 11:41:30','0','*','1'),
('85','300','1','15','16','1','opening-hours','com_content','Opening Hours','opening-hours','','','-2','0','0000-00-00 00:00:00','1','{"category_layout":"","image":""}','','','{"author":"","robots":""}','499','2014-05-22 13:35:05','0','0000-00-00 00:00:00','0','*','1'),
('86','309','1','13','14','1','header-articles','com_content','Header articles','header-articles','','','1','0','0000-00-00 00:00:00','1','{"category_layout":"","image":"","image_alt":""}','','','{"author":"","robots":""}','499','2014-05-23 07:17:59','545','2015-05-06 11:41:16','0','*','1'),
('88','360','1','9','10','1','articles','com_content','Articles','articles','','','1','0','0000-00-00 00:00:00','1','{"category_layout":"","image":""}','','','{"author":"","robots":""}','499','2014-12-11 13:31:45','182','2014-12-12 14:00:26','0','*','1');

DROP TABLE IF EXISTS #__contact_details;
CREATE TABLE `#__contact_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `alias` varchar(400) NOT NULL,
  `con_position` varchar(255) DEFAULT NULL,
  `address` mediumtext,
  `suburb` varchar(100) DEFAULT NULL,
  `state` varchar(100) DEFAULT NULL,
  `country` varchar(100) DEFAULT NULL,
  `postcode` varchar(100) DEFAULT NULL,
  `telephone` varchar(255) DEFAULT NULL,
  `fax` varchar(255) DEFAULT NULL,
  `misc` longtext,
  `image` varchar(255) DEFAULT NULL,
  `email_to` varchar(255) DEFAULT NULL,
  `default_con` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `params` mediumtext NOT NULL,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `catid` int(11) NOT NULL DEFAULT '0',
  `access` int(10) unsigned NOT NULL DEFAULT '0',
  `mobile` varchar(255) NOT NULL DEFAULT '',
  `webpage` varchar(255) NOT NULL DEFAULT '',
  `sortname1` varchar(255) NOT NULL DEFAULT '',
  `sortname2` varchar(255) NOT NULL DEFAULT '',
  `sortname3` varchar(255) NOT NULL DEFAULT '',
  `language` varchar(7) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT '0',
  `metakey` mediumtext NOT NULL,
  `metadesc` mediumtext NOT NULL,
  `metadata` mediumtext NOT NULL,
  `featured` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Set if article is featured.',
  `xreference` varchar(50) NOT NULL DEFAULT '' COMMENT 'A reference to enable linkages to external data sets.',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `version` int(10) unsigned NOT NULL DEFAULT '1',
  `hits` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`published`),
  KEY `idx_catid` (`catid`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_featured_catid` (`featured`,`catid`),
  KEY `idx_language` (`language`),
  KEY `idx_xreference` (`xreference`)
) AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;

INSERT INTO `#__contact_details` VALUES 
('1','Single Contact','single-contact','','7 Green Lane','London','','UK','N211AA','+44 789 100 100','+44 789 300 300','<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nulla scelerisque magna et orci porttitor ullamcorper. Proin euismod pretium dolor non consectetur. Aliquam feugiat nunc ac justo hendrerit, non lobortis lacus condimentum. Duis id erat nunc. Nam eu aliquam velit. Donec pretium sed quam quis pulvinar. Fusce felis ante, pulvinar ac metus et, adipiscing consequat lectus. Integer quam nibh, varius nec lacus elementum, bibendum posuere ante. Mauris vehicula, nunc quis aliquet tincidunt, massa arcu eleifend velit, posuere gravida nisl mi et magna.</p>','images/logo.png','templates@joomla-monster.com','1','1','0','0000-00-00 00:00:00','1','{"show_contact_category":"hide","show_contact_list":"0","presentation_style":"plain","show_tags":"0","show_name":"0","show_position":"0","show_email":"0","show_street_address":"0","show_suburb":"0","show_state":"0","show_postcode":"0","show_country":"0","show_telephone":"0","show_mobile":"0","show_fax":"0","show_webpage":"0","show_misc":"0","show_image":"0","allow_vcard":"0","show_articles":"0","show_profile":"0","show_links":"0","linka_name":"Twitter","linka":"http:\\/\\/twitter.com\\/joomla","linkb_name":"YouTube","linkb":"http:\\/\\/www.youtube.com\\/user\\/joomla","linkc_name":"Facebook","linkc":"http:\\/\\/www.facebook.com\\/joomla","linkd_name":"FriendFeed","linkd":"http:\\/\\/friendfeed.com\\/joomla","linke_name":"Scribed","linke":"http:\\/\\/www.scribd.com\\/people\\/view\\/504592-joomla","contact_layout":"","show_email_form":"1","show_email_copy":"","banned_email":"","banned_subject":"","banned_text":"","validate_session":"","custom_reply":"","redirect":""}','0','16','1','+44 789 200 200','http://www.joomla-monster.com','last','first','middle','en-GB','2011-01-01 00:00:01','499','Joomla','2014-05-28 08:43:28','153','','','{"robots":"","rights":""}','1','','0000-00-00 00:00:00','0000-00-00 00:00:00','17','74'),
('9','Accordion','accordion','','','London','','UK','','','','<p>Nunc tincidunt eros ut mauris ullamcorper, vitae semper ligula convallis. Morbi tincidunt congue venenatis. Fusce at vestibulum nisl, et congue nisi. Vestibulum sollicitudin tellus id arcu vulputate, sit amet vestibulum est pulvinar. Duis vitae velit consequat, accumsan turpis non, scelerisque dui. Proin auctor sit amet enim non suscipit. Maecenas nec tristique elit. Cras dapibus nibh ac elit eleifend tristique. Morbi rutrum nulla lectus, sit amet tincidunt massa elementum quis.</p>','images/logo.png','info@joomla-monster.com','0','1','0','0000-00-00 00:00:00','2','{"show_contact_category":"","show_contact_list":"0","presentation_style":"sliders","show_tags":"","show_name":"","show_position":"","show_email":"","show_street_address":"","show_suburb":"","show_state":"","show_postcode":"","show_country":"","show_telephone":"","show_mobile":"","show_fax":"","show_webpage":"","show_misc":"","show_image":"","allow_vcard":"","show_articles":"","show_profile":"0","show_links":"0","linka_name":"","linka":false,"linkb_name":"","linkb":false,"linkc_name":"","linkc":false,"linkd_name":"","linkd":false,"linke_name":"","linke":"","contact_layout":"","show_email_form":"","show_email_copy":"","banned_email":"","banned_subject":"","banned_text":"","validate_session":"","custom_reply":"","redirect":""}','153','16','1','123 - 345 - 890','http://www.joomla-monster.com','','','','*','2014-05-29 09:16:27','499','','2014-12-12 10:16:18','182','','','{"robots":"","rights":""}','0','','0000-00-00 00:00:00','0000-00-00 00:00:00','6','40'),
('10','Tabs','tabs','','','London','','UK','','','','<p>Nunc tincidunt eros ut mauris ullamcorper, vitae semper ligula convallis. Morbi tincidunt congue venenatis. Fusce at vestibulum nisl, et congue nisi. Vestibulum sollicitudin tellus id arcu vulputate, sit amet vestibulum est pulvinar. Duis vitae velit consequat, accumsan turpis non, scelerisque dui. Proin auctor sit amet enim non suscipit. Maecenas nec tristique elit. Cras dapibus nibh ac elit eleifend tristique. Morbi rutrum nulla lectus, sit amet tincidunt massa elementum quis.</p>','images/logo.png','info@joomla-monster.com','0','1','0','0000-00-00 00:00:00','3','{"show_contact_category":"","show_contact_list":"0","presentation_style":"tabs","show_tags":"","show_name":"","show_position":"","show_email":"","show_street_address":"","show_suburb":"","show_state":"","show_postcode":"","show_country":"","show_telephone":"","show_mobile":"","show_fax":"","show_webpage":"","show_misc":"","show_image":"","allow_vcard":"","show_articles":"","show_profile":"0","show_links":"0","linka_name":"","linka":false,"linkb_name":"","linkb":false,"linkc_name":"","linkc":false,"linkd_name":"","linkd":false,"linke_name":"","linke":"","contact_layout":"","show_email_form":"","show_email_copy":"","banned_email":"","banned_subject":"","banned_text":"","validate_session":"","custom_reply":"","redirect":""}','153','16','1','123 - 345 - 890','http://www.joomla-monster.com','','','','*','2014-12-12 10:16:00','499','','2014-12-10 10:08:33','0','','','{"robots":"","rights":""}','0','','0000-00-00 00:00:00','0000-00-00 00:00:00','1','5');

DROP TABLE IF EXISTS #__content;
CREATE TABLE `#__content` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `title` varchar(255) NOT NULL DEFAULT '',
  `alias` varchar(400) NOT NULL DEFAULT '',
  `introtext` longtext NOT NULL,
  `fulltext` longtext NOT NULL,
  `state` tinyint(3) NOT NULL DEFAULT '0',
  `catid` int(10) unsigned NOT NULL DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `images` mediumtext NOT NULL,
  `urls` mediumtext NOT NULL,
  `attribs` varchar(5120) NOT NULL,
  `version` int(10) unsigned NOT NULL DEFAULT '1',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `metakey` mediumtext NOT NULL,
  `metadesc` mediumtext NOT NULL,
  `access` int(10) unsigned NOT NULL DEFAULT '0',
  `hits` int(10) unsigned NOT NULL DEFAULT '0',
  `metadata` mediumtext NOT NULL,
  `featured` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Set if article is featured.',
  `language` char(7) NOT NULL COMMENT 'The language code for the article.',
  `xreference` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`state`),
  KEY `idx_catid` (`catid`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_featured_catid` (`featured`,`catid`),
  KEY `idx_language` (`language`),
  KEY `idx_xreference` (`xreference`)
) AUTO_INCREMENT=123 DEFAULT CHARSET=utf8;

INSERT INTO `#__content` VALUES 
('71','174','Typography','typography','<h3 class="jm-typo-title">Animated hover CSS3 effects for images</h3>\r\n<p>This code allows you to display an image and its description with animated CSS3 effect.<br /><strong>Note:</strong> If you would like to add your own text into the image description, just modify the code below or edit an existing code in the custom module of the demo template.</p>\r\n<p> </p>\r\n<div class="clearfix">\r\n<div style="width: 49%; float: left;">\r\n<div>\r\n<p><strong>Example 1</strong></p>\r\n<div class="jm-code" style="min-height: 165px;">&lt;div class="ch-item ch-first" style="background: url(\'<strong>images/modules/animated.jpg</strong>\') no-repeat;"&gt; &lt;div class="ch-info"&gt; &lt;div class="ch-container"&gt; &lt;div class="ch-outer"&gt; &lt;div class="ch-inner"&gt; &lt;p&gt;&lt;a href="<strong>#link</strong>"&gt;<strong>CHECK OUR</strong>&lt;br /&gt;&lt;span class="smaller"&gt;<strong>NEW OFFER!</strong>&lt;/span&gt;&lt;/a&gt;&lt;/p&gt; &lt;/div&gt; &lt;/div&gt; &lt;/div&gt; &lt;/div&gt; &lt;/div&gt;</div>\r\n<p> </p>\r\n<div style="margin: 0 auto; width: 280px;">\r\n<div class="ch-item ch-first" style="background: url(\'images/modules/animated.jpg\') no-repeat;">\r\n<div class="ch-info">\r\n<div class="ch-container">\r\n<div class="ch-outer">\r\n<div class="ch-inner">\r\n<p><a href="#">CHECK OUR<br /><span class="smaller">NEW OFFER!</span></a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<p> </p>\r\n</div>\r\n<div style="width: 49%; float: right;">\r\n<div>\r\n<p><strong>Example 2</strong></p>\r\n<div class="jm-code" style="min-height: 165px;">&lt;div class="ch-item ch-second" style="background: url(\'<strong>images/modules/animated.jpg</strong>\') no-repeat;"&gt; &lt;div class="ch-info-wrap"&gt; &lt;div class="ch-info"&gt; &lt;div class="ch-info-front"&gt; &lt;/div&gt; &lt;div class="ch-info-back"&gt; &lt;div class="ch-container"&gt; &lt;div class="ch-outer"&gt; &lt;div class="ch-inner"&gt; &lt;p&gt;&lt;a href="<strong>#link</strong>"&gt;<strong>CHECK OUR</strong>&lt;br /&gt;&lt;span class="smaller"&gt;<strong>NEW OFFER!</strong>&lt;/span&gt;&lt;/a&gt;&lt;/p&gt; &lt;/div&gt; &lt;/div&gt; &lt;/div&gt; &lt;/div&gt; &lt;/div&gt; &lt;/div&gt; &lt;/div&gt;</div>\r\n<p> </p>\r\n<div style="margin: 0 auto; width: 280px;">\r\n<div class="ch-item ch-second" style="background: url(\'images/modules/animated.jpg\') no-repeat;">\r\n<div class="ch-info-wrap">\r\n<div class="ch-info">\r\n<div class="ch-info-front"> </div>\r\n<div class="ch-info-back">\r\n<div class="ch-container">\r\n<div class="ch-outer">\r\n<div class="ch-inner">\r\n<p><a href="#">CHECK OUR<br /><span class="smaller">NEW OFFER!</span></a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<p> </p>\r\n</div>\r\n<div style="width: 49%; float: left;">\r\n<div>\r\n<p><strong>Example 3</strong></p>\r\n<div class="jm-code" style="min-height: 165px;">&lt;div class="ch-item ch-third"&gt; &lt;div class="ch-info"&gt; &lt;div class="ch-info-front" style="background: url(\'<strong>images/modules/animated.jpg</strong>\') no-repeat;"&gt; &lt;/div&gt; &lt;div class="ch-info-back"&gt; &lt;div class="ch-container"&gt; &lt;div class="ch-outer"&gt; &lt;div class="ch-inner"&gt; &lt;p&gt;&lt;a href="<strong>#link</strong>"&gt;<strong>CHECK OUR</strong>&lt;br /&gt;&lt;span class="smaller"&gt;<strong>NEW OFFER!</strong>&lt;/span&gt;&lt;/a&gt;&lt;/p&gt; &lt;/div&gt; &lt;/div&gt; &lt;/div&gt; &lt;/div&gt; &lt;/div&gt; &lt;/div&gt;</div>\r\n<p> </p>\r\n<div style="margin: 0 auto; width: 280px;">\r\n<div class="ch-item ch-third">\r\n<div class="ch-info">\r\n<div class="ch-info-front" style="background: url(\'images/modules/animated.jpg\') no-repeat;"> </div>\r\n<div class="ch-info-back">\r\n<div class="ch-container">\r\n<div class="ch-outer">\r\n<div class="ch-inner">\r\n<p><a href="#">CHECK OUR<br /><span class="smaller">NEW OFFER!</span></a></p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<p> </p>\r\n</div>\r\n<div style="width: 49%; float: right;">\r\n<div>\r\n<p><strong>Video</strong></p>\r\n<div class="jm-code" style="min-height: 165px;">&lt;div class="view view-video"&gt;&lt;img src="<strong>images/modules/animated.jpg</strong>" border="0" alt="Video" /&gt; &lt;div class="mask"&gt; &lt;span class="space"&gt; &amp;nbsp; &lt;/span&gt; &lt;a class="modal readmore" href="<strong>#link</strong>" rel="{handler: \'iframe\', size: {x: 800, y: 600}}"&gt;&lt;span&gt;<strong>Watch the Video</strong>&lt;/span&gt;&lt;/a&gt;&lt;/div&gt;</div>\r\n<p> </p>\r\n<div style="margin: 0 auto; width: 280px;">\r\n<div class="view view-video"><img src="images/modules/animated.jpg" alt="Video" border="0" />\r\n<div class="mask"><span class="space">   </span><a class="modal readmore" href="https://www.youtube.com/embed/Umqu9poqIgo" rel="{handler: \'iframe\', size: {x: 800, y: 600}}">Watch the Video</a></div>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<p> </p>\r\n</div>\r\n<h3 class="jm-typo-title">Image Borders</h3>\r\n<div class="clearfix" style="margin: 0 -15px;">\r\n<div style="float: left; width: 33%;">\r\n<div class="jm-code" style="margin: 0 15px 20px;">&lt;img class="<strong>border_img1</strong>" src="<strong>image.jpg</strong>" /&gt;</div>\r\n<div style="text-align: center;"><img class="border_img1" src="images/modules/article1.jpg" alt="Typography" border="0" /></div>\r\n<p> </p>\r\n</div>\r\n<div style="float: left; width: 33%;">\r\n<div class="jm-code" style="margin: 0 15px 20px;">&lt;img class="<strong>border_img2</strong>" src="<strong>image.jpg</strong>" /&gt;</div>\r\n<div style="text-align: center;"><img class="border_img2" src="images/modules/article1.jpg" alt="Typography" border="0" /></div>\r\n<p> </p>\r\n</div>\r\n<div style="float: left; width: 33%;">\r\n<div class="jm-code" style="margin: 0 15px 20px;">&lt;img class="<strong>border_img3</strong>" src="<strong>image.jpg</strong>" /&gt;</div>\r\n<div style="text-align: center;"><img class="border_img3" src="images/modules/article1.jpg" alt="Typography" border="0" /></div>\r\n<p> </p>\r\n</div>\r\n</div>\r\n<h3 class="jm-typo-title">Headings</h3>\r\n<div class="clearfix">\r\n<div style="float: left; width: 49%;">\r\n<div style="padding: 0 10px 0 0;">\r\n<h1>This is Heading One (h1)</h1>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duis viverra leo sed turpis convallis sit amet condimentum diam vehicula. Morbi suscipit nisl odio, nec sodales tellus. Aenean quis sapien suscipit mauris convallis porta lacinia bibendum felis.</p>\r\n<br />\r\n<h2>This is Heading Two (h2)</h2>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duis viverra leo sed turpis convallis sit amet condimentum diam vehicula. Morbi suscipit nisl odio, nec sodales tellus. Aenean quis sapien suscipit mauris convallis porta lacinia bibendum felis.</p>\r\n<br />\r\n<h3>This is Heading Three (h3)</h3>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duis viverra leo sed turpis convallis sit amet condimentum diam vehicula. Morbi suscipit nisl odio, nec sodales tellus. Aenean quis sapien suscipit mauris convallis porta lacinia bibendum felis.</p>\r\n</div>\r\n</div>\r\n<div style="float: right; width: 49%;">\r\n<div style="padding: 0 0 0 10px;">\r\n<h4>This is Heading Four (h4)</h4>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duis viverra leo sed turpis convallis sit amet condimentum diam vehicula. Morbi suscipit nisl odio, nec sodales tellus. Aenean quis sapien suscipit mauris convallis porta lacinia bibendum felis.</p>\r\n<br />\r\n<h5>This is Heading Five (h5)</h5>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duis viverra leo sed turpis convallis sit amet condimentum diam vehicula. Morbi suscipit nisl odio, nec sodales tellus. Aenean quis sapien suscipit mauris convallis porta lacinia bibendum felis.</p>\r\n<br />\r\n<h6>This is Heading Six (h6)</h6>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duis viverra leo sed turpis convallis sit amet condimentum diam vehicula. Morbi suscipit nisl odio, nec sodales tellus. Aenean quis sapien suscipit mauris convallis porta lacinia bibendum felis.</p>\r\n</div>\r\n</div>\r\n</div>\r\n<p> </p>\r\n<h3 class="jm-typo-title">Numered blocks</h3>\r\n<div class="clearfix">\r\n<div style="float: left; width: 49%;">\r\n<div style="padding: 0 10px 0 0;">\r\n<div class="jm-code">&lt;p class="<strong>jm-block</strong>"&gt;&lt;span class="jm"&gt;01&lt;/span&gt;<strong>Text goes here</strong>&lt;/p&gt;</div>\r\n<p class="jm-block"><span class="jm">01</span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duis viverra leo sed turpis convallis sit amet condimentum diam vehicula. Morbi suscipit nisl odio, nec sodales tellus. Aenean quis sapien suscipit mauris.</p>\r\n<p class="jm-block"><span class="jm">02</span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duis viverra leo sed turpis convallis sit amet condimentum diam vehicula. Morbi suscipit nisl odio, nec sodales tellus. Aenean quis sapien suscipit mauris.</p>\r\n<p class="jm-block"><span class="jm">03</span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duis viverra leo sed turpis convallis sit amet condimentum diam vehicula. Morbi suscipit nisl odio, nec sodales tellus. Aenean quis sapien suscipit mauris.</p>\r\n</div>\r\n</div>\r\n<div style="float: right; width: 49%;">\r\n<div style="padding: 0 0 0 10px;">\r\n<div class="jm-code">&lt;p class="<strong>jm-block second</strong>"&gt;&lt;span class="jm"&gt;a&lt;/span&gt;<strong>Text goes here</strong>&lt;/p&gt;</div>\r\n<p class="jm-block second"><span class="jm">a</span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duis viverra leo sed turpis convallis sit amet condimentum diam vehicula. Morbi suscipit nisl odio, nec sodales tellus. Aenean quis sapien suscipit mauris.</p>\r\n<p class="jm-block second"><span class="jm">b</span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duis viverra leo sed turpis convallis sit amet condimentum diam vehicula. Morbi suscipit nisl odio, nec sodales tellus. Aenean quis sapien suscipit mauris.</p>\r\n<p class="jm-block second"><span class="jm">c</span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duis viverra leo sed turpis convallis sit amet condimentum diam vehicula. Morbi suscipit nisl odio, nec sodales tellus. Aenean quis sapien suscipit mauris.</p>\r\n</div>\r\n</div>\r\n</div>\r\n<p> </p>\r\n<h3 class="jm-typo-title">Colored blocks</h3>\r\n<div class="clearfix">\r\n<div style="float: left; width: 49%;">\r\n<div style="padding: 0 10px 0 0;">\r\n<p class="blue">this is a paragraph with the class "<strong>blue</strong>"<br /> &lt;p class="<strong>blue</strong>" &gt; Text goes here&lt;/p&gt;</p>\r\n<p style="margin: 11px 0; height: 0;"> </p>\r\n<p class="green">this is a paragraph with the class "<strong>green</strong>"<br /> &lt;p class="<strong>green</strong>" &gt; Text goes here&lt;/p&gt;</p>\r\n<p style="margin: 11px 0; height: 0;"> </p>\r\n<p class="red">this is a paragraph with the class "<strong>red</strong>"<br /> &lt;p class="<strong>red</strong>" &gt; Text goes here&lt;/p&gt;</p>\r\n</div>\r\n</div>\r\n<div style="float: right; width: 49%;">\r\n<div style="padding: 0 0 0 10px;">\r\n<p class="bluefill">this is a paragraph with the class "<strong>bluefill</strong>"<br /> &lt;p class="<strong>bluefill</strong>" &gt; Text goes here&lt;/p&gt;</p>\r\n<p class="greenfill">this is a paragraph with the class "<strong>greenfill</strong>"<br /> &lt;p class="<strong>greenfill</strong>" &gt; Text goes here&lt;/p&gt;</p>\r\n<p class="redfill">this is a paragraph with the class "<strong>redfill</strong>"<br /> &lt;p class="<strong>redfill</strong>" &gt; Text goes here&lt;/p&gt;</p>\r\n</div>\r\n</div>\r\n</div>\r\n<p> </p>\r\n<h3 class="jm-typo-title">Quote blocks</h3>\r\n<div class="clearfix">\r\n<div style="float: left; width: 49%;">\r\n<div style="padding: 0 10px 0 0;">\r\n<p class="quote-left">this is a paragraph with the class "<strong>quote-left</strong>"<br /> &lt;p class="<strong>quote-left</strong>" &gt; Text goes here&lt;/p&gt;</p>\r\n</div>\r\n</div>\r\n<div style="float: right; width: 49%;">\r\n<div style="padding: 0 0 0 10px;">\r\n<p class="quote-right">this is a paragraph with the class "<strong>quote-right</strong>"<br /> &lt;p class="<strong>quote-right</strong>" &gt; Text goes here&lt;/p&gt;</p>\r\n</div>\r\n</div>\r\n</div>\r\n<p> </p>\r\n<h3 class="jm-typo-title">Icon blocks</h3>\r\n<div class="clearfix">\r\n<div style="float: left; width: 49%;">\r\n<div style="padding: 0 10px 0 0;">\r\n<p class="jmbadge">this is a paragraph with the class "<strong>jmbadge</strong>"<br /> &lt;p class="<strong>jmbadge</strong>" &gt; Text goes here&lt;/p&gt;</p>\r\n<p class="jmcalendar">this is a paragraph with the class "<strong>jmcalendar</strong>"<br /> &lt;p class="<strong>jmcalendar</strong>" &gt; Text goes here&lt;/p&gt;</p>\r\n<p class="jmchat">this is a paragraph with the class "<strong>jmchat</strong>"<br /> &lt;p class="<strong>jmchat</strong>" &gt; Text goes here&lt;/p&gt;</p>\r\n<p class="jmcheck">this is a paragraph with the class "<strong>jmcheck</strong>"<br /> &lt;p class="<strong>jmcheck</strong>" &gt; Text goes here&lt;/p&gt;</p>\r\n<p class="jmcloud">this is a paragraph with the class "<strong>jmcloud</strong>"<br /> &lt;p class="<strong>jmcloud</strong>" &gt; Text goes here&lt;/p&gt;</p>\r\n<p class="jmdirection">this is a paragraph with the class "<strong>jmdirection</strong>"<br /> &lt;p class="<strong>jmdirection</strong>" &gt; Text goes here&lt;/p&gt;</p>\r\n<p class="jmdivide">this is a paragraph with the class "<strong>jmdivide</strong>"<br /> &lt;p class="<strong>jmdivide</strong>" &gt; Text goes here&lt;/p&gt;</p>\r\n<p class="jmerror">this is a paragraph with the class "<strong>jmerror</strong>"<br /> &lt;p class="<strong>jmerror</strong>" &gt; Text goes here&lt;/p&gt;</p>\r\n<p class="jmfire">this is a paragraph with the class "<strong>jmfire</strong>"<br /> &lt;p class="<strong>jmfire</strong>" &gt; Text goes here&lt;/p&gt;</p>\r\n</div>\r\n</div>\r\n<div style="float: right; width: 49%;">\r\n<div style="padding: 0 0 0 10px;">\r\n<p class="jmflag">this is a paragraph with the class "<strong>jmflag</strong>"<br /> &lt;p class="<strong>jmflag</strong>" &gt; Text goes here&lt;/p&gt;</p>\r\n<p class="jmheart">this is a paragraph with the class "<strong>jmheart</strong>"<br /> &lt;p class="<strong>jmheart</strong>" &gt; Text goes here&lt;/p&gt;</p>\r\n<p class="jmhome">this is a paragraph with the class "<strong>jmhome</strong>"<br /> &lt;p class="<strong>jmhome</strong>" &gt; Text goes here&lt;/p&gt;</p>\r\n<p class="jminfo">this is a paragraph with the class "<strong>jminfo</strong>"<br /> &lt;p class="<strong>jminfo</strong>" &gt; Text goes here&lt;/p&gt;</p>\r\n<p class="jmlist">this is a paragraph with the class "<strong>jmlist</strong>"<br /> &lt;p class="<strong>jmlist</strong>" &gt; Text goes here&lt;/p&gt;</p>\r\n<p class="jmmail">this is a paragraph with the class "<strong>jmmail</strong>"<br /> &lt;p class="<strong>jmmail</strong>" &gt; Text goes here&lt;/p&gt;</p>\r\n<p class="jmpeople">this is a paragraph with the class "<strong>jmpeople</strong>"<br /> &lt;p class="<strong>jmpeople</strong>" &gt; Text goes here&lt;/p&gt;</p>\r\n<p class="jmstar">this is a paragraph with the class "<strong>jmstar</strong>"<br /> &lt;p class="<strong>jmstar</strong>" &gt; Text goes here&lt;/p&gt;</p>\r\n<p class="jmstat">this is a paragraph with the class "<strong>jmstat</strong>"<br /> &lt;p class="<strong>jmstat</strong>" &gt; Text goes here&lt;/p&gt;</p>\r\n</div>\r\n</div>\r\n</div>\r\n<p> </p>\r\n<h3 class="jm-typo-title">Unordered lists</h3>\r\n<div class="clearfix" style="margin: 0 -15px;">\r\n<div style="float: left; width: 33%;">\r\n<div style="margin: 0 15px;">\r\n<div class="jm-code" style="margin: 0 0 20px; min-height: 85px;"><br />Default list</div>\r\n<ul>\r\n<li>Duis tincidunt nunc sit amet ipsum</li>\r\n<li>Duis tincidunt nunc sit amet ipsum</li>\r\n<li>Duis tincidunt nunc sit amet ipsum\r\n<ul>\r\n<li>Duis tincidunt nunc sit amet ipsum</li>\r\n<li>Duis tincidunt nunc sit amet ipsum\r\n<ul>\r\n<li>Duis tincidunt nunc sit amet ipsum</li>\r\n<li>Duis tincidunt nunc sit amet ipsum</li>\r\n<li>Duis tincidunt nunc sit amet ipsum</li>\r\n</ul>\r\n</li>\r\n</ul>\r\n</li>\r\n</ul>\r\n</div>\r\n</div>\r\n<div style="float: left; width: 33%;">\r\n<div style="margin: 0 15px;">\r\n<div class="jm-code" style="margin: 0 0 20px; min-height: 85px;">This is a list with the class "<strong>jm-light</strong>"<br />Enter the class name to ul tag &lt;ul class="<strong>jm-light</strong>"&gt;</div>\r\n<ul class="jm-light">\r\n<li>Duis tincidunt nunc sit amet ipsum</li>\r\n<li>Duis tincidunt nunc sit amet ipsum</li>\r\n<li>Duis tincidunt nunc sit amet ipsum\r\n<ul>\r\n<li>Duis tincidunt nunc sit amet ipsum</li>\r\n<li>Duis tincidunt nunc sit amet ipsum\r\n<ul>\r\n<li>Duis tincidunt nunc sit amet ipsum</li>\r\n<li>Duis tincidunt nunc sit amet ipsum</li>\r\n<li>Duis tincidunt nunc sit amet ipsum</li>\r\n</ul>\r\n</li>\r\n</ul>\r\n</li>\r\n</ul>\r\n</div>\r\n</div>\r\n<div style="float: left; width: 33%;">\r\n<div style="margin: 0 15px;">\r\n<div class="jm-code" style="margin: 0 0 20px; min-height: 85px;">This is a list with the class "<strong>jm-dark</strong>"<br />Enter the class name to ul tag &lt;ul class="<strong>jm-dark</strong>"&gt;</div>\r\n<ul class="jm-dark">\r\n<li>Duis tincidunt nunc sit amet ipsum</li>\r\n<li>Duis tincidunt nunc sit amet ipsum</li>\r\n<li>Duis tincidunt nunc sit amet ipsum\r\n<ul>\r\n<li>Duis tincidunt nunc sit amet ipsum</li>\r\n<li>Duis tincidunt nunc sit amet ipsum\r\n<ul>\r\n<li>Duis tincidunt nunc sit amet ipsum</li>\r\n<li>Duis tincidunt nunc sit amet ipsum</li>\r\n<li>Duis tincidunt nunc sit amet ipsum</li>\r\n</ul>\r\n</li>\r\n</ul>\r\n</li>\r\n</ul>\r\n</div>\r\n</div>\r\n</div>\r\n<p> </p>\r\n<h3 class="jm-typo-title">Ordered lists</h3>\r\n<div class="clearfix" style="margin: 0 -15px;">\r\n<div style="float: left; width: 33%;">\r\n<div style="margin: 0 15px;">\r\n<div class="jm-code" style="margin: 0 0 20px; min-height: 85px;"><br />Default list</div>\r\n<ol>\r\n<li>Duis tincidunt nunc sit amet ipsum</li>\r\n<li>Duis tincidunt nunc sit amet ipsum</li>\r\n<li>Duis tincidunt nunc sit amet ipsum\r\n<ol>\r\n<li>Duis tincidunt nunc sit amet ipsum</li>\r\n<li>Duis tincidunt nunc sit amet ipsum\r\n<ol>\r\n<li>Duis tincidunt nunc sit amet ipsum</li>\r\n<li>Duis tincidunt nunc sit amet ipsum</li>\r\n<li>Duis tincidunt nunc sit amet ipsum</li>\r\n</ol>\r\n</li>\r\n</ol>\r\n</li>\r\n</ol>\r\n</div>\r\n</div>\r\n<div style="float: left; width: 33%;">\r\n<div style="margin: 0 15px;">\r\n<div class="jm-code" style="margin: 0 0 20px; min-height: 85px;">This is a list with the class "<strong>jm-roman</strong>"<br />Enter the class name to ol tag &lt;ol class="<strong>jm-roman</strong>"&gt;</div>\r\n<ol class="jm-roman">\r\n<li>Duis tincidunt nunc sit amet ipsum</li>\r\n<li>Duis tincidunt nunc sit amet ipsum</li>\r\n<li>Duis tincidunt nunc sit amet ipsum\r\n<ol>\r\n<li>Duis tincidunt nunc sit amet ipsum</li>\r\n<li>Duis tincidunt nunc sit amet ipsum\r\n<ol>\r\n<li>Duis tincidunt nunc sit amet ipsum</li>\r\n<li>Duis tincidunt nunc sit amet ipsum</li>\r\n<li>Duis tincidunt nunc sit amet ipsum</li>\r\n</ol>\r\n</li>\r\n</ol>\r\n</li>\r\n</ol>\r\n</div>\r\n</div>\r\n<div style="float: left; width: 33%;">\r\n<div style="margin: 0 15px;">\r\n<div class="jm-code" style="margin: 0 0 20px; min-height: 85px;">This is a list with the class "<strong>jm-alpha</strong>"<br />Enter the class name to ol tag &lt;ol class="<strong>jm-alpha</strong>"&gt;</div>\r\n<ol class="jm-alpha">\r\n<li>Duis tincidunt nunc sit amet ipsum</li>\r\n<li>Duis tincidunt nunc sit amet ipsum</li>\r\n<li>Duis tincidunt nunc sit amet ipsum\r\n<ol>\r\n<li>Duis tincidunt nunc sit amet ipsum</li>\r\n<li>Duis tincidunt nunc sit amet ipsum\r\n<ol>\r\n<li>Duis tincidunt nunc sit amet ipsum</li>\r\n<li>Duis tincidunt nunc sit amet ipsum</li>\r\n<li>Duis tincidunt nunc sit amet ipsum</li>\r\n</ol>\r\n</li>\r\n</ol>\r\n</li>\r\n</ol>\r\n</div>\r\n</div>\r\n</div>\r\n<p> </p>\r\n<h3 class="jm-typo-title">Offcanvas button (top-menu-nav)</h3>\r\n<div class="jm-code">&lt;p&gt;&lt;a class="toggle-nav menu"&gt;&lt;span class="icon-align-justify"&gt;&lt;/span&gt;&lt;/a&gt;&lt;/p&gt;</div>\r\n<p> </p>\r\n<p><a class="toggle-nav menu"><span class="icon-align-justify"></span></a></p>\r\n<p> </p>\r\n<h3 class="jm-typo-title">Custom modules (bottom)</h3>\r\n<div class="row-fluid">\r\n<div class="span3">\r\n<div class="jm-code">&lt;div class="jm-box"&gt;&lt;a href="<strong>#</strong>"&gt; &lt;span class="icon"&gt;&lt;img src="<strong>images/modules/icons/icon1.png</strong>" alt="" /&gt;&lt;/span&gt; &lt;span class="title"&gt;<strong>Domestic Cleaning</strong>&lt;/span&gt; &lt;/a&gt;&lt;/div&gt;</div>\r\n<p></p>\r\n<div class="jm-module color2-ms">\r\n<div class="jm-box"><a href="#"> <span class="icon"><img src="images/modules/icons/icon1.png" alt="" /></span> <span class="title">Domestic Cleaning</span></a></div>\r\n</div>\r\n</div>\r\n<div class="span3">\r\n<div class="jm-code">&lt;div class="jm-box"&gt;&lt;a href="<strong>#</strong>"&gt; &lt;span class="icon"&gt;&lt;img src="<strong>images/modules/icons/icon2.png</strong>" alt="" /&gt;&lt;/span&gt; &lt;span class="title"&gt;<strong>Office Cleaning</strong>&lt;/span&gt; &lt;/a&gt;&lt;/div&gt;</div>\r\n<p></p>\r\n<div class="jm-module color1-ms">\r\n<div class="jm-box"><a href="#"> <span class="icon"><img src="images/modules/icons/icon2.png" alt="" /></span> <span class="title">Office Cleaning</span></a></div>\r\n</div>\r\n</div>\r\n<div class="span3">\r\n<div class="jm-code">&lt;div class="jm-box"&gt;&lt;a href="<strong>#</strong>"&gt; &lt;span class="icon"&gt;&lt;img src="<strong>images/modules/icons/icon3.png</strong>" alt="" /&gt;&lt;/span&gt; &lt;span class="title"&gt;<strong>Ironing Services</strong>&lt;/span&gt; &lt;/a&gt;&lt;/div&gt;</div>\r\n<p></p>\r\n<div class="jm-module color2-ms">\r\n<div class="jm-box"><a href="#"> <span class="icon"><img src="images/modules/icons/icon3.png" alt="" /></span> <span class="title">Ironing Services</span></a></div>\r\n</div>\r\n</div>\r\n<div class="span3">\r\n<div class="jm-code">&lt;div class="jm-box"&gt;&lt;a href="<strong>#</strong>"&gt; &lt;span class="icon"&gt;&lt;img src="<strong>images/modules/icons/icon4.png</strong>" alt="" /&gt;&lt;/span&gt; &lt;span class="title"&gt;<strong>End of tenancy cleaning</strong>&lt;/span&gt; &lt;/a&gt;&lt;/div&gt;</div>\r\n<p></p>\r\n<div class="jm-module color1-ms">\r\n<div class="jm-box"><a href="#"> <span class="icon"><img src="images/modules/icons/icon4.png" alt="" /></span> <span class="title">End of tenancy cleaning</span></a></div>\r\n</div>\r\n</div>\r\n<div class="span3">\r\n<div class="jm-code">&lt;div class="jm-box"&gt;&lt;a href="<strong>#</strong>"&gt; &lt;span class="icon"&gt;&lt;img src="<strong>images/modules/icons/icon5.png</strong>" alt="" /&gt;&lt;/span&gt; &lt;span class="title"&gt;<strong>Spring cleaning</strong>&lt;/span&gt; &lt;/a&gt;&lt;/div&gt;</div>\r\n<p></p>\r\n<div class="jm-module color2-ms">\r\n<div class="jm-box"><a href="#"> <span class="icon"><img src="images/modules/icons/icon5.png" alt="" /></span> <span class="title">Spring cleaning</span></a></div>\r\n</div>\r\n</div>\r\n<div class="span3">\r\n<div class="jm-code">&lt;div class="jm-box"&gt;&lt;a href="<strong>#</strong>"&gt; &lt;span class="icon"&gt;&lt;img src="<strong>images/modules/icons/icon6.png</strong>" alt="" /&gt;&lt;/span&gt; &lt;span class="title"&gt;<strong>Window cleaning</strong>&lt;/span&gt; &lt;/a&gt;&lt;/div&gt;</div>\r\n<p></p>\r\n<div class="jm-module color1-ms">\r\n<div class="jm-box"><a href="#"> <span class="icon"><img src="images/modules/icons/icon6.png" alt="" /></span> <span class="title">Window cleaning</span></a></div>\r\n</div>\r\n</div>\r\n<div class="span3">\r\n<div class="jm-code">&lt;div class="jm-box"&gt;&lt;a href="<strong>#</strong>"&gt; &lt;span class="icon"&gt;&lt;img src="<strong>images/modules/icons/icon7.png</strong>" alt="" /&gt;&lt;/span&gt; &lt;span class="title"&gt;<strong>Carpet cleaning</strong>&lt;/span&gt; &lt;/a&gt;&lt;/div&gt;</div>\r\n<p></p>\r\n<div class="jm-module color2-ms">\r\n<div class="jm-box"><a href="#"> <span class="icon"><img src="images/modules/icons/icon7.png" alt="" /></span> <span class="title">Carpet cleaning</span></a></div>\r\n</div>\r\n</div>\r\n<div class="span3">\r\n<div class="jm-code">&lt;div class="jm-box"&gt;&lt;a href="<strong>#</strong>"&gt; &lt;span class="icon"&gt;&lt;img src="<strong>images/modules/icons/icon8.png</strong>" alt="" /&gt;&lt;/span&gt; &lt;span class="title"&gt;<strong>Steam cleaning</strong>&lt;/span&gt; &lt;/a&gt;&lt;/div&gt;</div>\r\n<p></p>\r\n<div class="jm-module color1-ms">\r\n<div class="jm-box"><a href="#"> <span class="icon"><img src="images/modules/icons/icon8.png" alt="" /></span> <span class="title">Steam cleaning</span></a></div>\r\n</div>\r\n</div>\r\n</div>\r\n<p></p>\r\n<h3 class="jm-typo-title">Custom modules (right-column)</h3>\r\n<div class="jm-code">&lt;div class="jm-box-vertical"&gt;&lt;a class="jm-panel <strong>icon1</strong>" href="<strong>#</strong>"&gt;&lt;span class="jm-icon"&gt;&amp;nbsp;&lt;/span&gt;&lt;span class="jm-cell"&gt;&lt;span class="title"&gt;<strong>Professional Housekeepers</strong>&lt;/span&gt;&lt;span class="subtitle"&gt;<strong>lorem ipsum dolor</strong>&lt;/span&gt;&lt;/span&gt;&lt;/a&gt; &lt;a class="jm-panel <strong>icon2</strong>" href="<strong>#</strong>"&gt;&lt;span class="jm-icon"&gt;&amp;nbsp;&lt;/span&gt;&lt;span class="jm-cell"&gt; &lt;span class="title"&gt;<strong>Insured</strong>&lt;/span&gt;&lt;span class="subtitle"&gt;<strong>lorem ipsum dolor</strong>&lt;/span&gt;&lt;/span&gt; &lt;/a&gt; &lt;a class="jm-panel <strong>icon3</strong>" href="<strong>#</strong>"&gt;&lt;span class="jm-icon"&gt;&amp;nbsp;&lt;/span&gt;&lt;span class="jm-cell"&gt; &lt;span class="title"&gt;<strong>Background-checked</strong>&lt;/span&gt;&lt;span class="subtitle"&gt;<strong>lorem ipsum dolor</strong>&lt;/span&gt;&lt;/span&gt; &lt;/a&gt; &lt;a class="jm-panel <strong>icon4</strong>" href="<strong>#</strong>"&gt;&lt;span class="jm-icon"&gt;&amp;nbsp;&lt;/span&gt;&lt;span class="jm-cell"&gt; &lt;span class="title"&gt;<strong>5 Star Reviews</strong>&lt;/span&gt;&lt;span class="subtitle"&gt;<strong>lorem ipsum dolor</strong>&lt;/span&gt; &lt;/span&gt;&lt;/a&gt;&lt;/div&gt;</div>\r\n<p></p>\r\n<div class="jm-box-vertical"><a class="jm-panel icon1" href="#"><span class="jm-icon"> </span><span class="jm-cell"><span class="title">Professional Housekeepers</span><span class="subtitle">lorem ipsum dolor</span></span></a> <a class="jm-panel icon2" href="#"><span class="jm-icon"> </span><span class="jm-cell"> <span class="title">Insured</span><span class="subtitle">lorem ipsum dolor</span></span> </a> <a class="jm-panel icon3" href="#"><span class="jm-icon"> </span><span class="jm-cell"> <span class="title">Background-checked</span><span class="subtitle">lorem ipsum dolor</span></span> </a> <a class="jm-panel icon4" href="#"><span class="jm-icon"> </span><span class="jm-cell"> <span class="title">5 Star Reviews</span><span class="subtitle">lorem ipsum dolor</span> </span></a></div>\r\n<p></p>\r\n<h3 class="jm-typo-title">Custom modules (footer)</h3>\r\n<div class="clearfix" style="margin: 0 -15px;">\r\n<div style="width: 33%; float: left;">\r\n<div class="jm-code" style="margin: 0 15px; min-height: 145px;">&lt;div class="jm-bottom-box"&gt; &lt;div class="icon"&gt;&lt;img src="<strong>images/modules/icons/icon-phone.png</strong>" alt="" /&gt;&lt;/div&gt; &lt;div class="content"&gt;&lt;span class="title jm-color"&gt;<strong>Make an appointment</strong>&lt;/span&gt;&lt;span class="desc"&gt;<strong>+44 7983 462 854</strong>&lt;/span&gt;&lt;/div&gt; &lt;/div&gt;</div>\r\n</div>\r\n<div style="width: 33%; float: left;">\r\n<div class="jm-code" style="margin: 0 15px; min-height: 145px;">&lt;div class="jm-bottom-box"&gt; &lt;div class="icon"&gt;&lt;img src="<strong>images/modules/icons/icon-mail.png</strong>" alt="" /&gt;&lt;/div&gt; &lt;div class="content"&gt;&lt;span class="title jm-color"&gt;<strong>Send us an e-mail</strong>&lt;/span&gt;&lt;span class="desc"&gt;<strong>info@joomla-monster.com</strong>&lt;/span&gt;&lt;/div&gt; &lt;/div&gt;</div>\r\n</div>\r\n<div style="width: 33%; float: left;">\r\n<div class="jm-code" style="margin: 0 15px; min-height: 145px;">&lt;div class="jm-bottom-box"&gt; &lt;div class="icon"&gt;&lt;img src="<strong>images/modules/icons/icon-direction.png</strong>" alt="" /&gt;&lt;/div&gt; &lt;div class="content"&gt;&lt;span class="title jm-color"&gt;<strong>Visit us</strong>&lt;/span&gt;&lt;span class="desc"&gt;<strong>7 Green Lane, London</strong>&lt;/span&gt;&lt;/div&gt; &lt;/div&gt;</div>\r\n</div>\r\n</div>\r\n<p> </p>\r\n<div class="clearfix">\r\n<div style="width: 33%; float: left;">\r\n<div class="jm-bottom-box">\r\n<div class="icon"><img src="images/modules/icons/icon-phone.png" alt="" /></div>\r\n<div class="content"><span class="title jm-color">Make an appointment</span><span class="desc">+44 7983 462 854</span></div>\r\n</div>\r\n</div>\r\n<div style="width: 33%; float: left;">\r\n<div class="jm-bottom-box">\r\n<div class="icon"><img src="images/modules/icons/icon-mail.png" alt="" /></div>\r\n<div class="content"><span class="title jm-color">Send us an e-mail</span><span class="desc">info@joomla-monster.com</span></div>\r\n</div>\r\n</div>\r\n<div style="width: 33%; float: left;">\r\n<div class="jm-bottom-box">\r\n<div class="icon"><img src="images/modules/icons/icon-direction.png" alt="" /></div>\r\n<div class="content"><span class="title jm-color">Visit us</span><span class="desc">7 Green Lane, London</span></div>\r\n</div>\r\n</div>\r\n</div>\r\n<p> </p>\r\n<h3 class="jm-typo-title">Contact Details</h3>\r\n<div class="jm-code">&lt;div class="jm-bottom-box-custom"&gt; &lt;div class="icon"&gt;&lt;a href="<strong>#</strong>"&gt;&lt;img src="<strong>images/modules/icons/icon-phone.png</strong>" alt="" /&gt;&lt;/a&gt;&lt;/div&gt; &lt;div class="content"&gt;&lt;span class="title jm-color"&gt;<strong>Make an appointment</strong>&lt;/span&gt;&lt;span class="desc"&gt;<strong>+44 7983 462 854</strong>&lt;/span&gt;&lt;/div&gt; &lt;/div&gt; &lt;div class="jm-bottom-box-custom"&gt; &lt;div class="icon"&gt;&lt;a href="<strong>#</strong>"&gt;&lt;img src="<strong>images/modules/icons/icon-mail.png</strong>" alt="" /&gt;&lt;/a&gt;&lt;/div&gt; &lt;div class="content"&gt;&lt;span class="title jm-color"&gt;<strong>Send us a message</strong>&lt;/span&gt;&lt;span class="desc"&gt;<strong>info@joomla-monster.com</strong>&lt;/span&gt;&lt;/div&gt; &lt;/div&gt; &lt;div class="jm-bottom-box-custom"&gt; &lt;div class="icon"&gt;&lt;a href="<strong>#</strong>"&gt;&lt;img src="<strong>images/modules/icons/icon-direction.png</strong>" alt="" /&gt;&lt;/a&gt;&lt;/div&gt; &lt;div class="content"&gt;&lt;span class="title jm-color"&gt;<strong>Visit us</strong>&lt;/span&gt;&lt;span class="desc"&gt;<strong>7 Green Lane, London</strong>&lt;/span&gt;&lt;/div&gt; &lt;/div&gt;</div>\r\n<p></p>\r\n<div class="jm-bottom-box-custom">\r\n<div class="icon"><a href="#"><img src="images/modules/icons/icon-phone.png" alt="" /></a></div>\r\n<div class="content"><span class="title jm-color">Make an appointment</span><span class="desc">+44 7983 462 854</span></div>\r\n</div>\r\n<div class="jm-bottom-box-custom">\r\n<div class="icon"><a href="#"><img src="images/modules/icons/icon-mail.png" alt="" /></a></div>\r\n<div class="content"><span class="title jm-color">Send us a message</span><span class="desc">info@joomla-monster.com</span></div>\r\n</div>\r\n<div class="jm-bottom-box-custom">\r\n<div class="icon"><a href="#"><img src="images/modules/icons/icon-direction.png" alt="" /></a></div>\r\n<div class="content"><span class="title jm-color">Visit us</span><span class="desc">7 Green Lane, London</span></div>\r\n</div>\r\n<h3 class="jm-typo-title">Promotion</h3>\r\n<div class="jm-code">&lt;div class="jm-promo"&gt; &lt;p&gt;&lt;a href="<strong>#</strong>"&gt; &lt;img src="<strong>images/modules/icons/icon4.png</strong>" alt="" /&gt; &lt;span class="title"&gt;<strong>Dream to live clean?</strong>&lt;/span&gt; &lt;/a&gt;&lt;/p&gt; &lt;p&gt;<strong>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt.</strong>&lt;/p&gt; &lt;/div&gt;</div>\r\n<p></p>\r\n<div style="padding: 1px 20px 20px; background: #303030; color: #a7acb0;">\r\n<div class="jm-promo">\r\n<p><a href="#"> <img src="images/modules/icons/icon4.png" alt="" /> <span class="title">Dream to live clean?</span> </a></p>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt.</p>\r\n</div>\r\n</div>\r\n<p></p>\r\n<h3 class="jm-typo-title">Pricing table</h3>\r\n<div class="jm-code">&lt;div class="clearfix"&gt; &lt;table class="table pricing" style="<strong>width: 33%;</strong>"&gt; &lt;thead&gt; &lt;tr&gt;&lt;th colspan="2"&gt;<strong>Cleaning Service</strong>&lt;/th&gt;&lt;/tr&gt; &lt;/thead&gt; &lt;tbody&gt; &lt;tr&gt; &lt;td class="item"&gt;<strong>Lorem ipsum dolor sit amet, consectetur adipiscing elit.</strong>&lt;/td&gt; &lt;td class="price"&gt;<strong>$1</strong>&lt;/td&gt; &lt;/tr&gt; &lt;tr&gt; &lt;td class="item"&gt;<strong>Donec tempor hendrerit sapien, sed mattis diam eleifend tempus.</strong>&lt;/td&gt; &lt;td class="price"&gt;<strong>$5</strong>&lt;/td&gt; &lt;/tr&gt; &lt;tr&gt; &lt;td class="item"&gt;<strong>Donec ornare venenatis imperdiet.</strong>&lt;/td&gt; &lt;td class="price"&gt;<strong>$10</strong>&lt;/td&gt; &lt;/tr&gt; &lt;tr&gt; &lt;td class="item"&gt;<strong>Vestibulum sed nibh in nisi blandit ornare eget vel neque.</strong>&lt;/td&gt; &lt;td class="price"&gt;<strong>$15</strong>&lt;/td&gt; &lt;/tr&gt; &lt;tr&gt; &lt;td class="item"&gt;<strong>Cras condimentum porttitor quam, id tincidunt odio lacinia id.</strong>&lt;/td&gt; &lt;td class="price"&gt;<strong>$20</strong>&lt;/td&gt; &lt;/tr&gt; &lt;/tbody&gt; &lt;/table&gt; &lt;table class="table pricing" style="<strong>width: 33%;</strong>"&gt; &lt;thead&gt; &lt;tr&gt;&lt;th colspan="2"&gt;<strong>Ironing Service</strong>&lt;/th&gt;&lt;/tr&gt; &lt;/thead&gt; &lt;tbody&gt; &lt;tr&gt; &lt;td class="item"&gt;<strong>Pellentesque convallis imperdiet velit a consequat.</strong>&lt;/td&gt; &lt;td class="price"&gt;<strong>$5</strong>&lt;/td&gt; &lt;/tr&gt; &lt;tr&gt; &lt;td class="item"&gt;<strong>Praesent quis purus cursus mauris ultrices ultrices ac vitae purus.</strong>&lt;/td&gt; &lt;td class="price"&gt;<strong>$10</strong>&lt;/td&gt; &lt;/tr&gt; &lt;tr&gt; &lt;td class="item"&gt;<strong>Phasellus at velit lacinia quam dapibus eleifend eu ac nisl.</strong>&lt;/td&gt; &lt;td class="price"&gt;<strong>$15</strong>&lt;/td&gt; &lt;/tr&gt; &lt;tr&gt; &lt;td class="item"&gt;<strong>Donec id justo tempus, tincidunt ipsum ut, rutrum quam.</strong>&lt;/td&gt; &lt;td class="price"&gt;<strong>$20</strong>&lt;/td&gt; &lt;/tr&gt; &lt;tr&gt; &lt;td class="item"&gt;<strong>Ut ultricies consectetur faucibus.</strong>&lt;/td&gt; &lt;td class="price"&gt;<strong>$25</strong>&lt;/td&gt; &lt;/tr&gt; &lt;/tbody&gt; &lt;/table&gt; &lt;table class="table pricing" style="<strong>width: 33%;</strong>"&gt; &lt;thead&gt; &lt;tr&gt;&lt;th colspan="2"&gt;<strong>Additional charges</strong>&lt;/th&gt;&lt;/tr&gt; &lt;/thead&gt; &lt;tbody&gt; &lt;tr&gt; &lt;td class="item"&gt;<strong>Etiam nibh nisl, fermentum sit amet egestas in, sodales in dui.</strong>&lt;/td&gt; &lt;td class="price"&gt;<strong>$5</strong>&lt;/td&gt; &lt;/tr&gt; &lt;tr&gt; &lt;td class="item"&gt;<strong>Quisque eu orci finibus, accumsan eros id, posuere est.</strong>&lt;/td&gt; &lt;td class="price"&gt;<strong>$10</strong>&lt;/td&gt; &lt;/tr&gt; &lt;tr&gt; &lt;td class="item"&gt;<strong>Vestibulum faucibus, mi eu mattis faucibus, orci velit pharetra tellus.</strong>&lt;/td&gt; &lt;td class="price"&gt;<strong>$15</strong>&lt;/td&gt; &lt;/tr&gt; &lt;tr&gt; &lt;td class="item"&gt;<strong>Proin imperdiet sapien ut dolor.</strong>&lt;/td&gt; &lt;td class="price"&gt;<strong>$20</strong>&lt;/td&gt; &lt;/tr&gt; &lt;tr&gt; &lt;td class="item"&gt;<strong>Praesent semper finibus consectetur.</strong>&lt;/td&gt; &lt;td class="price"&gt;<strong>$15</strong>&lt;/td&gt; &lt;/tr&gt; &lt;/tbody&gt; &lt;/table&gt; &lt;/div&gt;</div>\r\n<p></p>\r\n<div class="clearfix">\r\n<table class="table pricing" style="width: 33%;">\r\n<thead>\r\n<tr><th colspan="2">Cleaning Service</th></tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td class="item">Lorem ipsum dolor sit amet, consectetur adipiscing elit.</td>\r\n<td class="price">$1</td>\r\n</tr>\r\n<tr>\r\n<td class="item">Donec tempor hendrerit sapien, sed mattis diam eleifend tempus.</td>\r\n<td class="price">$5</td>\r\n</tr>\r\n<tr>\r\n<td class="item">Donec ornare venenatis imperdiet.</td>\r\n<td class="price">$10</td>\r\n</tr>\r\n<tr>\r\n<td class="item">Vestibulum sed nibh in nisi blandit ornare eget vel neque.</td>\r\n<td class="price">$15</td>\r\n</tr>\r\n<tr>\r\n<td class="item">Cras condimentum porttitor quam, id tincidunt odio lacinia id.</td>\r\n<td class="price">$20</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class="table pricing" style="width: 33%;">\r\n<thead>\r\n<tr><th colspan="2">Ironing Service</th></tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td class="item">Pellentesque convallis imperdiet velit a consequat.</td>\r\n<td class="price">$5</td>\r\n</tr>\r\n<tr>\r\n<td class="item">Praesent quis purus cursus mauris ultrices ultrices ac vitae purus.</td>\r\n<td class="price">$10</td>\r\n</tr>\r\n<tr>\r\n<td class="item">Phasellus at velit lacinia quam dapibus eleifend eu ac nisl.</td>\r\n<td class="price">$15</td>\r\n</tr>\r\n<tr>\r\n<td class="item">Donec id justo tempus, tincidunt ipsum ut, rutrum quam.</td>\r\n<td class="price">$20</td>\r\n</tr>\r\n<tr>\r\n<td class="item">Ut ultricies consectetur faucibus.</td>\r\n<td class="price">$25</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class="table pricing" style="width: 33%;">\r\n<thead>\r\n<tr><th colspan="2">Additional charges</th></tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td class="item">Etiam nibh nisl, fermentum sit amet egestas in, sodales in dui.</td>\r\n<td class="price">$5</td>\r\n</tr>\r\n<tr>\r\n<td class="item">Quisque eu orci finibus, accumsan eros id, posuere est.</td>\r\n<td class="price">$10</td>\r\n</tr>\r\n<tr>\r\n<td class="item">Vestibulum faucibus, mi eu mattis faucibus, orci velit pharetra tellus.</td>\r\n<td class="price">$15</td>\r\n</tr>\r\n<tr>\r\n<td class="item">Proin imperdiet sapien ut dolor.</td>\r\n<td class="price">$20</td>\r\n</tr>\r\n<tr>\r\n<td class="item">Praesent semper finibus consectetur.</td>\r\n<td class="price">$15</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<p></p>\r\n<h3 class="jm-typo-title">Social icons</h3>\r\n<div class="jm-code">&lt;p class="jm-icons"&gt; &lt;a class="jm-facebook" href="<strong>#link</strong>"&gt;&amp;nbsp;&lt;/a&gt; &lt;a class="jm-link" href="<strong>#link</strong>"&gt;&amp;nbsp;&lt;/a&gt; &lt;a class="jm-skype" href="<strong>#link</strong>"&gt;&amp;nbsp;&lt;/a&gt; &lt;a class="jm-twitter" href="<strong>#link</strong>"&gt;&amp;nbsp;&lt;/a&gt; &lt;a class="jm-google" href="<strong>#link</strong>"&gt;&amp;nbsp;&lt;/a&gt; &lt;/p&gt;</div>\r\n<p> </p>\r\n<div style="padding: 15px;">\r\n<p class="jm-icons"><a class="jm-facebook" href="#"> </a> <a class="jm-link" href="#"> </a> <a class="jm-skype" href="#"> </a> <a class="jm-twitter" href="#"> </a> <a class="jm-google" href="#"> </a></p>\r\n</div>\r\n<p> </p>\r\n<h3 class="jm-typo-title">Buttons</h3>\r\n<div class="jm-code">This is a read more link with the class "readmore"<br />Enter the class name to a tag &lt;a class="<strong>readmore</strong>" /&gt;</div>\r\n<p style="display: inline-block; width: 100%; margin: 10px 0 0;"><a class="readmore" href="#">Read more</a></p>\r\n<p> </p>\r\n<h3 class="jm-typo-title">Glyphicon Font</h3>\r\n<div>\r\n<div class="jm-code">&lt;span class="icon-joomla"&gt;&amp;nbsp&lt;/span&gt;</div>\r\n</div>\r\n<div class="row-fluid">\r\n<div class="span3">\r\n<div style="padding: 2px 0;"><span class="icon-asterisk"> </span> icon-asterisk</div>\r\n<div style="padding: 2px 0;"><span class="icon-plus"> </span> icon-plus</div>\r\n<div style="padding: 2px 0;"><span class="icon-euro"> </span> icon-euro</div>\r\n<div style="padding: 2px 0;"><span class="icon-minus"> </span> icon-minus</div>\r\n<div style="padding: 2px 0;"><span class="icon-cloud"> </span> icon-cloud</div>\r\n<div style="padding: 2px 0;"><span class="icon-envelope"> </span> icon-envelope</div>\r\n<div style="padding: 2px 0;"><span class="icon-pencil"> </span> icon-pencil</div>\r\n<div style="padding: 2px 0;"><span class="icon-glass"> </span> icon-glass</div>\r\n<div style="padding: 2px 0;"><span class="icon-music"> </span> icon-music</div>\r\n<div style="padding: 2px 0;"><span class="icon-search"> </span> icon-search</div>\r\n<div style="padding: 2px 0;"><span class="icon-heart"> </span> icon-heart</div>\r\n<div style="padding: 2px 0;"><span class="icon-star"> </span> icon-star</div>\r\n<div style="padding: 2px 0;"><span class="icon-star-empty"> </span> icon-star-empty</div>\r\n<div style="padding: 2px 0;"><span class="icon-user"> </span> icon-user</div>\r\n<div style="padding: 2px 0;"><span class="icon-film"> </span> icon-film</div>\r\n<div style="padding: 2px 0;"><span class="icon-th-large"> </span> icon-th-large</div>\r\n<div style="padding: 2px 0;"><span class="icon-th"> </span> icon-th</div>\r\n<div style="padding: 2px 0;"><span class="icon-th-list"> </span> icon-th-list</div>\r\n<div style="padding: 2px 0;"><span class="icon-ok"> </span> icon-ok</div>\r\n<div style="padding: 2px 0;"><span class="icon-remove"> </span> icon-remove</div>\r\n<div style="padding: 2px 0;"><span class="icon-zoom-in"> </span> icon-zoom-in</div>\r\n<div style="padding: 2px 0;"><span class="icon-zoom-out"> </span> icon-zoom-out</div>\r\n<div style="padding: 2px 0;"><span class="icon-off"> </span> icon-off</div>\r\n<div style="padding: 2px 0;"><span class="icon-signal"> </span> icon-signal</div>\r\n<div style="padding: 2px 0;"><span class="icon-cog"> </span> icon-cog</div>\r\n<div style="padding: 2px 0;"><span class="icon-trash"> </span> icon-trash</div>\r\n<div style="padding: 2px 0;"><span class="icon-home"> </span> icon-home</div>\r\n<div style="padding: 2px 0;"><span class="icon-file"> </span> icon-file</div>\r\n<div style="padding: 2px 0;"><span class="icon-time"> </span> icon-time</div>\r\n<div style="padding: 2px 0;"><span class="icon-road"> </span> icon-road</div>\r\n<div style="padding: 2px 0;"><span class="icon-download-alt"> </span> icon-download-alt</div>\r\n<div style="padding: 2px 0;"><span class="icon-download"> </span> icon-download</div>\r\n<div style="padding: 2px 0;"><span class="icon-upload"> </span> icon-upload</div>\r\n<div style="padding: 2px 0;"><span class="icon-inbox"> </span> icon-inbox</div>\r\n<div style="padding: 2px 0;"><span class="icon-play-circle"> </span> icon-play-circle</div>\r\n<div style="padding: 2px 0;"><span class="icon-repeat"> </span> icon-repeat</div>\r\n<div style="padding: 2px 0;"><span class="icon-refresh"> </span> icon-refresh</div>\r\n<div style="padding: 2px 0;"><span class="icon-list-alt"> </span> icon-list-alt</div>\r\n<div style="padding: 2px 0;"><span class="icon-lock"> </span> icon-lock</div>\r\n<div style="padding: 2px 0;"><span class="icon-flag"> </span> icon-flag</div>\r\n<div style="padding: 2px 0;"><span class="icon-headphones"> </span> icon-headphones</div>\r\n<div style="padding: 2px 0;"><span class="icon-volume-off"> </span> icon-volume-off</div>\r\n<div style="padding: 2px 0;"><span class="icon-volume-down"> </span> icon-volume-down</div>\r\n<div style="padding: 2px 0;"><span class="icon-volume-up"> </span> icon-volume-up</div>\r\n<div style="padding: 2px 0;"><span class="icon-qrcode"> </span> icon-qrcode</div>\r\n<div style="padding: 2px 0;"><span class="icon-barcode"> </span> icon-barcode</div>\r\n<div style="padding: 2px 0;"><span class="icon-tag"> </span> icon-tag</div>\r\n<div style="padding: 2px 0;"><span class="icon-tags"> </span> icon-tags</div>\r\n<div style="padding: 2px 0;"><span class="icon-book"> </span> icon-book</div>\r\n<div style="padding: 2px 0;"><span class="icon-bookmark"> </span> icon-bookmark</div>\r\n</div>\r\n<div class="span3">\r\n<div style="padding: 2px 0;"><span class="icon-print"> </span> icon-print</div>\r\n<div style="padding: 2px 0;"><span class="icon-camera"> </span> icon-camera</div>\r\n<div style="padding: 2px 0;"><span class="icon-font"> </span> icon-font</div>\r\n<div style="padding: 2px 0;"><span class="icon-bold"> </span> icon-bold</div>\r\n<div style="padding: 2px 0;"><span class="icon-italic"> </span> icon-italic</div>\r\n<div style="padding: 2px 0;"><span class="icon-text-height"> </span> icon-text-height</div>\r\n<div style="padding: 2px 0;"><span class="icon-text-width"> </span> icon-text-width</div>\r\n<div style="padding: 2px 0;"><span class="icon-align-left"> </span> icon-align-left</div>\r\n<div style="padding: 2px 0;"><span class="icon-align-center"> </span> icon-align-center</div>\r\n<div style="padding: 2px 0;"><span class="icon-align-right"> </span> icon-align-right</div>\r\n<div style="padding: 2px 0;"><span class="icon-align-justify"> </span> icon-align-justify</div>\r\n<div style="padding: 2px 0;"><span class="icon-list"> </span> icon-list</div>\r\n<div style="padding: 2px 0;"><span class="icon-indent-left"> </span> icon-indent-left</div>\r\n<div style="padding: 2px 0;"><span class="icon-indent-right"> </span> icon-indent-right</div>\r\n<div style="padding: 2px 0;"><span class="icon-facetime-video"> </span> icon-facetime-video</div>\r\n<div style="padding: 2px 0;"><span class="icon-picture"> </span> icon-picture</div>\r\n<div style="padding: 2px 0;"><span class="icon-map-marker"> </span> icon-map-marker</div>\r\n<div style="padding: 2px 0;"><span class="icon-adjust"> </span> icon-adjust</div>\r\n<div style="padding: 2px 0;"><span class="icon-tint"> </span> icon-tint</div>\r\n<div style="padding: 2px 0;"><span class="icon-edit"> </span> icon-edit</div>\r\n<div style="padding: 2px 0;"><span class="icon-share"> </span> icon-share</div>\r\n<div style="padding: 2px 0;"><span class="icon-check"> </span> icon-check</div>\r\n<div style="padding: 2px 0;"><span class="icon-move"> </span> icon-move</div>\r\n<div style="padding: 2px 0;"><span class="icon-step-backward"> </span> icon-step-backward</div>\r\n<div style="padding: 2px 0;"><span class="icon-fast-backward"> </span> icon-fast-backward</div>\r\n<div style="padding: 2px 0;"><span class="icon-backward"> </span> icon-backward</div>\r\n<div style="padding: 2px 0;"><span class="icon-play"> </span> icon-play</div>\r\n<div style="padding: 2px 0;"><span class="icon-pause"> </span> icon-pause</div>\r\n<div style="padding: 2px 0;"><span class="icon-stop"> </span> icon-stop</div>\r\n<div style="padding: 2px 0;"><span class="icon-forward"> </span> icon-forward</div>\r\n<div style="padding: 2px 0;"><span class="icon-fast-forward"> </span> icon-fast-forward</div>\r\n<div style="padding: 2px 0;"><span class="icon-step-forward"> </span> icon-step-forward</div>\r\n<div style="padding: 2px 0;"><span class="icon-eject"> </span> icon-eject</div>\r\n<div style="padding: 2px 0;"><span class="icon-chevron-left"> </span> icon-chevron-left</div>\r\n<div style="padding: 2px 0;"><span class="icon-chevron-right"> </span> icon-chevron-right</div>\r\n<div style="padding: 2px 0;"><span class="icon-plus-sign"> </span> icon-plus-sign</div>\r\n<div style="padding: 2px 0;"><span class="icon-minus-sign"> </span> icon-minus-sign</div>\r\n<div style="padding: 2px 0;"><span class="icon-remove-sign"> </span> icon-remove-sign</div>\r\n<div style="padding: 2px 0;"><span class="icon-ok-sign"> </span> icon-ok-sign</div>\r\n<div style="padding: 2px 0;"><span class="icon-question-sign"> </span> icon-question-sign</div>\r\n<div style="padding: 2px 0;"><span class="icon-info-sign"> </span> icon-info-sign</div>\r\n<div style="padding: 2px 0;"><span class="icon-screenshot"> </span> icon-screenshot</div>\r\n<div style="padding: 2px 0;"><span class="icon-remove-circle"> </span> icon-remove-circle</div>\r\n<div style="padding: 2px 0;"><span class="icon-ok-circle"> </span> icon-ok-circle</div>\r\n<div style="padding: 2px 0;"><span class="icon-ban-circle"> </span> icon-ban-circle</div>\r\n<div style="padding: 2px 0;"><span class="icon-arrow-left"> </span> icon-arrow-left</div>\r\n<div style="padding: 2px 0;"><span class="icon-arrow-right"> </span> icon-arrow-right</div>\r\n<div style="padding: 2px 0;"><span class="icon-arrow-up"> </span> icon-arrow-up</div>\r\n<div style="padding: 2px 0;"><span class="icon-arrow-down"> </span> icon-arrow-down</div>\r\n<div style="padding: 2px 0;"><span class="icon-share-alt"> </span> icon-share-alt</div>\r\n</div>\r\n<div class="span3">\r\n<div style="padding: 2px 0;"><span class="icon-resize-full"> </span> icon-resize-full</div>\r\n<div style="padding: 2px 0;"><span class="icon-resize-small"> </span> icon-resize-small</div>\r\n<div style="padding: 2px 0;"><span class="icon-exclamation-sign"> </span> icon-exclamation-sign</div>\r\n<div style="padding: 2px 0;"><span class="icon-gift"> </span> icon-gift</div>\r\n<div style="padding: 2px 0;"><span class="icon-leaf"> </span> icon-leaf</div>\r\n<div style="padding: 2px 0;"><span class="icon-fire"> </span> icon-fire</div>\r\n<div style="padding: 2px 0;"><span class="icon-eye-open"> </span> icon-eye-open</div>\r\n<div style="padding: 2px 0;"><span class="icon-eye-close"> </span> icon-eye-close</div>\r\n<div style="padding: 2px 0;"><span class="icon-warning-sign"> </span> icon-warning-sign</div>\r\n<div style="padding: 2px 0;"><span class="icon-plane"> </span> icon-plane</div>\r\n<div style="padding: 2px 0;"><span class="icon-calendar"> </span> icon-calendar</div>\r\n<div style="padding: 2px 0;"><span class="icon-random"> </span> icon-random</div>\r\n<div style="padding: 2px 0;"><span class="icon-comment"> </span> icon-comment</div>\r\n<div style="padding: 2px 0;"><span class="icon-magnet"> </span> icon-magnet</div>\r\n<div style="padding: 2px 0;"><span class="icon-chevron-up"> </span> icon-chevron-up</div>\r\n<div style="padding: 2px 0;"><span class="icon-chevron-down"> </span> icon-chevron-down</div>\r\n<div style="padding: 2px 0;"><span class="icon-retweet"> </span> icon-retweet</div>\r\n<div style="padding: 2px 0;"><span class="icon-shopping-cart"> </span> icon-shopping-cart</div>\r\n<div style="padding: 2px 0;"><span class="icon-folder-close"> </span> icon-folder-close</div>\r\n<div style="padding: 2px 0;"><span class="icon-folder-open"> </span> icon-folder-open</div>\r\n<div style="padding: 2px 0;"><span class="icon-resize-vertical"> </span> icon-resize-vertical</div>\r\n<div style="padding: 2px 0;"><span class="icon-resize-horizontal"> </span> icon-resize-horizontal</div>\r\n<div style="padding: 2px 0;"><span class="icon-hdd"> </span> icon-hdd</div>\r\n<div style="padding: 2px 0;"><span class="icon-bullhorn"> </span> icon-bullhorn</div>\r\n<div style="padding: 2px 0;"><span class="icon-bell"> </span> icon-bell</div>\r\n<div style="padding: 2px 0;"><span class="icon-certificate"> </span> icon-certificate</div>\r\n<div style="padding: 2px 0;"><span class="icon-thumbs-up"> </span> icon-thumbs-up</div>\r\n<div style="padding: 2px 0;"><span class="icon-thumbs-down"> </span> icon-thumbs-down</div>\r\n<div style="padding: 2px 0;"><span class="icon-hand-right"> </span> icon-hand-right</div>\r\n<div style="padding: 2px 0;"><span class="icon-hand-left"> </span> icon-hand-left</div>\r\n<div style="padding: 2px 0;"><span class="icon-hand-up"> </span> icon-hand-up</div>\r\n<div style="padding: 2px 0;"><span class="icon-hand-down"> </span> icon-hand-down</div>\r\n<div style="padding: 2px 0;"><span class="icon-circle-arrow-right"> </span> icon-circle-arrow-right</div>\r\n<div style="padding: 2px 0;"><span class="icon-circle-arrow-left"> </span> icon-circle-arrow-left</div>\r\n<div style="padding: 2px 0;"><span class="icon-circle-arrow-up"> </span> icon-circle-arrow-up</div>\r\n<div style="padding: 2px 0;"><span class="icon-circle-arrow-down"> </span> icon-circle-arrow-down</div>\r\n<div style="padding: 2px 0;"><span class="icon-globe"> </span> icon-globe</div>\r\n<div style="padding: 2px 0;"><span class="icon-wrench"> </span> icon-wrench</div>\r\n<div style="padding: 2px 0;"><span class="icon-tasks"> </span> icon-tasks</div>\r\n<div style="padding: 2px 0;"><span class="icon-filter"> </span> icon-filter</div>\r\n<div style="padding: 2px 0;"><span class="icon-briefcase"> </span> icon-briefcase</div>\r\n<div style="padding: 2px 0;"><span class="icon-fullscreen"> </span> icon-fullscreen</div>\r\n<div style="padding: 2px 0;"><span class="icon-dashboard"> </span> icon-dashboard</div>\r\n<div style="padding: 2px 0;"><span class="icon-paperclip"> </span> icon-paperclip</div>\r\n<div style="padding: 2px 0;"><span class="icon-heart-empty"> </span> icon-heart-empty</div>\r\n<div style="padding: 2px 0;"><span class="icon-link"> </span> icon-link</div>\r\n<div style="padding: 2px 0;"><span class="icon-phone"> </span> icon-phone</div>\r\n<div style="padding: 2px 0;"><span class="icon-pushpin"> </span> icon-pushpin</div>\r\n<div style="padding: 2px 0;"><span class="icon-usd"> </span> icon-usd</div>\r\n<div style="padding: 2px 0;"><span class="icon-gbp"> </span> icon-gbp</div>\r\n</div>\r\n<div class="span3">\r\n<div style="padding: 2px 0;"><span class="icon-sort"> </span> icon-sort</div>\r\n<div style="padding: 2px 0;"><span class="icon-sort-by-alphabet"> </span> icon-sort-by-alphabet</div>\r\n<div style="padding: 2px 0;"><span class="icon-sort-by-alphabet-alt"> </span> icon-sort-by-alphabet-alt</div>\r\n<div style="padding: 2px 0;"><span class="icon-sort-by-order"> </span> icon-sort-by-order</div>\r\n<div style="padding: 2px 0;"><span class="icon-sort-by-order-alt"> </span> icon-sort-by-order-alt</div>\r\n<div style="padding: 2px 0;"><span class="icon-sort-by-attributes"> </span> icon-sort-by-attributes</div>\r\n<div style="padding: 2px 0;"><span class="icon-sort-by-attributes-alt"> </span> icon-sort-by-attributes-alt</div>\r\n<div style="padding: 2px 0;"><span class="icon-unchecked"> </span> icon-unchecked</div>\r\n<div style="padding: 2px 0;"><span class="icon-expand"> </span> icon-expand</div>\r\n<div style="padding: 2px 0;"><span class="icon-collapse-down"> </span> icon-collapse-down</div>\r\n<div style="padding: 2px 0;"><span class="icon-collapse-up"> </span> icon-collapse-up</div>\r\n<div style="padding: 2px 0;"><span class="icon-log-in"> </span> icon-log-in</div>\r\n<div style="padding: 2px 0;"><span class="icon-flash"> </span> icon-flash</div>\r\n<div style="padding: 2px 0;"><span class="icon-log-out"> </span> icon-log-out</div>\r\n<div style="padding: 2px 0;"><span class="icon-new-window"> </span> icon-new-window</div>\r\n<div style="padding: 2px 0;"><span class="icon-record"> </span> icon-record</div>\r\n<div style="padding: 2px 0;"><span class="icon-save"> </span> icon-save</div>\r\n<div style="padding: 2px 0;"><span class="icon-open"> </span> icon-open</div>\r\n<div style="padding: 2px 0;"><span class="icon-saved"> </span> icon-saved</div>\r\n<div style="padding: 2px 0;"><span class="icon-import"> </span> icon-import</div>\r\n<div style="padding: 2px 0;"><span class="icon-export"> </span> icon-export</div>\r\n<div style="padding: 2px 0;"><span class="icon-send"> </span> icon-send</div>\r\n<div style="padding: 2px 0;"><span class="icon-floppy-disk"> </span> icon-floppy-disk</div>\r\n<div style="padding: 2px 0;"><span class="icon-floppy-saved"> </span> icon-floppy-saved</div>\r\n<div style="padding: 2px 0;"><span class="icon-floppy-remove"> </span> icon-floppy-remove</div>\r\n<div style="padding: 2px 0;"><span class="icon-floppy-save"> </span> icon-floppy-save</div>\r\n<div style="padding: 2px 0;"><span class="icon-floppy-open"> </span> icon-floppy-open</div>\r\n<div style="padding: 2px 0;"><span class="icon-credit-card"> </span> icon-credit-card</div>\r\n<div style="padding: 2px 0;"><span class="icon-transfer"> </span> icon-transfer</div>\r\n<div style="padding: 2px 0;"><span class="icon-cutlery"> </span> icon-cutlery</div>\r\n<div style="padding: 2px 0;"><span class="icon-header"> </span> icon-header</div>\r\n<div style="padding: 2px 0;"><span class="icon-compressed"> </span> icon-compressed</div>\r\n<div style="padding: 2px 0;"><span class="icon-earphone"> </span> icon-earphone</div>\r\n<div style="padding: 2px 0;"><span class="icon-phone-alt"> </span> icon-phone-alt</div>\r\n<div style="padding: 2px 0;"><span class="icon-tower"> </span> icon-tower</div>\r\n<div style="padding: 2px 0;"><span class="icon-stats"> </span> icon-stats</div>\r\n<div style="padding: 2px 0;"><span class="icon-sd-video"> </span> icon-sd-video</div>\r\n<div style="padding: 2px 0;"><span class="icon-hd-video"> </span> icon-hd-video</div>\r\n<div style="padding: 2px 0;"><span class="icon-subtitles"> </span> icon-subtitles</div>\r\n<div style="padding: 2px 0;"><span class="icon-sound-stereo"> </span> icon-sound-stereo</div>\r\n<div style="padding: 2px 0;"><span class="icon-sound-dolby"> </span> icon-sound-dolby</div>\r\n<div style="padding: 2px 0;"><span class="icon-sound-5-1"> </span> icon-sound-5-1</div>\r\n<div style="padding: 2px 0;"><span class="icon-sound-6-1"> </span> icon-sound-6-1</div>\r\n<div style="padding: 2px 0;"><span class="icon-sound-7-1"> </span> icon-sound-7-1</div>\r\n<div style="padding: 2px 0;"><span class="icon-copyright-mark"> </span> icon-copyright-mark</div>\r\n<div style="padding: 2px 0;"><span class="icon-registration-mark"> </span> icon-registration-mark</div>\r\n<div style="padding: 2px 0;"><span class="icon-cloud-download"> </span> icon-cloud-download</div>\r\n<div style="padding: 2px 0;"><span class="icon-cloud-upload"> </span> icon-cloud-upload</div>\r\n<div style="padding: 2px 0;"><span class="icon-tree-conifer"> </span> icon-tree-conifer</div>\r\n<div style="padding: 2px 0;"><span class="icon-tree-deciduous"> </span> icon-tree-deciduous</div>\r\n</div>\r\n</div>','','1','82','2013-02-20 09:05:10','499','','2015-05-06 13:19:48','545','0','0000-00-00 00:00:00','2013-02-20 09:05:10','0000-00-00 00:00:00','{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}','{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}','{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}','65','9','','','1','236','{"robots":"","author":"","rights":"","xreference":""}','0','*',''),
('84','206','All Template\'s Positions','all-template-positions','<p><strong>JM Cleaning Company</strong> Joomla template is using fully responsive layout that adjusts to various screens: desktops, tablets or mobiles.<br /><a title="EF4 Framework" href="http://www.joomla-monster.com/index.php?option=com_content&amp;id=137&amp;view=category&amp;Itemid=548" target="_blank">EF4 Framework</a> includes <a title="Layout Builder" href="http://www.joomla-monster.com/index.php?option=com_content&amp;catid=137&amp;id=901&amp;view=article&amp;Itemid=1034" target="_blank">Layout Builder</a> tool which allows you to customize template layout for different screen dimensions.</p>\r\n','\r\n<p></p>\r\n<h3 style="text-align: center;">Module positions for normal and large screen <small>usually desktop and tablet landscape (980px and higher)</small></h3>\r\n<p></p>\r\n<p style="text-align: center;"><a title="Layout Builder" href="http://www.joomla-monster.com/index.php?option=com_content&amp;catid=137&amp;id=901&amp;view=article&amp;Itemid=1034" target="_blank"><img title="Module positions for normal and large screen" src="images/features/normal-positions.jpg" alt="Module positions for normal and large screen" border="0" /></a></p>\r\n<p style="text-align: center;"><a class="btn" title="Layout Builder" href="http://www.joomla-monster.com/index.php?option=com_content&amp;catid=137&amp;id=901&amp;view=article&amp;Itemid=1034" target="_blank">Check out more details about layout customization!</a></p>\r\n<p></p>\r\n<h3 style="text-align: center;">Module positions for medium screen <small>usually tablet (768px-979px)</small></h3>\r\n<p></p>\r\n<p style="text-align: center;"><a title="Layout Builder" href="http://www.joomla-monster.com/index.php?option=com_content&amp;catid=137&amp;id=901&amp;view=article&amp;Itemid=1034" target="_blank"><img title="Module positions for medium screen" src="images/features/medium-positions.jpg" alt="Module positions for medium screen" border="0" /></a></p>\r\n<p style="text-align: center;"><a class="btn" title="Layout Builder" href="http://www.joomla-monster.com/index.php?option=com_content&amp;catid=137&amp;id=901&amp;view=article&amp;Itemid=1034" target="_blank">Check out more details about layout customization!</a></p>\r\n<p></p>\r\n<h3 style="text-align: center;">Module positions for small screen <small>usually tablet portrait and mobile landscape (481px-767px)</small></h3>\r\n<p></p>\r\n<p style="text-align: center;"><a title="Layout Builder" href="http://www.joomla-monster.com/index.php?option=com_content&amp;catid=137&amp;id=901&amp;view=article&amp;Itemid=1034" target="_blank"><img title="Module positions for small screen" src="images/features/small-positions.jpg" alt="Module positions for small screen" border="0" /></a></p>\r\n<p style="text-align: center;"><a class="btn" title="Layout Builder" href="http://www.joomla-monster.com/index.php?option=com_content&amp;catid=137&amp;id=901&amp;view=article&amp;Itemid=1034" target="_blank">Check out more details about layout customization!</a></p>\r\n<p></p>\r\n<h3 style="text-align: center;">Module positions for extra small screen <small>usually mobile portrait (480px and smaller)</small></h3>\r\n<p></p>\r\n<p style="text-align: center;"><a title="Layout Builder" href="http://www.joomla-monster.com/index.php?option=com_content&amp;catid=137&amp;id=901&amp;view=article&amp;Itemid=1034" target="_blank"><img title="Module positions for extra small screen" src="images/features/extrasmall-positions.jpg" alt="Module positions for extra small screen" border="0" /></a></p>\r\n<p style="text-align: center;"><a class="btn" title="Layout Builder" href="http://www.joomla-monster.com/index.php?option=com_content&amp;catid=137&amp;id=901&amp;view=article&amp;Itemid=1034" target="_blank">Check out more details about layout customization!</a></p>','1','82','2013-11-19 09:38:06','499','','2015-05-06 11:43:50','545','0','0000-00-00 00:00:00','2013-11-19 09:38:06','0000-00-00 00:00:00','{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}','{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}','{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}','7','7','','','1','20','{"robots":"","author":"","rights":"","xreference":""}','0','*',''),
('85','207','Module Suffixes','module-suffixes','<p>There are several available module designs that you can control by entering the correct suffix name to a module parameter.<br /> Let\'s check them all.</p>\r\n','\r\n<p><br />1. Available module designs.</p>\r\n<p><img class="border_img" title="Module designs" src="images/features/module-suffixes.png" alt="module-suffixes" border="0" /></p>\r\n<p><br />2. Use the suffix for Joomla Search module if you want to get the following view. Otherwise the module will use the default css styles.</p>\r\n<p><br /><img class="border_img" src="images/features/search-ms.png" alt="" border="0" /></p>\r\n<p><br /><strong>Suffix name:</strong> search-ms</p>\r\n<p><br />3. Use the suffix for menu module if you want to get the following view. Otherwise the module will use the default css styles.</p>\r\n<p><br /><img class="border_img" src="images/features/tag-ms.png" alt="" border="0" /></p>\r\n<p><br /><strong>Suffix name:</strong> tag-ms</p>\r\n<p><br />5. Use the suffix for module if you want to remove default bottom margin.</p>\r\n<p><br /><strong>Suffix name:</strong> margin-ms</p>\r\n<p><br />6. Additional and very useful suffix to make your modules height the same.<br />You just have to put a suffix at a module configuration to get the specified module height. <br /><br />See here the screenshot:</p>\r\n<p><img class="border_img" title="Module height" src="images/features/height1.jpg" alt="height1" border="0" /></p>\r\n<p><strong>_mod300</strong> means that your module will be of 300 pixels high.<br /><br />If you need to mix suffixes, remember to put that suffix at the end and add space between suffixes, see the example:</p>\r\n<p><img src="images/features/height2.jpg" alt="height2" border="0" /><br /><br /></p>','1','82','2013-11-19 09:39:13','499','','2015-05-07 08:51:04','545','0','0000-00-00 00:00:00','2013-11-19 09:39:13','0000-00-00 00:00:00','{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}','{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}','{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}','19','8','','','1','42','{"robots":"","author":"","rights":"","xreference":""}','0','*',''),
('86','252','Content Area','content-area','<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nulla scelerisque magna et orci porttitor ullamcorper. Proin euismod pretium dolor non consectetur. Aliquam feugiat nunc ac justo hendrerit, non lobortis lacus condimentum. Duis id erat nunc. Nam eu aliquam velit.<br /><br />Pellentesque ligula nisl, hendrerit nec facilisis sit amet, faucibus ac nulla. Morbi et consectetur ante. Etiam eu sodales tortor, ac dapibus lectus. In laoreet tempor felis, in ornare urna consequat sit amet. Praesent vehicula libero ac tellus rutrum ultrices. Sed eu consectetur libero, id varius massa.</p>\r\n<p>Suspendisse urna risus, interdum eu molestie eu, blandit vel orci. Vestibulum erat dui, tristique pharetra pellentesque id, consequat vitae massa.</p>','','1','82','2014-02-12 13:04:13','499','','2014-12-11 10:01:46','182','0','0000-00-00 00:00:00','2014-02-12 13:04:13','0000-00-00 00:00:00','{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}','{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}','{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}','6','6','','','1','1043','{"robots":"","author":"","rights":"","xreference":""}','0','*',''),
('87','253','Single Article','single-article','<p><strong>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nulla scelerisque magna et orci porttitor ullamcorper. Proin euismod pretium dolor non consectetur. Aliquam feugiat nunc ac justo hendrerit, non lobortis lacus condimentum.</strong></p>\r\n<p>Praesent vehicula libero ac tellus rutrum ultrices. Sed eu consectetur libero, id varius massa. Quisque vestibulum tempus felis. Nulla interdum varius arcu nec. Duis id erat nunc. Nam eu aliquam velit. Donec pretium sed quam quis pulvinar. Fusce felis ante, pulvinar ac metus et, adipiscing. Pellentesque ligula nisl, hendrerit nec facilisis sit amet, faucibus ac nulla. Morbi et consectetur ante.</p>\r\n','\r\n<p> </p>\r\n<h4>Lorem ipsum dolor</h4>\r\n<p>Nunc placerat egestas vehicula. Fusce eu risus sit amet metus sagittis volutpat vehicula porttitor elit. Sed fringilla purus sed mi scelerisque scelerisque. Donec vel enim ligula. Phasellus vulputate ac dui aliquet dapibus. Suspendisse ut vestibulum tellus, sed gravida arcu. Aliquam erat volutpat. Cras eu quam vitae magna cursus adipiscing. Etiam quis mi lacus. Proin fermentum velit non ligula malesuada imperdiet. Sed sapien enim, porta vel tempus sed, suscipit quis nisl. In vestibulum ut massa eu feugiat.</p>\r\n<p class="jm-block second"><span class="jm">1</span>Nulla vestibulum ultrices felis sit amet dapibus. Suspendisse et ligula hendrerit, auctor justo vel, sagittis metus. Mauris tincidunt quam eu pulvinar sagittis. Pellentesque imperdiet, purus vel feugiat pharetra, lectus velit scelerisque nisi, a aliquam nibh augue vel urna. In volutpat tellus et pulvinar varius. Aenean ultricies euismod rhoncus.</p>\r\n<p class="jm-block second"><span class="jm">2</span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nulla scelerisque magna et orci porttitor ullamcorper. Proin euismod pretium dolor non consectetur. Aliquam feugiat nunc ac justo hendrerit, non lobortis lacus condimentum. Duis id erat nunc. Nam eu aliquam velit. Donec pretium sed quam quis pulvinar.</p>\r\n<p class="jm-block second"><span class="jm">3</span>Cras eleifend iaculis purus sed hendrerit. Nulla facilisi. Sed congue semper consequat. Nam viverra semper libero, a luctus eros. Nulla porttitor commodo velit nec rhoncus. Vivamus blandit tellus risus, et hendrerit nisi aliquet ut. Ut imperdiet orci tellus, in tristique urna mattis eu.</p>\r\n<p>Nulla vestibulum ultrices felis sit amet dapibus. Suspendisse et ligula hendrerit, auctor justo vel, sagittis metus. Mauris tincidunt quam eu pulvinar sagittis. Pellentesque imperdiet, purus vel feugiat pharetra, lectus velit scelerisque nisi, a aliquam nibh augue vel urna. In volutpat tellus et pulvinar varius. Aenean ultricies euismod rhoncus. Ut lectus felis, facilisis nec erat at, pretium pellentesque lectus. Donec sit amet nibh est. Morbi augue libero, pretium vitae nulla ac, malesuada ultricies neque. Donec eget neque erat. Nam dictum justo sit amet placerat consectetur.</p>\r\n<p> </p>\r\n<h4>Consectetur adipiscing elit</h4>\r\n<p>Cras eleifend iaculis purus sed hendrerit. Nulla facilisi. Sed congue semper consequat. Nam viverra semper libero, a luctus eros. Nulla porttitor commodo velit nec rhoncus. Vivamus blandit tellus risus, et hendrerit nisi aliquet ut. Ut imperdiet orci tellus, in tristique urna mattis eu. Pellentesque ligula nisl, hendrerit nec facilisis sit amet, faucibus ac nulla. Morbi et consectetur ante. Etiam eu sodales tortor, ac dapibus lectus. In laoreet tempor felis, in ornare urna consequat sit amet. Praesent vehicula libero ac tellus rutrum ultrices. Sed eu consectetur libero, id varius massa. Quisque vestibulum tempus felis. Nulla interdum varius arcu nec.</p>\r\n<p class="jmpeople">Ut lectus felis, facilisis nec erat at, pretium pellentesque lectus. Donec sit amet nibh est. Morbi augue libero, pretium vitae nulla ac, malesuada ultricies neque. Praesent vehicula libero ac tellus rutrum ultrices. Sed eu consectetur libero, id varius massa. Nulla interdum varius arcu nec accumsan.</p>\r\n<p class="jmmail">Cras eleifend iaculis purus sed hendrerit. Nulla facilisi. Sed congue semper consequat. Nam viverra semper libero, a luctus eros. Nulla porttitor commodo velit nec rhoncus. Donec sit amet nibh est. Morbi augue libero, pretium vitae nulla ac. Nulla porttitor commodo velit nec rhoncus.</p>\r\n<p>Ut lectus felis, facilisis nec erat at, pretium pellentesque lectus. Donec sit amet nibh est. Morbi augue libero, pretium vitae nulla ac, malesuada ultricies neque. Donec eget neque erat. Nam dictum justo sit amet placerat consectetur. Maecenas laoreet, ligula vel scelerisque ultricies, lorem urna luctus odio, eget convallis urna erat quis justo. Morbi vel placerat nisl, ut tempor odio. Sed lacinia purus sit amet lorem dictum tincidunt.</p>','1','82','2014-02-12 13:05:53','499','','2015-05-06 11:08:03','545','0','0000-00-00 00:00:00','2014-02-12 13:05:53','0000-00-00 00:00:00','{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/modules\\/slider\\/slide1.jpg","float_fulltext":"left","image_fulltext_alt":"Single Article","image_fulltext_caption":""}','{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}','{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}','12','5','','','1','141','{"robots":"","author":"","rights":"","xreference":""}','0','*',''),
('88','254','Tabs / Accordion in article','tabs-accordion-in-article','<hr class="system-pagebreak" title="Tab 1" />\r\n<p>Ut lectus felis, facilisis nec erat at, pretium pellentesque lectus. Donec sit amet nibh est. Morbi augue libero, pretium vitae nulla ac, malesuada ultricies neque. Donec eget neque erat. Nam dictum justo sit amet placerat consectetur.</p>\r\n<p>Maecenas laoreet, ligula vel scelerisque ultricies, lorem urna luctus odio, eget convallis urna erat quis justo. Morbi vel placerat nisl, ut tempor odio. Sed lacinia purus sit amet lorem dictum tincidunt. Nunc placerat egestas vehicula. Fusce eu risus sit amet metus sagittis volutpat vehicula porttitor elit. Sed fringilla purus sed mi scelerisque scelerisque. Donec vel enim ligula. Phasellus vulputate ac dui aliquet dapibus. Suspendisse ut vestibulum tellus, sed gravida arcu. Aliquam erat volutpat.</p>\r\n<p>Donec sit amet eleifend tortor. In mattis velit ut nunc luctus ultrices. Nunc aliquet risus eget lorem dignissim, id imperdiet nulla ultricies. Sed euismod bibendum dui, vel faucibus quam tempor at. Etiam sagittis massa in urna sagittis, non viverra nibh placerat.</p>\r\n<hr class="system-pagebreak" title="Tab 2" />\r\n<p>Cras eu quam vitae magna cursus adipiscing. Etiam quis mi lacus. Proin fermentum velit non ligula malesuada imperdiet. Sed sapien enim, porta vel tempus sed, suscipit quis nisl. In vestibulum ut massa eu feugiat. Nulla vestibulum ultrices felis sit amet dapibus. Suspendisse et ligula hendrerit, auctor justo vel, sagittis metus.</p>\r\n<p>Mauris tincidunt quam eu pulvinar sagittis. Pellentesque imperdiet, purus vel feugiat pharetra, lectus velit scelerisque nisi, a aliquam nibh augue vel urna. In volutpat tellus et pulvinar varius. Aenean ultricies euismod rhoncus.</p>\r\n<p>Nunc tincidunt eros ut mauris ullamcorper, vitae semper ligula convallis. Morbi tincidunt congue venenatis. Fusce at vestibulum nisl, et congue nisi. Vestibulum sollicitudin tellus id arcu vulputate, sit amet vestibulum est pulvinar.</p>\r\n<hr class="system-pagebreak" title="Tab 3" />\r\n<p>Cras eleifend iaculis purus sed hendrerit. Nulla facilisi. Sed congue semper consequat. Nam viverra semper libero, a luctus eros. Nulla porttitor commodo velit nec rhoncus. Vivamus blandit tellus risus, et hendrerit nisi aliquet ut. Ut imperdiet orci tellus, in tristique urna mattis eu. Pellentesque ligula nisl, hendrerit nec facilisis sit amet, faucibus ac nulla.</p>\r\n<p>Morbi et consectetur ante. Etiam eu sodales tortor, ac dapibus lectus. In laoreet tempor felis, in ornare urna consequat sit amet. Praesent vehicula libero ac tellus rutrum ultrices. Sed eu consectetur libero, id varius massa. Quisque vestibulum tempus felis. Nulla interdum varius arcu nec accumsan.</p>\r\n<p>Suspendisse pellentesque placerat risus id porttitor. Morbi elit nulla, tincidunt sit amet justo sit amet, adipiscing molestie quam. Proin hendrerit eleifend egestas. In erat enim, ultricies nec nunc mattis, sodales placerat lacus. Nam ultrices adipiscing volutpat.</p>','','1','82','2014-02-12 13:06:38','499','','2014-12-12 10:17:44','182','0','0000-00-00 00:00:00','2014-02-12 13:06:38','0000-00-00 00:00:00','{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}','{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}','{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}','4','4','','','1','46','{"robots":"","author":"","rights":"","xreference":""}','0','*',''),
('89','255','Blog Article 1','blog-article-1','<p><strong>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nulla scelerisque magna et orci porttitor ullamcorper. Proin euismod pretium dolor non consectetur. Aliquam feugiat nunc ac justo hendrerit, non lobortis lacus condimentum.</strong></p>\r\n<p>Praesent vehicula libero ac tellus rutrum ultrices. Sed eu consectetur libero, id varius massa. Quisque vestibulum tempus felis. Nulla interdum varius arcu nec. Duis id erat nunc. Nam eu aliquam velit. Donec pretium sed quam quis pulvinar. Fusce felis ante, pulvinar ac metus et, adipiscing consequat lectus. Integer quam nibh, varius nec lacus elementum, bibendum posuere ante. Mauris vehicula.</p>\r\n','\r\n<p>Ut lectus felis, facilisis nec erat at, pretium pellentesque lectus. Donec sit amet nibh est. Morbi augue libero, pretium vitae nulla ac, malesuada ultricies neque. Donec eget neque erat. Nam dictum justo sit amet placerat consectetur. Maecenas laoreet, ligula vel scelerisque ultricies, lorem urna luctus odio, eget convallis. Quisque vestibulum tempus felis. Nulla interdum varius arcu nec. Duis id erat nunc.</p>\r\n<p> </p>\r\n<h4>Lorem ipsum dolor</h4>\r\n<p>Nunc placerat egestas vehicula. Fusce eu risus sit amet metus sagittis volutpat vehicula porttitor elit. Sed fringilla purus sed mi scelerisque scelerisque. Donec vel enim ligula. Phasellus vulputate ac dui aliquet dapibus. Suspendisse ut vestibulum tellus, sed gravida arcu. Aliquam erat volutpat. Cras eu quam vitae magna cursus adipiscing. Etiam quis mi lacus. Proin fermentum velit non ligula malesuada imperdiet. Sed sapien enim, porta vel tempus sed, suscipit quis nisl. In vestibulum ut massa eu feugiat.</p>\r\n<p class="jm-block second"><span class="jm">1</span>Nulla vestibulum ultrices felis sit amet dapibus. Suspendisse et ligula hendrerit, auctor justo vel, sagittis metus. Mauris tincidunt quam eu pulvinar sagittis. Pellentesque imperdiet, purus vel feugiat pharetra, lectus velit scelerisque nisi, a aliquam nibh augue vel urna. In volutpat tellus et pulvinar varius. Aenean ultricies euismod rhoncus.</p>\r\n<p class="jm-block second"><span class="jm">2</span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nulla scelerisque magna et orci porttitor ullamcorper. Proin euismod pretium dolor non consectetur. Aliquam feugiat nunc ac justo hendrerit, non lobortis lacus condimentum. Duis id erat nunc. Nam eu aliquam velit. Donec pretium sed quam quis pulvinar.</p>\r\n<p class="jm-block second"><span class="jm">3</span>Cras eleifend iaculis purus sed hendrerit. Nulla facilisi. Sed congue semper consequat. Nam viverra semper libero, a luctus eros. Nulla porttitor commodo velit nec rhoncus. Vivamus blandit tellus risus, et hendrerit nisi aliquet ut. Ut imperdiet orci tellus, in tristique urna mattis eu.</p>\r\n<p>Nulla vestibulum ultrices felis sit amet dapibus. Suspendisse et ligula hendrerit, auctor justo vel, sagittis metus. Mauris tincidunt quam eu pulvinar sagittis. Pellentesque imperdiet, purus vel feugiat pharetra, lectus velit scelerisque nisi, a aliquam nibh augue vel urna. In volutpat tellus et pulvinar varius. Aenean ultricies euismod rhoncus. Ut lectus felis, facilisis nec erat at, pretium pellentesque lectus. Donec sit amet nibh est. Morbi augue libero, pretium vitae nulla ac, malesuada ultricies neque. Donec eget neque erat. Nam dictum justo sit amet placerat consectetur.</p>\r\n<p> </p>\r\n<h4>Consectetur adipiscing elit</h4>\r\n<p>Cras eleifend iaculis purus sed hendrerit. Nulla facilisi. Sed congue semper consequat. Nam viverra semper libero, a luctus eros. Nulla porttitor commodo velit nec rhoncus. Vivamus blandit tellus risus, et hendrerit nisi aliquet ut. Ut imperdiet orci tellus, in tristique urna mattis eu. Pellentesque ligula nisl, hendrerit nec facilisis sit amet, faucibus ac nulla. Morbi et consectetur ante. Etiam eu sodales tortor, ac dapibus lectus. In laoreet tempor felis, in ornare urna consequat sit amet. Praesent vehicula libero ac tellus rutrum ultrices. Sed eu consectetur libero, id varius massa. Quisque vestibulum tempus felis. Nulla interdum varius arcu nec.</p>\r\n<p class="jmpeople">Ut lectus felis, facilisis nec erat at, pretium pellentesque lectus. Donec sit amet nibh est. Morbi augue libero, pretium vitae nulla ac, malesuada ultricies neque. Praesent vehicula libero ac tellus rutrum ultrices. Sed eu consectetur libero, id varius massa. Nulla interdum varius arcu nec accumsan.</p>\r\n<p class="jmmail">Cras eleifend iaculis purus sed hendrerit. Nulla facilisi. Sed congue semper consequat. Nam viverra semper libero, a luctus eros. Nulla porttitor commodo velit nec rhoncus. Donec sit amet nibh est. Morbi augue libero, pretium vitae nulla ac. Nulla porttitor commodo velit nec rhoncus.</p>\r\n<p>Ut lectus felis, facilisis nec erat at, pretium pellentesque lectus. Donec sit amet nibh est. Morbi augue libero, pretium vitae nulla ac, malesuada ultricies neque. Donec eget neque erat. Nam dictum justo sit amet placerat consectetur. Maecenas laoreet, ligula vel scelerisque ultricies, lorem urna luctus odio, eget convallis urna erat quis justo. Morbi vel placerat nisl, ut tempor odio. Sed lacinia purus sit amet lorem dictum tincidunt.</p>','1','83','2014-02-12 13:08:13','499','','2014-12-16 07:51:00','182','0','0000-00-00 00:00:00','2014-02-12 13:08:13','0000-00-00 00:00:00','{"image_intro":"images\\/modules\\/article1.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/modules\\/slider\\/slide4.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}','{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}','{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}','5','8','','','1','0','{"robots":"","author":"","rights":"","xreference":""}','0','*',''),
('90','256','Blog Article 2','blog-article-2','<p><strong>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nulla scelerisque magna et orci porttitor ullamcorper. Proin euismod pretium dolor non consectetur. Aliquam feugiat nunc ac justo hendrerit, non lobortis lacus condimentum.</strong></p>\r\n<p>Praesent vehicula libero ac tellus rutrum ultrices. Sed eu consectetur libero, id varius massa. Quisque vestibulum tempus felis. Nulla interdum varius arcu nec. Duis id erat nunc. Nam eu aliquam velit. Donec pretium sed quam quis pulvinar. Fusce felis ante, pulvinar ac metus et, adipiscing consequat lectus. Integer quam nibh, varius nec lacus elementum, bibendum posuere ante. Mauris vehicula.</p>\r\n','\r\n<p>Ut lectus felis, facilisis nec erat at, pretium pellentesque lectus. Donec sit amet nibh est. Morbi augue libero, pretium vitae nulla ac, malesuada ultricies neque. Donec eget neque erat. Nam dictum justo sit amet placerat consectetur. Maecenas laoreet, ligula vel scelerisque ultricies, lorem urna luctus odio, eget convallis. Quisque vestibulum tempus felis. Nulla interdum varius arcu nec. Duis id erat nunc.</p>\r\n<p> </p>\r\n<h4>Lorem ipsum dolor</h4>\r\n<p>Nunc placerat egestas vehicula. Fusce eu risus sit amet metus sagittis volutpat vehicula porttitor elit. Sed fringilla purus sed mi scelerisque scelerisque. Donec vel enim ligula. Phasellus vulputate ac dui aliquet dapibus. Suspendisse ut vestibulum tellus, sed gravida arcu. Aliquam erat volutpat. Cras eu quam vitae magna cursus adipiscing. Etiam quis mi lacus. Proin fermentum velit non ligula malesuada imperdiet. Sed sapien enim, porta vel tempus sed, suscipit quis nisl. In vestibulum ut massa eu feugiat.</p>\r\n<p class="jm-block second"><span class="jm">1</span>Nulla vestibulum ultrices felis sit amet dapibus. Suspendisse et ligula hendrerit, auctor justo vel, sagittis metus. Mauris tincidunt quam eu pulvinar sagittis. Pellentesque imperdiet, purus vel feugiat pharetra, lectus velit scelerisque nisi, a aliquam nibh augue vel urna. In volutpat tellus et pulvinar varius. Aenean ultricies euismod rhoncus.</p>\r\n<p class="jm-block second"><span class="jm">2</span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nulla scelerisque magna et orci porttitor ullamcorper. Proin euismod pretium dolor non consectetur. Aliquam feugiat nunc ac justo hendrerit, non lobortis lacus condimentum. Duis id erat nunc. Nam eu aliquam velit. Donec pretium sed quam quis pulvinar.</p>\r\n<p class="jm-block second"><span class="jm">3</span>Cras eleifend iaculis purus sed hendrerit. Nulla facilisi. Sed congue semper consequat. Nam viverra semper libero, a luctus eros. Nulla porttitor commodo velit nec rhoncus. Vivamus blandit tellus risus, et hendrerit nisi aliquet ut. Ut imperdiet orci tellus, in tristique urna mattis eu.</p>\r\n<p>Nulla vestibulum ultrices felis sit amet dapibus. Suspendisse et ligula hendrerit, auctor justo vel, sagittis metus. Mauris tincidunt quam eu pulvinar sagittis. Pellentesque imperdiet, purus vel feugiat pharetra, lectus velit scelerisque nisi, a aliquam nibh augue vel urna. In volutpat tellus et pulvinar varius. Aenean ultricies euismod rhoncus. Ut lectus felis, facilisis nec erat at, pretium pellentesque lectus. Donec sit amet nibh est. Morbi augue libero, pretium vitae nulla ac, malesuada ultricies neque. Donec eget neque erat. Nam dictum justo sit amet placerat consectetur.</p>\r\n<p> </p>\r\n<h4>Consectetur adipiscing elit</h4>\r\n<p>Cras eleifend iaculis purus sed hendrerit. Nulla facilisi. Sed congue semper consequat. Nam viverra semper libero, a luctus eros. Nulla porttitor commodo velit nec rhoncus. Vivamus blandit tellus risus, et hendrerit nisi aliquet ut. Ut imperdiet orci tellus, in tristique urna mattis eu. Pellentesque ligula nisl, hendrerit nec facilisis sit amet, faucibus ac nulla. Morbi et consectetur ante. Etiam eu sodales tortor, ac dapibus lectus. In laoreet tempor felis, in ornare urna consequat sit amet. Praesent vehicula libero ac tellus rutrum ultrices. Sed eu consectetur libero, id varius massa. Quisque vestibulum tempus felis. Nulla interdum varius arcu nec.</p>\r\n<p class="jmpeople">Ut lectus felis, facilisis nec erat at, pretium pellentesque lectus. Donec sit amet nibh est. Morbi augue libero, pretium vitae nulla ac, malesuada ultricies neque. Praesent vehicula libero ac tellus rutrum ultrices. Sed eu consectetur libero, id varius massa. Nulla interdum varius arcu nec accumsan.</p>\r\n<p class="jmmail">Cras eleifend iaculis purus sed hendrerit. Nulla facilisi. Sed congue semper consequat. Nam viverra semper libero, a luctus eros. Nulla porttitor commodo velit nec rhoncus. Donec sit amet nibh est. Morbi augue libero, pretium vitae nulla ac. Nulla porttitor commodo velit nec rhoncus.</p>\r\n<p>Ut lectus felis, facilisis nec erat at, pretium pellentesque lectus. Donec sit amet nibh est. Morbi augue libero, pretium vitae nulla ac, malesuada ultricies neque. Donec eget neque erat. Nam dictum justo sit amet placerat consectetur. Maecenas laoreet, ligula vel scelerisque ultricies, lorem urna luctus odio, eget convallis urna erat quis justo. Morbi vel placerat nisl, ut tempor odio. Sed lacinia purus sit amet lorem dictum tincidunt.</p>','1','83','2014-02-12 13:08:30','499','','2014-12-16 07:50:44','182','0','0000-00-00 00:00:00','2014-02-12 13:08:30','0000-00-00 00:00:00','{"image_intro":"images\\/modules\\/article1.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/modules\\/slider\\/slide3.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}','{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}','{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}','5','7','','','1','0','{"robots":"","author":"","rights":"","xreference":""}','0','*',''),
('91','257','Blog Article 3','blog-article-3','<p><strong>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nulla scelerisque magna et orci porttitor ullamcorper. Proin euismod pretium dolor non consectetur. Aliquam feugiat nunc ac justo hendrerit, non lobortis lacus condimentum.</strong></p>\r\n<p>Praesent vehicula libero ac tellus rutrum ultrices. Sed eu consectetur libero, id varius massa. Quisque vestibulum tempus felis. Nulla interdum varius arcu nec. Duis id erat nunc. Nam eu aliquam velit. Donec pretium sed quam quis pulvinar. Fusce felis ante, pulvinar ac metus et, adipiscing consequat lectus. Integer quam nibh, varius nec lacus elementum, bibendum posuere ante. Mauris vehicula.</p>\r\n','\r\n<p>Ut lectus felis, facilisis nec erat at, pretium pellentesque lectus. Donec sit amet nibh est. Morbi augue libero, pretium vitae nulla ac, malesuada ultricies neque. Donec eget neque erat. Nam dictum justo sit amet placerat consectetur. Maecenas laoreet, ligula vel scelerisque ultricies, lorem urna luctus odio, eget convallis. Quisque vestibulum tempus felis. Nulla interdum varius arcu nec. Duis id erat nunc.</p>\r\n<p> </p>\r\n<h4>Lorem ipsum dolor</h4>\r\n<p>Nunc placerat egestas vehicula. Fusce eu risus sit amet metus sagittis volutpat vehicula porttitor elit. Sed fringilla purus sed mi scelerisque scelerisque. Donec vel enim ligula. Phasellus vulputate ac dui aliquet dapibus. Suspendisse ut vestibulum tellus, sed gravida arcu. Aliquam erat volutpat. Cras eu quam vitae magna cursus adipiscing. Etiam quis mi lacus. Proin fermentum velit non ligula malesuada imperdiet. Sed sapien enim, porta vel tempus sed, suscipit quis nisl. In vestibulum ut massa eu feugiat.</p>\r\n<p class="jm-block second"><span class="jm">1</span>Nulla vestibulum ultrices felis sit amet dapibus. Suspendisse et ligula hendrerit, auctor justo vel, sagittis metus. Mauris tincidunt quam eu pulvinar sagittis. Pellentesque imperdiet, purus vel feugiat pharetra, lectus velit scelerisque nisi, a aliquam nibh augue vel urna. In volutpat tellus et pulvinar varius. Aenean ultricies euismod rhoncus.</p>\r\n<p class="jm-block second"><span class="jm">2</span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nulla scelerisque magna et orci porttitor ullamcorper. Proin euismod pretium dolor non consectetur. Aliquam feugiat nunc ac justo hendrerit, non lobortis lacus condimentum. Duis id erat nunc. Nam eu aliquam velit. Donec pretium sed quam quis pulvinar.</p>\r\n<p class="jm-block second"><span class="jm">3</span>Cras eleifend iaculis purus sed hendrerit. Nulla facilisi. Sed congue semper consequat. Nam viverra semper libero, a luctus eros. Nulla porttitor commodo velit nec rhoncus. Vivamus blandit tellus risus, et hendrerit nisi aliquet ut. Ut imperdiet orci tellus, in tristique urna mattis eu.</p>\r\n<p>Nulla vestibulum ultrices felis sit amet dapibus. Suspendisse et ligula hendrerit, auctor justo vel, sagittis metus. Mauris tincidunt quam eu pulvinar sagittis. Pellentesque imperdiet, purus vel feugiat pharetra, lectus velit scelerisque nisi, a aliquam nibh augue vel urna. In volutpat tellus et pulvinar varius. Aenean ultricies euismod rhoncus. Ut lectus felis, facilisis nec erat at, pretium pellentesque lectus. Donec sit amet nibh est. Morbi augue libero, pretium vitae nulla ac, malesuada ultricies neque. Donec eget neque erat. Nam dictum justo sit amet placerat consectetur.</p>\r\n<p> </p>\r\n<h4>Consectetur adipiscing elit</h4>\r\n<p>Cras eleifend iaculis purus sed hendrerit. Nulla facilisi. Sed congue semper consequat. Nam viverra semper libero, a luctus eros. Nulla porttitor commodo velit nec rhoncus. Vivamus blandit tellus risus, et hendrerit nisi aliquet ut. Ut imperdiet orci tellus, in tristique urna mattis eu. Pellentesque ligula nisl, hendrerit nec facilisis sit amet, faucibus ac nulla. Morbi et consectetur ante. Etiam eu sodales tortor, ac dapibus lectus. In laoreet tempor felis, in ornare urna consequat sit amet. Praesent vehicula libero ac tellus rutrum ultrices. Sed eu consectetur libero, id varius massa. Quisque vestibulum tempus felis. Nulla interdum varius arcu nec.</p>\r\n<p class="jmpeople">Ut lectus felis, facilisis nec erat at, pretium pellentesque lectus. Donec sit amet nibh est. Morbi augue libero, pretium vitae nulla ac, malesuada ultricies neque. Praesent vehicula libero ac tellus rutrum ultrices. Sed eu consectetur libero, id varius massa. Nulla interdum varius arcu nec accumsan.</p>\r\n<p class="jmmail">Cras eleifend iaculis purus sed hendrerit. Nulla facilisi. Sed congue semper consequat. Nam viverra semper libero, a luctus eros. Nulla porttitor commodo velit nec rhoncus. Donec sit amet nibh est. Morbi augue libero, pretium vitae nulla ac. Nulla porttitor commodo velit nec rhoncus.</p>\r\n<p>Ut lectus felis, facilisis nec erat at, pretium pellentesque lectus. Donec sit amet nibh est. Morbi augue libero, pretium vitae nulla ac, malesuada ultricies neque. Donec eget neque erat. Nam dictum justo sit amet placerat consectetur. Maecenas laoreet, ligula vel scelerisque ultricies, lorem urna luctus odio, eget convallis urna erat quis justo. Morbi vel placerat nisl, ut tempor odio. Sed lacinia purus sit amet lorem dictum tincidunt.</p>','1','83','2014-02-12 13:08:46','499','','2014-12-16 07:50:28','182','0','0000-00-00 00:00:00','2014-02-12 13:08:46','0000-00-00 00:00:00','{"image_intro":"images\\/modules\\/article1.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/modules\\/slider\\/slide2.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}','{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}','{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}','5','6','','','1','0','{"robots":"","author":"","rights":"","xreference":""}','0','*',''),
('92','258','Blog Article 4','blog-article-4','<p><strong>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nulla scelerisque magna et orci porttitor ullamcorper. Proin euismod pretium dolor non consectetur. Aliquam feugiat nunc ac justo hendrerit, non lobortis lacus condimentum.</strong></p>\r\n<p>Praesent vehicula libero ac tellus rutrum ultrices. Sed eu consectetur libero, id varius massa. Quisque vestibulum tempus felis. Nulla interdum varius arcu nec. Duis id erat nunc. Nam eu aliquam velit. Donec pretium sed quam quis pulvinar. Fusce felis ante, pulvinar ac metus et, adipiscing consequat lectus. Integer quam nibh, varius nec lacus elementum, bibendum posuere ante. Mauris vehicula.</p>\r\n','\r\n<p>Ut lectus felis, facilisis nec erat at, pretium pellentesque lectus. Donec sit amet nibh est. Morbi augue libero, pretium vitae nulla ac, malesuada ultricies neque. Donec eget neque erat. Nam dictum justo sit amet placerat consectetur. Maecenas laoreet, ligula vel scelerisque ultricies, lorem urna luctus odio, eget convallis. Quisque vestibulum tempus felis. Nulla interdum varius arcu nec. Duis id erat nunc.</p>\r\n<p> </p>\r\n<h4>Lorem ipsum dolor</h4>\r\n<p>Nunc placerat egestas vehicula. Fusce eu risus sit amet metus sagittis volutpat vehicula porttitor elit. Sed fringilla purus sed mi scelerisque scelerisque. Donec vel enim ligula. Phasellus vulputate ac dui aliquet dapibus. Suspendisse ut vestibulum tellus, sed gravida arcu. Aliquam erat volutpat. Cras eu quam vitae magna cursus adipiscing. Etiam quis mi lacus. Proin fermentum velit non ligula malesuada imperdiet. Sed sapien enim, porta vel tempus sed, suscipit quis nisl. In vestibulum ut massa eu feugiat.</p>\r\n<p class="jm-block second"><span class="jm">1</span>Nulla vestibulum ultrices felis sit amet dapibus. Suspendisse et ligula hendrerit, auctor justo vel, sagittis metus. Mauris tincidunt quam eu pulvinar sagittis. Pellentesque imperdiet, purus vel feugiat pharetra, lectus velit scelerisque nisi, a aliquam nibh augue vel urna. In volutpat tellus et pulvinar varius. Aenean ultricies euismod rhoncus.</p>\r\n<p class="jm-block second"><span class="jm">2</span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nulla scelerisque magna et orci porttitor ullamcorper. Proin euismod pretium dolor non consectetur. Aliquam feugiat nunc ac justo hendrerit, non lobortis lacus condimentum. Duis id erat nunc. Nam eu aliquam velit. Donec pretium sed quam quis pulvinar.</p>\r\n<p class="jm-block second"><span class="jm">3</span>Cras eleifend iaculis purus sed hendrerit. Nulla facilisi. Sed congue semper consequat. Nam viverra semper libero, a luctus eros. Nulla porttitor commodo velit nec rhoncus. Vivamus blandit tellus risus, et hendrerit nisi aliquet ut. Ut imperdiet orci tellus, in tristique urna mattis eu.</p>\r\n<p>Nulla vestibulum ultrices felis sit amet dapibus. Suspendisse et ligula hendrerit, auctor justo vel, sagittis metus. Mauris tincidunt quam eu pulvinar sagittis. Pellentesque imperdiet, purus vel feugiat pharetra, lectus velit scelerisque nisi, a aliquam nibh augue vel urna. In volutpat tellus et pulvinar varius. Aenean ultricies euismod rhoncus. Ut lectus felis, facilisis nec erat at, pretium pellentesque lectus. Donec sit amet nibh est. Morbi augue libero, pretium vitae nulla ac, malesuada ultricies neque. Donec eget neque erat. Nam dictum justo sit amet placerat consectetur.</p>\r\n<p> </p>\r\n<h4>Consectetur adipiscing elit</h4>\r\n<p>Cras eleifend iaculis purus sed hendrerit. Nulla facilisi. Sed congue semper consequat. Nam viverra semper libero, a luctus eros. Nulla porttitor commodo velit nec rhoncus. Vivamus blandit tellus risus, et hendrerit nisi aliquet ut. Ut imperdiet orci tellus, in tristique urna mattis eu. Pellentesque ligula nisl, hendrerit nec facilisis sit amet, faucibus ac nulla. Morbi et consectetur ante. Etiam eu sodales tortor, ac dapibus lectus. In laoreet tempor felis, in ornare urna consequat sit amet. Praesent vehicula libero ac tellus rutrum ultrices. Sed eu consectetur libero, id varius massa. Quisque vestibulum tempus felis. Nulla interdum varius arcu nec.</p>\r\n<p class="jmpeople">Ut lectus felis, facilisis nec erat at, pretium pellentesque lectus. Donec sit amet nibh est. Morbi augue libero, pretium vitae nulla ac, malesuada ultricies neque. Praesent vehicula libero ac tellus rutrum ultrices. Sed eu consectetur libero, id varius massa. Nulla interdum varius arcu nec accumsan.</p>\r\n<p class="jmmail">Cras eleifend iaculis purus sed hendrerit. Nulla facilisi. Sed congue semper consequat. Nam viverra semper libero, a luctus eros. Nulla porttitor commodo velit nec rhoncus. Donec sit amet nibh est. Morbi augue libero, pretium vitae nulla ac. Nulla porttitor commodo velit nec rhoncus.</p>\r\n<p>Ut lectus felis, facilisis nec erat at, pretium pellentesque lectus. Donec sit amet nibh est. Morbi augue libero, pretium vitae nulla ac, malesuada ultricies neque. Donec eget neque erat. Nam dictum justo sit amet placerat consectetur. Maecenas laoreet, ligula vel scelerisque ultricies, lorem urna luctus odio, eget convallis urna erat quis justo. Morbi vel placerat nisl, ut tempor odio. Sed lacinia purus sit amet lorem dictum tincidunt.</p>','1','83','2014-02-12 13:09:01','499','','2014-12-16 07:50:12','182','0','0000-00-00 00:00:00','2014-02-12 13:09:01','0000-00-00 00:00:00','{"image_intro":"images\\/modules\\/article1.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/modules\\/slider\\/slide1.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}','{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}','{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}','5','5','','','1','0','{"robots":"","author":"","rights":"","xreference":""}','0','*',''),
('93','259','Blog Article 5','blog-article-5','<p><strong>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nulla scelerisque magna et orci porttitor ullamcorper. Proin euismod pretium dolor non consectetur. Aliquam feugiat nunc ac justo hendrerit, non lobortis lacus condimentum.</strong></p>\r\n<p>Praesent vehicula libero ac tellus rutrum ultrices. Sed eu consectetur libero, id varius massa. Quisque vestibulum tempus felis. Nulla interdum varius arcu nec. Duis id erat nunc. Nam eu aliquam velit. Donec pretium sed quam quis pulvinar. Fusce felis ante, pulvinar ac metus et, adipiscing consequat lectus. Integer quam nibh, varius nec lacus elementum, bibendum posuere ante. Mauris vehicula.</p>\r\n','\r\n<p>Ut lectus felis, facilisis nec erat at, pretium pellentesque lectus. Donec sit amet nibh est. Morbi augue libero, pretium vitae nulla ac, malesuada ultricies neque. Donec eget neque erat. Nam dictum justo sit amet placerat consectetur. Maecenas laoreet, ligula vel scelerisque ultricies, lorem urna luctus odio, eget convallis. Quisque vestibulum tempus felis. Nulla interdum varius arcu nec. Duis id erat nunc.</p>\r\n<p> </p>\r\n<h4>Lorem ipsum dolor</h4>\r\n<p>Nunc placerat egestas vehicula. Fusce eu risus sit amet metus sagittis volutpat vehicula porttitor elit. Sed fringilla purus sed mi scelerisque scelerisque. Donec vel enim ligula. Phasellus vulputate ac dui aliquet dapibus. Suspendisse ut vestibulum tellus, sed gravida arcu. Aliquam erat volutpat. Cras eu quam vitae magna cursus adipiscing. Etiam quis mi lacus. Proin fermentum velit non ligula malesuada imperdiet. Sed sapien enim, porta vel tempus sed, suscipit quis nisl. In vestibulum ut massa eu feugiat.</p>\r\n<p class="jm-block second"><span class="jm">1</span>Nulla vestibulum ultrices felis sit amet dapibus. Suspendisse et ligula hendrerit, auctor justo vel, sagittis metus. Mauris tincidunt quam eu pulvinar sagittis. Pellentesque imperdiet, purus vel feugiat pharetra, lectus velit scelerisque nisi, a aliquam nibh augue vel urna. In volutpat tellus et pulvinar varius. Aenean ultricies euismod rhoncus.</p>\r\n<p class="jm-block second"><span class="jm">2</span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nulla scelerisque magna et orci porttitor ullamcorper. Proin euismod pretium dolor non consectetur. Aliquam feugiat nunc ac justo hendrerit, non lobortis lacus condimentum. Duis id erat nunc. Nam eu aliquam velit. Donec pretium sed quam quis pulvinar.</p>\r\n<p class="jm-block second"><span class="jm">3</span>Cras eleifend iaculis purus sed hendrerit. Nulla facilisi. Sed congue semper consequat. Nam viverra semper libero, a luctus eros. Nulla porttitor commodo velit nec rhoncus. Vivamus blandit tellus risus, et hendrerit nisi aliquet ut. Ut imperdiet orci tellus, in tristique urna mattis eu.</p>\r\n<p>Nulla vestibulum ultrices felis sit amet dapibus. Suspendisse et ligula hendrerit, auctor justo vel, sagittis metus. Mauris tincidunt quam eu pulvinar sagittis. Pellentesque imperdiet, purus vel feugiat pharetra, lectus velit scelerisque nisi, a aliquam nibh augue vel urna. In volutpat tellus et pulvinar varius. Aenean ultricies euismod rhoncus. Ut lectus felis, facilisis nec erat at, pretium pellentesque lectus. Donec sit amet nibh est. Morbi augue libero, pretium vitae nulla ac, malesuada ultricies neque. Donec eget neque erat. Nam dictum justo sit amet placerat consectetur.</p>\r\n<p> </p>\r\n<h4>Consectetur adipiscing elit</h4>\r\n<p>Cras eleifend iaculis purus sed hendrerit. Nulla facilisi. Sed congue semper consequat. Nam viverra semper libero, a luctus eros. Nulla porttitor commodo velit nec rhoncus. Vivamus blandit tellus risus, et hendrerit nisi aliquet ut. Ut imperdiet orci tellus, in tristique urna mattis eu. Pellentesque ligula nisl, hendrerit nec facilisis sit amet, faucibus ac nulla. Morbi et consectetur ante. Etiam eu sodales tortor, ac dapibus lectus. In laoreet tempor felis, in ornare urna consequat sit amet. Praesent vehicula libero ac tellus rutrum ultrices. Sed eu consectetur libero, id varius massa. Quisque vestibulum tempus felis. Nulla interdum varius arcu nec.</p>\r\n<p class="jmpeople">Ut lectus felis, facilisis nec erat at, pretium pellentesque lectus. Donec sit amet nibh est. Morbi augue libero, pretium vitae nulla ac, malesuada ultricies neque. Praesent vehicula libero ac tellus rutrum ultrices. Sed eu consectetur libero, id varius massa. Nulla interdum varius arcu nec accumsan.</p>\r\n<p class="jmmail">Cras eleifend iaculis purus sed hendrerit. Nulla facilisi. Sed congue semper consequat. Nam viverra semper libero, a luctus eros. Nulla porttitor commodo velit nec rhoncus. Donec sit amet nibh est. Morbi augue libero, pretium vitae nulla ac. Nulla porttitor commodo velit nec rhoncus.</p>\r\n<p>Ut lectus felis, facilisis nec erat at, pretium pellentesque lectus. Donec sit amet nibh est. Morbi augue libero, pretium vitae nulla ac, malesuada ultricies neque. Donec eget neque erat. Nam dictum justo sit amet placerat consectetur. Maecenas laoreet, ligula vel scelerisque ultricies, lorem urna luctus odio, eget convallis urna erat quis justo. Morbi vel placerat nisl, ut tempor odio. Sed lacinia purus sit amet lorem dictum tincidunt.</p>','1','83','2014-02-12 13:09:16','499','','2014-12-16 07:49:55','182','0','0000-00-00 00:00:00','2014-02-12 13:09:16','0000-00-00 00:00:00','{"image_intro":"images\\/modules\\/article1.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/modules\\/slider\\/slide4.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}','{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}','{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}','5','4','','','1','4','{"robots":"","author":"","rights":"","xreference":""}','0','*',''),
('94','260','Blog Article 6','blog-article-6','<p><strong>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nulla scelerisque magna et orci porttitor ullamcorper. Proin euismod pretium dolor non consectetur. Aliquam feugiat nunc ac justo hendrerit, non lobortis lacus.</strong></p>\r\n<p>Praesent vehicula libero ac tellus rutrum ultrices. Sed eu consectetur libero, id varius massa. Quisque vestibulum tempus felis. Nulla interdum varius arcu nec. Duis id erat nunc. Nam eu aliquam velit. Donec pretium sed quam quis pulvinar. Fusce felis ante, pulvinar ac metus et, adipiscing consequat lectus. Integer quam nibh, varius nec lacus elementum, bibendum posuere ante.</p>\r\n','\r\n<p>Ut lectus felis, facilisis nec erat at, pretium pellentesque lectus. Donec sit amet nibh est. Morbi augue libero, pretium vitae nulla ac, malesuada ultricies neque. Donec eget neque erat. Nam dictum justo sit amet placerat consectetur. Maecenas laoreet, ligula vel scelerisque ultricies, lorem urna luctus odio, eget convallis. Quisque vestibulum tempus felis. Nulla interdum varius arcu nec. Duis id erat nunc.</p>\r\n<p> </p>\r\n<h4>Lorem ipsum dolor</h4>\r\n<p>Nunc placerat egestas vehicula. Fusce eu risus sit amet metus sagittis volutpat vehicula porttitor elit. Sed fringilla purus sed mi scelerisque scelerisque. Donec vel enim ligula. Phasellus vulputate ac dui aliquet dapibus. Suspendisse ut vestibulum tellus, sed gravida arcu. Aliquam erat volutpat. Cras eu quam vitae magna cursus adipiscing. Etiam quis mi lacus. Proin fermentum velit non ligula malesuada imperdiet. Sed sapien enim, porta vel tempus sed, suscipit quis nisl. In vestibulum ut massa eu feugiat.</p>\r\n<p class="jm-block second"><span class="jm">1</span>Nulla vestibulum ultrices felis sit amet dapibus. Suspendisse et ligula hendrerit, auctor justo vel, sagittis metus. Mauris tincidunt quam eu pulvinar sagittis. Pellentesque imperdiet, purus vel feugiat pharetra, lectus velit scelerisque nisi, a aliquam nibh augue vel urna. In volutpat tellus et pulvinar varius. Aenean ultricies euismod rhoncus.</p>\r\n<p class="jm-block second"><span class="jm">2</span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nulla scelerisque magna et orci porttitor ullamcorper. Proin euismod pretium dolor non consectetur. Aliquam feugiat nunc ac justo hendrerit, non lobortis lacus condimentum. Duis id erat nunc. Nam eu aliquam velit. Donec pretium sed quam quis pulvinar.</p>\r\n<p class="jm-block second"><span class="jm">3</span>Cras eleifend iaculis purus sed hendrerit. Nulla facilisi. Sed congue semper consequat. Nam viverra semper libero, a luctus eros. Nulla porttitor commodo velit nec rhoncus. Vivamus blandit tellus risus, et hendrerit nisi aliquet ut. Ut imperdiet orci tellus, in tristique urna mattis eu.</p>\r\n<p>Nulla vestibulum ultrices felis sit amet dapibus. Suspendisse et ligula hendrerit, auctor justo vel, sagittis metus. Mauris tincidunt quam eu pulvinar sagittis. Pellentesque imperdiet, purus vel feugiat pharetra, lectus velit scelerisque nisi, a aliquam nibh augue vel urna. In volutpat tellus et pulvinar varius. Aenean ultricies euismod rhoncus. Ut lectus felis, facilisis nec erat at, pretium pellentesque lectus. Donec sit amet nibh est. Morbi augue libero, pretium vitae nulla ac, malesuada ultricies neque. Donec eget neque erat. Nam dictum justo sit amet placerat consectetur.</p>\r\n<p> </p>\r\n<h4>Consectetur adipiscing elit</h4>\r\n<p>Cras eleifend iaculis purus sed hendrerit. Nulla facilisi. Sed congue semper consequat. Nam viverra semper libero, a luctus eros. Nulla porttitor commodo velit nec rhoncus. Vivamus blandit tellus risus, et hendrerit nisi aliquet ut. Ut imperdiet orci tellus, in tristique urna mattis eu. Pellentesque ligula nisl, hendrerit nec facilisis sit amet, faucibus ac nulla. Morbi et consectetur ante. Etiam eu sodales tortor, ac dapibus lectus. In laoreet tempor felis, in ornare urna consequat sit amet. Praesent vehicula libero ac tellus rutrum ultrices. Sed eu consectetur libero, id varius massa. Quisque vestibulum tempus felis. Nulla interdum varius arcu nec.</p>\r\n<p class="jmpeople">Ut lectus felis, facilisis nec erat at, pretium pellentesque lectus. Donec sit amet nibh est. Morbi augue libero, pretium vitae nulla ac, malesuada ultricies neque. Praesent vehicula libero ac tellus rutrum ultrices. Sed eu consectetur libero, id varius massa. Nulla interdum varius arcu nec accumsan.</p>\r\n<p class="jmmail">Cras eleifend iaculis purus sed hendrerit. Nulla facilisi. Sed congue semper consequat. Nam viverra semper libero, a luctus eros. Nulla porttitor commodo velit nec rhoncus. Donec sit amet nibh est. Morbi augue libero, pretium vitae nulla ac. Nulla porttitor commodo velit nec rhoncus.</p>\r\n<p>Ut lectus felis, facilisis nec erat at, pretium pellentesque lectus. Donec sit amet nibh est. Morbi augue libero, pretium vitae nulla ac, malesuada ultricies neque. Donec eget neque erat. Nam dictum justo sit amet placerat consectetur. Maecenas laoreet, ligula vel scelerisque ultricies, lorem urna luctus odio, eget convallis urna erat quis justo. Morbi vel placerat nisl, ut tempor odio. Sed lacinia purus sit amet lorem dictum tincidunt.</p>','1','83','2014-02-12 13:09:33','499','','2014-12-16 07:49:37','182','0','0000-00-00 00:00:00','2014-02-12 13:09:33','0000-00-00 00:00:00','{"image_intro":"images\\/modules\\/article1.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/modules\\/slider\\/slide3.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}','{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}','{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}','6','3','','','1','3','{"robots":"","author":"","rights":"","xreference":""}','0','*',''),
('95','261','Blog Article 7','blog-article-7','<p><strong>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nulla scelerisque magna et orci porttitor ullamcorper. Proin euismod pretium dolor non consectetur. Aliquam feugiat nunc ac justo hendrerit, non lobortis lacus.</strong></p>\r\n<p>Praesent vehicula libero ac tellus rutrum ultrices. Sed eu consectetur libero, id varius massa. Quisque vestibulum tempus felis. Nulla interdum varius arcu nec. Duis id erat nunc. Nam eu aliquam velit. Donec pretium sed quam quis pulvinar. Fusce felis ante, pulvinar ac metus et, adipiscing consequat lectus. Integer quam nibh, varius nec lacus elementum, bibendum posuere ante.</p>\r\n','\r\n<p>Ut lectus felis, facilisis nec erat at, pretium pellentesque lectus. Donec sit amet nibh est. Morbi augue libero, pretium vitae nulla ac, malesuada ultricies neque. Donec eget neque erat. Nam dictum justo sit amet placerat consectetur. Maecenas laoreet, ligula vel scelerisque ultricies, lorem urna luctus odio, eget convallis. Quisque vestibulum tempus felis. Nulla interdum varius arcu nec. Duis id erat nunc.</p>\r\n<p> </p>\r\n<h4>Lorem ipsum dolor</h4>\r\n<p>Nunc placerat egestas vehicula. Fusce eu risus sit amet metus sagittis volutpat vehicula porttitor elit. Sed fringilla purus sed mi scelerisque scelerisque. Donec vel enim ligula. Phasellus vulputate ac dui aliquet dapibus. Suspendisse ut vestibulum tellus, sed gravida arcu. Aliquam erat volutpat. Cras eu quam vitae magna cursus adipiscing. Etiam quis mi lacus. Proin fermentum velit non ligula malesuada imperdiet. Sed sapien enim, porta vel tempus sed, suscipit quis nisl. In vestibulum ut massa eu feugiat.</p>\r\n<p class="jm-block second"><span class="jm">1</span>Nulla vestibulum ultrices felis sit amet dapibus. Suspendisse et ligula hendrerit, auctor justo vel, sagittis metus. Mauris tincidunt quam eu pulvinar sagittis. Pellentesque imperdiet, purus vel feugiat pharetra, lectus velit scelerisque nisi, a aliquam nibh augue vel urna. In volutpat tellus et pulvinar varius. Aenean ultricies euismod rhoncus.</p>\r\n<p class="jm-block second"><span class="jm">2</span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nulla scelerisque magna et orci porttitor ullamcorper. Proin euismod pretium dolor non consectetur. Aliquam feugiat nunc ac justo hendrerit, non lobortis lacus condimentum. Duis id erat nunc. Nam eu aliquam velit. Donec pretium sed quam quis pulvinar.</p>\r\n<p class="jm-block second"><span class="jm">3</span>Cras eleifend iaculis purus sed hendrerit. Nulla facilisi. Sed congue semper consequat. Nam viverra semper libero, a luctus eros. Nulla porttitor commodo velit nec rhoncus. Vivamus blandit tellus risus, et hendrerit nisi aliquet ut. Ut imperdiet orci tellus, in tristique urna mattis eu.</p>\r\n<p>Nulla vestibulum ultrices felis sit amet dapibus. Suspendisse et ligula hendrerit, auctor justo vel, sagittis metus. Mauris tincidunt quam eu pulvinar sagittis. Pellentesque imperdiet, purus vel feugiat pharetra, lectus velit scelerisque nisi, a aliquam nibh augue vel urna. In volutpat tellus et pulvinar varius. Aenean ultricies euismod rhoncus. Ut lectus felis, facilisis nec erat at, pretium pellentesque lectus. Donec sit amet nibh est. Morbi augue libero, pretium vitae nulla ac, malesuada ultricies neque. Donec eget neque erat. Nam dictum justo sit amet placerat consectetur.</p>\r\n<p> </p>\r\n<h4>Consectetur adipiscing elit</h4>\r\n<p>Cras eleifend iaculis purus sed hendrerit. Nulla facilisi. Sed congue semper consequat. Nam viverra semper libero, a luctus eros. Nulla porttitor commodo velit nec rhoncus. Vivamus blandit tellus risus, et hendrerit nisi aliquet ut. Ut imperdiet orci tellus, in tristique urna mattis eu. Pellentesque ligula nisl, hendrerit nec facilisis sit amet, faucibus ac nulla. Morbi et consectetur ante. Etiam eu sodales tortor, ac dapibus lectus. In laoreet tempor felis, in ornare urna consequat sit amet. Praesent vehicula libero ac tellus rutrum ultrices. Sed eu consectetur libero, id varius massa. Quisque vestibulum tempus felis. Nulla interdum varius arcu nec.</p>\r\n<p class="jmpeople">Ut lectus felis, facilisis nec erat at, pretium pellentesque lectus. Donec sit amet nibh est. Morbi augue libero, pretium vitae nulla ac, malesuada ultricies neque. Praesent vehicula libero ac tellus rutrum ultrices. Sed eu consectetur libero, id varius massa. Nulla interdum varius arcu nec accumsan.</p>\r\n<p class="jmmail">Cras eleifend iaculis purus sed hendrerit. Nulla facilisi. Sed congue semper consequat. Nam viverra semper libero, a luctus eros. Nulla porttitor commodo velit nec rhoncus. Donec sit amet nibh est. Morbi augue libero, pretium vitae nulla ac. Nulla porttitor commodo velit nec rhoncus.</p>\r\n<p>Ut lectus felis, facilisis nec erat at, pretium pellentesque lectus. Donec sit amet nibh est. Morbi augue libero, pretium vitae nulla ac, malesuada ultricies neque. Donec eget neque erat. Nam dictum justo sit amet placerat consectetur. Maecenas laoreet, ligula vel scelerisque ultricies, lorem urna luctus odio, eget convallis urna erat quis justo. Morbi vel placerat nisl, ut tempor odio. Sed lacinia purus sit amet lorem dictum tincidunt.</p>','1','83','2014-02-12 13:09:51','499','','2014-12-16 07:49:20','182','0','0000-00-00 00:00:00','2014-02-12 13:09:51','0000-00-00 00:00:00','{"image_intro":"images\\/modules\\/article1.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/modules\\/slider\\/slide2.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}','{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}','{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}','6','2','','','1','16','{"robots":"","author":"","rights":"","xreference":""}','0','*',''),
('96','262','Leading Article','leading-article','<p><strong>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nulla scelerisque magna et orci porttitor ullamcorper. Proin euismod pretium dolor non consectetur. Aliquam feugiat nunc ac justo hendrerit, non lobortis lacus.</strong></p>\r\n<p>Praesent vehicula libero ac tellus rutrum ultrices. Sed eu consectetur libero, id varius massa. Quisque vestibulum tempus felis. Nulla interdum varius arcu nec. Duis id erat nunc. Nam eu aliquam velit. Donec pretium sed quam quis pulvinar. Fusce felis ante, pulvinar ac metus et, adipiscing consequat lectus. Integer quam nibh, varius nec lacus elementum, bibendum posuere ante.</p>\r\n','\r\n<p>Ut lectus felis, facilisis nec erat at, pretium pellentesque lectus. Donec sit amet nibh est. Morbi augue libero, pretium vitae nulla ac, malesuada ultricies neque. Donec eget neque erat. Nam dictum justo sit amet placerat consectetur. Maecenas laoreet, ligula vel scelerisque ultricies, lorem urna luctus odio, eget convallis. Quisque vestibulum tempus felis. Nulla interdum varius arcu nec. Duis id erat nunc.</p>\r\n<p> </p>\r\n<h4>Lorem ipsum dolor</h4>\r\n<p>Nunc placerat egestas vehicula. Fusce eu risus sit amet metus sagittis volutpat vehicula porttitor elit. Sed fringilla purus sed mi scelerisque scelerisque. Donec vel enim ligula. Phasellus vulputate ac dui aliquet dapibus. Suspendisse ut vestibulum tellus, sed gravida arcu. Aliquam erat volutpat. Cras eu quam vitae magna cursus adipiscing. Etiam quis mi lacus. Proin fermentum velit non ligula malesuada imperdiet. Sed sapien enim, porta vel tempus sed, suscipit quis nisl. In vestibulum ut massa eu feugiat.</p>\r\n<p class="jm-block second"><span class="jm">1</span>Nulla vestibulum ultrices felis sit amet dapibus. Suspendisse et ligula hendrerit, auctor justo vel, sagittis metus. Mauris tincidunt quam eu pulvinar sagittis. Pellentesque imperdiet, purus vel feugiat pharetra, lectus velit scelerisque nisi, a aliquam nibh augue vel urna. In volutpat tellus et pulvinar varius. Aenean ultricies euismod rhoncus.</p>\r\n<p class="jm-block second"><span class="jm">2</span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nulla scelerisque magna et orci porttitor ullamcorper. Proin euismod pretium dolor non consectetur. Aliquam feugiat nunc ac justo hendrerit, non lobortis lacus condimentum. Duis id erat nunc. Nam eu aliquam velit. Donec pretium sed quam quis pulvinar.</p>\r\n<p class="jm-block second"><span class="jm">3</span>Cras eleifend iaculis purus sed hendrerit. Nulla facilisi. Sed congue semper consequat. Nam viverra semper libero, a luctus eros. Nulla porttitor commodo velit nec rhoncus. Vivamus blandit tellus risus, et hendrerit nisi aliquet ut. Ut imperdiet orci tellus, in tristique urna mattis eu.</p>\r\n<p>Nulla vestibulum ultrices felis sit amet dapibus. Suspendisse et ligula hendrerit, auctor justo vel, sagittis metus. Mauris tincidunt quam eu pulvinar sagittis. Pellentesque imperdiet, purus vel feugiat pharetra, lectus velit scelerisque nisi, a aliquam nibh augue vel urna. In volutpat tellus et pulvinar varius. Aenean ultricies euismod rhoncus. Ut lectus felis, facilisis nec erat at, pretium pellentesque lectus. Donec sit amet nibh est. Morbi augue libero, pretium vitae nulla ac, malesuada ultricies neque. Donec eget neque erat. Nam dictum justo sit amet placerat consectetur.</p>\r\n<p> </p>\r\n<h4>Consectetur adipiscing elit</h4>\r\n<p>Cras eleifend iaculis purus sed hendrerit. Nulla facilisi. Sed congue semper consequat. Nam viverra semper libero, a luctus eros. Nulla porttitor commodo velit nec rhoncus. Vivamus blandit tellus risus, et hendrerit nisi aliquet ut. Ut imperdiet orci tellus, in tristique urna mattis eu. Pellentesque ligula nisl, hendrerit nec facilisis sit amet, faucibus ac nulla. Morbi et consectetur ante. Etiam eu sodales tortor, ac dapibus lectus. In laoreet tempor felis, in ornare urna consequat sit amet. Praesent vehicula libero ac tellus rutrum ultrices. Sed eu consectetur libero, id varius massa. Quisque vestibulum tempus felis. Nulla interdum varius arcu nec.</p>\r\n<p class="jmpeople">Ut lectus felis, facilisis nec erat at, pretium pellentesque lectus. Donec sit amet nibh est. Morbi augue libero, pretium vitae nulla ac, malesuada ultricies neque. Praesent vehicula libero ac tellus rutrum ultrices. Sed eu consectetur libero, id varius massa. Nulla interdum varius arcu nec accumsan.</p>\r\n<p class="jmmail">Cras eleifend iaculis purus sed hendrerit. Nulla facilisi. Sed congue semper consequat. Nam viverra semper libero, a luctus eros. Nulla porttitor commodo velit nec rhoncus. Donec sit amet nibh est. Morbi augue libero, pretium vitae nulla ac. Nulla porttitor commodo velit nec rhoncus.</p>\r\n<p>Ut lectus felis, facilisis nec erat at, pretium pellentesque lectus. Donec sit amet nibh est. Morbi augue libero, pretium vitae nulla ac, malesuada ultricies neque. Donec eget neque erat. Nam dictum justo sit amet placerat consectetur. Maecenas laoreet, ligula vel scelerisque ultricies, lorem urna luctus odio, eget convallis urna erat quis justo. Morbi vel placerat nisl, ut tempor odio. Sed lacinia purus sit amet lorem dictum tincidunt.</p>','1','83','2014-02-12 13:10:05','499','','2014-12-16 07:49:03','182','0','0000-00-00 00:00:00','2014-02-12 13:10:05','0000-00-00 00:00:00','{"image_intro":"images\\/modules\\/article1.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/modules\\/slider\\/slide1.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}','{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}','{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}','6','1','','','1','16','{"robots":"","author":"","rights":"","xreference":""}','0','*',''),
('97','296','Steam cleaning','steam-cleaning','<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud. Cras euismod purus eget turpis semper gravida. Nulla volutpat bibendum sapien, et pharetra mi pretium nec. In mattis at arcu luctus porta. Aenean ullamcorper tortor lacus, at cursus justo fringilla et. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Maecenas gravida tortor in nisl tincidunt vestibulum.</p>\r\n','\r\n<p>Ut bibendum non leo id pellentesque. In vehicula ipsum sapien. Nunc vel adipiscing lectus, vitae placerat libero. Nulla eleifend, magna sit amet viverra auctor, nunc dui adipiscing diam, at suscipit felis diam in est. Cras tempus lorem odio, et tristique diam iaculis in. Morbi quis sem dapibus, molestie purus sed, eleifend lectus.</p>\r\n<p>Nunc convallis at velit eget feugiat. Nunc quis nunc risus. Nunc id venenatis augue. Etiam eu viverra orci. Ut egestas vehicula consequat. Nunc facilisis imperdiet nibh bibendum tempus. Nullam et ante dui. Duis pulvinar purus nec ipsum pulvinar suscipit. Nunc ante purus, convallis vitae odio ut, feugiat aliquet tellus. Aenean et purus risus.</p>\r\n<p>In mattis varius sapien, eget tincidunt nibh vestibulum viverra. Nunc at dolor mauris. Donec felis lorem, vehicula non aliquam non, feugiat ut nunc. Proin id felis vehicula, rhoncus nisl non, porta eros. Aliquam metus massa, condimentum sed sapien at, egestas imperdiet odio. Suspendisse non molestie est. Quisque congue lorem eu maximus placerat. Phasellus tempus dolor a diam scelerisque blandit. In eu semper elit, sit amet tristique nisi. Sed vitae lectus eu leo pellentesque elementum sit amet tempor metus. Quisque maximus mollis velit, sed varius elit posuere vel. Suspendisse sed dolor in nulla fermentum maximus at quis ante.</p>\r\n<p>Aliquam diam urna, consectetur id cursus ac, efficitur vitae lectus. Pellentesque gravida ipsum sit amet est congue, vitae sagittis nisl porta. Quisque tincidunt felis eget leo iaculis, non scelerisque mi sagittis. Ut pulvinar lobortis urna at placerat. Sed consectetur metus justo, vel elementum tellus fermentum eu. Pellentesque vel ex varius, mattis lectus quis, varius massa. Morbi felis quam, ullamcorper nec sem id, tincidunt dictum nisi. Nunc nec justo gravida, viverra odio et, consequat ante. Proin condimentum nunc at dui sodales posuere. Mauris nibh tortor, dignissim non convallis in, efficitur ac nisl. Mauris vitae condimentum turpis, sit amet tempor urna. Donec lobortis cursus mi a molestie. Nam quis quam ut mi sollicitudin pellentesque.</p>','1','84','2014-05-22 13:26:07','499','','2015-05-07 09:34:56','545','0','0000-00-00 00:00:00','2014-05-22 13:26:07','0000-00-00 00:00:00','{"image_intro":"images\\/modules\\/tabs\\/s4.jpg","float_intro":"left","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/modules\\/slider\\/slide4.jpg","float_fulltext":"left","image_fulltext_alt":"","image_fulltext_caption":""}','{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}','{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}','16','3','','','1','1','{"robots":"","author":"","rights":"","xreference":""}','0','*',''),
('98','297','Carpet cleanin','carpet-cleanin','<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud. Cras euismod purus eget turpis semper gravida.</p>\r\n<p></p>\r\n<ul style="display: table;">\r\n<li>Nulla volutpat bibendum sapien, et pharetra mi pretium nec.</li>\r\n<li>Aenean ullamcorper tortor lacus.</li>\r\n<li>Sed in efficitur neque, ac dignissim est. Curabitur at ultrices justo, non blandit quam. In sed vehicula lectus. Quisque et varius leo, nec vestibulum nibh. Nam vel leo sapien. Suspendisse pulvinar vestibulum suscipit.</li>\r\n</ul>\r\n','\r\n<p>Ut bibendum non leo id pellentesque. In vehicula ipsum sapien. Nunc vel adipiscing lectus, vitae placerat libero. Nulla eleifend, magna sit amet viverra auctor, nunc dui adipiscing diam, at suscipit felis diam in est. Cras tempus lorem odio, et tristique diam iaculis in. Morbi quis sem dapibus, molestie purus sed, eleifend lectus.</p>\r\n<p>Nunc convallis at velit eget feugiat. Nunc quis nunc risus. Nunc id venenatis augue. Etiam eu viverra orci. Ut egestas vehicula consequat. Nunc facilisis imperdiet nibh bibendum tempus. Nullam et ante dui. Duis pulvinar purus nec ipsum pulvinar suscipit. Nunc ante purus, convallis vitae odio ut, feugiat aliquet tellus. Aenean et purus risus.</p>\r\n<p>In mattis varius sapien, eget tincidunt nibh vestibulum viverra. Nunc at dolor mauris. Donec felis lorem, vehicula non aliquam non, feugiat ut nunc. Proin id felis vehicula, rhoncus nisl non, porta eros. Aliquam metus massa, condimentum sed sapien at, egestas imperdiet odio. Suspendisse non molestie est. Quisque congue lorem eu maximus placerat. Phasellus tempus dolor a diam scelerisque blandit. In eu semper elit, sit amet tristique nisi. Sed vitae lectus eu leo pellentesque elementum sit amet tempor metus. Quisque maximus mollis velit, sed varius elit posuere vel. Suspendisse sed dolor in nulla fermentum maximus at quis ante.</p>\r\n<p>Aliquam diam urna, consectetur id cursus ac, efficitur vitae lectus. Pellentesque gravida ipsum sit amet est congue, vitae sagittis nisl porta. Quisque tincidunt felis eget leo iaculis, non scelerisque mi sagittis. Ut pulvinar lobortis urna at placerat. Sed consectetur metus justo, vel elementum tellus fermentum eu. Pellentesque vel ex varius, mattis lectus quis, varius massa. Morbi felis quam, ullamcorper nec sem id, tincidunt dictum nisi. Nunc nec justo gravida, viverra odio et, consequat ante. Proin condimentum nunc at dui sodales posuere. Mauris nibh tortor, dignissim non convallis in, efficitur ac nisl. Mauris vitae condimentum turpis, sit amet tempor urna. Donec lobortis cursus mi a molestie. Nam quis quam ut mi sollicitudin pellentesque.</p>','1','84','2014-05-22 13:28:06','499','','2015-05-07 09:34:46','545','0','0000-00-00 00:00:00','2014-05-22 13:28:06','0000-00-00 00:00:00','{"image_intro":"images\\/modules\\/tabs\\/s3.jpg","float_intro":"left","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/modules\\/slider\\/slide3.jpg","float_fulltext":"left","image_fulltext_alt":"","image_fulltext_caption":""}','{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}','{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}','12','2','','','1','6','{"robots":"","author":"","rights":"","xreference":""}','0','*',''),
('99','298','Window cleaning','window-cleaning','<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud. Cras euismod purus eget turpis semper gravida.</p>\r\n<p></p>\r\n<ul style="display: table;">\r\n<li>Nulla volutpat bibendum sapien, et pharetra mi pretium nec.</li>\r\n<li>Aenean ullamcorper tortor lacus.</li>\r\n<li>Sed in efficitur neque, ac dignissim est. Curabitur at ultrices justo, non blandit quam. In sed vehicula lectus. Quisque et varius leo, nec vestibulum nibh. Nam vel leo sapien. Suspendisse pulvinar vestibulum suscipit.</li>\r\n</ul>\r\n','\r\n<p>Ut bibendum non leo id pellentesque. In vehicula ipsum sapien. Nunc vel adipiscing lectus, vitae placerat libero. Nulla eleifend, magna sit amet viverra auctor, nunc dui adipiscing diam, at suscipit felis diam in est. Cras tempus lorem odio, et tristique diam iaculis in. Morbi quis sem dapibus, molestie purus sed, eleifend lectus.</p>\r\n<p>Nunc convallis at velit eget feugiat. Nunc quis nunc risus. Nunc id venenatis augue. Etiam eu viverra orci. Ut egestas vehicula consequat. Nunc facilisis imperdiet nibh bibendum tempus. Nullam et ante dui. Duis pulvinar purus nec ipsum pulvinar suscipit. Nunc ante purus, convallis vitae odio ut, feugiat aliquet tellus. Aenean et purus risus.</p>\r\n<p>In mattis varius sapien, eget tincidunt nibh vestibulum viverra. Nunc at dolor mauris. Donec felis lorem, vehicula non aliquam non, feugiat ut nunc. Proin id felis vehicula, rhoncus nisl non, porta eros. Aliquam metus massa, condimentum sed sapien at, egestas imperdiet odio. Suspendisse non molestie est. Quisque congue lorem eu maximus placerat. Phasellus tempus dolor a diam scelerisque blandit. In eu semper elit, sit amet tristique nisi. Sed vitae lectus eu leo pellentesque elementum sit amet tempor metus. Quisque maximus mollis velit, sed varius elit posuere vel. Suspendisse sed dolor in nulla fermentum maximus at quis ante.</p>\r\n<p>Aliquam diam urna, consectetur id cursus ac, efficitur vitae lectus. Pellentesque gravida ipsum sit amet est congue, vitae sagittis nisl porta. Quisque tincidunt felis eget leo iaculis, non scelerisque mi sagittis. Ut pulvinar lobortis urna at placerat. Sed consectetur metus justo, vel elementum tellus fermentum eu. Pellentesque vel ex varius, mattis lectus quis, varius massa. Morbi felis quam, ullamcorper nec sem id, tincidunt dictum nisi. Nunc nec justo gravida, viverra odio et, consequat ante. Proin condimentum nunc at dui sodales posuere. Mauris nibh tortor, dignissim non convallis in, efficitur ac nisl. Mauris vitae condimentum turpis, sit amet tempor urna. Donec lobortis cursus mi a molestie. Nam quis quam ut mi sollicitudin pellentesque.</p>','1','84','2014-05-22 13:29:08','499','','2015-05-07 09:34:38','545','0','0000-00-00 00:00:00','2014-05-22 13:29:08','0000-00-00 00:00:00','{"image_intro":"images\\/modules\\/tabs\\/s2.jpg","float_intro":"right","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/modules\\/slider\\/slide2.jpg","float_fulltext":"right","image_fulltext_alt":"","image_fulltext_caption":""}','{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}','{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}','14','1','','','1','31','{"robots":"","author":"","rights":"","xreference":""}','0','*',''),
('103','310','You work enough already!','you-work-enough-already','<p>Nam mattis luctus mauris. Nulla sodales accumsan semper. Ut lectus arcu, porta nec urna sit amet, placerat vestibulum quam. In pretium nunc eu purus sodales, in facilisis magna molestie.</p>\r\n','\r\n<p><strong> Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed quis nisi eget lacus varius suscipit. Praesent tincidunt leo sit amet hendrerit tincidunt. Donec pulvinar dolor massa, interdum iaculis leo ornare nec.</strong></p>\r\n<p> </p>\r\n<p>Vivamus sagittis felis in tellus mollis, sit amet imperdiet purus porta. Ut laoreet, ipsum quis blandit semper, erat mauris tempor nulla, molestie convallis mauris magna at metus. In non hendrerit ante. Cras non urna aliquam eros vehicula placerat condimentum varius dolor. Nam quis viverra risus. Class aptent taciti sociosqu ad litora torquent per conubia.</p>\r\n<p> </p>\r\n<p class="quote-left">Donec tempor tincidunt adipiscing. Etiam sed pretium risus, sed cursus lorem. In consectetur, odio eu mollis imperdiet, leo augue dapibus mi, quis imperdiet massa sapien nec enim. Proin sed purus augue. Cras luctus massa a ante dapibus, ut feugiat leo mattis.</p>\r\n<p> </p>\r\n<p>Vivamus vitae congue metus, vel ornare massa. Maecenas et auctor urna, scelerisque ornare arcu. Proin pharetra, ligula id adipiscing pulvinar, dui nulla luctus felis, sed viverra dui sapien non risus. Sed faucibus quam id metus rutrum volutpat ac quis nulla. Nulla facilisi.</p>\r\n<p> </p>\r\n<p>Vivamus ullamcorper mi quis lacus consectetur, quis sodales metus ultricies. Cras at mauris lobortis, congue elit nec, tristique odio. Praesent eu dui blandit, rhoncus mauris quis, commodo neque. Maecenas tellus dolor, commodo vel ullamcorper a, consectetur eget lorem. Proin scelerisque tortor tellus, sit amet pharetra augue pulvinar nec. Suspendisse potenti. Etiam congue, est non luctus luctus, turpis nulla lobortis risus, sit amet tempor tortor lorem vel nisl. Nunc ultrices est a risus ultricies lobortis.</p>\r\n<p> </p>\r\n<p>Suspendisse potenti. Nam pharetra, orci nec rutrum adipiscing, ligula quam gravida lorem, ac porttitor ligula mi quis nulla. Sed vitae malesuada turpis. Praesent blandit tellus risus. Vivamus rutrum risus quis mollis pulvinar. Ut euismod enim urna, nec ullamcorper orci blandit ac. Donec dapibus, nunc tincidunt rutrum eleifend, elit dolor pellentesque felis, vitae condimentum magna odio varius enim. Cras placerat nibh ac molestie consectetur. Nunc scelerisque eros nulla, sed consectetur nibh venenatis nec. Curabitur fermentum, tellus id blandit feugiat, tortor quam suscipit libero, sed molestie sapien erat sed diam. Ut tempor condimentum sem, sed ullamcorper libero scelerisque id. Maecenas nec ante pellentesque, ultricies ante ut, malesuada odio. Nam vitae tortor ullamcorper, ultrices elit nec, suscipit arcu.</p>\r\n<p> </p>\r\n<p>Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur?</p>','1','86','2014-05-23 07:22:59','499','','2015-05-07 09:28:54','545','0','0000-00-00 00:00:00','2014-05-23 07:22:59','0000-00-00 00:00:00','{"image_intro":"images\\/modules\\/slider\\/slide5.jpg","float_intro":"none","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/modules\\/slider\\/slide5.jpg","float_fulltext":"none","image_fulltext_alt":"","image_fulltext_caption":""}','{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}','{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}','19','3','','','1','184','{"robots":"","author":"","rights":"","xreference":""}','0','*',''),
('104','312','Treat yourself to a clean healthy home','treat-yourself-to-a-clean-healthy-home','<p>Nunc tincidunt eros ut mauris ullamcorper, vitae semper ligula convallis. Morbi tincidunt congue venenatis. Fusce at vestibulum nisl, et congue nisi. Vestibulum sollicitudin tellus id arcu vulputate.</p>\r\n','\r\n<p><strong> Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed quis nisi eget lacus varius suscipit. Praesent tincidunt leo sit amet hendrerit tincidunt. Donec pulvinar dolor massa, interdum iaculis leo ornare nec.</strong></p>\r\n<p> </p>\r\n<p>Vivamus sagittis felis in tellus mollis, sit amet imperdiet purus porta. Ut laoreet, ipsum quis blandit semper, erat mauris tempor nulla, molestie convallis mauris magna at metus. In non hendrerit ante. Cras non urna aliquam eros vehicula placerat condimentum varius dolor. Nam quis viverra risus. Class aptent taciti sociosqu ad litora torquent per conubia.</p>\r\n<p> </p>\r\n<p class="quote-left">Donec tempor tincidunt adipiscing. Etiam sed pretium risus, sed cursus lorem. In consectetur, odio eu mollis imperdiet, leo augue dapibus mi, quis imperdiet massa sapien nec enim. Proin sed purus augue. Cras luctus massa a ante dapibus, ut feugiat leo mattis.</p>\r\n<p> </p>\r\n<p>Vivamus vitae congue metus, vel ornare massa. Maecenas et auctor urna, scelerisque ornare arcu. Proin pharetra, ligula id adipiscing pulvinar, dui nulla luctus felis, sed viverra dui sapien non risus. Sed faucibus quam id metus rutrum volutpat ac quis nulla. Nulla facilisi.</p>\r\n<p> </p>\r\n<p>Vivamus ullamcorper mi quis lacus consectetur, quis sodales metus ultricies. Cras at mauris lobortis, congue elit nec, tristique odio. Praesent eu dui blandit, rhoncus mauris quis, commodo neque. Maecenas tellus dolor, commodo vel ullamcorper a, consectetur eget lorem. Proin scelerisque tortor tellus, sit amet pharetra augue pulvinar nec. Suspendisse potenti. Etiam congue, est non luctus luctus, turpis nulla lobortis risus, sit amet tempor tortor lorem vel nisl. Nunc ultrices est a risus ultricies lobortis.</p>\r\n<p> </p>\r\n<p>Suspendisse potenti. Nam pharetra, orci nec rutrum adipiscing, ligula quam gravida lorem, ac porttitor ligula mi quis nulla. Sed vitae malesuada turpis. Praesent blandit tellus risus. Vivamus rutrum risus quis mollis pulvinar. Ut euismod enim urna, nec ullamcorper orci blandit ac. Donec dapibus, nunc tincidunt rutrum eleifend, elit dolor pellentesque felis, vitae condimentum magna odio varius enim. Cras placerat nibh ac molestie consectetur. Nunc scelerisque eros nulla, sed consectetur nibh venenatis nec. Curabitur fermentum, tellus id blandit feugiat, tortor quam suscipit libero, sed molestie sapien erat sed diam. Ut tempor condimentum sem, sed ullamcorper libero scelerisque id. Maecenas nec ante pellentesque, ultricies ante ut, malesuada odio. Nam vitae tortor ullamcorper, ultrices elit nec, suscipit arcu.</p>\r\n<p> </p>\r\n<p>Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur?</p>','1','86','2014-05-23 07:22:59','499','','2015-05-07 09:26:32','545','0','0000-00-00 00:00:00','2014-05-23 07:22:59','0000-00-00 00:00:00','{"image_intro":"images\\/modules\\/slider\\/slide4.jpg","float_intro":"none","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/modules\\/slider\\/slide4.jpg","float_fulltext":"none","image_fulltext_alt":"","image_fulltext_caption":""}','{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}','{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}','20','4','','','1','60','{"robots":"","author":"","rights":"","xreference":""}','0','*',''),
('109','322','Enjoy your time off','enjoy-your-time-off','<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam ut ipsum et nunc semper feugiat. Donec mattis arcu mi, eu mollis quam pretium vitae. Morbi sed vestibulum arcu. Nunc at orci turpis.</p>\r\n','\r\n<p><strong> Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed quis nisi eget lacus varius suscipit. Praesent tincidunt leo sit amet hendrerit tincidunt. Donec pulvinar dolor massa, interdum iaculis leo ornare nec.<br /></strong></p>\r\n<p> </p>\r\n<p>Vivamus sagittis felis in tellus mollis, sit amet imperdiet purus porta. Ut laoreet, ipsum quis blandit semper, erat mauris tempor nulla, molestie convallis mauris magna at metus. In non hendrerit ante. Cras non urna aliquam eros vehicula placerat condimentum varius dolor. Nam quis viverra risus. Class aptent taciti sociosqu ad litora torquent per conubia.</p>\r\n<p> </p>\r\n<p class="quote-left">Donec tempor tincidunt adipiscing. Etiam sed pretium risus, sed cursus lorem. In consectetur, odio eu mollis imperdiet, leo augue dapibus mi, quis imperdiet massa sapien nec enim. Proin sed purus augue. Cras luctus massa a ante dapibus, ut feugiat leo mattis.</p>\r\n<p> </p>\r\n<p>Vivamus vitae congue metus, vel ornare massa. Maecenas et auctor urna, scelerisque ornare arcu. Proin pharetra, ligula id adipiscing pulvinar, dui nulla luctus felis, sed viverra dui sapien non risus. Sed faucibus quam id metus rutrum volutpat ac quis nulla. Nulla facilisi.</p>\r\n<p> </p>\r\n<p>Vivamus ullamcorper mi quis lacus consectetur, quis sodales metus ultricies. Cras at mauris lobortis, congue elit nec, tristique odio. Praesent eu dui blandit, rhoncus mauris quis, commodo neque. Maecenas tellus dolor, commodo vel ullamcorper a, consectetur eget lorem. Proin scelerisque tortor tellus, sit amet pharetra augue pulvinar nec. Suspendisse potenti. Etiam congue, est non luctus luctus, turpis nulla lobortis risus, sit amet tempor tortor lorem vel nisl. Nunc ultrices est a risus ultricies lobortis.</p>\r\n<p> </p>\r\n<p>Suspendisse potenti. Nam pharetra, orci nec rutrum adipiscing, ligula quam gravida lorem, ac porttitor ligula mi quis nulla. Sed vitae malesuada turpis. Praesent blandit tellus risus. Vivamus rutrum risus quis mollis pulvinar. Ut euismod enim urna, nec ullamcorper orci blandit ac. Donec dapibus, nunc tincidunt rutrum eleifend, elit dolor pellentesque felis, vitae condimentum magna odio varius enim. Cras placerat nibh ac molestie consectetur. Nunc scelerisque eros nulla, sed consectetur nibh venenatis nec. Curabitur fermentum, tellus id blandit feugiat, tortor quam suscipit libero, sed molestie sapien erat sed diam. Ut tempor condimentum sem, sed ullamcorper libero scelerisque id. Maecenas nec ante pellentesque, ultricies ante ut, malesuada odio. Nam vitae tortor ullamcorper, ultrices elit nec, suscipit arcu.</p>\r\n<p> </p>\r\n<p>Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur?</p>','1','86','2014-05-23 07:22:59','499','','2015-05-07 09:35:45','545','0','0000-00-00 00:00:00','2014-05-23 07:22:59','0000-00-00 00:00:00','{"image_intro":"images\\/modules\\/slider\\/slide3.jpg","float_intro":"none","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/modules\\/slider\\/slide3.jpg","float_fulltext":"none","image_fulltext_alt":"","image_fulltext_caption":""}','{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}','{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}','18','5','','','1','99','{"robots":"","author":"","rights":"","xreference":""}','0','*',''),
('110','334','Pricing Table','pricing-table','<div class="clearfix">\r\n<table class="table pricing" style="width: 33%;">\r\n<thead>\r\n<tr><th colspan="2">Cleaning Service</th></tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td class="item">Lorem ipsum dolor sit amet, consectetur adipiscing elit.</td>\r\n<td class="price">$1</td>\r\n</tr>\r\n<tr>\r\n<td class="item">Donec tempor hendrerit sapien, sed mattis diam eleifend tempus.</td>\r\n<td class="price">$5</td>\r\n</tr>\r\n<tr>\r\n<td class="item">Donec ornare venenatis imperdiet.</td>\r\n<td class="price">$10</td>\r\n</tr>\r\n<tr>\r\n<td class="item">Vestibulum sed nibh in nisi blandit ornare eget vel neque.</td>\r\n<td class="price">$15</td>\r\n</tr>\r\n<tr>\r\n<td class="item">Cras condimentum porttitor quam, id tincidunt odio lacinia id.</td>\r\n<td class="price">$20</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class="table pricing" style="width: 33%;">\r\n<thead>\r\n<tr><th colspan="2">Ironing Service</th></tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td class="item">Pellentesque convallis imperdiet velit a consequat.</td>\r\n<td class="price">$5</td>\r\n</tr>\r\n<tr>\r\n<td class="item">Praesent quis purus cursus mauris ultrices ultrices ac vitae purus.</td>\r\n<td class="price">$10</td>\r\n</tr>\r\n<tr>\r\n<td class="item">Phasellus at velit lacinia quam dapibus eleifend eu ac nisl.</td>\r\n<td class="price">$15</td>\r\n</tr>\r\n<tr>\r\n<td class="item">Donec id justo tempus, tincidunt ipsum ut, rutrum quam.</td>\r\n<td class="price">$20</td>\r\n</tr>\r\n<tr>\r\n<td class="item">Ut ultricies consectetur faucibus.</td>\r\n<td class="price">$25</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class="table pricing" style="width: 33%;">\r\n<thead>\r\n<tr><th colspan="2">Additional charges</th></tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td class="item">Etiam nibh nisl, fermentum sit amet egestas in, sodales in dui.</td>\r\n<td class="price">$5</td>\r\n</tr>\r\n<tr>\r\n<td class="item">Quisque eu orci finibus, accumsan eros id, posuere est.</td>\r\n<td class="price">$10</td>\r\n</tr>\r\n<tr>\r\n<td class="item">Vestibulum faucibus, mi eu mattis faucibus, orci velit pharetra tellus.</td>\r\n<td class="price">$15</td>\r\n</tr>\r\n<tr>\r\n<td class="item">Proin imperdiet sapien ut dolor.</td>\r\n<td class="price">$20</td>\r\n</tr>\r\n<tr>\r\n<td class="item">Praesent semper finibus consectetur.</td>\r\n<td class="price">$15</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>','','1','82','2014-05-28 10:15:43','499','','2015-05-06 11:59:49','545','0','0000-00-00 00:00:00','2014-05-28 10:15:43','0000-00-00 00:00:00','{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}','{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}','{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}','10','3','','','1','26','{"robots":"","author":"","rights":"","xreference":""}','0','*',''),
('113','343','You deserve a break!','you-deserve-a-break','<p>Nunc tincidunt eros ut mauris ullamcorper, vitae semper ligula convallis. Morbi tincidunt congue venenatis. Fusce at vestibulum nisl, et congue nisi. Vestibulum sollicitudin tellus id arcu vulputate.</p>\r\n','\r\n<p><strong> Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed quis nisi eget lacus varius suscipit. Praesent tincidunt leo sit amet hendrerit tincidunt. Donec pulvinar dolor massa, interdum iaculis leo ornare nec.</strong></p>\r\n<p> </p>\r\n<p>Vivamus sagittis felis in tellus mollis, sit amet imperdiet purus porta. Ut laoreet, ipsum quis blandit semper, erat mauris tempor nulla, molestie convallis mauris magna at metus. In non hendrerit ante. Cras non urna aliquam eros vehicula placerat condimentum varius dolor. Nam quis viverra risus. Class aptent taciti sociosqu ad litora torquent per conubia.</p>\r\n<p> </p>\r\n<p class="quote-left">Donec tempor tincidunt adipiscing. Etiam sed pretium risus, sed cursus lorem. In consectetur, odio eu mollis imperdiet, leo augue dapibus mi, quis imperdiet massa sapien nec enim. Proin sed purus augue. Cras luctus massa a ante dapibus, ut feugiat leo mattis.</p>\r\n<p> </p>\r\n<p>Vivamus vitae congue metus, vel ornare massa. Maecenas et auctor urna, scelerisque ornare arcu. Proin pharetra, ligula id adipiscing pulvinar, dui nulla luctus felis, sed viverra dui sapien non risus. Sed faucibus quam id metus rutrum volutpat ac quis nulla. Nulla facilisi.</p>\r\n<p> </p>\r\n<p>Vivamus ullamcorper mi quis lacus consectetur, quis sodales metus ultricies. Cras at mauris lobortis, congue elit nec, tristique odio. Praesent eu dui blandit, rhoncus mauris quis, commodo neque. Maecenas tellus dolor, commodo vel ullamcorper a, consectetur eget lorem. Proin scelerisque tortor tellus, sit amet pharetra augue pulvinar nec. Suspendisse potenti. Etiam congue, est non luctus luctus, turpis nulla lobortis risus, sit amet tempor tortor lorem vel nisl. Nunc ultrices est a risus ultricies lobortis.</p>\r\n<p> </p>\r\n<p>Suspendisse potenti. Nam pharetra, orci nec rutrum adipiscing, ligula quam gravida lorem, ac porttitor ligula mi quis nulla. Sed vitae malesuada turpis. Praesent blandit tellus risus. Vivamus rutrum risus quis mollis pulvinar. Ut euismod enim urna, nec ullamcorper orci blandit ac. Donec dapibus, nunc tincidunt rutrum eleifend, elit dolor pellentesque felis, vitae condimentum magna odio varius enim. Cras placerat nibh ac molestie consectetur. Nunc scelerisque eros nulla, sed consectetur nibh venenatis nec. Curabitur fermentum, tellus id blandit feugiat, tortor quam suscipit libero, sed molestie sapien erat sed diam. Ut tempor condimentum sem, sed ullamcorper libero scelerisque id. Maecenas nec ante pellentesque, ultricies ante ut, malesuada odio. Nam vitae tortor ullamcorper, ultrices elit nec, suscipit arcu.</p>\r\n<p> </p>\r\n<p>Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur?</p>','1','86','2014-05-23 07:22:59','499','','2015-05-07 09:35:22','545','0','0000-00-00 00:00:00','2014-05-23 07:22:59','0000-00-00 00:00:00','{"image_intro":"images\\/modules\\/slider\\/slide2.jpg","float_intro":"none","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/modules\\/slider\\/slide2.jpg","float_fulltext":"none","image_fulltext_alt":"","image_fulltext_caption":""}','{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}','{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}','16','2','','','1','29','{"robots":"","author":"","rights":"","xreference":""}','0','*',''),
('114','361','Spring cleaning','spring-cleaning','<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud. Cras euismod purus eget turpis semper gravida.</p>\r\n<p></p>\r\n<ul style="display: table;">\r\n<li>Nulla volutpat bibendum sapien, et pharetra mi pretium nec.</li>\r\n<li>Aenean ullamcorper tortor lacus.</li>\r\n<li>Sed in efficitur neque, ac dignissim est. Curabitur at ultrices justo, non blandit quam. In sed vehicula lectus. Quisque et varius leo, nec vestibulum nibh. Nam vel leo sapien. Suspendisse pulvinar vestibulum suscipit.</li>\r\n</ul>\r\n','\r\n<p>Ut bibendum non leo id pellentesque. In vehicula ipsum sapien. Nunc vel adipiscing lectus, vitae placerat libero. Nulla eleifend, magna sit amet viverra auctor, nunc dui adipiscing diam, at suscipit felis diam in est. Cras tempus lorem odio, et tristique diam iaculis in. Morbi quis sem dapibus, molestie purus sed, eleifend lectus.</p>\r\n<p>Nunc convallis at velit eget feugiat. Nunc quis nunc risus. Nunc id venenatis augue. Etiam eu viverra orci. Ut egestas vehicula consequat. Nunc facilisis imperdiet nibh bibendum tempus. Nullam et ante dui. Duis pulvinar purus nec ipsum pulvinar suscipit. Nunc ante purus, convallis vitae odio ut, feugiat aliquet tellus. Aenean et purus risus.</p>\r\n<p>In mattis varius sapien, eget tincidunt nibh vestibulum viverra. Nunc at dolor mauris. Donec felis lorem, vehicula non aliquam non, feugiat ut nunc. Proin id felis vehicula, rhoncus nisl non, porta eros. Aliquam metus massa, condimentum sed sapien at, egestas imperdiet odio. Suspendisse non molestie est. Quisque congue lorem eu maximus placerat. Phasellus tempus dolor a diam scelerisque blandit. In eu semper elit, sit amet tristique nisi. Sed vitae lectus eu leo pellentesque elementum sit amet tempor metus. Quisque maximus mollis velit, sed varius elit posuere vel. Suspendisse sed dolor in nulla fermentum maximus at quis ante.</p>\r\n<p>Aliquam diam urna, consectetur id cursus ac, efficitur vitae lectus. Pellentesque gravida ipsum sit amet est congue, vitae sagittis nisl porta. Quisque tincidunt felis eget leo iaculis, non scelerisque mi sagittis. Ut pulvinar lobortis urna at placerat. Sed consectetur metus justo, vel elementum tellus fermentum eu. Pellentesque vel ex varius, mattis lectus quis, varius massa. Morbi felis quam, ullamcorper nec sem id, tincidunt dictum nisi. Nunc nec justo gravida, viverra odio et, consequat ante. Proin condimentum nunc at dui sodales posuere. Mauris nibh tortor, dignissim non convallis in, efficitur ac nisl. Mauris vitae condimentum turpis, sit amet tempor urna. Donec lobortis cursus mi a molestie. Nam quis quam ut mi sollicitudin pellentesque.</p>','1','84','2014-12-11 13:39:26','499','','2015-05-07 09:34:31','545','0','0000-00-00 00:00:00','2014-12-11 13:39:26','0000-00-00 00:00:00','{"image_intro":"images\\/modules\\/tabs\\/s1.jpg","float_intro":"left","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/modules\\/slider\\/slide1.jpg","float_fulltext":"left","image_fulltext_alt":"","image_fulltext_caption":""}','{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}','{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}','18','0','','','1','26','{"robots":"","author":"","rights":"","xreference":""}','0','*',''),
('115','362','Support at every stage of homeownership','support-at-every-stage-of-homeownership','<p>Nam mattis luctus mauris. Nulla sodales accumsan semper. Ut lectus arcu, porta nec urna sit amet, placerat vestibulum quam. In pretium nunc eu purus sodales, in facilisis magna molestie. Quisque non luctus mauris, non volutpat lacus. In vestibulum lorem nec scelerisque gravida. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos.</p>\r\n','\r\n<p><strong> Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed quis nisi eget lacus varius suscipit. Praesent tincidunt leo sit amet hendrerit tincidunt. Donec pulvinar dolor massa, interdum iaculis leo ornare nec.</strong></p>\r\n<p></p>\r\n<p>Vivamus sagittis felis in tellus mollis, sit amet imperdiet purus porta. Ut laoreet, ipsum quis blandit semper, erat mauris tempor nulla, molestie convallis mauris magna at metus. In non hendrerit ante. Cras non urna aliquam eros vehicula placerat condimentum varius dolor. Nam quis viverra risus. Class aptent taciti sociosqu ad litora torquent per conubia.</p>\r\n<p></p>\r\n<p class="quote-left">Donec tempor tincidunt adipiscing. Etiam sed pretium risus, sed cursus lorem. In consectetur, odio eu mollis imperdiet, leo augue dapibus mi, quis imperdiet massa sapien nec enim. Proin sed purus augue. Cras luctus massa a ante dapibus, ut feugiat leo mattis.</p>\r\n<p></p>\r\n<p>Vivamus vitae congue metus, vel ornare massa. Maecenas et auctor urna, scelerisque ornare arcu. Proin pharetra, ligula id adipiscing pulvinar, dui nulla luctus felis, sed viverra dui sapien non risus. Sed faucibus quam id metus rutrum volutpat ac quis nulla. Nulla facilisi.</p>\r\n<p></p>\r\n<p>Vivamus ullamcorper mi quis lacus consectetur, quis sodales metus ultricies. Cras at mauris lobortis, congue elit nec, tristique odio. Praesent eu dui blandit, rhoncus mauris quis, commodo neque. Maecenas tellus dolor, commodo vel ullamcorper a, consectetur eget lorem. Proin scelerisque tortor tellus, sit amet pharetra augue pulvinar nec. Suspendisse potenti. Etiam congue, est non luctus luctus, turpis nulla lobortis risus, sit amet tempor tortor lorem vel nisl. Nunc ultrices est a risus ultricies lobortis.</p>\r\n<p></p>\r\n<p>Suspendisse potenti. Nam pharetra, orci nec rutrum adipiscing, ligula quam gravida lorem, ac porttitor ligula mi quis nulla. Sed vitae malesuada turpis. Praesent blandit tellus risus. Vivamus rutrum risus quis mollis pulvinar. Ut euismod enim urna, nec ullamcorper orci blandit ac. Donec dapibus, nunc tincidunt rutrum eleifend, elit dolor pellentesque felis, vitae condimentum magna odio varius enim. Cras placerat nibh ac molestie consectetur. Nunc scelerisque eros nulla, sed consectetur nibh venenatis nec. Curabitur fermentum, tellus id blandit feugiat, tortor quam suscipit libero, sed molestie sapien erat sed diam. Ut tempor condimentum sem, sed ullamcorper libero scelerisque id. Maecenas nec ante pellentesque, ultricies ante ut, malesuada odio. Nam vitae tortor ullamcorper, ultrices elit nec, suscipit arcu.</p>\r\n<p></p>\r\n<p>Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur?</p>','1','88','2014-12-11 14:35:59','499','','2014-12-15 08:24:28','182','0','0000-00-00 00:00:00','2014-12-11 14:35:59','0000-00-00 00:00:00','{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}','{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}','{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}','7','3','','','1','7','{"robots":"","author":"","rights":"","xreference":""}','0','*',''),
('116','363','Guard against fraud','guard-against-fraud','<p>Nam mattis luctus mauris. Nulla sodales accumsan semper. Ut lectus arcu, porta nec urna sit amet, placerat vestibulum quam.</p>\r\n<p></p>\r\n<p style="text-align: center;"><iframe src="//www.youtube.com/embed/47E0xfFxWJw" width="560" height="315" frameborder="0" allowfullscreen=""></iframe></p>\r\n','\r\n<p><strong> Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed quis nisi eget lacus varius suscipit. Praesent tincidunt leo sit amet hendrerit tincidunt. Donec pulvinar dolor massa, interdum iaculis leo ornare nec.</strong></p>\r\n<p></p>\r\n<p>Vivamus sagittis felis in tellus mollis, sit amet imperdiet purus porta. Ut laoreet, ipsum quis blandit semper, erat mauris tempor nulla, molestie convallis mauris magna at metus. In non hendrerit ante. Cras non urna aliquam eros vehicula placerat condimentum varius dolor. Nam quis viverra risus. Class aptent taciti sociosqu ad litora torquent per conubia.</p>\r\n<p></p>\r\n<p class="quote-left">Donec tempor tincidunt adipiscing. Etiam sed pretium risus, sed cursus lorem. In consectetur, odio eu mollis imperdiet, leo augue dapibus mi, quis imperdiet massa sapien nec enim. Proin sed purus augue. Cras luctus massa a ante dapibus, ut feugiat leo mattis.</p>\r\n<p></p>\r\n<p>Vivamus vitae congue metus, vel ornare massa. Maecenas et auctor urna, scelerisque ornare arcu. Proin pharetra, ligula id adipiscing pulvinar, dui nulla luctus felis, sed viverra dui sapien non risus. Sed faucibus quam id metus rutrum volutpat ac quis nulla. Nulla facilisi.</p>\r\n<p></p>\r\n<p>Vivamus ullamcorper mi quis lacus consectetur, quis sodales metus ultricies. Cras at mauris lobortis, congue elit nec, tristique odio. Praesent eu dui blandit, rhoncus mauris quis, commodo neque. Maecenas tellus dolor, commodo vel ullamcorper a, consectetur eget lorem. Proin scelerisque tortor tellus, sit amet pharetra augue pulvinar nec. Suspendisse potenti. Etiam congue, est non luctus luctus, turpis nulla lobortis risus, sit amet tempor tortor lorem vel nisl. Nunc ultrices est a risus ultricies lobortis.</p>\r\n<p></p>\r\n<p>Suspendisse potenti. Nam pharetra, orci nec rutrum adipiscing, ligula quam gravida lorem, ac porttitor ligula mi quis nulla. Sed vitae malesuada turpis. Praesent blandit tellus risus. Vivamus rutrum risus quis mollis pulvinar. Ut euismod enim urna, nec ullamcorper orci blandit ac. Donec dapibus, nunc tincidunt rutrum eleifend, elit dolor pellentesque felis, vitae condimentum magna odio varius enim. Cras placerat nibh ac molestie consectetur. Nunc scelerisque eros nulla, sed consectetur nibh venenatis nec. Curabitur fermentum, tellus id blandit feugiat, tortor quam suscipit libero, sed molestie sapien erat sed diam. Ut tempor condimentum sem, sed ullamcorper libero scelerisque id. Maecenas nec ante pellentesque, ultricies ante ut, malesuada odio. Nam vitae tortor ullamcorper, ultrices elit nec, suscipit arcu.</p>\r\n<p></p>\r\n<p>Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur?</p>','1','88','2014-12-11 14:35:59','499','','2014-12-15 11:36:40','182','0','0000-00-00 00:00:00','2014-12-11 14:35:59','0000-00-00 00:00:00','{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}','{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}','{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}','6','2','','','1','0','{"robots":"","author":"","rights":"","xreference":""}','0','*',''),
('117','364','Make saving money simpler','make-saving-money-simpler','<p>Nam mattis luctus mauris. Nulla sodales accumsan semper. Ut lectus arcu, porta nec urna sit amet, placerat vestibulum quam. In pretium nunc eu purus sodales, in facilisis magna molestie.</p>\r\n','\r\n<p><strong> Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed quis nisi eget lacus varius suscipit. Praesent tincidunt leo sit amet hendrerit tincidunt. Donec pulvinar dolor massa, interdum iaculis leo ornare nec.</strong></p>\r\n<p></p>\r\n<p>Vivamus sagittis felis in tellus mollis, sit amet imperdiet purus porta. Ut laoreet, ipsum quis blandit semper, erat mauris tempor nulla, molestie convallis mauris magna at metus. In non hendrerit ante. Cras non urna aliquam eros vehicula placerat condimentum varius dolor. Nam quis viverra risus. Class aptent taciti sociosqu ad litora torquent per conubia.</p>\r\n<p></p>\r\n<p class="quote-left">Donec tempor tincidunt adipiscing. Etiam sed pretium risus, sed cursus lorem. In consectetur, odio eu mollis imperdiet, leo augue dapibus mi, quis imperdiet massa sapien nec enim. Proin sed purus augue. Cras luctus massa a ante dapibus, ut feugiat leo mattis.</p>\r\n<p></p>\r\n<p>Vivamus vitae congue metus, vel ornare massa. Maecenas et auctor urna, scelerisque ornare arcu. Proin pharetra, ligula id adipiscing pulvinar, dui nulla luctus felis, sed viverra dui sapien non risus. Sed faucibus quam id metus rutrum volutpat ac quis nulla. Nulla facilisi.</p>\r\n<p></p>\r\n<p>Vivamus ullamcorper mi quis lacus consectetur, quis sodales metus ultricies. Cras at mauris lobortis, congue elit nec, tristique odio. Praesent eu dui blandit, rhoncus mauris quis, commodo neque. Maecenas tellus dolor, commodo vel ullamcorper a, consectetur eget lorem. Proin scelerisque tortor tellus, sit amet pharetra augue pulvinar nec. Suspendisse potenti. Etiam congue, est non luctus luctus, turpis nulla lobortis risus, sit amet tempor tortor lorem vel nisl. Nunc ultrices est a risus ultricies lobortis.</p>\r\n<p></p>\r\n<p>Suspendisse potenti. Nam pharetra, orci nec rutrum adipiscing, ligula quam gravida lorem, ac porttitor ligula mi quis nulla. Sed vitae malesuada turpis. Praesent blandit tellus risus. Vivamus rutrum risus quis mollis pulvinar. Ut euismod enim urna, nec ullamcorper orci blandit ac. Donec dapibus, nunc tincidunt rutrum eleifend, elit dolor pellentesque felis, vitae condimentum magna odio varius enim. Cras placerat nibh ac molestie consectetur. Nunc scelerisque eros nulla, sed consectetur nibh venenatis nec. Curabitur fermentum, tellus id blandit feugiat, tortor quam suscipit libero, sed molestie sapien erat sed diam. Ut tempor condimentum sem, sed ullamcorper libero scelerisque id. Maecenas nec ante pellentesque, ultricies ante ut, malesuada odio. Nam vitae tortor ullamcorper, ultrices elit nec, suscipit arcu.</p>\r\n<p></p>\r\n<p>Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur?</p>','1','88','2014-12-11 14:35:59','499','','2014-12-15 11:36:27','182','0','0000-00-00 00:00:00','2014-12-11 14:35:59','0000-00-00 00:00:00','{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}','{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}','{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}','2','1','','','1','0','{"robots":"","author":"","rights":"","xreference":""}','0','*',''),
('118','365','Make no payments while you\'re in school','make-no-payments-while-you-re-in-school','<p>Nam mattis luctus mauris. Nulla sodales accumsan semper. Ut lectus arcu, porta nec urna sit amet, placerat vestibulum quam. In pretium nunc eu purus sodales, in facilisis magna molestie.</p>\r\n<p>Donec hendrerit, purus nec blandit posuere, nisi justo tincidunt sapien, quis suscipit sapien lorem vitae nunc. Suspendisse potenti. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Fusce non dignissim leo.</p>\r\n','\r\n<p><strong> Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed quis nisi eget lacus varius suscipit. Praesent tincidunt leo sit amet hendrerit tincidunt. Donec pulvinar dolor massa, interdum iaculis leo ornare nec.</strong></p>\r\n<p></p>\r\n<p>Vivamus sagittis felis in tellus mollis, sit amet imperdiet purus porta. Ut laoreet, ipsum quis blandit semper, erat mauris tempor nulla, molestie convallis mauris magna at metus. In non hendrerit ante. Cras non urna aliquam eros vehicula placerat condimentum varius dolor. Nam quis viverra risus. Class aptent taciti sociosqu ad litora torquent per conubia.</p>\r\n<p></p>\r\n<p class="quote-left">Donec tempor tincidunt adipiscing. Etiam sed pretium risus, sed cursus lorem. In consectetur, odio eu mollis imperdiet, leo augue dapibus mi, quis imperdiet massa sapien nec enim. Proin sed purus augue. Cras luctus massa a ante dapibus, ut feugiat leo mattis.</p>\r\n<p></p>\r\n<p>Vivamus vitae congue metus, vel ornare massa. Maecenas et auctor urna, scelerisque ornare arcu. Proin pharetra, ligula id adipiscing pulvinar, dui nulla luctus felis, sed viverra dui sapien non risus. Sed faucibus quam id metus rutrum volutpat ac quis nulla. Nulla facilisi.</p>\r\n<p></p>\r\n<p>Vivamus ullamcorper mi quis lacus consectetur, quis sodales metus ultricies. Cras at mauris lobortis, congue elit nec, tristique odio. Praesent eu dui blandit, rhoncus mauris quis, commodo neque. Maecenas tellus dolor, commodo vel ullamcorper a, consectetur eget lorem. Proin scelerisque tortor tellus, sit amet pharetra augue pulvinar nec. Suspendisse potenti. Etiam congue, est non luctus luctus, turpis nulla lobortis risus, sit amet tempor tortor lorem vel nisl. Nunc ultrices est a risus ultricies lobortis.</p>\r\n<p></p>\r\n<p>Suspendisse potenti. Nam pharetra, orci nec rutrum adipiscing, ligula quam gravida lorem, ac porttitor ligula mi quis nulla. Sed vitae malesuada turpis. Praesent blandit tellus risus. Vivamus rutrum risus quis mollis pulvinar. Ut euismod enim urna, nec ullamcorper orci blandit ac. Donec dapibus, nunc tincidunt rutrum eleifend, elit dolor pellentesque felis, vitae condimentum magna odio varius enim. Cras placerat nibh ac molestie consectetur. Nunc scelerisque eros nulla, sed consectetur nibh venenatis nec. Curabitur fermentum, tellus id blandit feugiat, tortor quam suscipit libero, sed molestie sapien erat sed diam. Ut tempor condimentum sem, sed ullamcorper libero scelerisque id. Maecenas nec ante pellentesque, ultricies ante ut, malesuada odio. Nam vitae tortor ullamcorper, ultrices elit nec, suscipit arcu.</p>\r\n<p></p>\r\n<p>Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur?</p>','1','88','2014-12-11 14:35:59','499','','2014-12-15 12:36:01','182','0','0000-00-00 00:00:00','2014-12-11 14:35:59','0000-00-00 00:00:00','{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}','{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}','{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}','4','0','','','1','0','{"robots":"","author":"","rights":"","xreference":""}','0','*',''),
('119','367','Coming Soon','coming-soon','<div style="display: block; width: 80%; margin: auto;">\r\n<p><img class="border_img1" style="display: block; margin-left: auto; margin-right: auto;" src="images/features/coming-soon.png" alt="" /></p>\r\n<br />\r\n<p></p>\r\n<p>You can make your Joomla! website unavailable to visitors until selected date. To enable this option login to Administrator back-end.</p>\r\n<p>1. Click the <strong>Extensions → Template Manager → JM-Template-Name → Basic Settings</strong> menu item</p>\r\n<p>2. Find field <strong>Coming Soon</strong> and click Enable button.</p>\r\n<p>3. Next set date in filed <strong>Coming Soon Date</strong>.</p>\r\n<p>Click the Save button to implement the new settings.</p>\r\n<p></p>\r\n<p>Title and description you can change in <strong>Extensions → Module Manager</strong>. Find module <strong>Our site is coming soon</strong> on position <strong>coming-soon</strong>. You can also publish different type of module if you like.</p>\r\n<p></p>\r\n<p>Coming Soon page can be easily customised in file - <strong>/templates/jm-template-name/tpl/comingsoon.php</strong></p>\r\n</div>','','1','82','2014-12-12 07:42:01','499','','2015-05-06 11:57:47','545','0','0000-00-00 00:00:00','2014-12-12 07:42:01','0000-00-00 00:00:00','{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}','{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}','{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}','4','2','','','1','14','{"robots":"","author":"","rights":"","xreference":""}','0','*',''),
('120','368','Frequently Asked Questions','frequently-asked-questions','<hr class="system-pagebreak" title="Question 1" />\r\n<p>Ut lectus felis, facilisis nec erat at, pretium pellentesque lectus. Donec sit amet nibh est. Morbi augue libero, pretium vitae nulla ac, malesuada ultricies neque. Donec eget neque erat. Nam dictum justo sit amet placerat consectetur.</p>\r\n<p>Maecenas laoreet, ligula vel scelerisque ultricies, lorem urna luctus odio, eget convallis urna erat quis justo. Morbi vel placerat nisl, ut tempor odio. Sed lacinia purus sit amet lorem dictum tincidunt. Nunc placerat egestas vehicula. Fusce eu risus sit amet metus sagittis volutpat vehicula porttitor elit. Sed fringilla purus sed mi scelerisque scelerisque. Donec vel enim ligula. Phasellus vulputate ac dui aliquet dapibus. Suspendisse ut vestibulum tellus, sed gravida arcu. Aliquam erat volutpat.</p>\r\n<p>Donec sit amet eleifend tortor. In mattis velit ut nunc luctus ultrices. Nunc aliquet risus eget lorem dignissim, id imperdiet nulla ultricies. Sed euismod bibendum dui, vel faucibus quam tempor at. Etiam sagittis massa in urna sagittis, non viverra nibh placerat.</p>\r\n<hr class="system-pagebreak" title="Question 2" />\r\n<p>Cras eu quam vitae magna cursus adipiscing. Etiam quis mi lacus. Proin fermentum velit non ligula malesuada imperdiet. Sed sapien enim, porta vel tempus sed, suscipit quis nisl. In vestibulum ut massa eu feugiat. Nulla vestibulum ultrices felis sit amet dapibus. Suspendisse et ligula hendrerit, auctor justo vel, sagittis metus.</p>\r\n<p>Mauris tincidunt quam eu pulvinar sagittis. Pellentesque imperdiet, purus vel feugiat pharetra, lectus velit scelerisque nisi, a aliquam nibh augue vel urna. In volutpat tellus et pulvinar varius. Aenean ultricies euismod rhoncus.</p>\r\n<p>Nunc tincidunt eros ut mauris ullamcorper, vitae semper ligula convallis. Morbi tincidunt congue venenatis. Fusce at vestibulum nisl, et congue nisi. Vestibulum sollicitudin tellus id arcu vulputate, sit amet vestibulum est pulvinar.</p>\r\n<hr class="system-pagebreak" title="Question 3" />\r\n<p>Cras eleifend iaculis purus sed hendrerit. Nulla facilisi. Sed congue semper consequat. Nam viverra semper libero, a luctus eros. Nulla porttitor commodo velit nec rhoncus. Vivamus blandit tellus risus, et hendrerit nisi aliquet ut. Ut imperdiet orci tellus, in tristique urna mattis eu. Pellentesque ligula nisl, hendrerit nec facilisis sit amet, faucibus ac nulla.</p>\r\n<p>Morbi et consectetur ante. Etiam eu sodales tortor, ac dapibus lectus. In laoreet tempor felis, in ornare urna consequat sit amet. Praesent vehicula libero ac tellus rutrum ultrices. Sed eu consectetur libero, id varius massa. Quisque vestibulum tempus felis. Nulla interdum varius arcu nec accumsan.</p>\r\n<p>Suspendisse pellentesque placerat risus id porttitor. Morbi elit nulla, tincidunt sit amet justo sit amet, adipiscing molestie quam. Proin hendrerit eleifend egestas. In erat enim, ultricies nec nunc mattis, sodales placerat lacus. Nam ultrices adipiscing volutpat.</p>','','1','82','2014-12-12 07:45:13','499','','0000-00-00 00:00:00','0','0','0000-00-00 00:00:00','2014-12-12 07:45:13','0000-00-00 00:00:00','{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}','{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}','{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}','1','1','','','1','6','{"robots":"","author":"","rights":"","xreference":""}','0','*',''),
('121','370','Error 404','error-404','<p></p>\r\n<div class="jm-error-page">\r\n<h1>404 OOPS!</h1>\r\n<h2>page Not found!</h2>\r\n<p>"Sorry, it appears the page you were looking for doesn\'t exist anymore or might have been moved.<br />Please try your luck again."</p>\r\n<a class="btn" href="index.php">Take me home</a>\r\n<p></p>\r\n</div>\r\n<p style="text-align: center;">This is Joomla! Article, You can change text and titile in Article Manager, click the <strong>Content → Article Manager</strong> menu item and find article <strong>Error 404</strong>.</p>\r\n<p style="text-align: center;">If you want select other article you can change article ID in <strong>/templates/template-name/error.php</strong></p>','','1','82','2014-12-12 10:13:31','499','','0000-00-00 00:00:00','0','0','0000-00-00 00:00:00','2014-12-12 10:13:31','0000-00-00 00:00:00','{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}','{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}','{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}','1','0','','','1','15','{"robots":"","author":"","rights":"","xreference":""}','0','*',''),
('122','410','Dream to live clean?','dream-to-live-clean','<p>Nam mattis luctus mauris. Nulla sodales accumsan semper. Ut lectus arcu, porta nec urna sit amet, placerat vestibulum quam. In pretium nunc eu purus sodales, in facilisis magna molestie.</p>\r\n','\r\n<p><strong> Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed quis nisi eget lacus varius suscipit. Praesent tincidunt leo sit amet hendrerit tincidunt. Donec pulvinar dolor massa, interdum iaculis leo ornare nec.</strong></p>\r\n<p> </p>\r\n<p>Vivamus sagittis felis in tellus mollis, sit amet imperdiet purus porta. Ut laoreet, ipsum quis blandit semper, erat mauris tempor nulla, molestie convallis mauris magna at metus. In non hendrerit ante. Cras non urna aliquam eros vehicula placerat condimentum varius dolor. Nam quis viverra risus. Class aptent taciti sociosqu ad litora torquent per conubia.</p>\r\n<p> </p>\r\n<p class="quote-left">Donec tempor tincidunt adipiscing. Etiam sed pretium risus, sed cursus lorem. In consectetur, odio eu mollis imperdiet, leo augue dapibus mi, quis imperdiet massa sapien nec enim. Proin sed purus augue. Cras luctus massa a ante dapibus, ut feugiat leo mattis.</p>\r\n<p> </p>\r\n<p>Vivamus vitae congue metus, vel ornare massa. Maecenas et auctor urna, scelerisque ornare arcu. Proin pharetra, ligula id adipiscing pulvinar, dui nulla luctus felis, sed viverra dui sapien non risus. Sed faucibus quam id metus rutrum volutpat ac quis nulla. Nulla facilisi.</p>\r\n<p> </p>\r\n<p>Vivamus ullamcorper mi quis lacus consectetur, quis sodales metus ultricies. Cras at mauris lobortis, congue elit nec, tristique odio. Praesent eu dui blandit, rhoncus mauris quis, commodo neque. Maecenas tellus dolor, commodo vel ullamcorper a, consectetur eget lorem. Proin scelerisque tortor tellus, sit amet pharetra augue pulvinar nec. Suspendisse potenti. Etiam congue, est non luctus luctus, turpis nulla lobortis risus, sit amet tempor tortor lorem vel nisl. Nunc ultrices est a risus ultricies lobortis.</p>\r\n<p> </p>\r\n<p>Suspendisse potenti. Nam pharetra, orci nec rutrum adipiscing, ligula quam gravida lorem, ac porttitor ligula mi quis nulla. Sed vitae malesuada turpis. Praesent blandit tellus risus. Vivamus rutrum risus quis mollis pulvinar. Ut euismod enim urna, nec ullamcorper orci blandit ac. Donec dapibus, nunc tincidunt rutrum eleifend, elit dolor pellentesque felis, vitae condimentum magna odio varius enim. Cras placerat nibh ac molestie consectetur. Nunc scelerisque eros nulla, sed consectetur nibh venenatis nec. Curabitur fermentum, tellus id blandit feugiat, tortor quam suscipit libero, sed molestie sapien erat sed diam. Ut tempor condimentum sem, sed ullamcorper libero scelerisque id. Maecenas nec ante pellentesque, ultricies ante ut, malesuada odio. Nam vitae tortor ullamcorper, ultrices elit nec, suscipit arcu.</p>\r\n<p> </p>\r\n<p>Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur?</p>','1','86','2014-05-23 07:22:59','499','','2015-05-07 09:35:08','545','0','0000-00-00 00:00:00','2014-05-23 07:22:59','0000-00-00 00:00:00','{"image_intro":"images\\/modules\\/slider\\/slide1.jpg","float_intro":"none","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/modules\\/slider\\/slide1.jpg","float_fulltext":"none","image_fulltext_alt":"","image_fulltext_caption":""}','{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}','{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}','5','1','','','1','15','{"robots":"","author":"","rights":"","xreference":""}','0','*','');

DROP TABLE IF EXISTS #__content_frontpage;
CREATE TABLE `#__content_frontpage` (
  `content_id` int(11) NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`content_id`)
) DEFAULT CHARSET=utf8;

INSERT INTO `#__content_frontpage` VALUES 
('8','2'),
('24','1'),
('35','4'),
('50','3');

DROP TABLE IF EXISTS #__content_rating;
CREATE TABLE `#__content_rating` (
  `content_id` int(11) NOT NULL DEFAULT '0',
  `rating_sum` int(10) unsigned NOT NULL DEFAULT '0',
  `rating_count` int(10) unsigned NOT NULL DEFAULT '0',
  `lastip` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`content_id`)
) DEFAULT CHARSET=utf8;

INSERT INTO `#__content_rating` VALUES 
('10','4','1','212.109.165.124'),
('53','3','1','212.109.165.124');

DROP TABLE IF EXISTS #__content_types;
CREATE TABLE `#__content_types` (
  `type_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type_title` varchar(255) NOT NULL DEFAULT '',
  `type_alias` varchar(400) NOT NULL DEFAULT '',
  `table` varchar(255) NOT NULL DEFAULT '',
  `rules` mediumtext NOT NULL,
  `field_mappings` mediumtext NOT NULL,
  `router` varchar(255) NOT NULL DEFAULT '',
  `content_history_options` varchar(5120) NOT NULL COMMENT 'JSON string for com_contenthistory options',
  PRIMARY KEY (`type_id`),
  KEY `idx_alias` (`type_alias`(100))
) AUTO_INCREMENT=10005 DEFAULT CHARSET=utf8;

INSERT INTO `#__content_types` VALUES 
('1','Article','com_content.article','{"special":{"dbtable":"#__content","key":"id","type":"Content","prefix":"JTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}','','{"common":{"core_content_item_id":"id","core_title":"title","core_state":"state","core_alias":"alias","core_created_time":"created","core_modified_time":"modified","core_body":"introtext", "core_hits":"hits","core_publish_up":"publish_up","core_publish_down":"publish_down","core_access":"access", "core_params":"attribs", "core_featured":"featured", "core_metadata":"metadata", "core_language":"language", "core_images":"images", "core_urls":"urls", "core_version":"version", "core_ordering":"ordering", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"catid", "core_xreference":"xreference", "asset_id":"asset_id"}, "special": {"fulltext":"fulltext"}}','ContentHelperRoute::getArticleRoute','{"formFile":"administrator\\/components\\/com_content\\/models\\/forms\\/article.xml", "hideFields":["asset_id","checked_out","checked_out_time","version"],"ignoreChanges":["modified_by", "modified", "checked_out", "checked_out_time", "version", "hits"],"convertToInt":["publish_up", "publish_down", "featured", "ordering"],"displayLookup":[{"sourceColumn":"catid","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"created_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"} ]}'),
('2','Weblink','com_weblinks.weblink','{"special":{"dbtable":"#__weblinks","key":"id","type":"Weblink","prefix":"WeblinksTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}','','{"common":{"core_content_item_id":"id","core_title":"title","core_state":"state","core_alias":"alias","core_created_time":"created","core_modified_time":"modified","core_body":"description", "core_hits":"hits","core_publish_up":"publish_up","core_publish_down":"publish_down","core_access":"access", "core_params":"params", "core_featured":"featured", "core_metadata":"metadata", "core_language":"language", "core_images":"images", "core_urls":"url", "core_version":"version", "core_ordering":"ordering", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"catid", "core_xreference":"xreference", "asset_id":"null"}, "special": {}}','WeblinksHelperRoute::getWeblinkRoute','{"formFile":"administrator\\/components\\/com_weblinks\\/models\\/forms\\/weblink.xml", "hideFields":["asset_id","checked_out","checked_out_time","version","featured","images"], "ignoreChanges":["modified_by", "modified", "checked_out", "checked_out_time", "version", "hits"], "convertToInt":["publish_up", "publish_down", "featured", "ordering"], "displayLookup":[{"sourceColumn":"catid","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"created_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"} ]}'),
('3','Contact','com_contact.contact','{"special":{"dbtable":"#__contact_details","key":"id","type":"Contact","prefix":"ContactTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}','','{"common":{"core_content_item_id":"id","core_title":"name","core_state":"published","core_alias":"alias","core_created_time":"created","core_modified_time":"modified","core_body":"address", "core_hits":"hits","core_publish_up":"publish_up","core_publish_down":"publish_down","core_access":"access", "core_params":"params", "core_featured":"featured", "core_metadata":"metadata", "core_language":"language", "core_images":"image", "core_urls":"webpage", "core_version":"version", "core_ordering":"ordering", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"catid", "core_xreference":"xreference", "asset_id":"null"}, "special": {"con_position":"con_position","suburb":"suburb","state":"state","country":"country","postcode":"postcode","telephone":"telephone","fax":"fax","misc":"misc","email_to":"email_to","default_con":"default_con","user_id":"user_id","mobile":"mobile","sortname1":"sortname1","sortname2":"sortname2","sortname3":"sortname3"}}','ContactHelperRoute::getContactRoute','{"formFile":"administrator\\/components\\/com_contact\\/models\\/forms\\/contact.xml","hideFields":["default_con","checked_out","checked_out_time","version","xreference"],"ignoreChanges":["modified_by", "modified", "checked_out", "checked_out_time", "version", "hits"],"convertToInt":["publish_up", "publish_down", "featured", "ordering"], "displayLookup":[ {"sourceColumn":"created_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"catid","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"} ] }'),
('4','Newsfeed','com_newsfeeds.newsfeed','{"special":{"dbtable":"#__newsfeeds","key":"id","type":"Newsfeed","prefix":"NewsfeedsTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}','','{"common":{"core_content_item_id":"id","core_title":"name","core_state":"published","core_alias":"alias","core_created_time":"created","core_modified_time":"modified","core_body":"description", "core_hits":"hits","core_publish_up":"publish_up","core_publish_down":"publish_down","core_access":"access", "core_params":"params", "core_featured":"featured", "core_metadata":"metadata", "core_language":"language", "core_images":"images", "core_urls":"link", "core_version":"version", "core_ordering":"ordering", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"catid", "core_xreference":"xreference", "asset_id":"null"}, "special": {"numarticles":"numarticles","cache_time":"cache_time","rtl":"rtl"}}','NewsfeedsHelperRoute::getNewsfeedRoute','{"formFile":"administrator\\/components\\/com_newsfeeds\\/models\\/forms\\/newsfeed.xml","hideFields":["asset_id","checked_out","checked_out_time","version"],"ignoreChanges":["modified_by", "modified", "checked_out", "checked_out_time", "version", "hits"],"convertToInt":["publish_up", "publish_down", "featured", "ordering"],"displayLookup":[{"sourceColumn":"catid","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"created_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"}]}'),
('5','User','com_users.user','{"special":{"dbtable":"#__users","key":"id","type":"User","prefix":"JTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}','','{"common":{"core_content_item_id":"id","core_title":"name","core_state":"null","core_alias":"username","core_created_time":"registerdate","core_modified_time":"lastvisitDate","core_body":"null", "core_hits":"null","core_publish_up":"null","core_publish_down":"null","access":"null", "core_params":"params", "core_featured":"null", "core_metadata":"null", "core_language":"null", "core_images":"null", "core_urls":"null", "core_version":"null", "core_ordering":"null", "core_metakey":"null", "core_metadesc":"null", "core_catid":"null", "core_xreference":"null", "asset_id":"null"}, "special": {}}','UsersHelperRoute::getUserRoute',''),
('6','Article Category','com_content.category','{"special":{"dbtable":"#__categories","key":"id","type":"Category","prefix":"JTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}','','{"common":{"core_content_item_id":"id","core_title":"title","core_state":"published","core_alias":"alias","core_created_time":"created_time","core_modified_time":"modified_time","core_body":"description", "core_hits":"hits","core_publish_up":"null","core_publish_down":"null","core_access":"access", "core_params":"params", "core_featured":"null", "core_metadata":"metadata", "core_language":"language", "core_images":"null", "core_urls":"null", "core_version":"version", "core_ordering":"null", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"parent_id", "core_xreference":"null", "asset_id":"asset_id"}, "special": {"parent_id":"parent_id","lft":"lft","rgt":"rgt","level":"level","path":"path","extension":"extension","note":"note"}}','ContentHelperRoute::getCategoryRoute','{"formFile":"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml", "hideFields":["asset_id","checked_out","checked_out_time","version","lft","rgt","level","path","extension"], "ignoreChanges":["modified_user_id", "modified_time", "checked_out", "checked_out_time", "version", "hits", "path"],"convertToInt":["publish_up", "publish_down"], "displayLookup":[{"sourceColumn":"created_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"parent_id","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"}]}'),
('7','Contact Category','com_contact.category','{"special":{"dbtable":"#__categories","key":"id","type":"Category","prefix":"JTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}','','{"common":{"core_content_item_id":"id","core_title":"title","core_state":"published","core_alias":"alias","core_created_time":"created_time","core_modified_time":"modified_time","core_body":"description", "core_hits":"hits","core_publish_up":"null","core_publish_down":"null","core_access":"access", "core_params":"params", "core_featured":"null", "core_metadata":"metadata", "core_language":"language", "core_images":"null", "core_urls":"null", "core_version":"version", "core_ordering":"null", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"parent_id", "core_xreference":"null", "asset_id":"asset_id"}, "special": {"parent_id":"parent_id","lft":"lft","rgt":"rgt","level":"level","path":"path","extension":"extension","note":"note"}}','ContactHelperRoute::getCategoryRoute','{"formFile":"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml", "hideFields":["asset_id","checked_out","checked_out_time","version","lft","rgt","level","path","extension"], "ignoreChanges":["modified_user_id", "modified_time", "checked_out", "checked_out_time", "version", "hits", "path"],"convertToInt":["publish_up", "publish_down"], "displayLookup":[{"sourceColumn":"created_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"parent_id","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"}]}'),
('8','Newsfeeds Category','com_newsfeeds.category','{"special":{"dbtable":"#__categories","key":"id","type":"Category","prefix":"JTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}','','{"common":{"core_content_item_id":"id","core_title":"title","core_state":"published","core_alias":"alias","core_created_time":"created_time","core_modified_time":"modified_time","core_body":"description", "core_hits":"hits","core_publish_up":"null","core_publish_down":"null","core_access":"access", "core_params":"params", "core_featured":"null", "core_metadata":"metadata", "core_language":"language", "core_images":"null", "core_urls":"null", "core_version":"version", "core_ordering":"null", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"parent_id", "core_xreference":"null", "asset_id":"asset_id"}, "special": {"parent_id":"parent_id","lft":"lft","rgt":"rgt","level":"level","path":"path","extension":"extension","note":"note"}}','NewsfeedsHelperRoute::getCategoryRoute','{"formFile":"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml", "hideFields":["asset_id","checked_out","checked_out_time","version","lft","rgt","level","path","extension"], "ignoreChanges":["modified_user_id", "modified_time", "checked_out", "checked_out_time", "version", "hits", "path"],"convertToInt":["publish_up", "publish_down"], "displayLookup":[{"sourceColumn":"created_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"parent_id","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"}]}'),
('9','Weblinks Category','com_weblinks.category','{"special":{"dbtable":"#__categories","key":"id","type":"Category","prefix":"JTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}','','{"common":{"core_content_item_id":"id","core_title":"title","core_state":"published","core_alias":"alias","core_created_time":"created_time","core_modified_time":"modified_time","core_body":"description", "core_hits":"hits","core_publish_up":"null","core_publish_down":"null","core_access":"access", "core_params":"params", "core_featured":"null", "core_metadata":"metadata", "core_language":"language", "core_images":"null", "core_urls":"null", "core_version":"version", "core_ordering":"null", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"parent_id", "core_xreference":"null", "asset_id":"asset_id"}, "special": {"parent_id":"parent_id","lft":"lft","rgt":"rgt","level":"level","path":"path","extension":"extension","note":"note"}}','WeblinksHelperRoute::getCategoryRoute','{"formFile":"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml", "hideFields":["asset_id","checked_out","checked_out_time","version","lft","rgt","level","path","extension"], "ignoreChanges":["modified_user_id", "modified_time", "checked_out", "checked_out_time", "version", "hits", "path"],"convertToInt":["publish_up", "publish_down"], "displayLookup":[{"sourceColumn":"created_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"parent_id","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"}]}'),
('10','Tag','com_tags.tag','{"special":{"dbtable":"#__tags","key":"tag_id","type":"Tag","prefix":"TagsTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}','','{"common":{"core_content_item_id":"id","core_title":"title","core_state":"published","core_alias":"alias","core_created_time":"created_time","core_modified_time":"modified_time","core_body":"description", "core_hits":"hits","core_publish_up":"null","core_publish_down":"null","core_access":"access", "core_params":"params", "core_featured":"featured", "core_metadata":"metadata", "core_language":"language", "core_images":"images", "core_urls":"urls", "core_version":"version", "core_ordering":"null", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"null", "core_xreference":"null", "asset_id":"null"}, "special": {"parent_id":"parent_id","lft":"lft","rgt":"rgt","level":"level","path":"path"}}','TagsHelperRoute::getTagRoute','{"formFile":"administrator\\/components\\/com_tags\\/models\\/forms\\/tag.xml", "hideFields":["checked_out","checked_out_time","version", "lft", "rgt", "level", "path", "urls", "publish_up", "publish_down"],"ignoreChanges":["modified_user_id", "modified_time", "checked_out", "checked_out_time", "version", "hits", "path"],"convertToInt":["publish_up", "publish_down"], "displayLookup":[{"sourceColumn":"created_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"}, {"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"}, {"sourceColumn":"modified_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"}]}'),
('10000','Banner','com_banners.banner','{"special":{"dbtable":"#__banners","key":"id","type":"Banner","prefix":"BannersTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}','','{"common":{"core_content_item_id":"id","core_title":"name","core_state":"published","core_alias":"alias","core_created_time":"created","core_modified_time":"modified","core_body":"description", "core_hits":"null","core_publish_up":"publish_up","core_publish_down":"publish_down","core_access":"access", "core_params":"params", "core_featured":"null", "core_metadata":"metadata", "core_language":"language", "core_images":"images", "core_urls":"link", "core_version":"version", "core_ordering":"ordering", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"catid", "core_xreference":"null", "asset_id":"null"}, "special":{"imptotal":"imptotal", "impmade":"impmade", "clicks":"clicks", "clickurl":"clickurl", "custombannercode":"custombannercode", "cid":"cid", "purchase_type":"purchase_type", "track_impressions":"track_impressions", "track_clicks":"track_clicks"}}','','{"formFile":"administrator\\/components\\/com_banners\\/models\\/forms\\/banner.xml", "hideFields":["checked_out","checked_out_time","version", "reset"],"ignoreChanges":["modified_by", "modified", "checked_out", "checked_out_time", "version", "imptotal", "impmade", "reset"], "convertToInt":["publish_up", "publish_down", "ordering"], "displayLookup":[{"sourceColumn":"catid","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"}, {"sourceColumn":"cid","targetTable":"#__banner_clients","targetColumn":"id","displayColumn":"name"}, {"sourceColumn":"created_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"modified_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"}]}'),
('10001','Banners Category','com_banners.category','{"special":{"dbtable":"#__categories","key":"id","type":"Category","prefix":"JTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}','','{"common":{"core_content_item_id":"id","core_title":"title","core_state":"published","core_alias":"alias","core_created_time":"created_time","core_modified_time":"modified_time","core_body":"description", "core_hits":"hits","core_publish_up":"null","core_publish_down":"null","core_access":"access", "core_params":"params", "core_featured":"null", "core_metadata":"metadata", "core_language":"language", "core_images":"null", "core_urls":"null", "core_version":"version", "core_ordering":"null", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"parent_id", "core_xreference":"null", "asset_id":"asset_id"}, "special": {"parent_id":"parent_id","lft":"lft","rgt":"rgt","level":"level","path":"path","extension":"extension","note":"note"}}','','{"formFile":"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml", "hideFields":["asset_id","checked_out","checked_out_time","version","lft","rgt","level","path","extension"], "ignoreChanges":["modified_user_id", "modified_time", "checked_out", "checked_out_time", "version", "hits", "path"], "convertToInt":["publish_up", "publish_down"], "displayLookup":[{"sourceColumn":"created_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"parent_id","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"}]}'),
('10002','Banner Client','com_banners.client','{"special":{"dbtable":"#__banner_clients","key":"id","type":"Client","prefix":"BannersTable"}}','','','','{"formFile":"administrator\\/components\\/com_banners\\/models\\/forms\\/client.xml", "hideFields":["checked_out","checked_out_time"], "ignoreChanges":["checked_out", "checked_out_time"], "convertToInt":[], "displayLookup":[]}'),
('10003','User Notes','com_users.note','{"special":{"dbtable":"#__user_notes","key":"id","type":"Note","prefix":"UsersTable"}}','','','','{"formFile":"administrator\\/components\\/com_users\\/models\\/forms\\/note.xml", "hideFields":["checked_out","checked_out_time", "publish_up", "publish_down"],"ignoreChanges":["modified_user_id", "modified_time", "checked_out", "checked_out_time"], "convertToInt":["publish_up", "publish_down"],"displayLookup":[{"sourceColumn":"catid","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"}, {"sourceColumn":"created_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"}, {"sourceColumn":"user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"}, {"sourceColumn":"modified_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"}]}'),
('10004','User Notes Category','com_users.category','{"special":{"dbtable":"#__categories","key":"id","type":"Category","prefix":"JTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}','','{"common":{"core_content_item_id":"id","core_title":"title","core_state":"published","core_alias":"alias","core_created_time":"created_time","core_modified_time":"modified_time","core_body":"description", "core_hits":"hits","core_publish_up":"null","core_publish_down":"null","core_access":"access", "core_params":"params", "core_featured":"null", "core_metadata":"metadata", "core_language":"language", "core_images":"null", "core_urls":"null", "core_version":"version", "core_ordering":"null", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"parent_id", "core_xreference":"null", "asset_id":"asset_id"}, "special":{"parent_id":"parent_id","lft":"lft","rgt":"rgt","level":"level","path":"path","extension":"extension","note":"note"}}','','{"formFile":"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml", "hideFields":["checked_out","checked_out_time","version","lft","rgt","level","path","extension"], "ignoreChanges":["modified_user_id", "modified_time", "checked_out", "checked_out_time", "version", "hits", "path"], "convertToInt":["publish_up", "publish_down"], "displayLookup":[{"sourceColumn":"created_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"}, {"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"parent_id","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"}]}');

DROP TABLE IF EXISTS #__contentitem_tag_map;
CREATE TABLE `#__contentitem_tag_map` (
  `type_alias` varchar(255) NOT NULL DEFAULT '',
  `core_content_id` int(10) unsigned NOT NULL COMMENT 'PK from the core content table',
  `content_item_id` int(11) NOT NULL COMMENT 'PK from the content type table',
  `tag_id` int(10) unsigned NOT NULL COMMENT 'PK from the tag table',
  `tag_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Date of most recent save for this tag-item',
  `type_id` mediumint(8) NOT NULL COMMENT 'PK from the content_type table',
  UNIQUE KEY `uc_ItemnameTagid` (`type_id`,`content_item_id`,`tag_id`),
  KEY `idx_tag_type` (`tag_id`,`type_id`),
  KEY `idx_date_id` (`tag_date`,`tag_id`),
  KEY `idx_core_content_id` (`core_content_id`)
) DEFAULT CHARSET=utf8 COMMENT='Maps items from content tables to tags';

INSERT INTO `#__contentitem_tag_map` VALUES 
('com_content.article','6','103','12','2015-05-07 11:28:54','1'),
('com_content.article','6','103','15','2015-05-07 11:28:54','1'),
('com_content.article','6','103','17','2015-05-07 11:28:54','1'),
('com_content.article','5','104','12','2015-05-07 11:26:32','1'),
('com_content.article','5','104','13','2015-05-07 11:26:32','1'),
('com_content.article','5','104','14','2015-05-07 11:26:32','1'),
('com_content.article','4','109','13','2015-05-07 11:35:45','1'),
('com_content.article','4','109','14','2015-05-07 11:35:45','1'),
('com_content.article','4','109','15','2015-05-07 11:35:45','1'),
('com_content.article','4','109','16','2015-05-07 11:35:45','1'),
('com_content.article','3','113','13','2015-05-07 11:35:22','1'),
('com_content.article','3','113','14','2015-05-07 11:35:22','1'),
('com_content.article','3','113','17','2015-05-07 11:35:22','1'),
('com_content.article','13','116','8','2014-12-15 12:36:40','1'),
('com_content.article','12','117','6','2014-12-15 12:36:27','1'),
('com_content.article','12','117','7','2014-12-15 12:36:27','1'),
('com_content.article','11','118','7','2014-12-15 13:36:01','1'),
('com_content.article','11','118','9','2014-12-15 13:36:01','1'),
('com_content.article','11','118','11','2014-12-15 13:36:01','1'),
('com_content.article','14','122','12','2015-05-07 11:35:08','1'),
('com_content.article','14','122','13','2015-05-07 11:35:08','1'),
('com_content.article','14','122','16','2015-05-07 11:35:08','1');

DROP TABLE IF EXISTS #__core_log_searches;
CREATE TABLE `#__core_log_searches` (
  `search_term` varchar(128) NOT NULL DEFAULT '',
  `hits` int(10) unsigned NOT NULL DEFAULT '0'
) DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS #__djmt_albums;
CREATE TABLE `#__djmt_albums` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0',
  `source` varchar(255) NOT NULL,
  `title` varchar(255) NOT NULL,
  `alias` varchar(255) NOT NULL DEFAULT '',
  `folder` varchar(255) DEFAULT NULL,
  `image` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `visible` tinyint(1) NOT NULL DEFAULT '1',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `params` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `parent_id` (`parent_id`,`published`),
  KEY `visible` (`visible`)
) AUTO_INCREMENT=23 DEFAULT CHARSET=utf8;

INSERT INTO `#__djmt_albums` VALUES 
('3','4','component','Album 3','album-3',NULL,'images/modules/slider/700x575.jpg','','1','0000-00-00 00:00:00','0','1','0','0000-00-00 00:00:00','2','{"plg_content_type":"featured","plg_content_id":"0","plg_content_maxlevel":"0","plg_content_order":"a.ordering","plg_content_order_dir":"ASC","plg_content_image":"","plg_catalog2_featured_only":"0","plg_catalog2_featured_first":"0","plg_catalog2_orderby":"i.ordering","plg_catalog2_orderdir":"0","plg_folder_path":"","plg_folder_link":"","layout":"","slider_type":"","desc_effect":"","sort_by":"","link_image":"","lightbox":"","image_width":"","image_height":"","resizing":"","quality":"","thumb_width":"","thumb_height":"","visible_images":"","space_between_images":"","max_images":"","show_thumbs":"","tab_indicator":"","tab_width":"","tab_height":"","tab_position":"","show_title":"","show_desc":"","show_readmore":"","readmore_text":"","link_title":"","link_desc":"","limit_desc":"","autoplay":"","pause_autoplay":"","show_buttons":"","show_arrows":"","show_custom_nav":"","effect":"","effect_type":"","duration":"","delay":"","lag":"","preload":"","desc_position":"","desc_width":"","desc_bottom":"","desc_horizontal":"","left_arrow":"","right_arrow":"","play_button":"","pause_button":"","arrows_top":"","arrows_horizontal":"","custom_nav_pos":"","custom_nav_align":"","loader_position":""}'),
('8','0','component','Album Group','album-group',NULL,'','','1','0000-00-00 00:00:00','0','1','0','0000-00-00 00:00:00','4','{"plg_content_type":"featured","plg_content_id":"0","plg_content_maxlevel":"0","plg_content_order":"a.ordering","plg_content_order_dir":"ASC","plg_content_image":"","plg_classifieds_catid":"0","plg_classifieds_items_ord":"0","plg_classifieds_items_ids":"","plg_classifieds_image":"","plg_folder_path":"","plg_folder_link":"","layout":"","slider_type":"","desc_effect":"","sort_by":"","link_image":"","lightbox":"","image_width":"","image_height":"","resizing":"","quality":"","thumb_width":"","thumb_height":"","visible_images":"","space_between_images":"","max_images":"","show_thumbs":"","tab_indicator":"","tab_width":"","tab_height":"","tab_position":"","show_title":"","show_desc":"","show_readmore":"","readmore_text":"","link_title":"","link_desc":"","limit_desc":"","autoplay":"","pause_autoplay":"","show_buttons":"","show_arrows":"","show_custom_nav":"","effect":"","effect_type":"","duration":"","delay":"","lag":"","preload":"","desc_position":"","desc_width":"","desc_bottom":"","desc_horizontal":"","left_arrow":"","right_arrow":"","play_button":"","pause_button":"","arrows_top":"","arrows_horizontal":"","custom_nav_pos":"","custom_nav_align":"","loader_position":""}'),
('14','8','component','Video','album-3','images/djmediatools/14-album-3','images/modules/album/2.jpg','','1','0000-00-00 00:00:00','0','1','0','0000-00-00 00:00:00','2','{"layout":"_:mslider","slider_type":"","desc_effect":"","sort_by":"","link_image":"","lightbox":"","image_width":"600","image_height":"550","resizing":"","quality":"","thumb_width":"","thumb_height":"","visible_images":"2","space_between_images":"","max_images":"","show_thumbs":"","tab_indicator":"","tab_width":"","tab_height":"","tab_position":"","show_title":"","show_desc":"","show_readmore":"0","readmore_text":"","link_title":"","link_desc":"","limit_desc":"","autoplay":"","pause_autoplay":"","show_buttons":"","show_arrows":"","show_custom_nav":"","effect":"","effect_type":"","duration":"","delay":"","lag":"","preload":"","desc_position":"","desc_width":"","desc_bottom":"","desc_horizontal":"","left_arrow":"","right_arrow":"","play_button":"","pause_button":"","arrows_top":"","arrows_horizontal":"","custom_nav_pos":"","custom_nav_align":"","loader_position":""}'),
('17','0','content','Header Articles','blog-front','images/djmediatools/17-blog-front','images/djmediatools/slide2.jpg','','1','0000-00-00 00:00:00','0','1','0','0000-00-00 00:00:00','3','{"source_params":{"mode":"normal","show_on_article_page":"1","show_front":"show","category_filtering_type":"1","catid":["86"],"show_child_category_articles":"0","levels":"1","author_filtering_type":"1","created_by":[""],"author_alias_filtering_type":"1","created_by_alias":[""],"excluded_articles":"","date_filtering":"off","date_field":"a.created","start_date_range":"","end_date_range":"","relative_date":"30","article_ordering":"a.ordering","article_ordering_direction":"ASC","show_date":"0","show_date_field":"created","show_date_format":"Y-m-d H:i:s","show_category":"0","show_hits":"0","show_author":"0","default_image":""},"layout":"","slider_type":"","desc_effect":"","sort_by":"","link_image":"","lightbox":"","image_width":"","image_height":"","resizing":"","quality":"","thumb_width":"","thumb_height":"","visible_images":"","space_between_images":"","max_images":"","show_thumbs":"","tab_indicator":"","tab_width":"","tab_height":"","tab_position":"","show_title":"","show_desc":"","show_readmore":"","readmore_text":"","link_title":"","link_desc":"","limit_desc":"","autoplay":"","pause_autoplay":"","show_buttons":"","show_arrows":"","show_custom_nav":"","effect":"","effect_type":"","duration":"","delay":"","lag":"","preload":"","desc_position":"","desc_width":"","desc_bottom":"","desc_horizontal":"","left_arrow":"","right_arrow":"","play_button":"","pause_button":"","arrows_top":"","arrows_horizontal":"","custom_nav_pos":"","custom_nav_align":"","loader_position":""}'),
('18','8','component','Sample Album','sample-album','images/djmediatools/18-sample-album','images/modules/album/0.jpg','','1','0000-00-00 00:00:00','0','1','0','0000-00-00 00:00:00','1','{"layout":"","slider_type":"","desc_effect":"","sort_by":"","link_image":"","lightbox":"","image_width":"","image_height":"","resizing":"","quality":"","thumb_width":"","thumb_height":"","visible_images":"","space_between_images":"","max_images":"","show_thumbs":"","tab_indicator":"","tab_width":"","tab_height":"","tab_position":"","show_title":"","show_desc":"","show_readmore":"","readmore_text":"","link_title":"","link_desc":"","limit_desc":"","autoplay":"","pause_autoplay":"","show_buttons":"","show_arrows":"","show_custom_nav":"","effect":"","effect_type":"","duration":"","delay":"","lag":"","preload":"","desc_position":"","desc_width":"","desc_bottom":"","desc_horizontal":"","left_arrow":"","right_arrow":"","play_button":"","pause_button":"","arrows_top":"","arrows_horizontal":"","custom_nav_pos":"","custom_nav_align":"","loader_position":""}'),
('19','8','content','Joomla Blog','joomla-blog','images/djmediatools/19-joomla-blog','images/modules/album/4.jpg','','1','0000-00-00 00:00:00','0','1','0','0000-00-00 00:00:00','3','{"source_params":{"mode":"normal","show_on_article_page":"1","show_front":"show","category_filtering_type":"1","catid":["86"],"show_child_category_articles":"0","levels":"1","author_filtering_type":"1","created_by":[""],"author_alias_filtering_type":"1","created_by_alias":[""],"excluded_articles":"","date_filtering":"off","date_field":"a.created","start_date_range":"","end_date_range":"","relative_date":"30","article_ordering":"a.ordering","article_ordering_direction":"ASC","show_date":"0","show_date_field":"created","show_date_format":"Y-m-d H:i:s","show_category":"0","show_hits":"0","show_author":"0","default_image":""},"layout":"_:slideshow","slider_type":"ifade","desc_effect":"up","sort_by":"","link_image":"","lightbox":"","image_width":"800","image_height":"450","resizing":"","quality":"","thumb_width":"","thumb_height":"","visible_images":"1","space_between_images":"0","max_images":"","show_thumbs":"","tab_indicator":"","tab_width":"","tab_height":"","tab_position":"","show_title":"","show_desc":"","show_readmore":"","readmore_text":"","link_title":"","link_desc":"","limit_desc":"20","autoplay":"","pause_autoplay":"","show_buttons":"","show_arrows":"","show_custom_nav":"","effect":"","effect_type":"","duration":"","delay":"","lag":"","preload":"","desc_position":"","desc_width":"280","desc_bottom":"","desc_horizontal":"","left_arrow":"","right_arrow":"","play_button":"","pause_button":"","arrows_top":"","arrows_horizontal":"","custom_nav_pos":"","custom_nav_align":"","loader_position":""}'),
('22','0','component','We work for','we-work-for','images/djmediatools/22-we-work-for','images/djmediatools/22-we-work-for/logo01.png','','1','0000-00-00 00:00:00','0','1','0','0000-00-00 00:00:00','1','{"plg_content_type":"featured","plg_content_id":"0","plg_content_maxlevel":"0","plg_content_order":"a.ordering","plg_content_order_dir":"ASC","plg_content_image":"","plg_folder_path":"images","plg_folder_link":"","layout":"","slider_type":"","desc_effect":"","sort_by":"","link_image":"","lightbox":"","image_width":"","image_height":"","resizing":"","quality":"","thumb_width":"","thumb_height":"","visible_images":"","space_between_images":"","max_images":"","show_thumbs":"","tab_indicator":"","tab_width":"","tab_height":"","tab_position":"","show_title":"","show_desc":"","show_readmore":"","readmore_text":"","link_title":"","link_desc":"","limit_desc":"","autoplay":"","pause_autoplay":"","show_buttons":"","show_arrows":"","show_custom_nav":"","effect":"","effect_type":"","duration":"","delay":"","lag":"","preload":"","desc_position":"","desc_width":"","desc_bottom":"","desc_horizontal":"","left_arrow":"","right_arrow":"","play_button":"","pause_button":"","arrows_top":"","arrows_horizontal":"","custom_nav_pos":"","custom_nav_align":"","loader_position":""}');

DROP TABLE IF EXISTS #__djmt_items;
CREATE TABLE `#__djmt_items` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `catid` int(10) unsigned NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL,
  `alias` varchar(255) NOT NULL DEFAULT '',
  `image` varchar(255) NOT NULL,
  `video` varchar(255) DEFAULT NULL,
  `description` text NOT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `params` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `catid` (`catid`,`published`)
) AUTO_INCREMENT=56 DEFAULT CHARSET=utf8;

INSERT INTO `#__djmt_items` VALUES 
('16','14','Vestibulum dictum','vestibulum-dictum','images/modules/album/4.jpg','http://www.youtube.com/embed/qGMXIkE3d70','','1','0000-00-00 00:00:00','0','2013-11-15 07:20:54','0000-00-00 00:00:00','0','0000-00-00 00:00:00','9','{"link_type":"","link_menu":"470","link_url":"","link_article":""}'),
('17','14','Praesent nec','praesent-nec','images/modules/album/1.jpg','http://www.youtube.com/embed/A6UJcBf8cqM','','1','0000-00-00 00:00:00','0','2013-11-15 07:21:42','0000-00-00 00:00:00','0','0000-00-00 00:00:00','6','{"link_type":"","link_menu":"470","link_url":"","link_article":""}'),
('18','14','Curabitur vulputate','curabitur-vulputate','images/modules/album/0.jpg','http://www.youtube.com/embed/bu9g1Jxw_c8','','1','0000-00-00 00:00:00','0','2013-11-15 07:22:19','0000-00-00 00:00:00','0','0000-00-00 00:00:00','5','{"link_type":"","link_menu":"470","link_url":"","link_article":""}'),
('19','14','Etiam cursus','etiam-cursus','images/modules/album/3.jpg','http://www.youtube.com/embed/FokhELMcKg4','','1','0000-00-00 00:00:00','0','2013-11-15 07:23:01','0000-00-00 00:00:00','0','0000-00-00 00:00:00','2','{"link_type":"","link_menu":"470","link_url":"","link_article":""}'),
('20','14','Lorem ipsum','lorem-ipsum','images/modules/album/5.jpg','http://www.youtube.com/embed/qGMXIkE3d70','','1','0000-00-00 00:00:00','0','2013-11-15 07:23:38','0000-00-00 00:00:00','0','0000-00-00 00:00:00','1','{"link_type":"","link_menu":"470","link_url":"","link_article":""}'),
('26','18',' Curabitur pharetra','curabitur-pharetra','images/modules/album/0.jpg','','<p>Praesent nec tortor in orci ultricies dictum. Fusce nec facilisis.</p>','1','0000-00-00 00:00:00','0','2014-05-26 12:06:10','0000-00-00 00:00:00','0','0000-00-00 00:00:00','12','{"link_type":"article;link_article","link_menu":"601","link_url":"","link_article":"109"}'),
('27','18','Ut volutpat','ut-volutpat','images/modules/album/3.jpg','','<p>Donec dictum dapibus auctor. Sed lobortis lacus in dignissim.</p>','1','0000-00-00 00:00:00','0','2014-05-26 12:06:10','0000-00-00 00:00:00','0','0000-00-00 00:00:00','11','{"link_type":"article;link_article","link_menu":"601","link_url":"","link_article":"109"}'),
('28','18','Donec ornare','donec-ornare','images/modules/album/1.jpg','','<p>Vivamus molestie tellus ut enim tincidunt rutrum.</p>','1','0000-00-00 00:00:00','0','2014-05-26 12:06:10','0000-00-00 00:00:00','0','0000-00-00 00:00:00','10','{"link_type":"article;link_article","link_menu":"601","link_url":"","link_article":"103"}'),
('29','18','Nullam maximus','nullam-maximus','images/modules/album/2.jpg','','<p>Etiam cursus lectus mi, at pretium elit sagittis vel.</p>','1','0000-00-00 00:00:00','0','2014-05-26 12:06:10','0000-00-00 00:00:00','0','0000-00-00 00:00:00','7','{"link_type":"article;link_article","link_menu":"601","link_url":"","link_article":"104"}'),
('30','18','Aliquam congue','aliquam-congue','images/modules/album/4.jpg','','<p>Aenean vel mauris id arcu venenatis eleifend.</p>','1','0000-00-00 00:00:00','0','2014-05-26 12:06:10','0000-00-00 00:00:00','0','0000-00-00 00:00:00','14','{"link_type":"article;link_article","link_menu":"601","link_url":"","link_article":"109"}'),
('31','18','Lorem ipsum','lorem-ipsum','images/modules/album/5.jpg','','<p>Nulla imperdiet ac nisl at auctor.</p>','1','0000-00-00 00:00:00','0','2014-05-26 12:21:05','0000-00-00 00:00:00','0','0000-00-00 00:00:00','3','{"link_type":"article;link_article","link_menu":"601","link_url":"","link_article":"103"}'),
('44','22','logo01','logo01','images/djmediatools/22-we-work-for/logo01.png','','','1','0000-00-00 00:00:00','0','2015-05-04 14:56:18','0000-00-00 00:00:00','0','0000-00-00 00:00:00','4','{"link_type":"menu;link_menu","link_menu":"470","link_url":"","link_article":""}'),
('45','22','logo02','logo02','images/djmediatools/22-we-work-for/logo02.png','','','1','0000-00-00 00:00:00','0','2015-05-04 14:56:18','0000-00-00 00:00:00','0','0000-00-00 00:00:00','8','{"link_type":"menu;link_menu","link_menu":"470","link_url":"","link_article":""}'),
('46','22','logo03','logo03','images/djmediatools/22-we-work-for/logo03.png','','','1','0000-00-00 00:00:00','0','2015-05-04 14:56:18','0000-00-00 00:00:00','0','0000-00-00 00:00:00','13','{"link_type":"menu;link_menu","link_menu":"470","link_url":"","link_article":""}'),
('47','22','logo04','logo04','images/djmediatools/22-we-work-for/logo04.png','','','1','0000-00-00 00:00:00','0','2015-05-04 14:56:18','0000-00-00 00:00:00','0','0000-00-00 00:00:00','15','{"link_type":"menu;link_menu","link_menu":"470","link_url":"","link_article":""}'),
('48','22','logo05','logo05','images/djmediatools/22-we-work-for/logo05.png','','','1','0000-00-00 00:00:00','0','2015-05-04 14:56:18','0000-00-00 00:00:00','0','0000-00-00 00:00:00','16','{"link_type":"menu;link_menu","link_menu":"470","link_url":"","link_article":""}'),
('49','22','logo06','logo06','images/djmediatools/22-we-work-for/logo06.png','','','1','0000-00-00 00:00:00','0','2015-05-04 14:56:18','0000-00-00 00:00:00','0','0000-00-00 00:00:00','17','{"link_type":"menu;link_menu","link_menu":"470","link_url":"","link_article":""}'),
('50','22','logo07','logo07','images/djmediatools/22-we-work-for/logo07.png','','','1','0000-00-00 00:00:00','0','2015-05-04 14:56:18','0000-00-00 00:00:00','0','0000-00-00 00:00:00','18','{"link_type":"menu;link_menu","link_menu":"470","link_url":"","link_article":""}'),
('51','22','logo08','logo08','images/djmediatools/22-we-work-for/logo08.png','','','1','0000-00-00 00:00:00','0','2015-05-04 14:56:18','0000-00-00 00:00:00','0','0000-00-00 00:00:00','19','{"link_type":"menu;link_menu","link_menu":"470","link_url":"","link_article":""}'),
('52','22','logo09','logo09','images/djmediatools/22-we-work-for/logo09.png','','','1','0000-00-00 00:00:00','0','2015-05-04 14:56:18','0000-00-00 00:00:00','0','0000-00-00 00:00:00','20','{"link_type":"menu;link_menu","link_menu":"470","link_url":"","link_article":""}'),
('53','22','logo10','logo10','images/djmediatools/22-we-work-for/logo10.png','','','1','0000-00-00 00:00:00','0','2015-05-04 14:56:18','0000-00-00 00:00:00','0','0000-00-00 00:00:00','21','{"link_type":"menu;link_menu","link_menu":"470","link_url":"","link_article":""}'),
('54','22','logo11','logo11','images/djmediatools/22-we-work-for/logo11.png','','','1','0000-00-00 00:00:00','0','2015-05-04 14:56:18','0000-00-00 00:00:00','0','0000-00-00 00:00:00','22','{"link_type":"menu;link_menu","link_menu":"470","link_url":"","link_article":""}'),
('55','22','logo12','logo12','images/djmediatools/22-we-work-for/logo12.png','','','1','0000-00-00 00:00:00','0','2015-05-04 14:56:18','0000-00-00 00:00:00','0','0000-00-00 00:00:00','23','{"link_type":"menu;link_menu","link_menu":"470","link_url":"","link_article":""}');

DROP TABLE IF EXISTS #__djmt_resmushit;
CREATE TABLE `#__djmt_resmushit` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `md5` varchar(50) NOT NULL,
  `path` varchar(255) NOT NULL,
  `original_size` int(8) unsigned NOT NULL DEFAULT '0',
  `size` int(8) unsigned NOT NULL DEFAULT '0',
  `percent` double(4,2) NOT NULL DEFAULT '0.00',
  `date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `md5` (`md5`)
) AUTO_INCREMENT=99 DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS #__djtabs_groups;
CREATE TABLE `#__djtabs_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL,
  `alias` varchar(255) NOT NULL,
  `image` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `params` text NOT NULL,
  PRIMARY KEY (`id`)
) AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;

INSERT INTO `#__djtabs_groups` VALUES 
('4','0','Tabs','tabs','','','1','0','0000-00-00 00:00:00','4',''),
('5','0','Video','video','','','1','0','0000-00-00 00:00:00','5',''),
('6','0','Subpage','subpage','','','1','0','0000-00-00 00:00:00','6',''),
('7','0','Accordion','accordion','','','1','0','0000-00-00 00:00:00','7','');

DROP TABLE IF EXISTS #__djtabs_items;
CREATE TABLE `#__djtabs_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `type` tinyint(4) NOT NULL,
  `group_id` int(11) NOT NULL,
  `ordering` int(11) NOT NULL,
  `params` text,
  `published` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) AUTO_INCREMENT=22 DEFAULT CHARSET=utf8;

INSERT INTO `#__djtabs_items` VALUES 
('7','Spring cleaning','2','4','1','{"module_position":"tab-dentures","video_link":"","article_id":"114","category_id":["82"],"tab_icon":"","tab_custom_html":"<p><img src=\\"images\\/modules\\/icons\\/ico1.png\\" alt=\\"\\" \\/><\\/p>","articles_display":"1","articles_per_row":"1","articles_space":"0","article_limit":"","max_category_levels":"1","articles_min_date":"","articles_max_date":"","articles_ordering":"","articles_ordering_direction":"1","date":"","date_position":"","title":"1","title_link":"1","title_char_limit":"","image":"","image_position":"","image_link":"","image_width":"","image_height":"","description":"","description_link":"","HTML_in_description":"","description_char_limit":"","readmore_button":"1","readmore_text":"Read more","category":"","category_link":"","author":""}','1'),
('8','Window cleaning','2','4','2','{"module_position":"","video_link":"","article_id":"99","category_id":["82"],"tab_icon":"","tab_custom_html":"<p><img src=\\"images\\/modules\\/icons\\/ico2.png\\" alt=\\"\\" \\/><\\/p>","articles_display":"1","articles_per_row":"1","articles_space":"0","article_limit":"","max_category_levels":"1","articles_min_date":"","articles_max_date":"","articles_ordering":"","articles_ordering_direction":"1","date":"","date_position":"","title":"1","title_link":"1","title_char_limit":"","image":"1","image_position":"2","image_link":"","image_width":"","image_height":"","description":"","description_link":"","HTML_in_description":"","description_char_limit":"","readmore_button":"1","readmore_text":"Read more","category":"","category_link":"","author":""}','1'),
('9','Carpet cleaning','2','4','3','{"module_position":"tab-crowns","video_link":"","article_id":"98","category_id":["82"],"tab_icon":"","tab_custom_html":"<p><img src=\\"images\\/modules\\/icons\\/ico3.png\\" alt=\\"\\" \\/><\\/p>","articles_display":"1","articles_per_row":"1","articles_space":"0","article_limit":"","max_category_levels":"1","articles_min_date":"","articles_max_date":"","articles_ordering":"","articles_ordering_direction":"1","date":"","date_position":"","title":"1","title_link":"1","title_char_limit":"","image":"","image_position":"","image_link":"","image_width":"","image_height":"","description":"","description_link":"","HTML_in_description":"","description_char_limit":"","readmore_button":"1","readmore_text":"Read more","category":"","category_link":"","author":""}','1'),
('10','Steam cleaning','2','4','4','{"module_position":"tab-white","video_link":"","article_id":"97","category_id":["82"],"tab_icon":"","tab_custom_html":"<p><img src=\\"images\\/modules\\/icons\\/ico4.png\\" alt=\\"\\" \\/><\\/p>","articles_display":"1","articles_per_row":"1","articles_space":"0","article_limit":"","max_category_levels":"1","articles_min_date":"","articles_max_date":"","articles_ordering":"","articles_ordering_direction":"1","date":"","date_position":"","title":"1","title_link":"1","title_char_limit":"","image":"","image_position":"","image_link":"","image_width":"","image_height":"","description":"","description_link":"","HTML_in_description":"","description_char_limit":"","readmore_button":"1","readmore_text":"Read more","category":"","category_link":"","author":""}','1'),
('11','Consectetur adipiscing elit','4','5','1','{"module_position":"","video_link":"https:\\/\\/www.youtube.com\\/watch?v=A6UJcBf8cqM","article_id":"","category_id":"82","tab_icon":"","tab_custom_html":"","articles_display":"1","articles_per_row":"1","articles_space":"0","article_limit":"","articles_ordering":"","articles_ordering_direction":"1","articles_min_date":"","articles_max_date":"","date":"","date_position":"","title":"","title_link":"","title_char_limit":"","image":"","image_position":"","image_link":"","image_width":"","image_height":"","description":"","description_link":"","HTML_in_description":"","description_char_limit":"","readmore_button":"","readmore_text":"","category":"","category_link":"","author":""}','1'),
('12','Sed quis nisi eget lacus varius suscipit','4','5','2','{"module_position":"","video_link":"https:\\/\\/www.youtube.com\\/watch?v=BhDoEJVHx_4","article_id":"","category_id":"82","tab_icon":"","tab_custom_html":"","articles_display":"1","articles_per_row":"1","articles_space":"0","article_limit":"","articles_ordering":"","articles_ordering_direction":"1","articles_min_date":"","articles_max_date":"","date":"","date_position":"","title":"","title_link":"","title_char_limit":"","image":"","image_position":"","image_link":"","image_width":"","image_height":"","description":"","description_link":"","HTML_in_description":"","description_char_limit":"","readmore_button":"","readmore_text":"","category":"","category_link":"","author":""}','1'),
('13','Praesent tincidunt leo sit amet ','4','5','3','{"module_position":"","video_link":"https:\\/\\/www.youtube.com\\/watch?v=1LOrO54gFLo","article_id":"","category_id":"82","tab_icon":"","tab_custom_html":"","articles_display":"1","articles_per_row":"1","articles_space":"0","article_limit":"","articles_ordering":"","articles_ordering_direction":"1","articles_min_date":"","articles_max_date":"","date":"","date_position":"","title":"","title_link":"","title_char_limit":"","image":"","image_position":"","image_link":"","image_width":"","image_height":"","description":"","description_link":"","HTML_in_description":"","description_char_limit":"","readmore_button":"","readmore_text":"","category":"","category_link":"","author":""}','1'),
('14','Single Article','2','6','1','{"module_position":"","video_link":"","article_id":"96","category_id":["82"],"tab_icon":"","tab_custom_html":"<p><img src=\\"images\\/modules\\/icons\\/ico1.png\\" alt=\\"\\" \\/><\\/p>","articles_display":"1","articles_per_row":"1","articles_space":"0","article_limit":"","max_category_levels":"1","articles_min_date":"","articles_max_date":"","articles_ordering":"","articles_ordering_direction":"1","date":"1","date_position":"1","title":"1","title_link":"1","title_char_limit":"","image":"","image_position":"","image_link":"","image_width":"","image_height":"","description":"","description_link":"","HTML_in_description":"","description_char_limit":"","readmore_button":"1","readmore_text":"","category":"1","category_link":"1","author":"1"}','1'),
('15','Article Category','1','6','2','{"module_position":"","video_link":"","article_id":"","category_id":["83"],"tab_icon":"","tab_custom_html":"<p><img src=\\"images\\/modules\\/icons\\/ico2.png\\" alt=\\"\\" \\/><\\/p>","articles_display":"1","articles_per_row":"1","articles_space":"0","article_limit":"5","max_category_levels":"1","articles_min_date":"","articles_max_date":"","articles_ordering":"","articles_ordering_direction":"1","date":"","date_position":"","title":"1","title_link":"0","title_char_limit":"","image":"","image_position":"","image_link":"","image_width":"287","image_height":"","description":"","description_link":"","HTML_in_description":"","description_char_limit":"","readmore_button":"","readmore_text":"","category":"","category_link":"","author":""}','1'),
('16','Module Position','3','6','3','{"module_position":"djtab-module","video_link":"","article_id":"","category_id":["82"],"tab_icon":"","tab_custom_html":"<p><img src=\\"images\\/modules\\/icons\\/ico3.png\\" alt=\\"\\" \\/><\\/p>","articles_display":"1","articles_per_row":"1","articles_space":"0","article_limit":"","max_category_levels":"1","articles_min_date":"","articles_max_date":"","articles_ordering":"","articles_ordering_direction":"1","date":"","date_position":"","title":"","title_link":"","title_char_limit":"","image":"","image_position":"","image_link":"","image_width":"","image_height":"","description":"","description_link":"","HTML_in_description":"","description_char_limit":"","readmore_button":"","readmore_text":"","category":"","category_link":"","author":""}','1'),
('17','Video','4','6','4','{"module_position":"","video_link":"https:\\/\\/www.youtube.com\\/watch?v=A6UJcBf8cqM","article_id":"","category_id":["82"],"tab_icon":"","tab_custom_html":"<p><img src=\\"images\\/modules\\/icons\\/ico4.png\\" alt=\\"\\" \\/><\\/p>","articles_display":"1","articles_per_row":"1","articles_space":"0","article_limit":"","max_category_levels":"1","articles_min_date":"","articles_max_date":"","articles_ordering":"","articles_ordering_direction":"1","date":"","date_position":"","title":"","title_link":"","title_char_limit":"","image":"","image_position":"","image_link":"","image_width":"","image_height":"","description":"","description_link":"","HTML_in_description":"","description_char_limit":"","readmore_button":"","readmore_text":"","category":"","category_link":"","author":""}','1'),
('18','Single article from the category','2','7','1','{"module_position":"","video_link":"","article_id":"115","tab_icon":"","tab_custom_html":"","articles_display":"1","articles_per_row":"1","articles_space":"0","article_limit":"","max_category_levels":"1","articles_min_date":"","articles_max_date":"","articles_ordering":"","articles_ordering_direction":"1","date":"1","date_position":"1","title":"1","title_link":"1","title_char_limit":"","image":"","image_position":"","image_link":"","image_width":"","image_height":"","description":"","description_link":"","HTML_in_description":"","description_char_limit":"","readmore_button":"","readmore_text":"","category":"1","category_link":"1","author":"1"}','1'),
('19','Video tutorial','4','7','2','{"module_position":"","video_link":"https:\\/\\/www.youtube.com\\/watch?v=47E0xfFxWJw","article_id":"116","tab_icon":"","tab_custom_html":"","articles_display":"1","articles_per_row":"1","articles_space":"0","article_limit":"","max_category_levels":"1","articles_min_date":"","articles_max_date":"","articles_ordering":"","articles_ordering_direction":"1","date":"1","date_position":"1","title":"1","title_link":"1","title_char_limit":"","image":"","image_position":"","image_link":"","image_width":"","image_height":"","description":"","description_link":"","HTML_in_description":"","description_char_limit":"","readmore_button":"","readmore_text":"","category":"1","category_link":"1","author":"1"}','1'),
('20','Content from the module position','3','7','3','{"module_position":"djtab-front","video_link":"","article_id":"117","tab_icon":"","tab_custom_html":"","articles_display":"1","articles_per_row":"1","articles_space":"0","article_limit":"","max_category_levels":"1","articles_min_date":"","articles_max_date":"","articles_ordering":"","articles_ordering_direction":"1","date":"1","date_position":"1","title":"1","title_link":"1","title_char_limit":"","image":"","image_position":"","image_link":"","image_width":"","image_height":"","description":"","description_link":"","HTML_in_description":"","description_char_limit":"","readmore_button":"","readmore_text":"","category":"1","category_link":"1","author":"1"}','1'),
('21','Articles from the category','1','7','4','{"module_position":"","video_link":"","article_id":"118","category_id":["84"],"tab_icon":"","tab_custom_html":"","articles_display":"2","articles_per_row":"1","articles_space":"0","article_limit":"","max_category_levels":"1","articles_min_date":"","articles_max_date":"","articles_ordering":"","articles_ordering_direction":"1","date":"1","date_position":"1","title":"1","title_link":"1","title_char_limit":"","image":"","image_position":"","image_link":"","image_width":"287","image_height":"","description":"","description_link":"","HTML_in_description":"","description_char_limit":"","readmore_button":"","readmore_text":"","category":"1","category_link":"1","author":"1"}','1');

DROP TABLE IF EXISTS #__djtabs_themes;
CREATE TABLE `#__djtabs_themes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `custom` tinyint(1) NOT NULL DEFAULT '1',
  `random` tinyint(1) NOT NULL DEFAULT '1',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `params` text NOT NULL,
  PRIMARY KEY (`id`)
) AUTO_INCREMENT=13 DEFAULT CHARSET=utf8;

INSERT INTO `#__djtabs_themes` VALUES 
('1','dj-black','0','1','1','1','{"tb-ctv-bck-clr":"#353535"}'),
('2','dj-orange','0','1','1','2','{"tb-ctv-bck-clr":"#DD4125"}'),
('3','dj-green','0','1','1','3','{"tb-ctv-bck-clr":"#51980E"}'),
('4','dj-blue','0','1','1','4','{"tb-ctv-bck-clr":"#239CCD"}'),
('5','dj-custom-black','1','1','1','5','{"tb-ctv-bck-clr":"#524C4C","tb-ctv-ttl-clr":"#F7F2EB","tb-nctv-bck-clr":"#302C2C","tb-nctv-ttl-clr":"#F7F2EB","pnl-dt-clr":"#524C4C","pnl-ctv-brdrs-stl":"solid","pnl-ctv-brdrs-clr":"#E2E2E2","pnl-ctv-clr":"#FFFFFF","pnl-ctv-ttl-clr":"#302C2C","tgglr-ctv-bck-clr":"#524C4C","pnl-nctv-brdrs-stl":"solid","pnl-nctv-brdrs-clr":"#E2E2E2","pnl-nctv-clr":"#FFFFFF","pnl-nctv-ttl-clr":"#302C2C","tgglr-nctv-bck-clr":"#E2E2E2"}'),
('6','dj-custom-orange','1','1','1','6','{"tb-ctv-bck-clr":"#F54828",\n"tb-ctv-ttl-clr":"#F7F2EB",\n"tb-nctv-bck-clr":"#302C2C",\n"tb-nctv-ttl-clr":"#F7F2EB",\n"pnl-dt-clr":"#F54828",\n"pnl-ctv-brdrs-stl":"solid",\n"pnl-ctv-brdrs-clr":"#E2E2E2",\n"pnl-ctv-clr":"#FFFFFF",\n"pnl-ctv-ttl-clr":"#302C2C",\n"tgglr-ctv-bck-clr":"#F54828",\n"pnl-nctv-brdrs-stl":"solid",\n"pnl-nctv-brdrs-clr":"#E2E2E2",\n"pnl-nctv-clr":"#FFFFFF",\n"pnl-nctv-ttl-clr":"#302C2C",\n"tgglr-nctv-bck-clr":"#E2E2E2"}'),
('7','dj-custom-green','1','1','1','7','{"tb-ctv-bck-clr":"#59A80F",\n"tb-ctv-ttl-clr":"#F7F2EB",\n"tb-nctv-bck-clr":"#302C2C",\n"tb-nctv-ttl-clr":"#F7F2EB",\n"pnl-dt-clr":"#59A80F",\n"pnl-ctv-brdrs-stl":"solid",\n"pnl-ctv-brdrs-clr":"#E2E2E2",\n"pnl-ctv-clr":"#FFFFFF",\n"pnl-ctv-ttl-clr":"#302C2C",\n"tgglr-ctv-bck-clr":"#59A80F",\n"pnl-nctv-brdrs-stl":"solid",\n"pnl-nctv-brdrs-clr":"#E2E2E2",\n"pnl-nctv-clr":"#FFFFFF",\n"pnl-nctv-ttl-clr":"#302C2C",\n"tgglr-nctv-bck-clr":"#E2E2E2"}'),
('8','dj-custom-blue','1','1','1','8','{"tb-ctv-bck-clr":"#26ADE4",\n"tb-ctv-ttl-clr":"#F7F2EB",\n"tb-nctv-bck-clr":"#302C2C",\n"tb-nctv-ttl-clr":"#F7F2EB",\n"pnl-dt-clr":"#26ADE4",\n"pnl-ctv-brdrs-stl":"solid",\n"pnl-ctv-brdrs-clr":"#E2E2E2",\n"pnl-ctv-clr":"#FFFFFF",\n"pnl-ctv-ttl-clr":"#302C2C",\n"tgglr-ctv-bck-clr":"#26ADE4",\n"pnl-nctv-brdrs-stl":"solid",\n"pnl-nctv-brdrs-clr":"#E2E2E2",\n"pnl-nctv-clr":"#FFFFFF",\n"pnl-nctv-ttl-clr":"#302C2C",\n"tgglr-nctv-bck-clr":"#E2E2E2"}'),
('9','dj-custom2-black','1','1','1','9','{"tb-nctv-bck-clr":"#302C2C","tb-ctv-bck-clr":"#524C4C","tb-nctv-ttl-clr":"#F7F2EB","tb-ctv-ttl-clr":"#F7F2EB","pnl-nctv-clr":"#FFFFFF","pnl-ctv-clr":"#302C2C","pnl-nctv-ttl-clr":"#302C2C","pnl-ctv-ttl-clr":"#F5F5F5","pnl-dt-clr":"#524C4C","pnl-nctv-brdrs-stl":"solid","pnl-ctv-brdrs-stl":"solid","pnl-nctv-brdrs-clr":"#E2E2E2","pnl-ctv-brdrs-clr":"#302C2C","tgglr-nctv-bck-clr":"#E2E2E2","tgglr-ctv-bck-clr":"#524C4C","tb-brdr-rds":"5","pnl-brdr-rds":"25","tgglr-brdr-rds":"25","mg-brdr-rds":"5"}'),
('10','dj-custom2-orange','1','1','1','10','{"tb-nctv-bck-clr":"#302C2C","tb-ctv-bck-clr":"#F54828","tb-nctv-ttl-clr":"#F7F2EB","tb-ctv-ttl-clr":"#F7F2EB","pnl-nctv-clr":"#FFFFFF","pnl-ctv-clr":"#302C2C","pnl-nctv-ttl-clr":"#302C2C","pnl-ctv-ttl-clr":"#F5F5F5","pnl-dt-clr":"#F54828","pnl-nctv-brdrs-stl":"solid","pnl-ctv-brdrs-stl":"solid","pnl-nctv-brdrs-clr":"#E2E2E2","pnl-ctv-brdrs-clr":"#302C2C","tgglr-nctv-bck-clr":"#E2E2E2","tgglr-ctv-bck-clr":"#F54828","tb-brdr-rds":"20","pnl-brdr-rds":"20","tgglr-brdr-rds":"20","mg-brdr-rds":"20"}'),
('11','dj-custom2-green','1','1','1','11','{"tb-nctv-bck-clr":"#302C2C","tb-ctv-bck-clr":"#59A80F","tb-nctv-ttl-clr":"#F7F2EB","tb-ctv-ttl-clr":"#F7F2EB","pnl-nctv-clr":"#FFFFFF","pnl-ctv-clr":"#302C2C","pnl-nctv-ttl-clr":"#302C2C","pnl-ctv-ttl-clr":"#F5F5F5","pnl-dt-clr":"#59A80F","pnl-nctv-brdrs-stl":"solid","pnl-ctv-brdrs-stl":"solid","pnl-nctv-brdrs-clr":"#E2E2E2","pnl-ctv-brdrs-clr":"#302C2C","tgglr-nctv-bck-clr":"#E2E2E2","tgglr-ctv-bck-clr":"#59A80F","tb-brdr-rds":"5","pnl-brdr-rds":"5","tgglr-brdr-rds":"5","mg-brdr-rds":"5"}'),
('12','dj-custom2-blue','1','1','1','12','{"tb-nctv-bck-clr":"#302C2C","tb-ctv-bck-clr":"#26ADE4","tb-nctv-ttl-clr":"#F7F2EB","tb-ctv-ttl-clr":"#F7F2EB","pnl-nctv-clr":"#FFFFFF","pnl-ctv-clr":"#302C2C","pnl-nctv-ttl-clr":"#302C2C","pnl-ctv-ttl-clr":"#F5F5F5","pnl-dt-clr":"#26ADE4","pnl-nctv-brdrs-stl":"solid","pnl-ctv-brdrs-stl":"solid","pnl-nctv-brdrs-clr":"#E2E2E2","pnl-ctv-brdrs-clr":"#302C2C","tgglr-nctv-bck-clr":"#E2E2E2","tgglr-ctv-bck-clr":"#26ADE4","tb-brdr-rds":"10","pnl-brdr-rds":"10","tgglr-brdr-rds":"10","mg-brdr-rds":"10"}');

DROP TABLE IF EXISTS #__extensions;
CREATE TABLE `#__extensions` (
  `extension_id` int(11) NOT NULL AUTO_INCREMENT,
  `package_id` int(11) NOT NULL DEFAULT '0' COMMENT 'Parent package ID for extensions installed as a package.',
  `name` varchar(100) NOT NULL,
  `type` varchar(20) NOT NULL,
  `element` varchar(100) NOT NULL,
  `folder` varchar(100) NOT NULL,
  `client_id` tinyint(3) NOT NULL,
  `enabled` tinyint(3) NOT NULL DEFAULT '0',
  `access` int(10) unsigned NOT NULL DEFAULT '1',
  `protected` tinyint(3) NOT NULL DEFAULT '0',
  `manifest_cache` mediumtext NOT NULL,
  `params` mediumtext NOT NULL,
  `custom_data` mediumtext NOT NULL,
  `system_data` mediumtext NOT NULL,
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) DEFAULT '0',
  `state` int(11) DEFAULT '0',
  PRIMARY KEY (`extension_id`),
  KEY `element_clientid` (`element`,`client_id`),
  KEY `element_folder_clientid` (`element`,`folder`,`client_id`),
  KEY `extension` (`type`,`element`,`folder`,`client_id`)
) AUTO_INCREMENT=10031 DEFAULT CHARSET=utf8;

INSERT INTO `#__extensions` VALUES 
('1','0','com_mailto','component','com_mailto','','0','1','1','1','{"name":"com_mailto","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_MAILTO_XML_DESCRIPTION","group":"","filename":"mailto"}','','','','0','0000-00-00 00:00:00','0','0'),
('2','0','com_wrapper','component','com_wrapper','','0','1','1','1','{"name":"com_wrapper","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.\\n\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_WRAPPER_XML_DESCRIPTION","group":"","filename":"wrapper"}','','','','0','0000-00-00 00:00:00','0','0'),
('3','0','com_admin','component','com_admin','','1','1','1','1','{"name":"com_admin","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_ADMIN_XML_DESCRIPTION","group":""}','','','','0','0000-00-00 00:00:00','0','0'),
('4','0','com_banners','component','com_banners','','1','1','1','0','{"name":"com_banners","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_BANNERS_XML_DESCRIPTION","group":"","filename":"banners"}','{"purchase_type":"3","track_impressions":"0","track_clicks":"0","metakey_prefix":""}','','','0','0000-00-00 00:00:00','0','0'),
('5','0','com_cache','component','com_cache','','1','1','1','1','{"name":"com_cache","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_CACHE_XML_DESCRIPTION","group":""}','','','','0','0000-00-00 00:00:00','0','0'),
('6','0','com_categories','component','com_categories','','1','1','1','1','{"name":"com_categories","type":"component","creationDate":"December 2007","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_CATEGORIES_XML_DESCRIPTION","group":""}','','','','0','0000-00-00 00:00:00','0','0'),
('7','0','com_checkin','component','com_checkin','','1','1','1','1','{"name":"com_checkin","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_CHECKIN_XML_DESCRIPTION","group":""}','','','','0','0000-00-00 00:00:00','0','0'),
('8','0','com_contact','component','com_contact','','1','1','1','0','{"name":"com_contact","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_CONTACT_XML_DESCRIPTION","group":"","filename":"contact"}','{"contact_layout":"_:default","show_contact_category":"hide","show_contact_list":"1","presentation_style":"tabs","show_name":"1","show_position":"1","show_email":"1","show_street_address":"1","show_suburb":"1","show_state":"1","show_postcode":"1","show_country":"1","show_telephone":"1","show_mobile":"1","show_fax":"1","show_webpage":"1","show_misc":"1","show_image":"1","image":"","allow_vcard":"1","show_articles":"1","show_profile":"1","show_links":"1","linka_name":"","linkb_name":"","linkc_name":"","linkd_name":"","linke_name":"","show_tags":"1","contact_icons":"1","icon_address":"","icon_email":"","icon_telephone":"","icon_mobile":"","icon_fax":"","icon_misc":"","category_layout":"_:default","show_category_title":"1","show_description":"1","show_description_image":"1","maxLevel":"-1","show_empty_categories":"1","show_subcat_desc":"1","show_cat_items":"1","show_cat_tags":"1","show_base_description":"1","maxLevelcat":"-1","show_empty_categories_cat":"1","show_subcat_desc_cat":"1","show_cat_items_cat":"1","filter_field":"1","show_pagination_limit":"1","show_headings":"1","show_position_headings":"1","show_email_headings":"0","show_telephone_headings":"1","show_mobile_headings":"1","show_fax_headings":"1","show_suburb_headings":"1","show_state_headings":"1","show_country_headings":"1","show_pagination":"2","show_pagination_results":"1","initial_sort":"ordering","captcha":"","show_email_form":"1","show_email_copy":"1","banned_email":"","banned_subject":"","banned_text":"","validate_session":"1","custom_reply":"0","redirect":"","show_feed_link":"1"}','','','0','0000-00-00 00:00:00','0','0'),
('9','0','com_cpanel','component','com_cpanel','','1','1','1','1','{"name":"com_cpanel","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_CPANEL_XML_DESCRIPTION","group":""}','','','','0','0000-00-00 00:00:00','0','0'),
('10','0','com_installer','component','com_installer','','1','1','1','1','{"name":"com_installer","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_INSTALLER_XML_DESCRIPTION","group":""}','{}','','','0','0000-00-00 00:00:00','0','0'),
('11','0','com_languages','component','com_languages','','1','1','1','1','{"name":"com_languages","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_LANGUAGES_XML_DESCRIPTION","group":""}','{"administrator":"en-GB","site":"en-GB"}','','','0','0000-00-00 00:00:00','0','0'),
('12','0','com_login','component','com_login','','1','1','1','1','{"name":"com_login","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_LOGIN_XML_DESCRIPTION","group":""}','','','','0','0000-00-00 00:00:00','0','0'),
('13','0','com_media','component','com_media','','1','1','0','1','{"name":"com_media","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_MEDIA_XML_DESCRIPTION","group":"","filename":"media"}','{"upload_extensions":"bmp,csv,doc,gif,ico,jpg,jpeg,odg,odp,ods,odt,pdf,png,ppt,swf,txt,xcf,xls,BMP,CSV,DOC,GIF,ICO,JPG,JPEG,ODG,ODP,ODS,ODT,PDF,PNG,PPT,SWF,TXT,XCF,XLS","upload_maxsize":"10","file_path":"images","image_path":"images","restrict_uploads":"1","allowed_media_usergroup":"3","check_mime":"1","image_extensions":"bmp,gif,jpg,png","ignore_extensions":"","upload_mime":"image\\/jpeg,image\\/gif,image\\/png,image\\/bmp,application\\/x-shockwave-flash,application\\/msword,application\\/excel,application\\/pdf,application\\/powerpoint,text\\/plain,application\\/x-zip","upload_mime_illegal":"text\\/html","enable_flash":"0"}','','','0','0000-00-00 00:00:00','0','0'),
('14','0','com_menus','component','com_menus','','1','1','1','1','{"name":"com_menus","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_MENUS_XML_DESCRIPTION","group":""}','{}','','','0','0000-00-00 00:00:00','0','0'),
('15','0','com_messages','component','com_messages','','1','1','1','1','{"name":"com_messages","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_MESSAGES_XML_DESCRIPTION","group":""}','','','','0','0000-00-00 00:00:00','0','0'),
('16','0','com_modules','component','com_modules','','1','1','1','1','{"name":"com_modules","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_MODULES_XML_DESCRIPTION","group":""}','{}','','','0','0000-00-00 00:00:00','0','0'),
('17','0','com_newsfeeds','component','com_newsfeeds','','1','1','1','0','{"name":"com_newsfeeds","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_NEWSFEEDS_XML_DESCRIPTION","group":"","filename":"newsfeeds"}','{"newsfeed_layout":"_:default","show_feed_image":"1","show_feed_description":"1","show_item_description":"1","feed_character_count":"0","feed_display_order":"des","category_layout":"_:default","show_category_title":"1","show_description":"1","show_description_image":"1","maxLevel":"-1","show_empty_categories":"1","show_subcat_desc":"1","show_cat_items":"1","show_base_description":"1","maxLevelcat":"-1","show_empty_categories_cat":"0","show_subcat_desc_cat":"1","show_cat_items_cat":"1","show_pagination_limit":"1","show_headings":"1","show_articles":"1","show_link":"1","show_pagination":"1","show_pagination_results":"1"}','','','0','0000-00-00 00:00:00','0','0'),
('18','0','com_plugins','component','com_plugins','','1','1','1','1','{"name":"com_plugins","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_PLUGINS_XML_DESCRIPTION","group":""}','{}','','','0','0000-00-00 00:00:00','0','0'),
('19','0','com_search','component','com_search','','1','1','1','1','{"name":"com_search","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_SEARCH_XML_DESCRIPTION","group":"","filename":"search"}','{"enabled":"0","show_date":"1"}','','','0','0000-00-00 00:00:00','0','0'),
('20','0','com_templates','component','com_templates','','1','1','1','1','{"name":"com_templates","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_TEMPLATES_XML_DESCRIPTION","group":""}','{"template_positions_display":"0","upload_limit":"2","image_formats":"gif,bmp,jpg,jpeg,png","source_formats":"txt,less,ini,xml,js,php,css","font_formats":"woff,ttf,otf","compressed_formats":"zip"}','','','0','0000-00-00 00:00:00','0','0'),
('21','801','com_weblinks','component','com_weblinks','','1','1','1','0','{"name":"com_weblinks","type":"component","creationDate":"2017-03-08","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.6.0","description":"COM_WEBLINKS_XML_DESCRIPTION","group":"","filename":"weblinks"}','{"target":"0","count_clicks":"1","icons":1,"link_icons":"","category_layout":"_:default","show_category_title":"1","show_description":"1","show_description_image":"1","maxLevel":"-1","show_empty_categories":"1","show_subcat_desc":"1","show_cat_num_links":"1","show_base_description":"1","maxLevelcat":"-1","show_empty_categories_cat":"1","show_subcat_desc_cat":"1","show_cat_num_links_cat":"1","show_pagination_limit":"1","show_headings":"1","show_link_description":"1","show_link_hits":"1","show_pagination":"2","show_pagination_results":"1","show_feed_link":"1"}','','','0','0000-00-00 00:00:00','0','0'),
('22','0','com_content','component','com_content','','1','1','0','1','{"name":"com_content","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_CONTENT_XML_DESCRIPTION","group":"","filename":"content"}','{"article_layout":"_:default","show_title":"1","link_titles":"1","show_intro":"1","info_block_position":"0","show_category":"0","link_category":"0","show_parent_category":"0","link_parent_category":"0","show_author":"0","link_author":"0","show_create_date":"0","show_modify_date":"0","show_publish_date":"0","show_item_navigation":"0","show_vote":"0","show_readmore":"1","show_readmore_title":"0","readmore_limit":"100","show_tags":"0","show_icons":"0","show_print_icon":"0","show_email_icon":"0","show_hits":"0","show_noauth":"0","urls_position":"0","show_publishing_options":"1","show_article_options":"1","save_history":"0","history_limit":10,"show_urls_images_frontend":"1","show_urls_images_backend":"1","targeta":0,"targetb":0,"targetc":0,"float_intro":"left","float_fulltext":"none","category_layout":"_:blog","show_category_heading_title_text":"1","show_category_title":"1","show_description":"1","show_description_image":"1","maxLevel":"1","show_empty_categories":"1","show_no_articles":"1","show_subcat_desc":"1","show_cat_num_articles":"1","show_cat_tags":"1","show_base_description":"1","maxLevelcat":"-1","show_empty_categories_cat":"1","show_subcat_desc_cat":"1","show_cat_num_articles_cat":"1","num_leading_articles":"1","num_intro_articles":"4","num_columns":"2","num_links":"4","multi_column_order":"0","show_subcategory_content":"0","show_pagination_limit":"1","filter_field":"title","show_headings":"1","list_show_date":"0","date_format":"","list_show_hits":"1","list_show_author":"1","orderby_pri":"order","orderby_sec":"rdate","order_date":"published","show_pagination":"2","show_pagination_results":"1","show_feed_link":"1","feed_summary":"0","feed_show_readmore":"1"}','','','0','0000-00-00 00:00:00','0','0'),
('23','0','com_config','component','com_config','','1','1','0','1','{"name":"com_config","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_CONFIG_XML_DESCRIPTION","group":""}','{"filters":{"1":{"filter_type":"NH","filter_tags":"","filter_attributes":""},"9":{"filter_type":"BL","filter_tags":"","filter_attributes":""},"6":{"filter_type":"BL","filter_tags":"","filter_attributes":""},"7":{"filter_type":"NONE","filter_tags":"","filter_attributes":""},"2":{"filter_type":"NH","filter_tags":"","filter_attributes":""},"3":{"filter_type":"BL","filter_tags":"","filter_attributes":""},"4":{"filter_type":"BL","filter_tags":"","filter_attributes":""},"5":{"filter_type":"BL","filter_tags":"","filter_attributes":""},"8":{"filter_type":"NONE","filter_tags":"","filter_attributes":""}}}','','','0','0000-00-00 00:00:00','0','0'),
('24','0','com_redirect','component','com_redirect','','1','1','0','1','{"name":"com_redirect","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_REDIRECT_XML_DESCRIPTION","group":""}','{}','','','0','0000-00-00 00:00:00','0','0'),
('25','0','com_users','component','com_users','','1','1','0','1','{"name":"com_users","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_USERS_XML_DESCRIPTION","group":"","filename":"users"}','{"allowUserRegistration":"1","new_usertype":"2","guest_usergroup":"9","sendpassword":"1","useractivation":"1","mail_to_admin":"0","captcha":"","frontend_userparams":"1","site_language":"0","change_login_name":"0","reset_count":"10","reset_time":"1","minimum_length":"4","minimum_integers":"0","minimum_symbols":"0","minimum_uppercase":"0","save_history":"0","history_limit":5,"mailSubjectPrefix":"","mailBodySuffix":""}','','','0','0000-00-00 00:00:00','0','0'),
('27','0','com_finder','component','com_finder','','1','1','0','0','{"name":"com_finder","type":"component","creationDate":"August 2011","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_FINDER_XML_DESCRIPTION","group":"","filename":"finder"}','{"show_description":"1","description_length":255,"allow_empty_query":"0","show_url":"1","show_autosuggest":"1","show_advanced":"1","expand_advanced":"0","show_date_filters":"1","sort_order":"relevance","sort_direction":"desc","highlight_terms":"1","opensearch_name":"","opensearch_description":"","batch_size":"50","memory_table_limit":30000,"title_multiplier":"1.7","text_multiplier":"0.7","meta_multiplier":"1.2","path_multiplier":"2.0","misc_multiplier":"0.3","stem":"1","stemmer":"snowball","enable_logging":"0"}','','','0','0000-00-00 00:00:00','0','0'),
('28','0','com_joomlaupdate','component','com_joomlaupdate','','1','1','0','1','{"name":"com_joomlaupdate","type":"component","creationDate":"February 2012","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.6.2","description":"COM_JOOMLAUPDATE_XML_DESCRIPTION","group":""}','{}','','','0','0000-00-00 00:00:00','0','0'),
('29','0','com_tags','component','com_tags','','1','1','1','1','{"name":"com_tags","type":"component","creationDate":"December 2013","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.1.0","description":"COM_TAGS_XML_DESCRIPTION","group":"","filename":"tags"}','{}','','','0','0000-00-00 00:00:00','0','0'),
('30','0','com_contenthistory','component','com_contenthistory','','1','1','1','0','{"name":"com_contenthistory","type":"component","creationDate":"May 2013","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.2.0","description":"COM_CONTENTHISTORY_XML_DESCRIPTION","group":"","filename":"contenthistory"}','{}','','','0','0000-00-00 00:00:00','0','0'),
('31','0','com_ajax','component','com_ajax','','1','1','1','1','{"name":"com_ajax","type":"component","creationDate":"August 2013","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.2.0","description":"COM_AJAX_XML_DESCRIPTION","group":"","filename":"ajax"}','{}','','','0','0000-00-00 00:00:00','0','0'),
('32','0','com_postinstall','component','com_postinstall','','1','1','1','1','{"name":"com_postinstall","type":"component","creationDate":"September 2013","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.2.0","description":"COM_POSTINSTALL_XML_DESCRIPTION","group":""}','','','','0','0000-00-00 00:00:00','0','0'),
('455','0','plg_installer_packageinstaller','plugin','packageinstaller','installer','0','1','1','1','{"name":"plg_installer_packageinstaller","type":"plugin","creationDate":"May 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.6.0","description":"PLG_INSTALLER_PACKAGEINSTALLER_PLUGIN_XML_DESCRIPTION","group":"","filename":"packageinstaller"}','','','','0','0000-00-00 00:00:00','1','0'),
('456','0','PLG_INSTALLER_FOLDERINSTALLER','plugin','folderinstaller','installer','0','1','1','1','{"name":"PLG_INSTALLER_FOLDERINSTALLER","type":"plugin","creationDate":"May 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.6.0","description":"PLG_INSTALLER_FOLDERINSTALLER_PLUGIN_XML_DESCRIPTION","group":"","filename":"folderinstaller"}','','','','0','0000-00-00 00:00:00','2','0'),
('457','0','PLG_INSTALLER_URLINSTALLER','plugin','urlinstaller','installer','0','1','1','1','{"name":"PLG_INSTALLER_URLINSTALLER","type":"plugin","creationDate":"May 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.6.0","description":"PLG_INSTALLER_URLINSTALLER_PLUGIN_XML_DESCRIPTION","group":"","filename":"urlinstaller"}','','','','0','0000-00-00 00:00:00','3','0'),
('102','0','LIB_PHPUTF8','library','phputf8','','0','1','1','1','{"name":"LIB_PHPUTF8","type":"library","creationDate":"2006","author":"Harry Fuecks","copyright":"Copyright various authors","authorEmail":"hfuecks@gmail.com","authorUrl":"http:\\/\\/sourceforge.net\\/projects\\/phputf8","version":"0.5","description":"LIB_PHPUTF8_XML_DESCRIPTION","group":"","filename":"phputf8"}','','','','0','0000-00-00 00:00:00','0','0'),
('103','0','LIB_JOOMLA','library','joomla','','0','1','1','1','{"name":"LIB_JOOMLA","type":"library","creationDate":"2008","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"https:\\/\\/www.joomla.org","version":"13.1","description":"LIB_JOOMLA_XML_DESCRIPTION","group":"","filename":"joomla"}','{"mediaversion":"4a608b85a6e99cdfd8e65d6c9ca72865"}','','','0','0000-00-00 00:00:00','0','0'),
('104','0','LIB_IDNA','library','idna_convert','','0','1','1','1','{"name":"LIB_IDNA","type":"library","creationDate":"2004","author":"phlyLabs","copyright":"2004-2011 phlyLabs Berlin, http:\\/\\/phlylabs.de","authorEmail":"phlymail@phlylabs.de","authorUrl":"http:\\/\\/phlylabs.de","version":"0.8.0","description":"LIB_IDNA_XML_DESCRIPTION","group":"","filename":"idna_convert"}','','','','0','0000-00-00 00:00:00','0','0'),
('105','0','FOF','library','fof','','0','1','1','1','{"name":"FOF","type":"library","creationDate":"2015-04-22 13:15:32","author":"Nicholas K. Dionysopoulos \\/ Akeeba Ltd","copyright":"(C)2011-2015 Nicholas K. Dionysopoulos","authorEmail":"nicholas@akeebabackup.com","authorUrl":"https:\\/\\/www.akeebabackup.com","version":"2.4.3","description":"LIB_FOF_XML_DESCRIPTION","group":"","filename":"fof"}','{}','','','0','0000-00-00 00:00:00','0','0'),
('106','0','LIB_PHPASS','library','phpass','','0','1','1','1','{"name":"LIB_PHPASS","type":"library","creationDate":"2004-2006","author":"Solar Designer","copyright":"","authorEmail":"solar@openwall.com","authorUrl":"http:\\/\\/www.openwall.com\\/phpass\\/","version":"0.3","description":"LIB_PHPASS_XML_DESCRIPTION","group":"","filename":"phpass"}','{}','','','0','0000-00-00 00:00:00','0','0'),
('200','0','mod_articles_archive','module','mod_articles_archive','','0','1','1','1','{"name":"mod_articles_archive","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_ARTICLES_ARCHIVE_XML_DESCRIPTION","group":"","filename":"mod_articles_archive"}','','','','0','0000-00-00 00:00:00','0','0'),
('201','0','mod_articles_latest','module','mod_articles_latest','','0','1','1','1','{"name":"mod_articles_latest","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_LATEST_NEWS_XML_DESCRIPTION","group":"","filename":"mod_articles_latest"}','','','','0','0000-00-00 00:00:00','0','0'),
('202','0','mod_articles_popular','module','mod_articles_popular','','0','1','1','0','{"name":"mod_articles_popular","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_POPULAR_XML_DESCRIPTION","group":"","filename":"mod_articles_popular"}','','','','0','0000-00-00 00:00:00','0','0'),
('203','0','mod_banners','module','mod_banners','','0','1','1','1','{"name":"mod_banners","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_BANNERS_XML_DESCRIPTION","group":"","filename":"mod_banners"}','','','','0','0000-00-00 00:00:00','0','0'),
('204','0','mod_breadcrumbs','module','mod_breadcrumbs','','0','1','1','1','{"name":"mod_breadcrumbs","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_BREADCRUMBS_XML_DESCRIPTION","group":"","filename":"mod_breadcrumbs"}','','','','0','0000-00-00 00:00:00','0','0'),
('205','0','mod_custom','module','mod_custom','','0','1','1','1','{"name":"mod_custom","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_CUSTOM_XML_DESCRIPTION","group":"","filename":"mod_custom"}','','','','0','0000-00-00 00:00:00','0','0'),
('206','0','mod_feed','module','mod_feed','','0','1','1','1','{"name":"mod_feed","type":"module","creationDate":"July 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_FEED_XML_DESCRIPTION","group":"","filename":"mod_feed"}','','','','0','0000-00-00 00:00:00','0','0'),
('207','0','mod_footer','module','mod_footer','','0','1','1','1','{"name":"mod_footer","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_FOOTER_XML_DESCRIPTION","group":"","filename":"mod_footer"}','','','','0','0000-00-00 00:00:00','0','0'),
('208','0','mod_login','module','mod_login','','0','1','1','1','{"name":"mod_login","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_LOGIN_XML_DESCRIPTION","group":"","filename":"mod_login"}','','','','0','0000-00-00 00:00:00','0','0'),
('209','0','mod_menu','module','mod_menu','','0','1','1','1','{"name":"mod_menu","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_MENU_XML_DESCRIPTION","group":"","filename":"mod_menu"}','','','','0','0000-00-00 00:00:00','0','0'),
('210','0','mod_articles_news','module','mod_articles_news','','0','1','1','0','{"name":"mod_articles_news","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_ARTICLES_NEWS_XML_DESCRIPTION","group":"","filename":"mod_articles_news"}','','','','0','0000-00-00 00:00:00','0','0');
INSERT INTO `#__extensions` VALUES 
('211','0','mod_random_image','module','mod_random_image','','0','1','1','0','{"name":"mod_random_image","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_RANDOM_IMAGE_XML_DESCRIPTION","group":"","filename":"mod_random_image"}','','','','0','0000-00-00 00:00:00','0','0'),
('212','0','mod_related_items','module','mod_related_items','','0','1','1','0','{"name":"mod_related_items","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_RELATED_XML_DESCRIPTION","group":"","filename":"mod_related_items"}','','','','0','0000-00-00 00:00:00','0','0'),
('213','0','mod_search','module','mod_search','','0','1','1','0','{"name":"mod_search","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_SEARCH_XML_DESCRIPTION","group":"","filename":"mod_search"}','','','','0','0000-00-00 00:00:00','0','0'),
('214','0','mod_stats','module','mod_stats','','0','1','1','0','{"name":"mod_stats","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_STATS_XML_DESCRIPTION","group":"","filename":"mod_stats"}','','','','0','0000-00-00 00:00:00','0','0'),
('215','0','mod_syndicate','module','mod_syndicate','','0','1','1','1','{"name":"mod_syndicate","type":"module","creationDate":"May 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_SYNDICATE_XML_DESCRIPTION","group":"","filename":"mod_syndicate"}','','','','0','0000-00-00 00:00:00','0','0'),
('216','0','mod_users_latest','module','mod_users_latest','','0','1','1','1','{"name":"mod_users_latest","type":"module","creationDate":"December 2009","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_USERS_LATEST_XML_DESCRIPTION","group":"","filename":"mod_users_latest"}','','','','0','0000-00-00 00:00:00','0','0'),
('217','801','mod_weblinks','module','mod_weblinks','','0','1','1','0','{"name":"mod_weblinks","type":"module","creationDate":"2017-03-08","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.6.0","description":"MOD_WEBLINKS_XML_DESCRIPTION","group":"","filename":"mod_weblinks"}','','','','0','0000-00-00 00:00:00','0','0'),
('218','0','mod_whosonline','module','mod_whosonline','','0','1','1','0','{"name":"mod_whosonline","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_WHOSONLINE_XML_DESCRIPTION","group":"","filename":"mod_whosonline"}','','','','0','0000-00-00 00:00:00','0','0'),
('219','0','mod_wrapper','module','mod_wrapper','','0','1','1','0','{"name":"mod_wrapper","type":"module","creationDate":"October 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_WRAPPER_XML_DESCRIPTION","group":"","filename":"mod_wrapper"}','','','','0','0000-00-00 00:00:00','0','0'),
('220','0','mod_articles_category','module','mod_articles_category','','0','1','1','1','{"name":"mod_articles_category","type":"module","creationDate":"February 2010","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_ARTICLES_CATEGORY_XML_DESCRIPTION","group":"","filename":"mod_articles_category"}','','','','0','0000-00-00 00:00:00','0','0'),
('221','0','mod_articles_categories','module','mod_articles_categories','','0','1','1','1','{"name":"mod_articles_categories","type":"module","creationDate":"February 2010","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_ARTICLES_CATEGORIES_XML_DESCRIPTION","group":"","filename":"mod_articles_categories"}','','','','0','0000-00-00 00:00:00','0','0'),
('222','0','mod_languages','module','mod_languages','','0','1','1','1','{"name":"mod_languages","type":"module","creationDate":"February 2010","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.5.0","description":"MOD_LANGUAGES_XML_DESCRIPTION","group":"","filename":"mod_languages"}','','','','0','0000-00-00 00:00:00','0','0'),
('223','0','mod_finder','module','mod_finder','','0','1','0','0','{"name":"mod_finder","type":"module","creationDate":"August 2011","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_FINDER_XML_DESCRIPTION","group":"","filename":"mod_finder"}','','','','0','0000-00-00 00:00:00','0','0'),
('300','0','mod_custom','module','mod_custom','','1','1','1','1','{"name":"mod_custom","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_CUSTOM_XML_DESCRIPTION","group":"","filename":"mod_custom"}','','','','0','0000-00-00 00:00:00','0','0'),
('301','0','mod_feed','module','mod_feed','','1','1','1','0','{"name":"mod_feed","type":"module","creationDate":"July 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_FEED_XML_DESCRIPTION","group":"","filename":"mod_feed"}','','','','0','0000-00-00 00:00:00','0','0'),
('302','0','mod_latest','module','mod_latest','','1','1','1','0','{"name":"mod_latest","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_LATEST_XML_DESCRIPTION","group":"","filename":"mod_latest"}','','','','0','0000-00-00 00:00:00','0','0'),
('303','0','mod_logged','module','mod_logged','','1','1','1','0','{"name":"mod_logged","type":"module","creationDate":"January 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_LOGGED_XML_DESCRIPTION","group":"","filename":"mod_logged"}','','','','0','0000-00-00 00:00:00','0','0'),
('304','0','mod_login','module','mod_login','','1','1','1','1','{"name":"mod_login","type":"module","creationDate":"March 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_LOGIN_XML_DESCRIPTION","group":"","filename":"mod_login"}','','','','0','0000-00-00 00:00:00','0','0'),
('305','0','mod_menu','module','mod_menu','','1','1','1','0','{"name":"mod_menu","type":"module","creationDate":"March 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_MENU_XML_DESCRIPTION","group":"","filename":"mod_menu"}','','','','0','0000-00-00 00:00:00','0','0'),
('307','0','mod_popular','module','mod_popular','','1','1','1','0','{"name":"mod_popular","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_POPULAR_XML_DESCRIPTION","group":"","filename":"mod_popular"}','','','','0','0000-00-00 00:00:00','0','0'),
('308','0','mod_quickicon','module','mod_quickicon','','1','1','1','1','{"name":"mod_quickicon","type":"module","creationDate":"Nov 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_QUICKICON_XML_DESCRIPTION","group":"","filename":"mod_quickicon"}','','','','0','0000-00-00 00:00:00','0','0'),
('309','0','mod_status','module','mod_status','','1','1','1','0','{"name":"mod_status","type":"module","creationDate":"Feb 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_STATUS_XML_DESCRIPTION","group":"","filename":"mod_status"}','','','','0','0000-00-00 00:00:00','0','0'),
('310','0','mod_submenu','module','mod_submenu','','1','1','1','0','{"name":"mod_submenu","type":"module","creationDate":"Feb 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_SUBMENU_XML_DESCRIPTION","group":"","filename":"mod_submenu"}','','','','0','0000-00-00 00:00:00','0','0'),
('311','0','mod_title','module','mod_title','','1','1','1','0','{"name":"mod_title","type":"module","creationDate":"Nov 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_TITLE_XML_DESCRIPTION","group":"","filename":"mod_title"}','','','','0','0000-00-00 00:00:00','0','0'),
('312','0','mod_toolbar','module','mod_toolbar','','1','1','1','1','{"name":"mod_toolbar","type":"module","creationDate":"Nov 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_TOOLBAR_XML_DESCRIPTION","group":"","filename":"mod_toolbar"}','','','','0','0000-00-00 00:00:00','0','0'),
('313','0','mod_multilangstatus','module','mod_multilangstatus','','1','1','1','0','{"name":"mod_multilangstatus","type":"module","creationDate":"September 2011","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_MULTILANGSTATUS_XML_DESCRIPTION","group":"","filename":"mod_multilangstatus"}','{"cache":"0"}','','','0','0000-00-00 00:00:00','0','0'),
('314','0','mod_version','module','mod_version','','1','1','1','0','{"name":"mod_version","type":"module","creationDate":"January 2012","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_VERSION_XML_DESCRIPTION","group":"","filename":"mod_version"}','{"format":"short","product":"1","cache":"0"}','','','0','0000-00-00 00:00:00','0','0'),
('316','0','mod_tags_popular','module','mod_tags_popular','','0','1','1','0','{"name":"mod_tags_popular","type":"module","creationDate":"January 2013","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.1.0","description":"MOD_TAGS_POPULAR_XML_DESCRIPTION","group":"","filename":"mod_tags_popular"}','{"maximum":"5","timeframe":"alltime","owncache":"1"}','','','0','0000-00-00 00:00:00','0','0'),
('317','0','mod_tags_similar','module','mod_tags_similar','','0','1','1','0','{"name":"mod_tags_similar","type":"module","creationDate":"January 2013","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.1.0","description":"MOD_TAGS_SIMILAR_XML_DESCRIPTION","group":"","filename":"mod_tags_similar"}','{"maximum":"5","matchtype":"any","owncache":"1"}','','','0','0000-00-00 00:00:00','0','0'),
('400','0','plg_authentication_gmail','plugin','gmail','authentication','0','0','1','0','{"name":"plg_authentication_gmail","type":"plugin","creationDate":"February 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_GMAIL_XML_DESCRIPTION","group":"","filename":"gmail"}','{"applysuffix":"0","suffix":"","verifypeer":"1","user_blacklist":""}','','','0','0000-00-00 00:00:00','1','0'),
('401','0','plg_authentication_joomla','plugin','joomla','authentication','0','1','1','1','{"name":"plg_authentication_joomla","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_AUTH_JOOMLA_XML_DESCRIPTION","group":"","filename":"joomla"}','{}','','','0','0000-00-00 00:00:00','0','0'),
('402','0','plg_authentication_ldap','plugin','ldap','authentication','0','0','1','0','{"name":"plg_authentication_ldap","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_LDAP_XML_DESCRIPTION","group":"","filename":"ldap"}','{"host":"","port":"389","use_ldapV3":"0","negotiate_tls":"0","no_referrals":"0","auth_method":"bind","base_dn":"","search_string":"","users_dn":"","username":"admin","password":"bobby7","ldap_fullname":"fullName","ldap_email":"mail","ldap_uid":"uid"}','','','0','0000-00-00 00:00:00','3','0'),
('403','0','plg_content_contact','plugin','contact','content','0','1','1','0','{"name":"plg_content_contact","type":"plugin","creationDate":"January 2014","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.2.2","description":"PLG_CONTENT_CONTACT_XML_DESCRIPTION","group":"","filename":"contact"}','','','','0','0000-00-00 00:00:00','1','0'),
('404','0','plg_content_emailcloak','plugin','emailcloak','content','0','1','1','0','{"name":"plg_content_emailcloak","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_CONTENT_EMAILCLOAK_XML_DESCRIPTION","group":"","filename":"emailcloak"}','{"mode":"1"}','','','0','0000-00-00 00:00:00','1','0'),
('406','0','plg_content_loadmodule','plugin','loadmodule','content','0','1','1','0','{"name":"plg_content_loadmodule","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_LOADMODULE_XML_DESCRIPTION","group":"","filename":"loadmodule"}','{"style":"xhtml"}','','','0','2011-09-18 15:22:50','0','0'),
('407','0','plg_content_pagebreak','plugin','pagebreak','content','0','1','1','1','{"name":"plg_content_pagebreak","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_CONTENT_PAGEBREAK_XML_DESCRIPTION","group":"","filename":"pagebreak"}','{"title":"1","article_index":"1","article_index_text":"","multipage_toc":"1","showall":"1","style":"sliders"}','','','0','0000-00-00 00:00:00','4','0'),
('408','0','plg_content_pagenavigation','plugin','pagenavigation','content','0','1','1','1','{"name":"plg_content_pagenavigation","type":"plugin","creationDate":"January 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_PAGENAVIGATION_XML_DESCRIPTION","group":"","filename":"pagenavigation"}','{"position":"1"}','','','0','0000-00-00 00:00:00','5','0'),
('409','0','plg_content_vote','plugin','vote','content','0','1','1','1','{"name":"plg_content_vote","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_VOTE_XML_DESCRIPTION","group":"","filename":"vote"}','{}','','','0','0000-00-00 00:00:00','6','0'),
('410','0','plg_editors_codemirror','plugin','codemirror','editors','0','1','1','1','{"name":"plg_editors_codemirror","type":"plugin","creationDate":"28 March 2011","author":"Marijn Haverbeke","copyright":"Copyright (C) 2014 - 2017 by Marijn Haverbeke <marijnh@gmail.com> and others","authorEmail":"marijnh@gmail.com","authorUrl":"http:\\/\\/codemirror.net\\/","version":"5.28","description":"PLG_CODEMIRROR_XML_DESCRIPTION","group":"","filename":"codemirror"}','{"lineNumbers":"1","lineWrapping":"1","matchTags":"1","matchBrackets":"1","marker-gutter":"1","autoCloseTags":"1","autoCloseBrackets":"1","autoFocus":"1","theme":"default","tabmode":"indent"}','','','0','0000-00-00 00:00:00','1','0'),
('411','0','plg_editors_none','plugin','none','editors','0','1','1','1','{"name":"plg_editors_none","type":"plugin","creationDate":"September 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_NONE_XML_DESCRIPTION","group":"","filename":"none"}','{}','','','0','0000-00-00 00:00:00','2','0'),
('412','0','plg_editors_tinymce','plugin','tinymce','editors','0','1','1','1','{"name":"plg_editors_tinymce","type":"plugin","creationDate":"2005-2017","author":"Ephox Corporation","copyright":"Ephox Corporation","authorEmail":"N\\/A","authorUrl":"http:\\/\\/www.tinymce.com","version":"4.5.7","description":"PLG_TINY_XML_DESCRIPTION","group":"","filename":"tinymce"}','{"mode":"1","skin":"0","mobile":"0","entity_encoding":"raw","lang_mode":"0","text_direction":"ltr","content_css":"1","content_css_custom":"","relative_urls":"1","newlines":"0","invalid_elements":"script,applet","valid_elements":"","extended_elements":"span[*],a[*],p[*],div[*]","html_height":"550","html_width":"750","resizing":"1","element_path":"1","fonts":"1","paste":"1","searchreplace":"1","insertdate":"1","colors":"1","table":"1","smilies":"1","hr":"1","link":"1","media":"1","print":"1","directionality":"1","fullscreen":"1","alignment":"1","visualchars":"1","visualblocks":"1","nonbreaking":"1","template":"1","blockquote":"1","wordcount":"1","image_advtab":"1","advlist":"1","autosave":"1","contextmenu":"1","inlinepopups":"1","custom_plugin":"","custom_button":""}','','','0','0000-00-00 00:00:00','3','0'),
('413','0','plg_editors-xtd_article','plugin','article','editors-xtd','0','1','1','0','{"name":"plg_editors-xtd_article","type":"plugin","creationDate":"October 2009","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_ARTICLE_XML_DESCRIPTION","group":"","filename":"article"}','{}','','','0','0000-00-00 00:00:00','1','0'),
('414','0','plg_editors-xtd_image','plugin','image','editors-xtd','0','1','1','0','{"name":"plg_editors-xtd_image","type":"plugin","creationDate":"August 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_IMAGE_XML_DESCRIPTION","group":"","filename":"image"}','{}','','','0','0000-00-00 00:00:00','2','0'),
('415','0','plg_editors-xtd_pagebreak','plugin','pagebreak','editors-xtd','0','1','1','0','{"name":"plg_editors-xtd_pagebreak","type":"plugin","creationDate":"August 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_EDITORSXTD_PAGEBREAK_XML_DESCRIPTION","group":"","filename":"pagebreak"}','{}','','','0','0000-00-00 00:00:00','3','0'),
('416','0','plg_editors-xtd_readmore','plugin','readmore','editors-xtd','0','1','1','0','{"name":"plg_editors-xtd_readmore","type":"plugin","creationDate":"March 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_READMORE_XML_DESCRIPTION","group":"","filename":"readmore"}','{}','','','0','0000-00-00 00:00:00','4','0'),
('417','0','plg_search_categories','plugin','categories','search','0','1','1','0','{"name":"plg_search_categories","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SEARCH_CATEGORIES_XML_DESCRIPTION","group":"","filename":"categories"}','{"search_limit":"50","search_content":"1","search_archived":"1"}','','','0','0000-00-00 00:00:00','0','0'),
('418','0','plg_search_contacts','plugin','contacts','search','0','1','1','0','{"name":"plg_search_contacts","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SEARCH_CONTACTS_XML_DESCRIPTION","group":"","filename":"contacts"}','{"search_limit":"50","search_content":"1","search_archived":"1"}','','','0','0000-00-00 00:00:00','0','0'),
('419','0','plg_search_content','plugin','content','search','0','1','1','0','{"name":"plg_search_content","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SEARCH_CONTENT_XML_DESCRIPTION","group":"","filename":"content"}','{"search_limit":"50","search_content":"1","search_archived":"1"}','','','0','0000-00-00 00:00:00','0','0'),
('420','0','plg_search_newsfeeds','plugin','newsfeeds','search','0','1','1','0','{"name":"plg_search_newsfeeds","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SEARCH_NEWSFEEDS_XML_DESCRIPTION","group":"","filename":"newsfeeds"}','{"search_limit":"50","search_content":"1","search_archived":"1"}','','','0','0000-00-00 00:00:00','0','0'),
('421','801','plg_search_weblinks','plugin','weblinks','search','0','1','1','0','{"name":"plg_search_weblinks","type":"plugin","creationDate":"2017-03-08","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.6.0","description":"PLG_SEARCH_WEBLINKS_XML_DESCRIPTION","group":"","filename":"weblinks"}','{"search_limit":"50","search_content":"1","search_archived":"1"}','','','0','0000-00-00 00:00:00','0','0');
INSERT INTO `#__extensions` VALUES 
('422','0','plg_system_languagefilter','plugin','languagefilter','system','0','0','1','1','{"name":"plg_system_languagefilter","type":"plugin","creationDate":"July 2010","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SYSTEM_LANGUAGEFILTER_XML_DESCRIPTION","group":"","filename":"languagefilter"}','{}','','','0','0000-00-00 00:00:00','1','0'),
('423','0','plg_system_p3p','plugin','p3p','system','0','1','1','1','{"name":"plg_system_p3p","type":"plugin","creationDate":"September 2010","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_P3P_XML_DESCRIPTION","group":"","filename":"p3p"}','{"headers":"NOI ADM DEV PSAi COM NAV OUR OTRo STP IND DEM"}','','','0','0000-00-00 00:00:00','2','0'),
('424','0','plg_system_cache','plugin','cache','system','0','0','1','1','{"name":"plg_system_cache","type":"plugin","creationDate":"February 2007","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_CACHE_XML_DESCRIPTION","group":"","filename":"cache"}','{"browsercache":"0","cachetime":"15"}','','','0','0000-00-00 00:00:00','9','0'),
('425','0','plg_system_debug','plugin','debug','system','0','1','1','0','{"name":"plg_system_debug","type":"plugin","creationDate":"December 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_DEBUG_XML_DESCRIPTION","group":"","filename":"debug"}','{"profile":"1","queries":"1","memory":"1","language_files":"1","language_strings":"1","strip-first":"1","strip-prefix":"","strip-suffix":""}','','','0','0000-00-00 00:00:00','4','0'),
('426','0','plg_system_log','plugin','log','system','0','1','1','1','{"name":"plg_system_log","type":"plugin","creationDate":"April 2007","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_LOG_XML_DESCRIPTION","group":"","filename":"log"}','{}','','','0','0000-00-00 00:00:00','5','0'),
('427','0','plg_system_redirect','plugin','redirect','system','0','1','1','1','{"name":"plg_system_redirect","type":"plugin","creationDate":"April 2009","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SYSTEM_REDIRECT_XML_DESCRIPTION","group":"","filename":"redirect"}','{}','','','0','0000-00-00 00:00:00','6','0'),
('428','0','plg_system_remember','plugin','remember','system','0','1','1','1','{"name":"plg_system_remember","type":"plugin","creationDate":"April 2007","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_REMEMBER_XML_DESCRIPTION","group":"","filename":"remember"}','{}','','','0','0000-00-00 00:00:00','7','0'),
('429','0','plg_system_sef','plugin','sef','system','0','1','1','0','{"name":"plg_system_sef","type":"plugin","creationDate":"December 2007","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SEF_XML_DESCRIPTION","group":"","filename":"sef"}','{}','','','0','0000-00-00 00:00:00','8','0'),
('430','0','plg_system_logout','plugin','logout','system','0','1','1','1','{"name":"plg_system_logout","type":"plugin","creationDate":"April 2009","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SYSTEM_LOGOUT_XML_DESCRIPTION","group":"","filename":"logout"}','{}','','','0','0000-00-00 00:00:00','3','0'),
('431','0','plg_user_contactcreator','plugin','contactcreator','user','0','0','1','1','{"name":"plg_user_contactcreator","type":"plugin","creationDate":"August 2009","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_CONTACTCREATOR_XML_DESCRIPTION","group":"","filename":"contactcreator"}','{"autowebpage":"","category":"34","autopublish":"0"}','','','0','0000-00-00 00:00:00','1','0'),
('432','0','plg_user_joomla','plugin','joomla','user','0','1','1','0','{"name":"plg_user_joomla","type":"plugin","creationDate":"December 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_USER_JOOMLA_XML_DESCRIPTION","group":"","filename":"joomla"}','{"autoregister":"1"}','','','0','0000-00-00 00:00:00','2','0'),
('433','0','plg_user_profile','plugin','profile','user','0','1','1','1','{"name":"plg_user_profile","type":"plugin","creationDate":"January 2008","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_USER_PROFILE_XML_DESCRIPTION","group":"","filename":"profile"}','{"register-require_address1":"1","register-require_address2":"1","register-require_city":"1","register-require_region":"1","register-require_country":"1","register-require_postal_code":"1","register-require_phone":"1","register-require_website":"1","register-require_favoritebook":"1","register-require_aboutme":"1","register-require_tos":"2","register_tos_article":"","register-require_dob":"1","profile-require_address1":"1","profile-require_address2":"1","profile-require_city":"1","profile-require_region":"1","profile-require_country":"1","profile-require_postal_code":"1","profile-require_phone":"1","profile-require_website":"1","profile-require_favoritebook":"1","profile-require_aboutme":"1","profile-require_dob":"1"}','','','0','0000-00-00 00:00:00','0','0'),
('434','0','plg_extension_joomla','plugin','joomla','extension','0','1','1','1','{"name":"plg_extension_joomla","type":"plugin","creationDate":"May 2010","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_EXTENSION_JOOMLA_XML_DESCRIPTION","group":"","filename":"joomla"}','{}','','','0','0000-00-00 00:00:00','1','0'),
('435','0','plg_content_joomla','plugin','joomla','content','0','1','1','0','{"name":"plg_content_joomla","type":"plugin","creationDate":"November 2010","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_CONTENT_JOOMLA_XML_DESCRIPTION","group":"","filename":"joomla"}','{}','','','0','0000-00-00 00:00:00','0','0'),
('436','0','plg_system_languagecode','plugin','languagecode','system','0','0','1','0','{"name":"plg_system_languagecode","type":"plugin","creationDate":"November 2011","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SYSTEM_LANGUAGECODE_XML_DESCRIPTION","group":"","filename":"languagecode"}','{}','','','0','0000-00-00 00:00:00','10','0'),
('437','0','plg_quickicon_joomlaupdate','plugin','joomlaupdate','quickicon','0','1','1','1','{"name":"plg_quickicon_joomlaupdate","type":"plugin","creationDate":"August 2011","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_QUICKICON_JOOMLAUPDATE_XML_DESCRIPTION","group":"","filename":"joomlaupdate"}','{}','','','0','0000-00-00 00:00:00','0','0'),
('438','0','plg_quickicon_extensionupdate','plugin','extensionupdate','quickicon','0','1','1','1','{"name":"plg_quickicon_extensionupdate","type":"plugin","creationDate":"August 2011","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_QUICKICON_EXTENSIONUPDATE_XML_DESCRIPTION","group":"","filename":"extensionupdate"}','{}','','','0','0000-00-00 00:00:00','0','0'),
('439','0','plg_captcha_recaptcha','plugin','recaptcha','captcha','0','1','1','0','{"name":"plg_captcha_recaptcha","type":"plugin","creationDate":"December 2011","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.4.0","description":"PLG_CAPTCHA_RECAPTCHA_XML_DESCRIPTION","group":"","filename":"recaptcha"}','{"public_key":"","private_key":"","theme":"clean"}','','','0','0000-00-00 00:00:00','0','0'),
('440','0','plg_system_highlight','plugin','highlight','system','0','1','1','0','{"name":"plg_system_highlight","type":"plugin","creationDate":"August 2011","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SYSTEM_HIGHLIGHT_XML_DESCRIPTION","group":"","filename":"highlight"}','{}','','','0','0000-00-00 00:00:00','7','0'),
('441','0','plg_content_finder','plugin','finder','content','0','0','1','0','{"name":"plg_content_finder","type":"plugin","creationDate":"December 2011","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_CONTENT_FINDER_XML_DESCRIPTION","group":"","filename":"finder"}','{}','','','0','0000-00-00 00:00:00','0','0'),
('442','0','plg_finder_categories','plugin','categories','finder','0','1','1','0','{"name":"plg_finder_categories","type":"plugin","creationDate":"August 2011","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_FINDER_CATEGORIES_XML_DESCRIPTION","group":"","filename":"categories"}','{}','','','0','0000-00-00 00:00:00','1','0'),
('443','0','plg_finder_contacts','plugin','contacts','finder','0','1','1','0','{"name":"plg_finder_contacts","type":"plugin","creationDate":"August 2011","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_FINDER_CONTACTS_XML_DESCRIPTION","group":"","filename":"contacts"}','{}','','','0','0000-00-00 00:00:00','2','0'),
('444','0','plg_finder_content','plugin','content','finder','0','1','1','0','{"name":"plg_finder_content","type":"plugin","creationDate":"August 2011","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_FINDER_CONTENT_XML_DESCRIPTION","group":"","filename":"content"}','{}','','','0','0000-00-00 00:00:00','3','0'),
('445','0','plg_finder_newsfeeds','plugin','newsfeeds','finder','0','1','1','0','{"name":"plg_finder_newsfeeds","type":"plugin","creationDate":"August 2011","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_FINDER_NEWSFEEDS_XML_DESCRIPTION","group":"","filename":"newsfeeds"}','{}','','','0','0000-00-00 00:00:00','4','0'),
('446','801','plg_finder_weblinks','plugin','weblinks','finder','0','1','1','0','{"name":"plg_finder_weblinks","type":"plugin","creationDate":"2017-03-08","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.6.0","description":"PLG_FINDER_WEBLINKS_XML_DESCRIPTION","group":"","filename":"weblinks"}','{}','','','0','0000-00-00 00:00:00','5','0'),
('447','0','plg_finder_tags','plugin','tags','finder','0','1','1','0','{"name":"plg_finder_tags","type":"plugin","creationDate":"February 2013","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_FINDER_TAGS_XML_DESCRIPTION","group":"","filename":"tags"}','{}','','','0','0000-00-00 00:00:00','0','0'),
('448','0','plg_twofactorauth_totp','plugin','totp','twofactorauth','0','0','1','0','{"name":"plg_twofactorauth_totp","type":"plugin","creationDate":"August 2013","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.2.0","description":"PLG_TWOFACTORAUTH_TOTP_XML_DESCRIPTION","group":"","filename":"totp"}','{}','','','0','0000-00-00 00:00:00','0','0'),
('449','0','plg_authentication_cookie','plugin','cookie','authentication','0','1','1','0','{"name":"plg_authentication_cookie","type":"plugin","creationDate":"July 2013","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_AUTH_COOKIE_XML_DESCRIPTION","group":"","filename":"cookie"}','{}','','','0','0000-00-00 00:00:00','0','0'),
('450','0','plg_twofactorauth_yubikey','plugin','yubikey','twofactorauth','0','0','1','0','{"name":"plg_twofactorauth_yubikey","type":"plugin","creationDate":"September 2013","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.2.0","description":"PLG_TWOFACTORAUTH_YUBIKEY_XML_DESCRIPTION","group":"","filename":"yubikey"}','{}','','','0','0000-00-00 00:00:00','0','0'),
('451','0','plg_search_tags','plugin','tags','search','0','0','1','0','{"name":"plg_search_tags","type":"plugin","creationDate":"March 2014","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SEARCH_TAGS_XML_DESCRIPTION","group":"","filename":"tags"}','{"search_limit":"50","show_tagged_items":"1"}','','','0','0000-00-00 00:00:00','0','0'),
('503','0','beez3','template','beez3','','0','1','1','0','{"name":"beez3","type":"template","creationDate":"25 November 2009","author":"Angie Radtke","copyright":"Copyright (C) 2005 - 2017 Open Source Matters, Inc. All rights reserved.","authorEmail":"a.radtke@derauftritt.de","authorUrl":"http:\\/\\/www.der-auftritt.de","version":"3.1.0","description":"TPL_BEEZ3_XML_DESCRIPTION","group":"","filename":"templateDetails"}','{"wrapperSmall":"53","wrapperLarge":"72","sitetitle":"","sitedescription":"","navposition":"center","templatecolor":"nature"}','','','0','0000-00-00 00:00:00','0','0'),
('504','0','hathor','template','hathor','','1','1','1','0','{"name":"hathor","type":"template","creationDate":"May 2010","author":"Andrea Tarr","copyright":"Copyright (C) 2005 - 2017 Open Source Matters, Inc. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"","version":"3.0.0","description":"TPL_HATHOR_XML_DESCRIPTION","group":"","filename":"templateDetails"}','{"showSiteName":"0","colourChoice":"0","boldText":"0"}','','','0','0000-00-00 00:00:00','0','0'),
('506','0','protostar','template','protostar','','0','1','1','0','{"name":"protostar","type":"template","creationDate":"4\\/30\\/2012","author":"Kyle Ledbetter","copyright":"Copyright (C) 2005 - 2017 Open Source Matters, Inc. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"","version":"1.0","description":"TPL_PROTOSTAR_XML_DESCRIPTION","group":"","filename":"templateDetails"}','{"templateColor":"","logoFile":"","googleFont":"1","googleFontName":"Open+Sans","fluidContainer":"0"}','','','0','0000-00-00 00:00:00','0','0'),
('507','0','isis','template','isis','','1','1','1','0','{"name":"isis","type":"template","creationDate":"3\\/30\\/2012","author":"Kyle Ledbetter","copyright":"Copyright (C) 2005 - 2017 Open Source Matters, Inc. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"","version":"1.0","description":"TPL_ISIS_XML_DESCRIPTION","group":"","filename":"templateDetails"}','{"templateColor":"","logoFile":""}','','','0','0000-00-00 00:00:00','0','0'),
('600','802','English (en-GB)','language','en-GB','','0','1','1','1','{"name":"English (en-GB)","type":"language","creationDate":"September 2017","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.8.0","description":"en-GB site language","group":""}','','','','0','0000-00-00 00:00:00','0','0'),
('601','802','English (en-GB)','language','en-GB','','1','1','1','1','{"name":"English (en-GB)","type":"language","creationDate":"September 2017","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.8.0","description":"en-GB administrator language","group":""}','','','','0','0000-00-00 00:00:00','0','0'),
('700','0','files_joomla','file','joomla','','0','1','1','1','{"name":"files_joomla","type":"file","creationDate":"September 2017","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.8.0","description":"FILES_JOOMLA_XML_DESCRIPTION","group":""}','','','','0','0000-00-00 00:00:00','0','0'),
('10003','10010','DJ-MediaTools Album','module','mod_djmediatools','','0','1','0','0','{"name":"DJ-MediaTools Album","type":"module","creationDate":"August 2017","author":"DJ-Extensions.com","copyright":"Copyright (C) 2017 DJ-Extensions.com, All rights reserved.","authorEmail":"contact@dj-extensions.com","authorUrl":"http:\\/\\/dj-extensions.com","version":"2.10.0","description":"MOD_DJMEDIATOOLS_DESC","group":"","filename":"mod_djmediatools"}','{"catid":"","layout":"","slider_type":"","desc_effect":"","sort_by":"","link_image":"","image_width":"","image_height":"","resizing":"","quality":"","thumb_width":"","thumb_height":"","visible_images":"","space_between_images":"","max_images":"","show_thumbs":"","tab_indicator":"","tab_width":"","tab_height":"","tab_position":"","show_title":"","show_desc":"","show_readmore":"","readmore_text":"","link_title":"","link_desc":"","limit_desc":"","autoplay":"","pause_autoplay":"","show_buttons":"","show_arrows":"","show_custom_nav":"","effect":"","effect_type":"","duration":"","delay":"","lag":"","preload":"","desc_position":"","desc_width":"","desc_bottom":"","desc_horizontal":"","left_arrow":"","right_arrow":"","play_button":"","pause_button":"","arrows_top":"","arrows_horizontal":"","custom_nav_pos":"","custom_nav_align":"","loader_position":"","cache":"1","cache_time":"900"}','','','0','0000-00-00 00:00:00','0','0'),
('10004','10010','plg_content_djmediatools','plugin','djmediatools','content','0','1','1','0','{"name":"plg_content_djmediatools","type":"plugin","creationDate":"August 2017","author":"DJ-Extensions.com","copyright":"Copyright (C) 2017 DJ-Extensions.com, All rights reserved.","authorEmail":"contact@dj-extensions.com","authorUrl":"http:\\/\\/dj-extensions.com","version":"2.2.1","description":"PLG_CONTENT_DJMEDIATOOLS_DESCRIPTION","group":"","filename":"djmediatools"}','{}','','','0','0000-00-00 00:00:00','0','0'),
('10005','10010','plg_editors-xtd_djmediatools','plugin','djmediatools','editors-xtd','0','1','1','0','{"name":"plg_editors-xtd_djmediatools","type":"plugin","creationDate":"August 2017","author":"DJ-Extensions.com","copyright":"Copyright (C) 2017 DJ-Extensions.com, All rights reserved.","authorEmail":"contact@dj-extensions.com","authorUrl":"http:\\/\\/dj-extensions.com","version":"2.10.0","description":"PLG_EDITORSXTD_DJMEDIATOOLS_DESCRIPTION","group":"","filename":"djmediatools"}','{}','','','0','0000-00-00 00:00:00','0','0'),
('10006','10010','plg_djmediatools_content','plugin','content','djmediatools','0','1','1','0','{"name":"plg_djmediatools_content","type":"plugin","creationDate":"August 2017","author":"DJ-Extensions.com","copyright":"Copyright (C) 2017 DJ-Extensions.com, All rights reserved.","authorEmail":"contact@dj-extensions.com","authorUrl":"http:\\/\\/dj-extensions.com","version":"2.0","description":"PLG_DJMEDIATOOLS_CONTENT_DESCRIPTION","group":"","filename":"content"}','{"plg_content_type":"featured","plg_content_maxlevel":"0"}','','','0','0000-00-00 00:00:00','0','0'),
('10007','10010','plg_djmediatools_folder','plugin','folder','djmediatools','0','1','1','0','{"name":"plg_djmediatools_folder","type":"plugin","creationDate":"August 2017","author":"DJ-Extensions.com","copyright":"Copyright (C) 2017 DJ-Extensions.com, All rights reserved.","authorEmail":"contact@dj-extensions.com","authorUrl":"http:\\/\\/dj-extensions.com","version":"1.3.0","description":"PLG_DJMEDIATOOLS_FOLDER_DESCRIPTION","group":"","filename":"folder"}','{"plg_folder_path":"","plg_folder_link":""}','','','0','0000-00-00 00:00:00','0','0'),
('10008','10010','plg_djmediatools_djcatalog2','plugin','djcatalog2','djmediatools','0','1','1','0','{"name":"plg_djmediatools_djcatalog2","type":"plugin","creationDate":"August 2017","author":"DJ-Extensions.com","copyright":"Copyright (C) 2017 DJ-Extensions.com, All rights reserved.","authorEmail":"contact@dj-extensions.com","authorUrl":"http:\\/\\/dj-extensions.com","version":"1.3.2","description":"PLG_DJMEDIATOOLS_DJCATALOG2_DESCRIPTION","group":"","filename":"djcatalog2"}','{"plg_catalog2_catid":"0","plg_catalog2_featured_only":"0","plg_catalog2_featured_first":"0","plg_catalog2_orderby":"0","plg_catalog2_orderdir":"0"}','','','0','0000-00-00 00:00:00','0','0'),
('10009','10010','com_djmediatools','component','com_djmediatools','','1','1','0','0','{"name":"com_djmediatools","type":"component","creationDate":"August 2017","author":"DJ-Extensions.com","copyright":"Copyright (C) 2017 DJ-Extensions.com, All rights reserved.","authorEmail":"contact@dj-extensions.com","authorUrl":"http:\\/\\/dj-extensions.com","version":"2.10.0","description":"DJ-MediaTools component","group":"","filename":"djmediatools"}','{"show_cat_titles":"2","cwidth":"255","cheight":"255","cresizing":"crop","cquality":"85","show_cat_title":"1","show_cat_desc":"after","show_subcategories":"after","show_album_title":"1","show_album_desc":"1","zoom":"1","window_size":"fluid","window_width":"900","window_height":"500","comments":"0","facebook_sdk":"1","facebook_admins":"","disqus_shortname":"","layout":"_:slideshow","slider_type":"left","desc_effect":"fade","sort_by":"1","link_image":"1","lightbox":"picbox","image_width":"600","image_height":"400","resizing":"crop","quality":"90","thumb_width":"","thumb_height":"","visible_images":"2","space_between_images":"10","max_images":"50","show_thumbs":"1","tab_indicator":"2","tab_width":"200","tab_height":"80","tab_position":"right","show_title":"1","show_desc":"1","show_readmore":"1","readmore_text":"Readmore","link_title":"1","link_desc":"0","limit_desc":"200","autoplay":"1","pause_autoplay":"1","show_buttons":"2","show_arrows":"2","show_custom_nav":"1","effect":"Expo","effect_type":"0","duration":"","delay":"","lag":"","preload":"","desc_position":"over","desc_width":"","desc_bottom":"0","desc_horizontal":"0","left_arrow":"images\\/modules\\/navi\\/prev.png","right_arrow":"images\\/modules\\/navi\\/next.png","play_button":"images\\/modules\\/navi\\/play.png","pause_button":"images\\/modules\\/navi\\/pause.png","arrows_top":"50","arrows_horizontal":"20","custom_nav_pos":"below","custom_nav_align":"center","loader_position":"tl","upload_max_size":"10240","upload_chunk_size":"1024","upload_width":"1600","upload_height":"1200","upload_quality":"90"}','','','0','0000-00-00 00:00:00','0','0'),
('10010','0','DJ-MediaTools Package','package','pkg_dj-mediatools','','0','1','1','0','{"name":"DJ-MediaTools Package","type":"package","creationDate":"August 2017","author":"DJ-Extensions.com","copyright":"Copyright (C) 2017 DJ-Extensions.com, All rights reserved.","authorEmail":"contact@dj-extensions.com","authorUrl":"http:\\/\\/dj-extensions.com","version":"2.10.0","description":"\\n\\t\\t<style type=\\"text\\/css\\">\\n\\t\\t\\t.djex-info { padding: 20px 30px 10px; margin: 0 0 20px 0; background: #25a3a3; color: #fff; border: 1px solid #1e8282; font-family: Arial, Helvetica, sans-serif; font-size: 13px; font-weight: normal; -webkit-border-radius: 4px; border-radius: 4px; }\\n\\t\\t\\t.djex-title { text-transform: uppercase; font-weight: bold; font-size: 14px; }\\n\\t\\t\\t.djex-info a:link, .djex-info a:visited, .djex-info a:hover { color:#fff; text-decoration:underline; font-weight: 600; }\\t\\n\\t\\t\\t.djex-info img { float: left; margin: 0 30px 10px 0; }\\n\\t\\t<\\/style>\\n\\t\\t<div class=\\"djex-info\\">\\n\\t\\t\\t<img src=\\"components\\/com_djmediatools\\/assets\\/ex_mediatools.png\\" \\/>\\n\\t\\t\\t<p class=\\"djex-title\\">Thank you for installing DJ-MediaTools!<\\/p>\\n\\t\\t\\t<p>The DJ-MediaTools extension allows you to display albums containing custom items or any different content from other 3rd party extensions on different layouts including Gallery Grid, Slideshow based on our new script or Slider based on DJ-ImageSlider and more up to 9 different layouts.\\n\\t\\t\\tIf you want to learn how to use DJ-MediaTools please read <a target=\\"_blank\\" href=\\"http:\\/\\/dj-extensions.com\\/documentation\\">Documentation<\\/a> and visit our <a target=\\"_blank\\" href=\\"http:\\/\\/dj-extensions.com\\/faq\\">FAQ Section<\\/a><\\/p>\\n\\t\\t\\t<p>Check out our other extensions at <a target=\\"_blank\\" href=\\"http:\\/\\/dj-extensions.com\\">DJ-Extensions.com<\\/a><\\/p>\\n\\t\\t\\t<div style=\\"clear:both\\"><\\/div>\\n\\t\\t<\\/div>\\n\\t\\t","group":"","filename":"pkg_dj-mediatools"}','{}','','','0','0000-00-00 00:00:00','0','0'),
('10011','10013','plg_system_djmegamenu','plugin','djmegamenu','system','0','1','1','0','{"name":"plg_system_djmegamenu","type":"plugin","creationDate":"August 2017","author":"DJ-Extensions.com","copyright":"Copyright (C) 2013-2016 DJ-Extensions.com, All rights reserved.","authorEmail":"contact@dj-extensions.com","authorUrl":"http:\\/\\/dj-extensions.com","version":"3.5.0","description":"PLG_SYSTEM_DJMEGAMENU_DESCRIPTION","group":"","filename":"djmegamenu"}','{}','','','0','0000-00-00 00:00:00','0','0'),
('10012','10013','DJ-MegaMenu','module','mod_djmegamenu','','0','1','0','0','{"name":"DJ-MegaMenu","type":"module","creationDate":"August 2017","author":"DJ-Extensions.com","copyright":"Copyright (C) 2012-2016 DJ-Extensions.com, All rights reserved.","authorEmail":"contact@dj-extensions.com","authorUrl":"http:\\/\\/dj-extensions.com","version":"3.5.4","description":"MOD_DJMEGAMENU_MODULE_DESC","group":"","filename":"mod_djmegamenu"}','{"menu":"mainmenu","theme":"default","startLevel":"1","endLevel":"0","expand":"0","column_width":"200","usenote":"1","moo":"1","event":"mouseenter","wrapper":"","select":"0","width":"979","height_fx":"1","width_fx":"0","opacity_fx":"1","height_fx_sub":"1","width_fx_sub":"1","opacity_fx_sub":"1","effect":"cubic","duration":"","delay":"","cache":"1","cache_time":"900","cachemode":"itemid"}','','','0','0000-00-00 00:00:00','0','0'),
('10013','0','DJ-MegaMenu Pro Package','package','pkg_dj-megamenu','','0','1','1','0','{"name":"DJ-MegaMenu Pro Package","type":"package","creationDate":"August 2017","author":"DJ-Extensions.com","copyright":"Copyright (C) 2012-2016 DJ-Extensions.com, All rights reserved.","authorEmail":"contact@dj-extensions.com","authorUrl":"http:\\/\\/dj-extensions.com","version":"3.5.4","description":"\\n\\t\\t<style type=\\"text\\/css\\">\\n\\t\\t\\t.djex-info { padding: 20px 30px 10px; margin: 0 0 20px 0; background: #5c14a6; color: #fff; border: 1px solid #400e74; font-family: Arial, Helvetica, sans-serif; font-size: 13px; font-weight: normal; -webkit-border-radius: 4px; border-radius: 4px; }\\n\\t\\t\\t.djex-title { text-transform: uppercase; font-weight: bold; font-size: 14px; }\\n\\t\\t\\t.djex-info a:link, .djex-info a:visited, .djex-info a:hover { color:#fff; text-decoration:underline; font-weight: 600; }\\t\\n\\t\\t\\t.djex-info img { float: left; margin: 0 30px 10px 0; }\\n\\t\\t<\\/style>\\n\\t\\t<div class=\\"djex-info\\">\\n\\t\\t\\t<img src=\\"..\\/modules\\/mod_djmegamenu\\/assets\\/images\\/ex_megamenu.png\\" \\/>\\n\\t\\t\\t<p class=\\"djex-title\\">Thank you for installing DJ-MegaMenu Professional Edition!<\\/p>\\n\\t\\t\\t<p>The DJ-MegaMenu is an advanced menu system for your Joomla! and it\'s ready for mobiles providing Offcanvas Menu, Acordion Menu or simple Select Menu opened with well know mobile menu icon.\\n\\t\\t\\tIf you want to learn how to use DJ-MegaMenu please read <a target=\\"_blank\\" href=\\"http:\\/\\/dj-extensions.com\\/documentation\\">Documentation<\\/a> and visit our <a target=\\"_blank\\" href=\\"http:\\/\\/dj-extensions.com\\/faq\\">FAQ Section<\\/a><\\/p>\\n\\t\\t\\t<p>Check out our other extensions at <a target=\\"_blank\\" href=\\"http:\\/\\/dj-extensions.com\\">DJ-Extensions.com<\\/a><\\/p>\\n\\t\\t\\t<div style=\\"clear:both\\"><\\/div>\\n\\t\\t<\\/div>\\n\\t\\t","group":"","filename":"pkg_dj-megamenu"}','{}','','','0','0000-00-00 00:00:00','0','0'),
('10014','10010','plg_djmediatools_virtuemart','plugin','virtuemart','djmediatools','0','0','1','0','{"name":"plg_djmediatools_virtuemart","type":"plugin","creationDate":"August 2017","author":"DJ-Extensions.com","copyright":"Copyright (C) 2017 DJ-Extensions.com, All rights reserved.","authorEmail":"contact@dj-extensions.com","authorUrl":"http:\\/\\/dj-extensions.com","version":"1.3.0","description":"PLG_DJMEDIATOOLS_VIRTUEMART_DESCRIPTION","group":"","filename":"virtuemart"}','{"plg_virtuemart_product_group":"latest","plg_virtuemart_show_price":"1","plg_virtuemart_show_addtocart":"1"}','','','0','0000-00-00 00:00:00','0','0'),
('10015','10010','plg_djmediatools_k2','plugin','k2','djmediatools','0','0','1','0','{"name":"plg_djmediatools_k2","type":"plugin","creationDate":"August 2017","author":"DJ-Extensions.com","copyright":"Copyright (C) 2017 DJ-Extensions.com, All rights reserved.","authorEmail":"contact@dj-extensions.com","authorUrl":"http:\\/\\/dj-extensions.com","version":"1.2.0","description":"PLG_DJMEDIATOOLS_K2_DESCRIPTION","group":"","filename":"k2"}','{"plg_k2_source":"filter","":"K2_ITEM_VIEW_OPTIONS_COMMON_FOR_EITHER_SOURCE","plg_k2_catfilter":"0","plg_k2_category_id":"","plg_k2_getChildren":"0","plg_k2_itemsOrdering":"","plg_k2_FeaturedItems":"1","plg_k2_popularityRange":"","plg_k2_videosOnly":"0","plg_k2_item":"","plg_k2_items":""}','','','0','0000-00-00 00:00:00','0','0');
INSERT INTO `#__extensions` VALUES 
('10016','10020','DJ-Tabs','module','mod_djtabs','','0','1','0','0','{"name":"DJ-Tabs","type":"module","creationDate":"August 2013","author":"DJ-Extensions.com","copyright":"Copyright (C) 2013 DJ-Extensions.com LTD, All rights reserved.","authorEmail":"contact@design-jooma.eu","authorUrl":"http:\\/\\/design-joomla.eu","version":"1.3.4","description":"DJ-Tabs module","group":"","filename":"mod_djtabs"}','{"group_id":"0","layout":"tabs","accordion_display":"1","video_autopause":"","tabs_hidden":"2","rows_number":"1"}','','','0','0000-00-00 00:00:00','0','0'),
('10017','10020','com_djtabs','component','com_djtabs','','1','1','0','0','{"name":"com_djtabs","type":"component","creationDate":"August 2013","author":"DJ-Extensions.com","copyright":"Copyright (C) 2013 DJ-Extensions.com, All rights reserved.","authorEmail":"contact@dj-extensions.com","authorUrl":"http:\\/\\/dj-extensions.com","version":"1.3.4","description":"DJ-Tabs component","group":"","filename":"djtabs"}','{"date":"0","date_position":"1","date_format":"l, d F Y","title":"0","title_link":"0","title_char_limit":"100","image":"1","image_position":"1","image_link":"1","image_width":"","image_height":"","thumbnails":"1","thumbnails_quality":"85","description":"1","description_link":"0","HTML_in_description":"1","description_char_limit":"500","readmore_button":"0","readmore_text":"","category":"0","category_link":"0","author":"0","video_autopause":"2","accordion_display":"1","rows_number":"1"}','','','0','0000-00-00 00:00:00','0','0'),
('10018','10020','plg_editors-xtd_djtabs','plugin','djtabs','editors-xtd','0','1','1','0','{"name":"plg_editors-xtd_djtabs","type":"plugin","creationDate":"November 2013","author":"DJ-Extensions.com","copyright":"Copyright (C) 2013 DJ-Extensions.com, All rights reserved.","authorEmail":"contact@dj-extensions.com","authorUrl":"http:\\/\\/dj-extensions.com","version":"1.0.0","description":"PLG_EDITORSXTD_DJTABS_DESCRIPTION","group":"","filename":"djtabs"}','{}','','','0','0000-00-00 00:00:00','0','0'),
('10019','10020','plg_content_djtabs','plugin','djtabs','content','0','1','1','0','{"name":"plg_content_djtabs","type":"plugin","creationDate":"November 2013","author":"DJ-Extensions.com","copyright":"Copyright (C) 2013 DJ-Extensions.com, All rights reserved.","authorEmail":"contact@dj-extensions.com","authorUrl":"http:\\/\\/dj-extensions.com","version":"1.3","description":"PLG_CONTENT_DJTABS_DESCRIPTION","group":"","filename":"djtabs"}','{}','','','0','0000-00-00 00:00:00','0','0'),
('10020','0','DJ-Tabs Package','package','pkg_dj-tabs','','0','1','1','0','{"name":"DJ-Tabs Package","type":"package","creationDate":"August 2013","author":"DJ-Extensions.com","copyright":"Copyright (C) 2013 DJ-Extensions.com, All rights reserved.","authorEmail":"contact@dj-extensions.com","authorUrl":"http:\\/\\/dj-extensions.com","version":"1.3.4","description":"\\n\\t\\t<style> #right-text {font-family:Arial, Helvetica, sans-serif;\\tfont-size:11px;\\t} #right-text a:link, #right-text a:visited {color:#4991c1;font-weight:bold; font-size: 13px;} #right-text a:hover {text-decoration:underline;}\\t#right-text h2 {color:#fa9539;text-transform:uppercase;\\tfont-size:16px;\\tpadding:0;\\tmargin:2px 0;}\\t#right-text p {padding:0;margin:4px 0;}\\t#left-logo {float:left;width:300px;height:120px;display:block;} #left-logo img {margin: 40px 20px;} #right-text {float:left;width:400px;text-align:left;}<\\/style>\\n\\t\\n\\t\\t<div id=\\"left-logo\\">\\n\\t\\t\\t<a target=\\"_blank\\" href=\\"http:\\/\\/dj-extensions.com\\"><img src=\\"..\\/administrator\\/components\\/com_djtabs\\/assets\\/logo.png\\" alt=\\"DJ-Extensions.com\\" \\/><\\/a>\\n\\t\\t<\\/div>\\n\\t\\t\\n\\t\\t<div id=\\"right-text\\">\\n\\t\\t\\t<h2>Thank you for installing DJ-Tabs!<\\/h2>\\n\\t\\t\\t<p><a href=\\"http:\\/\\/dj-extensions.com\\/changelog\\/dj-tabs\\/ver-1-3-4\\" target=\\"_blank\\">Check out changelog<\\/a><\\/p>\\n\\t\\t\\t<p>DJ-Tabs extension allows displaying grouped content including articles, multi-category articles, videos and modules from 3rd party extensions. \\n\\t\\t\\tAll of this on 2 different layouts and editable custom themes.<\\/p>\\n\\t\\t\\t<p>Check out our other extensions at <a target=\\"_blank\\" href=\\"http:\\/\\/dj-extensions.com\\">DJ-Extensions.com<\\/a><\\/p>\\n\\t\\t<\\/div>\\n\\t\\n\\t\\t","group":"","filename":"pkg_dj-tabs"}','{}','','','0','0000-00-00 00:00:00','0','0'),
('10001','0','plg_system_ef4_jmframework','plugin','ef4_jmframework','system','0','1','1','0','{"name":"plg_system_ef4_jmframework","type":"plugin","creationDate":"07\\/06\\/2017","author":"DJ-Extensions.com LTD","copyright":"Copyright (C) 2010-2017 DJ-Extensions.com LTD, All rights reserved.","authorEmail":"contact@dj-extensions.com","authorUrl":"http:\\/\\/dj-extensions.com","version":"4.7.8","description":"PLG_SYSTEM_JMFRAMEWORK_DESC","group":"","filename":"ef4_jmframework"}','','','','0','0000-00-00 00:00:00','0','0'),
('10021','10010','plg_djmediatools_djclassifieds','plugin','djclassifieds','djmediatools','0','0','1','0','{"name":"plg_djmediatools_djclassifieds","type":"plugin","creationDate":"August 2017","author":"DJ-Extensions.com","copyright":"Copyright (C) 2017 DJ-Extensions.com, All rights reserved.","authorEmail":"contact@dj-extensions.com","authorUrl":"http:\\/\\/dj-extensions.com","version":"2.1.4","description":"PLG_DJMEDIATOOLS_DJCLASSIFIEDS_DESCRIPTION","group":"","filename":"djclassifieds"}','{"plg_classifieds_items_source":"0","plg_classifieds_catid":"0","plg_classifieds_region_id":"0","plg_classifieds_type_id":"0","plg_classifieds_follow_category":"0","plg_classifieds_follow_region":"0","plg_classifieds_items_ids":"","plg_classifieds_users_ids":"","plg_classifieds_items_ord":"0","plg_classifieds_only_promoted":"0","plg_classifieds_show_date":"0","plg_classifieds_show_cat":"0","plg_classifieds_cat_link":"1","plg_classifieds_show_type":"0","plg_classifieds_show_region":"0","plg_classifieds_show_price":"0"}','','','0','0000-00-00 00:00:00','0','0'),
('10022','10010','plg_djmediatools_easyblog','plugin','easyblog','djmediatools','0','0','1','0','{"name":"plg_djmediatools_easyblog","type":"plugin","creationDate":"August 2017","author":"DJ-Extensions.com","copyright":"Copyright (C) 2017 DJ-Extensions.com, All rights reserved.","authorEmail":"contact@dj-extensions.com","authorUrl":"http:\\/\\/dj-extensions.com","version":"1.3.0","description":"PLG_DJMEDIATOOLS_EASYBLOG_DESCRIPTION","group":"","filename":"easyblog"}','{"plg_easyblog_catid":"all","plg_easyblog_includesubcategory":"0","plg_easyblog_usefeatured":"0","plg_easyblog_order":"latest","plg_easyblog_order_dir":"DESC"}','','','0','0000-00-00 00:00:00','0','0'),
('10023','10010','plg_djmediatools_hikashop','plugin','hikashop','djmediatools','0','0','1','0','{"name":"plg_djmediatools_hikashop","type":"plugin","creationDate":"August 2017","author":"DJ-Extensions.com","copyright":"Copyright (C) 2017 DJ-Extensions.com, All rights reserved.","authorEmail":"contact@dj-extensions.com","authorUrl":"http:\\/\\/dj-extensions.com","version":"1.1.0","description":"PLG_DJMEDIATOOLS_HIKASHOP_DESCRIPTION","group":"","filename":"hikashop"}','{"plg_hikashop_content_synchronize":"0;plg_hikashop_recently_viewed","plg_hikashop_product_synchronize":"0","plg_hikashop_recently_viewed":"0;plg_hikashop_selectparentlisting;plg_hikashop_filter_type","plg_hikashop_filter_type":"1","plg_hikashop_show_out_of_stock":"1","plg_hikashop_product_order":"ordering","plg_hikashop_order_dir":"ASC","plg_hikashop_itemid":"","plg_hikashop_add_to_cart":"1","plg_hikashop_show_quantity_field":"0","plg_hikashop_show_price":"1"}','','','0','0000-00-00 00:00:00','0','0'),
('10024','0','jm-cleaning-company','template','jm-cleaning-company','','0','1','1','0','{"name":"jm-cleaning-company","type":"template","creationDate":"06\\/05\\/2015","author":"joomla-monster.com","copyright":"Copyright (C) 2005 - 2015 Open Source Matters, Inc. All rights reserved.","authorEmail":"contact@joomla-monster.com","authorUrl":"joomla-monster.com","version":"1.04","description":"\\n\\t\\n\\t<div class=\\"jm-description clearfix\\">\\n\\t\\t<div class=\\"pull-left\\" style=\\"max-width: 35.69%;\\">\\n\\t\\t\\t<img style=\\"max-width: 100%; box-sizing: border-box; -webkit-box-sizing: border-box; padding: 10px; background: #fff; border: 1px solid #e1e1e1;\\" src=\\"http:\\/\\/www.joomla-monster.com\\/images\\/templates\\/jmcleaningcompany.png\\" \\/>\\n\\t\\t<\\/div>\\n\\t\\t<div class=\\"pull-left\\" style=\\"max-width: 64.31%; box-sizing: border-box; -webkit-box-sizing: border-box; padding: 0 30px;\\">\\n\\t\\t\\t<div style=\\"margin-bottom: 20px;\\">\\n\\t\\t\\t\\t<h2 style=\\"font-size: 33px; line-height: 40px; font-weight: 600; color: #393939; margin-top: 0;\\">JM Cleaning Company<\\/h2>\\n\\t\\t\\t\\t<span style=\\"color: #a0a0a0; display: block; margin-top: -10px;\\">Template version: 1.04<\\/span>\\n\\t\\t\\t\\t<div style=\\"margin: 20px 0 0;\\">\\n\\t\\t\\t\\t\\t<a style=\\"text-decoration: none !important; outline: none;\\" target=\\"_blank\\" href=\\"#\\">\\n\\t\\t\\t\\t\\t\\t<img src=\\"http:\\/\\/joomla-monster.com\\/images\\/templates\\/ef4.png\\" \\/>\\n\\t\\t\\t\\t\\t<\\/a>\\n\\t\\t\\t\\t\\t<a href=\\"http:\\/\\/www.joomla-monster.com\\/index.php?option=com_content&catid=137&id=897&view=article&Itemid=1027\\" target=\\"_blank\\" style=\\"margin: 0 20px; color: #3ea5ea;\\">Based on EF4 Framework<\\/a>\\n\\t\\t\\t\\t<\\/div>\\n\\t\\t\\t<\\/div>\\n\\t\\t\\t<div style=\\"margin-bottom: 20px;\\">\\n\\t\\t\\t\\t<a style=\\"text-decoration: none !important; display: block; outline: none;\\" target=\\"_blank\\" href=\\"http:\\/\\/www.joomla-monster.com\\/\\">\\n\\t\\t\\t\\t\\t<img src=\\"http:\\/\\/joomla-monster.com\\/images\\/templates\\/monster.png\\" \\/>\\n\\t\\t\\t\\t<\\/a>\\n\\t\\t\\t<\\/div>\\n\\t\\t\\t<div style=\\"margin: 0 -20px;\\">\\n\\t\\t\\t\\t<div style=\\"display: inline-block; margin: 0 20px 20px;\\">\\n\\t\\t\\t\\t\\t<span style=\\"display: block; color: #a0a0a0;\\">Templates for Joomla!<\\/span>\\n\\t\\t\\t\\t\\t<a style=\\"font-size: 15px; color: #3ea5ea;\\" target=\\"_blank\\" href=\\"http:\\/\\/www.joomla-monster.com\\">www.joomla-monster.com<\\/a>\\n\\t\\t\\t\\t<\\/div>\\n\\t\\t\\t\\t<div style=\\"display: inline-block; margin: 0 20px 20px;\\">\\n\\t\\t\\t\\t\\t<span style=\\"display: block; color: #a0a0a0;\\">Extensions for Joomla!<\\/span>\\n\\t\\t\\t\\t\\t<a style=\\"font-size: 15px; color: #3ea5ea;\\" target=\\"_blank\\" href=\\"http:\\/\\/www.dj-extensions.com\\">www.dj-extensions.com<\\/a>\\n\\t\\t\\t\\t<\\/div>\\n\\t\\t\\t\\t<div style=\\"display: inline-block; margin: 0 20px 20px;\\">\\n\\t\\t\\t\\t\\t<span style=\\"display: block; color: #a0a0a0;\\">Custom Joomla! Services<\\/span>\\n\\t\\t\\t\\t\\t<a style=\\"font-size: 15px; color: #3ea5ea;\\" target=\\"_blank\\" href=\\"http:\\/\\/www.design-joomla.eu\\">www.design-joomla.eu<\\/a>\\n\\t\\t\\t\\t<\\/div>\\n\\t\\t\\t<\\/div>\\n\\t\\t<\\/div>\\n\\t<\\/div>\\n\\t\\n\\t","group":"jmf-ef4","filename":"templateDetails"}','','','','0','0000-00-00 00:00:00','0','0'),
('801','0','pkg_weblinks','package','pkg_weblinks','','0','1','1','0','{"name":"pkg_weblinks","type":"package","creationDate":"2017-03-08","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.6.0","description":"PKG_WEBLINKS_XML_DESCRIPTION","group":"","filename":"pkg_weblinks"}','','','','0','0000-00-00 00:00:00','0','0'),
('10025','10010','plg_djmediatools_sobipro','plugin','sobipro','djmediatools','0','0','1','0','{"name":"plg_djmediatools_sobipro","type":"plugin","creationDate":"August 2017","author":"DJ-Extensions.com","copyright":"Copyright (C) 2017 DJ-Extensions.com, All rights reserved.","authorEmail":"contact@dj-extensions.com","authorUrl":"http:\\/\\/dj-extensions.com","version":"1.1.0","description":"PLG_DJMEDIATOOLS_SOBIPRO_DESCRIPTION","group":"","filename":"sobipro"}','{"plg_sobipro_autoListing":"0","spOrderDir":"asc"}','','','0','0000-00-00 00:00:00','0','0'),
('10026','10013','DJ-MegaMenu - Mobile Menu Button','module','mod_djmegamenu_button','','0','1','0','0','{"name":"DJ-MegaMenu - Mobile Menu Button","type":"module","creationDate":"August 2017","author":"DJ-Extensions.com","copyright":"Copyright (C) 2015 DJ-Extensions.com, All rights reserved.","authorEmail":"contact@dj-extensions.com","authorUrl":"http:\\/\\/dj-extensions.com","version":"1.0.1","description":"Place the Mobile Menu Button in any module position of your template.","group":"","filename":"mod_djmegamenu_button"}','{"module":""}','','','0','0000-00-00 00:00:00','0','0'),
('453','0','plg_editors-xtd_module','plugin','module','editors-xtd','0','1','1','0','{"name":"plg_editors-xtd_module","type":"plugin","creationDate":"October 2015","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.5.0","description":"PLG_MODULE_XML_DESCRIPTION","group":"","filename":"module"}','','','','0','0000-00-00 00:00:00','0','0'),
('452','0','plg_system_updatenotification','plugin','updatenotification','system','0','1','1','0','{"name":"plg_system_updatenotification","type":"plugin","creationDate":"May 2015","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.5.0","description":"PLG_SYSTEM_UPDATENOTIFICATION_XML_DESCRIPTION","group":"","filename":"updatenotification"}','{"lastrun":1506335520}','','','0','0000-00-00 00:00:00','0','0'),
('454','0','plg_system_stats','plugin','stats','system','0','1','1','0','{"name":"plg_system_stats","type":"plugin","creationDate":"November 2013","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.5.0","description":"PLG_SYSTEM_STATS_XML_DESCRIPTION","group":"","filename":"stats"}','{"mode":3,"lastrun":"","unique_id":"de7e5153a3338fc85794ec08a9b084185b0e38e6","interval":12}','','','0','0000-00-00 00:00:00','0','0'),
('10002','0','plg_system_djjquerymonster','plugin','djjquerymonster','system','0','1','1','0','{"name":"plg_system_djjquerymonster","type":"plugin","creationDate":"July 2017","author":"DJ-Extensions.com","copyright":"Copyright (C) 2017 DJ-Extensions.com, All rights reserved.","authorEmail":"contact@dj-extensions.com","authorUrl":"http:\\/\\/dj-extensions.com","version":"1.3.4","description":"PLG_SYSTEM_DJJQUERYMONSTER_DESCRIPTION","group":"","filename":"djjquerymonster"}','{"jquery":"1","version":"joomla","customver":"","custompath":"","jqueryui":"1","uiversion":"1.9.2","customuiver":"","customuipath":"","uitheme":"base","uithemecustom":"","compression":"1","protocol":"none","protectscripts":"","remove_mootools":"0","remove_modal":"1","debug":"0"}','','','0','0000-00-00 00:00:00','-1','0'),
('10027','10010','plg_djmediatools_j2store','plugin','j2store','djmediatools','0','0','1','0','{"name":"plg_djmediatools_j2store","type":"plugin","creationDate":"August 2017","author":"DJ-Extensions.com","copyright":"Copyright (C) 2017 DJ-Extensions.com, All rights reserved.","authorEmail":"contact@dj-extensions.com","authorUrl":"http:\\/\\/dj-extensions.com","version":"1.0.1","description":"PLG_DJMEDIATOOLS_J2STORE_DESCRIPTION","group":"","filename":"j2store"}','{"plg_j2store_product_source":"category","plg_j2store_category_filtering_type":"1","plg_j2store_show_child_category_articles":"0","plg_j2store_levels":"1","plg_j2store_show_front":"show","plg_j2store_article_ordering":"a.title","plg_j2store_article_ordering_direction":"ASC","plg_j2store_show_price":"1","plg_j2store_show_cartbutton":"1","plg_j2store_show_qtyinput":"1","plg_j2store_list_show_cart":"1","plg_j2store_product_image":"j2store"}','','','0','0000-00-00 00:00:00','0','0'),
('10028','10010','PLG_DJMEDIATOOLS_DJCATALOG2GALLERY','plugin','djcatalog2gallery','djmediatools','0','0','1','0','{"name":"PLG_DJMEDIATOOLS_DJCATALOG2GALLERY","type":"plugin","creationDate":"August 2017","author":"DJ-Extensions.com","copyright":"Copyright (C) 2017 DJ-Extensions.com, All rights reserved.","authorEmail":"contact@dj-extensions.com","authorUrl":"http:\\/\\/dj-extensions.com","version":"1.0.0","description":"PLG_DJMEDIATOOLS_DJCATALOG2GALLERY_DESCRIPTION","group":"","filename":"djcatalog2gallery"}','{"plg_djcatalog2gallery_visible":"false"}','','','0','0000-00-00 00:00:00','0','0'),
('802','0','English (en-GB) Language Pack','package','pkg_en-GB','','0','1','1','1','{"name":"English (en-GB) Language Pack","type":"package","creationDate":"September 2017","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters, Inc. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.8.0.1","description":"en-GB language pack","group":"","filename":"pkg_en-GB"}','','','','0','0000-00-00 00:00:00','0','0'),
('458','0','plg_quickicon_phpversioncheck','plugin','phpversioncheck','quickicon','0','1','1','1','{"name":"plg_quickicon_phpversioncheck","type":"plugin","creationDate":"August 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_QUICKICON_PHPVERSIONCHECK_XML_DESCRIPTION","group":"","filename":"phpversioncheck"}','','','','0','0000-00-00 00:00:00','0','0'),
('459','0','plg_editors-xtd_menu','plugin','menu','editors-xtd','0','1','1','0','{"name":"plg_editors-xtd_menu","type":"plugin","creationDate":"August 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_EDITORS-XTD_MENU_XML_DESCRIPTION","group":"","filename":"menu"}','','','','0','0000-00-00 00:00:00','0','0'),
('33','0','com_fields','component','com_fields','','1','1','1','0','{"name":"com_fields","type":"component","creationDate":"March 2016","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"COM_FIELDS_XML_DESCRIPTION","group":"","filename":"fields"}','','','','0','0000-00-00 00:00:00','0','0'),
('461','0','plg_system_fields','plugin','fields','system','0','1','1','0','{"name":"plg_system_fields","type":"plugin","creationDate":"March 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_SYSTEM_FIELDS_XML_DESCRIPTION","group":"","filename":"fields"}','','','','0','0000-00-00 00:00:00','0','0'),
('462','0','plg_fields_calendar','plugin','calendar','fields','0','1','1','0','{"name":"plg_fields_calendar","type":"plugin","creationDate":"March 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_FIELDS_CALENDAR_XML_DESCRIPTION","group":"","filename":"calendar"}','','','','0','0000-00-00 00:00:00','0','0'),
('463','0','plg_fields_checkboxes','plugin','checkboxes','fields','0','1','1','0','{"name":"plg_fields_checkboxes","type":"plugin","creationDate":"March 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_FIELDS_CHECKBOXES_XML_DESCRIPTION","group":"","filename":"checkboxes"}','','','','0','0000-00-00 00:00:00','0','0'),
('464','0','plg_fields_color','plugin','color','fields','0','1','1','0','{"name":"plg_fields_color","type":"plugin","creationDate":"March 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_FIELDS_COLOR_XML_DESCRIPTION","group":"","filename":"color"}','','','','0','0000-00-00 00:00:00','0','0'),
('465','0','plg_fields_editor','plugin','editor','fields','0','1','1','0','{"name":"plg_fields_editor","type":"plugin","creationDate":"March 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_FIELDS_EDITOR_XML_DESCRIPTION","group":"","filename":"editor"}','','','','0','0000-00-00 00:00:00','0','0'),
('466','0','plg_fields_imagelist','plugin','imagelist','fields','0','1','1','0','{"name":"plg_fields_imagelist","type":"plugin","creationDate":"March 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_FIELDS_IMAGELIST_XML_DESCRIPTION","group":"","filename":"imagelist"}','','','','0','0000-00-00 00:00:00','0','0'),
('467','0','plg_fields_integer','plugin','integer','fields','0','1','1','0','{"name":"plg_fields_integer","type":"plugin","creationDate":"March 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_FIELDS_INTEGER_XML_DESCRIPTION","group":"","filename":"integer"}','{"multiple":"0","first":"1","last":"100","step":"1"}','','','0','0000-00-00 00:00:00','0','0'),
('468','0','plg_fields_list','plugin','list','fields','0','1','1','0','{"name":"plg_fields_list","type":"plugin","creationDate":"March 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_FIELDS_LIST_XML_DESCRIPTION","group":"","filename":"list"}','','','','0','0000-00-00 00:00:00','0','0'),
('469','0','plg_fields_media','plugin','media','fields','0','1','1','0','{"name":"plg_fields_media","type":"plugin","creationDate":"March 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_FIELDS_MEDIA_XML_DESCRIPTION","group":"","filename":"media"}','','','','0','0000-00-00 00:00:00','0','0'),
('470','0','plg_fields_radio','plugin','radio','fields','0','1','1','0','{"name":"plg_fields_radio","type":"plugin","creationDate":"March 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_FIELDS_RADIO_XML_DESCRIPTION","group":"","filename":"radio"}','','','','0','0000-00-00 00:00:00','0','0'),
('471','0','plg_fields_sql','plugin','sql','fields','0','1','1','0','{"name":"plg_fields_sql","type":"plugin","creationDate":"March 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_FIELDS_SQL_XML_DESCRIPTION","group":"","filename":"sql"}','','','','0','0000-00-00 00:00:00','0','0'),
('472','0','plg_fields_text','plugin','text','fields','0','1','1','0','{"name":"plg_fields_text","type":"plugin","creationDate":"March 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_FIELDS_TEXT_XML_DESCRIPTION","group":"","filename":"text"}','','','','0','0000-00-00 00:00:00','0','0'),
('473','0','plg_fields_textarea','plugin','textarea','fields','0','1','1','0','{"name":"plg_fields_textarea","type":"plugin","creationDate":"March 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_FIELDS_TEXTAREA_XML_DESCRIPTION","group":"","filename":"textarea"}','','','','0','0000-00-00 00:00:00','0','0'),
('474','0','plg_fields_url','plugin','url','fields','0','1','1','0','{"name":"plg_fields_url","type":"plugin","creationDate":"March 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_FIELDS_URL_XML_DESCRIPTION","group":"","filename":"url"}','','','','0','0000-00-00 00:00:00','0','0'),
('475','0','plg_fields_user','plugin','user','fields','0','1','1','0','{"name":"plg_fields_user","type":"plugin","creationDate":"March 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_FIELDS_USER_XML_DESCRIPTION","group":"","filename":"user"}','','','','0','0000-00-00 00:00:00','0','0'),
('476','0','plg_fields_usergrouplist','plugin','usergrouplist','fields','0','1','1','0','{"name":"plg_fields_usergrouplist","type":"plugin","creationDate":"March 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_FIELDS_USERGROUPLIST_XML_DESCRIPTION","group":"","filename":"usergrouplist"}','','','','0','0000-00-00 00:00:00','0','0'),
('460','0','plg_editors-xtd_contact','plugin','contact','editors-xtd','0','1','1','0','{"name":"plg_editors-xtd_contact","type":"plugin","creationDate":"October 2016","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_EDITORS-XTD_CONTACT_XML_DESCRIPTION","group":"","filename":"contact"}','','','','0','0000-00-00 00:00:00','0','0'),
('34','0','com_associations','component','com_associations','','1','1','1','0','{"name":"com_associations","type":"component","creationDate":"Januar 2017","author":"Joomla! Project","copyright":"(C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"COM_ASSOCIATIONS_XML_DESCRIPTION","group":""}','','','','0','0000-00-00 00:00:00','0','0'),
('477','0','plg_content_fields','plugin','fields','content','0','1','1','0','{"name":"plg_content_fields","type":"plugin","creationDate":"February 2017","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_CONTENT_FIELDS_XML_DESCRIPTION","group":"","filename":"fields"}','','','','0','0000-00-00 00:00:00','0','0'),
('478','0','plg_editors-xtd_fields','plugin','fields','editors-xtd','0','1','1','0','{"name":"plg_editors-xtd_fields","type":"plugin","creationDate":"February 2017","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.7.0","description":"PLG_EDITORS-XTD_FIELDS_XML_DESCRIPTION","group":"","filename":"fields"}','','','','0','0000-00-00 00:00:00','0','0'),
('318','0','mod_sampledata','module','mod_sampledata','','1','0','1','0','{"name":"mod_sampledata","type":"module","creationDate":"July 2017","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.8.0","description":"MOD_SAMPLEDATA_XML_DESCRIPTION","group":"","filename":"mod_sampledata"}','{}','','','0','0000-00-00 00:00:00','0','0'),
('479','0','plg_sampledata_blog','plugin','blog','sampledata','0','0','1','0','{"name":"plg_sampledata_blog","type":"plugin","creationDate":"July 2017","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.8.0","description":"PLG_SAMPLEDATA_BLOG_XML_DESCRIPTION","group":"","filename":"blog"}','','','','0','0000-00-00 00:00:00','0','0'),
('10029','10010','PLG_DJMEDIATOOLS_DJCLASSIFIEDSGALLERY','plugin','djclassifiedsgallery','djmediatools','0','0','1','0','{"name":"PLG_DJMEDIATOOLS_DJCLASSIFIEDSGALLERY","type":"plugin","creationDate":"August 2017","author":"DJ-Extensions.com","copyright":"Copyright (C) 2017 DJ-Extensions.com, All rights reserved.","authorEmail":"contact@dj-extensions.com","authorUrl":"http:\\/\\/dj-extensions.com","version":"1.0.5","description":"PLG_DJMEDIATOOLS_DJCLASSIFIEDSGALLERY_DESCRIPTION","group":"","filename":"djclassifiedsgallery"}','{"plg_djclassifiedsgallery_visible":"false"}','','','0','0000-00-00 00:00:00','0','0'),
('10030','10010','plg_djmediatools_djevents','plugin','djevents','djmediatools','0','0','1','0','{"name":"plg_djmediatools_djevents","type":"plugin","creationDate":"August 2017","author":"DJ-Extensions.com","copyright":"Copyright (C) 2017 DJ-Extensions.com, All rights reserved.","authorEmail":"contact@dj-extensions.com","authorUrl":"http:\\/\\/dj-extensions.com","version":"1.0.0","description":"PLG_DJMEDIATOOLS_DJEVENTS_DESCRIPTION","group":"","filename":"djevents"}','{"plg_djevents_featured_only":"0","plg_djevents_show_date":"1","plg_djevents_show_cat":"0","plg_djevents_cat_link":"1","plg_djevents_show_city":"0"}','','','0','0000-00-00 00:00:00','0','0');

DROP TABLE IF EXISTS #__fields;
CREATE TABLE `#__fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) unsigned NOT NULL DEFAULT '0',
  `context` varchar(255) NOT NULL DEFAULT '',
  `group_id` int(10) unsigned NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `name` varchar(255) NOT NULL DEFAULT '',
  `label` varchar(255) NOT NULL DEFAULT '',
  `default_value` text NOT NULL,
  `type` varchar(255) NOT NULL DEFAULT 'text',
  `note` varchar(255) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `state` tinyint(1) NOT NULL DEFAULT '0',
  `required` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(11) NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `params` text NOT NULL,
  `fieldparams` text NOT NULL,
  `language` char(7) NOT NULL DEFAULT '',
  `created_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `modified_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT '0',
  `access` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`state`),
  KEY `idx_created_user_id` (`created_user_id`),
  KEY `idx_access` (`access`),
  KEY `idx_context` (`context`(191)),
  KEY `idx_language` (`language`)
) DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS #__fields_categories;
CREATE TABLE `#__fields_categories` (
  `field_id` int(11) NOT NULL DEFAULT '0',
  `category_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`field_id`,`category_id`)
) DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS #__fields_groups;
CREATE TABLE `#__fields_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) unsigned NOT NULL DEFAULT '0',
  `context` varchar(255) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `note` varchar(255) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `state` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(11) NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `params` text NOT NULL,
  `language` char(7) NOT NULL DEFAULT '',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT '0',
  `access` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`state`),
  KEY `idx_created_by` (`created_by`),
  KEY `idx_access` (`access`),
  KEY `idx_context` (`context`(191)),
  KEY `idx_language` (`language`)
) DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS #__fields_values;
CREATE TABLE `#__fields_values` (
  `field_id` int(10) unsigned NOT NULL,
  `item_id` varchar(255) NOT NULL COMMENT 'Allow references to items which have strings as ids, eg. none db systems.',
  `value` text NOT NULL,
  KEY `idx_field_id` (`field_id`),
  KEY `idx_item_id` (`item_id`(191))
) DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS #__finder_filters;
CREATE TABLE `#__finder_filters` (
  `filter_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `alias` varchar(255) NOT NULL,
  `state` tinyint(1) NOT NULL DEFAULT '1',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) unsigned NOT NULL,
  `created_by_alias` varchar(255) NOT NULL,
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `map_count` int(10) unsigned NOT NULL DEFAULT '0',
  `data` mediumtext NOT NULL,
  `params` longtext,
  PRIMARY KEY (`filter_id`)
) DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS #__finder_links;
CREATE TABLE `#__finder_links` (
  `link_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) NOT NULL,
  `route` varchar(255) NOT NULL,
  `title` varchar(400) DEFAULT NULL,
  `description` text,
  `indexdate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `md5sum` varchar(32) DEFAULT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '1',
  `state` int(5) DEFAULT '1',
  `access` int(5) DEFAULT '0',
  `language` varchar(8) NOT NULL,
  `publish_start_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_end_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `start_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `end_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `list_price` double unsigned NOT NULL DEFAULT '0',
  `sale_price` double unsigned NOT NULL DEFAULT '0',
  `type_id` int(11) NOT NULL,
  `object` mediumblob NOT NULL,
  PRIMARY KEY (`link_id`),
  KEY `idx_type` (`type_id`),
  KEY `idx_md5` (`md5sum`),
  KEY `idx_url` (`url`(75)),
  KEY `idx_published_list` (`published`,`state`,`access`,`publish_start_date`,`publish_end_date`,`list_price`),
  KEY `idx_published_sale` (`published`,`state`,`access`,`publish_start_date`,`publish_end_date`,`sale_price`),
  KEY `idx_title` (`title`(100))
) DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS #__finder_links_terms0;
CREATE TABLE `#__finder_links_terms0` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS #__finder_links_terms1;
CREATE TABLE `#__finder_links_terms1` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS #__finder_links_terms2;
CREATE TABLE `#__finder_links_terms2` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS #__finder_links_terms3;
CREATE TABLE `#__finder_links_terms3` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS #__finder_links_terms4;
CREATE TABLE `#__finder_links_terms4` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS #__finder_links_terms5;
CREATE TABLE `#__finder_links_terms5` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS #__finder_links_terms6;
CREATE TABLE `#__finder_links_terms6` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS #__finder_links_terms7;
CREATE TABLE `#__finder_links_terms7` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS #__finder_links_terms8;
CREATE TABLE `#__finder_links_terms8` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS #__finder_links_terms9;
CREATE TABLE `#__finder_links_terms9` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS #__finder_links_termsa;
CREATE TABLE `#__finder_links_termsa` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS #__finder_links_termsb;
CREATE TABLE `#__finder_links_termsb` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS #__finder_links_termsc;
CREATE TABLE `#__finder_links_termsc` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS #__finder_links_termsd;
CREATE TABLE `#__finder_links_termsd` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS #__finder_links_termse;
CREATE TABLE `#__finder_links_termse` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS #__finder_links_termsf;
CREATE TABLE `#__finder_links_termsf` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS #__finder_taxonomy;
CREATE TABLE `#__finder_taxonomy` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL,
  `state` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `access` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `ordering` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `parent_id` (`parent_id`),
  KEY `state` (`state`),
  KEY `ordering` (`ordering`),
  KEY `access` (`access`),
  KEY `idx_parent_published` (`parent_id`,`state`,`access`)
) DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS #__finder_taxonomy_map;
CREATE TABLE `#__finder_taxonomy_map` (
  `link_id` int(10) unsigned NOT NULL,
  `node_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`node_id`),
  KEY `link_id` (`link_id`),
  KEY `node_id` (`node_id`)
) DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS #__finder_terms;
CREATE TABLE `#__finder_terms` (
  `term_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `term` varchar(75) NOT NULL,
  `stem` varchar(75) NOT NULL,
  `common` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `phrase` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `weight` float unsigned NOT NULL DEFAULT '0',
  `soundex` varchar(75) NOT NULL,
  `links` int(10) NOT NULL DEFAULT '0',
  `language` char(3) NOT NULL DEFAULT '',
  PRIMARY KEY (`term_id`),
  UNIQUE KEY `idx_term` (`term`),
  KEY `idx_term_phrase` (`term`,`phrase`),
  KEY `idx_stem_phrase` (`stem`,`phrase`),
  KEY `idx_soundex_phrase` (`soundex`,`phrase`)
) DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS #__finder_terms_common;
CREATE TABLE `#__finder_terms_common` (
  `term` varchar(75) NOT NULL,
  `language` varchar(3) NOT NULL,
  KEY `idx_word_lang` (`term`,`language`),
  KEY `idx_lang` (`language`)
) DEFAULT CHARSET=utf8;

INSERT INTO `#__finder_terms_common` VALUES 
('a','en'),
('about','en'),
('after','en'),
('ago','en'),
('all','en'),
('am','en'),
('an','en'),
('and','en'),
('ani','en'),
('any','en'),
('are','en'),
('aren\'t','en'),
('as','en'),
('at','en'),
('be','en'),
('but','en'),
('by','en'),
('for','en'),
('from','en'),
('get','en'),
('go','en'),
('how','en'),
('if','en'),
('in','en'),
('into','en'),
('is','en'),
('isn\'t','en'),
('it','en'),
('its','en'),
('me','en'),
('more','en'),
('most','en'),
('must','en'),
('my','en'),
('new','en'),
('no','en'),
('none','en'),
('not','en'),
('noth','en'),
('nothing','en'),
('of','en'),
('off','en'),
('often','en'),
('old','en'),
('on','en'),
('onc','en'),
('once','en'),
('onli','en'),
('only','en'),
('or','en');
INSERT INTO `#__finder_terms_common` VALUES 
('other','en'),
('our','en'),
('ours','en'),
('out','en'),
('over','en'),
('page','en'),
('she','en'),
('should','en'),
('small','en'),
('so','en'),
('some','en'),
('than','en'),
('thank','en'),
('that','en'),
('the','en'),
('their','en'),
('theirs','en'),
('them','en'),
('then','en'),
('there','en'),
('these','en'),
('they','en'),
('this','en'),
('those','en'),
('thus','en'),
('time','en'),
('times','en'),
('to','en'),
('too','en'),
('true','en'),
('under','en'),
('until','en'),
('up','en'),
('upon','en'),
('use','en'),
('user','en'),
('users','en'),
('veri','en'),
('version','en'),
('very','en'),
('via','en'),
('want','en'),
('was','en'),
('way','en'),
('were','en'),
('what','en'),
('when','en'),
('where','en'),
('whi','en'),
('which','en');
INSERT INTO `#__finder_terms_common` VALUES 
('who','en'),
('whom','en'),
('whose','en'),
('why','en'),
('wide','en'),
('will','en'),
('with','en'),
('within','en'),
('without','en'),
('would','en'),
('yes','en'),
('yet','en'),
('you','en'),
('your','en'),
('yours','en');

DROP TABLE IF EXISTS #__finder_tokens;
CREATE TABLE `#__finder_tokens` (
  `term` varchar(75) NOT NULL,
  `stem` varchar(75) NOT NULL,
  `common` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `phrase` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `weight` float unsigned NOT NULL DEFAULT '1',
  `context` tinyint(1) unsigned NOT NULL DEFAULT '2',
  `language` char(3) NOT NULL DEFAULT '',
  KEY `idx_word` (`term`),
  KEY `idx_context` (`context`)
) DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS #__finder_tokens_aggregate;
CREATE TABLE `#__finder_tokens_aggregate` (
  `term_id` int(10) unsigned NOT NULL,
  `map_suffix` char(1) NOT NULL,
  `term` varchar(75) NOT NULL,
  `stem` varchar(75) NOT NULL,
  `common` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `phrase` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `term_weight` float unsigned NOT NULL,
  `context` tinyint(1) unsigned NOT NULL DEFAULT '2',
  `context_weight` float unsigned NOT NULL,
  `total_weight` float unsigned NOT NULL,
  `language` char(3) NOT NULL DEFAULT '',
  KEY `token` (`term`),
  KEY `keyword_id` (`term_id`)
) DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS #__finder_types;
CREATE TABLE `#__finder_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL,
  `mime` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `title` (`title`)
) AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

INSERT INTO `#__finder_types` VALUES 
('1','Category',''),
('2','Contact',''),
('3','Article',''),
('4','News Feed',''),
('5','Web Link','');

DROP TABLE IF EXISTS #__languages;
CREATE TABLE `#__languages` (
  `lang_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) unsigned NOT NULL DEFAULT '0',
  `lang_code` char(7) NOT NULL,
  `title` varchar(50) NOT NULL,
  `title_native` varchar(50) NOT NULL,
  `sef` varchar(50) NOT NULL,
  `image` varchar(50) NOT NULL,
  `description` varchar(512) NOT NULL,
  `metakey` mediumtext NOT NULL,
  `metadesc` mediumtext NOT NULL,
  `sitename` varchar(1024) NOT NULL DEFAULT '',
  `published` int(11) NOT NULL DEFAULT '0',
  `access` int(10) unsigned NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`lang_id`),
  UNIQUE KEY `idx_sef` (`sef`),
  UNIQUE KEY `idx_langcode` (`lang_code`),
  KEY `idx_access` (`access`),
  KEY `idx_ordering` (`ordering`)
) AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `#__languages` VALUES 
('1','0','en-GB','English (UK)','English (UK)','en','en','','','','','1','0','1');

DROP TABLE IF EXISTS #__menu;
CREATE TABLE `#__menu` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `menutype` varchar(24) NOT NULL COMMENT 'The type of menu this item belongs to. FK to #__menu_types.menutype',
  `title` varchar(255) NOT NULL COMMENT 'The display title of the menu item.',
  `alias` varchar(400) NOT NULL COMMENT 'The SEF alias of the menu item.',
  `note` varchar(255) NOT NULL DEFAULT '',
  `path` varchar(1024) NOT NULL COMMENT 'The computed path of the menu item based on the alias field.',
  `link` varchar(1024) NOT NULL COMMENT 'The actually link the menu item refers to.',
  `type` varchar(16) NOT NULL COMMENT 'The type of link: Component, URL, Alias, Separator',
  `published` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'The published state of the menu link.',
  `parent_id` int(10) unsigned NOT NULL DEFAULT '1' COMMENT 'The parent menu item in the menu tree.',
  `level` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The relative level in the tree.',
  `component_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to #__extensions.id',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to #__users.id',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT 'The time the menu item was checked out.',
  `browserNav` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'The click behaviour of the link.',
  `access` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The access level required to view the menu item.',
  `img` varchar(255) NOT NULL COMMENT 'The image of the menu item.',
  `template_style_id` int(10) unsigned NOT NULL DEFAULT '0',
  `params` mediumtext NOT NULL COMMENT 'JSON encoded data for the menu item.',
  `lft` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set lft.',
  `rgt` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set rgt.',
  `home` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Indicates if this menu item is the home or default page.',
  `language` char(7) NOT NULL DEFAULT '',
  `client_id` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_client_id_parent_id_alias_language` (`client_id`,`parent_id`,`alias`(100),`language`),
  KEY `idx_componentid` (`component_id`,`menutype`,`published`,`access`),
  KEY `idx_menutype` (`menutype`),
  KEY `idx_left_right` (`lft`,`rgt`),
  KEY `idx_language` (`language`),
  KEY `idx_alias` (`alias`(100)),
  KEY `idx_path` (`path`(100))
) AUTO_INCREMENT=779 DEFAULT CHARSET=utf8;

INSERT INTO `#__menu` VALUES 
('1','','Menu_Item_Root','root','','','','','1','0','0','0','0','0000-00-00 00:00:00','0','0','','0','','0','213','0','*','0'),
('2','main','com_banners','Banners','','Banners','index.php?option=com_banners','component','1','1','1','4','0','0000-00-00 00:00:00','0','0','class:banners','0','','75','84','0','*','1'),
('3','main','com_banners','Banners','','Banners/Banners','index.php?option=com_banners','component','1','2','2','4','0','0000-00-00 00:00:00','0','0','class:banners','0','','76','77','0','*','1'),
('4','main','com_banners_categories','Categories','','Banners/Categories','index.php?option=com_categories&extension=com_banners','component','1','2','2','6','0','0000-00-00 00:00:00','0','0','class:banners-cat','0','','78','79','0','*','1'),
('5','main','com_banners_clients','Clients','','Banners/Clients','index.php?option=com_banners&view=clients','component','1','2','2','4','0','0000-00-00 00:00:00','0','0','class:banners-clients','0','','80','81','0','*','1'),
('6','main','com_banners_tracks','Tracks','','Banners/Tracks','index.php?option=com_banners&view=tracks','component','1','2','2','4','0','0000-00-00 00:00:00','0','0','class:banners-tracks','0','','82','83','0','*','1'),
('7','main','com_contact','Contacts','','Contacts','index.php?option=com_contact','component','1','1','1','8','0','0000-00-00 00:00:00','0','0','class:contact','0','','85','90','0','*','1'),
('8','main','com_contact_contacts','Contacts','','Contacts/Contacts','index.php?option=com_contact','component','1','7','2','8','0','0000-00-00 00:00:00','0','0','class:contact','0','','86','87','0','*','1'),
('9','main','com_contact_categories','Categories','','Contacts/Categories','index.php?option=com_categories&extension=com_contact','component','1','7','2','6','0','0000-00-00 00:00:00','0','0','class:contact-cat','0','','88','89','0','*','1'),
('10','main','com_messages','Messaging','','Messaging','index.php?option=com_messages','component','1','1','1','15','0','0000-00-00 00:00:00','0','0','class:messages','0','','91','94','0','*','1'),
('11','main','com_messages_add','New Private Message','','Messaging/New Private Message','index.php?option=com_messages&task=message.add','component','1','10','2','15','0','0000-00-00 00:00:00','0','0','class:messages-add','0','','92','93','0','*','1'),
('13','main','com_newsfeeds','News Feeds','','News Feeds','index.php?option=com_newsfeeds','component','1','1','1','17','0','0000-00-00 00:00:00','0','0','class:newsfeeds','0','','95','100','0','*','1'),
('14','main','com_newsfeeds_feeds','Feeds','','News Feeds/Feeds','index.php?option=com_newsfeeds','component','1','13','2','17','0','0000-00-00 00:00:00','0','0','class:newsfeeds','0','','96','97','0','*','1'),
('15','main','com_newsfeeds_categories','Categories','','News Feeds/Categories','index.php?option=com_categories&extension=com_newsfeeds','component','1','13','2','6','0','0000-00-00 00:00:00','0','0','class:newsfeeds-cat','0','','98','99','0','*','1'),
('16','main','com_redirect','Redirect','','Redirect','index.php?option=com_redirect','component','1','1','1','24','0','0000-00-00 00:00:00','0','0','class:redirect','0','','105','106','0','*','1'),
('17','main','com_search','Basic Search','','Basic Search','index.php?option=com_search','component','1','1','1','19','0','0000-00-00 00:00:00','0','0','class:search','0','','103','104','0','*','1'),
('778','main','com_weblinks_categories','com-weblinks-categories','','com-weblinks/com-weblinks-categories','index.php?option=com_categories&extension=com_weblinks','component','1','776','2','21','0','0000-00-00 00:00:00','0','1','class:weblinks-cat','0','{}','210','211','0','','1'),
('777','main','com_weblinks_links','com-weblinks-links','','com-weblinks/com-weblinks-links','index.php?option=com_weblinks','component','1','776','2','21','0','0000-00-00 00:00:00','0','1','class:weblinks','0','{}','208','209','0','','1'),
('776','main','com_weblinks','com-weblinks','','com-weblinks','index.php?option=com_weblinks','component','1','1','1','21','0','0000-00-00 00:00:00','0','1','class:weblinks','0','{}','207','212','0','','1'),
('21','main','com_finder','Smart Search','','Smart Search','index.php?option=com_finder','component','1','1','1','27','0','0000-00-00 00:00:00','0','0','class:finder','0','','101','102','0','*','1'),
('760','main','com_joomlaupdate','com-joomlaupdate','','com-joomlaupdate','index.php?option=com_joomlaupdate','component','1','1','1','28','0','0000-00-00 00:00:00','0','1','class:joomlaupdate','0','{}','189','190','0','','1'),
('23','main','com_tags','Tags','','Tags','index.php?option=com_tags','component','1','1','1','29','0','0000-00-00 00:00:00','0','1','class:tags','0','','73','74','0','','1'),
('470','mainmenu','Home','home-page','check more','home-page','index.php?option=com_content&view=article&id=86','component','1','1','1','22','0','0000-00-00 00:00:00','0','1','','0','{"show_title":"","link_titles":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_tags":"","show_noauth":"","urls_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":"0","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"djmegamenu-show":"","djmegamenu-subtitle":"","djmegamenu-fa":"","djmegamenu-column_break":"0","djmegamenu-column_width":"","djmegamenu-expand":"","djmegamenu-dropdown_dir":"","djmegamenu-bg_image":"","djmegamenu-bg_pos_hor":"right","djmegamenu-bg_pos_ver":"bottom","djmegamenu-module_pos":"","djmegamenu-module_style":"0","djmegamenu-module_show_link":"0","djmobilemenu-module_pos":"","djmobilemenu-module_style":"System-xhtml","djmobilemenu-module_show_link":"0","djmegamenu-accesskey":""}','3','10','1','*','0'),
('472','mainmenu','RTL Languages','rtl-languages','ltr & rtl','rtl-languages','','separator','1','1','1','0','0','0000-00-00 00:00:00','0','1','','0','{"menu_image":"","menu_text":1,"djmegamenu-subtitle":"","djmegamenu-submenu_expand":"","djmegamenu-column_break":"0","djmegamenu-column_width":"","djmegamenu-module_pos":"","djmegamenu-module_style":"xhtml","djmegamenu-module_show_link":"0"}','61','66','0','*','0'),
('473','mainmenu','LTR Languages','2013-02-20-08-51-51','','rtl-languages/2013-02-20-08-51-51','?direction=ltr','url','1','472','2','0','0','0000-00-00 00:00:00','0','1','','0','{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1}','62','63','0','*','0'),
('474','mainmenu','RTL Languages','2013-02-20-08-52-13','','rtl-languages/2013-02-20-08-52-13','?direction=rtl','url','1','472','2','0','0','0000-00-00 00:00:00','0','1','','0','{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1}','64','65','0','*','0'),
('475','mainmenu','Template Features','2013-02-20-08-59-23','important info','2013-02-20-08-59-23','https://www.joomla-monster.com/knowledge-base-area/templates-documentation/general-info-ef4-framework-for-joomla-3-x/framework-ver-ef4','url','1','1','1','0','0','0000-00-00 00:00:00','1','1','','0','{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"djmegamenu-subtitle":"","djmegamenu-submenu_expand":"","djmegamenu-column_break":"0","djmegamenu-column_width":"","djmegamenu-module_pos":"","djmegamenu-module_style":"xhtml","djmegamenu-module_show_link":"0"}','25','40','0','*','0'),
('476','mainmenu','Template Parameters','2013-02-20-09-01-36','','2013-02-20-08-59-23/2013-02-20-09-01-36','https://www.joomla-monster.com/knowledge-base-area/templates-documentation/general-info-ef4-framework-for-joomla-3-x/framework-ver-ef4','url','1','475','2','0','0','0000-00-00 00:00:00','1','1','','0','{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"djmegamenu-subtitle":"","djmegamenu-submenu_expand":"","djmegamenu-column_break":"0","djmegamenu-column_width":"","djmegamenu-module_pos":"","djmegamenu-module_style":"xhtml","djmegamenu-module_show_link":"0"}','26','27','0','*','0'),
('477','mainmenu','All Template\'s Positions','positions','','2013-02-20-08-59-23/positions','index.php?option=com_content&view=article&id=84','component','1','475','2','22','0','0000-00-00 00:00:00','0','1','','0','{"show_title":"","link_titles":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_tags":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","urls_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"djmegamenu-subtitle":"","djmegamenu-submenu_expand":"","djmegamenu-column_break":"0","djmegamenu-column_width":"","djmegamenu-module_pos":"","djmegamenu-module_style":"xhtml","djmegamenu-module_show_link":"0"}','28','29','0','*','0'),
('478','mainmenu','Module Suffixes','suffixes','','2013-02-20-08-59-23/suffixes','index.php?option=com_content&view=article&id=85','component','1','475','2','22','0','0000-00-00 00:00:00','0','1','','0','{"show_title":"","link_titles":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_tags":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","urls_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"djmegamenu-subtitle":"","djmegamenu-submenu_expand":"","djmegamenu-column_break":"0","djmegamenu-column_width":"","djmegamenu-module_pos":"","djmegamenu-module_style":"xhtml","djmegamenu-module_show_link":"0"}','30','31','0','*','0'),
('479','mainmenu','Typography','typography','','2013-02-20-08-59-23/typography','index.php?option=com_content&view=article&id=71','component','1','475','2','22','0','0000-00-00 00:00:00','0','1','','0','{"show_title":"","link_titles":"","show_intro":"","info_block_position":"","show_category":"0","link_category":"","show_parent_category":"0","link_parent_category":"","show_author":"0","link_author":"","show_create_date":"0","show_modify_date":"0","show_publish_date":"0","show_item_navigation":"0","show_vote":"0","show_tags":"","show_icons":"0","show_print_icon":"0","show_email_icon":"0","show_hits":"0","show_noauth":"","urls_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"djmegamenu-subtitle":"","djmegamenu-submenu_expand":"","djmegamenu-column_break":"0","djmegamenu-column_width":"","djmegamenu-module_pos":"","djmegamenu-module_style":"xhtml","djmegamenu-module_show_link":"0"}','32','33','0','*','0'),
('480','mainmenu','Install Demo Copy','2013-02-20-09-07-12','','2013-02-20-08-59-23/2013-02-20-09-07-12','http://www.joomla-monster.com/knowledge-base-area/general-questions/regarding-our-store/what-is-a-quickstart','url','1','475','2','0','0','0000-00-00 00:00:00','1','1','','0','{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1}','34','35','0','*','0'),
('481','mainmenu','What You Get After Purchase?','2013-02-20-09-09-57','','2013-02-20-08-59-23/2013-02-20-09-09-57','http://www.joomla-monster.com/knowledge-base-area/general-questions/regarding-our-store/description-of-the-download-area','url','1','475','2','0','0','0000-00-00 00:00:00','1','1','','0','{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1}','36','37','0','*','0'),
('482','mainmenu','Joomla Templates','2013-02-20-09-11-02','','2013-02-20-08-59-23/2013-02-20-09-11-02','http://www.joomla-monster.com/all-templates','url','1','475','2','0','0','0000-00-00 00:00:00','1','1','','0','{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1}','38','39','0','*','0'),
('484','mainmenu','Column 1','column-1','','home-page/column-1','','separator','1','470','2','0','0','0000-00-00 00:00:00','0','1','','0','{"menu_image":"","menu_text":1,"djmegamenu-subtitle":"","djmegamenu-submenu_expand":"","djmegamenu-column_break":"1","djmegamenu-column_width":"220","djmegamenu-module_pos":"dj-mega-home0","djmegamenu-module_style":"xhtml","djmegamenu-module_show_link":"0"}','4','5','0','*','0'),
('487','mainmenu','Extensions','extensions','check views','extensions','','separator','1','1','1','0','0','0000-00-00 00:00:00','0','1','','0','{"menu_image":"","menu_text":1,"djmegamenu-subtitle":"","djmegamenu-submenu_expand":"","djmegamenu-column_break":"0","djmegamenu-column_width":"","djmegamenu-module_pos":"","djmegamenu-module_style":"xhtml","djmegamenu-module_show_link":"0"}','55','60','0','*','0'),
('488','mainmenu','DJ-Tabs','dj-tabs','','extensions/dj-tabs','','separator','1','487','2','0','0','0000-00-00 00:00:00','0','1','','0','{"menu_image":"","menu_text":1,"djmegamenu-subtitle":"","djmegamenu-submenu_expand":"","djmegamenu-column_break":"1","djmegamenu-column_width":"","djmegamenu-module_pos":"dj-mega-extensions1","djmegamenu-module_style":"xhtml","djmegamenu-module_show_link":"0"}','58','59','0','*','0'),
('496','mainmenu','DJ-MediaTools','dj-mediatools','','extensions/dj-mediatools','','separator','1','487','2','0','0','0000-00-00 00:00:00','0','1','','0','{"menu_image":"","menu_text":1,"djmegamenu-subtitle":"","djmegamenu-submenu_expand":"","djmegamenu-column_break":"1","djmegamenu-column_width":"","djmegamenu-module_pos":"dj-mega-extensions0","djmegamenu-module_style":"xhtml","djmegamenu-module_show_link":"0"}','56','57','0','*','0'),
('497','djmediatools','Gallery Grid','gallery-grid','','gallery-grid','index.php?option=com_djmediatools&view=category&id=18','component','1','1','1','10009','0','0000-00-00 00:00:00','0','1','','0','{"show_cat_titles":"","cwidth":"","cheight":"","cresizing":"","cquality":"","show_cat_title":"","show_cat_desc":"","show_subcategories":"","show_album_title":"","show_album_desc":"","zoom":"","window_size":"","window_width":"","window_height":"","layout":"_:galleryGrid","slider_type":"","desc_effect":"up","sort_by":"","link_image":"2;lightbox","lightbox":"slimbox","image_width":"350","image_height":"320","resizing":"","quality":"","thumb_width":"","thumb_height":"","visible_images":"","space_between_images":"10","max_images":"6","show_thumbs":"","tab_indicator":"","tab_width":"","tab_height":"","tab_position":"","show_title":"","show_desc":"","show_readmore":"","readmore_text":"","link_title":"","link_desc":"","limit_desc":"12","autoplay":"","pause_autoplay":"","show_buttons":"","show_arrows":"","show_custom_nav":"","effect":"","effect_type":"","duration":"","delay":"","lag":"","preload":"","desc_position":"","desc_width":"280","desc_bottom":"","desc_horizontal":"","left_arrow":"","right_arrow":"","play_button":"","pause_button":"","arrows_top":"","arrows_horizontal":"","custom_nav_pos":"","custom_nav_align":"","loader_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"djmegamenu-subtitle":"","djmegamenu-submenu_expand":"","djmegamenu-column_break":"0","djmegamenu-column_width":"","djmegamenu-module_pos":"","djmegamenu-module_style":"xhtml","djmegamenu-module_show_link":"0"}','11','12','0','*','0'),
('498','djmediatools','Modern Slider','modern-slider','','modern-slider','index.php?option=com_djmediatools&view=category&id=18','component','1','1','1','10009','0','0000-00-00 00:00:00','0','1','','0','{"show_cat_titles":"","cwidth":"","cheight":"","cresizing":"","cquality":"","show_cat_title":"","show_cat_desc":"","show_subcategories":"","show_album_title":"","show_album_desc":"","zoom":"","window_size":"","window_width":"","window_height":"","layout":"_:mslider","slider_type":"","desc_effect":"","sort_by":"","link_image":"3","lightbox":"","image_width":"365","image_height":"330","resizing":"","quality":"","thumb_width":"","thumb_height":"","visible_images":"2","space_between_images":"","max_images":"8","show_thumbs":"","tab_indicator":"","tab_width":"","tab_height":"","tab_position":"","show_title":"","show_desc":"0","show_readmore":"0","readmore_text":"readmore","link_title":"","link_desc":"","limit_desc":"30","autoplay":"","pause_autoplay":"","show_buttons":"","show_arrows":"","show_custom_nav":"","effect":"","effect_type":"","duration":"","delay":"","lag":"","preload":"","desc_position":"","desc_width":"300","desc_bottom":"0","desc_horizontal":"0","left_arrow":"","right_arrow":"","play_button":"","pause_button":"","arrows_top":"","arrows_horizontal":"","custom_nav_pos":"","custom_nav_align":"","loader_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"djmegamenu-subtitle":"","djmegamenu-submenu_expand":"","djmegamenu-column_break":"0","djmegamenu-column_width":"","djmegamenu-module_pos":"","djmegamenu-module_style":"xhtml","djmegamenu-module_show_link":"0"}','15','16','0','*','0'),
('499','djmediatools','Slider','slider','','slider','index.php?option=com_djmediatools&view=category&id=18','component','1','1','1','10009','0','0000-00-00 00:00:00','0','1','','0','{"show_cat_titles":"","cwidth":"","cheight":"","cresizing":"","cquality":"","show_cat_title":"","show_cat_desc":"","show_subcategories":"","show_album_title":"","show_album_desc":"","zoom":"","window_size":"","window_width":"","window_height":"","layout":"_:slider","slider_type":"","desc_effect":"","sort_by":"","link_image":"","lightbox":"","image_width":"365","image_height":"330","resizing":"","quality":"","thumb_width":"","thumb_height":"","visible_images":"2","space_between_images":"","max_images":"8","show_thumbs":"","tab_indicator":"","tab_width":"","tab_height":"","tab_position":"","show_title":"0","show_desc":"1","show_readmore":"0","readmore_text":"","link_title":"","link_desc":"1","limit_desc":"25","autoplay":"","pause_autoplay":"","show_buttons":"","show_arrows":"","show_custom_nav":"","effect":"","effect_type":"","duration":"","delay":"","lag":"","preload":"","desc_position":"","desc_width":"300","desc_bottom":"","desc_horizontal":"","left_arrow":"","right_arrow":"","play_button":"","pause_button":"","arrows_top":"","arrows_horizontal":"","custom_nav_pos":"","custom_nav_align":"","loader_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"djmegamenu-subtitle":"","djmegamenu-submenu_expand":"","djmegamenu-column_break":"0","djmegamenu-column_width":"","djmegamenu-module_pos":"","djmegamenu-module_style":"xhtml","djmegamenu-module_show_link":"0"}','17','18','0','*','0'),
('500','djmediatools','Slideshow','slideshow','','slideshow','index.php?option=com_djmediatools&view=category&id=18','component','1','1','1','10009','0','0000-00-00 00:00:00','0','1','','0','{"show_cat_titles":"","cwidth":"","cheight":"","cresizing":"","cquality":"","show_cat_title":"","show_cat_desc":"","show_subcategories":"","show_album_title":"","show_album_desc":"","zoom":"","window_size":"","window_width":"","window_height":"","layout":"_:slideshow","slider_type":"","desc_effect":"","sort_by":"","link_image":"","lightbox":"","image_width":"600","image_height":"450","resizing":"","quality":"","thumb_width":"","thumb_height":"","visible_images":"","space_between_images":"","max_images":"8","show_thumbs":"","tab_indicator":"","tab_width":"","tab_height":"","tab_position":"","show_title":"","show_desc":"0","show_readmore":"0","readmore_text":"","link_title":"","link_desc":"","limit_desc":"80","autoplay":"","pause_autoplay":"","show_buttons":"","show_arrows":"","show_custom_nav":"","effect":"","effect_type":"","duration":"","delay":"","lag":"","preload":"","desc_position":"","desc_width":"500","desc_bottom":"","desc_horizontal":"","left_arrow":"","right_arrow":"","play_button":"","pause_button":"","arrows_top":"","arrows_horizontal":"","custom_nav_pos":"","custom_nav_align":"","loader_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":"0","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"djmegamenu-subtitle":"","djmegamenu-column_break":"0","djmegamenu-column_width":"","djmegamenu-expand":"","djmegamenu-dropdown_dir":"","djmegamenu-bg_image":"","djmegamenu-bg_pos_hor":"right","djmegamenu-bg_pos_ver":"bottom","djmegamenu-module_pos":"","djmegamenu-module_style":"xhtml","djmegamenu-module_show_link":"0","djmegamenu-accesskey":""}','19','20','0','*','0'),
('501','djmediatools','Slideshow With Thumbnails','slideshow-with-thumbnails','','slideshow-with-thumbnails','index.php?option=com_djmediatools&view=category&id=18','component','1','1','1','10009','0','0000-00-00 00:00:00','0','1','','0','{"show_cat_titles":"","cwidth":"","cheight":"","cresizing":"","cquality":"","show_cat_title":"","show_cat_desc":"","show_subcategories":"","show_album_title":"","show_album_desc":"","zoom":"","window_size":"","window_width":"","window_height":"","layout":"_:slideshowThumbs","slider_type":"","desc_effect":"","sort_by":"","link_image":"","lightbox":"","image_width":"600","image_height":"450","resizing":"","quality":"","thumb_width":"120","thumb_height":"100","visible_images":"","space_between_images":"","max_images":"8","show_thumbs":"","tab_indicator":"","tab_width":"","tab_height":"","tab_position":"","show_title":"","show_desc":"","show_readmore":"","readmore_text":"","link_title":"","link_desc":"","limit_desc":"80","autoplay":"","pause_autoplay":"","show_buttons":"","show_arrows":"","show_custom_nav":"","effect":"","effect_type":"","duration":"","delay":"","lag":"","preload":"","desc_position":"","desc_width":"500","desc_bottom":"","desc_horizontal":"","left_arrow":"","right_arrow":"","play_button":"","pause_button":"","arrows_top":"","arrows_horizontal":"","custom_nav_pos":"","custom_nav_align":"","loader_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":"0","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"djmegamenu-subtitle":"","djmegamenu-column_break":"0","djmegamenu-column_width":"","djmegamenu-expand":"","djmegamenu-dropdown_dir":"","djmegamenu-bg_image":"","djmegamenu-bg_pos_hor":"right","djmegamenu-bg_pos_ver":"bottom","djmegamenu-module_pos":"","djmegamenu-module_style":"xhtml","djmegamenu-module_show_link":"0","djmegamenu-accesskey":""}','21','22','0','*','0'),
('502','djmediatools','Tabber','tabber','','tabber','index.php?option=com_djmediatools&view=category&id=18','component','1','1','1','10009','0','0000-00-00 00:00:00','0','1','','0','{"show_cat_titles":"","cwidth":"","cheight":"","cresizing":"","cquality":"","show_cat_title":"","show_cat_desc":"","show_subcategories":"","show_album_title":"","show_album_desc":"","zoom":"","window_size":"","window_width":"","window_height":"","layout":"_:tabber","slider_type":"","desc_effect":"","sort_by":"","link_image":"","lightbox":"","image_width":"564","image_height":"425","resizing":"","quality":"","thumb_width":"98","thumb_height":"98","visible_images":"","space_between_images":"","max_images":"","show_thumbs":"","tab_indicator":"","tab_width":"300","tab_height":"118","tab_position":"","show_title":"","show_desc":"0","show_readmore":"1","readmore_text":"","link_title":"","link_desc":"","limit_desc":"100","autoplay":"","pause_autoplay":"","show_buttons":"","show_arrows":"","show_custom_nav":"","effect":"","effect_type":"","duration":"","delay":"","lag":"","preload":"","desc_position":"","desc_width":"600","desc_bottom":"","desc_horizontal":"","left_arrow":"","right_arrow":"","play_button":"","pause_button":"","arrows_top":"","arrows_horizontal":"","custom_nav_pos":"","custom_nav_align":"","loader_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":"0","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"djmegamenu-subtitle":"","djmegamenu-column_break":"0","djmegamenu-column_width":"","djmegamenu-expand":"","djmegamenu-dropdown_dir":"","djmegamenu-bg_image":"","djmegamenu-bg_pos_hor":"right","djmegamenu-bg_pos_ver":"bottom","djmegamenu-module_pos":"","djmegamenu-module_style":"xhtml","djmegamenu-module_show_link":"0","djmegamenu-accesskey":""}','23','24','0','*','0'),
('503','djmediatools','Skitter Slideshow','skitter-slideshow','','skitter-slideshow','index.php?option=com_djmediatools&view=category&id=18','component','1','1','1','10009','0','0000-00-00 00:00:00','0','1','','0','{"show_cat_titles":"","cwidth":"","cheight":"","cresizing":"","cquality":"","show_cat_title":"","show_cat_desc":"","show_subcategories":"","show_album_title":"","show_album_desc":"","zoom":"","window_size":"","window_width":"","window_height":"","layout":"_:skitterSlideshow","slider_type":"","desc_effect":"","sort_by":"","link_image":"","lightbox":"","image_width":"600","image_height":"450","resizing":"","quality":"","thumb_width":"","thumb_height":"","visible_images":"","space_between_images":"","max_images":"8","show_thumbs":"","tab_indicator":"","tab_width":"","tab_height":"","tab_position":"","show_title":"","show_desc":"","show_readmore":"","readmore_text":"","link_title":"","link_desc":"","limit_desc":"80","autoplay":"","pause_autoplay":"","show_buttons":"","show_arrows":"","show_custom_nav":"","effect":"","effect_type":"","duration":"","delay":"","lag":"","preload":"","desc_position":"","desc_width":"500","desc_bottom":"","desc_horizontal":"","left_arrow":"","right_arrow":"","play_button":"","pause_button":"","arrows_top":"","arrows_horizontal":"","custom_nav_pos":"","custom_nav_align":"","loader_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":"0","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"djmegamenu-subtitle":"","djmegamenu-column_break":"0","djmegamenu-column_width":"","djmegamenu-expand":"","djmegamenu-dropdown_dir":"","djmegamenu-bg_image":"","djmegamenu-bg_pos_hor":"right","djmegamenu-bg_pos_ver":"bottom","djmegamenu-module_pos":"","djmegamenu-module_style":"xhtml","djmegamenu-module_show_link":"0","djmegamenu-accesskey":""}','41','42','0','*','0'),
('504','djmediatools','Nivo Slider','nivo-slider','','nivo-slider','index.php?option=com_djmediatools&view=category&id=18','component','1','1','1','10009','0','0000-00-00 00:00:00','0','1','','0','{"show_cat_titles":"","cwidth":"","cheight":"","cresizing":"","cquality":"","show_cat_title":"","show_cat_desc":"","show_subcategories":"","show_album_title":"","show_album_desc":"","zoom":"","window_size":"","window_width":"","window_height":"","layout":"_:nivoSlider","slider_type":"","desc_effect":"","sort_by":"","link_image":"","lightbox":"","image_width":"600","image_height":"450","resizing":"","quality":"","thumb_width":"","thumb_height":"","visible_images":"","space_between_images":"","max_images":"8","show_thumbs":"","tab_indicator":"","tab_width":"","tab_height":"","tab_position":"","show_title":"","show_desc":"","show_readmore":"0","readmore_text":"","link_title":"","link_desc":"","limit_desc":"","autoplay":"","pause_autoplay":"","show_buttons":"","show_arrows":"","show_custom_nav":"","effect":"","effect_type":"","duration":"","delay":"","lag":"","preload":"","desc_position":"","desc_width":"","desc_bottom":"","desc_horizontal":"","left_arrow":"","right_arrow":"","play_button":"","pause_button":"","arrows_top":"","arrows_horizontal":"","custom_nav_pos":"","custom_nav_align":"","loader_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":"0","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"djmegamenu-subtitle":"","djmegamenu-column_break":"0","djmegamenu-column_width":"","djmegamenu-expand":"","djmegamenu-dropdown_dir":"","djmegamenu-bg_image":"","djmegamenu-bg_pos_hor":"right","djmegamenu-bg_pos_ver":"bottom","djmegamenu-module_pos":"","djmegamenu-module_style":"xhtml","djmegamenu-module_show_link":"0","djmegamenu-accesskey":""}','43','44','0','*','0'),
('505','mainmenu','Column 2','column-2','','home-page/column-2','','separator','1','470','2','0','0','0000-00-00 00:00:00','0','1','','0','{"menu_image":"","menu_text":1,"djmegamenu-subtitle":"","djmegamenu-submenu_expand":"","djmegamenu-column_break":"1","djmegamenu-column_width":"260","djmegamenu-module_pos":"dj-mega-home1","djmegamenu-module_style":"xhtml","djmegamenu-module_show_link":"0"}','6','7','0','*','0'),
('506','mainmenu','Column 3','column-3','','home-page/column-3','','separator','1','470','2','0','0','0000-00-00 00:00:00','0','1','','0','{"menu_image":"","menu_text":1,"djmegamenu-subtitle":"","djmegamenu-submenu_expand":"","djmegamenu-column_break":"1","djmegamenu-column_width":"210","djmegamenu-module_pos":"dj-mega-home2","djmegamenu-module_style":"xhtml","djmegamenu-module_show_link":"0"}','8','9','0','*','0'),
('527','topbar','Login','log-in','','log-in','index.php?Itemid=','alias','1','1','1','0','0','0000-00-00 00:00:00','0','5','','0','{"aliasoptions":"572","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"djmegamenu-subtitle":"","djmegamenu-submenu_expand":"","djmegamenu-column_break":"0","djmegamenu-column_width":"","djmegamenu-module_pos":"","djmegamenu-module_style":"xhtml","djmegamenu-module_show_link":"0"}','69','70','0','*','0'),
('528','topbar','Register','register','','register','index.php?Itemid=','alias','1','1','1','25','0','0000-00-00 00:00:00','0','5','','0','{"aliasoptions":"573","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"djmegamenu-subtitle":"","djmegamenu-submenu_expand":"","djmegamenu-column_break":"0","djmegamenu-column_width":"","djmegamenu-module_pos":"","djmegamenu-module_style":"xhtml","djmegamenu-module_show_link":"0"}','71','72','0','*','0');
INSERT INTO `#__menu` VALUES 
('552','main','com_postinstall','Post-installation messages','','Post-installation messages','index.php?option=com_postinstall','component','1','1','1','32','0','0000-00-00 00:00:00','0','1','class:postinstall','0','','67','68','0','*','1'),
('564','layouts','Left-Content-Right','left-content-right','','left-content-right','index.php?option=com_content&view=article&id=86','component','1','1','1','22','0','0000-00-00 00:00:00','0','1','','0','{"show_title":"","link_titles":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_tags":"","show_noauth":"","urls_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"djmegamenu-subtitle":"","djmegamenu-submenu_expand":"","djmegamenu-column_break":"0","djmegamenu-column_width":"","djmegamenu-module_pos":"","djmegamenu-module_style":"xhtml","djmegamenu-module_show_link":"0"}','107','108','0','*','0'),
('565','layouts','Left-Right-Content','left-right-content','','left-right-content','index.php?option=com_content&view=article&id=86','component','1','1','1','22','0','0000-00-00 00:00:00','0','1','','0','{"show_title":"","link_titles":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_tags":"","show_noauth":"","urls_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"djmegamenu-subtitle":"","djmegamenu-submenu_expand":"","djmegamenu-column_break":"0","djmegamenu-column_width":"","djmegamenu-module_pos":"","djmegamenu-module_style":"xhtml","djmegamenu-module_show_link":"0"}','109','110','0','*','0'),
('566','layouts','Content-Right-Left','content-right-left','','content-right-left','index.php?option=com_content&view=article&id=86','component','1','1','1','22','0','0000-00-00 00:00:00','0','1','','0','{"show_title":"","link_titles":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_tags":"","show_noauth":"","urls_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"djmegamenu-subtitle":"","djmegamenu-submenu_expand":"","djmegamenu-column_break":"0","djmegamenu-column_width":"","djmegamenu-module_pos":"","djmegamenu-module_style":"xhtml","djmegamenu-module_show_link":"0"}','111','112','0','*','0'),
('567','layouts','Left-Content','left-content','','left-content','index.php?option=com_content&view=article&id=86','component','1','1','1','22','0','0000-00-00 00:00:00','0','1','','0','{"show_title":"","link_titles":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_tags":"","show_noauth":"","urls_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"djmegamenu-subtitle":"","djmegamenu-submenu_expand":"","djmegamenu-column_break":"0","djmegamenu-column_width":"","djmegamenu-module_pos":"","djmegamenu-module_style":"xhtml","djmegamenu-module_show_link":"0"}','113','114','0','*','0'),
('568','layouts','Content-Right','content-right','','content-right','index.php?option=com_content&view=article&id=86','component','1','1','1','22','0','0000-00-00 00:00:00','0','1','','0','{"show_title":"","link_titles":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_tags":"","show_noauth":"","urls_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"djmegamenu-subtitle":"","djmegamenu-submenu_expand":"","djmegamenu-column_break":"0","djmegamenu-column_width":"","djmegamenu-module_pos":"","djmegamenu-module_style":"xhtml","djmegamenu-module_show_link":"0"}','115','116','0','*','0'),
('569','layouts','Content','content','','content','index.php?option=com_content&view=article&id=86','component','1','1','1','22','0','0000-00-00 00:00:00','0','1','','0','{"show_title":"","link_titles":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_tags":"","show_noauth":"","urls_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"djmegamenu-subtitle":"","djmegamenu-submenu_expand":"","djmegamenu-column_break":"0","djmegamenu-column_width":"","djmegamenu-module_pos":"","djmegamenu-module_style":"xhtml","djmegamenu-module_show_link":"0"}','117','118','0','*','0'),
('570','jotherpages','Search','search','','search','index.php?option=com_search&view=search','component','1','1','1','19','0','0000-00-00 00:00:00','0','1','','0','{"search_areas":"","show_date":"","searchphrase":"0","ordering":"newest","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"djmegamenu-subtitle":"","djmegamenu-submenu_expand":"","djmegamenu-column_break":"0","djmegamenu-column_width":"","djmegamenu-module_pos":"","djmegamenu-module_style":"xhtml","djmegamenu-module_show_link":"0"}','165','166','0','*','0'),
('572','jotherpages','Login Form','login-form','','login-form','index.php?option=com_users&view=login','component','1','1','1','25','0','0000-00-00 00:00:00','0','1','','0','{"login_redirect_url":"","logindescription_show":"1","login_description":"","login_image":"","logout_redirect_url":"","logoutdescription_show":"1","logout_description":"","logout_image":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":1,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"djmegamenu-subtitle":"","djmegamenu-submenu_expand":"","djmegamenu-column_break":"0","djmegamenu-column_width":"","djmegamenu-module_pos":"","djmegamenu-module_style":"xhtml","djmegamenu-module_show_link":"0"}','119','120','0','*','0'),
('573','jotherpages','Registration Form','registration-form','','registration-form','index.php?option=com_users&view=registration','component','1','1','1','25','0','0000-00-00 00:00:00','0','1','','0','{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":1,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"djmegamenu-subtitle":"","djmegamenu-submenu_expand":"","djmegamenu-column_break":"0","djmegamenu-column_width":"","djmegamenu-module_pos":"","djmegamenu-module_style":"xhtml","djmegamenu-module_show_link":"0"}','121','122','0','*','0'),
('574','jcontent','Single Article','single-article','','single-article','index.php?option=com_content&view=article&id=87','component','1','1','1','22','0','0000-00-00 00:00:00','0','1','','0','{"show_title":"","link_titles":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_tags":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","urls_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"djmegamenu-subtitle":"","djmegamenu-submenu_expand":"","djmegamenu-column_break":"0","djmegamenu-column_width":"","djmegamenu-module_pos":"","djmegamenu-module_style":"xhtml","djmegamenu-module_show_link":"0"}','123','124','0','*','0'),
('575','jcontent','Category Blog - 2 columns','category-blog-2-columns','','category-blog-2-columns','index.php?option=com_content&view=category&layout=blog&id=83','component','1','1','1','22','0','0000-00-00 00:00:00','0','1','','0','{"layout_type":"blog","show_category_heading_title_text":"","show_category_title":"","show_description":"0","show_description_image":"","maxLevel":"","show_empty_categories":"","show_no_articles":"","show_subcat_desc":"","show_cat_num_articles":"","page_subheading":"","num_leading_articles":"1","num_intro_articles":"4","num_columns":"2","num_links":"4","multi_column_order":"1","show_subcategory_content":"","orderby_pri":"","orderby_sec":"","order_date":"","show_pagination":"","show_pagination_results":"","show_title":"","link_titles":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_readmore":"","show_readmore_title":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"djmegamenu-subtitle":"","djmegamenu-submenu_expand":"","djmegamenu-column_break":"0","djmegamenu-column_width":"","djmegamenu-module_pos":"","djmegamenu-module_style":"xhtml","djmegamenu-module_show_link":"0"}','125','126','0','*','0'),
('576','jcontent','Category Blog - 1 column','category-blog-1-column','','category-blog-1-column','index.php?option=com_content&view=category&layout=blog&id=83','component','1','1','1','22','0','0000-00-00 00:00:00','0','1','','0','{"layout_type":"blog","show_category_heading_title_text":"","show_category_title":"","show_description":"0","show_description_image":"0","maxLevel":"","show_empty_categories":"","show_no_articles":"","show_subcat_desc":"","show_cat_num_articles":"","page_subheading":"","num_leading_articles":"1","num_intro_articles":"4","num_columns":"1","num_links":"4","multi_column_order":"1","show_subcategory_content":"","orderby_pri":"","orderby_sec":"","order_date":"","show_pagination":"","show_pagination_results":"","show_title":"","link_titles":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_readmore":"","show_readmore_title":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"djmegamenu-subtitle":"","djmegamenu-submenu_expand":"","djmegamenu-column_break":"0","djmegamenu-column_width":"","djmegamenu-module_pos":"","djmegamenu-module_style":"xhtml","djmegamenu-module_show_link":"0"}','127','128','0','*','0'),
('577','jcontent','Category List','category-list','','category-list','index.php?option=com_content&view=category&id=83','component','1','1','1','22','0','0000-00-00 00:00:00','0','1','','0','{"show_category_title":"","show_description":"","show_description_image":"","maxLevel":"","show_empty_categories":"","show_no_articles":"","show_category_heading_title":"","show_subcat_desc":"","show_cat_num_articles":"","page_subheading":"","show_pagination_limit":"","filter_field":"","show_headings":"","list_show_date":"","date_format":"","list_show_hits":"","list_show_author":"","orderby_pri":"","orderby_sec":"","order_date":"","show_pagination":"","show_pagination_results":"","display_num":"10","show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_readmore":"","show_readmore_title":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"djmegamenu-subtitle":"","djmegamenu-submenu_expand":"","djmegamenu-column_break":"0","djmegamenu-column_width":"","djmegamenu-module_pos":"","djmegamenu-module_style":"xhtml","djmegamenu-module_show_link":"0"}','129','130','0','*','0'),
('578','jcontent','Submit Article','submit-article','','submit-article','index.php?option=com_content&view=form&layout=edit','component','1','1','1','22','0','0000-00-00 00:00:00','0','3','','0','{"enable_category":"0","catid":"82","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"djmegamenu-subtitle":"","djmegamenu-submenu_expand":"","djmegamenu-column_break":"0","djmegamenu-column_width":"","djmegamenu-module_pos":"","djmegamenu-module_style":"xhtml","djmegamenu-module_show_link":"0"}','131','132','0','*','0'),
('579','jcontent','Tabs','tabs','','tabs','index.php?option=com_contact&view=contact&id=10','component','1','1','1','8','0','0000-00-00 00:00:00','0','1','','0','{"presentation_style":"","show_contact_category":"","show_contact_list":"","show_tags":"","show_name":"","show_position":"","show_email":"","show_street_address":"","show_suburb":"","show_state":"","show_postcode":"","show_country":"","show_telephone":"","show_mobile":"","show_fax":"","show_webpage":"","show_misc":"","show_image":"","allow_vcard":"","show_articles":"","show_links":"","linka_name":"","linkb_name":"","linkc_name":"","linkd_name":"","linke_name":"","show_email_form":"","show_email_copy":"","banned_email":"","banned_subject":"","banned_text":"","validate_session":"","custom_reply":"","redirect":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"djmegamenu-subtitle":"","djmegamenu-submenu_expand":"","djmegamenu-column_break":"0","djmegamenu-column_width":"","djmegamenu-module_pos":"","djmegamenu-module_style":"xhtml","djmegamenu-module_show_link":"0"}','133','134','0','*','0'),
('580','jotherpages','Contact','single-contact','','single-contact','index.php?option=com_contact&view=contact&id=1','component','1','1','1','8','0','0000-00-00 00:00:00','0','1','','0','{"presentation_style":"","show_contact_category":"","show_contact_list":"","show_tags":"","show_name":"","show_position":"","show_email":"","show_street_address":"","show_suburb":"","show_state":"","show_postcode":"","show_country":"","show_telephone":"","show_mobile":"","show_fax":"","show_webpage":"","show_misc":"","show_image":"","allow_vcard":"","show_articles":"","show_links":"","linka_name":"","linkb_name":"","linkc_name":"","linkd_name":"","linke_name":"","show_email_form":"1","show_email_copy":"0","banned_email":"","banned_subject":"","banned_text":"","validate_session":"","custom_reply":"","redirect":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":" contact-ps","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"djmegamenu-subtitle":"","djmegamenu-submenu_expand":"","djmegamenu-column_break":"0","djmegamenu-column_width":"","djmegamenu-module_pos":"","djmegamenu-module_style":"xhtml","djmegamenu-module_show_link":"0"}','163','164','0','*','0'),
('581','jcontent','Accordion','accordion','','accordion','index.php?option=com_contact&view=contact&id=9','component','1','1','1','8','0','0000-00-00 00:00:00','0','1','','0','{"presentation_style":"","show_contact_category":"","show_contact_list":"","show_tags":"","show_name":"","show_position":"","show_email":"","show_street_address":"","show_suburb":"","show_state":"","show_postcode":"","show_country":"","show_telephone":"","show_mobile":"","show_fax":"","show_webpage":"","show_misc":"","show_image":"","allow_vcard":"","show_articles":"","show_links":"","linka_name":"","linkb_name":"","linkc_name":"","linkd_name":"","linke_name":"","show_email_form":"","show_email_copy":"","banned_email":"","banned_subject":"","banned_text":"","validate_session":"","custom_reply":"","redirect":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"djmegamenu-subtitle":"","djmegamenu-submenu_expand":"","djmegamenu-column_break":"0","djmegamenu-column_width":"","djmegamenu-module_pos":"","djmegamenu-module_style":"xhtml","djmegamenu-module_show_link":"0"}','135','136','0','*','0'),
('582','djmediatools','Album Grid','album-grid','','album-grid','index.php?option=com_djmediatools&view=categories&id=8','component','1','1','1','10009','0','0000-00-00 00:00:00','0','1','','0','{"show_cat_titles":"","cwidth":"","cheight":"","cresizing":"","cquality":"","show_cat_title":"","show_cat_desc":"","show_subcategories":"","show_album_title":"","show_album_desc":"","zoom":"","window_size":"","window_width":"","window_height":"","layout":"","slider_type":"","desc_effect":"","sort_by":"","link_image":"","lightbox":"","image_width":"220","image_height":"180","resizing":"","quality":"","thumb_width":"","thumb_height":"","visible_images":"","space_between_images":"","max_images":"","show_thumbs":"","tab_indicator":"","tab_width":"","tab_height":"","tab_position":"","show_title":"","show_desc":"","show_readmore":"","readmore_text":"","link_title":"","link_desc":"","limit_desc":"","autoplay":"","pause_autoplay":"","show_buttons":"","show_arrows":"","show_custom_nav":"","effect":"","effect_type":"","duration":"","delay":"","lag":"","preload":"","desc_position":"","desc_width":"","desc_bottom":"","desc_horizontal":"","left_arrow":"","right_arrow":"","play_button":"","pause_button":"","arrows_top":"","arrows_horizontal":"","custom_nav_pos":"","custom_nav_align":"","loader_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"djmegamenu-subtitle":"","djmegamenu-submenu_expand":"","djmegamenu-column_break":"0","djmegamenu-column_width":"","djmegamenu-module_pos":"","djmegamenu-module_style":"xhtml","djmegamenu-module_show_link":"0"}','1','2','0','*','0'),
('583','mainmenu','Pages','pages','content area','pages','index.php?Itemid=','alias','1','1','1','0','0','0000-00-00 00:00:00','0','1','','0','{"aliasoptions":"564","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"djmegamenu-subtitle":"","djmegamenu-submenu_expand":"","djmegamenu-column_break":"0","djmegamenu-column_width":"","djmegamenu-module_pos":"","djmegamenu-module_style":"xhtml","djmegamenu-module_show_link":"0"}','45','54','0','*','0'),
('584','mainmenu','Column 1 (Layouts)','column-1-layouts','','pages/column-1-layouts','','separator','1','583','2','0','0','0000-00-00 00:00:00','0','1','','0','{"menu_image":"","menu_text":1,"djmegamenu-subtitle":"","djmegamenu-submenu_expand":"","djmegamenu-column_break":"1","djmegamenu-column_width":"180","djmegamenu-module_pos":"dj-mega-subpage0","djmegamenu-module_style":"xhtml","djmegamenu-module_show_link":"0"}','46','47','0','*','0'),
('585','mainmenu','Column 2 (J! Content)','column-2-j-content','','pages/column-2-j-content','','separator','1','583','2','0','0','0000-00-00 00:00:00','0','1','','0','{"menu_image":"","menu_text":1,"djmegamenu-subtitle":"","djmegamenu-submenu_expand":"","djmegamenu-column_break":"1","djmegamenu-column_width":"","djmegamenu-module_pos":"dj-mega-subpage1","djmegamenu-module_style":"xhtml","djmegamenu-module_show_link":"0"}','48','49','0','*','0'),
('586','mainmenu','Column 3 (J! Other pages)','column-3-j-other-pages','','pages/column-3-j-other-pages','','separator','1','583','2','0','0','0000-00-00 00:00:00','0','1','','0','{"menu_image":"","menu_text":1,"djmegamenu-subtitle":"","djmegamenu-submenu_expand":"","djmegamenu-column_break":"1","djmegamenu-column_width":"","djmegamenu-module_pos":"dj-mega-subpage2","djmegamenu-module_style":"xhtml","djmegamenu-module_show_link":"0"}','50','51','0','*','0'),
('587','mainmenu','Column 4 (Custom pages)','column-4-custom-pages','','pages/column-4-custom-pages','','separator','1','583','2','0','0','0000-00-00 00:00:00','0','1','','0','{"menu_image":"","menu_text":1,"djmegamenu-subtitle":"","djmegamenu-submenu_expand":"","djmegamenu-column_break":"1","djmegamenu-column_width":"","djmegamenu-module_pos":"dj-mega-subpage3","djmegamenu-module_style":"xhtml","djmegamenu-module_show_link":"0"}','52','53','0','*','0'),
('589','jotherpages','User Profile','user-profile','','user-profile','index.php?option=com_users&view=profile','component','1','1','1','25','0','0000-00-00 00:00:00','0','1','','0','{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"djmegamenu-subtitle":"","djmegamenu-submenu_expand":"","djmegamenu-column_break":"0","djmegamenu-column_width":"","djmegamenu-module_pos":"","djmegamenu-module_style":"xhtml","djmegamenu-module_show_link":"0"}','137','138','0','*','0'),
('601','articles','Header articles','header-articles','','header-articles','index.php?option=com_content&view=category&layout=blog&id=86','component','1','1','1','22','0','0000-00-00 00:00:00','0','1','','0','{"layout_type":"blog","show_category_heading_title_text":"","show_category_title":"","show_description":"","show_description_image":"","maxLevel":"","show_empty_categories":"","show_no_articles":"","show_subcat_desc":"","show_cat_num_articles":"","show_cat_tags":"","page_subheading":"","num_leading_articles":"0","num_intro_articles":"3","num_columns":"1","num_links":"0","multi_column_order":"","show_subcategory_content":"","orderby_pri":"","orderby_sec":"","order_date":"","show_pagination":"","show_pagination_results":"","show_featured":"","show_title":"1","link_titles":"1","show_intro":"0","info_block_position":"","show_category":"1","link_category":"1","show_parent_category":"","link_parent_category":"","show_author":"1","link_author":"1","show_create_date":"1","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_readmore":"","show_readmore_title":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"1","show_tags":"","show_noauth":"","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":"0","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"djmegamenu-subtitle":"","djmegamenu-column_break":"0","djmegamenu-column_width":"","djmegamenu-expand":"","djmegamenu-dropdown_dir":"","djmegamenu-bg_image":"","djmegamenu-bg_pos_hor":"right","djmegamenu-bg_pos_ver":"bottom","djmegamenu-module_pos":"","djmegamenu-module_style":"xhtml","djmegamenu-module_show_link":"0","djmegamenu-accesskey":""}','139','140','0','*','0'),
('602','topbar','Contact Us','contact-us','','contact-us','index.php?Itemid=','alias','1','1','1','0','0','0000-00-00 00:00:00','0','1','','0','{"aliasoptions":"580","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"djmegamenu-subtitle":"","djmegamenu-submenu_expand":"","djmegamenu-column_break":"0","djmegamenu-column_width":"","djmegamenu-module_pos":"","djmegamenu-module_style":"xhtml","djmegamenu-module_show_link":"0"}','141','142','0','*','0'),
('607','djtabs','Accordion View','accordion-view','','accordion-view','index.php?option=com_djtabs&view=tabs&layout=accordion','component','1','1','1','10017','0','0000-00-00 00:00:00','0','1','','0','{"group_id":"6","theme":"-1","accordion_display":"2","video_autopause":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"djmegamenu-subtitle":"","djmegamenu-submenu_expand":"","djmegamenu-column_break":"0","djmegamenu-column_width":"","djmegamenu-module_pos":"","djmegamenu-module_style":"xhtml","djmegamenu-module_show_link":"0"}','143','144','0','*','0'),
('608','djtabs','Tabs View','tabs-view','','tabs-view','index.php?option=com_djtabs&view=tabs','component','1','1','1','10017','0','0000-00-00 00:00:00','0','1','','0','{"group_id":"6","theme":"-1","video_autopause":"","rows_number":"1","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"djmegamenu-subtitle":"","djmegamenu-submenu_expand":"","djmegamenu-column_break":"0","djmegamenu-column_width":"","djmegamenu-module_pos":"","djmegamenu-module_style":"xhtml","djmegamenu-module_show_link":"0"}','145','146','0','*','0'),
('611','articles','Sample Blog','sample-blog','','sample-blog','index.php?option=com_content&view=category&layout=blog&id=83','component','1','1','1','22','0','0000-00-00 00:00:00','0','1','','0','{"layout_type":"blog","show_category_heading_title_text":"","show_category_title":"","show_description":"","show_description_image":"","maxLevel":"","show_empty_categories":"","show_no_articles":"","show_subcat_desc":"","show_cat_num_articles":"","page_subheading":"","num_leading_articles":"","num_intro_articles":"","num_columns":"","num_links":"","multi_column_order":"","show_subcategory_content":"","orderby_pri":"","orderby_sec":"","order_date":"","show_pagination":"","show_pagination_results":"","show_title":"","link_titles":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_readmore":"","show_readmore_title":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"djmegamenu-subtitle":"","djmegamenu-submenu_expand":"","djmegamenu-column_break":"0","djmegamenu-column_width":"","djmegamenu-module_pos":"","djmegamenu-module_style":"xhtml","djmegamenu-module_show_link":"0"}','147','148','0','*','0'),
('612','djmediatools','Gallery Grid (modal)','gallery-grid-modal','','gallery-grid-modal','index.php?option=com_djmediatools&view=category&id=18','component','1','1','1','10009','0','0000-00-00 00:00:00','0','1','','0','{"show_cat_titles":"","cwidth":"","cheight":"","cresizing":"","cquality":"","show_cat_title":"","show_cat_desc":"","show_subcategories":"","show_album_title":"","show_album_desc":"","zoom":"","window_size":"","window_width":"","window_height":"","layout":"_:galleryGrid","slider_type":"","desc_effect":"up","sort_by":"","link_image":"2;lightbox","lightbox":"slimbox","image_width":"350","image_height":"320","resizing":"","quality":"","thumb_width":"","thumb_height":"","visible_images":"","space_between_images":"10","max_images":"6","show_thumbs":"","tab_indicator":"","tab_width":"","tab_height":"","tab_position":"","show_title":"0","show_desc":"0","show_readmore":"0","readmore_text":"","link_title":"","link_desc":"","limit_desc":"20","autoplay":"","pause_autoplay":"","show_buttons":"","show_arrows":"","show_custom_nav":"","effect":"","effect_type":"","duration":"","delay":"","lag":"","preload":"","desc_position":"","desc_width":"280","desc_bottom":"","desc_horizontal":"","left_arrow":"","right_arrow":"","play_button":"","pause_button":"","arrows_top":"","arrows_horizontal":"","custom_nav_pos":"","custom_nav_align":"","loader_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"djmegamenu-subtitle":"","djmegamenu-submenu_expand":"","djmegamenu-column_break":"0","djmegamenu-column_width":"","djmegamenu-module_pos":"","djmegamenu-module_style":"xhtml","djmegamenu-module_show_link":"0"}','13','14','0','*','0'),
('648','djmediatools','Kwicks Panels','kwicks-panels','','kwicks-panels','index.php?option=com_djmediatools&view=category&id=18','component','1','1','1','10009','0','0000-00-00 00:00:00','0','1','','0','{"show_cat_titles":"","cwidth":"","cheight":"","cresizing":"","cquality":"","show_cat_title":"","show_cat_desc":"","show_subcategories":"","show_album_title":"","show_album_desc":"","zoom":"","window_size":"","window_width":"","window_height":"","layout":"_:panels","slider_type":"","desc_effect":"","sort_by":"","link_image":"","lightbox":"","image_width":"","image_height":"450","resizing":"","quality":"","thumb_width":"","thumb_height":"","visible_images":"","space_between_images":"0","max_images":"","show_thumbs":"","tab_indicator":"","tab_width":"","tab_height":"","tab_position":"","show_title":"","show_desc":"","show_readmore":"","readmore_text":"","link_title":"","link_desc":"","limit_desc":"","autoplay":"","pause_autoplay":"","show_buttons":"","show_arrows":"","show_custom_nav":"","effect":"","effect_type":"","duration":"","delay":"","lag":"","preload":"","desc_position":"","desc_width":"","desc_bottom":"","desc_horizontal":"","left_arrow":"","right_arrow":"","play_button":"","pause_button":"","arrows_top":"","arrows_horizontal":"","custom_nav_pos":"","custom_nav_align":"","loader_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":"0","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"djmegamenu-subtitle":"","djmegamenu-column_break":"0","djmegamenu-column_width":"","djmegamenu-expand":"","djmegamenu-dropdown_dir":"","djmegamenu-bg_image":"","djmegamenu-bg_pos_hor":"right","djmegamenu-bg_pos_ver":"bottom","djmegamenu-module_pos":"","djmegamenu-module_style":"xhtml","djmegamenu-module_show_link":"0","djmegamenu-accesskey":""}','149','150','0','*','0'),
('649','mainmenu','Styles','styles','color','styles','','separator','1','1','1','0','0','0000-00-00 00:00:00','0','1','','0','{"menu_image":"","menu_text":1,"djmegamenu-subtitle":"","djmegamenu-submenu_expand":"","djmegamenu-column_break":"0","djmegamenu-column_width":"","djmegamenu-module_pos":"","djmegamenu-module_style":"xhtml","djmegamenu-module_show_link":"0"}','151','162','0','*','0'),
('650','custompages','Coming Soon','coming-soon','','coming-soon','index.php?option=com_content&view=article&id=119','component','1','1','1','22','0','0000-00-00 00:00:00','0','1','','0','{"show_title":"","link_titles":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_tags":"","show_noauth":"","urls_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"djmegamenu-subtitle":"","djmegamenu-submenu_expand":"","djmegamenu-column_break":"0","djmegamenu-column_width":"","djmegamenu-module_pos":"","djmegamenu-module_style":"xhtml","djmegamenu-module_show_link":"0"}','167','168','0','*','0'),
('651','custompages','Pricing Table','pricing-table','','pricing-table','index.php?option=com_content&view=article&id=110','component','1','1','1','22','0','0000-00-00 00:00:00','0','1','','0','{"show_title":"","link_titles":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_tags":"","show_noauth":"","urls_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"djmegamenu-subtitle":"","djmegamenu-submenu_expand":"","djmegamenu-column_break":"0","djmegamenu-column_width":"","djmegamenu-module_pos":"","djmegamenu-module_style":"xhtml","djmegamenu-module_show_link":"0"}','169','170','0','*','0'),
('652','custompages','Faq','faq','','faq','index.php?option=com_content&view=article&id=120','component','1','1','1','22','0','0000-00-00 00:00:00','0','1','','0','{"show_title":"","link_titles":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_tags":"","show_noauth":"","urls_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"djmegamenu-subtitle":"","djmegamenu-submenu_expand":"","djmegamenu-column_break":"0","djmegamenu-column_width":"","djmegamenu-module_pos":"","djmegamenu-module_style":"xhtml","djmegamenu-module_show_link":"0"}','171','172','0','*','0'),
('653','custompages','Gallery','gallery','','gallery','index.php?Itemid=','alias','1','1','1','0','0','0000-00-00 00:00:00','0','1','','0','{"aliasoptions":"497","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"djmegamenu-subtitle":"","djmegamenu-column_break":"0","djmegamenu-column_width":"","djmegamenu-expand":"","djmegamenu-dropdown_dir":"","djmegamenu-bg_image":"","djmegamenu-bg_pos_hor":"right","djmegamenu-bg_pos_ver":"bottom","djmegamenu-module_pos":"","djmegamenu-module_style":"xhtml","djmegamenu-module_show_link":"0","djmegamenu-accesskey":""}','173','174','0','*','0'),
('654','articles','Articles Tabs','articles-tabs','','articles-tabs','index.php?option=com_content&view=category&layout=blog&id=84','component','1','1','1','22','0','0000-00-00 00:00:00','0','1','','0','{"layout_type":"blog","show_category_heading_title_text":"","show_category_title":"","show_description":"","show_description_image":"","maxLevel":"","show_empty_categories":"","show_no_articles":"","show_subcat_desc":"","show_cat_num_articles":"","show_cat_tags":"","page_subheading":"","num_leading_articles":"0","num_intro_articles":"3","num_columns":"1","num_links":"0","multi_column_order":"","show_subcategory_content":"","orderby_pri":"","orderby_sec":"","order_date":"","show_pagination":"","show_pagination_results":"","show_title":"","link_titles":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_readmore":"","show_readmore_title":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"djmegamenu-subtitle":"","djmegamenu-submenu_expand":"","djmegamenu-column_break":"0","djmegamenu-column_width":"","djmegamenu-module_pos":"","djmegamenu-module_style":"xhtml","djmegamenu-module_show_link":"0"}','175','176','0','*','0'),
('655','articles','Articles Accordion','articles-accordion','','articles-accordion','index.php?option=com_content&view=category&layout=blog&id=88','component','1','1','1','22','0','0000-00-00 00:00:00','0','1','','0','{"layout_type":"blog","show_category_heading_title_text":"","show_category_title":"","show_description":"","show_description_image":"","maxLevel":"","show_empty_categories":"","show_no_articles":"","show_subcat_desc":"","show_cat_num_articles":"","show_cat_tags":"","page_subheading":"","num_leading_articles":"0","num_intro_articles":"3","num_columns":"1","num_links":"0","multi_column_order":"","show_subcategory_content":"","orderby_pri":"","orderby_sec":"","order_date":"","show_pagination":"","show_pagination_results":"","show_title":"","link_titles":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_readmore":"","show_readmore_title":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"djmegamenu-subtitle":"","djmegamenu-submenu_expand":"","djmegamenu-column_break":"0","djmegamenu-column_width":"","djmegamenu-module_pos":"","djmegamenu-module_style":"xhtml","djmegamenu-module_show_link":"0"}','177','178','0','*','0'),
('657','jotherpages','Error 404','error-404','','error-404','index.php?option=com_content&view=article&id=121','component','1','1','1','22','0','0000-00-00 00:00:00','0','1','','0','{"show_title":"","link_titles":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_tags":"","show_noauth":"","urls_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"noindex, follow","secure":0,"djmegamenu-subtitle":"","djmegamenu-submenu_expand":"","djmegamenu-column_break":"0","djmegamenu-column_width":"","djmegamenu-module_pos":"","djmegamenu-module_style":"xhtml","djmegamenu-module_show_link":"0"}','179','180','0','*','0'),
('658','homesubmenu','Home 1 - Slideshow','home1','','home1','index.php?Itemid=','alias','1','1','1','0','0','0000-00-00 00:00:00','0','1','','0','{"aliasoptions":"470","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"djmegamenu-subtitle":"","djmegamenu-column_break":"0","djmegamenu-column_width":"","djmegamenu-expand":"","djmegamenu-dropdown_dir":"","djmegamenu-bg_image":"","djmegamenu-bg_pos_hor":"right","djmegamenu-bg_pos_ver":"bottom","djmegamenu-module_pos":"","djmegamenu-module_style":"xhtml","djmegamenu-module_show_link":"0","djmegamenu-accesskey":""}','181','182','0','*','0'),
('659','homesubmenu','Home 2 - Tabber','home-2-tabber','','home-2-tabber','index.php?option=com_content&view=article&id=86','component','1','1','1','22','0','0000-00-00 00:00:00','0','1','','0','{"show_title":"","link_titles":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_tags":"","show_noauth":"","urls_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":"0","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"djmegamenu-subtitle":"","djmegamenu-column_break":"0","djmegamenu-column_width":"","djmegamenu-expand":"","djmegamenu-dropdown_dir":"","djmegamenu-bg_image":"","djmegamenu-bg_pos_hor":"right","djmegamenu-bg_pos_ver":"bottom","djmegamenu-module_pos":"","djmegamenu-module_style":"xhtml","djmegamenu-module_show_link":"0","djmegamenu-accesskey":""}','183','184','0','*','0'),
('660','homesubmenu','Home 3 - Nivo Slider','home-3-nivo-slider','','home-3-nivo-slider','index.php?option=com_content&view=article&id=86','component','1','1','1','22','0','0000-00-00 00:00:00','0','1','','0','{"show_title":"","link_titles":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_tags":"","show_noauth":"","urls_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":"0","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"djmegamenu-subtitle":"","djmegamenu-column_break":"0","djmegamenu-column_width":"","djmegamenu-expand":"","djmegamenu-dropdown_dir":"","djmegamenu-bg_image":"","djmegamenu-bg_pos_hor":"right","djmegamenu-bg_pos_ver":"bottom","djmegamenu-module_pos":"","djmegamenu-module_style":"xhtml","djmegamenu-module_show_link":"0","djmegamenu-accesskey":""}','185','186','0','*','0'),
('661','homesubmenu','Home 4 - Slider','home-4-slider','','home-4-slider','index.php?option=com_content&view=article&id=86','component','1','1','1','22','0','0000-00-00 00:00:00','0','1','','0','{"show_title":"","link_titles":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_tags":"","show_noauth":"","urls_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":"0","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"djmegamenu-subtitle":"","djmegamenu-column_break":"0","djmegamenu-column_width":"","djmegamenu-expand":"","djmegamenu-dropdown_dir":"","djmegamenu-bg_image":"","djmegamenu-bg_pos_hor":"right","djmegamenu-bg_pos_ver":"bottom","djmegamenu-module_pos":"","djmegamenu-module_style":"xhtml","djmegamenu-module_show_link":"0","djmegamenu-accesskey":""}','187','188','0','*','0'),
('670','mainmenu','Style 1 - Blue','style1','','styles/style1','index.php?Itemid=','alias','-2','649','2','0','0','0000-00-00 00:00:00','0','1','','0','{"aliasoptions":"658","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"djmegamenu-subtitle":"","djmegamenu-submenu_expand":"","djmegamenu-column_break":"0","djmegamenu-column_width":"","djmegamenu-module_pos":"","djmegamenu-module_style":"xhtml","djmegamenu-module_show_link":"0"}','152','153','0','*','0'),
('671','mainmenu','Style 2 - Orange','style2','','styles/style2','index.php?option=com_djtabs&view=tabs','component','-2','649','2','10017','0','0000-00-00 00:00:00','0','1','','23','{"group_id":"4","theme":"-1","video_autopause":"","rows_number":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"djmegamenu-subtitle":"","djmegamenu-submenu_expand":"","djmegamenu-column_break":"0","djmegamenu-column_width":"","djmegamenu-module_pos":"","djmegamenu-module_style":"xhtml","djmegamenu-module_show_link":"0"}','154','155','0','*','0'),
('672','mainmenu','Style 3 - Yellow','style3','','styles/style3','index.php?option=com_djtabs&view=tabs','component','-2','649','2','10017','0','0000-00-00 00:00:00','0','1','','24','{"group_id":"4","theme":"-1","video_autopause":"","rows_number":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"djmegamenu-subtitle":"","djmegamenu-submenu_expand":"","djmegamenu-column_break":"0","djmegamenu-column_width":"","djmegamenu-module_pos":"","djmegamenu-module_style":"xhtml","djmegamenu-module_show_link":"0"}','156','157','0','*','0'),
('673','mainmenu','Style 4 - Red','style4','','styles/style4','index.php?option=com_djtabs&view=tabs','component','-2','649','2','10017','0','0000-00-00 00:00:00','0','1','','0','{"group_id":"4","theme":"-1","video_autopause":"","rows_number":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"djmegamenu-subtitle":"","djmegamenu-submenu_expand":"","djmegamenu-column_break":"0","djmegamenu-column_width":"","djmegamenu-module_pos":"","djmegamenu-module_style":"xhtml","djmegamenu-module_show_link":"0"}','158','159','0','*','0'),
('693','mainmenu','Column','column','','styles/column','','separator','1','649','2','0','0','0000-00-00 00:00:00','0','1','','0','{"menu_image":"","menu_text":1,"djmegamenu-subtitle":"","djmegamenu-column_break":"0","djmegamenu-column_width":"","djmegamenu-expand":"","djmegamenu-dropdown_dir":"","djmegamenu-bg_image":"","djmegamenu-bg_pos_hor":"right","djmegamenu-bg_pos_ver":"bottom","djmegamenu-module_pos":"dj-mega-styles0","djmegamenu-module_style":"xhtml","djmegamenu-module_show_link":"0","djmegamenu-accesskey":""}','160','161','0','*','0'),
('775','main','COM_DJTABS_THEMES','com-djtabs-themes','','com-djtabs/com-djtabs-themes','index.php?option=com_djtabs&view=themes','component','1','772','2','10017','0','0000-00-00 00:00:00','0','1','components/com_djtabs/assets/icon-16-themes.png','0','{}','204','205','0','','1');
INSERT INTO `#__menu` VALUES 
('774','main','COM_DJTABS_GROUPS','com-djtabs-groups','','com-djtabs/com-djtabs-groups','index.php?option=com_djtabs&view=groups','component','1','772','2','10017','0','0000-00-00 00:00:00','0','1','components/com_djtabs/assets/icon-16-category.png','0','{}','202','203','0','','1'),
('772','main','COM_DJTABS','com-djtabs','','com-djtabs','index.php?option=com_djtabs','component','1','1','1','10017','0','0000-00-00 00:00:00','0','1','components/com_djtabs/assets/icon-16.png','0','{}','199','206','0','','1'),
('773','main','COM_DJTABS_ITEMS','com-djtabs-items','','com-djtabs/com-djtabs-items','index.php?option=com_djtabs&view=items','component','1','772','2','10017','0','0000-00-00 00:00:00','0','1','components/com_djtabs/assets/icon-16-items.png','0','{}','200','201','0','','1'),
('771','main','COM_DJMEDIATOOLS_CATEGORIES','com-djmediatools-categories','','com-djmediatools/com-djmediatools-categories','index.php?option=com_djmediatools&view=categories','component','1','769','2','10009','0','0000-00-00 00:00:00','0','1','class:category','0','{}','196','197','0','','1'),
('770','main','COM_DJMEDIATOOLS_SLIDES','com-djmediatools-slides','','com-djmediatools/com-djmediatools-slides','index.php?option=com_djmediatools&view=items','component','1','769','2','10009','0','0000-00-00 00:00:00','0','1','components/com_djmediatools/assets/icon-16-menu-slides.png','0','{}','194','195','0','','1'),
('769','main','COM_DJMEDIATOOLS','com-djmediatools','','com-djmediatools','index.php?option=com_djmediatools','component','1','1','1','10009','0','0000-00-00 00:00:00','0','1','components/com_djmediatools/assets/icon-16-djmediatools.png','0','{}','193','198','0','','1'),
('768','main','com_associations','multilingual-associations','','multilingual-associations','index.php?option=com_associations','component','1','1','1','34','0','0000-00-00 00:00:00','0','1','class:associations','0','{}','191','192','0','*','1');

DROP TABLE IF EXISTS #__menu_types;
CREATE TABLE `#__menu_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) unsigned NOT NULL DEFAULT '0',
  `menutype` varchar(24) NOT NULL,
  `title` varchar(48) NOT NULL,
  `description` varchar(255) NOT NULL DEFAULT '',
  `client_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_menutype` (`menutype`)
) AUTO_INCREMENT=26 DEFAULT CHARSET=utf8;

INSERT INTO `#__menu_types` VALUES 
('3','0','topbar','Topbar','Links for major types of users','0'),
('4','0','mainmenu','Main Menu','','0'),
('13','0','layouts','Layouts','','0'),
('14','0','jcontent','J! Content','','0'),
('15','0','jotherpages','J! Other pages','','0'),
('18','0','djmediatools','DJ-MediaTools','','0'),
('19','0','djtabs','DJ-Tabs','','0'),
('20','0','articles','Articles','','0'),
('23','0','custompages','Custom pages','','0'),
('24','0','homesubmenu','Home submenu','','0');

DROP TABLE IF EXISTS #__messages;
CREATE TABLE `#__messages` (
  `message_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id_from` int(10) unsigned NOT NULL DEFAULT '0',
  `user_id_to` int(10) unsigned NOT NULL DEFAULT '0',
  `folder_id` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `date_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `state` tinyint(1) NOT NULL DEFAULT '0',
  `priority` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `subject` varchar(255) NOT NULL DEFAULT '',
  `message` mediumtext NOT NULL,
  PRIMARY KEY (`message_id`),
  KEY `useridto_state` (`user_id_to`,`state`)
) DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS #__messages_cfg;
CREATE TABLE `#__messages_cfg` (
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `cfg_name` varchar(100) NOT NULL DEFAULT '',
  `cfg_value` varchar(255) NOT NULL DEFAULT '',
  UNIQUE KEY `idx_user_var_name` (`user_id`,`cfg_name`)
) DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS #__modules;
CREATE TABLE `#__modules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `title` varchar(100) NOT NULL DEFAULT '',
  `note` varchar(255) NOT NULL DEFAULT '',
  `content` text NOT NULL,
  `ordering` int(11) NOT NULL DEFAULT '0',
  `position` varchar(50) NOT NULL DEFAULT '',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `module` varchar(50) DEFAULT NULL,
  `access` int(10) unsigned NOT NULL DEFAULT '0',
  `showtitle` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `params` mediumtext NOT NULL,
  `client_id` tinyint(4) NOT NULL DEFAULT '0',
  `language` char(7) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `published` (`published`,`access`),
  KEY `newsfeeds` (`module`,`published`),
  KEY `idx_language` (`language`)
) AUTO_INCREMENT=304 DEFAULT CHARSET=utf8;

INSERT INTO `#__modules` VALUES 
('2','0','Login','','','1','login','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_login','1','1','','1','*'),
('3','0','Popular Articles','','','3','cpanel','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_popular','3','1','{"count":"5","catid":"","user_id":"0","layout":"_:default","moduleclass_sfx":"","cache":"0","automatic_title":"1"}','1','*'),
('4','0','Recently Added Articles','','','4','cpanel','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_latest','3','1','{"count":"5","ordering":"c_dsc","catid":"","user_id":"0","layout":"_:default","moduleclass_sfx":"","cache":"0","automatic_title":"1"}','1','*'),
('8','0','Toolbar','','','1','toolbar','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_toolbar','3','1','','1','*'),
('9','0','Quick Icons','','','1','icon','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_quickicon','3','1','','1','*'),
('10','0','Logged-in Users','','','2','cpanel','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_logged','3','1','{"count":"5","name":"1","layout":"_:default","moduleclass_sfx":"","cache":"0","automatic_title":"1"}','1','*'),
('12','0','Admin Menu','','','1','menu','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_menu','3','1','{"layout":"","moduleclass_sfx":"","shownew":"1","showhelp":"1","cache":"0"}','1','*'),
('13','0','Admin Submenu','','','1','submenu','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_submenu','3','1','','1','*'),
('14','0','User Status','','','2','status','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_status','3','1','','1','*'),
('15','0','Title','','','1','title','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_title','3','1','','1','*'),
('52','380','Breadcrumbs','','','1','breadcrumbs','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_breadcrumbs','1','1','{"showHere":"1","showHome":"1","homeText":"Home","showLast":"1","separator":"","layout":"_:default","moduleclass_sfx":"","cache":"0","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}','0','*'),
('79','0','Multilanguage status','','','1','status','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','0','mod_multilangstatus','3','1','{"layout":"_:default","moduleclass_sfx":"","cache":"0"}','1','*'),
('86','0','Joomla Version','','','1','footer','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_version','3','1','{"format":"short","product":"1","layout":"_:default","moduleclass_sfx":"","cache":"0"}','1','*'),
('91','208','Top','','<p><strong>Module suffix:</strong> default module</p>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam imperdiet sagittis sapien, sit amet placerat lacus ultricies.</p>','2','top-1','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_custom','1','1','{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}','0','*'),
('92','209','Top','','<p><strong>Module suffix:</strong> color1-ms</p>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam imperdiet sagittis sapien, sit amet placerat lacus ultricies ultrices.</p>','1','top-2','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_custom','1','1','{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":" color1-ms","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}','0','*'),
('93','210','Top','','<p><strong>Module suffix:</strong> color2-ms</p>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam imperdiet sagittis sapien, sit amet placerat lacus ultricies ultrices.</p>','1','top-3','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_custom','1','1','{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":" color2-ms","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}','0','*'),
('94','211','Top','','<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam imperdiet sagittis sapien, sit amet placerat lacus ultricies ultrices.</p>','1','top-4','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_custom','1','1','{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}','0','*'),
('95','237','Left-column','','<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam imperdiet sagittis sapien, sit amet placerat lacus ultricies ultrices.</p>','8','left-column','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_custom','1','1','{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}','0','*'),
('96','238','Left-column','','<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam imperdiet sagittis sapien, sit amet placerat lacus ultricies ultrices.</p>','9','left-column','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_custom','1','1','{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}','0','*'),
('97','240','Left-column','','<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam imperdiet sagittis sapien, sit amet placerat lacus ultricies ultrices.</p>','11','left-column','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_custom','1','1','{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}','0','*'),
('98','241','Right-column','','<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam imperdiet sagittis sapien, sit amet placerat lacus ultricies ultrices.</p>','4','right-column','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_custom','1','1','{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}','0','*'),
('99','242','Right-column','','<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam imperdiet sagittis sapien, sit amet placerat lacus ultricies ultrices.</p>','9','right-column','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_custom','1','1','{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}','0','*'),
('100','243','Right-column','','<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam imperdiet sagittis sapien, sit amet placerat lacus ultricies ultrices.</p>','8','right-column','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_custom','1','1','{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}','0','*'),
('103','203','Content-top','','<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam imperdiet sagittis sapien, sit amet placerat lacus ultricies ultrices. Aliquam id nunc turpis. In et blandit arcu. Donec pharetra, mauris id consectetur pretium, eros nisl pharetra urna, ut pellentesque magna mi a leo.</p>','1','content-top','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_custom','1','1','{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}','0','*'),
('104','204','Content-Bottom','','<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam imperdiet sagittis sapien, sit amet placerat lacus ultricies ultrices. Aliquam id nunc turpis. In et blandit arcu. Donec pharetra, mauris id consectetur pretium, eros nisl pharetra urna, ut pellentesque magna mi a leo.</p>','1','content-bottom','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_custom','1','1','{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}','0','*'),
('109','230','Footer','','<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam imperdiet sagittis sapien, sit amet placerat lacus ultricies ultrices.</p>','1','footer-1','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_custom','1','1','{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}','0','*'),
('110','231','Footer','','<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam imperdiet sagittis sapien, sit amet placerat lacus ultricies ultrices.</p>','2','footer-2','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_custom','1','1','{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}','0','*'),
('111','232','Footer','','<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam imperdiet sagittis sapien, sit amet placerat lacus ultricies ultrices.</p>','1','footer-4','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_custom','1','1','{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}','0','*'),
('112','233','Header','','<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam imperdiet sagittis sapien, sit amet placerat lacus ultricies ultrices. Phasellus viverra commodo nulla, eget scelerisque lectus consectetur et. Curabitur commodo lectus nec lectus porta vestibulum. Pellentesque in rutrum nisl. Proin purus augue, volutpat a mattis id, mattis quis ligula. Nulla facilisi. Vestibulum tincidunt velit faucibus erat congue non viverra nulla pharetra. Suspendisse potenti. Ut est felis, volutpat luctus porta quis, tincidunt sed lorem.</p>','6','header','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_custom','1','1','{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"3","header_tag":"h3","header_class":"","style":"0"}','0','*'),
('114','292','Copyrights','','<p>JM Cleaning Company All Rights Reserved.</p>','1','copyrights','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_custom','1','1','{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}','0','*'),
('141','202','DJ-MegaMenu','','','3','top-menu-nav','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_djmegamenu','1','1','{"menu":"mainmenu","startLevel":"1","endLevel":"0","icons":"2","subtitles":"2","usenote":"0","fa":"1","theme":"_override","megabg":"#383838","megacolor":"#ffffff","megastcolor":"#999999","megabg_a":"#1681d1","megacolor_a":"#ffffff","megastcolor_a":"#a4c4f5","megasubbg":"#303030","megasubcolor":"#c3c3c3","megasubstcolor":"#666666","megasubbg_a":"#1681d1","megasubcolor_a":"#ffffff","megasubstcolor_a":"#a4c4f5","megamodcolor":"#d2d2d2","expand":"dropdown","dropdown_dir":"","column_width":"200","moo":"1","animation_in":"fadeInUp","animation_out":"fadeOutDown","animation_speed":"normal","openDelay":"250","closeDelay":"500","event":"mouseenter","wrapper":"jm-djmenu","fixed":"0","fixed_offset":"0","fixed_logo":"","fixed_logo_align":"right","wcag":"1","select":"2","mobiletheme":"light","width":"979","mobilebtnbg":"#434343","mobilebtncolor":"#e4e4e4","mobilebg":"#393939","mobilecolor":"#f8f8f8","mobilestcolor":"#888888","mobilebg_a":"#333333","mobilecolor_a":"#ffffff","mobilestcolor_a":"#aaaaaa","mobilesubbg":"#333333","mobilesubcolor":"#aeaeae","mobilesubstcolor":"#666666","mobilesubbg_a":"#2e2e2e","mobilesubcolor_a":"#e4e4e4","mobilesubstcolor_a":"#888888","mobilemodcolor":"#aeaeae","select_type":"button","accordion_pos":"static","accordion_align":"right","offcanvas_logo":"images\\/logo.png","offcanvas_effect":"3","offcanvas_topmod_style":"System-xhtml","offcanvas_botmod_style":"System-xhtml","accordion_collapsed":"0","moduleclass_sfx":"","layout":"_:default","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}','0','*'),
('148','265','Promotion','','<div class="jm-promo">\r\n<p><a href="#"> <img src="images/modules/icons/icon4.png" alt="" /> <span class="title">Dream to live clean?</span> </a></p>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit.</p>\r\n</div>','1','dj-mega-home2','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_custom','1','1','{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}','0','*'),
('152','239','Left-column','','<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam imperdiet sagittis sapien, sit amet placerat lacus ultricies ultrices.</p>','10','left-column','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_custom','1','1','{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}','0','*'),
('153','244','Right-column','','<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam imperdiet sagittis sapien, sit amet placerat lacus ultricies ultrices.</p>','5','right-column','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_custom','1','1','{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}','0','*'),
('167','226','Bottom','','<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam imperdiet sagittis sapien, sit amet placerat lacus ultricies ultrices.</p>','3','bottom-3','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_custom','1','1','{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}','0','*'),
('168','227','Bottom','','<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam imperdiet sagittis sapien, sit amet placerat lacus ultricies ultrices.</p>','4','bottom-4','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_custom','1','1','{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}','0','*'),
('169','228','Bottom','','<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam imperdiet sagittis sapien, sit amet placerat lacus ultricies ultrices.</p>','1','bottom-1','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_custom','1','1','{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}','0','*'),
('170','229','Bottom','','<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam imperdiet sagittis sapien, sit amet placerat lacus ultricies ultrices.</p>','2','bottom-2','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_custom','1','1','{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}','0','*'),
('176','324','Top-bar Guest','','','1','top-bar','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_menu','1','0','{"menutype":"topbar","base":"","startLevel":"1","endLevel":"0","showAllChildren":"1","tag_id":"","class_sfx":"","window_open":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}','0','*'),
('181','323','Logout','','','1','dj-offcanvas-top','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_login','2','0','{"pretext":"","posttext":"","login":"","logout":"","greeting":"1","name":"0","usesecure":"0","usetext":"0","layout":"_:default","moduleclass_sfx":"","cache":"0","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}','0','*'),
('192','287','Social','','<p class="jm-icons"><a class="jm-facebook" href="#"> </a> <a class="jm-link" href="#"> </a> <a class="jm-skype" href="#"> </a> <a class="jm-twitter" href="#"> </a> <a class="jm-google" href="#"> </a></p>','1','social','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_custom','1','0','{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}','0','*'),
('212','267','Layouts','','','1','dj-mega-subpage0','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_menu','1','1','{"menutype":"layouts","base":"","startLevel":"1","endLevel":"0","showAllChildren":"0","tag_id":"","class_sfx":"","window_open":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}','0','*'),
('214','269','J! Content','','','1','dj-mega-subpage1','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_menu','1','1','{"menutype":"jcontent","base":"","startLevel":"1","endLevel":"0","showAllChildren":"0","tag_id":"","class_sfx":"","window_open":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}','0','*'),
('215','270','J! Content','','','7','left-column','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_menu','1','1','{"menutype":"jcontent","base":"","startLevel":"1","endLevel":"0","showAllChildren":"1","tag_id":"","class_sfx":"","window_open":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}','0','*'),
('216','271','J! Other pages','','','1','dj-mega-subpage2','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_menu','1','1','{"menutype":"jotherpages","base":"","startLevel":"1","endLevel":"0","showAllChildren":"0","tag_id":"","class_sfx":"","window_open":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}','0','*'),
('217','272','J! Other pages','','','6','left-column','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_menu','1','1','{"menutype":"jotherpages","base":"","startLevel":"1","endLevel":"0","showAllChildren":"0","tag_id":"","class_sfx":"","window_open":"","layout":"_:default","moduleclass_sfx":"nav menu","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}','0','*'),
('222','277','DJ-MediaTools','','','1','dj-mega-extensions0','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_menu','1','1','{"menutype":"djmediatools","base":"","startLevel":"1","endLevel":"0","showAllChildren":"0","tag_id":"","class_sfx":"","window_open":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}','0','*'),
('223','278','DJ-MediaTools','','','5','left-column','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_menu','1','1','{"menutype":"djmediatools","base":"","startLevel":"1","endLevel":"0","showAllChildren":"0","tag_id":"","class_sfx":"","window_open":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}','0','*'),
('231','289','Footer','','<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam imperdiet sagittis sapien, sit amet placerat lacus ultricies ultrices.</p>','1','footer-3','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_custom','1','1','{"prepare_content":"1","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}','0','*'),
('233','291','Header 4','','','5','header','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_djmediatools','1','0','{"catid":"17","layout":"_:slider","slider_type":"up","desc_effect":"","sort_by":"","link_image":"","lightbox":"","image_width":"1170","image_height":"470","resizing":"","quality":"","thumb_width":"","thumb_height":"","visible_images":"1","space_between_images":"0","max_images":"","show_thumbs":"","tab_indicator":"","tab_width":"","tab_height":"","tab_position":"","show_title":"","show_desc":"0","show_readmore":"","readmore_text":"","link_title":"","link_desc":"","limit_desc":"60","autoplay":"","pause_autoplay":"","show_buttons":"","show_arrows":"","show_custom_nav":"","effect":"","effect_type":"","duration":"","delay":"","lag":"","preload":"","desc_position":"","desc_width":"570","desc_bottom":"0","desc_horizontal":"0","left_arrow":"","right_arrow":"","play_button":"","pause_button":"","arrows_top":"","arrows_horizontal":"","custom_nav_pos":"bottomin","custom_nav_align":"right","loader_position":"","moduleclass_sfx":" margin-ms","cache":"1","cache_time":"900","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}','0','*');
INSERT INTO `#__modules` VALUES 
('238','306','Contact Details','','<div class="jm-bottom-box-custom">\r\n<div class="icon"><a href="index.php?option=com_contact&amp;view=contact&amp;id=1&amp;Itemid=580"><img src="images/modules/icons/icon-phone.png" alt="" /></a></div>\r\n<div class="content"><span class="title jm-color">Make an appointment</span><span class="desc">+44 7983 462 854</span></div>\r\n</div>\r\n<div class="jm-bottom-box-custom">\r\n<div class="icon"><a href="index.php?option=com_contact&amp;view=contact&amp;id=1&amp;Itemid=580"><img src="images/modules/icons/icon-mail.png" alt="" /></a></div>\r\n<div class="content"><span class="title jm-color">Send us a message</span><span class="desc">info@joomla-monster.com</span></div>\r\n</div>\r\n<div class="jm-bottom-box-custom">\r\n<div class="icon"><a href="index.php?option=com_contact&amp;view=contact&amp;id=1&amp;Itemid=580"><img src="images/modules/icons/icon-direction.png" alt="" /></a></div>\r\n<div class="content"><span class="title jm-color">Visit us</span><span class="desc">7 Green Lane, London</span></div>\r\n</div>','12','bottom-1','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_custom','1','0','{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"3","header_tag":"h3","header_class":"","style":"0"}','0','*'),
('241','311','Other articles','','','1','right-column','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_articles_category','1','1','{"mode":"normal","show_on_article_page":"1","show_front":"show","count":"5","category_filtering_type":"1","catid":["86"],"show_child_category_articles":"0","levels":"1","author_filtering_type":"1","created_by":[""],"author_alias_filtering_type":"1","created_by_alias":[""],"excluded_articles":"","date_filtering":"off","date_field":"a.created","start_date_range":"","end_date_range":"","relative_date":"30","article_ordering":"a.title","article_ordering_direction":"ASC","article_grouping":"none","article_grouping_direction":"ksort","month_year_format":"F Y","link_titles":"1","show_date":"0","show_date_field":"created","show_date_format":"Y-m-d H:i:s","show_category":"0","show_hits":"0","show_author":"0","show_introtext":"0","introtext_limit":"100","show_readmore":"0","show_readmore_title":"1","readmore_limit":"15","layout":"_:default","moduleclass_sfx":"nav menu","owncache":"1","cache_time":"900","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}','0','*'),
('242','313','Trust & Security','','<div class="jm-box-vertical"><a class="jm-panel icon1" href="index.php?option=com_content&amp;view=article&amp;id=103&amp;catid=86&amp;Itemid=601"><span class="jm-icon"> </span><span class="jm-cell"><span class="title">Professional Housekeepers</span><span class="subtitle">lorem ipsum dolor</span></span></a> <a class="jm-panel icon2" href="index.php?option=com_content&amp;view=article&amp;id=104&amp;catid=86&amp;Itemid=601"><span class="jm-icon"> </span><span class="jm-cell"> <span class="title">Insured</span><span class="subtitle">lorem ipsum dolor</span></span> </a> <a class="jm-panel icon3" href="index.php?option=com_content&amp;view=article&amp;id=109&amp;catid=86&amp;Itemid=601"><span class="jm-icon"> </span><span class="jm-cell"> <span class="title">Background-checked</span><span class="subtitle">lorem ipsum dolor</span></span> </a> <a class="jm-panel icon4" href="index.php?option=com_content&amp;view=article&amp;id=113&amp;catid=86&amp;Itemid=601"><span class="jm-icon"> </span><span class="jm-cell"> <span class="title">5 Star Reviews</span><span class="subtitle">lorem ipsum dolor</span> </span></a></div>','6','right-column','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_custom','1','1','{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}','0','*'),
('244','317','Articles Tabs','','','1','content-bottom','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_djtabs','1','0','{"group_id":"4","theme":"-1","layout":"tabs","moduleclass_sfx":"","video_autopause":"","accordion_display":"1","tabs_hidden":"2","rows_number":"1","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}','0','*'),
('245','321','Our Videos','','','7','right-column','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_djtabs','1','0','{"group_id":"5","theme":"-1","layout":"accordion","moduleclass_sfx":"","video_autopause":"","accordion_display":"1","tabs_hidden":"2","rows_number":"1","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}','0','*'),
('246','325','Search','','','2','top-menu-nav','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_search','1','0','{"label":"","width":"20","text":"","button":"1","button_pos":"right","imagebutton":"0","button_text":"","opensearch":"1","opensearch_title":"","set_itemid":"0","layout":"_:default","moduleclass_sfx":" search-ms visible-desktop","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}','0','*'),
('248','327','DJ-Tabs','','','1','dj-mega-extensions1','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_menu','1','1','{"menutype":"djtabs","base":"","startLevel":"1","endLevel":"0","showAllChildren":"0","tag_id":"","class_sfx":"","window_open":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}','0','*'),
('249','328','DJ-Tabs','','','4','left-column','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_menu','1','1','{"menutype":"djtabs","base":"","startLevel":"1","endLevel":"0","showAllChildren":"0","tag_id":"","class_sfx":"","window_open":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}','0','*'),
('253','332','Contact Map','','','3','right-column','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_wrapper','1','0','{"url":"https:\\/\\/www.google.com\\/maps\\/embed?pb=!1m18!1m12!1m3!1d2483.41937820287!2d-0.34182460000000275!3d51.50552159999999!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x48760d65371d245f%3A0xeb46a0f260e9224!2s7+Green+Ln!5e0!3m2!1spl!2spl!4v1401265709524","add":"1","scrolling":"no","width":"100%","height":"450","height_auto":"0","frameborder":"0","target":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}','0','*'),
('254','333','Contact Info','','<p style="text-align: right;"><img src="images/logo.png" alt="" /></p>\r\n<p style="margin: 15px 0 0; text-align: right;">7 Green Lane<br />London, United Kingdom</p>','1','right-column','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_custom','1','0','{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}','0','*'),
('260','342','Latest News','','','1','dj-mega-home1','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_articles_category','1','1','{"mode":"normal","show_on_article_page":"1","show_front":"show","count":"3","category_filtering_type":"1","catid":["86"],"show_child_category_articles":"0","levels":"1","author_filtering_type":"1","created_by":[""],"author_alias_filtering_type":"1","created_by_alias":[""],"excluded_articles":"","date_filtering":"off","date_field":"a.created","start_date_range":"","end_date_range":"","relative_date":"30","article_ordering":"a.title","article_ordering_direction":"ASC","article_grouping":"none","article_grouping_direction":"ksort","month_year_format":"F Y","link_titles":"1","show_date":"0","show_date_field":"created","show_date_format":"Y-m-d H:i:s","show_category":"0","show_hits":"0","show_author":"0","show_introtext":"1","introtext_limit":"60","show_readmore":"0","show_readmore_title":"0","readmore_limit":"15","layout":"_:default","moduleclass_sfx":"","owncache":"1","cache_time":"900","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}','0','*'),
('263','347','Offcanvas Button','','<p><a class="toggle-nav menu"><span class="icon-align-justify"></span></a></p>','1','top-menu-nav','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_custom','1','1','{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":" visible-desktop","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}','0','*'),
('264','348','Offcanvas Info','','<p>Assign modules on offcanvas module position to make them visible in the sidebar.</p>','1','offcanvas','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_custom','1','0','{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}','0','*'),
('265','349','Main Menu','','','3','offcanvas','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_menu','1','0','{"menutype":"mainmenu","base":"","startLevel":"1","endLevel":"0","showAllChildren":"0","tag_id":"","class_sfx":"","window_open":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}','0','*'),
('266','350','Our site is coming soon','','<p>Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque<br />laudantium eaque ipsa quae ab illo inventore veritatis et quasi architecto.</p>','0','coming-soon','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_custom','1','1','{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}','0','*'),
('268','353','Domestic Cleaning','','<div class="jm-box"><a href="index.php?option=com_content&amp;view=article&amp;id=104:treat-yourself-to-a-clean-healthy-home&amp;catid=86&amp;Itemid=601"> <span class="icon"> <img src="images/modules/icons/icon1.png" alt="" /> </span> <span class="title"> Domestic Cleaning </span> </a></div>','9','bottom-1','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_custom','1','0','{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":" color1-ms margin-ms","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"3","header_tag":"h3","header_class":"","style":"0"}','0','*'),
('274','359','Articles Accordion Front','','','10','bottom-1','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_djtabs','1','0','{"group_id":"7","theme":"-1","layout":"accordion","moduleclass_sfx":"","video_autopause":"","accordion_display":"2","tabs_hidden":"2","rows_number":"1","module_tag":"div","bootstrap_size":"6","header_tag":"h3","header_class":"","style":"0"}','0','*'),
('275','366','Custom pages','','','0','dj-mega-subpage3','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_menu','1','1','{"menutype":"custompages","base":"","startLevel":"1","endLevel":"0","showAllChildren":"0","tag_id":"","class_sfx":"","window_open":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}','0','*'),
('279','379','Home views','','','0','dj-mega-home0','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_menu','1','1','{"menutype":"homesubmenu","base":"","startLevel":"1","endLevel":"0","showAllChildren":"0","tag_id":"","class_sfx":"","window_open":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}','0','*'),
('280','381','Header 1','','','2','header','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_djmediatools','1','0','{"catid":"17","layout":"_:slideshow","slider_type":"","desc_effect":"up","sort_by":"","link_image":"","lightbox":"","image_width":"1170","image_height":"448","resizing":"toHeight","quality":"","thumb_width":"","thumb_height":"","visible_images":"1","space_between_images":"0","max_images":"","show_thumbs":"","tab_indicator":"","tab_width":"","tab_height":"","tab_position":"","show_title":"","show_desc":"","show_readmore":"0","readmore_text":"","link_title":"","link_desc":"","limit_desc":"60","autoplay":"","pause_autoplay":"","show_buttons":"","show_arrows":"","show_custom_nav":"","effect":"","effect_type":"","duration":"","delay":"","lag":"","preload":"","desc_position":"","desc_width":"","desc_bottom":"0","desc_horizontal":"0","left_arrow":"","right_arrow":"","play_button":"","pause_button":"","arrows_top":"185","arrows_horizontal":"","custom_nav_pos":"topin","custom_nav_align":"right","loader_position":"","moduleclass_sfx":" margin-ms","cache":"1","cache_time":"900","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}','0','*'),
('281','382','Header 3','','','4','header','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_djmediatools','1','0','{"catid":"17","layout":"_:nivoSlider","slider_type":"","desc_effect":"","sort_by":"","link_image":"","lightbox":"","image_width":"1170","image_height":"470","resizing":"toHeight","quality":"","thumb_width":"","thumb_height":"","visible_images":"1","space_between_images":"0","max_images":"","show_thumbs":"","tab_indicator":"","tab_width":"","tab_height":"","tab_position":"","show_title":"","show_desc":"","show_readmore":"0","readmore_text":"","link_title":"","link_desc":"","limit_desc":"60","autoplay":"","pause_autoplay":"","show_buttons":"","show_arrows":"","show_custom_nav":"","effect":"","effect_type":"","duration":"","delay":"","lag":"","preload":"","desc_position":"","desc_width":"570","desc_bottom":"0","desc_horizontal":"0","left_arrow":"","right_arrow":"","play_button":"","pause_button":"","arrows_top":"","arrows_horizontal":"","custom_nav_pos":"","custom_nav_align":"center","loader_position":"","moduleclass_sfx":" margin-ms","cache":"1","cache_time":"900","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}','0','*'),
('282','383','Header 2','','','3','header','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_djmediatools','1','0','{"catid":"17","layout":"_:tabber","slider_type":"","desc_effect":"","sort_by":"","link_image":"","lightbox":"","image_width":"870","image_height":"355","resizing":"","quality":"","thumb_width":"98","thumb_height":"98","visible_images":"1","space_between_images":"0","max_images":"","show_thumbs":"","tab_indicator":"","tab_width":"300","tab_height":"118","tab_position":"","show_title":"","show_desc":"0","show_readmore":"0","readmore_text":"","link_title":"","link_desc":"","limit_desc":"60","autoplay":"","pause_autoplay":"","show_buttons":"","show_arrows":"","show_custom_nav":"0","effect":"","effect_type":"","duration":"","delay":"","lag":"","preload":"","desc_position":"","desc_width":"570","desc_bottom":"0","desc_horizontal":"0","left_arrow":"","right_arrow":"","play_button":"","pause_button":"","arrows_top":"","arrows_horizontal":"","custom_nav_pos":"bottomin","custom_nav_align":"center","loader_position":"","moduleclass_sfx":" margin-ms","cache":"1","cache_time":"900","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}','0','*'),
('283','384','Example module','','','1','djtab-module','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_articles_news','1','1','{"catid":["86"],"image":"0","item_title":"1","link_titles":"1","item_heading":"h4","showLastSeparator":"1","readmore":"0","count":"3","ordering":"a.publish_up","direction":"1","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}','0','*'),
('284','385','Custom boxes - Front','','<div class="jm-box-vertical"><a class="jm-panel icon1" href="index.php?option=com_content&amp;view=article&amp;id=103&amp;catid=86&amp;Itemid=601"><span class="jm-icon"> </span><span class="jm-cell"><span class="title">Professional Housekeepers</span><span class="subtitle">lorem ipsum dolor</span></span></a> <a class="jm-panel icon2" href="index.php?option=com_content&amp;view=article&amp;id=104&amp;catid=86&amp;Itemid=601"><span class="jm-icon"> </span><span class="jm-cell"> <span class="title">Insured</span><span class="subtitle">lorem ipsum dolor</span></span> </a> <a class="jm-panel icon3" href="index.php?option=com_content&amp;view=article&amp;id=109t&amp;catid=86&amp;Itemid=601"><span class="jm-icon"> </span><span class="jm-cell"> <span class="title">Background-checked</span><span class="subtitle">lorem ipsum dolor</span></span> </a> <a class="jm-panel icon4" href="index.php?option=com_content&amp;view=article&amp;id=113&amp;catid=86&amp;Itemid=601"><span class="jm-icon"> </span><span class="jm-cell"> <span class="title">5 Star Reviews</span><span class="subtitle">lorem ipsum dolor</span> </span></a></div>','1','djtab-front','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_custom','1','0','{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}','0','*'),
('285','386','Promo Offcanvas','','<div class="jm-promo">\r\n<p><a href="#"> <img src="images/modules/icons/icon4.png" alt="" /> <span class="title">Dream to live clean?</span> </a></p>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt.</p>\r\n</div>','4','offcanvas','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_custom','1','0','{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}','0','*'),
('286','387','Tags','','','5','offcanvas','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_tags_popular','1','0','{"maximum":"6","timeframe":"alltime","order_value":"count","order_direction":"1","display_count":0,"no_results_text":"0","minsize":1,"maxsize":2,"layout":"_:default","moduleclass_sfx":"","owncache":"1","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}','0','*'),
('287','399','Banner','','<p><a href="index.php?option=com_content&amp;view=article&amp;id=86&amp;Itemid=564"><img src="images/modules/banner.jpg" alt="" /></a></p>','10','right-column','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_custom','1','0','{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}','0','*'),
('288','400','Office Cleaning','','<div class="jm-box"><a href="index.php?option=com_content&amp;view=article&amp;id=103:you-work-enough-already&amp;catid=86&amp;Itemid=601"> <span class="icon"> <img src="images/modules/icons/icon2.png" alt="" /> </span> <span class="title">Office Cleaning</span> </a></div>','8','bottom-1','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_custom','1','0','{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":" color2-ms margin-ms","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"3","header_tag":"h3","header_class":"","style":"0"}','0','*'),
('289','401','Ironing Services','','<div class="jm-box"><a href="index.php?option=com_content&amp;view=article&amp;id=122:dream-to-live-clean&amp;catid=86&amp;Itemid=601"> <span class="icon"> <img src="images/modules/icons/icon3.png" alt="" /> </span> <span class="title">Ironing Services</span> </a></div>','7','bottom-1','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_custom','1','0','{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":" color1-ms margin-ms","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"3","header_tag":"h3","header_class":"","style":"0"}','0','*'),
('290','402','End of tenancy cleaning','','<div class="jm-box"><a href="index.php?option=com_content&amp;view=article&amp;id=113:you-deserve-a-break&amp;catid=86&amp;Itemid=601"> <span class="icon"> <img src="images/modules/icons/icon4.png" alt="" /> </span> <span class="title">End of tenancy cleaning</span> </a></div>','6','bottom-1','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_custom','1','0','{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":" color2-ms margin-ms","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"3","header_tag":"h3","header_class":"","style":"0"}','0','*'),
('291','403','Spring cleaning','','<div class="jm-box"><a href="index.php?option=com_content&amp;view=article&amp;id=109:enjoy-your-time-off&amp;catid=86&amp;Itemid=601"> <span class="icon"> <img src="images/modules/icons/icon5.png" alt="" /> </span> <span class="title">Spring cleaning</span> </a></div>','5','bottom-1','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_custom','1','0','{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":" color2-ms margin-ms","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"3","header_tag":"h3","header_class":"","style":"0"}','0','*'),
('292','404','Window cleaning','','<div class="jm-box"><a href="index.php?option=com_content&amp;view=article&amp;id=104:treat-yourself-to-a-clean-healthy-home&amp;catid=86&amp;Itemid=601"> <span class="icon"> <img src="images/modules/icons/icon6.png" alt="" /> </span> <span class="title">Window cleaning</span> </a></div>','4','bottom-1','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_custom','1','0','{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":" color1-ms margin-ms","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"3","header_tag":"h3","header_class":"","style":"0"}','0','*'),
('293','405','Carpet cleaning','','<div class="jm-box"><a href="index.php?option=com_content&amp;view=article&amp;id=103:you-work-enough-already&amp;catid=86&amp;Itemid=601"> <span class="icon"> <img src="images/modules/icons/icon7.png" alt="" /> </span> <span class="title">Carpet cleaning</span> </a></div>','3','bottom-1','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_custom','1','0','{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":" color2-ms margin-ms","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"3","header_tag":"h3","header_class":"","style":"0"}','0','*'),
('294','406','Steam cleaning','','<div class="jm-box"><a href="index.php?option=com_content&amp;view=article&amp;id=122:dream-to-live-clean&amp;catid=86&amp;Itemid=601"> <span class="icon"> <img src="images/modules/icons/icon8.png" alt="" /> </span> <span class="title">Steam cleaning</span> </a></div>','2','bottom-1','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_custom','1','0','{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":" color1-ms margin-ms","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"3","header_tag":"h3","header_class":"","style":"0"}','0','*'),
('295','407','Guarantee','','<div class="jm-bottom-box-custom"><img src="images/modules/guarantee.png" alt="" /></div>','11','bottom-1','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_custom','1','0','{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"3","header_tag":"h3","header_class":"","style":"0"}','0','*'),
('296','408','WE WORK FOR','','','1','footer-1','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_djmediatools','1','1','{"catid":"22","layout":"_:mslider","slider_type":"","desc_effect":"","sort_by":"","link_image":"","lightbox":"","image_width":"","image_height":"220","resizing":"no","quality":"","thumb_width":"","thumb_height":"","visible_images":"6","space_between_images":"30","max_images":"","skip":"","show_thumbs":"","tab_indicator":"","tab_width":"","tab_height":"","tab_position":"","show_title":"0","show_desc":"0","show_readmore":"0","readmore_text":"","link_title":"","link_desc":"","limit_desc":"","autoplay":"","pause_autoplay":"0","show_buttons":"0","show_arrows":"0","show_custom_nav":"0","effect":"","effect_type":"","duration":"","delay":"","lag":"","preload":"","desc_position":"","desc_width":"","desc_bottom":"","desc_horizontal":"","left_arrow":"","right_arrow":"","play_button":"","pause_button":"","arrows_top":"","arrows_horizontal":"","custom_nav_pos":"","custom_nav_align":"","loader_position":"","moduleclass_sfx":"","cache":"1","cache_time":"900","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}','0','*'),
('297','412','Make an appointment','','<div class="jm-bottom-box-custom">\r\n<div class="icon"><a href="index.php?option=com_contact&amp;view=contact&amp;id=1&amp;Itemid=580"><img src="images/modules/icons/icon-phone.png" alt="" /></a></div>\r\n<div class="content"><span class="title jm-color">Make an appointment</span><span class="desc">+44 7983 462 854</span></div>\r\n</div>','13','bottom-1','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_custom','1','0','{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"4","header_tag":"h3","header_class":"","style":"0"}','0','*'),
('298','413','Send us a message','','<div class="jm-bottom-box-custom">\r\n<div class="icon"><a href="index.php?option=com_contact&amp;view=contact&amp;id=1&amp;Itemid=580"><img src="images/modules/icons/icon-mail.png" alt="" /></a></div>\r\n<div class="content"><span class="title jm-color">Send us a message</span><span class="desc">info@joomla-monster.com</span></div>\r\n</div>','14','bottom-1','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_custom','1','0','{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"4","header_tag":"h3","header_class":"","style":"0"}','0','*'),
('299','414','Visit us','','<div class="jm-bottom-box-custom">\r\n<div class="icon"><a href="index.php?option=com_contact&amp;view=contact&amp;id=1&amp;Itemid=580"><img src="images/modules/icons/icon-direction.png" alt="" /></a></div>\r\n<div class="content"><span class="title jm-color">Visit us</span><span class="desc">7 Green Lane, London</span></div>\r\n</div>','15','bottom-1','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_custom','1','0','{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"4","header_tag":"h3","header_class":"","style":"0"}','0','*'),
('300','415','Template styles','','<p style="text-align: center;">Use theme customizer that is available at the left side of the screen to modify the template colors.</p>\r\n<p><img style="display: block; margin-left: auto; margin-right: auto;" src="images/features/theme.png" alt="" /></p>','0','dj-mega-styles0','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_custom','1','1','{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}','0','*'),
('301','416','DJ-MegaMenu - Mobile Menu Button','','','0','','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','0','mod_djmegamenu_button','1','1','','0','*'),
('302','417','Search (2)','','','1','dj-offcanvas-top','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_search','1','0','{"label":"","width":"17","text":"","button":"1","button_pos":"right","imagebutton":"0","button_text":"»","opensearch":"1","opensearch_title":"","set_itemid":"0","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}','0','*'),
('303','418','Topbar Logout','','','1','top-bar','0','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00','1','mod_login','2','0','{"pretext":"","posttext":"","login":"","logout":"","greeting":"1","name":"0","usesecure":"0","usetext":"0","layout":"_:default","moduleclass_sfx":" visible-desktop","cache":"0","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}','0','*');

DROP TABLE IF EXISTS #__modules_menu;
CREATE TABLE `#__modules_menu` (
  `moduleid` int(11) NOT NULL DEFAULT '0',
  `menuid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`moduleid`,`menuid`)
) DEFAULT CHARSET=utf8;

INSERT INTO `#__modules_menu` VALUES 
('1','0'),
('1','101'),
('2','0'),
('3','0'),
('4','0'),
('6','0'),
('7','0'),
('8','0'),
('9','0'),
('10','0'),
('12','0'),
('13','0'),
('14','0'),
('15','0'),
('19','-463'),
('19','-462'),
('19','-433'),
('19','-432'),
('19','-431'),
('19','-430'),
('19','-429'),
('19','-427'),
('19','-400'),
('19','-399'),
('19','-296'),
('19','-244'),
('19','-243'),
('19','-242'),
('19','-234'),
('22','231'),
('22','234'),
('22','238'),
('22','242'),
('22','243'),
('22','244'),
('22','296'),
('22','399'),
('22','400'),
('25','294'),
('32','309'),
('45','303'),
('45','471'),
('52','-673'),
('52','-672'),
('52','-671'),
('52','-670'),
('52','-661'),
('52','-660'),
('52','-659'),
('52','-658');
INSERT INTO `#__modules_menu` VALUES 
('52','-649'),
('52','-470'),
('57','238'),
('57','427'),
('57','429'),
('57','430'),
('57','431'),
('57','432'),
('57','433'),
('57','462'),
('57','463'),
('79','0'),
('86','0'),
('87','227'),
('87','229'),
('87','249'),
('87','251'),
('87','252'),
('87','253'),
('87','254'),
('87','255'),
('87','256'),
('87','257'),
('87','259'),
('87','260'),
('87','262'),
('87','263'),
('87','265'),
('87','266'),
('87','267'),
('87','270'),
('87','271'),
('87','272'),
('87','274'),
('87','275'),
('87','276'),
('87','402'),
('87','403'),
('87','404'),
('87','405'),
('87','406'),
('87','409'),
('87','452'),
('87','466'),
('87','471'),
('88','300'),
('88','301'),
('88','302'),
('88','303'),
('88','304');
INSERT INTO `#__modules_menu` VALUES 
('88','305'),
('88','306'),
('88','307'),
('88','309'),
('88','310'),
('88','311'),
('88','312'),
('88','313'),
('88','324'),
('88','325'),
('88','326'),
('88','410'),
('88','411'),
('88','412'),
('88','416'),
('88','417'),
('88','418'),
('88','443'),
('88','447'),
('88','459'),
('88','467'),
('88','471'),
('89','238'),
('89','427'),
('89','429'),
('89','430'),
('89','431'),
('89','432'),
('89','433'),
('89','462'),
('89','463'),
('91','564'),
('91','565'),
('91','566'),
('91','567'),
('91','568'),
('91','569'),
('92','564'),
('92','565'),
('92','566'),
('92','567'),
('92','568'),
('92','569'),
('93','564'),
('93','565'),
('93','566'),
('93','567'),
('93','568'),
('93','569'),
('94','564');
INSERT INTO `#__modules_menu` VALUES 
('94','565'),
('94','566'),
('94','567'),
('94','568'),
('94','569'),
('95','564'),
('95','565'),
('95','566'),
('95','567'),
('96','564'),
('96','565'),
('96','566'),
('96','567'),
('97','564'),
('97','565'),
('97','566'),
('97','567'),
('98','564'),
('98','565'),
('98','566'),
('98','568'),
('99','564'),
('99','565'),
('99','566'),
('99','568'),
('100','564'),
('100','565'),
('100','566'),
('100','568'),
('103','564'),
('103','565'),
('103','566'),
('103','567'),
('103','568'),
('103','569'),
('104','564'),
('104','565'),
('104','566'),
('104','567'),
('104','568'),
('104','569'),
('109','564'),
('109','565'),
('109','566'),
('109','567'),
('109','568'),
('109','569'),
('110','564'),
('110','565'),
('110','566');
INSERT INTO `#__modules_menu` VALUES 
('110','567'),
('110','568'),
('110','569'),
('111','564'),
('111','565'),
('111','566'),
('111','567'),
('111','568'),
('111','569'),
('112','564'),
('112','565'),
('112','566'),
('112','567'),
('112','568'),
('112','569'),
('114','0'),
('121','0'),
('141','0'),
('148','0'),
('152','564'),
('152','565'),
('152','566'),
('152','567'),
('153','564'),
('153','565'),
('153','566'),
('153','568'),
('167','564'),
('167','565'),
('167','566'),
('167','567'),
('167','568'),
('167','569'),
('168','564'),
('168','565'),
('168','566'),
('168','567'),
('168','568'),
('168','569'),
('169','564'),
('169','565'),
('169','566'),
('169','567'),
('169','568'),
('169','569'),
('170','564'),
('170','565'),
('170','566'),
('170','567'),
('170','568');
INSERT INTO `#__modules_menu` VALUES 
('170','569'),
('176','564'),
('176','565'),
('176','566'),
('176','567'),
('176','568'),
('176','569'),
('176','583'),
('178','0'),
('181','0'),
('192','0'),
('194','-569'),
('194','-568'),
('194','-567'),
('194','-566'),
('194','-565'),
('194','-564'),
('195','-569'),
('195','-568'),
('195','-567'),
('195','-566'),
('195','-565'),
('195','-564'),
('212','0'),
('214','0'),
('215','575'),
('215','576'),
('215','577'),
('215','578'),
('215','579'),
('215','581'),
('216','0'),
('217','572'),
('217','573'),
('218','0'),
('219','570'),
('219','571'),
('220','0'),
('221','580'),
('222','0'),
('223','497'),
('223','498'),
('223','499'),
('223','500'),
('223','501'),
('223','502'),
('223','503'),
('223','504'),
('223','582'),
('223','612');
INSERT INTO `#__modules_menu` VALUES 
('223','648'),
('231','564'),
('231','565'),
('231','566'),
('231','567'),
('231','568'),
('231','569'),
('233','661'),
('238','470'),
('238','658'),
('238','659'),
('238','660'),
('238','661'),
('241','574'),
('241','601'),
('241','654'),
('241','655'),
('241','662'),
('241','665'),
('241','666'),
('241','667'),
('241','668'),
('241','669'),
('242','574'),
('242','601'),
('242','654'),
('242','655'),
('242','662'),
('242','665'),
('242','666'),
('242','667'),
('242','668'),
('242','669'),
('244','574'),
('244','601'),
('244','654'),
('244','655'),
('245','574'),
('245','601'),
('245','654'),
('245','655'),
('245','662'),
('245','665'),
('245','666'),
('245','667'),
('245','668'),
('245','669'),
('246','0'),
('247','0'),
('248','0');
INSERT INTO `#__modules_menu` VALUES 
('249','607'),
('249','608'),
('253','580'),
('254','580'),
('260','0'),
('263','0'),
('264','0'),
('265','0'),
('266','0'),
('268','470'),
('268','649'),
('268','658'),
('268','659'),
('268','660'),
('268','661'),
('268','670'),
('268','671'),
('268','672'),
('268','673'),
('274','470'),
('274','649'),
('274','658'),
('274','659'),
('274','660'),
('274','661'),
('275','0'),
('279','0'),
('280','470'),
('280','649'),
('280','658'),
('281','660'),
('282','659'),
('283','0'),
('284','0'),
('285','0'),
('286','0'),
('287','574'),
('287','601'),
('287','654'),
('287','655'),
('287','662'),
('287','665'),
('287','666'),
('287','667'),
('287','668'),
('287','669'),
('288','470'),
('288','649'),
('288','658'),
('288','659');
INSERT INTO `#__modules_menu` VALUES 
('288','660'),
('288','661'),
('288','670'),
('288','671'),
('288','672'),
('288','673'),
('289','470'),
('289','649'),
('289','658'),
('289','659'),
('289','660'),
('289','661'),
('289','670'),
('289','671'),
('289','672'),
('289','673'),
('290','470'),
('290','649'),
('290','658'),
('290','659'),
('290','660'),
('290','661'),
('290','670'),
('290','671'),
('290','672'),
('290','673'),
('291','470'),
('291','649'),
('291','658'),
('291','659'),
('291','660'),
('291','661'),
('291','670'),
('291','671'),
('291','672'),
('291','673'),
('292','470'),
('292','649'),
('292','658'),
('292','659'),
('292','660'),
('292','661'),
('292','670'),
('292','671'),
('292','672'),
('292','673'),
('293','470'),
('293','649'),
('293','658'),
('293','659');
INSERT INTO `#__modules_menu` VALUES 
('293','660'),
('293','661'),
('293','670'),
('293','671'),
('293','672'),
('293','673'),
('294','470'),
('294','649'),
('294','658'),
('294','659'),
('294','660'),
('294','661'),
('294','670'),
('294','671'),
('294','672'),
('294','673'),
('295','470'),
('295','658'),
('295','659'),
('295','660'),
('295','661'),
('296','470'),
('296','649'),
('296','658'),
('296','659'),
('296','660'),
('296','661'),
('297','574'),
('297','601'),
('297','654'),
('297','655'),
('298','574'),
('298','601'),
('298','654'),
('298','655'),
('299','574'),
('299','601'),
('299','649'),
('299','654'),
('299','655'),
('300','0'),
('302','0'),
('303','0');

DROP TABLE IF EXISTS #__newsfeeds;
CREATE TABLE `#__newsfeeds` (
  `catid` int(11) NOT NULL DEFAULT '0',
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL DEFAULT '',
  `alias` varchar(400) NOT NULL DEFAULT '',
  `link` varchar(2048) NOT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `numarticles` int(10) unsigned NOT NULL DEFAULT '1',
  `cache_time` int(10) unsigned NOT NULL DEFAULT '3600',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `rtl` tinyint(4) NOT NULL DEFAULT '0',
  `access` int(10) unsigned NOT NULL DEFAULT '0',
  `language` char(7) NOT NULL DEFAULT '',
  `params` mediumtext NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT '0',
  `metakey` mediumtext NOT NULL,
  `metadesc` mediumtext NOT NULL,
  `metadata` mediumtext NOT NULL,
  `xreference` varchar(50) NOT NULL DEFAULT '',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `description` mediumtext NOT NULL,
  `version` int(10) unsigned NOT NULL DEFAULT '1',
  `hits` int(10) unsigned NOT NULL DEFAULT '0',
  `images` mediumtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`published`),
  KEY `idx_catid` (`catid`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_language` (`language`),
  KEY `idx_xreference` (`xreference`)
) DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS #__overrider;
CREATE TABLE `#__overrider` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `constant` varchar(255) NOT NULL,
  `string` mediumtext NOT NULL,
  `file` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) AUTO_INCREMENT=2859 DEFAULT CHARSET=utf8;

INSERT INTO `#__overrider` VALUES 
('1','ERROR_NOT_ENABLED','Operation not permitted','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_akeeba.ini'),
('2','ERROR_INVALID_KEY','Access denied','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_akeeba.ini'),
('3','EMAIL_SUBJECT_OK','Akeeba Backup has taken a new backup','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_akeeba.ini'),
('4','EMAIL_SUBJECT_ERROR','Akeeba Backup was unable to take a backup','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_akeeba.ini'),
('5','EMAIL_BODY_OK','Akeeba Backup has completed backing up your site using the front-end backup feature. You may visit the site\'s administrator section to download the backup.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_akeeba.ini'),
('6','EMAIL_BODY_INFO','The new backup was taken with profile #%s. It consists of %s part(s). The full list of files of this backup set is the following:','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_akeeba.ini'),
('7','EMAIL_BODY_ERROR','Akeeba Backup was unable to complete backing up your site using the front-end backup feature. You should visit the site\'s administrator section to review the log and resolve this issue. The last error message was:','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_akeeba.ini'),
('8','LIGHT_HEADER','Akeeba Backup Lite Mode','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_akeeba.ini'),
('9','LIGHT_HEADER_DONE','Backup Finished','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_akeeba.ini'),
('10','LIGHT_TEXT_DONE','Akeeba Backup just finished backing up your site. You can administer your backup files through the administrator section of your site.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_akeeba.ini'),
('11','LIGHT_TEXT_ERROR','Backup failed. Error:','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_akeeba.ini'),
('12','LIGHT_TEXT_ERRORPOST','You have to log in the administrator back-end of your site to view the log and resolve this error.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_akeeba.ini'),
('13','LIGHT_LABEL_PROFILE','Profile','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_akeeba.ini'),
('14','LIGHT_LABEL_SECRET','Secret word','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_akeeba.ini'),
('15','LIGHT_LABEL_SUBMIT','Start backup','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_akeeba.ini'),
('16','LIGHT_DOMAIN_INIT','Initializing','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_akeeba.ini'),
('17','LIGHT_DOMAIN_INSTALLER','Copying installer files','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_akeeba.ini'),
('18','LIGHT_DOMAIN_PACKDB','Backing up database','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_akeeba.ini'),
('19','LIGHT_DOMAIN_PACKING','Backing up files','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_akeeba.ini'),
('20','LIGHT_DOMAIN_FINALE','Finishing up','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_akeeba.ini'),
('21','COM_AKEEBA_EMAIL_POSTPROCESSING_FAILED','Post-processing (upload to remote storage) has FAILED.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_akeeba.ini'),
('22','COM_AKEEBA_EMAIL_POSTPROCESSING_SUCCESS','Post-processing (upload to remote storage) was successful.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_akeeba.ini'),
('23','COM_CONTACT_ADDRESS','Address','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_contact.ini'),
('24','COM_CONTACT_ARTICLES_HEADING','Contact\'s articles','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_contact.ini'),
('25','COM_CONTACT_CAPTCHA_LABEL','Captcha','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_contact.ini'),
('26','COM_CONTACT_CAPTCHA_DESC','Type in the textbox what you see in the image.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_contact.ini'),
('27','COM_CONTACT_CAT_NUM','# of Contacts :','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_contact.ini'),
('28','COM_CONTACT_CONTACT_EMAIL_A_COPY_DESC','Sends a copy of the message to the address you have supplied.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_contact.ini'),
('29','COM_CONTACT_CONTACT_EMAIL_A_COPY_LABEL','Send copy to yourself','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_contact.ini'),
('30','COM_CONTACT_CONTACT_EMAIL_NAME_DESC','Your name','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_contact.ini'),
('31','COM_CONTACT_CONTACT_EMAIL_NAME_LABEL','Name','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_contact.ini'),
('32','COM_CONTACT_CONTACT_ENTER_MESSAGE_DESC','Enter your message here.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_contact.ini'),
('33','COM_CONTACT_CONTACT_ENTER_MESSAGE_LABEL','Message','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_contact.ini'),
('34','COM_CONTACT_CONTACT_ENTER_VALID_EMAIL','Please enter a valid email address.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_contact.ini'),
('35','COM_CONTACT_FILTER_LABEL','Filter field','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_contact.ini'),
('36','COM_CONTACT_FILTER_SEARCH_DESC','Contact Filter Search','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_contact.ini'),
('37','COM_CONTACT_CONTACT_MESSAGE_SUBJECT_DESC','Enter the subject of your message here .','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_contact.ini'),
('38','COM_CONTACT_CONTACT_MESSAGE_SUBJECT_LABEL','Subject','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_contact.ini'),
('39','COM_CONTACT_CONTACT_SEND','Send Email','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_contact.ini'),
('40','COM_CONTACT_COPYSUBJECT_OF','Copy of: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_contact.ini'),
('41','COM_CONTACT_COPYTEXT_OF','This is a copy of the following message you sent to %s via %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_contact.ini'),
('42','COM_CONTACT_COUNT','Contact count:','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_contact.ini'),
('43','COM_CONTACT_COUNTRY','Country','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_contact.ini'),
('44','COM_CONTACT_DEFAULT_PAGE_TITLE','Contacts','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_contact.ini'),
('45','COM_CONTACT_DETAILS','Contact','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_contact.ini'),
('46','COM_CONTACT_DOWNLOAD_INFORMATION_AS','Download information as:','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_contact.ini'),
('47','COM_CONTACT_EMAIL_BANNEDTEXT','The %s of your email contains banned text.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_contact.ini'),
('48','COM_CONTACT_EMAIL_DESC','Email for contact','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_contact.ini'),
('49','COM_CONTACT_EMAIL_FORM','Contact Form','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_contact.ini'),
('50','COM_CONTACT_EMAIL_LABEL','Email','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_contact.ini');
INSERT INTO `#__overrider` VALUES 
('51','COM_CONTACT_EMAIL_THANKS','Thank you for your email.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_contact.ini'),
('52','COM_CONTACT_ENQUIRY_TEXT','This is an enquiry email via %s from:','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_contact.ini'),
('53','COM_CONTACT_ERROR_CONTACT_NOT_FOUND','Contact not found','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_contact.ini'),
('54','COM_CONTACT_FAX','Fax','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_contact.ini'),
('55','COM_CONTACT_FAX_NUMBER','Fax: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_contact.ini'),
('56','COM_CONTACT_FORM_LABEL','Send an email. All fields with an * are required.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_contact.ini'),
('57','COM_CONTACT_FORM_NC','Please make sure the form is complete and valid.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_contact.ini'),
('58','COM_CONTACT_IMAGE_DETAILS','Contact-image','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_contact.ini'),
('59','COM_CONTACT_LINKS','Links','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_contact.ini'),
('60','COM_CONTACT_MAILENQUIRY','%s Enquiry','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_contact.ini'),
('61','COM_CONTACT_MOBILE','Mobile','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_contact.ini'),
('62','COM_CONTACT_MOBILE_NUMBER','Mobile: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_contact.ini'),
('63','COM_CONTACT_NO_ARTICLES','No articles to display','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_contact.ini'),
('64','COM_CONTACT_NO_CONTACTS','There are no Contacts to display','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_contact.ini'),
('65','COM_CONTACT_NOT_MORE_THAN_ONE_EMAIL_ADDRESS','You cannot enter more than one email address.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_contact.ini'),
('66','COM_CONTACT_OPTIONAL','(optional)','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_contact.ini'),
('67','COM_CONTACT_OTHER_INFORMATION','Miscellaneous Information','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_contact.ini'),
('68','COM_CONTACT_POSITION','Position','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_contact.ini'),
('69','COM_CONTACT_PROFILE','Profile','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_contact.ini'),
('70','COM_CONTACT_PROFILE_HEADING','Contact profile','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_contact.ini'),
('71','COM_CONTACT_SELECT_CONTACT','Select a contact:','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_contact.ini'),
('72','COM_CONTACT_STATE','State','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_contact.ini'),
('73','COM_CONTACT_SUBURB','Suburb','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_contact.ini'),
('74','COM_CONTACT_TELEPHONE','Phone','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_contact.ini'),
('75','COM_CONTACT_TELEPHONE_NUMBER','Phone: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_contact.ini'),
('76','COM_CONTACT_VCARD','vCard','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_contact.ini'),
('77','COM_CONTENT_ACCESS_DELETE_DESC','Inherited state for <strong>delete actions</strong> on this article and the calculated state based on the menu selection.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_content.ini'),
('78','COM_CONTENT_ACCESS_EDITSTATE_DESC','Inherited state for <strong>edit state actions</strong> on this article and the calculated state based on the menu selection.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_content.ini'),
('79','COM_CONTENT_ACCESS_EDIT_DESC','Inherited state for <strong>edit actions</strong> on this article and the calculated state based on the menu selection.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_content.ini'),
('80','COM_CONTENT_ARTICLE_HITS','Hits: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_content.ini'),
('81','COM_CONTENT_ARTICLE_INFO','Details','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_content.ini'),
('82','COM_CONTENT_ARTICLE_VOTE_SUCCESS','Thank You for rating this Article.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_content.ini'),
('83','COM_CONTENT_ARTICLE_VOTE_FAILURE','You already rated this Article today!','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_content.ini'),
('84','COM_CONTENT_AUTHOR_FILTER_LABEL','Author Filter','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_content.ini'),
('85','COM_CONTENT_CATEGORY','Category: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_content.ini'),
('86','COM_CONTENT_CHECKED_OUT_BY','Checked out by %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_content.ini'),
('87','COM_CONTENT_CREATE_ARTICLE','Submit new article','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_content.ini'),
('88','COM_CONTENT_CREATED_DATE','Created Date','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_content.ini'),
('89','COM_CONTENT_CREATED_DATE_ON','Created: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_content.ini'),
('90','COM_CONTENT_EDIT_ITEM','Edit Article','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_content.ini'),
('91','COM_CONTENT_ERROR_ARTICLE_NOT_FOUND','Article not found','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_content.ini'),
('92','COM_CONTENT_ERROR_LOGIN_TO_VIEW_ARTICLE','Please login to view the article','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_content.ini'),
('93','COM_CONTENT_ERROR_CATEGORY_NOT_FOUND','Category not found','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_content.ini'),
('94','COM_CONTENT_ERROR_PARENT_CATEGORY_NOT_FOUND','Parent category not found','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_content.ini'),
('95','COM_CONTENT_FEED_READMORE','Read More...','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_content.ini'),
('96','COM_CONTENT_FILTER_SEARCH_DESC','Content Filter Search','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_content.ini'),
('97','COM_CONTENT_FORM_EDIT_ARTICLE','Edit an article','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_content.ini'),
('98','COM_CONTENT_HEADING_TITLE','Title','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_content.ini'),
('99','COM_CONTENT_HITS_FILTER_LABEL','Hits Filter','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_content.ini'),
('100','COM_CONTENT_INTROTEXT','Article must have some content.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_content.ini');
INSERT INTO `#__overrider` VALUES 
('101','COM_CONTENT_INVALID_RATING','Article Rating: Invalid Rating: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_content.ini'),
('102','COM_CONTENT_LAST_UPDATED','Last Updated: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_content.ini'),
('103','COM_CONTENT_METADATA','Metadata','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_content.ini'),
('104','COM_CONTENT_MODIFIED_DATE','Modified Date','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_content.ini'),
('105','COM_CONTENT_MONTH','Month','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_content.ini'),
('106','COM_CONTENT_MORE_ARTICLES','More Articles...','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_content.ini'),
('107','COM_CONTENT_NEW_ARTICLE','New Article','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_content.ini'),
('108','COM_CONTENT_NO_ARTICLES','There are no articles in this category. If subcategories display on this page, they may contain articles.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_content.ini'),
('109','COM_CONTENT_NONE','None','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_content.ini'),
('110','COM_CONTENT_NUM_ITEMS','Article Count:','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_content.ini'),
('111','COM_CONTENT_ON_NEW_CONTENT','A new Article has been submitted by \'%1$s\' entitled \'%2$s\'.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_content.ini'),
('112','COM_CONTENT_ORDERING','Ordering:<br />New articles default to the first position in the Category. The ordering can be changed in backend.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_content.ini'),
('113','COM_CONTENT_PAGEBREAK_DOC_TITLE','Page break','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_content.ini'),
('114','COM_CONTENT_PAGEBREAK_INSERT_BUTTON','Insert Page Break','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_content.ini'),
('115','COM_CONTENT_PAGEBREAK_TITLE','Page Title:','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_content.ini'),
('116','COM_CONTENT_PAGEBREAK_TOC','Table of Contents Alias:','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_content.ini'),
('117','COM_CONTENT_PARENT','Parent Category: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_content.ini'),
('118','COM_CONTENT_PUBLISHED_DATE','Published Date','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_content.ini'),
('119','COM_CONTENT_PUBLISHED_DATE_ON','Published: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_content.ini'),
('120','COM_CONTENT_PUBLISHING','Publishing','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_content.ini'),
('121','COM_CONTENT_READ_MORE','Read more: ','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_content.ini'),
('122','COM_CONTENT_READ_MORE_TITLE','Read more...','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_content.ini'),
('123','COM_CONTENT_REGISTER_TO_READ_MORE','Register to read more...','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_content.ini'),
('124','COM_CONTENT_SAVE_SUCCESS','Article successfully saved','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_content.ini'),
('125','COM_CONTENT_SELECT_AN_ARTICLE','Select an Article','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_content.ini'),
('126','COM_CONTENT_SUBMIT_SAVE_SUCCESS','Article successfully submitted','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_content.ini'),
('127','COM_CONTENT_TITLE_FILTER_LABEL','Title Filter','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_content.ini'),
('128','COM_CONTENT_WRITTEN_BY','Written by %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_content.ini'),
('129','COM_CONTENT_FIELD_FULL_DESC','Image for the single article display','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_content.ini'),
('130','COM_CONTENT_FIELD_FULL_LABEL','Full article image','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_content.ini'),
('131','COM_CONTENT_FIELD_IMAGE_DESC','The image to be displayed','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_content.ini'),
('132','COM_CONTENT_FIELD_IMAGE_ALT_DESC','Alternative text used for visitors without access to images. Replaced with caption text if it is present.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_content.ini'),
('133','COM_CONTENT_FIELD_IMAGE_ALT_LABEL','Alt text','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_content.ini'),
('134','COM_CONTENT_FIELD_IMAGE_CAPTION_DESC','Caption attached to the image','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_content.ini'),
('135','COM_CONTENT_FIELD_IMAGE_CAPTION_LABEL','Caption','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_content.ini'),
('136','COM_CONTENT_FIELD_INTRO_DESC','Image for the intro text layouts such as blogs and featured','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_content.ini'),
('137','COM_CONTENT_FIELD_INTRO_LABEL','Intro Image','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_content.ini'),
('138','COM_CONTENT_FIELD_URLC_LABEL','Link C','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_content.ini'),
('139','COM_CONTENT_FIELD_URL_DESC','Link for display. Must be a full URL.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_content.ini'),
('140','COM_CONTENT_FIELD_URLA_LABEL','Link A','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_content.ini'),
('141','COM_CONTENT_FIELD_URLA_LINK_TEXT_LABEL','Link A Text','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_content.ini'),
('142','COM_CONTENT_FIELD_URLB_LABEL','Link B','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_content.ini'),
('143','COM_CONTENT_FIELD_URL_LINK_TEXT_DESC','Text to display for the link','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_content.ini'),
('144','COM_CONTENT_FIELD_URLB_LINK_TEXT_LABEL','Link B Text','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_content.ini'),
('145','COM_CONTENT_FIELD_URLC_LINK_TEXT_LABEL','Link C Text','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_content.ini'),
('146','COM_CONTENT_FLOAT_DESC','Controls placement of the image','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_content.ini'),
('147','COM_CONTENT_FLOAT_LABEL','Image Float','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_content.ini'),
('148','COM_CONTENT_FLOAT_INTRO_LABEL','Intro image float','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_content.ini'),
('149','COM_CONTENT_FLOAT_FULLTEXT_LABEL','Full text image float','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_content.ini'),
('150','COM_CONTENT_LEFT','Left','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_content.ini');
INSERT INTO `#__overrider` VALUES 
('151','COM_CONTENT_RIGHT','Right','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_content.ini'),
('152','COM_CONTENT_FIELD_URL_LINK_TEXT_LABEL','Link Text','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_content.ini'),
('153','COM_CONTENT_IMAGES_AND_URLS','Images and Links','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_content.ini'),
('154','COM_FINDER','Smart Search','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_finder.ini'),
('155','COM_FINDER_ADVANCED_SEARCH_TOGGLE','Advanced Search','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_finder.ini'),
('156','COM_FINDER_ADVANCED_TIPS','<p>Here are a few examples of how you can use the search feature:</p><p>Entering <span class="term">this and that</span> into the search form will return results containing both "this" and "that".</p><p>Entering <span class="term">this not that</span> into the search form will return results containing "this" and not "that".</p><p>Entering <span class="term">this or that</span> into the search form will return results containing either "this" or "that".</p><p>Entering <span class="term">"this and that"</span> (with quotes) into the search form will return results containing the exact phrase "this and that".</p><p>Search results can also be filtered using a variety of criteria. Select one or more filters below to get started.</p>','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_finder.ini'),
('157','COM_FINDER_DEFAULT_PAGE_TITLE','Search Results','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_finder.ini'),
('158','COM_FINDER_FILTER_BRANCH_LABEL','Search by %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_finder.ini'),
('159','COM_FINDER_FILTER_DATE_BEFORE','Before','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_finder.ini'),
('160','COM_FINDER_FILTER_DATE_EXACTLY','Exactly','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_finder.ini'),
('161','COM_FINDER_FILTER_DATE_AFTER','After','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_finder.ini'),
('162','COM_FINDER_FILTER_DATE1','Start Date','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_finder.ini'),
('163','COM_FINDER_FILTER_DATE1_DESC','Enter a date in YYYY-MM-DD format','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_finder.ini'),
('164','COM_FINDER_FILTER_DATE2','End Date','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_finder.ini'),
('165','COM_FINDER_FILTER_DATE2_DESC','Enter a date in YYYY-MM-DD format','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_finder.ini'),
('166','COM_FINDER_FILTER_SELECT_ALL_LABEL','Search All','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_finder.ini'),
('167','COM_FINDER_FILTER_WHEN_AFTER','After','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_finder.ini'),
('168','COM_FINDER_FILTER_WHEN_BEFORE','Before','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_finder.ini'),
('169','COM_FINDER_QUERY_END_DATE','ending date <span class="when">%s</span> <span class="date">%s</span>','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_finder.ini'),
('170','COM_FINDER_QUERY_OPERATOR_AND','and','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_finder.ini'),
('171','COM_FINDER_QUERY_OPERATOR_OR','or','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_finder.ini'),
('172','COM_FINDER_QUERY_OPERATOR_NOT','not','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_finder.ini'),
('173','COM_FINDER_QUERY_FILTER_BRANCH_VENUE','venue','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_finder.ini'),
('174','COM_FINDER_QUERY_START_DATE','beginning date <span class="when">%s</span> <span class="date">%s</span>','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_finder.ini'),
('175','COM_FINDER_QUERY_TAXONOMY_NODE','with <span class="node">%s</span> as <span class="branch">%s</span> ','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_finder.ini'),
('176','COM_FINDER_QUERY_TOKEN_EXCLUDED','<span class="term">%s</span> should be excluded','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_finder.ini'),
('177','COM_FINDER_QUERY_TOKEN_GLUE',', and ','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_finder.ini'),
('178','COM_FINDER_QUERY_TOKEN_INTERPRETED','Assuming %s, the following results were found.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_finder.ini'),
('179','COM_FINDER_QUERY_TOKEN_OPTIONAL','<span class="term">%s</span> is optional','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_finder.ini'),
('180','COM_FINDER_QUERY_TOKEN_REQUIRED','<span class="term">%s</span> is required','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_finder.ini'),
('181','COM_FINDER_SEARCH_NO_RESULTS_BODY','No search results could be found for query: %s.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_finder.ini'),
('182','COM_FINDER_SEARCH_NO_RESULTS_BODY_MULTILANG','No search results (in English-UK) could be found for query: %s.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_finder.ini'),
('183','COM_FINDER_SEARCH_NO_RESULTS_HEADING','No Results Found','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_finder.ini'),
('184','COM_FINDER_SEARCH_RESULTS_OF','Results <strong>%s</strong> - <strong>%s</strong> of <strong>%s</strong>','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_finder.ini'),
('185','COM_FINDER_SEARCH_SIMILAR','Did you mean: %s?','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_finder.ini'),
('186','COM_FINDER_SEARCH_TERMS','Search Terms:','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_finder.ini'),
('187','COM_MAILTO','Mailto','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_mailto.ini'),
('188','COM_MAILTO_CANCEL','Cancel','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_mailto.ini'),
('189','COM_MAILTO_CLOSE_WINDOW','Close Window','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_mailto.ini'),
('190','COM_MAILTO_EMAIL_ERR_NOINFO','Please provide a valid email address.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_mailto.ini'),
('191','COM_MAILTO_EMAIL_INVALID','The address \'%s\' does not appear to be a valid email address.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_mailto.ini'),
('192','COM_MAILTO_EMAIL_MSG','This is an email from (%s) sent by %s (%s). You may also find the following link interesting: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_mailto.ini'),
('193','COM_MAILTO_EMAIL_NOT_SENT','Email could not be sent.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_mailto.ini'),
('194','COM_MAILTO_EMAIL_SENT','Email was sent successfully.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_mailto.ini'),
('195','COM_MAILTO_EMAIL_TO','Email to','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_mailto.ini'),
('196','COM_MAILTO_EMAIL_TO_A_FRIEND','Email this link to a friend.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_mailto.ini'),
('197','COM_MAILTO_LINK_IS_MISSING','Link is missing','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_mailto.ini'),
('198','COM_MAILTO_SEND','Send','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_mailto.ini'),
('199','COM_MAILTO_SENDER','Sender','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_mailto.ini'),
('200','COM_MAILTO_SENT_BY','Item sent by','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_mailto.ini');
INSERT INTO `#__overrider` VALUES 
('201','COM_MAILTO_SUBJECT','Subject','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_mailto.ini'),
('202','COM_MAILTO_YOUR_EMAIL','Your Email','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_mailto.ini'),
('203','COM_MEDIA_ALIGN','Align','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_media.ini'),
('204','COM_MEDIA_ALIGN_DESC','If \'Not Set\', the alignment is defined by the class \'.img_caption.none\'. Usually to get the image centred on the page.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_media.ini'),
('205','COM_MEDIA_BROWSE_FILES','Browse files','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_media.ini'),
('206','COM_MEDIA_CAPTION','Caption','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_media.ini'),
('207','COM_MEDIA_CAPTION_DESC','If set to \'Yes\', the Image Title will be used as caption.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_media.ini'),
('208','COM_MEDIA_CLEAR_LIST','Clear List','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_media.ini'),
('209','COM_MEDIA_CONFIGURATION','Media Manager Options','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_media.ini'),
('210','COM_MEDIA_CREATE_FOLDER','Create Folder','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_media.ini'),
('211','COM_MEDIA_CURRENT_PROGRESS','Current progress','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_media.ini'),
('212','COM_MEDIA_DESCFTP','To upload, change and delete media files, Joomla! will most likely need your FTP account details. Please enter them in the form fields below.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_media.ini'),
('213','COM_MEDIA_DESCFTPTITLE','FTP Login Details','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_media.ini'),
('214','COM_MEDIA_DETAIL_VIEW','Detail View','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_media.ini'),
('215','COM_MEDIA_DIRECTORY','Directory','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_media.ini'),
('216','COM_MEDIA_DIRECTORY_UP','Directory Up','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_media.ini'),
('217','COM_MEDIA_ERROR_BAD_REQUEST','Bad Request','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_media.ini'),
('218','COM_MEDIA_ERROR_FILE_EXISTS','File already exists','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_media.ini'),
('219','COM_MEDIA_ERROR_UNABLE_TO_CREATE_FOLDER_WARNDIRNAME','Unable to create directory. Directory name must only contain alphanumeric characters and no spaces.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_media.ini'),
('220','COM_MEDIA_ERROR_UNABLE_TO_DELETE',' Unable to delete:&#160;','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_media.ini'),
('221','COM_MEDIA_ERROR_UNABLE_TO_DELETE_FILE_WARNFILENAME','Unable to delete:&#160;%s. File name must only contain alphanumeric characters and no spaces.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_media.ini'),
('222','COM_MEDIA_ERROR_UNABLE_TO_DELETE_FOLDER_NOT_EMPTY','Unable to delete:&#160;%s. Folder is not empty!','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_media.ini'),
('223','COM_MEDIA_ERROR_UNABLE_TO_DELETE_FOLDER_WARNDIRNAME','Unable to delete:&#160;%s. Directory name must only contain alphanumeric characters and no spaces.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_media.ini'),
('224','COM_MEDIA_ERROR_UNABLE_TO_UPLOAD_FILE','Unable to upload file.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_media.ini'),
('225','COM_MEDIA_ERROR_UPLOAD_INPUT','Please input a file for upload','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_media.ini'),
('226','COM_MEDIA_ERROR_WARNFILENAME','File name must only contain alphanumeric characters and no spaces.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_media.ini'),
('227','COM_MEDIA_ERROR_WARNFILETOOLARGE','This file is too large to upload.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_media.ini'),
('228','COM_MEDIA_ERROR_WARNFILETYPE','This file type is not supported.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_media.ini'),
('229','COM_MEDIA_ERROR_WARNIEXSS','Possible IE XSS Attack found.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_media.ini'),
('230','COM_MEDIA_ERROR_WARNINVALID_IMG','Not a valid image.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_media.ini'),
('231','COM_MEDIA_ERROR_WARNINVALID_MIME','Illegal or invalid mime type detected.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_media.ini'),
('232','COM_MEDIA_ERROR_WARNNOTADMIN','Uploaded file is not an image file and you are not a manager or higher.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_media.ini'),
('233','COM_MEDIA_ERROR_WARNNOTEMPTY','Not empty!','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_media.ini'),
('234','COM_MEDIA_FIELD_CHECK_MIME_DESC','Use MIME Magic or Fileinfo to attempt to verify files. Try disabling this if you get invalid mime type errors','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_media.ini'),
('235','COM_MEDIA_FIELD_CHECK_MIME_LABEL','Check MIME Types','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_media.ini'),
('236','COM_MEDIA_FIELD_ENABLE_FLASH_UPLOADER_DESC','Flash uploader lets upload multiple files at the same time. It may not work on your settings','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_media.ini'),
('237','COM_MEDIA_FIELD_ENABLE_FLASH_UPLOADER_LABEL','Enable flash uploader','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_media.ini'),
('238','COM_MEDIA_FIELD_IGNORED_EXTENSIONS_DESC','Ignored file extensions for MIME type checking and restricted uploads','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_media.ini'),
('239','COM_MEDIA_FIELD_IGNORED_EXTENSIONS_LABEL','Ignored Extensions','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_media.ini'),
('240','COM_MEDIA_FIELD_ILLEGAL_MIME_TYPES_DESC','A comma separated list of illegal MIME types for upload (blacklist)','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_media.ini'),
('241','COM_MEDIA_FIELD_ILLEGAL_MIME_TYPES_LABEL','Illegal MIME Types','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_media.ini'),
('242','COM_MEDIA_FIELD_LEGAL_EXTENSIONS_DESC',' Extensions (file types) you are allowed to upload (comma separated).','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_media.ini'),
('243','COM_MEDIA_FIELD_LEGAL_EXTENSIONS_LABEL','Legal Extensions (File Types)','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_media.ini'),
('244','COM_MEDIA_FIELD_LEGAL_IMAGE_EXTENSIONS_DESC',' Image Extensions (file types) you are allowed to upload (comma separated). These are used to check for valid image headers.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_media.ini'),
('245','COM_MEDIA_FIELD_LEGAL_IMAGE_EXTENSIONS_LABEL','Legal Image Extensions (File Types)','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_media.ini'),
('246','COM_MEDIA_FIELD_LEGAL_MIME_TYPES_DESC','A comma separated list of legal MIME types for upload','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_media.ini'),
('247','COM_MEDIA_FIELD_LEGAL_MIME_TYPES_LABEL','Legal MIME Types','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_media.ini'),
('248','COM_MEDIA_FIELD_MAXIMUM_SIZE_DESC','The maximum size for an upload (in bytes). Use zero for no limit. Note: your server has a maximum limit.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_media.ini'),
('249','COM_MEDIA_FIELD_MAXIMUM_SIZE_LABEL','Maximum Size','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_media.ini'),
('250','COM_MEDIA_FIELD_PATH_FILE_FOLDER_DESC','Enter here the path to the file folder relative to root','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_media.ini');
INSERT INTO `#__overrider` VALUES 
('251','COM_MEDIA_FIELD_PATH_FILE_FOLDER_LABEL','Path to file folder','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_media.ini'),
('252','COM_MEDIA_FIELD_PATH_IAMGE_FOLDER_DESC','Enter here the path to the image folder relative to root','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_media.ini'),
('253','COM_MEDIA_FIELD_PATH_IMAGE_FOLDER_LABEL','Path to image folder','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_media.ini'),
('254','COM_MEDIA_FIELD_RESTRICT_UPLOADS_DESC','Restrict uploads for lower than manager users to just images if Fileinfo or MIME Magic isn\'t installed.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_media.ini'),
('255','COM_MEDIA_FIELD_RESTRICT_UPLOADS_LABEL','Restrict Uploads','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_media.ini'),
('256','COM_MEDIA_FILES','Files','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_media.ini'),
('257','COM_MEDIA_FILESIZE','File size','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_media.ini'),
('258','COM_MEDIA_FOLDER','Folder','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_media.ini'),
('259','COM_MEDIA_FOLDERS','Folders','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_media.ini'),
('260','COM_MEDIA_IMAGE_DESCRIPTION','Image Description','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_media.ini'),
('261','COM_MEDIA_IMAGE_URL','Image URL','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_media.ini'),
('262','COM_MEDIA_INSERT','Insert','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_media.ini'),
('263','COM_MEDIA_INSERT_IMAGE','Insert Image','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_media.ini'),
('264','COM_MEDIA_MAXIMUM_SIZE','Maximum Size','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_media.ini'),
('265','COM_MEDIA_MEDIA','Media','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_media.ini'),
('266','COM_MEDIA_NAME','Image Name','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_media.ini'),
('267','COM_MEDIA_NO_IMAGES_FOUND','No Images Found','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_media.ini'),
('268','COM_MEDIA_NOT_SET','Not Set','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_media.ini'),
('269','COM_MEDIA_OVERALL_PROGRESS','Overall Progress','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_media.ini'),
('270','COM_MEDIA_PIXEL_DIMENSIONS','Pixel Dimensions (W x H)','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_media.ini'),
('271','COM_MEDIA_START_UPLOAD','Start Upload','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_media.ini'),
('272','COM_MEDIA_THUMBNAIL_VIEW','Thumbnail View','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_media.ini'),
('273','COM_MEDIA_TITLE','Image Title','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_media.ini'),
('274','COM_MEDIA_UP','Up','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_media.ini'),
('275','COM_MEDIA_UPLOAD','Upload','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_media.ini'),
('276','COM_MEDIA_UPLOAD_COMPLETE','Upload Complete','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_media.ini'),
('277','COM_MEDIA_UPLOAD_FILE','Upload file','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_media.ini'),
('278','COM_MEDIA_UPLOAD_FILES','Upload files (Maximum Size: %s MB)','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_media.ini'),
('279','COM_MEDIA_UPLOAD_FILES_NOLIMIT','Upload files (No maximum size)','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_media.ini'),
('280','COM_MEDIA_UPLOAD_SUCCESSFUL','Upload Successful','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_media.ini'),
('281','COM_MESSAGES_ERR_SEND_FAILED','The user has locked their mailbox. Message failed.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_messages.ini'),
('282','COM_MESSAGES_NEW_MESSAGE_ARRIVED','A new private message has arrived from %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_messages.ini'),
('283','COM_MESSAGES_PLEASE_LOGIN','Please log in to %s to read your message.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_messages.ini'),
('284','COM_NEWSFEEDS_CACHE_DIRECTORY_UNWRITABLE','The cache directory is unwritable. The news feed can\'t be displayed. Please contact a site administrator.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_newsfeeds.ini'),
('285','COM_NEWSFEEDS_CAT_NUM','# of Newsfeeds :','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_newsfeeds.ini'),
('286','COM_NEWSFEEDS_DEFAULT_PAGE_TITLE','News Feeds','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_newsfeeds.ini'),
('287','COM_NEWSFEEDS_ERROR_FEED_NOT_FOUND','Error. Feed not found.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_newsfeeds.ini'),
('288','COM_NEWSFEEDS_ERRORS_FEED_NOT_RETRIEVED','Error. Feed could not be retrieved.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_newsfeeds.ini'),
('289','COM_NEWSFEEDS_FEED_LINK','Feed Link','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_newsfeeds.ini'),
('290','COM_NEWSFEEDS_FEED_NAME','Feed Name','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_newsfeeds.ini'),
('291','COM_NEWSFEEDS_FILTER_LABEL','Filter field','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_newsfeeds.ini'),
('292','COM_NEWSFEEDS_FILTER_SEARCH_DESC','Newsfeed Filter Search','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_newsfeeds.ini'),
('293','COM_NEWSFEEDS_NO_ARTICLES','No Articles for this News Feed','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_newsfeeds.ini'),
('294','COM_NEWSFEEDS_NUM_ARTICLES','# Articles','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_newsfeeds.ini'),
('295','COM_NEWSFEEDS_NUM_ARTICLES_COUNT','# Articles: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_newsfeeds.ini'),
('296','COM_SEARCH_ALL_WORDS','All words','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_search.ini'),
('297','COM_SEARCH_ALPHABETICAL','Alphabetical','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_search.ini'),
('298','COM_SEARCH_ANY_WORDS','Any words','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_search.ini'),
('299','COM_SEARCH_ERROR_ENTERKEYWORD','Enter a search keyword','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_search.ini'),
('300','COM_SEARCH_ERROR_IGNOREKEYWORD','One or more common words were ignored in the search.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_search.ini');
INSERT INTO `#__overrider` VALUES 
('301','COM_SEARCH_ERROR_SEARCH_MESSAGE','Search term must be a minimum of %1$s characters and a maximum of %2$s characters.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_search.ini'),
('302','COM_SEARCH_EXACT_PHRASE','Exact Phrase','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_search.ini'),
('303','COM_SEARCH_FIELD_SEARCH_AREAS_DESC','Show the search areas checkboxes','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_search.ini'),
('304','COM_SEARCH_FIELD_SEARCH_AREAS_LABEL','Use Search Areas','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_search.ini'),
('305','COM_SEARCH_FOR','Search for:','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_search.ini'),
('306','COM_SEARCH_MOST_POPULAR','Most Popular','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_search.ini'),
('307','COM_SEARCH_NEWEST_FIRST','Newest First','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_search.ini'),
('308','COM_SEARCH_OLDEST_FIRST','Oldest First','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_search.ini'),
('309','COM_SEARCH_ORDERING','Ordering:','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_search.ini'),
('310','COM_SEARCH_SEARCH','Search','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_search.ini'),
('311','COM_SEARCH_SEARCH_AGAIN','Search Again','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_search.ini'),
('312','COM_SEARCH_SEARCH_KEYWORD','Search Keyword:','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_search.ini'),
('313','COM_SEARCH_SEARCH_KEYWORD_N_RESULTS_1','<strong>Total: One result found.</strong>','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_search.ini'),
('314','COM_SEARCH_SEARCH_KEYWORD_N_RESULTS','<strong>Total: %s results found.</strong>','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_search.ini'),
('315','COM_SEARCH_SEARCH_ONLY','Search Only:','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_search.ini'),
('316','COM_SEARCH_SEARCH_RESULT','Search Result','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_search.ini'),
('317','COM_TAGS_CREATED_DATE','Created Date','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_tags.ini'),
('318','COM_TAGS_FILTER_SEARCH_DESC','Enter all or part of the title to search for.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_tags.ini'),
('319','COM_TAGS_MODIFIED_DATE','Modified Date','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_tags.ini'),
('320','COM_TAGS_NO_ITEMS','No matching items were found.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_tags.ini'),
('321','COM_TAGS_NO_TAGS','There are no tags','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_tags.ini'),
('322','COM_TAGS_PUBLISHED_DATE','Published Date','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_tags.ini'),
('323','COM_TAGS_TITLE_FILTER_LABEL','Enter part of title','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_tags.ini'),
('324','COM_USERS_ACTIVATION_TOKEN_NOT_FOUND','Verification code not found.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('325','COM_USERS_CAPTCHA_LABEL','Captcha','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('326','COM_USERS_CAPTCHA_DESC','Type in the textbox what you see in the image.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('327','COM_USERS_DATABASE_ERROR','Error getting the user from the database: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('328','COM_USERS_DESIRED_PASSWORD','Enter your desired password - Enter a minimum of 4 characters','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('329','COM_USERS_DESIRED_USERNAME','Enter your desired user name','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('330','COM_USERS_EDIT_PROFILE','Edit Profile','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('331','COM_USERS_EMAIL_ACCOUNT_DETAILS','Account Details for %s at %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('332','COM_USERS_EMAIL_ACTIVATE_WITH_ADMIN_ACTIVATION_BODY','Hello administrator,\\n\\nA new user has registered at %s.\\nThe user has verified his email, and requests that you approve his account.\\nThis email contains their details:\\n\\n  Name :  %s \\n  email:  %s \\n Username:  %s \\n\\nYou can activate the user by clicking on the link below:\\n %s \\n','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('333','COM_USERS_EMAIL_ACTIVATE_WITH_ADMIN_ACTIVATION_SUBJECT','Registration approval required for account of %s at %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('334','COM_USERS_EMAIL_ACTIVATED_BY_ADMIN_ACTIVATION_BODY','Hello %s,\\n\\nYour account has been activated by an administrator. You can now login at %s using the username %s and the password you chose while registering.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('335','COM_USERS_EMAIL_ACTIVATED_BY_ADMIN_ACTIVATION_SUBJECT','Account activated for %s at %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('336','COM_USERS_EMAIL_PASSWORD_RESET_BODY','Hello,\\n\\nA request has been made to reset your %s account password. To reset your password, you will need to submit this verification code in order to verify that the request was legitimate.\\n\\nThe verification code is %s\\n\\nClick on the URL below to enter the verification code and proceed with resetting your password.\\n\\n %s \\n\\nThank you.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('337','COM_USERS_EMAIL_PASSWORD_RESET_SUBJECT','Your %s password reset request','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('338','COM_USERS_EMAIL_REGISTERED_BODY','Hello %s,\\n\\nThank you for registering at %s.\\n\\nYou may now log in to %s using the following username and password:\\n\\nUsername: %s\\nPassword: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('339','COM_USERS_EMAIL_REGISTERED_BODY_NOPW','Hello %s,\\n\\nThank you for registering at %s.\\n\\nYou may now log in to %s using the username and password you registered with.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('340','COM_USERS_EMAIL_REGISTERED_NOTIFICATION_TO_ADMIN_BODY','Hello administrator, \\n\\nA new user \'%s\', username \'%s\', has registered at %s.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('341','COM_USERS_EMAIL_REGISTERED_WITH_ACTIVATION_BODY','Hello %s,\\n\\nThank you for registering at %s. Your account is created and must be activated before you can use it.\\nTo activate the account click on the following link or copy-paste it in your browser:\\n%s \\n\\nAfter activation you may login to %s using the following username and password:\\n\\nUsername: %s\\nPassword: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('342','COM_USERS_EMAIL_REGISTERED_WITH_ACTIVATION_BODY_NOPW','Hello %s,\\n\\nThank you for registering at %s. Your account is created and must be activated before you can use it.\\nTo activate the account click on the following link or copy-paste it in your browser:\\n%s \\n\\nAfter activation you may login to %s using the following username and the password you entered during registration:\\n\\nUsername: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('343','COM_USERS_EMAIL_REGISTERED_WITH_ADMIN_ACTIVATION_BODY','Hello %s,\\n\\nThank you for registering at %s. Your account is created and must be verified before you can use it.\\nTo verify the account click on the following link or copy-paste it in your browser:\\n %s \\n\\nAfter verification an administrator will be notified to activate your account. You\'ll receive a confirmation when it\'s done.\\nOnce that account has been activated you may login to %s using the following username and password:\\n\\nUsername: %s\\nPassword: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('344','COM_USERS_EMAIL_REGISTERED_WITH_ADMIN_ACTIVATION_BODY_NOPW','Hello %s,\\n\\nThank you for registering at %s. Your account is created and must be verified before you can use it.\\nTo verify the account click on the following link or copy-paste it in your browser:\\n %s \\n\\nAfter verification an administrator will be notified to activate your account. You\'ll receive a confirmation when it\'s done.\\nOnce that account has been activated you may login to %s using the following username and the password you entered during registration:\\n\\nUsername: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('345','COM_USERS_EMAIL_USERNAME_REMINDER_BODY','Hello,\\n\\nA username reminder has been requested for your %s account.\\n\\nYour username is %s.\\n\\nTo login to your account, click on the link below.\\n\\n%s \\n\\nThank you.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('346','COM_USERS_EMAIL_USERNAME_REMINDER_SUBJECT','Your %s username','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('347','COM_USERS_FIELD_PASSWORD_RESET_DESC','Please enter the email address associated with your User account.<br />A verification code will be sent to you. Once you have received the verification code, you will be able to choose a new password for your account.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('348','COM_USERS_FIELD_PASSWORD_RESET_LABEL','Email Address:','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('349','COM_USERS_FIELD_REMIND_EMAIL_DESC','Please enter the email address associated with your User account.<br /> Your username will be emailed to the email address on file.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('350','COM_USERS_FIELD_REMIND_EMAIL_LABEL','Email Address:','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini');
INSERT INTO `#__overrider` VALUES 
('351','COM_USERS_FIELD_RESET_CONFIRM_TOKEN_DESC','Enter the password reset verification code you received by email.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('352','COM_USERS_FIELD_RESET_CONFIRM_TOKEN_LABEL','Verification Code:','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('353','COM_USERS_FIELD_RESET_CONFIRM_USERNAME_DESC','Enter your username','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('354','COM_USERS_FIELD_RESET_CONFIRM_USERNAME_LABEL','Username:','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('355','COM_USERS_FIELD_RESET_PASSWORD1_DESC','Enter your new password','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('356','COM_USERS_FIELD_RESET_PASSWORD1_LABEL','Password:','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('357','COM_USERS_FIELD_RESET_PASSWORD1_MESSAGE','The passwords you entered do not match. Please enter your desired password in the password field and confirm your entry by entering it in the confirm password field.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('358','COM_USERS_FIELD_RESET_PASSWORD2_DESC','Confirm your new password','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('359','COM_USERS_FIELD_RESET_PASSWORD2_LABEL','Confirm Password:','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('360','COM_USERS_INVALID_EMAIL','Invalid email address','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('361','COM_USERS_LOGIN_REGISTER','Don\'t have an account?','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('362','COM_USERS_LOGIN_REMIND','Forgot your username?','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('363','COM_USERS_LOGIN_RESET','Forgot your password?','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('364','COM_USERS_LOGIN_USERNAME_LABEL','User Name','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('365','COM_USERS_MAIL_FAILED','Failed sending email.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('366','COM_USERS_MAIL_SEND_FAILURE_BODY','An error was encountered when sending the user registration email. The error is: %s The user who attempted to register is: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('367','COM_USERS_MAIL_SEND_FAILURE_SUBJECT','Error sending email','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('368','COM_USERS_OPTIONAL','(optional)','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('369','COM_USERS_OR','or','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('370','COM_USERS_PROFILE','User Profile','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('371','COM_USERS_PROFILE_CORE_LEGEND','Profile','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('372','COM_USERS_PROFILE_CUSTOM_LEGEND','Custom Profile','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('373','COM_USERS_PROFILE_DEFAULT_LABEL','Edit Your Profile','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('374','COM_USERS_PROFILE_EMAIL1_DESC','Enter your email address','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('375','COM_USERS_PROFILE_EMAIL1_LABEL','Email Address:','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('376','COM_USERS_PROFILE_EMAIL1_MESSAGE','The email address you entered is already in use or invalid. Please enter another email address.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('377','COM_USERS_PROFILE_EMAIL2_DESC','Confirm your email address','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('378','COM_USERS_PROFILE_EMAIL2_LABEL','Confirm email Address:','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('379','COM_USERS_PROFILE_EMAIL2_MESSAGE','The email addresses you entered do not match. Please enter your email address in the email address field and confirm your entry by entering it in the confirm email field.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('380','COM_USERS_PROFILE_LAST_VISITED_DATE_LABEL','Last visited date','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('381','COM_USERS_PROFILE_MY_PROFILE','My Profile','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('382','COM_USERS_PROFILE_NAME_DESC','Enter your full name','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('383','COM_USERS_PROFILE_NAME_LABEL','Name:','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('384','COM_USERS_PROFILE_NEVER_VISITED','This is the first time you visit this site','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('385','COM_USERS_PROFILE_NOCHANGE_USERNAME_DESC','If you want to change your username, please contact a site administrator','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('386','COM_USERS_PROFILE_PASSWORD1_LABEL','Password:','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('387','COM_USERS_PROFILE_PASSWORD1_MESSAGE','The passwords you entered do not match. Please enter your desired password in the password field and confirm your entry by entering it in the confirm password field.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('388','COM_USERS_PROFILE_PASSWORD2_DESC','Confirm your password','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('389','COM_USERS_PROFILE_PASSWORD2_LABEL','Confirm Password:','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('390','COM_USERS_PROFILE_REGISTERED_DATE_LABEL','Registered Date','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('391','COM_USERS_PROFILE_SAVE_FAILED','Profile could not be saved: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('392','COM_USERS_PROFILE_SAVE_SUCCESS','Profile successfully saved','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('393','COM_USERS_PROFILE_USERNAME_DESC','Enter your desired username','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('394','COM_USERS_PROFILE_USERNAME_LABEL','Username:','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('395','COM_USERS_PROFILE_USERNAME_MESSAGE','The username you entered is not available. Please pick another username.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('396','COM_USERS_PROFILE_VALUE_NOT_FOUND','No Information Entered','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('397','COM_USERS_PROFILE_WELCOME','Welcome, %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('398','COM_USERS_REGISTER_DEFAULT_LABEL','Create An Account','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('399','COM_USERS_REGISTER_EMAIL1_DESC','Enter your email address','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('400','COM_USERS_REGISTER_EMAIL1_LABEL','Email Address:','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini');
INSERT INTO `#__overrider` VALUES 
('401','COM_USERS_REGISTER_EMAIL1_MESSAGE','The email address you entered is already in use or invalid. Please enter another email address.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('402','COM_USERS_REGISTER_EMAIL2_DESC','Confirm your email address','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('403','COM_USERS_REGISTER_EMAIL2_LABEL','Confirm email Address:','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('404','COM_USERS_REGISTER_EMAIL2_MESSAGE','The email addresses you entered do not match. Please enter your email address in the email address field and confirm your entry by entering it in the confirm email field.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('405','COM_USERS_REGISTER_NAME_DESC','Enter your full name','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('406','COM_USERS_REGISTER_NAME_LABEL','Name:','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('407','COM_USERS_REGISTER_PASSWORD1_LABEL','Password:','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('408','COM_USERS_REGISTER_PASSWORD1_MESSAGE','The passwords you entered do not match. Please enter your desired password in the password field and confirm your entry by entering it in the confirm password field.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('409','COM_USERS_REGISTER_PASSWORD2_DESC','Confirm your password','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('410','COM_USERS_REGISTER_PASSWORD2_LABEL','Confirm Password:','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('411','COM_USERS_REGISTER_REQUIRED','<strong class="red">*</strong> Required field','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('412','COM_USERS_REGISTER_USERNAME_DESC','Enter your desired username','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('413','COM_USERS_REGISTER_USERNAME_LABEL','Username:','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('414','COM_USERS_REGISTER_USERNAME_MESSAGE','The username you entered is not available. Please pick another username.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('415','COM_USERS_REGISTRATION','User Registration','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('416','COM_USERS_REGISTRATION_ACTIVATE_SUCCESS','Your Account has been successfully activated. You can now log in using the username and password you chose during the registration.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('417','COM_USERS_REGISTRATION_ACTIVATION_NOTIFY_SEND_MAIL_FAILED','An error was encountered while sending activation notification email','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('418','COM_USERS_REGISTRATION_ACTIVATION_SAVE_FAILED','Failed to save activation data: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('419','COM_USERS_REGISTRATION_ADMINACTIVATE_SUCCESS','The user\'s account has been successfully activated and the user has been notified about it.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('420','COM_USERS_REGISTRATION_BIND_FAILED','Failed to bind registration data: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('421','COM_USERS_REGISTRATION_COMPLETE_ACTIVATE','Your account has been created and an activation link has been sent to the email address you entered. Note that you must activate the account by clicking on the activation link when you get the email before you can login.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('422','COM_USERS_REGISTRATION_COMPLETE_VERIFY','Your account has been created and a verification link has been sent to the email address you entered. Note that you must verify the account by clicking on the verification link when you get the email and then an administrator will activate your account before you can login.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('423','COM_USERS_REGISTRATION_DEFAULT_LABEL','User Registration','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('424','COM_USERS_REGISTRATION_SAVE_FAILED','Registration failed: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('425','COM_USERS_REGISTRATION_SAVE_SUCCESS','Thank you for registering. You may now log in using the username and password you registered with.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('426','COM_USERS_REGISTRATION_SEND_MAIL_FAILED','An error was encountered while sending the registration email. A message has been sent to the administrator of this site.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('427','COM_USERS_REGISTRATION_VERIFY_SUCCESS','Your email has been verified. Once an administrator approves your account, you will be notified by email, and you can login to the site.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('428','COM_USERS_REMIND','Reminder','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('429','COM_USERS_REMIND_DEFAULT_LABEL','Please enter the email address associated with your User account. Your username will be emailed to the email address on file.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('430','COM_USERS_REMIND_EMAIL_LABEL','Your email','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('431','COM_USERS_REMIND_LIMIT_ERROR_N_HOURS','You have exceeded the maximum number of password resets allowed. Please try again in %s hours.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('432','COM_USERS_REMIND_LIMIT_ERROR_N_HOURS_1','You have exceeded the maximum number of password resets allowed. Please try again in one hour.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('433','COM_USERS_REMIND_REQUEST_FAILED','Reminder failed: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('434','COM_USERS_REMIND_REQUEST_SUCCESS','Reminder successfully sent. Please check your mail.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('435','COM_USERS_REMIND_SUPERADMIN_ERROR','A Super Administrator can\'t request a password reminder. Please contact another Super Administrator or use an alternative method.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('436','COM_USERS_RESET_COMPLETE_ERROR','Error completing password reset.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('437','COM_USERS_RESET_COMPLETE_FAILED','Completing reset password failed: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('438','COM_USERS_RESET_COMPLETE_LABEL','To complete the password reset process, please enter a new password.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('439','COM_USERS_RESET_COMPLETE_SUCCESS','Reset password successful. You may now login to the site.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('440','COM_USERS_RESET_CONFIRM_ERROR','Error while confirming the password.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('441','COM_USERS_RESET_CONFIRM_FAILED','Your password reset confirmation failed because the verification code was invalid. %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('442','COM_USERS_RESET_CONFIRM_LABEL','An email has been sent to your email address. The email contains a verification code, please paste the verification code in the field below to prove that you are the owner of this account.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('443','COM_USERS_RESET_COMPLETE_TOKENS_MISSING','Your password reset confirmation failed because the verification code was missing.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('444','COM_USERS_RESET_REQUEST_ERROR','Error requesting password reset.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('445','COM_USERS_RESET_REQUEST_FAILED','Reset password failed: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('446','COM_USERS_RESET_REQUEST_LABEL','Please enter the email address for your account. A verification code will be sent to you. Once you have received the verification code, you will be able to choose a new password for your account.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('447','COM_USERS_SETTINGS_FIELDSET_LABEL','Basic Settings','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('448','COM_USERS_USER_BLOCKED','This user is blocked. If this is an error, please contact an administrator.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('449','COM_USERS_USER_FIELD_BACKEND_LANGUAGE_DESC','Choose here your default language for the backend','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('450','COM_USERS_USER_FIELD_BACKEND_LANGUAGE_LABEL','Backend language','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini');
INSERT INTO `#__overrider` VALUES 
('451','COM_USERS_USER_FIELD_BACKEND_TEMPLATE_DESC','Select the template style for the Administrator Backend interface. This will only affect this User.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('452','COM_USERS_USER_FIELD_BACKEND_TEMPLATE_LABEL','Backend Template Style','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('453','COM_USERS_USER_FIELD_EDITOR_DESC','Choose here your text editor','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('454','COM_USERS_USER_FIELD_EDITOR_LABEL','Editor','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('455','COM_USERS_USER_FIELD_FRONTEND_LANGUAGE_DESC','Choose here your default language for the frontend','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('456','COM_USERS_USER_FIELD_FRONTEND_LANGUAGE_LABEL','Frontend language','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('457','COM_USERS_USER_FIELD_HELPSITE_DESC','Help site for the backend','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('458','COM_USERS_USER_FIELD_HELPSITE_LABEL','Help Site','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('459','COM_USERS_USER_FIELD_TIMEZONE_DESC','Choose here your time zone','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('460','COM_USERS_USER_FIELD_TIMEZONE_LABEL','Time zone','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('461','COM_USERS_USER_NOT_FOUND','User not found','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('462','COM_USERS_USER_SAVE_FAILED','Failed to save user: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_users.ini'),
('463','COM_WEBLINKS_DEFAULT_PAGE_TITLE','Web Links','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_weblinks.ini'),
('464','COM_WEBLINKS_EDIT','Edit Web link','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_weblinks.ini'),
('465','COM_WEBLINKS_ERR_TABLES_NAME','There is already a Web Link with that name in this category. Please try again.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_weblinks.ini'),
('466','COM_WEBLINKS_ERR_TABLES_PROVIDE_URL','Please provide a valid URL','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_weblinks.ini'),
('467','COM_WEBLINKS_ERR_TABLES_TITLE','Your Weblink must contain a title.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_weblinks.ini'),
('468','COM_WEBLINKS_ERROR_CATEGORY_NOT_FOUND','Web link category not found','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_weblinks.ini'),
('469','COM_WEBLINKS_ERROR_UNIQUE_ALIAS','Another Weblink from this category has the same alias','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_weblinks.ini'),
('470','COM_WEBLINKS_ERROR_WEBLINK_NOT_FOUND','Web link not found','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_weblinks.ini'),
('471','COM_WEBLINKS_ERROR_WEBLINK_URL_INVALID','Invalid Web link URL','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_weblinks.ini'),
('472','COM_WEBLINKS_FIELD_ALIAS_DESC','The alias is for internal use only. Leave this blank and Joomla will fill in a default value from the title. It has to be unique for each web link in the same category.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_weblinks.ini'),
('473','COM_WEBLINKS_FIELD_CATEGORY_DESC','You must select a Category.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_weblinks.ini'),
('474','COM_WEBLINKS_FIELD_DESCRIPTION_DESC','You may enter here a description for your Web link','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_weblinks.ini'),
('475','COM_WEBLINKS_FILTER_LABEL','Filter field','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_weblinks.ini'),
('476','COM_WEBLINKS_FILTER_SEARCH_DESC','Web Links Filter Search','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_weblinks.ini'),
('477','COM_WEBLINKS_FIELD_TITLE_DESC','Your Web Link must have a Title.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_weblinks.ini'),
('478','COM_WEBLINKS_FIELD_URL_DESC','You must enter a URL.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_weblinks.ini'),
('479','COM_WEBLINKS_FIELD_URL_LABEL','URL','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_weblinks.ini'),
('480','COM_WEBLINKS_FORM_CREATE_WEBLINK','Submit a Web link','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_weblinks.ini'),
('481','COM_WEBLINKS_GRID_TITLE','Title','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_weblinks.ini'),
('482','COM_WEBLINKS_LINK','Web Link','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_weblinks.ini'),
('483','COM_WEBLINKS_NAME','Name','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_weblinks.ini'),
('484','COM_WEBLINKS_NO_WEBLINKS','There are no Web links in this category','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_weblinks.ini'),
('485','COM_WEBLINKS_NUM','# of links:','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_weblinks.ini'),
('486','COM_WEBLINKS_FORM_EDIT_WEBLINK','Edit a Web link','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_weblinks.ini'),
('487','COM_WEBLINKS_FORM_SUBMIT_WEBLINK','Submit a Web link','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_weblinks.ini'),
('488','COM_WEBLINKS_SAVE_SUCCESS','Web link successfully saved','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_weblinks.ini'),
('489','COM_WEBLINKS_SUBMIT_SAVE_SUCCESS','Web link successfully submitted','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_weblinks.ini'),
('490','COM_WEBLINKS_WEB_LINKS','Web links','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_weblinks.ini'),
('491','JGLOBAL_NEWITEMSLAST_DESC','New Web links default to the last position. Ordering can be changed after this Web link has been saved.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_weblinks.ini'),
('492','COM_WRAPPER_NO_IFRAMES','This option will not work correctly. Unfortunately, your browser does not support inline frames.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.com_wrapper.ini'),
('493','FILES_JOOMLA','Joomla CMS','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.files_joomla.sys.ini'),
('494','FILES_JOOMLA_ERROR_FILE_FOLDER','Error on deleting file or folder %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.files_joomla.sys.ini'),
('495','FILES_JOOMLA_ERROR_MANIFEST','Error on updating manifest cache: (type, element, folder, client) = (%s, %s, %s, %s)','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.files_joomla.sys.ini'),
('496','FILES_JOOMLA_XML_DESCRIPTION','Joomla! 3.0 Content Management System','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.files_joomla.sys.ini'),
('497','FINDER_CLI','Smart Search INDEXER','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.finder_cli.ini'),
('498','FINDER_CLI_BATCH_COMPLETE',' * Processed batch %s in %s seconds.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.finder_cli.ini'),
('499','FINDER_CLI_PROCESS_COMPLETE','Total Processing Time: %s seconds.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.finder_cli.ini'),
('500','FINDER_CLI_STARTING_INDEXER','Starting Indexer','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.finder_cli.ini');
INSERT INTO `#__overrider` VALUES 
('501','FINDER_CLI_SETTING_UP_PLUGINS','Setting up Finder plugins','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.finder_cli.ini'),
('502','FINDER_CLI_SETUP_ITEMS','Setup %s items in %s seconds.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.finder_cli.ini'),
('503','JERROR_PARSING_LANGUAGE_FILE','&#160;: error(s) in line(s) %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('504','ERROR','Error','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('505','MESSAGE','Message','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('506','NOTICE','Notice','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('507','WARNING','Warning','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('508','J1','1','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('509','J2','2','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('510','J3','3','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('511','J4','4','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('512','J5','5','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('513','J6','6','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('514','J7','7','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('515','J8','8','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('516','J9','9','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('517','J10','10','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('518','J15','15','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('519','J20','20','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('520','J25','25','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('521','J30','30','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('522','J50','50','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('523','J100','100','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('524','JACTION_ADMIN','Configure','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('525','JACTION_ADMIN_GLOBAL','Super Admin','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('526','JACTION_COMPONENT_SETTINGS','Component Settings','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('527','JACTION_CREATE','Create','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('528','JACTION_DELETE','Delete','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('529','JACTION_EDIT','Edit','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('530','JACTION_EDITOWN','Edit Own','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('531','JACTION_EDITSTATE','Edit State','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('532','JACTION_LOGIN_ADMIN','Admin Login','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('533','JACTION_LOGIN_SITE','Site Login','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('534','JACTION_MANAGE','Access Administration Interface','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('535','JADMINISTRATOR','Administrator','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('536','JALL','All','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('537','JALL_LANGUAGE','All','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('538','JARCHIVED','Archived','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('539','JAUTHOR','Author','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('540','JCANCEL','Cancel','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('541','JCATEGORY','Category','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('542','JDATE','Date','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('543','JDEFAULT','Default','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('544','JDETAILS','Details','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('545','JDISABLED','Disabled','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('546','JEDITOR','Editor','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('547','JENABLED','Enabled','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('548','JFALSE','False','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('549','JFEATURED','Featured','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('550','JHIDE','Hide','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini');
INSERT INTO `#__overrider` VALUES 
('551','JINVALID_TOKEN','Invalid Token','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('552','JLOGIN','Log in','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('553','JLOGOUT','Log out','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('554','JNEW','New','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('555','JNEXT','Next','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('556','JNO','No','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('557','JNONE','None','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('558','JNOTICE','Notice','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('559','JOFF','Off','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('560','JOFFLINE_MESSAGE','This site is down for maintenance.<br /> Please check back again soon.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('561','JON','On','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('562','JOPTIONS','Options','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('563','JPAGETITLE','%1$s - %2$s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('564','JPREV','Prev','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('565','JPREVIOUS','Previous','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('566','JPUBLISHED','Published','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('567','JREGISTER','Register','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('568','JREQUIRED','Required','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('569','JSAVE','Save','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('570','JSHOW','Show','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('571','JSITE','Site','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('572','JSTATUS','Status','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('573','JSUBMIT','Submit','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('574','JTAG','Tags','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('575','JTAG_DESC','Add and delete tags to an item.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('576','JTRASH','Trash','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('577','JTRASHED','Trashed','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('578','JTRUE','True','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('579','JUNPUBLISHED','Unpublished','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('580','JYEAR','Year','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('581','JYES','Yes','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('582','JBROWSERTARGET_MODAL','Modal','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('583','JBROWSERTARGET_NEW','Open in new window','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('584','JBROWSERTARGET_PARENT','Open in parent window','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('585','JBROWSERTARGET_POPUP','Open in popup','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('586','JERROR_ALERTNOAUTHOR','You are not authorised to view this resource.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('587','JERROR_ALERTNOTEMPLATE','<strong>The template for this display is not available. Please contact a Site administrator.</strong>','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('588','JERROR_AN_ERROR_HAS_OCCURRED','An error has occurred.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('589','JERROR_COULD_NOT_FIND_TEMPLATE','Could not find template "%s".','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('590','JERROR_ERROR','Error','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('591','JERROR_LAYOUT_AN_OUT_OF_DATE_BOOKMARK_FAVOURITE','an <strong>out-of-date bookmark/favourite</strong>','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('592','JERROR_LAYOUT_ERROR_HAS_OCCURRED_WHILE_PROCESSING_YOUR_REQUEST','An error has occurred while processing your request.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('593','JERROR_LAYOUT_GO_TO_THE_HOME_PAGE','Go to the Home Page','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('594','JERROR_LAYOUT_HOME_PAGE','Home Page','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('595','JERROR_LAYOUT_MIS_TYPED_ADDRESS','a <strong>mistyped address</strong>','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('596','JERROR_LAYOUT_NOT_ABLE_TO_VISIT','You may not be able to visit this page because of:','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('597','JERROR_LAYOUT_PAGE_NOT_FOUND','The requested page cannot be found.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('598','JERROR_LAYOUT_PLEASE_CONTACT_THE_SYSTEM_ADMINISTRATOR','If difficulties persist, please contact the System Administrator of this site and report the error below.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('599','JERROR_LAYOUT_PLEASE_TRY_ONE_OF_THE_FOLLOWING_PAGES','Please try one of the following pages:','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('600','JERROR_LAYOUT_REQUESTED_RESOURCE_WAS_NOT_FOUND','The requested resource was not found.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini');
INSERT INTO `#__overrider` VALUES 
('601','JERROR_LAYOUT_SEARCH','You may wish to search the site or visit the home page.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('602','JERROR_LAYOUT_SEARCH_ENGINE_OUT_OF_DATE_LISTING','a search engine that has an <strong>out-of-date listing for this site</strong>','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('603','JERROR_LAYOUT_SEARCH_PAGE','Search this site','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('604','JERROR_LAYOUT_YOU_HAVE_NO_ACCESS_TO_THIS_PAGE','you have <strong>no access</strong> to this page','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('605','JERROR_LOGIN_DENIED','You cannot access the private section of this site.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('606','JERROR_NOLOGIN_BLOCKED','Login denied! Your account has either been blocked or you have not activated it yet.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('607','JERROR_TABLE_BIND_FAILED','hmm %s ...','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('608','JERROR_USERS_PROFILE_NOT_FOUND','User profile not found','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('609','JFIELD_ACCESS_DESC','Access level for this content','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('610','JFIELD_ACCESS_LABEL','Access','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('611','JFIELD_ALIAS_DESC','The Alias will be used in the SEF URL. Leave this blank and Joomla! will fill in a default value from the title. This value will depend on the SEO settings (Global Configuration->Site). <br />Using Unicode will produce UTF-8 aliases. You may also enter manually any UTF-8 character. Spaces and some forbidden characters will be changed to hyphens.<br />When using default transliteration it will produce an alias in lower case and with dashes instead of spaces. You may enter the Alias manually. Use lowercase letters and hyphens (-). No spaces or underscores are allowed. Default value will be a date and time if the title is typed in non-latin letters .','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('612','JFIELD_ALIAS_LABEL','Alias','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('613','JFIELD_CATEGORY_DESC','Category','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('614','JFIELD_LANGUAGE_DESC','Assign a language to this article.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('615','JFIELD_LANGUAGE_LABEL','Language','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('616','JFIELD_META_DESCRIPTION_DESC','Meta data description','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('617','JFIELD_META_DESCRIPTION_LABEL','Meta Description','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('618','JFIELD_META_KEYWORDS_DESC','Keywords describing the content','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('619','JFIELD_META_KEYWORDS_LABEL','Keywords','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('620','JFIELD_META_RIGHTS_DESC','Describe what rights others have to use this content.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('621','JFIELD_META_RIGHTS_LABEL','Rights for content','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('622','JFIELD_ORDERING_DESC','Ordering of the article within the category','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('623','JFIELD_ORDERING_LABEL','Ordering','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('624','JFIELD_PUBLISHED_DESC','Set publication status','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('625','JFIELD_TITLE_DESC','Title for the article','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('626','JGLOBAL_ARTICLES','Articles','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('627','JGLOBAL_AUTH_ACCESS_DENIED','Access Denied','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('628','JGLOBAL_AUTH_ACCESS_GRANTED','Access Granted','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('629','JGLOBAL_AUTH_BIND_FAILED','Failed binding to LDAP server','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('630','JGLOBAL_AUTH_CANCEL','Authentication cancelled','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('631','JGLOBAL_AUTH_EMPTY_PASS_NOT_ALLOWED','Empty password not allowed','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('632','JGLOBAL_AUTH_FAIL','Authentication failed','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('633','JGLOBAL_AUTH_FAILED','Failed to authenticate: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('634','JGLOBAL_AUTH_INCORRECT','Incorrect username/password','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('635','JGLOBAL_AUTH_INVALID_PASS','Username and password do not match or you do not have an account yet.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('636','JGLOBAL_AUTH_NO_BIND','Unable to bind to LDAP','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('637','JGLOBAL_AUTH_NO_CONNECT','Unable to connect to LDAP server','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('638','JGLOBAL_AUTH_NO_REDIRECT','Could not redirect to server: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('639','JGLOBAL_AUTH_NO_USER','Username and password do not match or you do not have an account yet.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('640','JGLOBAL_AUTH_NOT_CREATE_DIR','Could not create the FileStore directory %s. Please check the effective permissions.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('641','JGLOBAL_AUTH_PASS_BLANK','LDAP can not have blank password','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('642','JGLOBAL_AUTH_UNKNOWN_ACCESS_DENIED','Result Unknown. Access Denied','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('643','JGLOBAL_AUTH_USER_BLACKLISTED','User is blacklisted','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('644','JGLOBAL_AUTH_USER_NOT_FOUND','Unable to find user','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('645','JGLOBAL_AUTO','Auto','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('646','JGLOBAL_CATEGORY_NOT_FOUND','Category not found','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('647','JGLOBAL_CENTER','Center','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('648','JGLOBAL_CLICK_TO_SORT_THIS_COLUMN','Click to sort by this column','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('649','JGLOBAL_CREATED_DATE_ON','Created on %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('650','JGLOBAL_DESCRIPTION','Description','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini');
INSERT INTO `#__overrider` VALUES 
('651','JGLOBAL_DISPLAY_NUM','Display #','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('652','JGLOBAL_EDIT','Edit','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('653','JGLOBAL_EMAIL','Email','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('654','JGLOBAL_FIELD_CREATED_BY_ALIAS_DESC','Uses another name than the author\'s for display','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('655','JGLOBAL_FIELD_CREATED_BY_ALIAS_LABEL','Author\'s Alias','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('656','JGLOBAL_FIELD_FEATURED_DESC','Assign the article to the featured blog layout','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('657','JGLOBAL_FIELD_FEATURED_LABEL','Featured','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('658','JGLOBAL_FIELD_PUBLISH_DOWN_DESC','An optional date to Stop Publishing','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('659','JGLOBAL_FIELD_PUBLISH_DOWN_LABEL','Finish Publishing','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('660','JGLOBAL_FIELD_PUBLISH_UP_DESC','An optional date to Start Publishing','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('661','JGLOBAL_FIELD_PUBLISH_UP_LABEL','Start Publishing','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('662','JGLOBAL_FILTER_BUTTON','Filter','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('663','JGLOBAL_FILTER_LABEL','Filter','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('664','JGLOBAL_FULL_TEXT','Full Text','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('665','JGLOBAL_GT','&gt;','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('666','JGLOBAL_HITS','Hits','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('667','JGLOBAL_HITS_COUNT','Hits: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('668','JGLOBAL_ICON_SEP','|','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('669','JGLOBAL_INHERIT','Inherit','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('670','JGLOBAL_INTRO_TEXT','Intro Text','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('671','JGLOBAL_KEEP_TYPING','Keep typing...','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('672','JGLOBAL_LEFT','Left','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('673','JGLOBAL_LOOKING_FOR','Looking for','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('674','JGLOBAL_LT','&lt;','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('675','JGLOBAL_NEWITEMSLAST_DESC','New items default to the last position. Ordering can be changed after this item has been saved.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('676','JGLOBAL_NUM','#','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('677','JGLOBAL_PASSWORD','Password','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('678','JGLOBAL_PRINT','Print','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('679','JGLOBAL_RECORD_NUMBER','Record ID: %d','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('680','JGLOBAL_REMEMBER_ME','Remember me','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('681','JGLOBAL_RESOURCE_NOT_FOUND','Resource not found','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('682','JGLOBAL_RIGHT','Right','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('683','JGLOBAL_ROOT','Root','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('684','JGLOBAL_SELECT_AN_OPTION','Select an option','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('685','JGLOBAL_SELECT_NO_RESULTS_MATCH','No results match','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('686','JGLOBAL_SELECT_SOME_OPTIONS','Select some options','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('687','JGLOBAL_START_PUBLISH_AFTER_FINISH','Item start publishing date must be before finish publishing date','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('688','JGLOBAL_SUBCATEGORIES','Subcategories','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('689','JGLOBAL_TITLE','Title','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('690','JGLOBAL_USE_GLOBAL','Use Global','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('691','JGLOBAL_USERNAME','User Name','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('692','JGLOBAL_VALIDATION_FORM_FAILED','Invalid form','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('693','JGLOBAL_YOU_MUST_LOGIN_FIRST','Please login first','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('694','JGRID_HEADING_ACCESS','Access','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('695','JGRID_HEADING_ID','ID','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('696','JGRID_HEADING_LANGUAGE','Language','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('697','JLIB_DATABASE_ERROR_ADAPTER_MYSQL','The MySQL adapter \'mysql\' is not available.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('698','JLIB_DATABASE_ERROR_ADAPTER_MYSQLI','The MySQL adapter \'mysqli\' is not available.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('699','JLIB_DATABASE_ERROR_CONNECT_DATABASE','Unable to connect to the Database: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('700','JLIB_DATABASE_ERROR_CONNECT_MYSQL','Could not connect to MySQL.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini');
INSERT INTO `#__overrider` VALUES 
('701','JLIB_DATABASE_ERROR_DATABASE_CONNECT','Could not connect to database','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('702','JLIB_DATABASE_ERROR_LOAD_DATABASE_DRIVER','Unable to load Database Driver: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('703','JLIB_ERROR_INFINITE_LOOP','Infinite loop detected in JError','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('704','JOPTION_SELECT_ACCESS','- Select Access -','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('705','JOPTION_SELECT_CATEGORY','- Select Category -','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('706','JOPTION_SELECT_LANGUAGE','- Select Language -','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('707','JOPTION_SELECT_PUBLISHED','- Select Status -','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('708','JOPTION_USE_DEFAULT','- Use Default -','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('709','JSEARCH_FILTER_CLEAR','Clear','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('710','JSEARCH_FILTER_LABEL','Filter','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('711','JSEARCH_FILTER_SUBMIT','Search','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('712','DATE_FORMAT_LC','l, d F Y','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('713','DATE_FORMAT_LC1','l, d F Y','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('714','DATE_FORMAT_LC2','l, d F Y H:i','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('715','DATE_FORMAT_LC3','d F Y','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('716','DATE_FORMAT_LC4','Y-m-d','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('717','DATE_FORMAT_JS1','y-m-d','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('718','JANUARY_SHORT','Jan','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('719','JANUARY','January','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('720','FEBRUARY_SHORT','Feb','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('721','FEBRUARY','February','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('722','MARCH_SHORT','Mar','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('723','MARCH','March','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('724','APRIL_SHORT','Apr','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('725','APRIL','April','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('726','MAY_SHORT','May','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('727','MAY','May','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('728','JUNE_SHORT','Jun','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('729','JUNE','June','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('730','JULY_SHORT','Jul','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('731','JULY','July','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('732','AUGUST_SHORT','Aug','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('733','AUGUST','August','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('734','SEPTEMBER_SHORT','Sep','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('735','SEPTEMBER','September','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('736','OCTOBER_SHORT','Oct','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('737','OCTOBER','October','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('738','NOVEMBER_SHORT','Nov','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('739','NOVEMBER','November','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('740','DECEMBER_SHORT','Dec','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('741','DECEMBER','December','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('742','SAT','Sat','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('743','SATURDAY','Saturday','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('744','SUN','Sun','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('745','SUNDAY','Sunday','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('746','MON','Mon','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('747','MONDAY','Monday','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('748','TUE','Tue','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('749','TUESDAY','Tuesday','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('750','WED','Wed','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini');
INSERT INTO `#__overrider` VALUES 
('751','WEDNESDAY','Wednesday','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('752','THU','Thu','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('753','THURSDAY','Thursday','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('754','FRI','Fri','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('755','FRIDAY','Friday','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('756','UTC__12_00__INTERNATIONAL_DATE_LINE_WEST','(UTC -12:00) International Date Line West','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('757','UTC__11_00__MIDWAY_ISLAND__SAMOA','(UTC -11:00) Midway Island, Samoa','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('758','UTC__10_00__HAWAII','(UTC -10:00) Hawaii','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('759','UTC__09_30__TAIOHAE__MARQUESAS_ISLANDS','(UTC -09:30) Taiohae, Marquesas Islands','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('760','UTC__09_00__ALASKA','(UTC -09:00) Alaska','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('761','UTC__08_00__PACIFIC_TIME__US__AMP__CANADA_','(UTC -08:00) Pacific Time (US &amp; Canada)','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('762','UTC__07_00__MOUNTAIN_TIME__US__AMP__CANADA_','(UTC -07:00) Mountain Time (US &amp; Canada)','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('763','UTC__06_00__CENTRAL_TIME__US__AMP__CANADA___MEXICO_CITY','(UTC -06:00) Central Time (US &amp; Canada), Mexico City','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('764','UTC__05_00__EASTERN_TIME__US__AMP__CANADA___BOGOTA__LIMA','(UTC -05:00) Eastern Time (US &amp; Canada), Bogota, Lima','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('765','UTC__04_30__VENEZUELA','(UTC -04:30) Venezuela','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('766','UTC__04_00__ATLANTIC_TIME__CANADA___CARACAS__LA_PAZ','(UTC -04:00) Atlantic Time (Canada), Caracas, La Paz','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('767','UTC__03_30__ST__JOHN_S__NEWFOUNDLAND__LABRADOR','(UTC -03:30) St. John\'s, Newfoundland, Labrador','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('768','UTC__03_00__BRAZIL__BUENOS_AIRES__GEORGETOWN','(UTC -03:00) Brazil, Buenos Aires, Georgetown','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('769','UTC__02_00__MID_ATLANTIC','(UTC -02:00) Mid-Atlantic','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('770','UTC__01_00__AZORES__CAPE_VERDE_ISLANDS','(UTC -01:00) Azores, Cape Verde Islands','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('771','UTC_00_00__WESTERN_EUROPE_TIME__LONDON__LISBON__CASABLANCA','(UTC 00:00) Western Europe Time, London, Lisbon, Casablanca','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('772','UTC__01_00__AMSTERDAM__BERLIN__BRUSSELS__COPENHAGEN__MADRID__PARIS','(UTC +01:00) Amsterdam, Berlin, Brussels, Copenhagen, Madrid, Paris','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('773','UTC__02_00__ISTANBUL__JERUSALEM__KALININGRAD__SOUTH_AFRICA','(UTC +02:00) Istanbul, Jerusalem, Kaliningrad, South Africa','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('774','UTC__03_00__BAGHDAD__RIYADH__MOSCOW__ST__PETERSBURG','(UTC +03:00) Baghdad, Riyadh, Moscow, St. Petersburg','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('775','UTC__03_30__TEHRAN','(UTC +03:30) Tehran','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('776','UTC__04_00__ABU_DHABI__MUSCAT__BAKU__TBILISI','(UTC +04:00) Abu Dhabi, Muscat, Baku, Tbilisi','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('777','UTC__04_30__KABUL','(UTC +04:30) Kabul','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('778','UTC__05_00__EKATERINBURG__ISLAMABAD__KARACHI__TASHKENT','(UTC +05:00) Ekaterinburg, Islamabad, Karachi, Tashkent','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('779','UTC__05_30__BOMBAY__CALCUTTA__MADRAS__NEW_DELHI__COLOMBO','(UTC +05:30) Mumbai, Calcutta, Madras, New Delhi, Colombo','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('780','UTC__05_45__KATHMANDU','(UTC +05:45) Kathmandu','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('781','UTC__06_00__ALMATY__DHAKA','(UTC +06:00) Almaty, Dhaka','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('782','UTC__06_30__YAGOON','(UTC +06:30) Yagoon','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('783','UTC__07_00__BANGKOK__HANOI__JAKARTA__PHNOM_PENH','(UTC +07:00) Bangkok, Hanoi, Jakarta, Phnom Penh','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('784','UTC__08_00__BEIJING__PERTH__SINGAPORE__HONG_KONG','(UTC +08:00) Beijing, Perth, Singapore, Hong Kong','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('785','UTC__08_00__WESTERN_AUSTRALIA','(UTC +08:00) Western Australia','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('786','UTC__09_00__TOKYO__SEOUL__OSAKA__SAPPORO__YAKUTSK','(UTC +09:00) Tokyo, Seoul, Osaka, Sapporo, Yakutsk','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('787','UTC__09_30__ADELAIDE__DARWIN__YAKUTSK','(UTC +09:30) Adelaide, Darwin, Yakutsk','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('788','UTC__10_00__EASTERN_AUSTRALIA__GUAM__VLADIVOSTOK','(UTC +10:00) Eastern Australia, Guam, Vladivostok','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('789','UTC__10_30__LORD_HOWE_ISLAND__AUSTRALIA_','(UTC +10:30) Lord Howe Island (Australia)','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('790','UTC__11_00__MAGADAN__SOLOMON_ISLANDS__NEW_CALEDONIA','(UTC +11:00) Magadan, Solomon Islands, New Caledonia','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('791','UTC__11_30__NORFOLK_ISLAND','(UTC +11:30) Norfolk Island','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('792','UTC__12_00__AUCKLAND__WELLINGTON__FIJI__KAMCHATKA','(UTC +12:00) Auckland, Wellington, Fiji, Kamchatka','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('793','UTC__12_45__CHATHAM_ISLAND','(UTC +12:45) Chatham Island','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('794','UTC__13_00__TONGA','(UTC +13:00) Tonga','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('795','UTC__14_00__KIRIBATI','(UTC +14:00) Kiribati','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('796','PHPMAILER_PROVIDE_ADDRESS','You must provide at least one recipient email address.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('797','PHPMAILER_MAILER_IS_NOT_SUPPORTED',' Mailer is not supported.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('798','PHPMAILER_EXECUTE','Could not execute: ','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('799','PHPMAILER_INSTANTIATE','Could not instantiate mail function.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('800','PHPMAILER_AUTHENTICATE','SMTP Error! Could not authenticate.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini');
INSERT INTO `#__overrider` VALUES 
('801','PHPMAILER_FROM_FAILED','The following from address failed: ','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('802','PHPMAILER_RECIPIENTS_FAILED','SMTP Error! The following recipients failed: ','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('803','PHPMAILER_DATA_NOT_ACCEPTED','SMTP Error! Data not accepted.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('804','PHPMAILER_CONNECT_HOST','SMTP Error! Could not connect to SMTP host.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('805','PHPMAILER_FILE_ACCESS','Could not access file: ','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('806','PHPMAILER_FILE_OPEN','File Error: Could not open file: ','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('807','PHPMAILER_ENCODING','Unknown encoding: ','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('808','PHPMAILER_SIGNING_ERROR','Signing error: ','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('809','PHPMAILER_SMTP_ERROR','SMTP server error: ','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('810','PHPMAILER_EMPTY_MESSAGE','Empty message body','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('811','PHPMAILER_INVALID_ADDRESS','Invalid address','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('812','PHPMAILER_VARIABLE_SET','Cannot set or reset variable: ','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('813','PHPMAILER_SMTP_CONNECT_FAILED','SMTP connect failed','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('814','PHPMAILER_TLS','Could not start TLS','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.ini'),
('815','JERROR_PARSING_LANGUAGE_FILE','&#160;: error(s) in line(s) %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('816','JLIB_APPLICATION_ERROR_ACCESS_FORBIDDEN','Access forbidden','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('817','JLIB_APPLICATION_ERROR_APPLICATION_GET_NAME','JApplication: :getName() : Can\'t get or parse class name.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('818','JLIB_APPLICATION_ERROR_APPLICATION_LOAD','Unable to load application: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('819','JLIB_APPLICATION_ERROR_BATCH_CANNOT_CREATE','You are not allowed to create new items in this category.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('820','JLIB_APPLICATION_ERROR_BATCH_CANNOT_EDIT','You are not allowed to edit one or more of these items.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('821','JLIB_APPLICATION_ERROR_BATCH_FAILED','Batch process failed with following error: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('822','JLIB_APPLICATION_ERROR_BATCH_MOVE_CATEGORY_NOT_FOUND','Cannot find the destination category for this move.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('823','JLIB_APPLICATION_ERROR_BATCH_MOVE_ROW_NOT_FOUND','Cannot find the item being moved.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('824','JLIB_APPLICATION_ERROR_CHECKIN_FAILED','Check-in failed with the following error: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('825','JLIB_APPLICATION_ERROR_CHECKIN_NOT_CHECKED','Item is not checked out','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('826','JLIB_APPLICATION_ERROR_CHECKIN_USER_MISMATCH','The user checking in does not match the user who checked out the item.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('827','JLIB_APPLICATION_ERROR_CHECKOUT_FAILED','Check-out failed with the following error: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('828','JLIB_APPLICATION_ERROR_CHECKOUT_USER_MISMATCH','The user checking out does not match the user who checked out the item.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('829','JLIB_APPLICATION_ERROR_COMPONENT_NOT_FOUND','Component not found','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('830','JLIB_APPLICATION_ERROR_COMPONENT_NOT_LOADING','Error loading component: %1$s, %2$s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('831','JLIB_APPLICATION_ERROR_CONTROLLER_GET_NAME','JController: :getName() : Cannot get or parse class name.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('832','JLIB_APPLICATION_ERROR_CREATE_RECORD_NOT_PERMITTED','Create record not permitted','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('833','JLIB_APPLICATION_ERROR_DELETE_NOT_PERMITTED','Delete not permitted','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('834','JLIB_APPLICATION_ERROR_EDITSTATE_NOT_PERMITTED','Edit state is not permitted','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('835','JLIB_APPLICATION_ERROR_EDIT_ITEM_NOT_PERMITTED','Edit is not permitted','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('836','JLIB_APPLICATION_ERROR_EDIT_NOT_PERMITTED','Edit not permitted','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('837','JLIB_APPLICATION_ERROR_INSUFFICIENT_BATCH_INFORMATION','Insufficient information to perform the batch operation','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('838','JLIB_APPLICATION_ERROR_INVALID_CONTROLLER_CLASS','Invalid controller class: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('839','JLIB_APPLICATION_ERROR_INVALID_CONTROLLER','Invalid controller: name=\'%s\', format=\'%s\'','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('840','JLIB_APPLICATION_ERROR_LAYOUTFILE_NOT_FOUND','Layout %s not found','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('841','JLIB_APPLICATION_ERROR_MODEL_GET_NAME','JModel: :getName() : Can\'t get or parse class name.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('842','JLIB_APPLICATION_ERROR_MODULE_LOAD','Error loading module %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('843','JLIB_APPLICATION_ERROR_PATHWAY_LOAD','Unable to load pathway: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('844','JLIB_APPLICATION_ERROR_REORDER_FAILED','Reorder failed. Error: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('845','JLIB_APPLICATION_ERROR_ROUTER_LOAD','Unable to load router: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('846','JLIB_APPLICATION_ERROR_MODELCLASS_NOT_FOUND','Model class %s not found in file','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('847','JLIB_APPLICATION_ERROR_SAVE_FAILED','Save failed with the following error: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('848','JLIB_APPLICATION_ERROR_SAVE_NOT_PERMITTED','Save not permitted','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('849','JLIB_APPLICATION_ERROR_TABLE_NAME_NOT_SUPPORTED','Table %s not supported. File not found.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('850','JLIB_APPLICATION_ERROR_TASK_NOT_FOUND','Task [%s] not found','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini');
INSERT INTO `#__overrider` VALUES 
('851','JLIB_APPLICATION_ERROR_UNHELD_ID','You are not permitted to use that link to directly access that page (#%d).','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('852','JLIB_APPLICATION_ERROR_VIEW_CLASS_NOT_FOUND','View class not found [class, file]: %1$s, %2$s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('853','JLIB_APPLICATION_ERROR_VIEW_GET_NAME_SUBSTRING','JView: :getName() : Your classname contains the substring \'view\'. This causes problems when extracting the classname from the name of your objects view. Avoid Object names with the substring \'view\'.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('854','JLIB_APPLICATION_ERROR_VIEW_GET_NAME','JView: :getName() : Cannot get or parse class name.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('855','JLIB_APPLICATION_ERROR_VIEW_NOT_FOUND','View not found [name, type, prefix]: %1$s, %2$s, %3$s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('856','JLIB_APPLICATION_SAVE_SUCCESS','Item successfully saved.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('857','JLIB_APPLICATION_SUBMIT_SAVE_SUCCESS','Item successfully submitted.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('858','JLIB_APPLICATION_SUCCESS_BATCH','Batch process completed successfully.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('859','JLIB_APPLICATION_SUCCESS_ITEM_REORDERED','Ordering successfully saved.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('860','JLIB_APPLICATION_SUCCESS_ORDERING_SAVED','Ordering successfully saved.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('861','JLIB_LOGIN_AUTHENTICATE','Username and password do not match or you do not have an account yet.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('862','JLIB_CACHE_ERROR_CACHE_HANDLER_LOAD','Unable to load Cache Handler: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('863','JLIB_CACHE_ERROR_CACHE_STORAGE_LOAD','Unable to load Cache Storage: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('864','JLIB_CAPTCHA_ERROR_PLUGIN_NOT_FOUND','Captcha plugin not set or not found. Please contact a site administrator','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('865','JLIB_CLIENT_ERROR_JFTP_NO_CONNECT','JFTP: :connect: Could not connect to host \' %1$s \' on port \' %2$s \'','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('866','JLIB_CLIENT_ERROR_JFTP_NO_CONNECT_SOCKET','JFTP: :connect: Could not connect to host \' %1$s \' on port \' %2$s \'. Socket error number: %3$s and error message: %4$s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('867','JLIB_CLIENT_ERROR_JFTP_BAD_RESPONSE','JFTP: :connect: Bad response. Server response: %s [Expected: 220]','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('868','JLIB_CLIENT_ERROR_JFTP_BAD_USERNAME','JFTP: :login: Bad Username. Server response: %1$s [Expected: 331]. Username sent: %2$s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('869','JLIB_CLIENT_ERROR_JFTP_BAD_PASSWORD','JFTP: :login: Bad Password. Server response: %1$s [Expected: 230]. Password sent: %2$s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('870','JLIB_CLIENT_ERROR_JFTP_PWD_BAD_RESPONSE_NATIVE','FTP: :pwd: Bad response','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('871','JLIB_CLIENT_ERROR_JFTP_PWD_BAD_RESPONSE','JFTP: :pwd: Bad response. Server response: %s [Expected: 257]','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('872','JLIB_CLIENT_ERROR_JFTP_SYST_BAD_RESPONSE_NATIVE','JFTP: :syst: Bad response','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('873','JLIB_CLIENT_ERROR_JFTP_SYST_BAD_RESPONSE','JFTP: :syst: Bad response. Server response: %s [Expected: 215]','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('874','JLIB_CLIENT_ERROR_JFTP_CHDIR_BAD_RESPONSE_NATIVE','JFTP: :chdir: Bad response','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('875','JLIB_CLIENT_ERROR_JFTP_CHDIR_BAD_RESPONSE','JFTP: :chdir: Bad response. Server response: %1$s [Expected: 250]. Path sent: %2$s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('876','JLIB_CLIENT_ERROR_JFTP_REINIT_BAD_RESPONSE_NATIVE','JFTP: :reinit: Bad response','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('877','JLIB_CLIENT_ERROR_JFTP_REINIT_BAD_RESPONSE','JFTP: :reinit: Bad response. Server response: %s [Expected: 220]','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('878','JLIB_CLIENT_ERROR_JFTP_RENAME_BAD_RESPONSE_NATIVE','JFTP: :rename: Bad response','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('879','JLIB_CLIENT_ERROR_JFTP_RENAME_BAD_RESPONSE_FROM','JFTP: :rename: Bad response. Server response: %1$s [Expected: 350]. From path sent: %2$s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('880','JLIB_CLIENT_ERROR_JFTP_RENAME_BAD_RESPONSE_TO','JFTP: :rename: Bad response. Server response: %1$s [Expected: 250]. To path sent: %2$s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('881','JLIB_CLIENT_ERROR_JFTP_CHMOD_BAD_RESPONSE_NATIVE','JFTP: :chmod: Bad response','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('882','JLIB_CLIENT_ERROR_JFTP_CHMOD_BAD_RESPONSE','JFTP: :chmod: Bad response. Server response: %1$s [Expected: 250]. Path sent: %2$s. Mode sent: %3$s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('883','JLIB_CLIENT_ERROR_JFTP_DELETE_BAD_RESPONSE_NATIVE','JFTP: :delete: Bad response','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('884','JLIB_CLIENT_ERROR_JFTP_DELETE_BAD_RESPONSE','JFTP: :delete: Bad response. Server response: %1$s [Expected: 250]. Path sent: %2$s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('885','JLIB_CLIENT_ERROR_JFTP_MKDIR_BAD_RESPONSE_NATIVE','JFTP: :mkdir: Bad response','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('886','JLIB_CLIENT_ERROR_JFTP_MKDIR_BAD_RESPONSE','JFTP: :mkdir: Bad response. Server response: %1$s [Expected: 257]. Path sent: %2$s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('887','JLIB_CLIENT_ERROR_JFTP_RESTART_BAD_RESPONSE_NATIVE','JFTP: :restart: Bad response','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('888','JLIB_CLIENT_ERROR_JFTP_RESTART_BAD_RESPONSE','JFTP: :restart: Bad response. Server response: %1$s [Expected: 350]. Restart point sent: %2$s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('889','JLIB_CLIENT_ERROR_JFTP_CREATE_BAD_RESPONSE_BUFFER','JFTP: :create: Bad response','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('890','JLIB_CLIENT_ERROR_JFTP_CREATE_BAD_RESPONSE_PASSIVE','JFTP: :create: Unable to use passive mode','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('891','JLIB_CLIENT_ERROR_JFTP_CREATE_BAD_RESPONSE','JFTP: :create: Bad response. Server response: %1$s [Expected: 150 or 125]. Path sent: %2$s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('892','JLIB_CLIENT_ERROR_JFTP_CREATE_BAD_RESPONSE_TRANSFER','JFTP: :create: Transfer Failed. Server response: %1$s [Expected: 226]. Path sent: %2$s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('893','JLIB_CLIENT_ERROR_JFTP_READ_BAD_RESPONSE_BUFFER','JFTP: :read: Bad response','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('894','JLIB_CLIENT_ERROR_JFTP_READ_BAD_RESPONSE_PASSIVE','JFTP: :read: Unable to use passive mode','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('895','JLIB_CLIENT_ERROR_JFTP_READ_BAD_RESPONSE','JFTP: :read: Bad response. Server response: %1$s [Expected: 150 or 125]. Path sent: %2$s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('896','JLIB_CLIENT_ERROR_JFTP_READ_BAD_RESPONSE_TRANSFER','JFTP: :read: Transfer Failed. Server response: %1$s [Expected: 226]. Path sent: %2$s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('897','JLIB_CLIENT_ERROR_JFTP_GET_BAD_RESPONSE','JFTP: :get: Bad response','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('898','JLIB_CLIENT_ERROR_JFTP_GET_PASSIVE','JFTP: :get: Unable to use passive mode','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('899','JLIB_CLIENT_ERROR_JFTP_GET_WRITING_LOCAL','JFTP: :get: Unable to open local file for writing. Local path: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('900','JLIB_CLIENT_ERROR_JFTP_GET_BAD_RESPONSE_RETR','JFTP: :get: Bad response. Server response: %1$s [Expected: 150 or 125]. Path sent: %2$s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini');
INSERT INTO `#__overrider` VALUES 
('901','JLIB_CLIENT_ERROR_JFTP_GET_BAD_RESPONSE_TRANSFER','JFTP: :get: Transfer Failed. Server response: %1$s [Expected: 226]. Path sent: %2$s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('902','JLIB_CLIENT_ERROR_JFTP_STORE_PASSIVE','JFTP: :store: Unable to use passive mode','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('903','JLIB_CLIENT_ERROR_JFTP_STORE_BAD_RESPONSE','JFTP: :store: Bad response','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('904','JLIB_CLIENT_ERROR_JFTP_STORE_READING_LOCAL','JFTP: :store: Unable to open local file for reading. Local path: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('905','JLIB_CLIENT_ERROR_JFTP_STORE_FIND_LOCAL','JFTP: :store: Unable to find local file. Local path: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('906','JLIB_CLIENT_ERROR_JFTP_STORE_BAD_RESPONSE_STOR','JFTP: :store: Bad response. Server response: %1$s [Expected: 150 or 125]. Path sent: %2$s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('907','JLIB_CLIENT_ERROR_JFTP_STORE_DATA_PORT','JFTP: :store: Unable to write to data port socket','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('908','JLIB_CLIENT_ERROR_JFTP_STORE_BAD_RESPONSE_TRANSFER','JFTP: :store: Transfer Failed. Server response: %1$s [Expected: 226]. Path sent: %2$s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('909','JLIB_CLIENT_ERROR_JFTP_WRITE_PASSIVE','JFTP: :write: Unable to use passive mode','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('910','JLIB_CLIENT_ERROR_JFTP_WRITE_BAD_RESPONSE','JFTP: :write: Bad response','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('911','JLIB_CLIENT_ERROR_JFTP_WRITE_BAD_RESPONSE_STOR','JFTP: :write: Bad response. Server response: %1$s [Expected: 150 or 125]. Path sent: %2$s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('912','JLIB_CLIENT_ERROR_JFTP_WRITE_DATA_PORT','JFTP: :write: Unable to write to data port socket','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('913','JLIB_CLIENT_ERROR_JFTP_WRITE_BAD_RESPONSE_TRANSFER','JFTP: :write: Transfer Failed. Server response: %1$s [Expected: 226]. Path sent: %2$s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('914','JLIB_CLIENT_ERROR_JFTP_LISTNAMES_PASSIVE','JFTP: :listNames: Unable to use passive mode','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('915','JLIB_CLIENT_ERROR_JFTP_LISTNAMES_BAD_RESPONSE','JFTP: :listNames: Bad response','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('916','JLIB_CLIENT_ERROR_JFTP_LISTNAMES_BAD_RESPONSE_NLST','JFTP: :listNames: Bad response. Server response: %1$s [Expected: 150 or 125]. Path sent: %2$s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('917','JLIB_CLIENT_ERROR_JFTP_LISTNAMES_BAD_RESPONSE_TRANSFER','JFTP: :listNames: Transfer Failed. Server response: %1$s [Expected: 226]. Path sent: %2$s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('918','JLIB_CLIENT_ERROR_JFTP_LISTDETAILS_BAD_RESPONSE','JFTP: :listDetails: Bad response','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('919','JLIB_CLIENT_ERROR_JFTP_LISTDETAILS_PASSIVE','JFTP: :listDetails: Unable to use passive mode','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('920','JLIB_CLIENT_ERROR_JFTP_LISTDETAILS_BAD_RESPONSE_LIST','JFTP: :listDetails: Bad response. Server response: %1$s [Expected: 150 or 125]. Path sent: %2$s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('921','JLIB_CLIENT_ERROR_JFTP_LISTDETAILS_BAD_RESPONSE_TRANSFER','JFTP: :listDetails: Transfer Failed. Server response: %1$s [Expected: 226]. Path sent: %2$s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('922','JLIB_CLIENT_ERROR_JFTP_LISTDETAILS_UNRECOGNISED','JFTP: :listDetails: Unrecognised directory listing format','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('923','JLIB_CLIENT_ERROR_JFTP_PUTCMD_UNCONNECTED','JFTP: :_putCmd: Not connected to the control port','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('924','JLIB_CLIENT_ERROR_JFTP_PUTCMD_SEND','JFTP: :_putCmd: Unable to send command: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('925','JLIB_CLIENT_ERROR_JFTP_VERIFYRESPONSE','JFTP: :_verifyResponse: Timeout or unrecognised response while waiting for a response from the server. Server response: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('926','JLIB_CLIENT_ERROR_JFTP_PASSIVE_CONNECT_PORT','JFTP: :_passive: Not connected to the control port','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('927','JLIB_CLIENT_ERROR_JFTP_PASSIVE_RESPONSE','JFTP: :_passive: Timeout or unrecognised response while waiting for a response from the server. Server response: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('928','JLIB_CLIENT_ERROR_JFTP_PASSIVE_IP_OBTAIN','JFTP: :_passive: Unable to obtain IP and port for data transfer. Server response: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('929','JLIB_CLIENT_ERROR_JFTP_PASSIVE_IP_VALID','JFTP: :_passive: IP and port for data transfer not valid. Server response: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('930','JLIB_CLIENT_ERROR_JFTP_PASSIVE_CONNECT','JFTP: :_passive: Could not connect to host %1$s on port %2$s. Socket error number: %3$s and error message: %4$s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('931','JLIB_CLIENT_ERROR_JFTP_MODE_BINARY','JFTP: :_mode: Bad response. Server response: %s [Expected: 200]. Mode sent: Binary','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('932','JLIB_CLIENT_ERROR_JFTP_MODE_ASCII','JFTP: :_mode: Bad response. Server response: %s [Expected: 200]. Mode sent: Ascii','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('933','JLIB_CLIENT_ERROR_HELPER_SETCREDENTIALSFROMREQUEST_FAILED','Looks like User\'s credentials are no good...','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('934','JLIB_CLIENT_ERROR_LDAP_ADDRESS_NOT_AVAILABLE','Address not available.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('935','JLIB_DATABASE_ERROR_ADAPTER_MYSQL','The MySQL adapter \'mysql\' is not available.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('936','JLIB_DATABASE_ERROR_ADAPTER_MYSQLI','The MySQL adapter \'mysqli\' is not available.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('937','JLIB_DATABASE_ERROR_ANCESTOR_NODES_LOWER_STATE','Cannot change the published state when the parent item is of a lesser state.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('938','JLIB_DATABASE_ERROR_BIND_FAILED_INVALID_SOURCE_ARGUMENT','%s: :bind failed. Invalid source argument.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('939','JLIB_DATABASE_ERROR_ARTICLE_UNIQUE_ALIAS','Another article from this category has the same alias','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('940','JLIB_DATABASE_ERROR_CATEGORY_UNIQUE_ALIAS','Another category with the same parent category has the same alias','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('941','JLIB_DATABASE_ERROR_CHECK_FAILED','%s: :check Failed - %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('942','JLIB_DATABASE_ERROR_CHECKIN_FAILED','%s: :checkIn failed - %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('943','JLIB_DATABASE_ERROR_CHECKOUT_FAILED','%s: :checkOut failed - %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('944','JLIB_DATABASE_ERROR_CHILD_ROWS_CHECKED_OUT','Child rows checked out.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('945','JLIB_DATABASE_ERROR_CLASS_DOES_NOT_SUPPORT_ORDERING','%s does not support ordering.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('946','JLIB_DATABASE_ERROR_CLASS_IS_MISSING_FIELD','Missing field in the database: %s &#160; %s.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('947','JLIB_DATABASE_ERROR_CLASS_NOT_FOUND_IN_FILE','Table class %s not found in file.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('948','JLIB_DATABASE_ERROR_CONNECT_DATABASE','Unable to connect to the Database: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('949','JLIB_DATABASE_ERROR_CONNECT_MYSQL','Could not connect to MySQL.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('950','JLIB_DATABASE_ERROR_DATABASE_CONNECT','Could not connect to database','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini');
INSERT INTO `#__overrider` VALUES 
('951','JLIB_DATABASE_ERROR_DELETE_CATEGORY','Left-Right data inconsistency. Cannot delete category.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('952','JLIB_DATABASE_ERROR_DELETE_FAILED','%s: :delete failed - %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('953','JLIB_DATABASE_ERROR_DELETE_ROOT_CATEGORIES','Root categories cannot be deleted.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('954','JLIB_DATABASE_ERROR_EMAIL_INUSE','This email is already registered.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('955','JLIB_DATABASE_ERROR_EMPTY_ROW_RETURNED','The database row is empty.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('956','JLIB_DATABASE_ERROR_FUNCTION_FAILED','DB function failed with error number %s <br /><span style="color: red;">%s</span>','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('957','JLIB_DATABASE_ERROR_GET_NEXT_ORDER_FAILED','%s: :getNextOrder failed - %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('958','JLIB_DATABASE_ERROR_GET_TREE_FAILED','%s: :getTree Failed - %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('959','JLIB_DATABASE_ERROR_GETNODE_FAILED','%s: :_getNode Failed - %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('960','JLIB_DATABASE_ERROR_GETROOTID_FAILED','%s: :getRootId Failed - %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('961','JLIB_DATABASE_ERROR_HIT_FAILED','%s: :hit failed - %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('962','JLIB_DATABASE_ERROR_INVALID_LOCATION','%s: :setLocation - Invalid location','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('963','JLIB_DATABASE_ERROR_INVALID_NODE_RECURSION','%s: :move Failed - Cannot move the node to be a child of itself','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('964','JLIB_DATABASE_ERROR_INVALID_PARENT_ID','Invalid parent ID.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('965','JLIB_DATABASE_ERROR_LANGUAGE_NO_TITLE','The language should have a title','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('966','JLIB_DATABASE_ERROR_LANGUAGE_UNIQUE_IMAGE','A content language already exists with this Image Prefix','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('967','JLIB_DATABASE_ERROR_LANGUAGE_UNIQUE_LANG_CODE','A content language already exists with this Language Tag','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('968','JLIB_DATABASE_ERROR_LANGUAGE_UNIQUE_SEF','A content language already exists with this URL Language Code','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('969','JLIB_DATABASE_ERROR_LOAD_DATABASE_DRIVER','Unable to load Database Driver: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('970','JLIB_DATABASE_ERROR_MENUTYPE_EMPTY','Menu type empty','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('971','JLIB_DATABASE_ERROR_MENUTYPE_EXISTS','Menu type exists: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('972','JLIB_DATABASE_ERROR_MENUTYPE','Some menu items or some menu modules related to this menutype are checked out by another user or the default menu item is in this menu','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('973','JLIB_DATABASE_ERROR_MENU_CANNOT_UNSET_DEFAULT','The Language parameter for this menu item must be set to \'All\'. At least one Default menu item must have Language set to All, even if the site is multilingual.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('974','JLIB_DATABASE_ERROR_MENU_CANNOT_UNSET_DEFAULT_DEFAULT','At least one menu item has to be set as Default.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('975','JLIB_DATABASE_ERROR_MENU_UNPUBLISH_DEFAULT_HOME','Cannot unpublish default home','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('976','JLIB_DATABASE_ERROR_MENU_DEFAULT_CHECKIN_USER_MISMATCH','The current home menu for this language is checked out','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('977','JLIB_DATABASE_ERROR_MENU_UNIQUE_ALIAS','Another menu item with the same parent has this alias','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('978','JLIB_DATABASE_ERROR_MENU_UNIQUE_ALIAS_ROOT','Another menu item has the same alias in Root. Root is the top level parent','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('979','JLIB_DATABASE_ERROR_MENU_HOME_NOT_COMPONENT','The home menu item must be a component.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('980','JLIB_DATABASE_ERROR_MENU_HOME_NOT_UNIQUE_IN_MENU','A menu should contain only one Default home.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('981','JLIB_DATABASE_ERROR_MENU_ROOT_ALIAS_COMPONENT','A first level menu item alias cannot be \'component\'.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('982','JLIB_DATABASE_ERROR_MENU_ROOT_ALIAS_FOLDER','A first level menu item alias cannot be \'%s\' because \'%s\' is a sub-folder of your joomla installation folder.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('983','JLIB_DATABASE_ERROR_MOVE_FAILED','%s: :move failed - %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('984','JLIB_DATABASE_ERROR_MUSTCONTAIN_A_TITLE_CATEGORY','Category must have a title','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('985','JLIB_DATABASE_ERROR_MUSTCONTAIN_A_TITLE_EXTENSION','Extension must have a title','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('986','JLIB_DATABASE_ERROR_MUSTCONTAIN_A_TITLE_MODULE','Module must have a title','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('987','JLIB_DATABASE_ERROR_NEGATIVE_NOT_PERMITTED','%s cannot be negative','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('988','JLIB_DATABASE_ERROR_NO_ROWS_SELECTED','No rows selected.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('989','JLIB_DATABASE_ERROR_NOT_SUPPORTED_FILE_NOT_FOUND','Table %s not supported. File not found.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('990','JLIB_DATABASE_ERROR_NULL_PRIMARY_KEY','Null primary key not allowed.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('991','JLIB_DATABASE_ERROR_ORDERDOWN_FAILED','%s: :orderDown Failed - %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('992','JLIB_DATABASE_ERROR_ORDERUP_FAILED','%s: :orderUp Failed - %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('993','JLIB_DATABASE_ERROR_PLEASE_ENTER_A_USER_NAME','Please enter a user name.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('994','JLIB_DATABASE_ERROR_PLEASE_ENTER_YOUR_NAME','Please enter your name.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('995','JLIB_DATABASE_ERROR_PUBLISH_FAILED','%s: :publish failed - %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('996','JLIB_DATABASE_ERROR_REBUILD_FAILED','%s: :rebuild Failed - %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('997','JLIB_DATABASE_ERROR_REBUILDPATH_FAILED','%s: :rebuildPath Failed - %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('998','JLIB_DATABASE_ERROR_REORDER_FAILED','%s: :reorder failed - %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('999','JLIB_DATABASE_ERROR_REORDER_UPDATE_ROW_FAILED','%s: :reorder update the row %s failed - %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1000','JLIB_DATABASE_ERROR_ROOT_NODE_NOT_FOUND','Root node not found.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini');
INSERT INTO `#__overrider` VALUES 
('1001','JLIB_DATABASE_ERROR_STORE_FAILED_UPDATE_ASSET_ID','The asset_id field could not be updated','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1002','JLIB_DATABASE_ERROR_STORE_FAILED','%1$s: :store failed<br />%2$s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1003','JLIB_DATABASE_ERROR_USERGROUP_TITLE','Usergroup must have a title','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1004','JLIB_DATABASE_ERROR_USERGROUP_TITLE_EXISTS','Usergroup title already exists. Title must be unique with the same parent.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1005','JLIB_DATABASE_ERROR_USERNAME_CANNOT_CHANGE','Cannot use this user name','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1006','JLIB_DATABASE_ERROR_USERNAME_INUSE','User name in use','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1007','JLIB_DATABASE_ERROR_VALID_AZ09','Please enter a valid username. No spaces, at least %d characters and must <strong>not</strong> contain the following characters: < > \\ " \' &#37; ; ( ) &','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1008','JLIB_DATABASE_ERROR_VALID_MAIL','Please enter a valid email address.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1009','JLIB_DATABASE_ERROR_VIEWLEVEL','Viewlevel must have a title','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1010','JLIB_DATABASE_FUNCTION_NOERROR','DB function reports no errors','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1011','JLIB_DATABASE_QUERY_FAILED','Database query failed (error # %s): %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1012','JLIB_DOCUMENT_ERROR_UNABLE_LOAD_DOC_CLASS','Unable to load document class','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1013','JLIB_ENVIRONMENT_SESSION_EXPIRED','Your session has expired. Please log in again.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1014','JLIB_ERROR_INFINITE_LOOP','Infinite loop detected in JError','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1015','JLIB_EVENT_ERROR_DISPATCHER','JDispatcher: :register: Event handler not recognised. Handler: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1016','JLIB_FILESYSTEM_BZIP_NOT_SUPPORTED','BZip2 Not Supported','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1017','JLIB_FILESYSTEM_BZIP_UNABLE_TO_READ','Unable to read archive (bz2)','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1018','JLIB_FILESYSTEM_BZIP_UNABLE_TO_WRITE','Unable to write archive (bz2)','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1019','JLIB_FILESYSTEM_BZIP_UNABLE_TO_WRITE_FILE','Unable to write file (bz2)','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1020','JLIB_FILESYSTEM_GZIP_NOT_SUPPORTED','GZlib Not Supported','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1021','JLIB_FILESYSTEM_GZIP_UNABLE_TO_READ','Unable to read archive (gz)','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1022','JLIB_FILESYSTEM_GZIP_UNABLE_TO_WRITE','Unable to write archive (gz)','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1023','JLIB_FILESYSTEM_GZIP_UNABLE_TO_WRITE_FILE','Unable to write file (gz)','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1024','JLIB_FILESYSTEM_GZIP_UNABLE_TO_DECOMPRESS','Unable to decompress data','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1025','JLIB_FILESYSTEM_TAR_UNABLE_TO_READ','Unable to read archive (tar)','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1026','JLIB_FILESYSTEM_TAR_UNABLE_TO_DECOMPRESS','Unable to decompress data','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1027','JLIB_FILESYSTEM_TAR_UNABLE_TO_CREATE_DESTINATION','Unable to create destination','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1028','JLIB_FILESYSTEM_TAR_UNABLE_TO_WRITE_ENTRY','Unable to write entry','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1029','JLIB_FILESYSTEM_ZIP_NOT_SUPPORTED','Zlib Not Supported','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1030','JLIB_FILESYSTEM_ZIP_UNABLE_TO_READ','Unable to read archive (zip)','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1031','JLIB_FILESYSTEM_ZIP_INFO_FAILED','Get ZIP Information failed','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1032','JLIB_FILESYSTEM_ZIP_UNABLE_TO_CREATE_DESTINATION','Unable to create destination','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1033','JLIB_FILESYSTEM_ZIP_UNABLE_TO_WRITE_ENTRY','Unable to write entry','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1034','JLIB_FILESYSTEM_ZIP_UNABLE_TO_READ_ENTRY','Unable to read entry','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1035','JLIB_FILESYSTEM_ZIP_UNABLE_TO_OPEN_ARCHIVE','Unable to open archive','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1036','JLIB_FILESYSTEM_ZIP_INVALID_ZIP_DATA','Invalid ZIP data','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1037','JLIB_FILESYSTEM_STREAM_FAILED','Failed to register string stream','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1038','JLIB_FILESYSTEM_UNKNOWNARCHIVETYPE','Unknown Archive type','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1039','JLIB_FILESYSTEM_UNABLE_TO_LOAD_ARCHIVE','Unable to load archive','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1040','JLIB_FILESYSTEM_ERROR_JFILE_FIND_COPY','JFile: :copy: Cannot find or read file: $%s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1041','JLIB_FILESYSTEM_ERROR_JFILE_STREAMS','JFile: :copy(%1$s, %2$s): %3$s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1042','JLIB_FILESYSTEM_ERROR_COPY_FAILED','Copy failed','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1043','JLIB_FILESYSTEM_DELETE_FAILED','Failed deleting %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1044','JLIB_FILESYSTEM_CANNOT_FIND_SOURCE_FILE','Cannot find source file','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1045','JLIB_FILESYSTEM_ERROR_JFILE_MOVE_STREAMS','JFile: :move: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1046','JLIB_FILESYSTEM_ERROR_RENAME_FILE','Rename failed','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1047','JLIB_FILESYSTEM_ERROR_READ_UNABLE_TO_OPEN_FILE','JFile: :read: Unable to open file: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1048','JLIB_FILESYSTEM_ERROR_WRITE_STREAMS','JFile: :write(%1$s): %2$s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1049','JLIB_FILESYSTEM_ERROR_UPLOAD','JFile: :upload: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1050','JLIB_FILESYSTEM_ERROR_WARNFS_ERR01','Warning: Failed to change file permissions!','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini');
INSERT INTO `#__overrider` VALUES 
('1051','JLIB_FILESYSTEM_ERROR_WARNFS_ERR02','Warning: Failed to move file!','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1052','JLIB_FILESYSTEM_ERROR_FIND_SOURCE_FOLDER','Cannot find source folder','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1053','JLIB_FILESYSTEM_ERROR_FOLDER_EXISTS','Folder already exists','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1054','JLIB_FILESYSTEM_ERROR_FOLDER_CREATE','Unable to create target folder','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1055','JLIB_FILESYSTEM_ERROR_FOLDER_OPEN','Unable to open source folder','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1056','JLIB_FILESYSTEM_ERROR_FOLDER_LOOP','Infinite loop detected','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1057','JLIB_FILESYSTEM_ERROR_FOLDER_PATH','Path not in open_basedir paths','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1058','JLIB_FILESYSTEM_ERROR_COULD_NOT_CREATE_DIRECTORY','Could not create directory','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1059','JLIB_FILESYSTEM_ERROR_DELETE_BASE_DIRECTORY','You can not delete a base directory.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1060','JLIB_FILESYSTEM_ERROR_PATH_IS_NOT_A_FOLDER','JFolder: :delete: Path is not a folder. Path: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1061','JLIB_FILESYSTEM_ERROR_FOLDER_DELETE','JFolder: :delete: Could not delete folder. Path: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1062','JLIB_FILESYSTEM_ERROR_FOLDER_RENAME','Rename failed: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1063','JLIB_FILESYSTEM_ERROR_PATH_IS_NOT_A_FOLDER_FILES','JFolder: :files: Path is not a folder. Path: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1064','JLIB_FILESYSTEM_ERROR_PATH_IS_NOT_A_FOLDER_FOLDER','JFolder: :folder: Path is not a folder. Path: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1065','JLIB_FILESYSTEM_ERROR_STREAMS_FILE_SIZE','Failed to get file size. This may not work for all streams!','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1066','JLIB_FILESYSTEM_ERROR_STREAMS_FILE_NOT_OPEN','File not open','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1067','JLIB_FILESYSTEM_ERROR_STREAMS_FILENAME','Filename not set','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1068','JLIB_FILESYSTEM_ERROR_NO_DATA_WRITTEN','Warning: No data written','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1069','JLIB_FILESYSTEM_ERROR_STREAMS_FAILED_TO_OPEN_WRITER','Failed to open writer: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1070','JLIB_FILESYSTEM_ERROR_STREAMS_FAILED_TO_OPEN_READER','Failed to open reader: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1071','JLIB_FILESYSTEM_ERROR_STREAMS_NOT_UPLOADED_FILE','Not an uploaded file!','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1072','JLIB_FORM_BUTTON_CLEAR','Clear','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1073','JLIB_FORM_BUTTON_SELECT','Select','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1074','JLIB_FORM_CHANGE_IMAGE','Change image','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1075','JLIB_FORM_CHANGE_IMAGE_BUTTON','Change Image Button','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1076','JLIB_FORM_CHANGE_USER','Select User','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1077','JLIB_FORM_ERROR_FIELDS_CATEGORY_ERROR_EXTENSION_EMPTY','Extension attribute is empty in the category field','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1078','JLIB_FORM_ERROR_FIELDS_GROUPEDLIST_ELEMENT_NAME','Unknown element type: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1079','JLIB_FORM_ERROR_NO_DATA','No data','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1080','JLIB_FORM_ERROR_VALIDATE_FIELD','Invalid xml field','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1081','JLIB_FORM_ERROR_XML_FILE_DID_NOT_LOAD','XML file did not load','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1082','JLIB_FORM_FIELD_INVALID','Invalid field:&#160','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1083','JLIB_FORM_INVALID_FORM_OBJECT','Invalid Form Object: :%s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1084','JLIB_FORM_INVALID_FORM_RULE','Invalid Form Rule: :%s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1085','JLIB_FORM_MEDIA_PREVIEW_ALT','Selected image','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1086','JLIB_FORM_MEDIA_PREVIEW_EMPTY','No image selected.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1087','JLIB_FORM_MEDIA_PREVIEW_SELECTED_IMAGE','Selected image','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1088','JLIB_FORM_MEDIA_PREVIEW_TIP_TITLE','Preview','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1089','JLIB_FORM_SELECT_USER','Select a User','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1090','JLIB_FORM_VALIDATE_FIELD_INVALID','Invalid field: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1091','JLIB_FORM_VALIDATE_FIELD_REQUIRED','Field required: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1092','JLIB_FORM_VALIDATE_FIELD_RULE_MISSING','Validation Rule missing: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1093','JLIB_FORM_VALUE_CACHE_APC','Alternative PHP Cache','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1094','JLIB_FORM_VALUE_CACHE_CACHELITE','Cache_Lite','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1095','JLIB_FORM_VALUE_CACHE_EACCELERATOR','eAccelerator','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1096','JLIB_FORM_VALUE_CACHE_FILE','File','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1097','JLIB_FORM_VALUE_CACHE_MEMCACHE','Memcache','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1098','JLIB_FORM_VALUE_CACHE_MEMCACHED','Memcached (Experimental)','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1099','JLIB_FORM_VALUE_CACHE_WINCACHE','Windows Cache','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1100','JLIB_FORM_VALUE_CACHE_XCACHE','XCache','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini');
INSERT INTO `#__overrider` VALUES 
('1101','JLIB_FORM_VALUE_SESSION_APC','Alternative PHP Cache','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1102','JLIB_FORM_VALUE_SESSION_DATABASE','Database','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1103','JLIB_FORM_VALUE_SESSION_EACCELERATOR','eAccelerator','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1104','JLIB_FORM_VALUE_SESSION_MEMCACHE','Memcache','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1105','JLIB_FORM_VALUE_SESSION_MEMCACHED','Memcached (Experimental)','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1106','JLIB_FORM_VALUE_SESSION_NONE','None','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1107','JLIB_FORM_VALUE_SESSION_WINCACHE','Windows Cache','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1108','JLIB_FORM_VALUE_SESSION_XCACHE','XCache','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1109','JLIB_FORM_VALUE_TIMEZONE_UTC','Universal Time, Coordinated (UTC)','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1110','JLIB_FORM_VALUE_FROM_TEMPLATE','From Template','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1111','JLIB_FORM_VALUE_INHERITED','Inherited','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1112','JLIB_HTML_ACCESS_MODIFY_DESC_CAPTION_ACL','ACL','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1113','JLIB_HTML_ACCESS_MODIFY_DESC_CAPTION_TABLE','Table','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1114','JLIB_HTML_ACCESS_SUMMARY_DESC_CAPTION','ACL Summary Table','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1115','JLIB_HTML_ACCESS_SUMMARY_DESC','Shown below is an overview of the permission settings for this article. Click the tabs above to customise these settings by action.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1116','JLIB_HTML_ACCESS_SUMMARY','Summary','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1117','JLIB_HTML_ADD_TO_ROOT','Add to root','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1118','JLIB_HTML_ADD_TO_THIS_MENU','Add to this menu','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1119','JLIB_HTML_BATCH_ACCESS_LABEL','Set Access Level','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1120','JLIB_HTML_BATCH_ACCESS_LABEL_DESC','Not making a selection will keep the original access levels when processing.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1121','JLIB_HTML_BATCH_COPY','Copy','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1122','JLIB_HTML_BATCH_LANGUAGE_LABEL','Set Language','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1123','JLIB_HTML_BATCH_LANGUAGE_LABEL_DESC','Not making a selection will keep the original language when processing.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1124','JLIB_HTML_BATCH_LANGUAGE_NOCHANGE','- Keep original Language -','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1125','JLIB_HTML_BATCH_MENU_LABEL','Select Category for Move/Copy','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1126','JLIB_HTML_BATCH_MOVE','Move','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1127','JLIB_HTML_BATCH_NOCHANGE','- Keep original Access Levels -','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1128','JLIB_HTML_BATCH_TAG_LABEL','Add Tag','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1129','JLIB_HTML_BATCH_TAG_LABEL_DESC','Add a tag to selected items.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1130','JLIB_HTML_BATCH_TAG_NOCHANGE','- Keep original Tags -','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1131','JLIB_HTML_BATCH_USER_LABEL','Set User','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1132','JLIB_HTML_BATCH_USER_LABEL_DESC','Not making a selection will keep the original user when processing.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1133','JLIB_HTML_BATCH_USER_NOCHANGE','- Keep original User -','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1134','JLIB_HTML_BATCH_USER_NOUSER','No User','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1135','JLIB_HTML_BEHAVIOR_ABOUT_THE_CALENDAR','About the Calendar','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1136','JLIB_HTML_BEHAVIOR_CLOSE','Close','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1137','JLIB_HTML_BEHAVIOR_DATE_SELECTION','Date selection:\\n','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1138','JLIB_HTML_BEHAVIOR_DISPLAY_S_FIRST','Display %s first','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1139','JLIB_HTML_BEHAVIOR_DRAG_TO_MOVE','Drag to move','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1140','JLIB_HTML_BEHAVIOR_GO_TODAY','Go to today','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1141','JLIB_HTML_BEHAVIOR_GREEN','Green','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1142','JLIB_HTML_BEHAVIOR_HOLD_MOUSE','- Hold mouse button on any of the above buttons for faster selection.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1143','JLIB_HTML_BEHAVIOR_MONTH_SELECT','- Use the < and > buttons to select month\\n','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1144','JLIB_HTML_BEHAVIOR_NEXT_MONTH_HOLD_FOR_MENU','Click to move to the next month. Click and hold for a list of the months.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1145','JLIB_HTML_BEHAVIOR_NEXT_YEAR_HOLD_FOR_MENU','Click to move to the next year. Click and hold for a list of years.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1146','JLIB_HTML_BEHAVIOR_PREV_MONTH_HOLD_FOR_MENU','Click to move to the previous month. Click and hold for a list of the months.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1147','JLIB_HTML_BEHAVIOR_PREV_YEAR_HOLD_FOR_MENU','Click to move to the previous year. Click and hold for a list of years.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1148','JLIB_HTML_BEHAVIOR_SELECT_DATE','Select a date.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1149','JLIB_HTML_BEHAVIOR_SHIFT_CLICK_OR_DRAG_TO_CHANGE_VALUE','(Shift-)Click or Drag to change the value.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1150','JLIB_HTML_BEHAVIOR_TIME','Time:','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini');
INSERT INTO `#__overrider` VALUES 
('1151','JLIB_HTML_BEHAVIOR_TODAY','Today','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1152','JLIB_HTML_BEHAVIOR_TT_DATE_FORMAT','%a, %b %e','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1153','JLIB_HTML_BEHAVIOR_WK','wk','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1154','JLIB_HTML_BEHAVIOR_YEAR_SELECT','- Use the « and » buttons to select year\\n','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1155','JLIB_HTML_BEHAVIOR_UPLOADER_ERROR_HTTPSTATUS','Invalid Server Response','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1156','JLIB_HTML_BEHAVIOR_UPLOADER_ERROR_IOERROR','Transfer Error','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1157','JLIB_HTML_BEHAVIOR_UPLOADER_ERROR_SECURITYERROR','Security Error','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1158','JLIB_HTML_BEHAVIOR_UPLOADER_UPLOAD_COMPLETED','Upload Completed.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1159','JLIB_HTML_BEHAVIOR_UPLOADER_FILE_SUCCESSFULLY_UPLOADED','File Successfully Uploaded.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1160','JLIB_HTML_BEHAVIOR_UPLOADER_ERROR_OCCURRED','An Error Occurred: {error}','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1161','JLIB_HTML_BEHAVIOR_UPLOADER_ALL_FILES','All Files (*.*)','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1162','JLIB_HTML_BEHAVIOR_UPLOADER_PROGRESS_OVERALL','Overall Progress {total}','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1163','JLIB_HTML_BEHAVIOR_UPLOADER_CURRENT_TITLE','Upload Files','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1164','JLIB_HTML_BEHAVIOR_UPLOADER_REMOVE','Remove','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1165','JLIB_HTML_BEHAVIOR_UPLOADER_REMOVE_TITLE','Remove Title','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1166','JLIB_HTML_BEHAVIOR_UPLOADER_FILENAME','{name}','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1167','JLIB_HTML_BEHAVIOR_UPLOADER_CURRENT_FILE','Current File: {name}','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1168','JLIB_HTML_BEHAVIOR_UPLOADER_CURRENT_PROGRESS','Current Progress','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1169','JLIB_HTML_BEHAVIOR_UPLOADER_FILE_ERROR','File Error','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1170','JLIB_HTML_BEHAVIOR_UPLOADER_VALIDATION_ERROR_DUPLICATE','File Already Exists','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1171','JLIB_HTML_BEHAVIOR_UPLOADER_VALIDATION_ERROR_FILELISTMAX','Too Many Files','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1172','JLIB_HTML_BEHAVIOR_UPLOADER_VALIDATION_ERROR_FILELISTSIZEMAX','Total Upload Size Too Large','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1173','JLIB_HTML_BEHAVIOR_UPLOADER_VALIDATION_ERROR_SIZELIMITMAX','File is Too Big','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1174','JLIB_HTML_BEHAVIOR_UPLOADER_VALIDATION_ERROR_SIZELIMITMIN','File is Too Small','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1175','JLIB_HTML_BUTTON_BASE_CLASS','Could not load button base class.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1176','JLIB_HTML_BUTTON_NO_LOAD','Could not load button %s (%s);','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1177','JLIB_HTML_BUTTON_NOT_DEFINED','Button not defined for type = %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1178','JLIB_HTML_CALENDAR','Calendar','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1179','JLIB_HTML_CHECKED_OUT','Checked out','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1180','JLIB_HTML_CHECKIN','Checkin','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1181','JLIB_HTML_CLOAKING','This email address is being protected from spambots. You need JavaScript enabled to view it.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1182','JLIB_HTML_DATE_RELATIVE_DAYS','%s days ago','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1183','JLIB_HTML_DATE_RELATIVE_DAYS_1','%s day ago','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1184','JLIB_HTML_DATE_RELATIVE_DAYS_0','%s days ago','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1185','JLIB_HTML_DATE_RELATIVE_HOURS','%s hours ago','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1186','JLIB_HTML_DATE_RELATIVE_HOURS_1','%s hour ago','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1187','JLIB_HTML_DATE_RELATIVE_HOURS_0','%s hours ago','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1188','JLIB_HTML_DATE_RELATIVE_LESSTHANAMINUTE','Less than a minute ago','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1189','JLIB_HTML_DATE_RELATIVE_MINUTES','%s minutes ago','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1190','JLIB_HTML_DATE_RELATIVE_MINUTES_1','%s minute ago','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1191','JLIB_HTML_DATE_RELATIVE_MINUTES_0','%s minutes ago','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1192','JLIB_HTML_DATE_RELATIVE_WEEKS','%s weeks ago','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1193','JLIB_HTML_DATE_RELATIVE_WEEKS_1','%s week ago','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1194','JLIB_HTML_DATE_RELATIVE_WEEKS_0','%s weeks ago','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1195','JLIB_HTML_EDITOR_CANNOT_LOAD','Cannot load the editor','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1196','JLIB_HTML_END','End','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1197','JLIB_HTML_ERROR_FUNCTION_NOT_SUPPORTED','Function not supported.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1198','JLIB_HTML_ERROR_NOTFOUNDINFILE','%s: :%s not found in file.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1199','JLIB_HTML_ERROR_NOTSUPPORTED_NOFILE','%s: :%s not supported. File not found.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1200','JLIB_HTML_ERROR_NOTSUPPORTED','%s: :%s not supported.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini');
INSERT INTO `#__overrider` VALUES 
('1201','JLIB_HTML_MOVE_DOWN','Move Down','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1202','JLIB_HTML_MOVE_UP','Move Up','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1203','JLIB_HTML_NO_PARAMETERS_FOR_THIS_ITEM','There are no parameters for this item','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1204','JLIB_HTML_NO_RECORDS_FOUND','No record found','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1205','JLIB_HTML_PAGE_CURRENT_OF_TOTAL','Page %s of %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1206','JLIB_HTML_PLEASE_MAKE_A_SELECTION_FROM_THE_LIST','Please first make a selection from the list','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1207','JLIB_HTML_PUBLISH_ITEM','Publish Item','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1208','JLIB_HTML_PUBLISHED_EXPIRED_ITEM','Published, but has Expired','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1209','JLIB_HTML_PUBLISHED_FINISHED','Finish: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1210','JLIB_HTML_PUBLISHED_ITEM','Published and is Current','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1211','JLIB_HTML_PUBLISHED_PENDING_ITEM','Published, but is Pending','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1212','JLIB_HTML_PUBLISHED_START','Start: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1213','JLIB_HTML_RESULTS_OF','Results %s - %s of %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1214','JLIB_HTML_SAVE_ORDER','Save Order','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1215','JLIB_HTML_SELECT_STATE','Select State','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1216','JLIB_HTML_START','Start','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1217','JLIB_HTML_UNPUBLISH_ITEM','Unpublish Item','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1218','JLIB_HTML_VIEW_ALL','View All','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1219','JLIB_HTML_SETDEFAULT_ITEM','Set default','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1220','JLIB_HTML_UNSETDEFAULT_ITEM','Unset default','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1221','JLIB_INSTALLER_ABORT','Aborting language installation: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1222','JLIB_INSTALLER_ABORT_ALREADYINSTALLED','Extension is already installed','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1223','JLIB_INSTALLER_ABORT_COMP_BUILDADMINMENUS_FAILED','Error building Admin Menus','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1224','JLIB_INSTALLER_ABORT_COMP_INSTALL_COPY_SETUP','Component Install: Could not copy setup file.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1225','JLIB_INSTALLER_ABORT_COMP_INSTALL_CUSTOM_INSTALL_FAILURE','Component Install: Custom install routine failure','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1226','JLIB_INSTALLER_ABORT_COMP_INSTALL_MANIFEST','Component Install: Could not copy PHP manifest file.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1227','JLIB_INSTALLER_ABORT_COMP_INSTALL_PHP_INSTALL','Component Install: Could not copy PHP install file.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1228','JLIB_INSTALLER_ABORT_COMP_INSTALL_PHP_UNINSTALL','Component Install: Could not copy PHP uninstall file.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1229','JLIB_INSTALLER_ABORT_COMP_INSTALL_ROLLBACK','Component Install: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1230','JLIB_INSTALLER_ABORT_COMP_INSTALL_SQL_ERROR','Component Install: SQL error file %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1231','JLIB_INSTALLER_ABORT_COMP_UPDATE_ADMIN_ELEMENT','Component Update: The XML file did not contain an administration element','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1232','JLIB_INSTALLER_ABORT_COMP_UPDATE_COPY_SETUP','Component Update: Could not copy setup file.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1233','JLIB_INSTALLER_ABORT_COMP_UPDATE_MANIFEST','Component Update: Could not copy PHP manifest file.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1234','JLIB_INSTALLER_ABORT_COMP_UPDATE_PHP_INSTALL','Component Update: Could not copy PHP install file.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1235','JLIB_INSTALLER_ABORT_COMP_UPDATE_PHP_UNINSTALL','Component Update: Could not copy PHP uninstall file.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1236','JLIB_INSTALLER_ABORT_COMP_UPDATE_ROLLBACK','Component Update: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1237','JLIB_INSTALLER_ABORT_COMP_UPDATE_SQL_ERROR','Component Update: SQL error file %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1238','JLIB_INSTALLER_ABORT_DEBUG','Installation unexpectedly terminated:','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1239','JLIB_INSTALLER_ABORT_DETECTMANIFEST','Unable to detect manifest file','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1240','JLIB_INSTALLER_ABORT_EXTENSIONNOTVALID','Extension is not valid','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1241','JLIB_INSTALLER_ABORT_FILE_INSTALL_COPY_SETUP','Files Install: Could not copy setup file.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1242','JLIB_INSTALLER_ABORT_FILE_INSTALL_CUSTOM_INSTALL_FAILURE','Files Install: Custom install routine failure','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1243','JLIB_INSTALLER_ABORT_FILE_INSTALL_FAIL_SOURCE_DIRECTORY','Files Install: Failed to find source directory: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1244','JLIB_INSTALLER_ABORT_FILE_INSTALL_ROLLBACK','Files Install: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1245','JLIB_INSTALLER_ABORT_FILE_INSTALL_SQL_ERROR','Files %1$s: SQL error file %2$s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1246','JLIB_INSTALLER_ABORT_FILE_ROLLBACK','Files Install: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1247','JLIB_INSTALLER_ABORT_FILE_SAME_NAME','Files Install: Another extension with same name already exists.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1248','JLIB_INSTALLER_ABORT_FILE_UPDATE_SQL_ERROR','Files Update: SQL error file %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1249','JLIB_INSTALLER_ABORT_LIB_INSTALL_ALREADY_INSTALLED','Library Install: Library already installed','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1250','JLIB_INSTALLER_ABORT_LIB_INSTALL_COPY_SETUP','Library Install: Could not copy setup file.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini');
INSERT INTO `#__overrider` VALUES 
('1251','JLIB_INSTALLER_ABORT_LIB_INSTALL_FAILED_TO_CREATE_DIRECTORY','Library Install: Failed to create directory: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1252','JLIB_INSTALLER_ABORT_LIB_INSTALL_NOFILE','Library Install: No library file specified','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1253','JLIB_INSTALLER_ABORT_LIB_INSTALL_ROLLBACK','Library Install: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1254','JLIB_INSTALLER_ABORT_LOAD_DETAILS','Failed to load extension details','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1255','JLIB_INSTALLER_ABORT_METHODNOTSUPPORTED','Method not supported for this extension type','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1256','JLIB_INSTALLER_ABORT_METHODNOTSUPPORTED_TYPE','Method not supported for this extension type: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1257','JLIB_INSTALLER_ABORT_MOD_INSTALL_COPY_SETUP','Module Install: Could not copy setup file.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1258','JLIB_INSTALLER_ABORT_MOD_INSTALL_CREATE_DIRECTORY','Module %1$s: Failed to create directory: %2$s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1259','JLIB_INSTALLER_ABORT_MOD_INSTALL_CUSTOM_INSTALL_FAILURE','Module Install: Custom install routine failure','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1260','JLIB_INSTALLER_ABORT_MOD_INSTALL_DIRECTORY','Module %1$s: Another module is already using directory: %2$s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1261','JLIB_INSTALLER_ABORT_MOD_INSTALL_MANIFEST','Module Install: Could not copy PHP manifest file.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1262','JLIB_INSTALLER_ABORT_MOD_INSTALL_NOFILE','Module %s: No module file specified','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1263','JLIB_INSTALLER_ABORT_MOD_INSTALL_SQL_ERROR','Module %1$s: SQL error file %2$s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1264','JLIB_INSTALLER_ABORT_MOD_ROLLBACK','Module %1$s: %2$s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1265','JLIB_INSTALLER_ABORT_MOD_UNINSTALL_UNKNOWN_CLIENT','Module Uninstall: Unknown client type [%s]','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1266','JLIB_INSTALLER_ABORT_MOD_UNKNOWN_CLIENT','Module %1$s: Unknown client type [%2$s]','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1267','JLIB_INSTALLER_ABORT_NOINSTALLPATH','Install path does not exist','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1268','JLIB_INSTALLER_ABORT_NOUPDATEPATH','Update path does not exist','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1269','JLIB_INSTALLER_ABORT_PACK_INSTALL_COPY_SETUP','Package Install: Could not copy setup file.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1270','JLIB_INSTALLER_ABORT_PACKAGE_INSTALL_MANIFEST','Installation failed: Could not copy PHP manifest file.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1271','JLIB_INSTALLER_ABORT_PACK_INSTALL_CREATE_DIRECTORY','Package Install: Failed to create directory:%s ','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1272','JLIB_INSTALLER_ABORT_PACK_INSTALL_ERROR_EXTENSION','Package %1$s: There was an error installing an extension: %2$s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1273','JLIB_INSTALLER_ABORT_PACK_INSTALL_NO_FILES','Package %s: There were no files to install!','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1274','JLIB_INSTALLER_ABORT_PACK_INSTALL_NO_PACK','Package %s: No package file specified','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1275','JLIB_INSTALLER_ABORT_PACK_INSTALL_ROLLBACK','Package Install: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1276','JLIB_INSTALLER_ABORT_PLG_INSTALL_ALLREADY_EXISTS','Plugin %1$s: Plugin %2$s already exists','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1277','JLIB_INSTALLER_ABORT_PLG_INSTALL_COPY_SETUP','Plugin %s: Could not copy setup file.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1278','JLIB_INSTALLER_ABORT_PLG_INSTALL_CREATE_DIRECTORY','Plugin %1$s: Failed to create directory: %2$s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1279','JLIB_INSTALLER_ABORT_PLG_INSTALL_CUSTOM_INSTALL_FAILURE','Plugin Install: Custom install routine failure','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1280','JLIB_INSTALLER_ABORT_PLG_INSTALL_DIRECTORY','Plugin %1$s: Another plugin is already using directory: %2$s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1281','JLIB_INSTALLER_ABORT_PLG_INSTALL_MANIFEST','Plugin %s: Could not copy PHP manifest file.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1282','JLIB_INSTALLER_ABORT_PLG_INSTALL_NO_FILE','Plugin %s: No plugin file specified','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1283','JLIB_INSTALLER_ABORT_PLG_INSTALL_ROLLBACK','Plugin %1$s: %2$s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1284','JLIB_INSTALLER_ABORT_PLG_INSTALL_SQL_ERROR','Plugin %1$s: SQL error file %2$s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1285','JLIB_INSTALLER_ABORT_PLG_UNINSTALL_SQL_ERROR','Plugin Uninstall: SQL error file %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1286','JLIB_INSTALLER_ABORT_REFRESH_MANIFEST_CACHE','Refresh Manifest Cache failed: Extension is not currently installed.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1287','JLIB_INSTALLER_ABORT_REFRESH_MANIFEST_CACHE_VALID','Refresh Manifest Cache failed: Extension is not valid.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1288','JLIB_INSTALLER_ABORT_TPL_INSTALL_ALREADY_INSTALLED','Template Install: Template already installed','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1289','JLIB_INSTALLER_ABORT_TPL_INSTALL_ANOTHER_TEMPLATE_USING_DIRECTORY','Template Install: There is already a Template using the named directory: %s. Are you trying to install the same template again?','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1290','JLIB_INSTALLER_ABORT_TPL_INSTALL_COPY_SETUP','Template Install: Could not copy setup file.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1291','JLIB_INSTALLER_ABORT_TPL_INSTALL_FAILED_CREATE_DIRECTORY','Template Install: Failed to create directory: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1292','JLIB_INSTALLER_ABORT_TPL_INSTALL_ROLLBACK','Template Install: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1293','JLIB_INSTALLER_ABORT_TPL_INSTALL_UNKNOWN_CLIENT','Template Install: Unknown client type [%s]','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1294','JLIB_INSTALLER_PURGED_UPDATES','Purged updates','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1295','JLIB_INSTALLER_FAILED_TO_PURGE_UPDATES','Failed to purge updates','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1296','JLIB_INSTALLER_DEFAULT_STYLE','%s - Default','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1297','JLIB_INSTALLER_DISCOVER','Discover','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1298','JLIB_INSTALLER_ERROR_COMP_DISCOVER_STORE_DETAILS','Component Discover install: Failed to store component details','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1299','JLIB_INSTALLER_ERROR_COMP_INSTALL_ADMIN_ELEMENT','Component Install: The XML file did not contain an administration element','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1300','JLIB_INSTALLER_ERROR_COMP_INSTALL_DIR_ADMIN','Component Install: Another component is already using directory: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini');
INSERT INTO `#__overrider` VALUES 
('1301','JLIB_INSTALLER_ERROR_COMP_INSTALL_DIR_SITE','Component Install: Another component is already using directory: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1302','JLIB_INSTALLER_ERROR_COMP_INSTALL_FAILED_TO_CREATE_DIRECTORY_ADMIN','Component Install: Failed to create admin directory: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1303','JLIB_INSTALLER_ERROR_COMP_INSTALL_FAILED_TO_CREATE_DIRECTORY_SITE','Component Install: Failed to create site directory: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1304','JLIB_INSTALLER_ERROR_COMP_REFRESH_MANIFEST_CACHE','Component Refresh manifest cache: Failed to store component details','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1305','JLIB_INSTALLER_ERROR_COMP_REMOVING_ADMIN_MENUS_FAILED','Could not delete the administrator menus.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1306','JLIB_INSTALLER_ERROR_COMP_UNINSTALL_CUSTOM','Component Uninstall: Custom Uninstall script unsuccessful','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1307','JLIB_INSTALLER_ERROR_COMP_UNINSTALL_FAILED_DELETE_CATEGORIES','Component Uninstall: Unable to delete the component categories','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1308','JLIB_INSTALLER_ERROR_COMP_UNINSTALL_ERRORREMOVEMANUALLY','Component Uninstall: Can\'t uninstall. Please remove manually','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1309','JLIB_INSTALLER_ERROR_COMP_UNINSTALL_ERRORUNKOWNEXTENSION','Component Uninstall: Unknown Extension','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1310','JLIB_INSTALLER_ERROR_COMP_UNINSTALL_FAILED_REMOVE_DIRECTORY_ADMIN','Component Uninstall: Unable to remove the component admin directory','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1311','JLIB_INSTALLER_ERROR_COMP_UNINSTALL_FAILED_REMOVE_DIRECTORY_SITE','Component Uninstall: Unable to remove the component site directory','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1312','JLIB_INSTALLER_ERROR_COMP_UNINSTALL_NO_OPTION','Component Uninstall: Option field empty, cannot remove files','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1313','JLIB_INSTALLER_ERROR_COMP_UNINSTALL_SQL_ERROR','Component Uninstall: SQL error file %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1314','JLIB_INSTALLER_ERROR_COMP_UNINSTALL_WARNCORECOMPONENT','Component Uninstall: Trying to uninstall a core component','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1315','JLIB_INSTALLER_ERROR_COMP_UPDATE_FAILED_TO_CREATE_DIRECTORY_ADMIN','Component Update: Failed to create admin directory: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1316','JLIB_INSTALLER_ERROR_COMP_UPDATE_FAILED_TO_CREATE_DIRECTORY_SITE','Component Update: Failed to create site directory: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1317','JLIB_INSTALLER_ERROR_CREATE_DIRECTORY','JInstaller: :Install: Failed to create directory: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1318','JLIB_INSTALLER_ERROR_CREATE_FOLDER_FAILED','Failed to create directory [%s]','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1319','JLIB_INSTALLER_ERROR_DEPRECATED_FORMAT','Deprecated install format (client="both"), use package installer in future','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1320','JLIB_INSTALLER_ERROR_DOWNLOAD_SERVER_CONNECT','Error connecting to the server: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1321','JLIB_INSTALLER_ERROR_FAIL_COPY_FILE','JInstaller: :Install: Failed to copy file %1$s to %2$s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1322','JLIB_INSTALLER_ERROR_FAIL_COPY_FOLDER','JInstaller: :Install: Failed to copy folder %1$s to %2$s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1323','JLIB_INSTALLER_ERROR_FAILED_READING_NETWORK_RESOURCES','Failed reading network resource: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1324','JLIB_INSTALLER_ERROR_FILE_EXISTS','JInstaller: :Install: File already exists %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1325','JLIB_INSTALLER_ERROR_FILE_UNINSTALL_INVALID_MANIFEST','Files Uninstall: Invalid manifest file','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1326','JLIB_INSTALLER_ERROR_FILE_UNINSTALL_INVALID_NOTFOUND_MANIFEST','Files Uninstall: Manifest file invalid or not found.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1327','JLIB_INSTALLER_ERROR_FILE_UNINSTALL_LOAD_ENTRY','Files Uninstall: Could not load extension entry','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1328','JLIB_INSTALLER_ERROR_FILE_UNINSTALL_LOAD_MANIFEST','Files Uninstall: Could not load manifest file','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1329','JLIB_INSTALLER_ERROR_FILE_UNINSTALL_SQL_ERROR','Files Uninstall: SQL error file %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1330','JLIB_INSTALLER_ERROR_FILE_UNINSTALL_WARNCOREFILE','File Uninstall: Trying to uninstall core files','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1331','JLIB_INSTALLER_ERROR_FOLDER_IN_USE','Another extension is already using directory [%s]','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1332','JLIB_INSTALLER_ERROR_LANG_DISCOVER_STORE_DETAILS','Language Discover install: Failed to store language details','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1333','JLIB_INSTALLER_ERROR_LANG_UNINSTALL_DEFAULT','This language can\'t be uninstalled as long as it is defined as a default language.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1334','JLIB_INSTALLER_ERROR_LANG_UNINSTALL_DIRECTORY','Language Uninstall: Unable to remove the specified Language directory.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1335','JLIB_INSTALLER_ERROR_LANG_UNINSTALL_ELEMENT_EMPTY','Language Uninstall: Element is empty, cannot uninstall files','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1336','JLIB_INSTALLER_ERROR_LANG_UNINSTALL_PATH_EMPTY','Language Uninstall: Language path is empty, cannot uninstall files','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1337','JLIB_INSTALLER_ERROR_LANG_UNINSTALL_PROTECTED','This language can\'t be uninstalled. It is protected in the database (usually en-GB)','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1338','JLIB_INSTALLER_ERROR_LIB_DISCOVER_STORE_DETAILS','Library Discover install: Failed to store library details','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1339','JLIB_INSTALLER_ERROR_LIB_UNINSTALL_INVALID_MANIFEST','Library Uninstall: Invalid manifest file','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1340','JLIB_INSTALLER_ERROR_LIB_UNINSTALL_INVALID_NOTFOUND_MANIFEST','Library Uninstall: Manifest file invalid or not found.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1341','JLIB_INSTALLER_ERROR_LIB_UNINSTALL_LOAD_MANIFEST','Library Uninstall: Could not load manifest file','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1342','JLIB_INSTALLER_ERROR_LIB_UNINSTALL_WARNCORELIBRARY','Library Uninstall: Trying to uninstall a core library','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1343','JLIB_INSTALLER_ERROR_LOAD_XML','JInstaller: :Install: Failed to load XML File: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1344','JLIB_INSTALLER_ERROR_MOD_DISCOVER_STORE_DETAILS','Module Discover install: Failed to store module details','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1345','JLIB_INSTALLER_ERROR_MOD_REFRESH_MANIFEST_CACHE','Module Refresh manifest cache: Failed to store module details','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1346','JLIB_INSTALLER_ERROR_MOD_UNINSTALL_ERRORUNKOWNEXTENSION','Module Uninstall: Unknown Extension','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1347','JLIB_INSTALLER_ERROR_MOD_UNINSTALL_EXCEPTION','Module Uninstall: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1348','JLIB_INSTALLER_ERROR_MOD_UNINSTALL_INVALID_NOTFOUND_MANIFEST','Module Uninstall: Manifest file invalid or not found.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1349','JLIB_INSTALLER_ERROR_MOD_UNINSTALL_SQL_ERROR','Module Uninstall: SQL error file %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1350','JLIB_INSTALLER_ERROR_MOD_UNINSTALL_WARNCOREMODULE','Module Uninstall: Trying to uninstall a core module: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini');
INSERT INTO `#__overrider` VALUES 
('1351','JLIB_INSTALLER_ERROR_NO_CORE_LANGUAGE','No core pack exists for the language [%s]','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1352','JLIB_INSTALLER_ERROR_NO_FILE','JInstaller: :Install: File does not exist %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1353','JLIB_INSTALLER_ERROR_NO_LANGUAGE_TAG','The package did not specify a language tag. Are you trying to install an old language package?','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1354','JLIB_INSTALLER_ERROR_NOTFINDJOOMLAXMLSETUPFILE','JInstaller: :Install: Cannot find Joomla XML setup file','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1355','JLIB_INSTALLER_ERROR_NOTFINDXMLSETUPFILE','JInstaller: :Install: Cannot find XML setup file','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1356','JLIB_INSTALLER_ERROR_PACK_UNINSTALL_INVALID_MANIFEST','Package Uninstall: Invalid manifest file','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1357','JLIB_INSTALLER_ERROR_PACK_UNINSTALL_INVALID_NOTFOUND_MANIFEST','Package Uninstall: Manifest file invalid or not found: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1358','JLIB_INSTALLER_ERROR_PACK_UNINSTALL_LOAD_MANIFEST','Package Uninstall: Could not load manifest file','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1359','JLIB_INSTALLER_ERROR_PACK_UNINSTALL_MANIFEST_NOT_REMOVED','Package Uninstall: Errors were detected, manifest file not removed!','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1360','JLIB_INSTALLER_ERROR_PACK_UNINSTALL_MISSINGMANIFEST','Package Uninstall: Missing manifest file','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1361','JLIB_INSTALLER_ERROR_PACK_UNINSTALL_NOT_PROPER','Package Uninstall: This extension may have already been uninstalled or might not have been uninstall properly: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1362','JLIB_INSTALLER_ERROR_PACK_UNINSTALL_WARNCOREPACK','Package Uninstall: Trying to uninstall core package','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1363','JLIB_INSTALLER_ERROR_PLG_DISCOVER_STORE_DETAILS','Plugin Discover install: Failed to store plugin details','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1364','JLIB_INSTALLER_ERROR_PLG_REFRESH_MANIFEST_CACHE','Plugin Refresh manifest cache: Failed to store plugin details','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1365','JLIB_INSTALLER_ERROR_PLG_UNINSTALL_ERRORUNKOWNEXTENSION','Plugin Uninstall: Unknown Extension','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1366','JLIB_INSTALLER_ERROR_PLG_UNINSTALL_FOLDER_FIELD_EMPTY','Plugin Uninstall: Folder field empty, cannot remove files','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1367','JLIB_INSTALLER_ERROR_PLG_UNINSTALL_INVALID_MANIFEST','Plugin Uninstall: Invalid manifest file','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1368','JLIB_INSTALLER_ERROR_PLG_UNINSTALL_INVALID_NOTFOUND_MANIFEST','Plugin Uninstall: Manifest file invalid or not found.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1369','JLIB_INSTALLER_ERROR_PLG_UNINSTALL_LOAD_MANIFEST','Plugin Uninstall: Could not load manifest file','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1370','JLIB_INSTALLER_ERROR_PLG_UNINSTALL_WARNCOREPLUGIN','Plugin Uninstall: Trying to uninstall a core plugin: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1371','JLIB_INSTALLER_ERROR_SQL_ERROR','JInstaller: :Install: Error SQL %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1372','JLIB_INSTALLER_ERROR_SQL_FILENOTFOUND','JInstaller: :Install: SQL File not found %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1373','JLIB_INSTALLER_ERROR_SQL_READBUFFER','JInstaller: :Install: SQL File Buffer Read Error','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1374','JLIB_INSTALLER_ERROR_TPL_DISCOVER_STORE_DETAILS','Template Discover install: Failed to store template details','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1375','JLIB_INSTALLER_ERROR_TPL_UNINSTALL_ERRORUNKOWNEXTENSION','Template Uninstall: Unknown Extension','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1376','JLIB_INSTALLER_ERROR_TPL_UNINSTALL_INVALID_CLIENT','Template Uninstall: Invalid client.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1377','JLIB_INSTALLER_ERROR_TPL_UNINSTALL_INVALID_NOTFOUND_MANIFEST','Template Uninstall: Manifest file invalid or not found.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1378','JLIB_INSTALLER_ERROR_TPL_UNINSTALL_TEMPLATE_DEFAULT','Template Uninstall: Cannot remove default template.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1379','JLIB_INSTALLER_ERROR_TPL_UNINSTALL_TEMPLATE_DIRECTORY','Template Uninstall: Directory does not exist, cannot remove files','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1380','JLIB_INSTALLER_ERROR_TPL_UNINSTALL_TEMPLATE_ID_EMPTY','Template Uninstall: Template ID is empty, cannot uninstall files','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1381','JLIB_INSTALLER_ERROR_TPL_UNINSTALL_WARNCORETEMPLATE','Template Uninstall: Trying to uninstall a core template: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1382','JLIB_INSTALLER_ERROR_UNKNOWN_CLIENT_TYPE','Unknown Client Type [%s]','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1383','JLIB_INSTALLER_INSTALL','Install','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1384','JLIB_INSTALLER_NOTICE_LANG_RESET_USERS','Language set to Default for %d users','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1385','JLIB_INSTALLER_NOTICE_LANG_RESET_USERS_1','Language set to Default for %d user','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1386','JLIB_INSTALLER_UNINSTALL','Uninstall','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1387','JLIB_INSTALLER_UPDATE','Update','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1388','JLIB_INSTALLER_ERROR_EXTENSION_INVALID_CLIENT_IDENTIFIER','Invalid client identifier specified in extension manifest.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1389','JLIB_INSTALLER_ERROR_PACK_UNINSTALL_UNKNOWN_EXTENSION','Attempting to uninstall unknown extension from package. This extension may have already been removed earlier.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1390','JLIB_MAIL_FUNCTION_DISABLED','The mail() function has been disabled and the mail cannot be sent.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1391','JLIB_MAIL_INVALID_EMAIL_SENDER','JMail: : Invalid email Sender: %s, JMail: :setSender(%s)','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1392','JLIB_PLUGIN_ERROR_LOADING_PLUGINS','Error loading Plugins: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1393','JLIB_REGISTRY_EXCEPTION_LOAD_FORMAT_CLASS','Unable to load format class','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1394','JLIB_RULES_ACTION','Action','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1395','JLIB_RULES_ALLOWED','Allowed','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1396','JLIB_RULES_ALLOWED_ADMIN','Allowed (Super Admin)','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1397','JLIB_RULES_CALCULATED_SETTING','Calculated Setting <sup>2</sup>','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1398','JLIB_RULES_CONFLICT','Conflict','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1399','JLIB_RULES_DENIED','Denied','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1400','JLIB_RULES_GROUP','%s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini');
INSERT INTO `#__overrider` VALUES 
('1401','JLIB_RULES_GROUPS','Groups','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1402','JLIB_RULES_INHERIT','Inherit','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1403','JLIB_RULES_INHERITED','Inherited','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1404','JLIB_RULES_NOT_ALLOWED','Not Allowed','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1405','JLIB_RULES_NOT_ALLOWED_ADMIN_CONFLICT','Conflict','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1406','JLIB_RULES_NOT_ALLOWED_LOCKED','Not Allowed (Locked)','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1407','JLIB_RULES_NOT_SET','Not Set','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1408','JLIB_RULES_SELECT_ALLOW_DENY_GROUP','Allow or deny %s for users in the %s group','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1409','JLIB_RULES_SELECT_SETTING','Select New Setting <sup>1</sup>','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1410','JLIB_RULES_SETTING_NOTES','1. If you change the setting, it will apply to this and all child groups, components and content. Note that <em>Denied</em> will overrule any inherited setting, and also the setting in any child group, component or content. In the case of a setting conflict, <em>Deny</em> will take precedence. <em>Not Set</em> is equivalent to <em>Denied</em> but can be changed in child groups, components and content.<br />2. If you select a new setting, click <em>Save</em> to refresh the calculated settings.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1411','JLIB_RULES_SETTING_NOTES_ITEM','1. If you change the setting, it will apply to this item. Note that:<br /><em>Inherited</em> means that the permissions from global configuration, parent group and category will be used.<br /><em>Denied</em> means that no matter what the global configuration, parent group or category settings are, the group being edited cannot take this action on this item.<br /><em>Allowed</em> means that the group being edited will be able to take this action for this item (but if this is in conflict with the global configuration, parent group or category it will have no impact; a conflict will be indicated by <em>Not Allowed (Locked)</em> under Calculated Settings).<br />2. If you select a new setting, click <em>Save</em> to refresh the calculated settings.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1412','JLIB_RULES_SETTINGS_DESC','Manage the permission settings for the user groups below. See notes at the bottom.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1413','JLIB_UNKNOWN','Unknown','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1414','JLIB_UPDATER_ERROR_COLLECTION_FOPEN','The PHP allow_url_fopen setting is disabled. This setting must be enabled for the updater to work.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1415','JLIB_UPDATER_ERROR_COLLECTION_OPEN_URL','Update: :Collection: Could not open %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1416','JLIB_UPDATER_ERROR_COLLECTION_PARSE_URL','Update: :Collection: Could not parse %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1417','JLIB_UPDATER_ERROR_EXTENSION_OPEN_URL','Update: :Extension: Could not open %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1418','JLIB_UPDATER_ERROR_EXTENSION_PARSE_URL','Update: :Extension: Could not parse %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1419','JLIB_USER_ERROR_AUTHENTICATION_FAILED_LOAD_PLUGIN','JAuthentication: :authenticate: Failed to load plugin: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1420','JLIB_USER_ERROR_AUTHENTICATION_LIBRARIES','JAuthentication: :__construct: Could not load authentication libraries.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1421','JLIB_USER_ERROR_BIND_ARRAY','Unable to bind array to user object','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1422','JLIB_USER_ERROR_CANNOT_DEMOTE_SELF','You cannot remove your own Super Admin permissions.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1423','JLIB_USER_ERROR_ID_NOT_EXISTS','JUser: :_load: User %s does not exist','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1424','JLIB_USER_ERROR_NOT_SUPERADMIN','Only users with Super Admin permissions can change other Super Admin user accounts.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1425','JLIB_USER_ERROR_PASSWORD_NOT_MATCH','Passwords do not match. Please re-enter password.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1426','JLIB_USER_ERROR_UNABLE_TO_FIND_USER','Unable to find a user with given activation string','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1427','JLIB_USER_ERROR_UNABLE_TO_LOAD_USER','JUser: :_load: Unable to load user with ID: %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1428','JLIB_USER_EXCEPTION_ACCESS_USERGROUP_INVALID','User Group does not exist','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1429','JLIB_UTIL_ERROR_APP_INSTANTIATION','Application Instantiation Error','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1430','JLIB_UTIL_ERROR_CONNECT_DATABASE','JDatabase: :getInstance: Could not connect to database <br />joomla.library: %1$s - %2$s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1431','JLIB_UTIL_ERROR_DOMIT','DommitDocument is deprecated. Use DomDocument instead','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1432','JLIB_UTIL_ERROR_LOADING_FEED_DATA','Error loading feed data','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1433','JLIB_UTIL_ERROR_XML_LOAD','Failed loading XML file','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.ini'),
('1434','LIB_JOOMLA_XML_DESCRIPTION','The Joomla! Platform is the Core of the Joomla! Content Management System','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_joomla.sys.ini'),
('1435','LIB_PHPMAILER_XML_DESCRIPTION','Classes for sending email','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_phpmailer.sys.ini'),
('1436','LIB_PHPUTF8_XML_DESCRIPTION','Classes for UTF-8','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_phputf8.sys.ini'),
('1437','LIB_SIMPLEPIE_XML_DESCRIPTION','PHP-Based RSS and Atom Feed Framework.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.lib_simplepie.sys.ini'),
('1438','MOD_ARTICLES_ARCHIVE','Archived Articles','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_archive.ini'),
('1439','MOD_ARTICLES_ARCHIVE_FIELD_COUNT_LABEL','# of Months','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_archive.ini'),
('1440','MOD_ARTICLES_ARCHIVE_FIELD_COUNT_DESC','The number of months to display (the default is 10)','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_archive.ini'),
('1441','MOD_ARTICLES_ARCHIVE_XML_DESCRIPTION','This module shows a list of the calendar months containing archived articles. After you have changed the status of an article to archived, this list will be automatically generated.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_archive.ini'),
('1442','MOD_ARTICLES_ARCHIVE_DATE','%1$s, %2$s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_archive.ini'),
('1443','MOD_ARTICLES_ARCHIVE','Archived Articles','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_archive.sys.ini'),
('1444','MOD_ARTICLES_ARCHIVE_XML_DESCRIPTION','This Module shows a list of the calendar months containing Archived Articles. After you have changed the status of an Article to Archived, this list will be automatically generated.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_archive.sys.ini'),
('1445','MOD_ARTICLES_ARCHIVE_LAYOUT_DEFAULT','Default','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_archive.sys.ini'),
('1446','MOD_ARTICLES_CATEGORIES','Articles Categories','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_categories.ini'),
('1447','MOD_ARTICLES_CATEGORIES_FIELD_COUNT_DESC','Select here the number of first level subcategories to display. Default is all.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_categories.ini'),
('1448','MOD_ARTICLES_CATEGORIES_FIELD_COUNT_LABEL','# First Subcategories','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_categories.ini'),
('1449','MOD_ARTICLES_CATEGORIES_FIELD_MAXLEVEL_DESC','Select here the maximum level depth for each subcategory. Default is all.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_categories.ini'),
('1450','MOD_ARTICLES_CATEGORIES_FIELD_MAXLEVEL_LABEL','Maximum Level Depth','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_categories.ini');
INSERT INTO `#__overrider` VALUES 
('1451','MOD_ARTICLES_CATEGORIES_FIELD_PARENT_DESC','Choose a parent category','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_categories.ini'),
('1452','MOD_ARTICLES_CATEGORIES_FIELD_PARENT_LABEL','Parent Category','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_categories.ini'),
('1453','MOD_ARTICLES_CATEGORIES_FIELD_SHOW_CHILDREN_DESC','Show or Hide Subcategories','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_categories.ini'),
('1454','MOD_ARTICLES_CATEGORIES_FIELD_SHOW_CHILDREN_LABEL','Show Subcategories','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_categories.ini'),
('1455','MOD_ARTICLES_CATEGORIES_FIELD_SHOW_DESCRIPTION_DESC','Show or Hide category descriptions','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_categories.ini'),
('1456','MOD_ARTICLES_CATEGORIES_FIELD_SHOW_DESCRIPTION_LABEL','Category Descriptions','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_categories.ini'),
('1457','MOD_ARTICLES_CATEGORIES_XML_DESCRIPTION','This module displays a list of categories from one parent category.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_categories.ini'),
('1458','MOD_ARTICLES_CATEGORIES_TITLE_HEADING_LABEL','Heading style','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_categories.ini'),
('1459','MOD_ARTICLES_CATEGORIES_TITLE_HEADING_DESC','Set the heading style to use','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_categories.ini'),
('1460','MOD_ARTICLES_CATEGORIES','Articles Categories','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_categories.sys.ini'),
('1461','MOD_ARTICLES_CATEGORIES_XML_DESCRIPTION','This module displays a list of categories from one parent category.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_categories.sys.ini'),
('1462','MOD_ARTICLES_CATEGORIES_LAYOUT_DEFAULT','Default','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_categories.sys.ini'),
('1463','MOD_ARTICLES_CATEGORY','Articles Category','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1464','MOD_ARTICLES_CATEGORY_FIELD_ARTICLEGROUPING_DESC','Select how you would like the articles to be grouped.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1465','MOD_ARTICLES_CATEGORY_FIELD_ARTICLEGROUPING_LABEL','Article Grouping','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1466','MOD_ARTICLES_CATEGORY_FIELD_ARTICLEGROUPINGDIR_DESC','Select the direction you would like the Article Groupings to be ordered by.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1467','MOD_ARTICLES_CATEGORY_FIELD_ARTICLEGROUPINGDIR_LABEL','Grouping Direction','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1468','MOD_ARTICLES_CATEGORY_FIELD_ARTICLEORDERING_DESC','Select which field you would like Articles to be ordered by. Featured Ordering should only be used when Filtering Option for Featured Articles is set to \'Only\'.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1469','MOD_ARTICLES_CATEGORY_FIELD_ARTICLEORDERING_LABEL','Article Field to Order By','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1470','MOD_ARTICLES_CATEGORY_FIELD_ARTICLEORDERINGDIR_DESC','Select the direction you would like Articles to be ordered by.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1471','MOD_ARTICLES_CATEGORY_FIELD_ARTICLEORDERINGDIR_LABEL','Ordering Direction','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1472','MOD_ARTICLES_CATEGORY_FIELD_AUTHOR_DESC','Select one or more authors from the list below.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1473','MOD_ARTICLES_CATEGORY_FIELD_AUTHOR_LABEL','Authors','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1474','MOD_ARTICLES_CATEGORY_FIELD_AUTHORALIAS_DESC','Select one or more author aliases from the list below.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1475','MOD_ARTICLES_CATEGORY_FIELD_AUTHORALIAS_LABEL','Author Aliases','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1476','MOD_ARTICLES_CATEGORY_FIELD_AUTHORALIASFILTERING_DESC','Select Inclusive to Include the Selected Author Aliases, Exclusive to Exclude the Selected Author Aliases.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1477','MOD_ARTICLES_CATEGORY_FIELD_AUTHORALIASFILTERING_LABEL','Author Alias Filtering Type','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1478','MOD_ARTICLES_CATEGORY_FIELD_AUTHORFILTERING_DESC','Select Inclusive to Include the Selected Authors, Exclusive to Exclude the Selected Authors.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1479','MOD_ARTICLES_CATEGORY_FIELD_AUTHORFILTERING_LABEL','Author Filtering Type','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1480','MOD_ARTICLES_CATEGORY_FIELD_CATDEPTH_DESC','The number of child category levels to return.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1481','MOD_ARTICLES_CATEGORY_FIELD_CATDEPTH_LABEL','Category Depth','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1482','MOD_ARTICLES_CATEGORY_FIELD_CATEGORY_DESC','Please select one or more categories.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1483','MOD_ARTICLES_CATEGORY_FIELD_CATFILTERINGTYPE_DESC','Select Inclusive to Include the Selected Categories, Exclusive to Exclude the Selected Categories.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1484','MOD_ARTICLES_CATEGORY_FIELD_CATFILTERINGTYPE_LABEL','Category Filtering Type','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1485','MOD_ARTICLES_CATEGORY_FIELD_COUNT_DESC','The number of items to display. The default value of 0 will display all articles.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1486','MOD_ARTICLES_CATEGORY_FIELD_COUNT_LABEL','Count','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1487','MOD_ARTICLES_CATEGORY_FIELD_DATERANGEFIELD_DESC','Select which date field you want the date range to be applied to.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1488','MOD_ARTICLES_CATEGORY_FIELD_DATERANGEFIELD_LABEL','Date Range Field','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1489','MOD_ARTICLES_CATEGORY_FIELD_DATEFIELD_DESC','Select which date field you want to display.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1490','MOD_ARTICLES_CATEGORY_FIELD_DATEFIELD_LABEL','Date Field','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1491','MOD_ARTICLES_CATEGORY_FIELD_DATEFIELDFORMAT_DESC','Please enter in a valid date format. See: http://php.net/date for formatting information.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1492','MOD_ARTICLES_CATEGORY_FIELD_DATEFIELDFORMAT_LABEL','Date Format','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1493','MOD_ARTICLES_CATEGORY_FIELD_DATEFILTERING_DESC','Select Date Filtering Type.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1494','MOD_ARTICLES_CATEGORY_FIELD_DATEFILTERING_LABEL','Date Filtering','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1495','MOD_ARTICLES_CATEGORY_FIELD_ENDDATE_DESC','If Date Range is selected above, please enter an End Date.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1496','MOD_ARTICLES_CATEGORY_FIELD_ENDDATE_LABEL','To Date','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1497','MOD_ARTICLES_CATEGORY_FIELD_EXCLUDEDARTICLES_DESC','Please enter each Article ID on a new line.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1498','MOD_ARTICLES_CATEGORY_FIELD_EXCLUDEDARTICLES_LABEL','Article IDs to Exclude','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1499','MOD_ARTICLES_CATEGORY_FIELD_GROUP_DISPLAY_LABEL','Display Options','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1500','MOD_ARTICLES_CATEGORY_FIELD_GROUP_DYNAMIC_LABEL','Dynamic Mode Options','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini');
INSERT INTO `#__overrider` VALUES 
('1501','MOD_ARTICLES_CATEGORY_FIELD_GROUP_FILTERING_LABEL','Filtering Options','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1502','MOD_ARTICLES_CATEGORY_FIELD_GROUP_GROUPING_LABEL','Grouping Options','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1503','MOD_ARTICLES_CATEGORY_FIELD_GROUP_ORDERING_LABEL','Ordering Options','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1504','MOD_ARTICLES_CATEGORY_FIELD_INTROTEXTLIMIT_DESC','Please enter in a numeric character limit value. The introtext will be trimmed to the number of characters you enter.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1505','MOD_ARTICLES_CATEGORY_FIELD_INTROTEXTLIMIT_LABEL','Introtext Limit','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1506','MOD_ARTICLES_CATEGORY_FIELD_LINKTITLES_LABEL','Linked Titles','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1507','MOD_ARTICLES_CATEGORY_FIELD_LINKTITLES_DESC','Linked Titles','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1508','MOD_ARTICLES_CATEGORY_FIELD_MODE_DESC','Please select the mode you would like to use. If Normal Mode is chosen, then simply configure the module and it will display a static list of Articles on the menu items you assign the module to. If Dynamic Mode is chosen, then you can still configure the module normally, however now the Category option will no longer be used. Instead, the module will dynamically detect whether or not you are on a Category view and will display the list of articles within that Category accordingly. When Dynamic Mode is chosen, it is best to leave the module set to display on all pages, as it will decide whether or not to display anything dynamically.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1509','MOD_ARTICLES_CATEGORY_FIELD_MODE_LABEL','Mode','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1510','MOD_ARTICLES_CATEGORY_FIELD_MONTHYEARFORMAT_DESC','Please enter in a valid date format. See: http://php.net/date for formatting information.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1511','MOD_ARTICLES_CATEGORY_FIELD_MONTHYEARFORMAT_LABEL','Month and Year Display Format','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1512','MOD_ARTICLES_CATEGORY_FIELD_RELATIVEDATE_DESC','If Relative Date is selected above, please enter in a numeric day value. Results will be retrieved relative to the current date and the value you enter.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1513','MOD_ARTICLES_CATEGORY_FIELD_RELATIVEDATE_LABEL','Relative Date','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1514','MOD_ARTICLES_CATEGORY_FIELD_SHOWAUTHOR_DESC','Select Show if you would like the author (or author alias instead, if available) to be displayed.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1515','MOD_ARTICLES_CATEGORY_FIELD_SHOWCATEGORY_DESC','Select Show if you would like the category name displayed.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1516','MOD_ARTICLES_CATEGORY_FIELD_SHOWCHILDCATEGORYARTICLES_DESC','Include or Exclude Articles from Child Categories.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1517','MOD_ARTICLES_CATEGORY_FIELD_SHOWCHILDCATEGORYARTICLES_LABEL','Child Category Articles','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1518','MOD_ARTICLES_CATEGORY_FIELD_SHOWDATE_DESC','Select Show if you would like the date displayed.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1519','MOD_ARTICLES_CATEGORY_FIELD_SHOWFEATURED_DESC','Select to Show, Hide, or Only display Featured Articles.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1520','MOD_ARTICLES_CATEGORY_FIELD_SHOWFEATURED_LABEL','Featured Articles','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1521','MOD_ARTICLES_CATEGORY_FIELD_SHOWHITS_DESC','Select Show if you would like the hits for each article to be displayed.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1522','MOD_ARTICLES_CATEGORY_FIELD_SHOWHITS_LABEL','Hits','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1523','MOD_ARTICLES_CATEGORY_FIELD_SHOWINTROTEXT_DESC','Select Show if you would like the introtext to be displayed.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1524','MOD_ARTICLES_CATEGORY_FIELD_SHOWINTROTEXT_LABEL','Introtext','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1525','MOD_ARTICLES_CATEGORY_FIELD_SHOWONARTICLEPAGE_DESC','Select to Show or Hide Article List from Article Pages. This means that the module will only display itself dynamically on Category Pages.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1526','MOD_ARTICLES_CATEGORY_FIELD_SHOWONARTICLEPAGE_LABEL','Show on Article Page','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1527','MOD_ARTICLES_CATEGORY_FIELD_STARTDATE_DESC','If Date Range is selected above, please enter a Starting Date.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1528','MOD_ARTICLES_CATEGORY_FIELD_STARTDATE_LABEL','Start Date Range','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1529','MOD_ARTICLES_CATEGORY_OPTION_ASCENDING_VALUE','Ascending','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1530','MOD_ARTICLES_CATEGORY_OPTION_CREATED_VALUE','Created Date','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1531','MOD_ARTICLES_CATEGORY_OPTION_DATERANGE_VALUE','Date Range','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1532','MOD_ARTICLES_CATEGORY_OPTION_DESCENDING_VALUE','Descending','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1533','MOD_ARTICLES_CATEGORY_OPTION_DYNAMIC_VALUE','Dynamic','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1534','MOD_ARTICLES_CATEGORY_OPTION_EXCLUDE_VALUE','Exclude','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1535','MOD_ARTICLES_CATEGORY_OPTION_EXCLUSIVE_VALUE','Exclusive','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1536','MOD_ARTICLES_CATEGORY_OPTION_HITS_VALUE','Hits','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1537','MOD_ARTICLES_CATEGORY_OPTION_ID_VALUE','ID','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1538','MOD_ARTICLES_CATEGORY_OPTION_INCLUDE_VALUE','Include','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1539','MOD_ARTICLES_CATEGORY_OPTION_INCLUSIVE_VALUE','Inclusive','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1540','MOD_ARTICLES_CATEGORY_OPTION_MODIFIED_VALUE','Modified Date','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1541','MOD_ARTICLES_CATEGORY_OPTION_MONTHYEAR_VALUE','Month and Year','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1542','MOD_ARTICLES_CATEGORY_OPTION_NORMAL_VALUE','Normal','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1543','MOD_ARTICLES_CATEGORY_OPTION_OFF_VALUE','Off','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1544','MOD_ARTICLES_CATEGORY_OPTION_ONLYFEATURED_VALUE','Only','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1545','MOD_ARTICLES_CATEGORY_OPTION_ORDERING_VALUE','Article Manager Order','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1546','MOD_ARTICLES_CATEGORY_OPTION_ORDERINGFEATURED_VALUE','Featured Articles Order','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1547','MOD_ARTICLES_CATEGORY_OPTION_RELATIVEDAY_VALUE','Relative Date','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1548','MOD_ARTICLES_CATEGORY_OPTION_STARTPUBLISHING_VALUE','Start Publishing Date','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1549','MOD_ARTICLES_CATEGORY_OPTION_FINISHPUBLISHING_VALUE','Finish Publishing Date','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1550','MOD_ARTICLES_CATEGORY_OPTION_YEAR_VALUE','Year','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini');
INSERT INTO `#__overrider` VALUES 
('1551','MOD_ARTICLES_CATEGORY_READ_MORE','Read more: ','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1552','MOD_ARTICLES_CATEGORY_READ_MORE_TITLE','Read More...','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1553','MOD_ARTICLES_CATEGORY_REGISTER_TO_READ_MORE','Register to read more','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1554','MOD_ARTICLES_CATEGORY_TITLE_HEADING','Heading Level','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1555','MOD_ARTICLES_CATEGORY_TITLE_HEADING_DESCRIPTION','Select the desired HTML tag for the article titles.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1556','MOD_ARTICLES_CATEGORY_XML_DESCRIPTION','This module displays a list of articles from one or more categories.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.ini'),
('1557','MOD_ARTICLES_CATEGORY','Articles Category','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.sys.ini'),
('1558','MOD_ARTICLES_CATEGORY_XML_DESCRIPTION','This module displays a list of articles from one or more categories.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.sys.ini'),
('1559','MOD_ARTICLES_CATEGORY_LAYOUT_DEFAULT','Default','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_category.sys.ini'),
('1560','MOD_ARTICLES_LATEST','Latest News','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_latest.ini'),
('1561','MOD_LATEST_NEWS_FIELD_CATEGORY_DESC','Selects Articles from one or more Categories. If no selection will show all categories as default','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_latest.ini'),
('1562','MOD_LATEST_NEWS_FIELD_COUNT_DESC','The number of Articles to display (the default is 5)','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_latest.ini'),
('1563','MOD_LATEST_NEWS_FIELD_COUNT_LABEL','Count','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_latest.ini'),
('1564','MOD_LATEST_NEWS_FIELD_FEATURED_DESC','Show/Hide Articles designated as Featured','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_latest.ini'),
('1565','MOD_LATEST_NEWS_FIELD_FEATURED_LABEL','Featured Articles','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_latest.ini'),
('1566','MOD_LATEST_NEWS_FIELD_ORDERING_DESC','Recently Added First: order the articles using their creation date<br />Recently Modified First: order the articles using their modification date<br />Recently Published First: order the articles using their publication date.<br />Recently Touched First: order the articles using their modification or creation dates.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_latest.ini'),
('1567','MOD_LATEST_NEWS_FIELD_ORDERING_LABEL','Order','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_latest.ini'),
('1568','MOD_LATEST_NEWS_FIELD_USER_DESC','Filter by author','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_latest.ini'),
('1569','MOD_LATEST_NEWS_FIELD_USER_LABEL','Authors','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_latest.ini'),
('1570','MOD_LATEST_NEWS_VALUE_ADDED_BY_ME','Added or modified by me','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_latest.ini'),
('1571','MOD_LATEST_NEWS_VALUE_ANYONE','Anyone','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_latest.ini'),
('1572','MOD_LATEST_NEWS_VALUE_NOTADDED_BY_ME','Not added or modified by me','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_latest.ini'),
('1573','MOD_LATEST_NEWS_VALUE_ONLY_SHOW_FEATURED','Only show Featured Articles','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_latest.ini'),
('1574','MOD_LATEST_NEWS_VALUE_RECENT_ADDED','Recently Added First','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_latest.ini'),
('1575','MOD_LATEST_NEWS_VALUE_RECENT_MODIFIED','Recently Modified First','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_latest.ini'),
('1576','MOD_LATEST_NEWS_VALUE_RECENT_PUBLISHED','Recently Published First','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_latest.ini'),
('1577','MOD_LATEST_NEWS_VALUE_RECENT_TOUCHED','Recently Touched First','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_latest.ini'),
('1578','MOD_LATEST_NEWS_XML_DESCRIPTION','This Module shows a list of the most recently published and current Articles. Some that are shown may have expired even though they are the most recent.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_latest.ini'),
('1579','MOD_ARTICLES_LATEST','Latest News','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_latest.sys.ini'),
('1580','MOD_LATEST_NEWS_XML_DESCRIPTION','This Module shows a list of the most recently published and current Articles. Some that are shown may have expired even though they are the most recent.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_latest.sys.ini'),
('1581','MOD_ARTICLES_LATEST_LAYOUT_DEFAULT','Default','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_latest.sys.ini'),
('1582','MOD_ARTICLES_NEWS','Articles - Newsflash','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_news.ini'),
('1583','MOD_ARTICLES_NEWS_FIELD_CATEGORY_DESC','Select Articles from a specific Category or a set of Categories. If no selection will show all categories as default','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_news.ini'),
('1584','MOD_ARTICLES_NEWS_FIELD_IMAGES_DESC','Display Article images','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_news.ini'),
('1585','MOD_ARTICLES_NEWS_FIELD_IMAGES_LABEL','Show Images','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_news.ini'),
('1586','MOD_ARTICLES_NEWS_FIELD_ITEMS_DESC','The number of Articles to display within this module','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_news.ini'),
('1587','MOD_ARTICLES_NEWS_FIELD_ITEMS_LABEL','Number of Articles','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_news.ini'),
('1588','MOD_ARTICLES_NEWS_FIELD_LINKTITLE_DESC','Link the Article titles to Articles.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_news.ini'),
('1589','MOD_ARTICLES_NEWS_FIELD_LINKTITLE_LABEL','Linked Titles','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_news.ini'),
('1590','MOD_ARTICLES_NEWS_FIELD_ORDERING_DESC','Select the order in which you want query results presented.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_news.ini'),
('1591','MOD_ARTICLES_NEWS_FIELD_ORDERING_LABEL','Order Results','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_news.ini'),
('1592','MOD_ARTICLES_NEWS_FIELD_ORDERING_CREATED_DATE','Created Date','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_news.ini'),
('1593','MOD_ARTICLES_NEWS_FIELD_ORDERING_PUBLISHED_DATE','Published Date','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_news.ini'),
('1594','MOD_ARTICLES_NEWS_FIELD_ORDERING_ORDERING','Ordering','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_news.ini'),
('1595','MOD_ARTICLES_NEWS_FIELD_ORDERING_RANDOM','Random','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_news.ini'),
('1596','MOD_ARTICLES_NEWS_FIELD_READMORE_DESC','If set to Show, the \'Read more...\' link will show if Main text has been provided for an Article.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_news.ini'),
('1597','MOD_ARTICLES_NEWS_FIELD_READMORE_LABEL','\'Read more...\' Link','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_news.ini'),
('1598','MOD_ARTICLES_NEWS_FIELD_SEPARATOR_DESC','Show separator after last Article','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_news.ini'),
('1599','MOD_ARTICLES_NEWS_FIELD_SEPARATOR_LABEL','Show last separator','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_news.ini'),
('1600','MOD_ARTICLES_NEWS_FIELD_TITLE_DESC','Show/hide Article title','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_news.ini');
INSERT INTO `#__overrider` VALUES 
('1601','MOD_ARTICLES_NEWS_FIELD_TITLE_LABEL','Show Article title','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_news.ini'),
('1602','MOD_ARTICLES_NEWS_READMORE','Read more...','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_news.ini'),
('1603','MOD_ARTICLES_NEWS_READMORE_REGISTER','Register to Read More','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_news.ini'),
('1604','MOD_ARTICLES_NEWS_TITLE_HEADING','Header Level','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_news.ini'),
('1605','MOD_ARTICLES_NEWS_TITLE_HEADING_DESCRIPTION','Select the desired HTML header level for the Article titles.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_news.ini'),
('1606','MOD_ARTICLES_NEWS_XML_DESCRIPTION','The Article Newsflash Module will display a fixed number of Articles from a specific Category or a set of Categories.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_news.ini'),
('1607','MOD_ARTICLES_NEWS','Articles - Newsflash','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_news.sys.ini'),
('1608','MOD_ARTICLES_NEWS_XML_DESCRIPTION','The Newsflash Module will display a fixed number of articles from a specific category.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_news.sys.ini'),
('1609','MOD_ARTICLES_NEWS_LAYOUT_DEFAULT','Default','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_news.sys.ini'),
('1610','MOD_ARTICLES_POPULAR','Most Read Content','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_popular.ini'),
('1611','MOD_POPULAR_FIELD_CATEGORY_DESC','Select Articles from a specific Category or a set of Categories. If no selection will show all categories as default','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_popular.ini'),
('1612','MOD_POPULAR_FIELD_COUNT_DESC','The number of Articles to display (the default is 5)','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_popular.ini'),
('1613','MOD_POPULAR_FIELD_COUNT_LABEL','Count','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_popular.ini'),
('1614','MOD_POPULAR_FIELD_FEATURED_DESC','Show/Hide Articles designated as Featured','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_popular.ini'),
('1615','MOD_POPULAR_FIELD_FEATURED_LABEL','Featured Articles','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_popular.ini'),
('1616','MOD_POPULAR_XML_DESCRIPTION','This Module shows a list of the currently published Articles which have the highest number of page views.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_popular.ini'),
('1617','MOD_ARTICLES_POPULAR','Most Read Content','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_popular.sys.ini'),
('1618','MOD_POPULAR_XML_DESCRIPTION','This Module shows a list of the currently published Articles which have the highest number of page views.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_popular.sys.ini'),
('1619','MOD_ARTICLES_POPULAR_LAYOUT_DEFAULT','Default','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_articles_popular.sys.ini'),
('1620','COM_BANNERS_NO_CLIENT','- No client -','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_banners.ini'),
('1621','MOD_BANNERS','Banners','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_banners.ini'),
('1622','MOD_BANNERS_BANNER','Banner','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_banners.ini'),
('1623','MOD_BANNERS_FIELD_BANNERCLIENT_DESC','Select banners only from a single client.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_banners.ini'),
('1624','MOD_BANNERS_FIELD_BANNERCLIENT_LABEL','Client','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_banners.ini'),
('1625','MOD_BANNERS_FIELD_CACHETIME_DESC','The time before the module is recached','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_banners.ini'),
('1626','MOD_BANNERS_FIELD_CACHETIME_LABEL','Cache Time','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_banners.ini'),
('1627','MOD_BANNERS_FIELD_CATEGORY_DESC','Select banners from a specific Category or a set of Categories. If no selection will show all categories as default','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_banners.ini'),
('1628','MOD_BANNERS_FIELD_COUNT_DESC','The number of banners to display (default 5)','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_banners.ini'),
('1629','MOD_BANNERS_FIELD_COUNT_LABEL','Count','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_banners.ini'),
('1630','MOD_BANNERS_FIELD_FOOTER_DESC','Text or HTML to display after the group of banners','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_banners.ini'),
('1631','MOD_BANNERS_FIELD_FOOTER_LABEL','Footer Text','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_banners.ini'),
('1632','MOD_BANNERS_FIELD_HEADER_DESC','Text or HTML to display before the group of banners','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_banners.ini'),
('1633','MOD_BANNERS_FIELD_HEADER_LABEL','Header Text','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_banners.ini'),
('1634','MOD_BANNERS_FIELD_RANDOMISE_DESC','Randomise the ordering of the banners','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_banners.ini'),
('1635','MOD_BANNERS_FIELD_RANDOMISE_LABEL','Randomise','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_banners.ini'),
('1636','MOD_BANNERS_FIELD_TAG_DESC','Banner is selected by matching the banner tags to the current document keywords.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_banners.ini'),
('1637','MOD_BANNERS_FIELD_TAG_LABEL','Search by Tag','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_banners.ini'),
('1638','MOD_BANNERS_FIELD_TARGET_DESC','Target window when the link is clicked','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_banners.ini'),
('1639','MOD_BANNERS_FIELD_TARGET_LABEL','Target','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_banners.ini'),
('1640','MOD_BANNERS_VALUE_STICKYORDERING','Sticky, Ordering','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_banners.ini'),
('1641','MOD_BANNERS_VALUE_STICKYRANDOMISE','Sticky, Randomise','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_banners.ini'),
('1642','MOD_BANNERS_XML_DESCRIPTION','The Banner Module displays the active Banners from the Component.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_banners.ini'),
('1643','MOD_BANNERS','Banners','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_banners.sys.ini'),
('1644','MOD_BANNERS_XML_DESCRIPTION','The Banner Module displays the active Banners from the Component.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_banners.sys.ini'),
('1645','MOD_BANNERS_LAYOUT_DEFAULT','Default','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_banners.sys.ini'),
('1646','MOD_BREADCRUMBS','Breadcrumbs','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_breadcrumbs.ini'),
('1647','MOD_BREADCRUMBS_FIELD_HOMETEXT_DESC','This text will be shown as Home entry. If the field is left empty, it will use the default value from the mod_breadcrumbs.ini language file.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_breadcrumbs.ini'),
('1648','MOD_BREADCRUMBS_FIELD_HOMETEXT_LABEL','Text for Home Entry','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_breadcrumbs.ini'),
('1649','MOD_BREADCRUMBS_FIELD_SEPARATOR_DESC','A text separator','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_breadcrumbs.ini'),
('1650','MOD_BREADCRUMBS_FIELD_SEPARATOR_LABEL','Text Separator','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_breadcrumbs.ini');
INSERT INTO `#__overrider` VALUES 
('1651','MOD_BREADCRUMBS_FIELD_SHOWHERE_DESC','Show/Hide &quot;You are here&quot; text in the Pathway','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_breadcrumbs.ini'),
('1652','MOD_BREADCRUMBS_FIELD_SHOWHERE_LABEL','Show &quot;You are here&quot;','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_breadcrumbs.ini'),
('1653','MOD_BREADCRUMBS_FIELD_SHOWHOME_DESC','Show/Hide the Home element in the Pathway','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_breadcrumbs.ini'),
('1654','MOD_BREADCRUMBS_FIELD_SHOWHOME_LABEL','Show Home','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_breadcrumbs.ini'),
('1655','MOD_BREADCRUMBS_FIELD_SHOWLAST_DESC','Show/Hide the last element in the Pathway','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_breadcrumbs.ini'),
('1656','MOD_BREADCRUMBS_FIELD_SHOWLAST_LABEL','Show Last','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_breadcrumbs.ini'),
('1657','MOD_BREADCRUMBS_HERE','You are here: ','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_breadcrumbs.ini'),
('1658','MOD_BREADCRUMBS_HOME','Home','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_breadcrumbs.ini'),
('1659','MOD_BREADCRUMBS_XML_DESCRIPTION','This Module displays the Breadcrumbs','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_breadcrumbs.ini'),
('1660','MOD_BREADCRUMBS','Breadcrumbs','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_breadcrumbs.sys.ini'),
('1661','MOD_BREADCRUMBS_XML_DESCRIPTION','This Module displays the Breadcrumbs','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_breadcrumbs.sys.ini'),
('1662','MOD_BREADCRUMBS_LAYOUT_DEFAULT','Default','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_breadcrumbs.sys.ini'),
('1663','MOD_CUSTOM','Custom HTML','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_custom.ini'),
('1664','MOD_CUSTOM_FIELD_PREPARE_CONTENT_DESC','Optionally prepare the content with the Joomla Content Plug-ins.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_custom.ini'),
('1665','MOD_CUSTOM_FIELD_PREPARE_CONTENT_LABEL','Prepare Content','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_custom.ini'),
('1666','MOD_CUSTOM_XML_DESCRIPTION','This Module allows you to create your own HTML Module using a WYSIWYG editor.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_custom.ini'),
('1667','MOD_CUSTOM_FIELD_BACKGROUNDIMAGE_LABEL','Select a Background-Image','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_custom.ini'),
('1668','MOD_BACKGROUNDIMAGE_FIELD_LOGO_DESC','If you select an image here it will automatically be inserted as an inline style for the wrapping div element','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_custom.ini'),
('1669','MOD_CUSTOM','Custom HTML','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_custom.sys.ini'),
('1670','MOD_CUSTOM_XML_DESCRIPTION','This Module allows you to create your own HTML Module using a WYSIWYG editor.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_custom.sys.ini'),
('1671','MOD_CUSTOM_LAYOUT_DEFAULT','Default','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_custom.sys.ini'),
('1672','MOD_FEED','Feed Display','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_feed.ini'),
('1673','MOD_FEED_ERR_CACHE','Please make cache directory writeable','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_feed.ini'),
('1674','MOD_FEED_ERR_FEED_NOT_RETRIEVED','Feed not found','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_feed.ini'),
('1675','MOD_FEED_ERR_NO_URL','No feed URL specified.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_feed.ini'),
('1676','MOD_FEED_FIELD_DESCRIPTION_DESC','Show the description text for the entire feed','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_feed.ini'),
('1677','MOD_FEED_FIELD_DESCRIPTION_LABEL','Feed Description','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_feed.ini'),
('1678','MOD_FEED_FIELD_IMAGE_DESC','Show the image associated with the entire feed','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_feed.ini'),
('1679','MOD_FEED_FIELD_IMAGE_LABEL','Feed Image','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_feed.ini'),
('1680','MOD_FEED_FIELD_ITEMDESCRIPTION_DESC','Show the description or intro text of individual RSS items','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_feed.ini'),
('1681','MOD_FEED_FIELD_ITEMDESCRIPTION_LABEL','Item Description','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_feed.ini'),
('1682','MOD_FEED_FIELD_ITEMS_DESC','Enter number of RSS items to display','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_feed.ini'),
('1683','MOD_FEED_FIELD_ITEMS_LABEL','Feed Items','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_feed.ini'),
('1684','MOD_FEED_FIELD_RSSTITLE_DESC','Display news feed title','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_feed.ini'),
('1685','MOD_FEED_FIELD_RSSTITLE_LABEL','Feed Title','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_feed.ini'),
('1686','MOD_FEED_FIELD_RSSURL_DESC','Enter the URL of the RSS/RDF/ATOM feed','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_feed.ini'),
('1687','MOD_FEED_FIELD_RSSURL_LABEL','Feed URL','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_feed.ini'),
('1688','MOD_FEED_FIELD_RTL_DESC','Display feed in RTL direction','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_feed.ini'),
('1689','MOD_FEED_FIELD_RTL_LABEL','RTL Feed','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_feed.ini'),
('1690','MOD_FEED_FIELD_WORDCOUNT_DESC','Allows you to limit the amount of visible Item description text. 0 will show all the text','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_feed.ini'),
('1691','MOD_FEED_FIELD_WORDCOUNT_LABEL','Word Count','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_feed.ini'),
('1692','MOD_FEED_XML_DESCRIPTION','This module allows the displaying of a syndicated feed','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_feed.ini'),
('1693','MOD_FEED','Feed Display','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_feed.sys.ini'),
('1694','MOD_FEED_XML_DESCRIPTION','This module allows the displaying of a syndicated feed','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_feed.sys.ini'),
('1695','MOD_FEED_LAYOUT_DEFAULT','Default','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_feed.sys.ini'),
('1696','COM_FINDER_FILTER_BRANCH_LABEL','Search by %s','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_finder.ini'),
('1697','COM_FINDER_FILTER_SELECT_ALL_LABEL','Search All','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_finder.ini'),
('1698','COM_FINDER_ADVANCED_SEARCH','Advanced Search','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_finder.ini'),
('1699','COM_FINDER_SELECT_SEARCH_FILTER','- No Filter -','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_finder.ini'),
('1700','MOD_FINDER','Smart Search Module','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_finder.ini');
INSERT INTO `#__overrider` VALUES 
('1701','MOD_FINDER_CONFIG_OPTION_BOTTOM','Bottom','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_finder.ini'),
('1702','MOD_FINDER_CONFIG_OPTION_TOP','Top','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_finder.ini'),
('1703','MOD_FINDER_FIELDSET_ADVANCED_ALT_DESCRIPTION','An alternate label for the search field.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_finder.ini'),
('1704','MOD_FINDER_FIELDSET_ADVANCED_ALT_LABEL','Alternate Label','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_finder.ini'),
('1705','MOD_FINDER_FIELDSET_ADVANCED_BUTTON_POS_DESCRIPTION','The position of the search button relative to the search field.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_finder.ini'),
('1706','MOD_FINDER_FIELDSET_ADVANCED_BUTTON_POS_LABEL','Button Position','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_finder.ini'),
('1707','MOD_FINDER_FIELDSET_ADVANCED_FIELD_SIZE_DESCRIPTION','The width of the search field by character length.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_finder.ini'),
('1708','MOD_FINDER_FIELDSET_ADVANCED_FIELD_SIZE_LABEL','Search Field Size','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_finder.ini'),
('1709','MOD_FINDER_FIELDSET_ADVANCED_LABEL_POS_DESCRIPTION','The position of the search label relative to the search field.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_finder.ini'),
('1710','MOD_FINDER_FIELDSET_ADVANCED_LABEL_POS_LABEL','Label Position','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_finder.ini'),
('1711','MOD_FINDER_FIELDSET_ADVANCED_SHOW_BUTTON_DESCRIPTION','Toggle whether a button should be displayed for the search form.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_finder.ini'),
('1712','MOD_FINDER_FIELDSET_ADVANCED_SHOW_BUTTON_LABEL','Search Button','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_finder.ini'),
('1713','MOD_FINDER_FIELDSET_ADVANCED_SHOW_LABEL_DESCRIPTION','Toggle whether a label should be displayed for the search field.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_finder.ini'),
('1714','MOD_FINDER_FIELDSET_ADVANCED_SHOW_LABEL_LABEL','Search Field Label','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_finder.ini'),
('1715','MOD_FINDER_FIELDSET_BASIC_AUTOSUGGEST_DESCRIPTION','Toggle whether automatic search suggestions should be displayed.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_finder.ini'),
('1716','MOD_FINDER_FIELDSET_BASIC_AUTOSUGGEST_LABEL','Search Suggestions','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_finder.ini'),
('1717','MOD_FINDER_FIELDSET_BASIC_SEARCHFILTER_DESCRIPTION','Selecting a Search Filter will limit any searches submitted through this module to use the selected filter.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_finder.ini'),
('1718','MOD_FINDER_FIELDSET_BASIC_SEARCHFILTER_LABEL','Search Filter','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_finder.ini'),
('1719','MOD_FINDER_FIELDSET_BASIC_SHOW_ADVANCED_DESCRIPTION','Toggle whether users should be able to see advanced search options. If set to Link to Component option creates an Smart Search link which redirects to the smart search view. If set to show, the advanced search options will be displayed inline.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_finder.ini'),
('1720','MOD_FINDER_FIELDSET_BASIC_SHOW_ADVANCED_LABEL','Advanced Search','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_finder.ini'),
('1721','MOD_FINDER_FIELDSET_BASIC_SHOW_ADVANCED_OPTION_LINK','Link to Component','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_finder.ini'),
('1722','MOD_FINDER_FIELD_OPENSEARCH_DESCRIPTION','Some Browsers can add support for your site\'s search if this option is enabled.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_finder.ini'),
('1723','MOD_FINDER_FIELD_OPENSEARCH_LABEL','OpenSearch autodiscovery','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_finder.ini'),
('1724','MOD_FINDER_FIELD_OPENSEARCH_TEXT_DESCRIPTION','Text displayed in supported Browsers when adding your site as a search provider.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_finder.ini'),
('1725','MOD_FINDER_FIELD_OPENSEARCH_TEXT_LABEL','OpenSearch title','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_finder.ini'),
('1726','MOD_FINDER_SEARCHBUTTON_TEXT','Search','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_finder.ini'),
('1727','MOD_FINDER_SEARCH_BUTTON','Go','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_finder.ini'),
('1728','MOD_FINDER_SEARCH_VALUE','Search...','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_finder.ini'),
('1729','MOD_FINDER_XML_DESCRIPTION','This is a Smart Search module.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_finder.ini'),
('1730','MOD_FINDER','Smart Search Module','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_finder.sys.ini'),
('1731','MOD_FINDER_XML_DESCRIPTION','This is a search module for the Smart Search system.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_finder.sys.ini'),
('1732','MOD_FOOTER','Footer','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_footer.ini'),
('1733','MOD_FOOTER_LINE1','Copyright &#169; %date% %sitename%. All Rights Reserved.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_footer.ini'),
('1734','MOD_FOOTER_LINE2','<a href="http://www.joomla.org">Joomla!</a> is Free Software released under the <a href="http://www.gnu.org/licenses/gpl-2.0.html">GNU General Public License.</a>','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_footer.ini'),
('1735','MOD_FOOTER_XML_DESCRIPTION','This module shows the Joomla! copyright information.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_footer.ini'),
('1736','MOD_FOOTER','Footer','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_footer.sys.ini'),
('1737','MOD_FOOTER_XML_DESCRIPTION','This module shows the Joomla! copyright information.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_footer.sys.ini'),
('1738','MOD_FOOTER_LAYOUT_DEFAULT','Default','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_footer.sys.ini'),
('1739','MOD_LANGUAGES','Language Switcher','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_languages.ini'),
('1740','MOD_LANGUAGES_FIELD_ACTIVE_DESC','Display or not the active language. If displayed, the class \'lang-active\' will be added to the element.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_languages.ini'),
('1741','MOD_LANGUAGES_FIELD_ACTIVE_LABEL','Active Language','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_languages.ini'),
('1742','MOD_LANGUAGES_FIELD_CACHING_DESC','Select whether to cache or not the content of this module.<br />This should be set to \'No caching\' when using Items Associations.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_languages.ini'),
('1743','MOD_LANGUAGES_FIELD_DROPDOWN_DESC','If set to \'Yes\', the display parameters below will be ignored. The content languages native names will display in a dropdown.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_languages.ini'),
('1744','MOD_LANGUAGES_FIELD_DROPDOWN_LABEL','Use Dropdown','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_languages.ini'),
('1745','MOD_LANGUAGES_FIELD_FOOTER_DESC','This is the text or HTML that is displayed below the language switcher','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_languages.ini'),
('1746','MOD_LANGUAGES_FIELD_FOOTER_LABEL','Post-text','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_languages.ini'),
('1747','MOD_LANGUAGES_FIELD_FULL_NAME_DESC','If set to \'Yes\' and image flags set to \'No\', full content language native names are displayed. If set to \'No\', upper case abbreviations from the content language\'s URL Language Code are used. Example: EN for English, FR for French.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_languages.ini'),
('1748','MOD_LANGUAGES_FIELD_FULL_NAME_LABEL','Languages Full Names','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_languages.ini'),
('1749','MOD_LANGUAGES_FIELD_HEADER_DESC','This is the text or HTML that is displayed above the language switcher','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_languages.ini'),
('1750','MOD_LANGUAGES_FIELD_HEADER_LABEL','Pre-text','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_languages.ini');
INSERT INTO `#__overrider` VALUES 
('1751','MOD_LANGUAGES_FIELD_INLINE_DESC','Default is set to \'Yes\', i.e. to horizontal display.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_languages.ini'),
('1752','MOD_LANGUAGES_FIELD_INLINE_LABEL','Horizontal Display','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_languages.ini'),
('1753','MOD_LANGUAGES_FIELD_MODULE_LAYOUT_DESC','Use a different layout from the supplied module or overrides in the default template.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_languages.ini'),
('1754','MOD_LANGUAGES_FIELD_USEIMAGE_DESC','If set to \'Yes\', will display language choice as image flags. Otherwise will use the content language native names.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_languages.ini'),
('1755','MOD_LANGUAGES_FIELD_USEIMAGE_LABEL','Use Image Flags','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_languages.ini'),
('1756','MOD_LANGUAGES_OPTION_DEFAULT_LANGUAGE','Default','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_languages.ini'),
('1757','MOD_LANGUAGES_SPACERDROP_LABEL','<u>If Use Dropdown is set to \'Yes\', <br />the display options below will be ignored</u>','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_languages.ini'),
('1758','MOD_LANGUAGES_SPACERNAME_LABEL','<u>If Use Image Flags is set to \'Yes\', <br />the display options below will be ignored</u>','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_languages.ini'),
('1759','MOD_LANGUAGES_XML_DESCRIPTION','This module displays a list of available Content Languages (as defined and published in Language Manager Content tab) for switching between them when one wants to use Joomla! as a multilanguage site. <br />--The plugin \'System - Language Filter\' has to be enabled.--<br /> When switching languages and if the item displayed in the page is not associated to another item, the module redirects to the Home page defined for the chosen language.<br /> Otherwise, if the parameter is set for the Language filter plugin, it will redirect to the associated item in the language chosen. Thereafter, the navigation will be the one defined for that language. <br />If the plugin <strong>\'System - Language Filter\'</strong> is disabled, this may have unwanted results.<br /><strong>Method:</strong><br />1. Open Language Manager Content tab and make sure the Languages you want to use in contents are published and have a Language Code for the URL as well as prefix for the image used in the module display.<br />2. Create a Home page by assigning a language to a menu item and defining it as Default Home page for each published content language. <br />  3. Thereafter, you can assign a language to any Article, Category, Module, Newsfeed, Weblinks in Joomla.<br /> 4. Make sure the module is published and the plugin is enabled. <br /> 5. When using associated items, make sure the module is displayed on the pages concerned. <br />6. The way the flags or names of the languages are displayed is defined by the ordering in the Language Manager - Content Languages.<br ><br >If this module is published, it is suggested to publish the administrator multilanguage status module.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_languages.ini'),
('1760','MOD_LANGUAGES','Language Switcher','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_languages.sys.ini'),
('1761','MOD_LANGUAGES_XML_DESCRIPTION','This module displays a list of available Content Languages (as defined and published in Language Manager Content tab) for switching between them when one wants to use Joomla! as a multilanguage site. <br />--The plugin \'System - Language Filter\' has to be enabled.--<br /> When switching languages and if the item displayed in the page is not associated to another item, the module redirects to the Home page defined for the chosen language.<br /> Otherwise, if the parameter is set for the Language filter plugin, it will redirect to the associated item in the language chosen. Thereafter, the navigation will be the one defined for that language. <br />If the plugin <strong>\'System - Language Filter\'</strong> is disabled, this may have unwanted results.<br /><strong>Method:</strong><br />1. Open Language Manager Content tab and make sure the Languages you want to use in contents are published and have a Language Code for the URL as well as prefix for the image used in the module display.<br />2. Create a Home page by assigning a language to a menu item and defining it as Default Home page for each published content language. <br />  3. Thereafter, you can assign a language to any Article, Category, Module, Newsfeed, Weblinks in Joomla.<br /> 4. Make sure the module is published and the plugin is enabled. <br /> 5. When using associated items, make sure the module is displayed on the pages concerned. <br />6. The way the flags or names of the languages are displayed is defined by the ordering in the Language Manager - Content Languages.<br ><br >If this module is published, it is suggested to publish the administrator multilanguage status module.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_languages.sys.ini'),
('1762','MOD_LANGUAGES_LAYOUT_DEFAULT','Default','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_languages.sys.ini'),
('1763','MOD_LOGIN','Login','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_login.ini'),
('1764','MOD_LOGIN_FIELD_GREETING_DESC','Show/Hide the simple greeting text','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_login.ini'),
('1765','MOD_LOGIN_FIELD_GREETING_LABEL','Show Greeting','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_login.ini'),
('1766','MOD_LOGIN_FIELD_LOGIN_REDIRECTURL_DESC','Select the page the user will be redirected to after a successful login. Select from all the pages listed in the dropdown menu. Choosing "Default" will return to the same page.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_login.ini'),
('1767','MOD_LOGIN_FIELD_LOGIN_REDIRECTURL_LABEL','Login Redirection Page','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_login.ini'),
('1768','MOD_LOGIN_FIELD_LOGOUT_REDIRECTURL_DESC','Select the page the user will be redirected to after successfully ending their current session by logging out. Select from all the pages listed in the dropdown menu. Choosing "Default" will return to the same page.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_login.ini'),
('1769','MOD_LOGIN_FIELD_LOGOUT_REDIRECTURL_LABEL','Logout Redirection Page','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_login.ini'),
('1770','MOD_LOGIN_FIELD_NAME_DESC','Displays name or username after logging','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_login.ini'),
('1771','MOD_LOGIN_FIELD_NAME_LABEL','Show Name/Username','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_login.ini'),
('1772','MOD_LOGIN_FIELD_POST_TEXT_DESC','This is the text or HTML that is displayed below the login form.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_login.ini'),
('1773','MOD_LOGIN_FIELD_POST_TEXT_LABEL','Post-text','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_login.ini'),
('1774','MOD_LOGIN_FIELD_PRE_TEXT_DESC','This is the text or HTML that is displayed above the login form.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_login.ini'),
('1775','MOD_LOGIN_FIELD_PRE_TEXT_LABEL','Pre-text','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_login.ini'),
('1776','MOD_LOGIN_FIELD_USESECURE_DESC','Submit encrypted login data (requires SSL).  Do not enable this option if Joomla is not accessible using the https:// protocol prefix.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_login.ini'),
('1777','MOD_LOGIN_FIELD_USESECURE_LABEL','Encrypt Login Form','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_login.ini'),
('1778','MOD_LOGIN_FIELD_USETEXT_DESC','Choose text or icons to display the fields labels. Default is icons','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_login.ini'),
('1779','MOD_LOGIN_FIELD_USETEXT_LABEL','Display Labels','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_login.ini'),
('1780','MOD_LOGIN_FORGOT_YOUR_PASSWORD','Forgot your password?','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_login.ini'),
('1781','MOD_LOGIN_FORGOT_YOUR_USERNAME','Forgot your username?','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_login.ini'),
('1782','MOD_LOGIN_HINAME','Hi %s,','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_login.ini'),
('1783','MOD_LOGIN_REGISTER','Create an account','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_login.ini'),
('1784','MOD_LOGIN_REMEMBER_ME','Remember Me','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_login.ini'),
('1785','MOD_LOGIN_VALUE_ICONS','Icons','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_login.ini'),
('1786','MOD_LOGIN_VALUE_NAME','Name','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_login.ini'),
('1787','MOD_LOGIN_VALUE_TEXT','Text','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_login.ini'),
('1788','MOD_LOGIN_VALUE_USERNAME','User Name','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_login.ini'),
('1789','MOD_LOGIN_XML_DESCRIPTION','This module displays a username and password login form. It also displays a link to retrieve a forgotten password. If user registration is enabled (in User Manager > Options), another link will be shown to enable self-registration for users.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_login.ini'),
('1790','MOD_LOGIN','Login','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_login.sys.ini'),
('1791','MOD_LOGIN_XML_DESCRIPTION','This module displays a username and password login form. It also displays a link to retrieve a forgotten password. If user registration is enabled (in User Manager > Options), another link will be shown to enable self-registration for users.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_login.sys.ini'),
('1792','MOD_LOGIN_LAYOUT_DEFAULT','Default','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_login.sys.ini'),
('1793','MOD_MENU','Menu','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_menu.ini'),
('1794','MOD_MENU_FIELD_ACTIVE_DESC','Select a menu item to always be used as the base for the menu display. You must set the Start Level to the same level or higher than the level of the base item. This will cause the module to be displayed on all assigned pages. If Current is selected the currently active item is used as the base. This causes the module to only display when the parent menu item is active.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_menu.ini'),
('1795','MOD_MENU_FIELD_ACTIVE_LABEL','Base Item','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_menu.ini'),
('1796','MOD_MENU_FIELD_ALLCHILDREN_DESC','Expand the menu and make its sub-menu items always visible.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_menu.ini'),
('1797','MOD_MENU_FIELD_ALLCHILDREN_LABEL','Show Sub-menu Items','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_menu.ini'),
('1798','MOD_MENU_FIELD_CLASS_DESC','A suffix to be applied to the CSS class of the menu items','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_menu.ini'),
('1799','MOD_MENU_FIELD_CLASS_LABEL','Menu Class Suffix','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_menu.ini'),
('1800','MOD_MENU_FIELD_ENDLEVEL_DESC','Level to stop rendering the menu at. If you choose \'All\', all levels will be shown depending on \'Show Sub-menu Items\' setting.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_menu.ini');
INSERT INTO `#__overrider` VALUES 
('1801','MOD_MENU_FIELD_ENDLEVEL_LABEL','End Level','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_menu.ini'),
('1802','MOD_MENU_FIELD_MENUTYPE_DESC','Select a menu in the list','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_menu.ini'),
('1803','MOD_MENU_FIELD_MENUTYPE_LABEL','Select Menu','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_menu.ini'),
('1804','MOD_MENU_FIELD_STARTLEVEL_DESC','Level to start rendering the menu at. Setting the start and end levels to the same # and setting \'Show Sub-menu Items\' to yes will only display that single level.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_menu.ini'),
('1805','MOD_MENU_FIELD_STARTLEVEL_LABEL','Start Level','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_menu.ini'),
('1806','MOD_MENU_FIELD_TAG_ID_DESC','An ID attribute to assign to the root UL tag of the menu (optional)','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_menu.ini'),
('1807','MOD_MENU_FIELD_TAG_ID_LABEL','Menu Tag ID','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_menu.ini'),
('1808','MOD_MENU_FIELD_TARGET_DESC','JavaScript values to position a popup window, e.g. top=50,left=50,width=200,height=300','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_menu.ini'),
('1809','MOD_MENU_FIELD_TARGET_LABEL','Target Position','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_menu.ini'),
('1810','MOD_MENU_XML_DESCRIPTION','This module displays a menu on the frontend.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_menu.ini'),
('1811','MOD_MENU','Menu','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_menu.sys.ini'),
('1812','MOD_MENU_XML_DESCRIPTION','This module displays a menu on the frontend.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_menu.sys.ini'),
('1813','MOD_MENU_LAYOUT_DEFAULT','Default','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_menu.sys.ini'),
('1814','MOD_RANDOM_IMAGE','Random Image','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_random_image.ini'),
('1815','MOD_RANDOM_IMAGE_FIELD_FOLDER_DESC','Path to the image folder relative to the site URL (e.g. images).','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_random_image.ini'),
('1816','MOD_RANDOM_IMAGE_FIELD_FOLDER_LABEL','Image Folder','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_random_image.ini'),
('1817','MOD_RANDOM_IMAGE_FIELD_HEIGHT_DESC','Image Height forces all images to be displayed with the height in pixels.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_random_image.ini'),
('1818','MOD_RANDOM_IMAGE_FIELD_HEIGHT_LABEL','Height (px)','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_random_image.ini'),
('1819','MOD_RANDOM_IMAGE_FIELD_LINK_DESC','A URL to redirect to if the image is clicked upon (e.g. http://www.joomla.org).','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_random_image.ini'),
('1820','MOD_RANDOM_IMAGE_FIELD_LINK_LABEL','Link','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_random_image.ini'),
('1821','MOD_RANDOM_IMAGE_FIELD_TYPE_DESC','Type of image PNG/GIF/JPG etc. (the default is JPG)','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_random_image.ini'),
('1822','MOD_RANDOM_IMAGE_FIELD_TYPE_LABEL','Image Type','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_random_image.ini'),
('1823','MOD_RANDOM_IMAGE_FIELD_WIDTH_DESC','Image Width forces all images to be displayed with this width in pixels.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_random_image.ini'),
('1824','MOD_RANDOM_IMAGE_FIELD_WIDTH_LABEL','Width (px)','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_random_image.ini'),
('1825','MOD_RANDOM_IMAGE_NO_IMAGES','No Images','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_random_image.ini'),
('1826','MOD_RANDOM_IMAGE_XML_DESCRIPTION','This Module displays a random image from your chosen directory.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_random_image.ini'),
('1827','MOD_RANDOM_IMAGE','Random Image','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_random_image.sys.ini'),
('1828','MOD_RANDOM_IMAGE_XML_DESCRIPTION','This Module displays a random image from your chosen directory.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_random_image.sys.ini'),
('1829','MOD_RANDOM_IMAGE_LAYOUT_DEFAULT','Default','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_random_image.sys.ini'),
('1830','MOD_RELATED_FIELD_SHOWDATE_DESC','Show/Hide Date','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_related_items.ini'),
('1831','MOD_RELATED_FIELD_SHOWDATE_LABEL','Show Date','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_related_items.ini'),
('1832','MOD_RELATED_ITEMS','Articles - Related Articles','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_related_items.ini'),
('1833','MOD_RELATED_XML_DESCRIPTION','This Module displays other Articles that are related to the one currently being viewed. These relations are established by the Meta Keywords. <br />All the keywords of the current Article are searched against all the keywords of all other published Articles. For example, you may have an Article on "Breeding Parrots" and another on "Hand Raising Black Cockatoos". If you include the keyword "parrot" in both Articles, then the Related Items Module will list the "Breeding Parrots" Article when viewing "Hand Raising Black Cockatoos" and vice-versa.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_related_items.ini'),
('1834','MOD_RELATED_ITEMS','Articles - Related Articles','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_related_items.sys.ini'),
('1835','MOD_RELATED_XML_DESCRIPTION','This Module displays other Articles that are related to the one currently being viewed. These relations are established by the Meta Keywords. <br />All the keywords of the current Article are searched against all the keywords of all other published Articles. For example, you may have an Article on "Breeding Parrots" and another on "Hand Raising Black Cockatoos". If you include the keyword "parrot" in both Articles, then the Related Items Module will list the "Breeding Parrots" Article when viewing "Hand Raising Black Cockatoos" and vice-versa.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_related_items.sys.ini'),
('1836','MOD_RELATED_ITEMS_LAYOUT_DEFAULT','Default','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_related_items.sys.ini'),
('1837','MOD_SEARCH','Search','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_search.ini'),
('1838','MOD_SEARCH_FIELD_BOXWIDTH_DESC','Size of the search text box in characters','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_search.ini'),
('1839','MOD_SEARCH_FIELD_BOXWIDTH_LABEL','Box Width','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_search.ini'),
('1840','MOD_SEARCH_FIELD_BUTTON_DESC','Display a Search Button','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_search.ini'),
('1841','MOD_SEARCH_FIELD_BUTTON_LABEL','Search Button','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_search.ini'),
('1842','MOD_SEARCH_FIELD_BUTTONPOS_DESC','Position of the button relative to the search box.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_search.ini'),
('1843','MOD_SEARCH_FIELD_BUTTONPOS_LABEL','Button Position','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_search.ini'),
('1844','MOD_SEARCH_FIELD_BUTTONTEXT_DESC','The text that appears in the search button. If left blank, it will load the \'searchbutton\' string from your language file.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_search.ini'),
('1845','MOD_SEARCH_FIELD_BUTTONTEXT_LABEL','Button Text','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_search.ini'),
('1846','MOD_SEARCH_FIELD_IMAGEBUTTON_DESC','Use an image as button. This image has to be named searchButton.gif and must be located in templates/*your template name*/images/','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_search.ini'),
('1847','MOD_SEARCH_FIELD_IMAGEBUTTON_LABEL','Search Button Image','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_search.ini'),
('1848','MOD_SEARCH_FIELD_SETITEMID_DESC','Assign an ItemID for the display of the search results if there is no com_search menu and a specific display is desired. The ItemId may be chosen among those available through the Menu Manager. If you do not know what this means, you may not need it.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_search.ini'),
('1849','MOD_SEARCH_FIELD_SETITEMID_LABEL','Set ItemID','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_search.ini'),
('1850','MOD_SEARCH_FIELD_LABEL_TEXT_DESC','The text that appears in the label of search box. If left blank, it will load \'label\' string from your language file.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_search.ini');
INSERT INTO `#__overrider` VALUES 
('1851','MOD_SEARCH_FIELD_LABEL_TEXT_LABEL','Box Label','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_search.ini'),
('1852','MOD_SEARCH_FIELD_OPENSEARCH_LABEL','OpenSearch autodiscovery','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_search.ini'),
('1853','MOD_SEARCH_FIELD_OPENSEARCH_TEXT_LABEL','OpenSearch title','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_search.ini'),
('1854','MOD_SEARCH_FIELD_OPENSEARCH_TEXT_DESC','Text displayed in supported Browsers when adding your site as a search provider.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_search.ini'),
('1855','MOD_SEARCH_FIELD_OPENSEARCH_DESC','Some Browsers can add support for your site\'s search if this option is enabled.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_search.ini'),
('1856','MOD_SEARCH_FIELD_TEXT_DESC','The text that appears in the search text box. If left blank, it will load \'searchbox\' string from your language file.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_search.ini'),
('1857','MOD_SEARCH_FIELD_TEXT_LABEL','Box Text','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_search.ini'),
('1858','MOD_SEARCH_FIELD_VALUE_BOTTOM','Bottom','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_search.ini'),
('1859','MOD_SEARCH_FIELD_VALUE_LEFT','Left','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_search.ini'),
('1860','MOD_SEARCH_FIELD_VALUE_RIGHT','Right','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_search.ini'),
('1861','MOD_SEARCH_FIELD_VALUE_TOP','Top','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_search.ini'),
('1862','MOD_SEARCH_SEARCHBOX_TEXT','Search...','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_search.ini'),
('1863','MOD_SEARCH_LABEL_TEXT','Search...','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_search.ini'),
('1864','MOD_SEARCH_SEARCHBUTTON_TEXT','Search','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_search.ini'),
('1865','MOD_SEARCH_XML_DESCRIPTION','This module will display a search box.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_search.ini'),
('1866','MOD_SEARCH','Search','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_search.sys.ini'),
('1867','MOD_SEARCH_XML_DESCRIPTION','This module will display a search box.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_search.sys.ini'),
('1868','MOD_SEARCH_LAYOUT_DEFAULT','Default','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_search.sys.ini'),
('1869','MOD_STATS','Statistics','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_stats.ini'),
('1870','MOD_STATS_ARTICLES','Articles','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_stats.ini'),
('1871','MOD_STATS_ARTICLES_VIEW_HITS','Articles View Hits','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_stats.ini'),
('1872','MOD_STATS_CACHING','Caching','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_stats.ini'),
('1873','MOD_STATS_FIELD_COUNTER_DESC','Display Hit Counter','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_stats.ini'),
('1874','MOD_STATS_FIELD_COUNTER_LABEL','Hit Counter','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_stats.ini'),
('1875','MOD_STATS_FIELD_INCREASECOUNTER_DESC','Enter the amount of hits to increase the counter by.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_stats.ini'),
('1876','MOD_STATS_FIELD_INCREASECOUNTER_LABEL','Increase Counter','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_stats.ini'),
('1877','MOD_STATS_FIELD_SERVERINFO_DESC','Display Server Information','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_stats.ini'),
('1878','MOD_STATS_FIELD_SERVERINFO_LABEL','Server Information','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_stats.ini'),
('1879','MOD_STATS_FIELD_SITEINFO_DESC','Display Site Information','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_stats.ini'),
('1880','MOD_STATS_FIELD_SITEINFO_LABEL','Site Information','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_stats.ini'),
('1881','MOD_STATS_GZIP','GZip','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_stats.ini'),
('1882','MOD_STATS_MYSQL','MySQL','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_stats.ini'),
('1883','MOD_STATS_OS','OS','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_stats.ini'),
('1884','MOD_STATS_PHP','PHP','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_stats.ini'),
('1885','MOD_STATS_TIME','Time','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_stats.ini'),
('1886','MOD_STATS_USERS','Visitors','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_stats.ini'),
('1887','MOD_STATS_WEBLINKS','Web Links','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_stats.ini'),
('1888','MOD_STATS_XML_DESCRIPTION','The Statistics Module shows information about your server installation together with statistics on the Web site users, number of Articles in your database and the number of Web links you provide.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_stats.ini'),
('1889','MOD_STATS','Statistics','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_stats.sys.ini'),
('1890','MOD_STATS_XML_DESCRIPTION','The Statistics Module shows information about your server installation together with statistics on the Web site users, number of Articles in your database and the number of Web links you provide.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_stats.sys.ini'),
('1891','MOD_STATS_LAYOUT_DEFAULT','Default','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_stats.sys.ini'),
('1892','MOD_SYNDICATE','Syndication Feeds','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_syndicate.ini'),
('1893','MOD_SYNDICATE_DEFAULT_FEED_ENTRIES','Feed Entries','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_syndicate.ini'),
('1894','MOD_SYNDICATE_FIELD_DISPLAYTEXT_DESC','If set to \'Yes\', text will be displayed next to the icon','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_syndicate.ini'),
('1895','MOD_SYNDICATE_FIELD_DISPLAYTEXT_LABEL','Display Text','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_syndicate.ini'),
('1896','MOD_SYNDICATE_FIELD_FORMAT_DESC','Select the format for the Syndication Feed','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_syndicate.ini'),
('1897','MOD_SYNDICATE_FIELD_FORMAT_LABEL','Feed Format','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_syndicate.ini'),
('1898','MOD_SYNDICATE_FIELD_TEXT_DESC','If \'Display Text\' is activated, the text entered here will be displayed next to the icon along with the RSS Link. If this field is left empty, the default text displayed will be picked from the site language ini file.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_syndicate.ini'),
('1899','MOD_SYNDICATE_FIELD_TEXT_LABEL','Text','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_syndicate.ini'),
('1900','MOD_SYNDICATE_FIELD_VALUE_ATOM','Atom 1.0','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_syndicate.ini');
INSERT INTO `#__overrider` VALUES 
('1901','MOD_SYNDICATE_FIELD_VALUE_RSS','RSS 2.0','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_syndicate.ini'),
('1902','MOD_SYNDICATE_XML_DESCRIPTION','Smart Syndication Module that creates a Syndicated Feed for the page where the Module is displayed.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_syndicate.ini'),
('1903','MOD_SYNDICATE','Syndication Feeds','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_syndicate.sys.ini'),
('1904','MOD_SYNDICATE_XML_DESCRIPTION','Smart Syndication Module that creates a Syndicated Feed for the page where the Module is displayed.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_syndicate.sys.ini'),
('1905','MOD_SYNDICATE_LAYOUT_DEFAULT','Default','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_syndicate.sys.ini'),
('1906','MOD_TAGS_POPULAR','Popular Tags','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_tags_popular.ini'),
('1907','MOD_TAGS_POPULAR_FIELD_ALL_TIME','All time','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_tags_popular.ini'),
('1908','MOD_TAGS_POPULAR_FIELD_LAST_DAY','Last day','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_tags_popular.ini'),
('1909','MOD_TAGS_POPULAR_FIELD_LAST_HOUR','Last hour','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_tags_popular.ini'),
('1910','MOD_TAGS_POPULAR_FIELD_LAST_MONTH','Last month','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_tags_popular.ini'),
('1911','MOD_TAGS_POPULAR_FIELD_LAST_WEEK','Last week','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_tags_popular.ini'),
('1912','MOD_TAGS_POPULAR_FIELD_LAST_YEAR','Last year','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_tags_popular.ini'),
('1913','MOD_TAGS_POPULAR_FIELD_TIMEFRAME_DESC','Sets the time period for which to calculate popularity','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_tags_popular.ini'),
('1914','MOD_TAGS_POPULAR_FIELD_TIMEFRAME_LABEL','Time Period','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_tags_popular.ini'),
('1915','MOD_TAGS_POPULAR_MAX_DESC','Sets the maximum number of tags to display in the module','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_tags_popular.ini'),
('1916','MOD_TAGS_POPULAR_MAX_LABEL','Maximum tags','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_tags_popular.ini'),
('1917','MOD_TAGS_POPULAR_XML_DESCRIPTION','The Popular Tags Module displays the most commonly used tags, optionally within specific time periods.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_tags_popular.ini'),
('1918','MOD_TAGS_POPULAR','Popular Tags','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_tags_popular.sys.ini'),
('1919','MOD_TAGS_POPULAR_LAYOUT_DEFAULT','Default','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_tags_popular.sys.ini'),
('1920','MOD_TAGS_POPULAR_XML_DESCRIPTION','The Popular Tags Module displays the most commonly used tags, optionally within specific time periods.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_tags_popular.sys.ini'),
('1921','MOD_TAGS_SIMILAR','Similar Tags','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_tags_similar.ini'),
('1922','MOD_TAGS_SIMILAR_FIELD_ALL','All','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_tags_similar.ini'),
('1923','MOD_TAGS_SIMILAR_FIELD_HALF','Half','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_tags_similar.ini'),
('1924','MOD_TAGS_SIMILAR_FIELD_MATCHTYPE_DESC','How closely an item\'s tags need to match. All - requires that all tags in the displayed item be matched. Any - requires that at least one tag match. Half - requires that at least half of the tags match (rounded up in the case of decimals).','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_tags_similar.ini'),
('1925','MOD_TAGS_SIMILAR_FIELD_MATCHTYPE_LABEL','Match type','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_tags_similar.ini'),
('1926','MOD_TAGS_SIMILAR_FIELD_ONE','Any','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_tags_similar.ini'),
('1927','MOD_TAGS_SIMILAR_LAYOUT_DEFAULT','Default','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_tags_similar.ini'),
('1928','MOD_TAGS_SIMILAR_MAX_DESC','Maximum number of items to display','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_tags_similar.ini'),
('1929','MOD_TAGS_SIMILAR_MAX_LABEL','Maximum items','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_tags_similar.ini'),
('1930','MOD_TAGS_SIMILAR_NO_MATCHING_TAGS','No matching tags','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_tags_similar.ini'),
('1931','MOD_TAGS_SIMILAR_XML_DESCRIPTION','The Similar Tags Module displays links to other items with similar tags. The closeness of the match can be specified.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_tags_similar.ini'),
('1932','MOD_TAGS_SIMILAR','Similar Tags','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_tags_similar.sys.ini'),
('1933','MOD_TAGS_SIMILAR_LAYOUT_DEFAULT','Default','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_tags_similar.sys.ini'),
('1934','MOD_TAGS_SIMILAR_XML_DESCRIPTION','The Similar Tags Module displays links to other items with similar tags. The closeness of the match can be specified.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_tags_similar.sys.ini'),
('1935','MOD_USERS_LATEST','Latest Users','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_users_latest.ini'),
('1936','MOD_USERS_LATEST_FIELD_FILTER_GROUPS_DESC','Choose to filter by groups of the connected user','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_users_latest.ini'),
('1937','MOD_USERS_LATEST_FIELD_FILTER_GROUPS_LABEL','Filter groups','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_users_latest.ini'),
('1938','MOD_USERS_LATEST_FIELD_LINKTOWHAT_DESC','Choose the type of information to display','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_users_latest.ini'),
('1939','MOD_USERS_LATEST_FIELD_LINKTOWHAT_LABEL','User Information','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_users_latest.ini'),
('1940','MOD_USERS_LATEST_FIELD_NUMBER_DESC','Number of latest registered users to display','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_users_latest.ini'),
('1941','MOD_USERS_LATEST_FIELD_NUMBER_LABEL','Number of Users','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_users_latest.ini'),
('1942','MOD_USERS_LATEST_FIELD_VALUE_CONTACT','Contact','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_users_latest.ini'),
('1943','MOD_USERS_LATEST_FIELD_VALUE_PROFILE','Profile','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_users_latest.ini'),
('1944','MOD_USERS_LATEST_XML_DESCRIPTION','This module displays the latest registered users','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_users_latest.ini'),
('1945','MOD_USERS_LATEST','Latest Users','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_users_latest.sys.ini'),
('1946','MOD_USERS_LATEST_XML_DESCRIPTION','This module displays the latest registered users','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_users_latest.sys.ini'),
('1947','MOD_USERS_LATEST_LAYOUT_DEFAULT','Default','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_users_latest.sys.ini'),
('1948','MOD_WEBLINKS','Weblinks','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_weblinks.ini'),
('1949','MOD_WEBLINKS_FIELD_CATEGORY_DESC','Choose the weblinks category to display','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_weblinks.ini'),
('1950','MOD_WEBLINKS_FIELD_COUNT_DESC','Number of weblinks to display','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_weblinks.ini');
INSERT INTO `#__overrider` VALUES 
('1951','MOD_WEBLINKS_FIELD_COUNT_LABEL','Count','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_weblinks.ini'),
('1952','MOD_WEBLINKS_FIELD_COUNTCLICKS_DESC','If set to yes, the number of times the link has been clicked will be recorded','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_weblinks.ini'),
('1953','MOD_WEBLINKS_FIELD_COUNTCLICKS_LABEL','Count Clicks','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_weblinks.ini'),
('1954','MOD_WEBLINKS_FIELD_DESCRIPTION_DESC','Display Weblink description','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_weblinks.ini'),
('1955','MOD_WEBLINKS_FIELD_DESCRIPTION_LABEL','Description','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_weblinks.ini'),
('1956','MOD_WEBLINKS_FIELD_FOLLOW_DESC','Robots index - allow to follow or not','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_weblinks.ini'),
('1957','MOD_WEBLINKS_FIELD_FOLLOW_LABEL','Follow/No Follow','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_weblinks.ini'),
('1958','MOD_WEBLINKS_FIELD_HITS_DESC','Show Hits','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_weblinks.ini'),
('1959','MOD_WEBLINKS_FIELD_HITS_LABEL','Hits','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_weblinks.ini'),
('1960','MOD_WEBLINKS_FIELD_ORDERDIRECTION_DESC','Set the ordering direction','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_weblinks.ini'),
('1961','MOD_WEBLINKS_FIELD_ORDERDIRECTION_LABEL','Direction','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_weblinks.ini'),
('1962','MOD_WEBLINKS_FIELD_ORDERING_DESC','Ordering for the weblinks','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_weblinks.ini'),
('1963','MOD_WEBLINKS_FIELD_ORDERING_LABEL','Ordering','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_weblinks.ini'),
('1964','MOD_WEBLINKS_FIELD_TARGET_DESC','Target browser window when the link is clicked','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_weblinks.ini'),
('1965','MOD_WEBLINKS_FIELD_TARGET_LABEL','Target Window','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_weblinks.ini'),
('1966','MOD_WEBLINKS_FIELD_VALUE_ASCENDING','Ascending','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_weblinks.ini'),
('1967','MOD_WEBLINKS_FIELD_VALUE_DESCENDING','Descending','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_weblinks.ini'),
('1968','MOD_WEBLINKS_FIELD_VALUE_FOLLOW','Follow','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_weblinks.ini'),
('1969','MOD_WEBLINKS_FIELD_VALUE_HITS','Hits','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_weblinks.ini'),
('1970','MOD_WEBLINKS_FIELD_VALUE_NOFOLLOW','No follow','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_weblinks.ini'),
('1971','MOD_WEBLINKS_FIELD_VALUE_ORDER','Order','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_weblinks.ini'),
('1972','MOD_WEBLINKS_HITS','Hits','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_weblinks.ini'),
('1973','MOD_WEBLINKS_XML_DESCRIPTION','This modules displays weblinks from a category defined in the Weblinks component.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_weblinks.ini'),
('1974','MOD_WEBLINKS','Weblinks','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_weblinks.sys.ini'),
('1975','MOD_WEBLINKS_XML_DESCRIPTION','This modules displays weblinks from a category defined in the Weblinks component.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_weblinks.sys.ini'),
('1976','MOD_WEBLINKS_LAYOUT_DEFAULT','Default','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_weblinks.sys.ini'),
('1977','MOD_WHOSONLINE','Who\'s Online','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_whosonline.ini'),
('1978','MOD_WHOSONLINE_FIELD_FILTER_GROUPS_DESC','Choose to filter by groups of the connected user','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_whosonline.ini'),
('1979','MOD_WHOSONLINE_FIELD_FILTER_GROUPS_LABEL','Filter groups','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_whosonline.ini'),
('1980','MOD_WHOSONLINE_FIELD_LINKTOWHAT_DESC','Choose the type of information to display','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_whosonline.ini'),
('1981','MOD_WHOSONLINE_FIELD_LINKTOWHAT_LABEL','Information','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_whosonline.ini'),
('1982','MOD_WHOSONLINE_FIELD_VALUE_BOTH','Both','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_whosonline.ini'),
('1983','MOD_WHOSONLINE_FIELD_VALUE_CONTACT','Contact','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_whosonline.ini'),
('1984','MOD_WHOSONLINE_FIELD_VALUE_NAMES','User names','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_whosonline.ini'),
('1985','MOD_WHOSONLINE_FIELD_VALUE_NUMBER','# of Guests / Users','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_whosonline.ini'),
('1986','MOD_WHOSONLINE_FIELD_VALUE_PROFILE','Profile','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_whosonline.ini'),
('1987','MOD_WHOSONLINE_GUESTS','%s&#160;guests','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_whosonline.ini'),
('1988','MOD_WHOSONLINE_GUESTS_1','one guest','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_whosonline.ini'),
('1989','MOD_WHOSONLINE_GUESTS_0','no guests','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_whosonline.ini'),
('1990','MOD_WHOSONLINE_MEMBERS','%s&#160;members','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_whosonline.ini'),
('1991','MOD_WHOSONLINE_MEMBERS_1','one member','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_whosonline.ini'),
('1992','MOD_WHOSONLINE_MEMBERS_0','no members','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_whosonline.ini'),
('1993','MOD_WHOSONLINE_SAME_GROUP_MESSAGE','List of Users who belong to your user groups or your user groups\' child groups','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_whosonline.ini'),
('1994','MOD_WHOSONLINE_SHOWMODE_DESC','Select what shall be shown','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_whosonline.ini'),
('1995','MOD_WHOSONLINE_SHOWMODE_LABEL','Display','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_whosonline.ini'),
('1996','MOD_WHOSONLINE_XML_DESCRIPTION','The Who\'s Online Module displays the number of Anonymous Users (e.g. Guests) and Registered Users (ones logged-in) that are currently accessing the Web site.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_whosonline.ini'),
('1997','MOD_WHOSONLINE_WE_HAVE','We have %1$s and %2$s online','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_whosonline.ini'),
('1998','MOD_WHOSONLINE','Who\'s Online','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_whosonline.sys.ini'),
('1999','MOD_WHOSONLINE_XML_DESCRIPTION','The Who\'s Online Module displays the number of Anonymous Users (e.g. Guests) and Registered Users (ones logged-in) that are currently accessing the Web site.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_whosonline.sys.ini'),
('2000','MOD_WHOSONLINE_LAYOUT_DEFAULT','Default','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_whosonline.sys.ini');
INSERT INTO `#__overrider` VALUES 
('2001','MOD_WRAPPER','Wrapper','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_wrapper.ini'),
('2002','MOD_WRAPPER_FIELD_ADD_DESC','By default, http:// will be added unless it detects http:// or https:// in the URL you provide. This allows you to switch this ability off.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_wrapper.ini'),
('2003','MOD_WRAPPER_FIELD_ADD_LABEL','Auto Add','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_wrapper.ini'),
('2004','MOD_WRAPPER_FIELD_AUTOHEIGHT_DESC','The height will automatically be set to the size of the external page. This will only work for pages on your own domain.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_wrapper.ini'),
('2005','MOD_WRAPPER_FIELD_AUTOHEIGHT_LABEL','Auto Height','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_wrapper.ini'),
('2006','MOD_WRAPPER_FIELD_HEIGHT_DESC','Height of the iFrame window','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_wrapper.ini'),
('2007','MOD_WRAPPER_FIELD_HEIGHT_LABEL','Height','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_wrapper.ini'),
('2008','MOD_WRAPPER_FIELD_SCROLL_DESC','Show/Hide Horizontal &amp; Vertical Scroll Bars.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_wrapper.ini'),
('2009','MOD_WRAPPER_FIELD_SCROLL_LABEL','Scroll Bars','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_wrapper.ini'),
('2010','MOD_WRAPPER_FIELD_TARGET_DESC','Name of the iFrame when used as Target','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_wrapper.ini'),
('2011','MOD_WRAPPER_FIELD_TARGET_LABEL','Target Name','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_wrapper.ini'),
('2012','MOD_WRAPPER_FIELD_URL_DESC','URL to site/file you wish to display within the iframe.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_wrapper.ini'),
('2013','MOD_WRAPPER_FIELD_URL_LABEL','URL','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_wrapper.ini'),
('2014','MOD_WRAPPER_FIELD_VALUE_AUTO','Auto','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_wrapper.ini'),
('2015','MOD_WRAPPER_FIELD_WIDTH_DESC','Width of the iFrame window. You can enter an absolute figure in pixels or a relative figure by adding a %.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_wrapper.ini'),
('2016','MOD_WRAPPER_FIELD_WIDTH_LABEL','Width','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_wrapper.ini'),
('2017','MOD_WRAPPER_NO_IFRAMES','No Iframes','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_wrapper.ini'),
('2018','MOD_WRAPPER_XML_DESCRIPTION','This module shows an iFrame window to specified location.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_wrapper.ini'),
('2019','MOD_WRAPPER_FIELD_FRAME_LABEL','Frame border','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_wrapper.ini'),
('2020','MOD_WRAPPER_FIELD_FRAME_DESC','Show frame border which wraps the iframe','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_wrapper.ini'),
('2021','MOD_WRAPPER','Wrapper','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_wrapper.sys.ini'),
('2022','MOD_WRAPPER_NO_IFRAMES','No Iframes','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_wrapper.sys.ini'),
('2023','MOD_WRAPPER_XML_DESCRIPTION','This Module shows an iframe window to specified location.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_wrapper.sys.ini'),
('2024','MOD_WRAPPER_LAYOUT_DEFAULT','Default','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.mod_wrapper.sys.ini'),
('2025','TPL_BEEZ3_ADDITIONAL_INFORMATION','Additional information','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_beez3.ini'),
('2026','TPL_BEEZ3_ALTCLOSE','is closed','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_beez3.ini'),
('2027','TPL_BEEZ3_ALTOPEN','is open','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_beez3.ini'),
('2028','TPL_BEEZ3_BIGGER','Bigger','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_beez3.ini'),
('2029','TPL_BEEZ3_CLICK','click','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_beez3.ini'),
('2030','TPL_BEEZ3_CLOSEMENU','Close Menu','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_beez3.ini'),
('2031','TPL_BEEZ3_DECREASE_SIZE','Decrease size','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_beez3.ini'),
('2032','TPL_BEEZ3_ERROR_JUMP_TO_NAV','Jump to navigation','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_beez3.ini'),
('2033','TPL_BEEZ3_FIELD_BOOTSTRAP_DESC','Create a comma separated list of any components for which Bootstrap is needed, for example com_name, com_anothername.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_beez3.ini'),
('2034','TPL_BEEZ3_FIELD_BOOTSTRAP_LABEL','Components Requiring<br/> Bootstrap','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_beez3.ini'),
('2035','TPL_BEEZ3_FIELD_DESCRIPTION_DESC','Please add your site description here','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_beez3.ini'),
('2036','TPL_BEEZ3_FIELD_DESCRIPTION_LABEL','Site Description','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_beez3.ini'),
('2037','TPL_BEEZ3_FIELD_HEADER_BACKGROUND_COLOR_DESC','Background colour used if the custom colour option is selected','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_beez3.ini'),
('2038','TPL_BEEZ3_FIELD_HEADER_BACKGROUND_COLOR_LABEL','Background Colour','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_beez3.ini'),
('2039','TPL_BEEZ3_FIELD_HEADER_IMAGE_DESC','Use the selected header image when the custom colour option is selected','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_beez3.ini'),
('2040','TPL_BEEZ3_FIELD_HEADER_IMAGE_LABEL','Header Image','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_beez3.ini'),
('2041','TPL_BEEZ3_FIELD_LOGO_DESC','Please choose an image. If you do not want to display a logo, click on Clear and leave the field blank.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_beez3.ini'),
('2042','TPL_BEEZ3_FIELD_LOGO_LABEL','Logo','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_beez3.ini'),
('2043','TPL_BEEZ3_FIELD_NAVPOSITION_DESC','Navigation before or after content','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_beez3.ini'),
('2044','TPL_BEEZ3_FIELD_NAVPOSITION_LABEL','Position of Navigation','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_beez3.ini'),
('2045','TPL_BEEZ3_FIELD_SITETITLE_DESC','Please add your site title here, it\'s only displayed if you don\'t use a logo','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_beez3.ini'),
('2046','TPL_BEEZ3_FIELD_SITETITLE_LABEL','Site Title','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_beez3.ini'),
('2047','TPL_BEEZ3_FIELD_TEMPLATECOLOR_DESC','Colour of the template','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_beez3.ini'),
('2048','TPL_BEEZ3_FIELD_TEMPLATECOLOR_LABEL','Template colour','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_beez3.ini'),
('2049','TPL_BEEZ3_FIELD_WRAPPERLARGE_DESC','Wrapper width with closed additional columns in percent','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_beez3.ini'),
('2050','TPL_BEEZ3_FIELD_WRAPPERLARGE_LABEL','Wrapper Large (%)','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_beez3.ini');
INSERT INTO `#__overrider` VALUES 
('2051','TPL_BEEZ3_FIELD_WRAPPERSMALL_DESC','Wrapper width with opened additional columns in percent','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_beez3.ini'),
('2052','TPL_BEEZ3_FIELD_WRAPPERSMALL_LABEL','Wrapper Small (%)','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_beez3.ini'),
('2053','TPL_BEEZ3_FONTSIZE','Font size','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_beez3.ini'),
('2054','TPL_BEEZ3_INCREASE_SIZE','Increase size','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_beez3.ini'),
('2055','TPL_BEEZ3_JUMP_TO_INFO','Jump to additional information','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_beez3.ini'),
('2056','TPL_BEEZ3_JUMP_TO_NAV','Jump to main navigation and login','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_beez3.ini'),
('2057','TPL_BEEZ3_NAVIGATION','Navigation','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_beez3.ini'),
('2058','TPL_BEEZ3_NAV_VIEW_SEARCH','Nav view search','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_beez3.ini'),
('2059','TPL_BEEZ3_NEXTTAB','Next Tab','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_beez3.ini'),
('2060','TPL_BEEZ3_OPENMENU','Open Menu','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_beez3.ini'),
('2061','TPL_BEEZ3_OPTION_AFTER_CONTENT','after content','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_beez3.ini'),
('2062','TPL_BEEZ3_OPTION_BEFORE_CONTENT','before content','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_beez3.ini'),
('2063','TPL_BEEZ3_OPTION_IMAGE','Custom','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_beez3.ini'),
('2064','TPL_BEEZ3_OPTION_NATURE','Nature','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_beez3.ini'),
('2065','TPL_BEEZ3_OPTION_PERSONAL','Personal','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_beez3.ini'),
('2066','TPL_BEEZ3_OPTION_RED','Red','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_beez3.ini'),
('2067','TPL_BEEZ3_OPTION_TURQ','Turquoise','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_beez3.ini'),
('2068','TPL_BEEZ3_POWERED_BY','Powered by','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_beez3.ini'),
('2069','TPL_BEEZ3_RESET','Reset','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_beez3.ini'),
('2070','TPL_BEEZ3_REVERT_STYLES_TO_DEFAULT','Revert styles to default','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_beez3.ini'),
('2071','TPL_BEEZ3_SEARCH','Search','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_beez3.ini'),
('2072','TPL_BEEZ3_SKIP_TO_CONTENT','Skip to content','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_beez3.ini'),
('2073','TPL_BEEZ3_SKIP_TO_ERROR_CONTENT','Jump to error message and search','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_beez3.ini'),
('2074','TPL_BEEZ3_SMALLER','Smaller','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_beez3.ini'),
('2075','TPL_BEEZ3_SYSTEM_MESSAGE','Error','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_beez3.ini'),
('2076','TPL_BEEZ3_TEXTRIGHTCLOSE','Close info','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_beez3.ini'),
('2077','TPL_BEEZ3_TEXTRIGHTOPEN','Open info','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_beez3.ini'),
('2078','TPL_BEEZ3_XML_DESCRIPTION','Accessible template for Joomla! Beez, the HTML 4 version.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_beez3.ini'),
('2079','TPL_BEEZ3_YOUR_SITE_DESCRIPTION','Your site description','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_beez3.ini'),
('2080','TPL_BEEZ3_POSITION_DEBUG','Debug','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_beez3.sys.ini'),
('2081','TPL_BEEZ3_POSITION_POSITION-0','Search','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_beez3.sys.ini'),
('2082','TPL_BEEZ3_POSITION_POSITION-10','Footer middle','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_beez3.sys.ini'),
('2083','TPL_BEEZ3_POSITION_POSITION-11','Footer bottom','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_beez3.sys.ini'),
('2084','TPL_BEEZ3_POSITION_POSITION-12','Middle top','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_beez3.sys.ini'),
('2085','TPL_BEEZ3_POSITION_POSITION-13','Unused','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_beez3.sys.ini'),
('2086','TPL_BEEZ3_POSITION_POSITION-14','Footer last','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_beez3.sys.ini'),
('2087','TPL_BEEZ3_POSITION_POSITION-15','Header','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_beez3.sys.ini'),
('2088','TPL_BEEZ3_POSITION_POSITION-1','Top','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_beez3.sys.ini'),
('2089','TPL_BEEZ3_POSITION_POSITION-2','Breadcrumbs','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_beez3.sys.ini'),
('2090','TPL_BEEZ3_POSITION_POSITION-3','Right bottom','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_beez3.sys.ini'),
('2091','TPL_BEEZ3_POSITION_POSITION-4','Left middle','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_beez3.sys.ini'),
('2092','TPL_BEEZ3_POSITION_POSITION-5','Left bottom','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_beez3.sys.ini'),
('2093','TPL_BEEZ3_POSITION_POSITION-6','Right top','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_beez3.sys.ini'),
('2094','TPL_BEEZ3_POSITION_POSITION-7','Left top','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_beez3.sys.ini'),
('2095','TPL_BEEZ3_POSITION_POSITION-8','Right middle','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_beez3.sys.ini'),
('2096','TPL_BEEZ3_POSITION_POSITION-9','Footer top','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_beez3.sys.ini'),
('2097','TPL_BEEZ3_XML_DESCRIPTION','Accessible template for Joomla! Beez, the HTML 4 version.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_beez3.sys.ini'),
('2098','TPL_PROTOSTAR_XML_DESCRIPTION','Continuing the space theme (Solarflare from 1.0 and Milkyway from 1.5), Protostar is the Joomla 3.0 site template based on Bootstrap from Twitter and the launch of the Joomla User Interface library (JUI).','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_protostar.ini'),
('2099','TPL_PROTOSTAR_BACKGROUND_COLOR_DESC','Choose a background colour for static layouts. Default is #F4F6F7','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_protostar.ini'),
('2100','TPL_PROTOSTAR_BACKGROUND_COLOR_LABEL','Background Colour','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_protostar.ini');
INSERT INTO `#__overrider` VALUES 
('2101','TPL_PROTOSTAR_BACKTOTOP','Back to Top','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_protostar.ini'),
('2102','TPL_PROTOSTAR_COLOR_LABEL','Template Colour','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_protostar.ini'),
('2103','TPL_PROTOSTAR_COLOR_DESC','Choose an overall colour for the site template. Default is #08C','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_protostar.ini'),
('2104','TPL_PROTOSTAR_FLUID','Fluid','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_protostar.ini'),
('2105','TPL_PROTOSTAR_FLUID_LABEL','Fluid Layout','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_protostar.ini'),
('2106','TPL_PROTOSTAR_FLUID_DESC','Use Bootstrap\'s Fluid or Static Container (both are Responsive)','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_protostar.ini'),
('2107','TPL_PROTOSTAR_FONT_LABEL','Google Font for Headings','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_protostar.ini'),
('2108','TPL_PROTOSTAR_FONT_DESC','Load a Google font for the headings (H1, H2, H3, etc.)','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_protostar.ini'),
('2109','TPL_PROTOSTAR_FONT_NAME_LABEL','Google Font Name','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_protostar.ini'),
('2110','TPL_PROTOSTAR_FONT_NAME_DESC','Example: Open+Sans or Source+Sans+Pro','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_protostar.ini'),
('2111','TPL_PROTOSTAR_LOGO_LABEL','Logo','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_protostar.ini'),
('2112','TPL_PROTOSTAR_LOGO_DESC','Upload a custom logo for the site template.','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_protostar.ini'),
('2113','TPL_PROTOSTAR_STATIC','Static','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_protostar.ini'),
('2114','TPL_PROTOSTAR_POSITION_DEBUG','Debug','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_protostar.sys.ini'),
('2115','TPL_PROTOSTAR_POSITION_POSITION-0','Search','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_protostar.sys.ini'),
('2116','TPL_PROTOSTAR_POSITION_POSITION-10','Unused','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_protostar.sys.ini'),
('2117','TPL_PROTOSTAR_POSITION_POSITION-11','Unused','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_protostar.sys.ini'),
('2118','TPL_PROTOSTAR_POSITION_POSITION-12','Unused','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_protostar.sys.ini'),
('2119','TPL_PROTOSTAR_POSITION_POSITION-13','Unused','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_protostar.sys.ini'),
('2120','TPL_PROTOSTAR_POSITION_POSITION-14','Unused','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_protostar.sys.ini'),
('2121','TPL_PROTOSTAR_POSITION_POSITION-15','Unused','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_protostar.sys.ini'),
('2122','TPL_PROTOSTAR_POSITION_POSITION-1','Navigation','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_protostar.sys.ini'),
('2123','TPL_PROTOSTAR_POSITION_POSITION-2','Breadcrumbs','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_protostar.sys.ini'),
('2124','TPL_PROTOSTAR_POSITION_POSITION-3','Top center','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_protostar.sys.ini'),
('2125','TPL_PROTOSTAR_POSITION_POSITION-4','Unused','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_protostar.sys.ini'),
('2126','TPL_PROTOSTAR_POSITION_POSITION-5','Unused','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_protostar.sys.ini'),
('2127','TPL_PROTOSTAR_POSITION_POSITION-6','Unused','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_protostar.sys.ini'),
('2128','TPL_PROTOSTAR_POSITION_POSITION-7','Right','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_protostar.sys.ini'),
('2129','TPL_PROTOSTAR_POSITION_POSITION-8','Left','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_protostar.sys.ini'),
('2130','TPL_PROTOSTAR_POSITION_POSITION-9','Unused','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_protostar.sys.ini'),
('2131','TPL_PROTOSTAR_POSITION_FOOTER','Footer','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_protostar.sys.ini'),
('2132','TPL_PROTOSTAR_XML_DESCRIPTION','Continuing the space theme (Solarflare from 1.0 and Milkyway from 1.5), Protostar is the Joomla 3.0 site template based on Bootstrap from Twitter and the launch of the Joomla User Interface library (JUI).','/home/akdevsil/public_html/j3/jm-minima/language/en-GB/en-GB.tpl_protostar.sys.ini'),
('2133','COM_DJCATALOG2','DJ-Catalog2','/home/akdevsil/public_html/j3/jm-minima/components/com_djcatalog2/language/en-GB/en-GB.com_djcatalog2.ini'),
('2134','COM_DJCATALOG2_READMORE','More...','/home/akdevsil/public_html/j3/jm-minima/components/com_djcatalog2/language/en-GB/en-GB.com_djcatalog2.ini'),
('2135','COM_DJCATALOG2_PRODUCT_NOT_FOUND','Incorrect product page','/home/akdevsil/public_html/j3/jm-minima/components/com_djcatalog2/language/en-GB/en-GB.com_djcatalog2.ini'),
('2136','COM_DJCATALOG2_PRODUCER_NOT_FOUND','Incorrect producer page','/home/akdevsil/public_html/j3/jm-minima/components/com_djcatalog2/language/en-GB/en-GB.com_djcatalog2.ini'),
('2137','COM_DJCATALOG2_PAGE_NOT_FOUND','Page not found','/home/akdevsil/public_html/j3/jm-minima/components/com_djcatalog2/language/en-GB/en-GB.com_djcatalog2.ini'),
('2138','COM_DJCATALOG2_CATEGORY','Category','/home/akdevsil/public_html/j3/jm-minima/components/com_djcatalog2/language/en-GB/en-GB.com_djcatalog2.ini'),
('2139','COM_DJCATALOG2_PRODUCER','Manufacturer','/home/akdevsil/public_html/j3/jm-minima/components/com_djcatalog2/language/en-GB/en-GB.com_djcatalog2.ini'),
('2140','COM_DJCATALOG2_PRICE','Price','/home/akdevsil/public_html/j3/jm-minima/components/com_djcatalog2/language/en-GB/en-GB.com_djcatalog2.ini'),
('2141','COM_DJCATALOG2_NAME','Name','/home/akdevsil/public_html/j3/jm-minima/components/com_djcatalog2/language/en-GB/en-GB.com_djcatalog2.ini'),
('2142','COM_DJCATALOG2_DESCRIPTION','Description','/home/akdevsil/public_html/j3/jm-minima/components/com_djcatalog2/language/en-GB/en-GB.com_djcatalog2.ini'),
('2143','COM_DJCATALOG2_SELECT_CATEGORY','Choose Category','/home/akdevsil/public_html/j3/jm-minima/components/com_djcatalog2/language/en-GB/en-GB.com_djcatalog2.ini'),
('2144','COM_DJCATALOG2_SELECT_PRODUCER','Choose Manufacturer','/home/akdevsil/public_html/j3/jm-minima/components/com_djcatalog2/language/en-GB/en-GB.com_djcatalog2.ini'),
('2145','COM_DJCATALOG2_SEARCH_RESTRICTION','Search term must be a minimum of 3 characters and a maximum of 20 characters!','/home/akdevsil/public_html/j3/jm-minima/components/com_djcatalog2/language/en-GB/en-GB.com_djcatalog2.ini'),
('2146','COM_DJCATALOG2_SUBCATEGORIES','Sub Categories','/home/akdevsil/public_html/j3/jm-minima/components/com_djcatalog2/language/en-GB/en-GB.com_djcatalog2.ini'),
('2147','COM_DJCATALOG2_BROWSE','Browse','/home/akdevsil/public_html/j3/jm-minima/components/com_djcatalog2/language/en-GB/en-GB.com_djcatalog2.ini'),
('2148','COM_DJCATALOG2_ORDERBY','Order','/home/akdevsil/public_html/j3/jm-minima/components/com_djcatalog2/language/en-GB/en-GB.com_djcatalog2.ini'),
('2149','COM_DJCATALOG2_FILTER','Filters','/home/akdevsil/public_html/j3/jm-minima/components/com_djcatalog2/language/en-GB/en-GB.com_djcatalog2.ini'),
('2150','COM_DJCATALOG2_SEARCH','Search','/home/akdevsil/public_html/j3/jm-minima/components/com_djcatalog2/language/en-GB/en-GB.com_djcatalog2.ini');
INSERT INTO `#__overrider` VALUES 
('2151','COM_DJCATALOG2_GO','Go','/home/akdevsil/public_html/j3/jm-minima/components/com_djcatalog2/language/en-GB/en-GB.com_djcatalog2.ini'),
('2152','COM_DJCATALOG2_RESET','Reset','/home/akdevsil/public_html/j3/jm-minima/components/com_djcatalog2/language/en-GB/en-GB.com_djcatalog2.ini'),
('2153','COM_DJCATALOG2_NO_ITEMS_FOUND','There aren\'t any products matching supplied criteria...','/home/akdevsil/public_html/j3/jm-minima/components/com_djcatalog2/language/en-GB/en-GB.com_djcatalog2.ini'),
('2154','COM_DJCATALOG2_FILE_HITS','%s hits','/home/akdevsil/public_html/j3/jm-minima/components/com_djcatalog2/language/en-GB/en-GB.com_djcatalog2.ini'),
('2155','COM_DJCATALOG2_FILES','Attachments','/home/akdevsil/public_html/j3/jm-minima/components/com_djcatalog2/language/en-GB/en-GB.com_djcatalog2.ini'),
('2156','COM_DJCATALOG2_DATE','Date','/home/akdevsil/public_html/j3/jm-minima/components/com_djcatalog2/language/en-GB/en-GB.com_djcatalog2.ini'),
('2157','COM_DJCATALOG2_RELATED_ITEMS','Related items','/home/akdevsil/public_html/j3/jm-minima/components/com_djcatalog2/language/en-GB/en-GB.com_djcatalog2.ini'),
('2158','COM_DJCATALOG2_FEATURED_ITEM','Featured item','/home/akdevsil/public_html/j3/jm-minima/components/com_djcatalog2/language/en-GB/en-GB.com_djcatalog2.ini'),
('2159','COM_DJCATALOG2_SHOW_PRODUCERS_ITEMS','show products','/home/akdevsil/public_html/j3/jm-minima/components/com_djcatalog2/language/en-GB/en-GB.com_djcatalog2.ini'),
('2160','COM_DJCATALOG2_FORM_LABEL','Ask about this product','/home/akdevsil/public_html/j3/jm-minima/components/com_djcatalog2/language/en-GB/en-GB.com_djcatalog2.ini'),
('2161','COM_DJCATALOG2_CONTACT_EMAIL_NAME_LABEL','Name','/home/akdevsil/public_html/j3/jm-minima/components/com_djcatalog2/language/en-GB/en-GB.com_djcatalog2.ini'),
('2162','COM_DJCATALOG2_EMAIL_LABEL','Email','/home/akdevsil/public_html/j3/jm-minima/components/com_djcatalog2/language/en-GB/en-GB.com_djcatalog2.ini'),
('2163','COM_DJCATALOG2_CONTACT_MESSAGE_SUBJECT_LABEL','Subject','/home/akdevsil/public_html/j3/jm-minima/components/com_djcatalog2/language/en-GB/en-GB.com_djcatalog2.ini'),
('2164','COM_DJCATALOG2_CONTACT_ENTER_MESSAGE_LABEL','Message','/home/akdevsil/public_html/j3/jm-minima/components/com_djcatalog2/language/en-GB/en-GB.com_djcatalog2.ini'),
('2165','COM_DJCATALOG2_CONTACT_EMAIL_A_COPY_LABEL','Send me a copy?','/home/akdevsil/public_html/j3/jm-minima/components/com_djcatalog2/language/en-GB/en-GB.com_djcatalog2.ini'),
('2166','COM_DJCATALOG2_CONTACT_SEND','Send','/home/akdevsil/public_html/j3/jm-minima/components/com_djcatalog2/language/en-GB/en-GB.com_djcatalog2.ini'),
('2167','COM_DJCATALOG2_EMAIL_THANKS','Thankyou! Your message has been sent','/home/akdevsil/public_html/j3/jm-minima/components/com_djcatalog2/language/en-GB/en-GB.com_djcatalog2.ini'),
('2168','COM_DJCATALOG2_OPTIONAL','optional','/home/akdevsil/public_html/j3/jm-minima/components/com_djcatalog2/language/en-GB/en-GB.com_djcatalog2.ini'),
('2169','COM_DJCATALOG2_CONTACT_FORM_OPEN','Ask about this product','/home/akdevsil/public_html/j3/jm-minima/components/com_djcatalog2/language/en-GB/en-GB.com_djcatalog2.ini'),
('2170','COM_DJCATALOG2_CONTACT_FORM_CLOSE','Close form','/home/akdevsil/public_html/j3/jm-minima/components/com_djcatalog2/language/en-GB/en-GB.com_djcatalog2.ini'),
('2171','COM_DJCATALOG2_CAPTCHA_LABEL','Verification','/home/akdevsil/public_html/j3/jm-minima/components/com_djcatalog2/language/en-GB/en-GB.com_djcatalog2.ini'),
('2172','COM_DJCATALOG2_COPYSUBJECT_OF','Copy of: %s','/home/akdevsil/public_html/j3/jm-minima/components/com_djcatalog2/language/en-GB/en-GB.com_djcatalog2.ini'),
('2173','COM_DJCATALOG2_COPYTEXT_OF','This is a copy of the following message concerning \'%s\' you sent via %s','/home/akdevsil/public_html/j3/jm-minima/components/com_djcatalog2/language/en-GB/en-GB.com_djcatalog2.ini'),
('2174','COM_DJCATALOG2_MAILENQUIRY','%s Enquiry','/home/akdevsil/public_html/j3/jm-minima/components/com_djcatalog2/language/en-GB/en-GB.com_djcatalog2.ini'),
('2175','COM_DJCATALOG2_ENQUIRY_TEXT','This is an enquiry email via %s concerning \'%s\' from:','/home/akdevsil/public_html/j3/jm-minima/components/com_djcatalog2/language/en-GB/en-GB.com_djcatalog2.ini'),
('2176','COM_DJCATALOG2_CUSTOM_ATTRIBUTES','Additional data','/home/akdevsil/public_html/j3/jm-minima/components/com_djcatalog2/language/en-GB/en-GB.com_djcatalog2.ini'),
('2177','COM_DJCATALOG2_COMMENTS','Comments','/home/akdevsil/public_html/j3/jm-minima/components/com_djcatalog2/language/en-GB/en-GB.com_djcatalog2.ini'),
('2178','COM_DJCATALOG2_PREVIOUS','&laquo; previous','/home/akdevsil/public_html/j3/jm-minima/components/com_djcatalog2/language/en-GB/en-GB.com_djcatalog2.ini'),
('2179','COM_DJCATALOG2_NEXT','next &raquo;','/home/akdevsil/public_html/j3/jm-minima/components/com_djcatalog2/language/en-GB/en-GB.com_djcatalog2.ini'),
('2180','COM_DJMEDIATOOLS','DJ-MediaTools','/home/akdevsil/public_html/j3/jm-minima/components/com_djmediatools/language/en-GB/en-GB.com_djmediatools.ini'),
('2181','COM_DJMEDIATOOLS_SUBCATEGORIES','Child albums','/home/akdevsil/public_html/j3/jm-minima/components/com_djmediatools/language/en-GB/en-GB.com_djmediatools.ini'),
('2182','COM_DJMEDIATOOLS_EMPTY_CATEGORY','This album doesn\'t contain any items','/home/akdevsil/public_html/j3/jm-minima/components/com_djmediatools/language/en-GB/en-GB.com_djmediatools.ini'),
('2183','COM_DJMEDIATOOLS_ERROR_INVALID_HELPER_CLASS','DJ-Mediatools layout helper class (%s) doesn\'t exist','/home/akdevsil/public_html/j3/jm-minima/components/com_djmediatools/language/en-GB/en-GB.com_djmediatools.ini'),
('2184','COM_DJMEDIATOOLS_READMORE','Read more »','/home/akdevsil/public_html/j3/jm-minima/components/com_djmediatools/language/en-GB/en-GB.com_djmediatools.ini'),
('2185','COM_DJMEDIATOOLS_ITEM_CURRENT_OF_TOTAL','%s of %s','/home/akdevsil/public_html/j3/jm-minima/components/com_djmediatools/language/en-GB/en-GB.com_djmediatools.ini'),
('2186','MOD_DJC2CATEGORIES','DJ-Catalog2 Categories','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2categories/language/en-GB/en-GB.mod_djc2categories.ini'),
('2187','MOD_DJC2CATEGORIES_DESC','DJ-Catalog2 Categories Module','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2categories/language/en-GB/en-GB.mod_djc2categories.ini'),
('2188','MOD_DJC2CATEGORIES_EXPAND','Expand categories','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2categories/language/en-GB/en-GB.mod_djc2categories.ini'),
('2189','MOD_DJC2CATEGORIES_NO','No','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2categories/language/en-GB/en-GB.mod_djc2categories.ini'),
('2190','MOD_DJC2CATEGORIES_YES','Yes','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2categories/language/en-GB/en-GB.mod_djc2categories.ini'),
('2191','MOD_DJC2CATEGORIES_ALL','Root category','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2categories/language/en-GB/en-GB.mod_djc2categories.ini'),
('2192','MOD_DJC2CATEGORIES_CATEGORY','Category','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2categories/language/en-GB/en-GB.mod_djc2categories.ini'),
('2193','MOD_DJC2CATEGORIES_CATEGORY_DESC','You may choose which category should be treated as root category. Module will render category tree starting from chosen category.','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2categories/language/en-GB/en-GB.mod_djc2categories.ini'),
('2194','MOD_DJC2CATEGORIES','DJ-Catalog2 Categories','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2categories/language/en-GB/en-GB.mod_djc2categories.sys.ini'),
('2195','MOD_DJC2CATEGORIES_DESC','DJ-Catalog2 Categories Module','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2categories/language/en-GB/en-GB.mod_djc2categories.sys.ini'),
('2196','MOD_DJC2FILTERS','DJ-Catalog2 Filters Module','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2filters/language/en-GB/en-GB.mod_djc2filters.ini'),
('2197','MOD_DJC2FILTERS_RESET','<strong> &times; </strong>','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2filters/language/en-GB/en-GB.mod_djc2filters.ini'),
('2198','MOD_DJC2FILTERS_RESET_LABEL','reset','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2filters/language/en-GB/en-GB.mod_djc2filters.ini'),
('2199','MOD_DJC2FILTERS_GROUP_TITLE','Group title','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2filters/language/en-GB/en-GB.mod_djc2filters.ini'),
('2200','MOD_DJC2FILTERS_GROUP_NAME','Filter %s','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2filters/language/en-GB/en-GB.mod_djc2filters.ini');
INSERT INTO `#__overrider` VALUES 
('2201','MOD_DJC2FILTERS_FIELD_GROUPS','Field groups','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2filters/language/en-GB/en-GB.mod_djc2filters.ini'),
('2202','MOD_DJC2FILTERS_FIELD_GROUPS_DESC','Select for which field groups should filters be displayed. Leave empty to display all.','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2filters/language/en-GB/en-GB.mod_djc2filters.ini'),
('2203','MOD_DJC2FILTERS_CATEGORIES','Categories','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2filters/language/en-GB/en-GB.mod_djc2filters.ini'),
('2204','MOD_DJC2FILTERS_CATEGORIES_DESC','Select in which categories should filters be displayed. Leave empty to display everywhere.','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2filters/language/en-GB/en-GB.mod_djc2filters.ini'),
('2205','MOD_DJC2FILTERS_MODULE_VISIBILITY','Show module','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2filters/language/en-GB/en-GB.mod_djc2filters.ini'),
('2206','MOD_DJC2FILTERS_MODULE_VISIBILITY_DESC','Choose on which pages should the module be displayed','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2filters/language/en-GB/en-GB.mod_djc2filters.ini'),
('2207','MOD_DJC2FILTERS_MODULE_VISIBILITY_EVERYWHERE','Everywhere - no restrictions','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2filters/language/en-GB/en-GB.mod_djc2filters.ini'),
('2208','MOD_DJC2FILTERS_MODULE_VISIBILITY_ITEMS_VIEW','Product list only','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2filters/language/en-GB/en-GB.mod_djc2filters.ini'),
('2209','MOD_DJC2FILTERS_MODULE_VISIBILITY_ITEMS_N_ITEM_VIEW','Product list and single product pages','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2filters/language/en-GB/en-GB.mod_djc2filters.ini'),
('2210','MOD_DJC2FILTERS_ROOT_CATEGORY','Root Category','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2filters/language/en-GB/en-GB.mod_djc2filters.ini'),
('2211','MOD_DJC2FILTERS','DJ-Catalog2 Filters Module','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2filters/language/en-GB/en-GB.mod_djc2filters.sys.ini'),
('2212','MOD_DJC2FRONTPAGE','DJ-Catalog2 Frontpage','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2frontpage/language/en-GB/en-GB.mod_djc2frontpage.ini'),
('2213','MOD_DJC2FRONTPAGE_MODULE_DESCRIPTION','DJ-Catalog2 FrontPage Module','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2frontpage/language/en-GB/en-GB.mod_djc2frontpage.ini'),
('2214','MOD_DJC2FRONTPAGE_CONFIG_CSSSTYLE','CSS Style','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2frontpage/language/en-GB/en-GB.mod_djc2frontpage.ini'),
('2215','MOD_DJC2FRONTPAGE_CONFIG_CSSSTYLE_DESC','Choose CSS Stylesheet for DJ-Catalog2.','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2frontpage/language/en-GB/en-GB.mod_djc2frontpage.ini'),
('2216','MOD_DJC2FRONTPAGE_STYLE_DEFAULT','Default','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2frontpage/language/en-GB/en-GB.mod_djc2frontpage.ini'),
('2217','MOD_DJC2FRONTPAGE_STYLE_LIGHT','Light','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2frontpage/language/en-GB/en-GB.mod_djc2frontpage.ini'),
('2218','MOD_DJC2FRONTPAGE_STYLE_BOOTSTRAP','Bootstrap','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2frontpage/language/en-GB/en-GB.mod_djc2frontpage.ini'),
('2219','MOD_DJC2FRONTPAGE_SHOW_TITLE','Show title','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2frontpage/language/en-GB/en-GB.mod_djc2frontpage.ini'),
('2220','MOD_DJC2FRONTPAGE_SHOW_CATTITLE','Show category name','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2frontpage/language/en-GB/en-GB.mod_djc2frontpage.ini'),
('2221','MOD_DJC2FRONTPAGE_SHOW_PAGINATION','Show pagination','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2frontpage/language/en-GB/en-GB.mod_djc2frontpage.ini'),
('2222','MOD_DJC2FRONTPAGE_ORDERBY','Order by','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2frontpage/language/en-GB/en-GB.mod_djc2frontpage.ini'),
('2223','MOD_DJC2FRONTPAGE_ORDERING','Fixed order','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2frontpage/language/en-GB/en-GB.mod_djc2frontpage.ini'),
('2224','MOD_DJC2FRONTPAGE_NAME','Name','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2frontpage/language/en-GB/en-GB.mod_djc2frontpage.ini'),
('2225','MOD_DJC2FRONTPAGE_PRODUCER','Producer','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2frontpage/language/en-GB/en-GB.mod_djc2frontpage.ini'),
('2226','MOD_DJC2FRONTPAGE_CATEGORY','Category','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2frontpage/language/en-GB/en-GB.mod_djc2frontpage.ini'),
('2227','MOD_DJC2FRONTPAGE_PRICE','Price','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2frontpage/language/en-GB/en-GB.mod_djc2frontpage.ini'),
('2228','MOD_DJC2FRONTPAGE_YES','Yes','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2frontpage/language/en-GB/en-GB.mod_djc2frontpage.ini'),
('2229','MOD_DJC2FRONTPAGE_NO','No','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2frontpage/language/en-GB/en-GB.mod_djc2frontpage.ini'),
('2230','MOD_DJC2FRONTPAGE_CATEGORIES','Categories','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2frontpage/language/en-GB/en-GB.mod_djc2frontpage.ini'),
('2231','MOD_DJC2FRONTPAGE_CATEGORIES_DESC','Hold CTRL to select more than one category','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2frontpage/language/en-GB/en-GB.mod_djc2frontpage.ini'),
('2232','MOD_DJC2FRONTPAGE_THCOLS','Thumbnail columns','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2frontpage/language/en-GB/en-GB.mod_djc2frontpage.ini'),
('2233','MOD_DJC2FRONTPAGE_THROWS','Thumbnail rows','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2frontpage/language/en-GB/en-GB.mod_djc2frontpage.ini'),
('2234','MOD_DJC2FRONTPAGE_SHOW_FOOTER','Show footer','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2frontpage/language/en-GB/en-GB.mod_djc2frontpage.ini'),
('2235','MOD_DJC2FRONTPAGE_READMORE','Readmore...','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2frontpage/language/en-GB/en-GB.mod_djc2frontpage.ini'),
('2236','MOD_DJC2FRONTPAGE_CATEGORIESSWITCH','Select categories','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2frontpage/language/en-GB/en-GB.mod_djc2frontpage.ini'),
('2237','MOD_DJC2FRONTPAGE_SELECTED','Selected','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2frontpage/language/en-GB/en-GB.mod_djc2frontpage.ini'),
('2238','MOD_DJC2FRONTPAGE_ALL','All','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2frontpage/language/en-GB/en-GB.mod_djc2frontpage.ini'),
('2239','MOD_DJC2FRONTPAGE_MAINIMAGE','Image size','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2frontpage/language/en-GB/en-GB.mod_djc2frontpage.ini'),
('2240','MOD_DJC2FRONTPAGE_LARGE','Large','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2frontpage/language/en-GB/en-GB.mod_djc2frontpage.ini'),
('2241','MOD_DJC2FRONTPAGE_MEDIUM','Medium','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2frontpage/language/en-GB/en-GB.mod_djc2frontpage.ini'),
('2242','MOD_DJC2FRONTPAGE_DESCRIPTION_TRUNCATE','Intro text truncate','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2frontpage/language/en-GB/en-GB.mod_djc2frontpage.ini'),
('2243','MOD_DJC2FRONTPAGE_DESCRIPTION_TRUNCATE_DESC','Notice! Turning on this option will remove all HTML tags from description.','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2frontpage/language/en-GB/en-GB.mod_djc2frontpage.ini'),
('2244','MOD_DJC2FRONTPAGE_DESCRIPTION_TRUNCATE_LENGTH','Intro text length','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2frontpage/language/en-GB/en-GB.mod_djc2frontpage.ini'),
('2245','MOD_DJC2FRONTPAGE_DESCRIPTION_TRUNCATE_LENGTH_DESC','Maximum number of characters.','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2frontpage/language/en-GB/en-GB.mod_djc2frontpage.ini'),
('2246','MOD_DJC2FRONTPAGE_ORDERBYDIR','Order direction','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2frontpage/language/en-GB/en-GB.mod_djc2frontpage.ini'),
('2247','MOD_DJC2FRONTPAGE_ASC','Ascending','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2frontpage/language/en-GB/en-GB.mod_djc2frontpage.ini'),
('2248','MOD_DJC2FRONTPAGE_DESC','Descending','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2frontpage/language/en-GB/en-GB.mod_djc2frontpage.ini'),
('2249','MOD_DJC2FRONTPAGE_ID','ID','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2frontpage/language/en-GB/en-GB.mod_djc2frontpage.ini'),
('2250','MOD_DJC2FRONTPAGE_DATE','Date','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2frontpage/language/en-GB/en-GB.mod_djc2frontpage.ini');
INSERT INTO `#__overrider` VALUES 
('2251','MOD_DJC2FRONTPAGE_FEATURED_FIRST','Featured first','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2frontpage/language/en-GB/en-GB.mod_djc2frontpage.ini'),
('2252','MOD_DJC2FRONTPAGE_FEATURED_ONLY','Featured only','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2frontpage/language/en-GB/en-GB.mod_djc2frontpage.ini'),
('2253','MOD_DJC2FRONTPAGE_SHOW_READMORE','Read-more button','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2frontpage/language/en-GB/en-GB.mod_djc2frontpage.ini'),
('2254','MOD_DJC2FRONTPAGE_READMORE_TEXT','Read-more label','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2frontpage/language/en-GB/en-GB.mod_djc2frontpage.ini'),
('2255','MOD_DJC2FRONTPAGE_LINK_TITLE','Link title','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2frontpage/language/en-GB/en-GB.mod_djc2frontpage.ini'),
('2256','MOD_DJC2FRONTPAGE_CONFIG_LAYOUT','Layout','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2frontpage/language/en-GB/en-GB.mod_djc2frontpage.ini'),
('2257','MOD_DJC2FRONTPAGE_CONFIG_LAYOUT_DESC','Your template may not support every layout','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2frontpage/language/en-GB/en-GB.mod_djc2frontpage.ini'),
('2258','MOD_DJC2FRONTPAGE_LAYOUT_DEFAULT','Default','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2frontpage/language/en-GB/en-GB.mod_djc2frontpage.ini'),
('2259','MOD_DJC2FRONTPAGE_LAYOUT_TABLELESS','Fluid','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2frontpage/language/en-GB/en-GB.mod_djc2frontpage.ini'),
('2260','MOD_DJC2FRONTPAGE_CONFIG_RESPONSIVE_WIDTH','Max width','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2frontpage/language/en-GB/en-GB.mod_djc2frontpage.ini'),
('2261','MOD_DJC2FRONTPAGE_CONFIG_RESPONSIVE_WIDTH_DESC','Max width','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2frontpage/language/en-GB/en-GB.mod_djc2frontpage.ini'),
('2262','MOD_DJC2FRONTPAGE_LARGE_IMG_PROCESS','Large image process','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2frontpage/language/en-GB/en-GB.mod_djc2frontpage.ini'),
('2263','MOD_DJC2FRONTPAGE_LARGE_IMG_WIDTH','Large image width','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2frontpage/language/en-GB/en-GB.mod_djc2frontpage.ini'),
('2264','MOD_DJC2FRONTPAGE_LARGE_IMG_HEIGHT','Large image height','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2frontpage/language/en-GB/en-GB.mod_djc2frontpage.ini'),
('2265','MOD_DJC2FRONTPAGE_SMALL_IMG_PROCESS','Small image process','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2frontpage/language/en-GB/en-GB.mod_djc2frontpage.ini'),
('2266','MOD_DJC2FRONTPAGE_SMALL_IMG_WIDTH','Small image width','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2frontpage/language/en-GB/en-GB.mod_djc2frontpage.ini'),
('2267','MOD_DJC2FRONTPAGE_SMALL_IMG_HEIGHT','Small image height','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2frontpage/language/en-GB/en-GB.mod_djc2frontpage.ini'),
('2268','MOD_DJC2FRONTPAGE_IMG_PROCESS_DESC','Choose if you want an image to cropped or not','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2frontpage/language/en-GB/en-GB.mod_djc2frontpage.ini'),
('2269','MOD_DJC2FRONTPAGE_IMG_WIDTH_DESC','Pixel width - numeric value (without \'px\')','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2frontpage/language/en-GB/en-GB.mod_djc2frontpage.ini'),
('2270','MOD_DJC2FRONTPAGE_IMG_HEIGHT_DESC','Pixel height - numeric value (without \'px\')','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2frontpage/language/en-GB/en-GB.mod_djc2frontpage.ini'),
('2271','COM_DJCATALOG2_CONFIG_IMAGE_RESIZE_AND_CROP','Resize & Crop','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2frontpage/language/en-GB/en-GB.mod_djc2frontpage.ini'),
('2272','COM_DJCATALOG2_CONFIG_IMAGE_RESIZE','Resize','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2frontpage/language/en-GB/en-GB.mod_djc2frontpage.ini'),
('2273','MOD_DJC2FRONTPAGE_NAVIGATION','Navigation','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2frontpage/language/en-GB/en-GB.mod_djc2frontpage.ini'),
('2274','MOD_DJC2FRONTPAGE_PAGINATION','Pagination','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2frontpage/language/en-GB/en-GB.mod_djc2frontpage.ini'),
('2275','MOD_DJC2FRONTPAGE_ARROWS','Next/Prev','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2frontpage/language/en-GB/en-GB.mod_djc2frontpage.ini'),
('2276','MOD_DJC2FRONTPAGE_NONE','None','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2frontpage/language/en-GB/en-GB.mod_djc2frontpage.ini'),
('2277','MOD_DJC2FRONTPAGE','DJ-Catalog2 Frontpage','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2frontpage/language/en-GB/en-GB.mod_djc2frontpage.sys.ini'),
('2278','MOD_DJC2FRONTPAGE_MODULE_DESCRIPTION','DJ-Catalog2 FrontPage Module','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2frontpage/language/en-GB/en-GB.mod_djc2frontpage.sys.ini'),
('2279','MOD_DJC2ITEMS','DJ-Catalog2 Items','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2280','MOD_DJC2ITEMS_DESC','Descending','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2281','MOD_DJC2ITEMS_READMORE','More...','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2282','MOD_DJC2ITEMS_PRODUCT_NOT_FOUND','Incorrect product page','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2283','MOD_DJC2ITEMS_PRODUCER_NOT_FOUND','Incorrect producer page','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2284','MOD_DJC2ITEMS_PAGE_NOT_FOUND','Page not found','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2285','MOD_DJC2ITEMS_CATEGORY','Category','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2286','MOD_DJC2ITEMS_PRODUCER','Manufacturer','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2287','MOD_DJC2ITEMS_PRICE','Price','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2288','MOD_DJC2ITEMS_NEW_PRICE','New price','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2289','MOD_DJC2ITEMS_OLD_PRICE','Old price','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2290','MOD_DJC2ITEMS_NAME','Name','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2291','MOD_DJC2ITEMS_DESCRIPTION','Description','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2292','MOD_DJC2ITEMS_CATEGORIESSWITCH','Categories','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2293','MOD_DJC2ITEMS_CATEGORIESSWITCH_DESC','Select categories','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2294','MOD_DJC2ITEMS_SELECT_CATEGORY','Choose Category','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2295','MOD_DJC2ITEMS_SELECT_PRODUCER','Choose Manufacturer','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2296','MOD_DJC2ITEMS_SEARCH_RESTRICTION','Search term must be a minimum of 3 characters and a maximum of 20 characters!','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2297','MOD_DJC2ITEMS_SUBCATEGORIES','Sub Categories','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2298','MOD_DJC2ITEMS_BROWSE','Browse','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2299','MOD_DJC2ITEMS_ORDERBY','Order','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2300','MOD_DJC2ITEMS_FILTER','Filter','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini');
INSERT INTO `#__overrider` VALUES 
('2301','MOD_DJC2ITEMS_SEARCH','Search','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2302','MOD_DJC2ITEMS_GO','Go','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2303','MOD_DJC2ITEMS_RESET','Reset','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2304','MOD_DJC2ITEMS_NO_ITEMS_FOUND','There aren\'t any products matching supplied criteria...','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2305','MOD_DJC2ITEMS_FEATURED_ONLY','Featured only','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2306','MOD_DJC2ITEMS_FEATURED_FIRST','Featured first','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2307','MOD_DJC2ITEMS_SPECIAL_ONLY','On special only','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2308','MOD_DJC2ITEMS_CATEGORY_GROUPPING','Category groupping','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2309','MOD_DJC2ITEMS_ITEM_COLUMNS','Columns','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2310','MOD_DJC2ITEMS_DEFAULTORDER','Default order','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2311','MOD_DJC2ITEMS_ORDERDIR','Order direction','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2312','MOD_DJC2ITEMS_ASC','Ascending','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2313','MOD_DJC2ITEMS_CONFIG_HIDE','Hide','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2314','MOD_DJC2ITEMS_CONFIG_SHOW','Show','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2315','MOD_DJC2ITEMS_CONFIG_YES','Yes','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2316','MOD_DJC2ITEMS_CONFIG_NO','No','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2317','MOD_DJC2ITEMS_CONFIG_SHOW_CATEGORY_NAME','Category name','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2318','MOD_DJC2ITEMS_CONFIG_SHOW_CATEGORY_NAME_DESC','Displaying category name','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2319','MOD_DJC2ITEMS_CONFIG_SHOW_PRODUCER_NAME','Producer name','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2320','MOD_DJC2ITEMS_CONFIG_SHOW_PRODUCER_NAME_DESC','Displaying producer name','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2321','MOD_DJC2ITEMS_CONFIG_TEXT','As text','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2322','MOD_DJC2ITEMS_CONFIG_LINK','As link','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2323','MOD_DJC2ITEMS_CONFIG_PRODUCER_LIGHTBOX','Link to producer lightbox','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2324','MOD_DJC2ITEMS_CONFIG_PRODUCER_LINK','Link to producer description','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2325','MOD_DJC2ITEMS_CONFIG_SHOW_PRICE','Price','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2326','MOD_DJC2ITEMS_CONFIG_SHOW_PRICE_DESC','Show price','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2327','MOD_DJC2ITEMS_CONFIG_PRICE_ALWAYS','Always','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2328','MOD_DJC2ITEMS_CONFIG_PRICE_ONLY_IF_GTT0','Only if &gt; 0','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2329','MOD_DJC2ITEMS_CONFIG_SHOW_ITEM_INTRO_DESCRIPTION','Description','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2330','MOD_DJC2ITEMS_CONFIG_SHOW_ITEM_INTRO_DESCRIPTION_DESC','Display product description','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2331','MOD_DJC2ITEMS_CONFIG_SHOW_ITEM_INTRO_DESCRIPTION_TRUNCATE','Truncate description','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2332','MOD_DJC2ITEMS_CONFIG_SHOW_ITEM_INTRO_DESCRIPTION_TRUNCATE_DESC','<strong>NOTICE!</strong>: turning on this option will remove all HTML tags from description.','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2333','MOD_DJC2ITEMS_CONFIG_SHOW_ITEM_INTRO_DESCRIPTION_LENGTH','Description length','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2334','MOD_DJC2ITEMS_CONFIG_SHOW_ITEM_INTRO_DESCRIPTION_LENGTH_DESC','Product description character limit','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2335','MOD_DJC2ITEMS_CONFIG_SHOW_ITEM_IMAGE_BEHAVIOR','Image on-click behavior','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2336','MOD_DJC2ITEMS_CONFIG_SHOW_ITEM_IMAGE_BEHAVIOR_DESC','You may choose between showing the image in the slimbox or redirecting to item','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2337','MOD_DJC2ITEMS_CONFIG_SHOW_ITEM_READMORE','Readmore','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2338','MOD_DJC2ITEMS_CONFIG_SHOW_ITEM_READMORE_DESC','Display readmore','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2339','MOD_DJC2ITEMS_CONFIG_REDIRECT','Redirect / Browse','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2340','MOD_DJC2ITEMS_CONFIG_LIGHTBOX','Slimbox','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2341','COM_DJCATALOG_SELECT_ROOT_CAT','All Categories','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2342','MOD_DJC2ITEMS_RANDOM','Random','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2343','MOD_DJC2ITEMS_LIMIT_DESC','Maximum number of items. 0 = no limit','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2344','MOD_DJC2ITEMS_LIMIT','Count','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2345','MOD_DJC2ITEMS_CATEGORY_PATH','In','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2346','MOD_DJC2_ITEM_READMORE','More...','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2347','MOD_DJC2_ITEM_POPULAR_BLOG','Popular!','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2348','MOD_DJC2ITEMS_THUMB_TYPE','Image size','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2349','MOD_DJC2ITEMS_SMALL','Small - (same as in table view)','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2350','MOD_DJC2ITEMS_MEDIUM','Medium - (same as in list view)','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini');
INSERT INTO `#__overrider` VALUES 
('2351','MOD_DJC2ITEMS_LARGE','Large - (main picture in product view)','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2352','MOD_DJC2ITEMS_FRONTPAGE','Frontpage - (same as in frontpage module)','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2353','MOD_DJC2ITEMS_CONFIG_SHOW_IMAGE','Show image','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2354','MOD_DJC2ITEMS_IMG_PROCESS','Image process','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2355','MOD_DJC2ITEMS_IMG_WIDTH','Image width','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2356','MOD_DJC2ITEMS_IMG_HEIGHT','Image height','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2357','MOD_DJC2ITEMS_IMG_PROCESS_DESC','Choose if you want an image to cropped or not','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2358','MOD_DJC2ITEMS_IMG_WIDTH_DESC','Pixel width - numeric value (without \'px\')','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2359','MOD_DJC2ITEMS_IMG_HEIGHT_DESC','Pixel height - numeric value (without \'px\')','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2360','MOD_DJC2ITEMS_IMAGE_RESIZE_AND_CROP','Resize & Crop','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2361','MOD_DJC2ITEMS_IMAGE_RESIZE','Resize','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2362','MOD_DJC2ITEMS_CONFIG_FLOAT','Alignment / float','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2363','MOD_DJC2ITEMS_CONFIG_FLOAT_DESC','Allows to align module\'s items by adding \'float\' property','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2364','MOD_DJC2ITEMS_LEFT','Left','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2365','MOD_DJC2ITEMS_RIGHT','Right','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2366','MOD_DJC2ITEMS_CENTER','Center','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2367','MOD_DJC2ITEMS_JUSTIFY','Justify','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2368','MOD_DJC2ITEMS_CONFIG_MOD_WIDTH','Product width <small>[px|%]</small>','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2369','MOD_DJC2ITEMS_CONFIG_MOD_HEIGHT','Product height <small>[px|%]</small>','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2370','MOD_DJC2ITEMS_CONFIG_MOD_WIDTH_DESC','Enter numerical, pixel or percent value. Eg. \'120\', \'120px\', \'25%\'. Leave empty to let product\'s container expand automatically.','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2371','MOD_DJC2ITEMS_CONFIG_MOD_HEIGHT_DESC','Enter numerical, pixel or percent value. Eg. \'120\', \'120px\', \'25%\'. Leave empty to let product\'s container expand automatically.','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2372','MOD_DJC2ITEMS_CONFIG_MOD_TEXT_ALIGN','Text align','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.ini'),
('2373','MOD_DJC2ITEMS','DJ-Catalog2 Items','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.sys.ini'),
('2374','MOD_DJC2ITEMS_DESC','DJ-Catalog2 Product Browser','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2items/language/en-GB/en-GB.mod_djc2items.sys.ini'),
('2375','MOD_DJC2PRODUCERS','DJ-Catalog2 Producers','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2producers/language/en-GB/en-GB.mod_djc2producers.ini'),
('2376','MOD_DJC2PRODUCERS_DESC','DJ-Catalog2 Producers Filter','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2producers/language/en-GB/en-GB.mod_djc2producers.ini'),
('2377','MOD_DJC2PRODUCERS_CHOOSE_PRODUCER','Choose manufacturer','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2producers/language/en-GB/en-GB.mod_djc2producers.ini'),
('2378','MOD_DJC2PRODUCERS_ISFILTER','Filtering','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2producers/language/en-GB/en-GB.mod_djc2producers.ini'),
('2379','MOD_DJC2PRODUCERS_ISFILTER_DESC','Selecting the producer may result in displaying items from either current category or all categories.','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2producers/language/en-GB/en-GB.mod_djc2producers.ini'),
('2380','MOD_DJC2PRODUCERS_FILTER_CATEGORY','Current category','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2producers/language/en-GB/en-GB.mod_djc2producers.ini'),
('2381','MOD_DJC2PRODUCERS_SHOW_FROM_ALL','All categories','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2producers/language/en-GB/en-GB.mod_djc2producers.ini'),
('2382','MOD_DJC2PRODUCERS','DJ-Catalog2 Producers','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2producers/language/en-GB/en-GB.mod_djc2producers.sys.ini'),
('2383','MOD_DJC2PRODUCERS_DESC','DJ-Catalog2 Producers Filter','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2producers/language/en-GB/en-GB.mod_djc2producers.sys.ini'),
('2384','MOD_DJC2RELATEDITEMS','DJ-Catalog2 Items','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2relateditems/language/en-GB/en-GB.mod_djc2relateditems.ini'),
('2385','MOD_DJC2RELATEDITEMS_DESC','Descending','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2relateditems/language/en-GB/en-GB.mod_djc2relateditems.ini'),
('2386','MOD_DJC2RELATEDITEMS_READMORE','More...','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2relateditems/language/en-GB/en-GB.mod_djc2relateditems.ini'),
('2387','MOD_DJC2RELATEDITEMS_PRODUCT_NOT_FOUND','Incorrect product page','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2relateditems/language/en-GB/en-GB.mod_djc2relateditems.ini'),
('2388','MOD_DJC2RELATEDITEMS_PRODUCER_NOT_FOUND','Incorrect producer page','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2relateditems/language/en-GB/en-GB.mod_djc2relateditems.ini'),
('2389','MOD_DJC2RELATEDITEMS_PAGE_NOT_FOUND','Page not found','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2relateditems/language/en-GB/en-GB.mod_djc2relateditems.ini'),
('2390','MOD_DJC2RELATEDITEMS_CATEGORY','Category','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2relateditems/language/en-GB/en-GB.mod_djc2relateditems.ini'),
('2391','MOD_DJC2RELATEDITEMS_PRODUCER','Manufacturer','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2relateditems/language/en-GB/en-GB.mod_djc2relateditems.ini'),
('2392','MOD_DJC2RELATEDITEMS_PRICE','Price','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2relateditems/language/en-GB/en-GB.mod_djc2relateditems.ini'),
('2393','MOD_DJC2RELATEDITEMS_NEW_PRICE','New price','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2relateditems/language/en-GB/en-GB.mod_djc2relateditems.ini'),
('2394','MOD_DJC2RELATEDITEMS_OLD_PRICE','Old price','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2relateditems/language/en-GB/en-GB.mod_djc2relateditems.ini'),
('2395','MOD_DJC2RELATEDITEMS_NAME','Name','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2relateditems/language/en-GB/en-GB.mod_djc2relateditems.ini'),
('2396','MOD_DJC2RELATEDITEMS_DESCRIPTION','Description','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2relateditems/language/en-GB/en-GB.mod_djc2relateditems.ini'),
('2397','MOD_DJC2RELATEDITEMS_CATEGORIESSWITCH','Categories','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2relateditems/language/en-GB/en-GB.mod_djc2relateditems.ini'),
('2398','MOD_DJC2RELATEDITEMS_CATEGORIESSWITCH_DESC','Select categories','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2relateditems/language/en-GB/en-GB.mod_djc2relateditems.ini'),
('2399','MOD_DJC2RELATEDITEMS_SELECT_CATEGORY','Choose Category','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2relateditems/language/en-GB/en-GB.mod_djc2relateditems.ini'),
('2400','MOD_DJC2RELATEDITEMS_SELECT_PRODUCER','Choose Manufacturer','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2relateditems/language/en-GB/en-GB.mod_djc2relateditems.ini');
INSERT INTO `#__overrider` VALUES 
('2401','MOD_DJC2RELATEDITEMS_SEARCH_RESTRICTION','Search term must be a minimum of 3 characters and a maximum of 20 characters!','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2relateditems/language/en-GB/en-GB.mod_djc2relateditems.ini'),
('2402','MOD_DJC2RELATEDITEMS_SUBCATEGORIES','Sub Categories','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2relateditems/language/en-GB/en-GB.mod_djc2relateditems.ini'),
('2403','MOD_DJC2RELATEDITEMS_BROWSE','Browse','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2relateditems/language/en-GB/en-GB.mod_djc2relateditems.ini'),
('2404','MOD_DJC2RELATEDITEMS_ORDERBY','Order','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2relateditems/language/en-GB/en-GB.mod_djc2relateditems.ini'),
('2405','MOD_DJC2RELATEDITEMS_FILTER','Filter','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2relateditems/language/en-GB/en-GB.mod_djc2relateditems.ini'),
('2406','MOD_DJC2RELATEDITEMS_SEARCH','Search','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2relateditems/language/en-GB/en-GB.mod_djc2relateditems.ini'),
('2407','MOD_DJC2RELATEDITEMS_GO','Go','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2relateditems/language/en-GB/en-GB.mod_djc2relateditems.ini'),
('2408','MOD_DJC2RELATEDITEMS_RESET','Reset','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2relateditems/language/en-GB/en-GB.mod_djc2relateditems.ini'),
('2409','MOD_DJC2RELATEDITEMS_NO_ITEMS_FOUND','There aren\'t any products matching supplied criteria...','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2relateditems/language/en-GB/en-GB.mod_djc2relateditems.ini'),
('2410','MOD_DJC2RELATEDITEMS_FEATURED_ONLY','Featured only','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2relateditems/language/en-GB/en-GB.mod_djc2relateditems.ini'),
('2411','MOD_DJC2RELATEDITEMS_FEATURED_FIRST','Featured first','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2relateditems/language/en-GB/en-GB.mod_djc2relateditems.ini'),
('2412','MOD_DJC2RELATEDITEMS_SPECIAL_ONLY','On special only','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2relateditems/language/en-GB/en-GB.mod_djc2relateditems.ini'),
('2413','MOD_DJC2RELATEDITEMS_CATEGORY_GROUPPING','Category groupping','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2relateditems/language/en-GB/en-GB.mod_djc2relateditems.ini'),
('2414','MOD_DJC2RELATEDITEMS_ITEM_COLUMNS','Columns','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2relateditems/language/en-GB/en-GB.mod_djc2relateditems.ini'),
('2415','MOD_DJC2RELATEDITEMS_DEFAULTORDER','Default order','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2relateditems/language/en-GB/en-GB.mod_djc2relateditems.ini'),
('2416','MOD_DJC2RELATEDITEMS_ORDERDIR','Order direction','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2relateditems/language/en-GB/en-GB.mod_djc2relateditems.ini'),
('2417','MOD_DJC2RELATEDITEMS_ASC','Ascending','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2relateditems/language/en-GB/en-GB.mod_djc2relateditems.ini'),
('2418','MOD_DJC2RELATEDITEMS_CONFIG_HIDE','Hide','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2relateditems/language/en-GB/en-GB.mod_djc2relateditems.ini'),
('2419','MOD_DJC2RELATEDITEMS_CONFIG_SHOW','Show','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2relateditems/language/en-GB/en-GB.mod_djc2relateditems.ini'),
('2420','MOD_DJC2RELATEDITEMS_CONFIG_YES','Yes','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2relateditems/language/en-GB/en-GB.mod_djc2relateditems.ini'),
('2421','MOD_DJC2RELATEDITEMS_CONFIG_NO','No','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2relateditems/language/en-GB/en-GB.mod_djc2relateditems.ini'),
('2422','MOD_DJC2RELATEDITEMS_CONFIG_SHOW_CATEGORY_NAME','Category name','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2relateditems/language/en-GB/en-GB.mod_djc2relateditems.ini'),
('2423','MOD_DJC2RELATEDITEMS_CONFIG_SHOW_CATEGORY_NAME_DESC','Displaying category name','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2relateditems/language/en-GB/en-GB.mod_djc2relateditems.ini'),
('2424','MOD_DJC2RELATEDITEMS_CONFIG_SHOW_PRODUCER_NAME','Producer name','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2relateditems/language/en-GB/en-GB.mod_djc2relateditems.ini'),
('2425','MOD_DJC2RELATEDITEMS_CONFIG_SHOW_PRODUCER_NAME_DESC','Displaying producer name','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2relateditems/language/en-GB/en-GB.mod_djc2relateditems.ini'),
('2426','MOD_DJC2RELATEDITEMS_CONFIG_TEXT','As text','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2relateditems/language/en-GB/en-GB.mod_djc2relateditems.ini'),
('2427','MOD_DJC2RELATEDITEMS_CONFIG_LINK','As link','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2relateditems/language/en-GB/en-GB.mod_djc2relateditems.ini'),
('2428','MOD_DJC2RELATEDITEMS_CONFIG_PRODUCER_LIGHTBOX','Link to producer lightbox','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2relateditems/language/en-GB/en-GB.mod_djc2relateditems.ini'),
('2429','MOD_DJC2RELATEDITEMS_CONFIG_PRODUCER_LINK','Link to producer description','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2relateditems/language/en-GB/en-GB.mod_djc2relateditems.ini'),
('2430','MOD_DJC2RELATEDITEMS_CONFIG_SHOW_PRICE','Price','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2relateditems/language/en-GB/en-GB.mod_djc2relateditems.ini'),
('2431','MOD_DJC2RELATEDITEMS_CONFIG_SHOW_PRICE_DESC','Show price','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2relateditems/language/en-GB/en-GB.mod_djc2relateditems.ini'),
('2432','MOD_DJC2RELATEDITEMS_CONFIG_PRICE_ALWAYS','Always','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2relateditems/language/en-GB/en-GB.mod_djc2relateditems.ini'),
('2433','MOD_DJC2RELATEDITEMS_CONFIG_PRICE_ONLY_IF_GTT0','Only if &gt; 0','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2relateditems/language/en-GB/en-GB.mod_djc2relateditems.ini'),
('2434','MOD_DJC2RELATEDITEMS_CONFIG_SHOW_ITEM_INTRO_DESCRIPTION','Description','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2relateditems/language/en-GB/en-GB.mod_djc2relateditems.ini'),
('2435','MOD_DJC2RELATEDITEMS_CONFIG_SHOW_ITEM_INTRO_DESCRIPTION_DESC','Display product description','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2relateditems/language/en-GB/en-GB.mod_djc2relateditems.ini'),
('2436','MOD_DJC2RELATEDITEMS_CONFIG_SHOW_ITEM_INTRO_DESCRIPTION_TRUNCATE','Truncate description','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2relateditems/language/en-GB/en-GB.mod_djc2relateditems.ini'),
('2437','MOD_DJC2RELATEDITEMS_CONFIG_SHOW_ITEM_INTRO_DESCRIPTION_TRUNCATE_DESC','<strong>NOTICE!</strong>: turning on this option will remove all HTML tags from description.','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2relateditems/language/en-GB/en-GB.mod_djc2relateditems.ini'),
('2438','MOD_DJC2RELATEDITEMS_CONFIG_SHOW_ITEM_INTRO_DESCRIPTION_LENGTH','Description length','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2relateditems/language/en-GB/en-GB.mod_djc2relateditems.ini'),
('2439','MOD_DJC2RELATEDITEMS_CONFIG_SHOW_ITEM_INTRO_DESCRIPTION_LENGTH_DESC','Product description character limit','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2relateditems/language/en-GB/en-GB.mod_djc2relateditems.ini'),
('2440','MOD_DJC2RELATEDITEMS_CONFIG_SHOW_ITEM_IMAGE_BEHAVIOR','Image on-click behavior','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2relateditems/language/en-GB/en-GB.mod_djc2relateditems.ini'),
('2441','MOD_DJC2RELATEDITEMS_CONFIG_SHOW_ITEM_IMAGE_BEHAVIOR_DESC','You may choose between showing the image in the slimbox or redirecting to item','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2relateditems/language/en-GB/en-GB.mod_djc2relateditems.ini'),
('2442','MOD_DJC2RELATEDITEMS_CONFIG_SHOW_ITEM_READMORE','Readmore','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2relateditems/language/en-GB/en-GB.mod_djc2relateditems.ini'),
('2443','MOD_DJC2RELATEDITEMS_CONFIG_SHOW_ITEM_READMORE_DESC','Display readmore','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2relateditems/language/en-GB/en-GB.mod_djc2relateditems.ini'),
('2444','MOD_DJC2RELATEDITEMS_CONFIG_REDIRECT','Redirect / Browse','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2relateditems/language/en-GB/en-GB.mod_djc2relateditems.ini'),
('2445','MOD_DJC2RELATEDITEMS_CONFIG_LIGHTBOX','Slimbox','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2relateditems/language/en-GB/en-GB.mod_djc2relateditems.ini'),
('2446','COM_DJCATALOG_SELECT_ROOT_CAT','All Categories','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2relateditems/language/en-GB/en-GB.mod_djc2relateditems.ini'),
('2447','MOD_DJC2RELATEDITEMS_RANDOM','Random','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2relateditems/language/en-GB/en-GB.mod_djc2relateditems.ini'),
('2448','MOD_DJC2RELATEDITEMS_LIMIT_DESC','Maximum number of items. 0 = no limit','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2relateditems/language/en-GB/en-GB.mod_djc2relateditems.ini'),
('2449','MOD_DJC2RELATEDITEMS_LIMIT','Count','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2relateditems/language/en-GB/en-GB.mod_djc2relateditems.ini'),
('2450','MOD_DJC2RELATEDITEMS_CATEGORY_PATH','In','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2relateditems/language/en-GB/en-GB.mod_djc2relateditems.ini');
INSERT INTO `#__overrider` VALUES 
('2451','MOD_DJC2_ITEM_READMORE','More...','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2relateditems/language/en-GB/en-GB.mod_djc2relateditems.ini'),
('2452','MOD_DJC2_ITEM_POPULAR_BLOG','Popular!','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2relateditems/language/en-GB/en-GB.mod_djc2relateditems.ini'),
('2453','MOD_DJC2RELATEDITEMS_THUMB_TYPE','Image size','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2relateditems/language/en-GB/en-GB.mod_djc2relateditems.ini'),
('2454','MOD_DJC2RELATEDITEMS_SMALL','Small - (same as in table view)','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2relateditems/language/en-GB/en-GB.mod_djc2relateditems.ini'),
('2455','MOD_DJC2RELATEDITEMS_MEDIUM','Medium - (same as in list view)','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2relateditems/language/en-GB/en-GB.mod_djc2relateditems.ini'),
('2456','MOD_DJC2RELATEDITEMS_LARGE','Large - (main picture in product view)','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2relateditems/language/en-GB/en-GB.mod_djc2relateditems.ini'),
('2457','MOD_DJC2RELATEDITEMS_FRONTPAGE','Frontpage - (same as in frontpage module)','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2relateditems/language/en-GB/en-GB.mod_djc2relateditems.ini'),
('2458','MOD_DJC2RELATEDITEMS_CONFIG_SHOW_IMAGE','Show image','/home/akdevsil/public_html/j3/jm-minima/modules/mod_djc2relateditems/language/en-GB/en-GB.mod_djc2relateditems.ini'),
('2459','MOD_DJC2RELATEDITEMS_IMG_PROCESS','Image process','/home/akdevsil/public_html