<?php
/**
 * @version $Id: djmodules.php 72 2017-08-04 10:30:52Z szymon $
 * @package DJ-MediaTools
 * @copyright Copyright (C) 2017 DJ-Extensions.com LTD, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 * @developer Szymon Woronowski - szymon.woronowski@design-joomla.eu
 *
 * DJ-MediaTools is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * DJ-MediaTools is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with DJ-MediaTools. If not, see <http://www.gnu.org/licenses/>.
 *
 */

defined('_JEXEC') or die();
defined('JPATH_BASE') or die;
defined('DS') or define('DS', DIRECTORY_SEPARATOR);

jimport('joomla.html.html');
jimport('joomla.form.formfield');

class JFormFieldDJModules extends JFormField {
	
	protected $type = 'DJModules';
	
	protected function getInput()
	{
		$attr = 'multiple="true"'; 

		$attr .= $this->element['class'] ? ' class="'.(string) $this->element['class'].'"' : '';
		$attr .= ((string) $this->element['disabled'] == 'true') ? ' disabled="disabled"' : '';
		$attr .= $this->element['size'] ? ' size="'.(int) $this->element['size'].'"' : '';
		
		$db	= JFactory::getDBO();
		$lang = JFactory::getLanguage()->getTag();
		$where = 'language IN (' . $db->quote($lang) . ',' . $db->quote('*') . ')';
		$query = "SELECT * FROM #__modules WHERE client_id=0 AND $where ORDER BY position, ordering";
		
		$db->setQuery($query);
		$modules = $db->loadObjectList();
		
		$options = array();
		
		if(count($modules)) foreach($modules as $module){
			$options[] = JHTML::_('select.option', $module->module.'|'.$module->title, $module->title);
		}
		
		$html = JHTML::_('select.genericlist', $options, $this->name, trim($attr), 'value', 'text', $this->value);
		
		return ($html);
		
	}
}
?>